{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    {
      packages = {
        run-tests = pkgs.writeShellApplication {
          name = "run-tests";
          text = ''
            nix build .#cli-tests -L
          '';
        };
        cli-tests =
          let
            playbook = map (cmd: "${base_cmd} ${cmd} 1>&2") [
              ''config info''
              ''auth login --token "''${TOKEN}"''
              ''user info''
              ''repo create --name "foo" --description "asdf" --private "private" --default-branch "main"''
              ''repo create --name "bar" --description "asdf" --private "public" --default-branch "mega"''
            ];
            conf = "--config /var/lib/forgejo/custom/conf/app.ini";
            scopes = lib.concatStringsSep "," (
              map (x: "write:${x}") [
                "activitypub"
                "issue"
                "notification"
                "organization"
                "package"
                "repository"
                "user"
              ]
            );
            debug = false;
            base_cmd = "${lib.optionalString debug "RUST_LOG=trace "}BERG_BASE_URL=0.0.0.0:3000 BERG_PROTOCOL=http berg";
            exe = "su -- forgejo gitea admin user";
            runtest =
              let
                script_raw =
                  lib.concatStringsSep
                    ''

                    ''
                    (
                      [
                        ''${exe} create --email admin@example.com --username adminx --password pass ${conf}''
                        ''
                          TOKEN=$(${exe} generate-access-token --username adminx --scopes '${scopes}' --raw ${conf})
                          echo "TOKEN: <''${TOKEN}>" >&2
                        ''
                      ]
                      ++ playbook
                      ++ [
                        "|=================|"
                        "| !!! SUCCESS !!! |"
                        "|=================|"
                      ]
                    );
                script = builtins.trace script_raw script_raw;
              in
              pkgs.writeShellScriptBin "runtest" script;
          in
          pkgs.testers.runNixOSTest {
            name = "forgjeo-test";
            nodes = {
              forgejo =
                { pkgs, ... }:
                {
                  environment.systemPackages = [
                    pkgs.curl
                    pkgs.forgejo
                    self'.packages.berg

                    runtest
                  ];

                  services.forgejo = {
                    enable = true;
                    settings = {
                      default = {
                        RUN_MODE = "dev";
                      };
                    };
                  };

                  system.stateVersion = "24.05";
                };
            };

            testScript =
              { nodes, ... }:
              ''
                forgejo.wait_until_succeeds("curl 0.0.0.0:3000")
                forgejo.succeed("runtest")
              '';
          };
      };
    };
}
