// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.25.3
// source: loadtest.proto

package google_pubsub_loadtest

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StartRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GCP project.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The Pub/Sub topic name.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// The time at which the load test should start. If this is less than the current time, we start immediately.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The duration the load test should run for.
	TestDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=test_duration,json=testDuration,proto3" json:"test_duration,omitempty"`
	// Whether to include ids in check responses.
	IncludeIds bool `protobuf:"varint,5,opt,name=include_ids,json=includeIds,proto3" json:"include_ids,omitempty"`
	// Types that are assignable to Options:
	//
	//	*StartRequest_PubsubOptions
	Options isStartRequest_Options `protobuf_oneof:"options"`
	// Types that are assignable to ClientOptions:
	//
	//	*StartRequest_PublisherOptions
	//	*StartRequest_SubscriberOptions
	ClientOptions isStartRequest_ClientOptions `protobuf_oneof:"client_options"`
	// The cpu scaling of the worker.  A multiple of the number of logical processors
	// on the machine.  The number of threads for the worker is calculated by
	// max((numCpus * cpu_scaling), 1) for languages which use thread parallelism.
	// Languages which use process parallelism ignore this setting.
	CpuScaling int32 `protobuf:"varint,10,opt,name=cpu_scaling,json=cpuScaling,proto3" json:"cpu_scaling,omitempty"`
}

func (x *StartRequest) Reset() {
	*x = StartRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartRequest) ProtoMessage() {}

func (x *StartRequest) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartRequest.ProtoReflect.Descriptor instead.
func (*StartRequest) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{0}
}

func (x *StartRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *StartRequest) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *StartRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *StartRequest) GetTestDuration() *durationpb.Duration {
	if x != nil {
		return x.TestDuration
	}
	return nil
}

func (x *StartRequest) GetIncludeIds() bool {
	if x != nil {
		return x.IncludeIds
	}
	return false
}

func (m *StartRequest) GetOptions() isStartRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *StartRequest) GetPubsubOptions() *PubsubOptions {
	if x, ok := x.GetOptions().(*StartRequest_PubsubOptions); ok {
		return x.PubsubOptions
	}
	return nil
}

func (m *StartRequest) GetClientOptions() isStartRequest_ClientOptions {
	if m != nil {
		return m.ClientOptions
	}
	return nil
}

func (x *StartRequest) GetPublisherOptions() *PublisherOptions {
	if x, ok := x.GetClientOptions().(*StartRequest_PublisherOptions); ok {
		return x.PublisherOptions
	}
	return nil
}

func (x *StartRequest) GetSubscriberOptions() *SubscriberOptions {
	if x, ok := x.GetClientOptions().(*StartRequest_SubscriberOptions); ok {
		return x.SubscriberOptions
	}
	return nil
}

func (x *StartRequest) GetCpuScaling() int32 {
	if x != nil {
		return x.CpuScaling
	}
	return 0
}

type isStartRequest_Options interface {
	isStartRequest_Options()
}

type StartRequest_PubsubOptions struct {
	PubsubOptions *PubsubOptions `protobuf:"bytes,6,opt,name=pubsub_options,json=pubsubOptions,proto3,oneof"`
}

func (*StartRequest_PubsubOptions) isStartRequest_Options() {}

type isStartRequest_ClientOptions interface {
	isStartRequest_ClientOptions()
}

type StartRequest_PublisherOptions struct {
	PublisherOptions *PublisherOptions `protobuf:"bytes,8,opt,name=publisher_options,json=publisherOptions,proto3,oneof"`
}

type StartRequest_SubscriberOptions struct {
	SubscriberOptions *SubscriberOptions `protobuf:"bytes,9,opt,name=subscriber_options,json=subscriberOptions,proto3,oneof"`
}

func (*StartRequest_PublisherOptions) isStartRequest_ClientOptions() {}

func (*StartRequest_SubscriberOptions) isStartRequest_ClientOptions() {}

type StartResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StartResponse) Reset() {
	*x = StartResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartResponse) ProtoMessage() {}

func (x *StartResponse) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartResponse.ProtoReflect.Descriptor instead.
func (*StartResponse) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{1}
}

type PublisherOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The max messages-per-second publishing rate.  If unset, no rate limit will
	// be imposed.
	Rate float32 `protobuf:"fixed32,1,opt,name=rate,proto3" json:"rate,omitempty"`
	// The max duration for coalescing a batch of published messages.
	BatchDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=batch_duration,json=batchDuration,proto3" json:"batch_duration,omitempty"`
	// The number of user messages of size message_size to publish together.
	BatchSize int32 `protobuf:"varint,3,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	// The size in bytes of messages to publish
	MessageSize int32 `protobuf:"varint,4,opt,name=message_size,json=messageSize,proto3" json:"message_size,omitempty"`
}

func (x *PublisherOptions) Reset() {
	*x = PublisherOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublisherOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherOptions) ProtoMessage() {}

func (x *PublisherOptions) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherOptions.ProtoReflect.Descriptor instead.
func (*PublisherOptions) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{2}
}

func (x *PublisherOptions) GetRate() float32 {
	if x != nil {
		return x.Rate
	}
	return 0
}

func (x *PublisherOptions) GetBatchDuration() *durationpb.Duration {
	if x != nil {
		return x.BatchDuration
	}
	return nil
}

func (x *PublisherOptions) GetBatchSize() int32 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

func (x *PublisherOptions) GetMessageSize() int32 {
	if x != nil {
		return x.MessageSize
	}
	return 0
}

type SubscriberOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SubscriberOptions) Reset() {
	*x = SubscriberOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscriberOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriberOptions) ProtoMessage() {}

func (x *SubscriberOptions) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriberOptions.ProtoReflect.Descriptor instead.
func (*SubscriberOptions) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{3}
}

type PubsubOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Pub/Sub subscription name
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *PubsubOptions) Reset() {
	*x = PubsubOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubsubOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubOptions) ProtoMessage() {}

func (x *PubsubOptions) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubOptions.ProtoReflect.Descriptor instead.
func (*PubsubOptions) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{4}
}

func (x *PubsubOptions) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

type MessageIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique id of the client that published the message.
	PublisherClientId int64 `protobuf:"varint,1,opt,name=publisher_client_id,json=publisherClientId,proto3" json:"publisher_client_id,omitempty"`
	// Sequence number of the published message with the given publish_client_id.
	SequenceNumber int32 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
}

func (x *MessageIdentifier) Reset() {
	*x = MessageIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageIdentifier) ProtoMessage() {}

func (x *MessageIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageIdentifier.ProtoReflect.Descriptor instead.
func (*MessageIdentifier) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{5}
}

func (x *MessageIdentifier) GetPublisherClientId() int64 {
	if x != nil {
		return x.PublisherClientId
	}
	return 0
}

func (x *MessageIdentifier) GetSequenceNumber() int32 {
	if x != nil {
		return x.SequenceNumber
	}
	return 0
}

// Request a statistics update.
type CheckRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CheckRequest) Reset() {
	*x = CheckRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckRequest) ProtoMessage() {}

func (x *CheckRequest) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckRequest.ProtoReflect.Descriptor instead.
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{6}
}

type CheckResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Histogram of latencies, each one a delta from the previous CheckResponse sent.
	// The bounds of the nth bucket (starting from the 0th bucket) are
	// [1.5^(n-1), 1.5^n) milliseconds.  The lower bound of the 0th bucket is 0 seconds.
	BucketValues []int64 `protobuf:"varint,1,rep,packed,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// The duration from the start of the loadtest to its completion or now if is_finished is false.
	RunningDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=running_duration,json=runningDuration,proto3" json:"running_duration,omitempty"`
	// True if the load test has finished running.
	IsFinished bool `protobuf:"varint,3,opt,name=is_finished,json=isFinished,proto3" json:"is_finished,omitempty"`
	// MessageIdentifiers of all messages since the last Check.
	ReceivedMessages []*MessageIdentifier `protobuf:"bytes,4,rep,name=received_messages,json=receivedMessages,proto3" json:"received_messages,omitempty"`
	// Number of failed messages since the last check.
	Failed int64 `protobuf:"varint,5,opt,name=failed,proto3" json:"failed,omitempty"`
}

func (x *CheckResponse) Reset() {
	*x = CheckResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_loadtest_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckResponse) ProtoMessage() {}

func (x *CheckResponse) ProtoReflect() protoreflect.Message {
	mi := &file_loadtest_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckResponse.ProtoReflect.Descriptor instead.
func (*CheckResponse) Descriptor() ([]byte, []int) {
	return file_loadtest_proto_rawDescGZIP(), []int{7}
}

func (x *CheckResponse) GetBucketValues() []int64 {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *CheckResponse) GetRunningDuration() *durationpb.Duration {
	if x != nil {
		return x.RunningDuration
	}
	return nil
}

func (x *CheckResponse) GetIsFinished() bool {
	if x != nil {
		return x.IsFinished
	}
	return false
}

func (x *CheckResponse) GetReceivedMessages() []*MessageIdentifier {
	if x != nil {
		return x.ReceivedMessages
	}
	return nil
}

func (x *CheckResponse) GetFailed() int64 {
	if x != nil {
		return x.Failed
	}
	return 0
}

var File_loadtest_proto protoreflect.FileDescriptor

var file_loadtest_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9d, 0x04, 0x0a, 0x0c, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0d, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x49, 0x64, 0x73, 0x12, 0x4e, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x6c,
	0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x2e, 0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x10, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5a, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x6c, 0x6f, 0x61, 0x64,
	0x74, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x11, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x70, 0x75, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x63, 0x70, 0x75, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x09, 0x0a, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x0f, 0x0a, 0x0d, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x10, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x72, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x72,
	0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x13, 0x0a, 0x11, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x33, 0x0a, 0x0d,
	0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x22, 0x0a,
	0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6c, 0x0a, 0x11, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22,
	0x0e, 0x0a, 0x0c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22,
	0x8b, 0x02, 0x0a, 0x0d, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x10, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x69, 0x73, 0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x69, 0x73, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x56, 0x0a,
	0x11, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73,
	0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x52, 0x10, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x32, 0xbc, 0x01,
	0x0a, 0x0e, 0x4c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x12, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65,
	0x73, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x05, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2e,
	0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x2e, 0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x3f, 0x5a, 0x3d,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x2f, 0x6c, 0x6f, 0x61, 0x64, 0x74,
	0x65, 0x73, 0x74, 0x2f, 0x70, 0x62, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x74, 0x65, 0x73, 0x74, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_loadtest_proto_rawDescOnce sync.Once
	file_loadtest_proto_rawDescData = file_loadtest_proto_rawDesc
)

func file_loadtest_proto_rawDescGZIP() []byte {
	file_loadtest_proto_rawDescOnce.Do(func() {
		file_loadtest_proto_rawDescData = protoimpl.X.CompressGZIP(file_loadtest_proto_rawDescData)
	})
	return file_loadtest_proto_rawDescData
}

var file_loadtest_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_loadtest_proto_goTypes = []interface{}{
	(*StartRequest)(nil),          // 0: google.pubsub.loadtest.StartRequest
	(*StartResponse)(nil),         // 1: google.pubsub.loadtest.StartResponse
	(*PublisherOptions)(nil),      // 2: google.pubsub.loadtest.PublisherOptions
	(*SubscriberOptions)(nil),     // 3: google.pubsub.loadtest.SubscriberOptions
	(*PubsubOptions)(nil),         // 4: google.pubsub.loadtest.PubsubOptions
	(*MessageIdentifier)(nil),     // 5: google.pubsub.loadtest.MessageIdentifier
	(*CheckRequest)(nil),          // 6: google.pubsub.loadtest.CheckRequest
	(*CheckResponse)(nil),         // 7: google.pubsub.loadtest.CheckResponse
	(*timestamppb.Timestamp)(nil), // 8: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 9: google.protobuf.Duration
}
var file_loadtest_proto_depIdxs = []int32{
	8,  // 0: google.pubsub.loadtest.StartRequest.start_time:type_name -> google.protobuf.Timestamp
	9,  // 1: google.pubsub.loadtest.StartRequest.test_duration:type_name -> google.protobuf.Duration
	4,  // 2: google.pubsub.loadtest.StartRequest.pubsub_options:type_name -> google.pubsub.loadtest.PubsubOptions
	2,  // 3: google.pubsub.loadtest.StartRequest.publisher_options:type_name -> google.pubsub.loadtest.PublisherOptions
	3,  // 4: google.pubsub.loadtest.StartRequest.subscriber_options:type_name -> google.pubsub.loadtest.SubscriberOptions
	9,  // 5: google.pubsub.loadtest.PublisherOptions.batch_duration:type_name -> google.protobuf.Duration
	9,  // 6: google.pubsub.loadtest.CheckResponse.running_duration:type_name -> google.protobuf.Duration
	5,  // 7: google.pubsub.loadtest.CheckResponse.received_messages:type_name -> google.pubsub.loadtest.MessageIdentifier
	0,  // 8: google.pubsub.loadtest.LoadtestWorker.Start:input_type -> google.pubsub.loadtest.StartRequest
	6,  // 9: google.pubsub.loadtest.LoadtestWorker.Check:input_type -> google.pubsub.loadtest.CheckRequest
	1,  // 10: google.pubsub.loadtest.LoadtestWorker.Start:output_type -> google.pubsub.loadtest.StartResponse
	7,  // 11: google.pubsub.loadtest.LoadtestWorker.Check:output_type -> google.pubsub.loadtest.CheckResponse
	10, // [10:12] is the sub-list for method output_type
	8,  // [8:10] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_loadtest_proto_init() }
func file_loadtest_proto_init() {
	if File_loadtest_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_loadtest_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_loadtest_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_loadtest_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublisherOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_loadtest_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscriberOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_loadtest_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubsubOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_loadtest_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_loadtest_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_loadtest_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_loadtest_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*StartRequest_PubsubOptions)(nil),
		(*StartRequest_PublisherOptions)(nil),
		(*StartRequest_SubscriberOptions)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_loadtest_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_loadtest_proto_goTypes,
		DependencyIndexes: file_loadtest_proto_depIdxs,
		MessageInfos:      file_loadtest_proto_msgTypes,
	}.Build()
	File_loadtest_proto = out.File
	file_loadtest_proto_rawDesc = nil
	file_loadtest_proto_goTypes = nil
	file_loadtest_proto_depIdxs = nil
}
