/* $Id: dp_alert.h,v 1.5 2004/02/20 01:59:48 andrewbaker Exp $ */
/*
** Copyright (C) 2001 Martin Roesch <roesch@sourcefire.com>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/
 

#ifndef __DP_ALERT_H__
#define __DP_ALERT_H__

#include "event.h"

#define ALERT_MAGIC  0xDEAD4137   /* dead alert (ok, so it's stupid) */


typedef struct _UnifiedAlertFileHeader
{
    u_int32_t version_major;
    u_int32_t version_minor;
    u_int32_t timezone;
} UnifiedAlertFileHeader;

/* Unified alert message format
 *
 * One per event notification, all the important data for people to know
 */
typedef struct _UnifiedAlertRecord
{
    Event event;
    struct timeval ts;         /* event timestamp */
    u_int32_t sip;             /* src ip */
    u_int32_t dip;             /* dest ip */
    u_int16_t sp;              /* src port */
    u_int16_t dp;              /* dest port */
    u_int32_t protocol;        /* protocol id */
    u_int32_t flags;           /* any other flags (fragmented, etc) */
} UnifiedAlertRecord;

void AlertDpInit();

#endif /* __DP_ALERT_H__ */
