#include "macros.h"

/* swap_bytes assumes that there are 4 bytes per word */

void swap_bytes(char *ptr, int nbytes)
{
    char *ptr2;

    for (ptr2 = ptr+nbytes; ptr < ptr2; ptr += 4)
    {
	SWAP(ptr[0], ptr[3], char);
	SWAP(ptr[1], ptr[2], char);
    }
}

#define  N  1024

void main(int argc, char **argv)
{
    int n;
    char msg[100];
    float x[N];
    FILE *fp_in, *fp_out;

    if (argc != 3)
    {
	sprintf(msg, "correct syntax: %s <input file> <output file>", argv[0]);
	ERROR_AND_EXIT(msg);
    }

    if (OPEN_FOR_READING(fp_in, argv[1]))
    {
	sprintf(msg, "opening '%s' for reading", argv[1]);
	ERROR_AND_EXIT(msg);
    }

    if (OPEN_FOR_WRITING(fp_out, argv[2]))
    {
	sprintf(msg, "opening '%s' for writing", argv[2]);
	ERROR_AND_EXIT(msg);
    }

    while ((n = fread(x, BYTES_PER_WORD, N, fp_in)) > 0)
    {
	swap_bytes((void *) x, BYTES_PER_WORD*n);
	fwrite(x, BYTES_PER_WORD, n, fp_out);
    }
}
