#include "macros.h"

/* swap_bytes assumes that there are 4 bytes per word */

void swap_bytes(char *ptr, int nbytes)
{
    char *ptr2;

    for (ptr2 = ptr+nbytes; ptr < ptr2; ptr += 4)
    {
	SWAP(ptr[0], ptr[3], char);
	SWAP(ptr[1], ptr[2], char);
    }
}

void main(argc, argv)
    int argc;
    char **argv;
{
    char *c, error_msg[100];
    int *y, byte;
    short *s;
    float x;
    FILE *fp;

    if (argc != 2)
    {
        sprintf(error_msg, "correct syntax: %s <file>", argv[0]);
        ERROR_AND_EXIT(error_msg);
    }

    if (OPEN_FOR_READING(fp, argv[1]))
    {
        sprintf(error_msg, "opening '%s' for reading", argv[1]);
        ERROR_AND_EXIT(error_msg);
    }

    c = (char *) &x;
    s = (short *) &x;
    y = (int *) &x;

    printf("Byte to look at (< 0 to stop): ");
    scanf("%d", &byte);

    while (byte >= 0)
    {
	if (fseek(fp, byte, SEEK_SET) == 0)
	{
	    if (fread((void *) &x, BYTES_PER_WORD, 1, fp) == 1)
	    {
		printf("float = %f, int = %d, hex = %x\n", x, *y, *y);
		printf("short = %d, hex = %x, byte = %d\n", *s, *s, *c);
		swap_bytes((char *) &x, BYTES_PER_WORD);
		printf("swapped: float = %f, int = %d, hex = %x\n", x, *y, *y);
		printf("swapped: short = %d, hex = %x, byte = %d\n", *s, *s, *c);
	    }
	    else
	    {
		printf("Error reading\n");
	    }
	}
	else
	{
	    printf("Error seeking\n");
	}

    	printf("Byte to look at (< 0 to stop): ");
    	scanf("%d", &byte);
    }
}
