#include "macros.h"

/* swap_bytes assumes that there are 4 bytes per word */

void swap_bytes(char *ptr, int nbytes)
{
    char *ptr2;

    for (ptr2 = ptr+nbytes; ptr < ptr2; ptr += 4)
    {
	SWAP(ptr[0], ptr[3], char);
	SWAP(ptr[1], ptr[2], char);
    }
}

void main(argc, argv)
    int argc;
    char **argv;
{
    char msg[100];
    int *y, word;
    float x;
    FILE *fp;

    if (argc != 2)
    {
        sprintf(msg, "correct syntax: %s <file>", argv[0]);
        ERROR_AND_EXIT(msg);
    }

    if (OPEN_FOR_BINARY_READING(fp, argv[1]))
    {
        sprintf(msg, "opening '%s' for reading", argv[1]);
        ERROR_AND_EXIT(msg);
    }

    y = (int *) &x;

    printf("Word to look at (< 0 to stop): ");
    scanf("%d", &word);

    while (word >= 0)
    {
	if (fseek(fp, BYTES_PER_WORD*word, SEEK_SET) == 0)
	{
	    if (fread((void *) &x, BYTES_PER_WORD, 1, fp) == 1)
	    {
		printf("float = %f, int = %d, hex = %x\n", x, *y, *y);
		swap_bytes((char *) &x, BYTES_PER_WORD);
		printf("swapped: float = %f, int = %d, hex = %x\n", x, *y, *y);
	    }
	    else
	    {
		printf("Error reading\n");
	    }
	}
	else
	{
	    printf("Error seeking\n");
	}

    	printf("Word to look at (< 0 to stop): ");
    	scanf("%d", &word);
    }
}
