#include "macros.h"

#define N 1024

/* int_words takes floating point data and converts it to integer by rounding */
void int_words(int *ptr, int nwords)
{
    int *ptr2;
    float x;

    for (ptr2 = ptr+nwords; ptr < ptr2; ptr++)
    {
        x = *((float *) ptr);
        *ptr = NEAREST_INTEGER(x);
    }
}

void main(int argc, char **argv)
{
    char msg[100];
    int x[N];
    FILE *fp_in, *fp_out;
    int n;

    if (argc != 3)
    {
	sprintf(msg,
	    "correct syntax: %s <input file> <output file>",
	    argv[0]);
	ERROR_AND_EXIT(msg);
    }

    if (OPEN_FOR_BINARY_READING(fp_in, argv[1]))
    {
	sprintf(msg, "opening '%s' for reading", argv[1]);
	ERROR_AND_EXIT(msg);
    }

    if (OPEN_FOR_WRITING(fp_out, argv[2]))
    {
	sprintf(msg, "opening '%s' for writing", argv[2]);
	ERROR_AND_EXIT(msg);
    }

    while ((n = fread((void *) x, BYTES_PER_WORD, N, fp_in)) > 0)
    {
	int_words(x, n);
        fwrite((void *) x, BYTES_PER_WORD, n, fp_out);
    }
}
