#ifndef _incl_par
#define _incl_par

#include "macros.h"
#include "types.h"

#include "ref.h"

typedef struct
{
    String file;
    int ndim;
    int *npoints;
    int *block_size;
    Ref_info *ref;
    Bool swapped;
    Bool integer;
    Bool blocked;
    int header;
    Bool deflated;
    float level;
    int dir_size;
    int byte_size;
    int param_dim;
    float *params;
}   Par_info;

typedef struct
{
    Bool have_varian;
    int *dim_order;
    int file_header;
    int block_header;
}   Varian_info;

extern Status read_par_file
	(String name, Par_info *par_info, String error_msg);

extern FILE *open_par_file
	(String name, String file, String error_msg);

extern void write_par_comment
	(FILE *fp, String comment);

extern void write_par_info
	(FILE *fp, Par_info *par_info);

extern Status write_par_file
	(String name, Par_info *par_info, String error_msg);

extern void find_block_sizes
	(int ndim, int size_of_block, int *npoints,
			int *block_size, Bool initialized);

extern void set_varian
	();

extern void get_varian
	(Varian_info *varian_info);

#endif /* _incl_par */
