#include "ps_func.h"

#include "list.h"
#include "ps.h"
#include "utility.h"

#define  BOUNDING_BOX_STRING		"%%BoundingBox:"
#define  DOCUMENT_FONT_STRING		"%%DocumentNeededResources: font"
#define  END_HEADER_STRING		"%%EndSetup"
#define  END_BODY_STRING		"PS_end"
#define  START_BORDER_STRING		"% Start PS_border"
#define  END_BORDER_STRING		"% End PS_border"

static List font_list;
static String font_string;

Status init_ps_font(String error_msg)
{
    sprintf(error_msg, "initializing font list");
    CHECK_STATUS(init_list(&font_list));

    return  OK;
}

static Bool cmp_strings(Generic_ptr p1, Generic_ptr p2)
{
    String f1 = (String) p1;
    String f2 = (String) p2;

    return  equal_strings(f1, f2);
}

Status insert_ps_font(String font, String error_msg)
{
    List key_node;
    String name;

    if (find_key(font_list, (Generic_ptr) font, cmp_strings,
							&key_node) == ERROR)
    {
	STRING_MALLOC_COPY(name, font);

	sprintf(error_msg, "inserting font in list");
	CHECK_STATUS(insert_list(&font_list, (Generic_ptr) name));
    }

    return  OK;
}

static void add_font(Generic_ptr p)
{
    String f = (String) p;

    if (*font_string)
	strcat(font_string, " ");

    strcat(font_string, f);

    FREE(f, char);
}

void end_ps_font(String fonts)
{
    font_string = fonts;
    font_string[0] = 0;

    destroy_list(&font_list, add_font);
}

static Status parse_bounding_box(String line, float *x_min, float *y_min,
			float *x_max, float *y_max, String error_msg)
{
    char *ptr;

/*  this was a bug; should not have parenthesis in bounding box  */
/*
    if (!(ptr = strchr(line, '(')))
	RETURN_ERROR_MSG("parsing bounding box");

    ptr++;
*/
/*  make backwards-bug compatible for now */
    if (ptr = strchr(line, '('))
	ptr++;
    else
	ptr = line;

    if (sscanf(ptr, "%f %f %f %f", x_min, y_min, x_max, y_max) != 4)
	RETURN_ERROR_MSG("parsing bounding box");

    if ((*x_max <= *x_min) || (*y_max <= *y_min))
	RETURN_ERROR_MSG("illegal bounding box");

    return  OK;
}

static Status parse_font_string(String line, String error_msg)
{
    char *ptr;

    while (ptr = strtok(line, " \t\n"))
    {
	line = (String) NULL;
	CHECK_STATUS(insert_ps_font(ptr, error_msg));
    }

    return  OK;
}

static Status end_bounding_box(FILE *fp, float *x_min, float *y_min,
			float *x_max, float *y_max, String error_msg)
{
    char *ptr;
    Line line;

    while (fgets(line, LINE_SIZE, fp))
    {
	if (ptr = strstr(line, BOUNDING_BOX_STRING))
	{
	    CHECK_STATUS(parse_bounding_box(ptr + strlen(BOUNDING_BOX_STRING),
				x_min, y_min, x_max, y_max, error_msg));
	    rewind(fp);

	    while (fgets(line, LINE_SIZE, fp))
	    {
		if (strstr(line, BOUNDING_BOX_STRING))
		    break;
	    }

	    return  OK;
	}
    }

    sprintf(error_msg, "cannot find bounding box");

    return  ERROR;
}

Status read_ps_header(FILE *fp, float *x_min, float *y_min,
		float *x_max, float *y_max, String error_msg)
{
    char *ptr;
    Line line;

    while (fgets(line, LINE_SIZE, fp))
    {
	if (ptr = strstr(line, BOUNDING_BOX_STRING))
	{
	    if (parse_bounding_box(ptr + strlen(BOUNDING_BOX_STRING),
			x_min, y_min, x_max, y_max, error_msg) == ERROR)
		CHECK_STATUS(end_bounding_box(fp, x_min, y_min, x_max, y_max, error_msg));
	}
	else if (ptr = strstr(line, DOCUMENT_FONT_STRING))
	{
	    ptr += strlen(DOCUMENT_FONT_STRING);
	    CHECK_STATUS(parse_font_string(ptr, error_msg));
	}
	else if (strstr(line, END_HEADER_STRING))
	{
	    break;
	}
    }

    return  OK;
}

Status copy_ps_body(FILE *fp_in, FILE *fp_out, Bool keep_border,
							String error_msg)
{
    Bool found_end_border;
    Line line;

    while (fgets(line, LINE_SIZE, fp_in))
    {
	if (!keep_border && strstr(line, START_BORDER_STRING))
	{
	    found_end_border = FALSE;
	    while (fgets(line, LINE_SIZE, fp_in))
	    {
		if (strstr(line, END_BORDER_STRING))
		{
		    found_end_border = TRUE;
		    break;
		}
	    }

	    if (!found_end_border)
		RETURN_ERROR_MSG("did not find end of border");
	}
	else if (strstr(line, END_BODY_STRING))
	{
	    break;
	}
	else
	{
	    fputs(line, fp_out);
	}
    }

    return  OK;
}
