#include "color.h"

typedef struct
{
    String name;
    float r, g, b;
}   Color;

Color colors[] =
{
#include "color.txt"
};

#define  NCOLORS  (sizeof(colors) / sizeof(colors[0]))

static int ncolors = NCOLORS;
static String color_names[NCOLORS];

void get_color_rgb(int color, float *r, float *g, float *b)
{
    if (color < ncolors)
    {
	*r = colors[color].r;
	*g = colors[color].g;
	*b = colors[color].b;
    }
    else
    {
	*r = colors[BLACK].r;
	*g = colors[BLACK].g;
	*b = colors[BLACK].b;
    }
}

String get_color_name(int color)
{
    if ((color >= 0) && (color < ncolors))
    {
	return  colors[color].name;
    }
    else
    {
	return  colors[BLACK].name;
    }
}

int get_color_index(String name)
{
    int i;

    for (i = 0; i < ncolors; i++)
    {
	if (!strcmp(name, colors[i].name))
	    return  i;
    }

    return  BLACK;
}

int get_ncolors()
{
    return  ncolors;
}

String *get_color_names()
{
    return  color_names;
}

void initialize_colors()
{
    int i;

    for (i = 0; i < ncolors; i++)
	color_names[i] = colors[i].name;
}
