#include "reduce.h"

#include "command.h"

static int ncodes = 0;
static int npoints[MAX_NCODES];

static void do_reduce(int code, float *data)
{
    int i;

    for (i = 0; i < npoints[code]; i++)
	data[i] = data[2*i];
}

static void do_complexify(int code, float *data)
{
    int i;

    for (i = npoints[code]-2; i >= 0; i -= 2)
    {
	data[i] = data[i/2];
	data[i+1] = 0;
    }
}

Status init_reduce(Generic_ptr *param, String error_msg)
{
    int type, npts;

    if (setup_command(&type, &npts, ncodes, "reduce",
					do_reduce, error_msg) == ERROR)
        return  ERROR;

    if (type != COMPLEX_DATA)
	RETURN_ERROR_MSG("'reduce': must have complex data");

    type = REAL_DATA;
    npts /= 2;

    npoints[ncodes] = npts;

    CHECK_STATUS(end_command(type, npts, "reduce", error_msg));

    ncodes++;

    return  OK;
}

Status init_complexify(Generic_ptr *param, String error_msg)
{
    int type, npts;

    if (setup_command(&type, &npts, ncodes, "complexify",
					do_complexify, error_msg) == ERROR)
        return  ERROR;

    if (type != REAL_DATA)
	RETURN_ERROR_MSG("'complexify': must have real data");

    type = COMPLEX_DATA;
    npts *= 2;

    npoints[ncodes] = npts;

    CHECK_STATUS(end_command(type, npts, "complexify", error_msg));

    ncodes++;

    return  OK;
}
