#ifndef _incl_command
#define _incl_command

#include "macros.h"
#include "types.h"
#include "consts.h"

#include "ref.h"

#define  COMPLEX_DATA   0
#define  REAL_DATA      1

#define  MAX_NCOMMANDS          20

typedef void (*Do_process)(int code, float *data);

typedef struct
{
    int code;
    Do_process do_process;
    char msg[80];
}   Command;

typedef struct
{
    int ndim;
    int dims[MAX_NDIM];
    int npts[MAX_NDIM];
    int npts_max;
    Bool output;
    Bool interlace;
    int ncommands;
    Command commands[MAX_NCOMMANDS];
}   Script;

extern Status setup_command
	(int *type, int *npts, int code, String cmd_msg,
			Do_process do_process, String error_msg);

extern Status end_command
	(int type, int npts, String cmd_msg, String error_msg);

extern void do_nothing
	(int code, float *data);

extern Status read_command_file
	(int *npts, int *max_npts, int *type, String file,
					Script *script, String error_msg);

extern Status read_command_subfile
	(int *npts, int *max_npts, int *type, String file, FILE *fp,
					Script *script, String error_msg);

extern Status skip_command_subfile
	(FILE *fp, String error_msg);

#endif /* _incl_command */
