#include "ticks.h"

#define  MINOR_TICK_SCALE  0.01
#define  MAJOR_TICK_SCALE  0.02

#define  FONT_NAME  "Times-Roman"
#define  FONT_SIZE  12

#define  SMALL_NUM  0.5e-4

static Draw_funcs *draw_funcs;

void find_ticks(String tick_string, int *nticks)
{
    int n;

    n = sscanf(tick_string, "%d %d", nticks, nticks+1);

    if (n == 0)
	nticks[0] = nticks[1] = 0;

    if (n == 1)
	nticks[1] = nticks[0];
}

static void find_tick_info(int nticks, int *n, float lower, float upper, 
						float *step, float *start)
{
    int m = 0, q, l, u, current = 0;
    float d;
    static float multiplier[] = { 0.5, 0.4, 0.5 };
#define  M  ((sizeof multiplier) / (sizeof multiplier[0]))

    if (nticks <= 0)
    {
	*n = 0;
	return;
    }

    if (upper < lower)
	SWAP(upper, lower, float);

    d = log10((double) (upper - lower));
    q = FLOOR(d);
    d = pow(10.0, (double) q);

    while (m < nticks)
    {
	l = CEILING(lower/d);
	u = FLOOR(upper/d);
	m = u - l + 1;
	d *= multiplier[current++ % M];
    }

    d /= multiplier[--current % M];

    *start = l * d;
    *step = d;
    *n = m;
}

static void draw_horizontal_ticks(int nticks, float x, float dx,
							float y0, float y1)
{
    int i;

    for (i = 0; i < nticks; i++)
    {
	(*(draw_funcs->draw_line))(x, y0, x, y1);
	x += dx;
    }
}

static void draw_vertical_ticks(int nticks, float y, float dy,
							float x0, float x1)
{
    int i;

    for (i = 0; i < nticks; i++)
    {
	(*(draw_funcs->draw_line))(x0, y, x1, y);
	y += dy;
    }
}

static void draw_horizontal_texts(int ntexts, float x, float dx, float y,
							float tx, float ty)
{
    int i, q;
    float d;
    Line format, text;

    d = log10((double) (dx + SMALL_NUM));
    q = FLOOR(d);

    if (q > 4)
    {
    	for (i = 0; i < ntexts; i++)
    	{
	    sprintf(text, "%3.1e", x);
	    (*(draw_funcs->draw_text))(text, x, y, tx, ty);
	    x += dx;
    	}
    }
    else if (q >= 0)
    {
    	for (i = 0; i < ntexts; i++)
    	{
	    sprintf(text, "%d", FLOOR(x+SMALL_NUM));
	    (*(draw_funcs->draw_text))(text, x, y, tx, ty);
	    x += dx;
    	}
    }
    else
    {
	sprintf(format, "%%3.%df", -q);

    	for (i = 0; i < ntexts; i++)
    	{
	    sprintf(text, format, x);
	    (*(draw_funcs->draw_text))(text, x, y, tx, ty);
	    x += dx;
    	}
    }
}

static void draw_vertical_texts(int ntexts, float y, float dy, float x,
							float tx, float ty)
{
    int i, q;
    float d;
    Line format, text;

    d = log10((double) (dy + SMALL_NUM));
    q = FLOOR(d);

    if (q > 4)
    {
    	for (i = 0; i < ntexts; i++)
    	{
	    sprintf(text, "%3.1e", y);
	    (*(draw_funcs->draw_text))(text, x, y, tx, ty);
	    y += dy;
    	}
    }
    else if (q >= 0)
    {
    	for (i = 0; i < ntexts; i++)
    	{
	    sprintf(text, "%d", FLOOR(y+SMALL_NUM));
	    (*(draw_funcs->draw_text))(text, x, y, tx, ty);
	    y += dy;
    	}
    }
    else
    {
	sprintf(format, "%%3.%df", -q);

    	for (i = 0; i < ntexts; i++)
    	{
	    sprintf(text, format, y);
	    (*(draw_funcs->draw_text))(text, x, y, tx, ty);
	    y += dy;
    	}
    }
}

void draw_minor_ticks(int *nticks, Bool *done, float *lower, float *upper,
						Draw_funcs *d_funcs)
{
    int n;
    float step, start, length;

    draw_funcs = d_funcs;

    if (done[0])
    {
	length = MINOR_TICK_SCALE * (upper[1]-lower[1]);

	find_tick_info(nticks[0], &n, lower[0], upper[0], &step, &start);
	draw_horizontal_ticks(n, start, step, lower[1], lower[1]+length);
	draw_horizontal_ticks(n, start, step, upper[1]-length, upper[1]);
    }

    if (done[1])
    {
	length = MINOR_TICK_SCALE * (upper[0]-lower[0]);

	find_tick_info(nticks[1], &n, lower[1], upper[1], &step, &start);
	draw_vertical_ticks(n, start, step, lower[0], lower[0]+length);
	draw_vertical_ticks(n, start, step, upper[0]-length, upper[0]);
    }
}

void draw_major_ticks(int *nticks, Bool *done, float *lower, float *upper,
						Draw_funcs *d_funcs)
{
    int n;
    float step, start, length;

    draw_funcs = d_funcs;

    (*(draw_funcs->set_draw_font))(FONT_NAME, FONT_SIZE);

    if (done[0])
    {
	length = MAJOR_TICK_SCALE * (upper[1]-lower[1]);

	find_tick_info(nticks[0], &n, lower[0], upper[0], &step, &start);

	draw_horizontal_ticks(n, start, step, lower[1], lower[1]+length);
	draw_horizontal_ticks(n, start, step, upper[1]-length, upper[1]);

	if (draw_funcs->display_medium == SCREEN_DISPLAY)
	    draw_horizontal_texts(n, start, step, lower[1]+length, 0.6, 0.0);
	else /* draw_funcs->display_medium == PAPER_DISPLAY */
	    draw_horizontal_texts(n, start, step, lower[1], 0.4, 1.0);
    }

    if (done[1])
    {
	length = MAJOR_TICK_SCALE * (upper[0]-lower[0]);

	find_tick_info(nticks[1], &n, lower[1], upper[1], &step, &start);

	draw_vertical_ticks(n, start, step, lower[0], lower[0]+length);
	draw_vertical_ticks(n, start, step, upper[0]-length, upper[0]);

	if (draw_funcs->display_medium == SCREEN_DISPLAY)
	    draw_vertical_texts(n, start, step, lower[0]+length, 0.0, 0.5);
	else /* draw_funcs->display_medium == PAPER_DISPLAY */
	    draw_vertical_texts(n, start, step, lower[0], 1.0, 0.4);
    }
}

static void draw_vertical_grid(int nlines, float x, float dx,
							float y0, float y1)
{
    int i;

    for (i = 0; i < nlines; i++)
    {
	(*(draw_funcs->draw_line))(x, y0, x, y1);
	x += dx;
    }
}

static void draw_horizontal_grid(int nlines, float y, float dy,
							float x0, float x1)
{
    int i;

    for (i = 0; i < nlines; i++)
    {
	(*(draw_funcs->draw_line))(x0, y, x1, y);
	y += dy;
    }
}

void draw_grid(int *nlines, float *lower, float *upper,
						Draw_funcs *d_funcs)
{
    int n;
    float step, start;

    draw_funcs = d_funcs;

    find_tick_info(nlines[0], &n, lower[0], upper[0], &step, &start);
    draw_vertical_grid(n, start, step, lower[1], upper[1]);

    find_tick_info(nlines[1], &n, lower[1], upper[1], &step, &start);
    draw_horizontal_grid(n, start, step, lower[0], upper[0]);
}
