#include "prop_func.h"

#include "color.h"
#include "data.h"
#include "object.h"
#include "param.h"

#define  DEFAULT_SCALE	1.0

static int visibility_type = VISIBILITY_ON;

static int nproperty_sets = 0;

static int object_selected[NDATA_OBJECTS];

#define  SMALL_NUMBER  0.01
#define  SMALLER_NUMBER  1.0e-10

static char e_format[] = "%8.2e";
static char f_format[] = "%3.2f";

static void update_property_data()
{
    if (!(*object_scale))
	sprintf(object_scale, f_format, DEFAULT_SCALE);

    if (*object_visible)
	visibility_type = atoi(object_visible);
}

void remove_property_set_func(int property_set)
{
    if (property_set < nproperty_sets)
	nproperty_sets--;
}

void register_property_set_func(int property_set)
{
    if (property_set >= nproperty_sets)
	nproperty_sets++;
}

static void get_property_info()
{
    int set, object;
    char *fmt;
    Object_property *property;

    for (set = 0; set < nproperty_sets; set++)
    {
	if (data_property_selected(set))
	    break;
    }

    if (set == nproperty_sets)
	return;

    for (object = 0; object < NDATA_OBJECTS; object++)
    {
	if (object_selected[object])
	    break;
    }

    if (object < NDATA_OBJECTS)
    {
	property = get_data_property(set, object);
	strcpy(object_color, get_color_name(property->color));

	if (property->scale < SMALL_NUMBER)
	    fmt = e_format;
	else
	    fmt = f_format;

	sprintf(object_scale, fmt, property->scale);
	sprintf(object_visible, "%d", property->visible);
    }
}

static void set_property_info()
{
    int color, set, object;
    float scale;
    Object_property *property;

    update_property_data();

    color = get_color_index(object_color);
    scale = atof(object_scale);

    if (scale < SMALLER_NUMBER)
    {
	scale = SMALLER_NUMBER;

	sprintf(object_scale, e_format, scale);
    }

    for (set = 0; set < nproperty_sets; set++)
    {
	if (data_property_selected(set))
	{
	    for (object = 0; object < NDATA_OBJECTS; object++)
	    {
		if (object_selected[object])
		{
		    property = get_data_property(set, object);
		    property->color = color;
		    property->scale = scale;
		    property->visible = visibility_type;
		}
	    }
	}
    }
}

static void check_init_object_selected()
{
    int i;
    static Bool first_pass = TRUE;

    if (first_pass)
    {
	for (i = 0; i < NDATA_OBJECTS; i++)
	    object_selected[i] = FALSE;

	first_pass = FALSE;
    }
}

void prop_object_func(int object)
{
    check_init_object_selected();

    object_selected[object] = !object_selected[object];
}

void prop_select_func(int property_set)
{
    toggle_data_property(property_set);
}

void prop_get_func()
{
    check_init_object_selected();

    get_property_info();
}

void prop_set_func()
{
    check_init_object_selected();

    set_property_info();
}

int prop_objects_set()
{
    int i, n = 0;

    check_init_object_selected();

    for (i = (NDATA_OBJECTS-1); i >= 0; i--)
    {
	n *= 2;

	if (object_selected[i])
	    n++;
    }

    return  n;
}
