#include "output_popup.h"

#include "output.hlp"

#include "callback.h"
#include "output.h"
#include "output_func.h"
#include "param.h"
#include "utility.h"
#include "window.h"

#define  OUTPUT_FONT	"Times-Roman"

static Widget output_popup = (Widget) NULL;
static Widget output_form;

static Cursor output_cursor;

static Widget display_boxes[NDISPLAYS];
static Radiobox_item display_items[] =
{
    { "2D display", NO_CALLBACK, NO_DATA, display_boxes + TWO_DISPLAY },
    { "1D display", NO_CALLBACK, NO_DATA, display_boxes + ONE_DISPLAY }
};

static int display_type = TWO_DISPLAY;
static int ndisplay_types = ARRAY_SIZE(display_boxes);

static Widget time_date_boxes[NTIME_DATES];
static Radiobox_item time_date_items[] =
{
    { "time & date", NO_CALLBACK, NO_DATA, time_date_boxes + TIME_DATE },
    { "no time & date", NO_CALLBACK, NO_DATA, time_date_boxes + NO_TIME_DATE }
};

static int time_date_type = TIME_DATE;
static int ntime_date_types = ARRAY_SIZE(time_date_boxes);

static Widget file_name_boxes[NFILE_NAMES];
static Radiobox_item file_name_items[] =
{
    { "file name", NO_CALLBACK, NO_DATA, file_name_boxes + FILE_NAME },
    { "no file name", NO_CALLBACK, NO_DATA, file_name_boxes + NO_FILE_NAME }
};

static int file_name_type = FILE_NAME;
static int nfile_name_types = ARRAY_SIZE(file_name_boxes);

static Widget file_field;
static Widget title_field;
static Widget size_field;

static Textfield_item textfield_items[] =
{
    { "file name: ", output_file, NO_CALLBACK, NO_DATA, &file_field },
    { "title: ", output_title, NO_CALLBACK, NO_DATA, &title_field },
    { "size: ",	 output_size, NO_CALLBACK, NO_DATA, &size_field }
};

static int ntexts = ARRAY_SIZE(textfield_items);

static Widget other_field;

static Textfield_item other_items[] =
{
    { "", other_size, NO_CALLBACK, NO_DATA, &other_field }
};

static int nothers = ARRAY_SIZE(other_items);

static Widget size_mode_boxes[NSIZE_MODES];
static Radiobox_item size_mode_items[NSIZE_MODES];

static int size_mode_type = SIZE_PICTURE;
static int nsize_mode_types = ARRAY_SIZE(size_mode_boxes);

static Widget size_units_boxes[NSIZE_UNITS];
static Radiobox_item size_units_items[NSIZE_UNITS];

static int size_units_type = SIZE_PICTURE;
static int nsize_units_types = ARRAY_SIZE(size_units_boxes);

static Widget paper_size_boxes[NPAPER_SIZES];
static Radiobox_item paper_size_items[NPAPER_SIZES];

static int paper_size_type = A4_PAPER;
static int npaper_size_types = ARRAY_SIZE(paper_size_boxes);

static Widget paper_dirn_boxes[NPAPER_DIRNS];
static Radiobox_item paper_dirn_items[NPAPER_DIRNS];

static int paper_dirn_type = PORTRAIT;
static int npaper_dirn_types = ARRAY_SIZE(paper_dirn_boxes);

static Widget output_color_boxes[NCOLOR_TYPES];
static Radiobox_item output_color_items[NCOLOR_TYPES];

static int output_color_type = BLACK_WHITE;
static int noutput_color_types = ARRAY_SIZE(output_color_boxes);

static Widget output_gl_boxes[NGL_TYPES];
static Radiobox_item output_gl_items[NGL_TYPES];

static int output_gl_type = PS_OUTPUT;
static int noutput_gl_types = ARRAY_SIZE(output_gl_boxes);

void update_output_params()
{
    if (output_popup)
    {
	get_textfields(textfield_items, ntexts);
	get_textfields(other_items, nothers);

	display_type = get_radio_state(display_boxes, ndisplay_types);
	time_date_type = get_radio_state(time_date_boxes, ntime_date_types);
	file_name_type = get_radio_state(file_name_boxes, nfile_name_types);
	size_mode_type = get_radio_state(size_mode_boxes, nsize_mode_types);
	size_units_type = get_radio_state(size_units_boxes, nsize_units_types);
	paper_size_type = get_radio_state(paper_size_boxes, npaper_size_types);
	paper_dirn_type = get_radio_state(paper_dirn_boxes, npaper_dirn_types);
	output_color_type = get_radio_state(output_color_boxes,
							noutput_color_types);
	output_gl_type = get_radio_state(output_gl_boxes, noutput_gl_types);

	sprintf(display_mode, "%d", display_type);
	sprintf(time_date, "%d", time_date_type);
	sprintf(show_name, "%d", file_name_type);
	sprintf(size_mode, "%d", size_mode_type);
	sprintf(size_units, "%d", size_units_type);
	sprintf(paper_size, "%d", paper_size_type);
	sprintf(paper_dirn, "%d", paper_dirn_type);
	sprintf(output_color, "%d", output_color_type);
	sprintf(output_gl, "%d", output_gl_type);
    }
    else
    {
	if (*display_mode)
	    display_type = atoi(display_mode);

	if (*time_date)
	    time_date_type = atoi(time_date);

	if (*show_name)
	    file_name_type = atoi(show_name);

	if (*size_mode)
	    size_mode_type = atoi(size_mode);

	if (*size_units)
	    size_units_type = atoi(size_units);

	if (*paper_size)
	    paper_size_type = atoi(paper_size);

	if (*paper_dirn)
	    paper_dirn_type = atoi(paper_dirn);

	if (*output_color)
	    output_color_type = atoi(output_color);

	if (*output_gl)
	    output_gl_type = atoi(output_gl);
    }
}

#ifdef USE_XPM
static Status output_xpm(String error_msg)
{
    if (display_type == TWO_DISPLAY)
    {
	CHECK_STATUS(do_display_dump(output_file, error_msg));
    }
    else
    {
	CHECK_STATUS(do_slice_dump(output_file, error_msg));
    }

    return  OK;
}
#endif /* USE_XPM */

static Status save_command(String error_msg)
{
#ifdef USE_XPM
    if (output_gl_type == XPM_OUTPUT)
	return  output_xpm(error_msg);
#endif /* USE_XPM */

    CHECK_STATUS(output_save_func(error_msg));

    return  OK;
}

static void save_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_output_params();

    change_cursor(output_cursor);

    if (save_command(error_msg) == ERROR)
    {
	change_cursor(None);

	ERROR_AND_RETURN(error_msg);
    }

    change_cursor(None);
}

Status output_save_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(save_command(error_msg));

    return  OK;
}

static void other_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    set_radio_state(paper_size_boxes, NPAPER_SIZES, OTHER_SIZE);
}

static void create_output_popup(Widget parent)
{
    Widget buttons, radio, radio2, separator, texts;
    Apply_dismiss_help_info adh_info;
    char save_label[] = "save";

    update_output_params();

    initialize_boxes(size_mode_items, size_mode_names,
				size_mode_boxes, nsize_mode_types);

    initialize_boxes(size_units_items, size_units_names,
				size_units_boxes, nsize_units_types);

    initialize_boxes(paper_size_items, paper_size_names,
				paper_size_boxes, npaper_size_types);

    initialize_boxes(paper_dirn_items, paper_dirn_names,
				paper_dirn_boxes, npaper_dirn_types);

    initialize_boxes(output_color_items, output_color_names,
				output_color_boxes, noutput_color_types);

    initialize_boxes(output_gl_items, output_gl_names,
				output_gl_boxes, noutput_gl_types);

    output_popup = create_popup(parent, "Graphical Output");
    CHECK_WIDGET_WARNING(output_popup);

    output_form = create_form(output_popup);
    CHECK_WIDGET_DESTROY_WARNING(output_form, output_popup);

    texts = create_textfields(output_form, textfield_items, ntexts);
    CHECK_WIDGET_DESTROY_WARNING(texts, output_popup);
    attachments(texts, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, size_mode_items, nsize_mode_types,
						size_mode_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    radio2 = create_radiobox(output_form, size_units_items,
			nsize_units_types, size_units_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio2, output_popup);
    attachments(radio2, radio, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, display_items, ndisplay_types,
						display_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, radio2, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    radio2 = create_radiobox(output_form, time_date_items, ntime_date_types,
						time_date_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio2, output_popup);
    attachments(radio2, radio, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    radio = create_radiobox(output_form, file_name_items, nfile_name_types,
						file_name_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, radio2, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, paper_size_items, npaper_size_types,
						paper_size_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    other_items->callback = other_callback;
    texts = create_textfields(output_form, other_items, nothers);
    CHECK_WIDGET_DESTROY_WARNING(texts, output_popup);
    attachments(texts, NO_ATTACH, separator, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, paper_dirn_items, npaper_dirn_types,
						paper_dirn_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, output_color_items,
			noutput_color_types, output_color_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(output_form, output_gl_items,
			noutput_gl_types, output_gl_type, VERTICAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, output_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(output_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, output_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    adh_info.apply_label = save_label;
    adh_info.apply_callback = save_callback;
    adh_info.dismiss_form = output_form;
    adh_info.help_message = output_help;

    buttons = create_apply_dismiss_help(output_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, output_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, NO_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(output_form);

    output_cursor = create_busy_cursor(WIDGET_DISPLAY(output_form));
}

void output_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!output_popup)
	create_output_popup(parent);

    if (output_popup)
	popup(output_form);
}

Status output_popup_command(String value, Generic_ptr data, String error_msg)
{
    output_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
