#include "levels_func.h"

#include "levels.h"
#include "param.h"

static int change_type = CHANGE_MULTIPLY;
static int timer_type = TIMER_ON;

static Levels_info levels_info =
{ CHANGE_MULTIPLY, 0, (float *) NULL, base_level, number_levels,
							change_levels };

static void update_levels_data()
{
    if (*change_mode)
	change_type = atoi(change_mode);

    if (*timer_mode)
	timer_type = atoi(timer_mode);
}

Bool use_timer()
{
    if (timer_type == TIMER_ON)
	return  TRUE;
    else /* timer_type == TIMER_OFF */
	return  FALSE;
}

Status levels_apply_func(int *nlevels, float **levels, String error_msg)
{
    update_levels_data();

    levels_info.change_type = change_type;

    CHECK_STATUS(find_levels(&levels_info, error_msg));

    *nlevels = levels_info.nlevels;
    *levels = levels_info.levels;

    return  OK;
}

Status levels_action_func(int modify_type, String error_msg)
{
    CHECK_STATUS(modify_levels(base_level, level_modifier, modify_type, error_msg));

    return  OK;
}
