#include "extract_popup.h"

#include "extract.hlp"

#include "callback.h"
#include "command.h"
#include "data.h"
#include "data_popup.h"
#include "extract.h"
#include "extract_func.h"
#include "par.h"
#include "param.h"
#include "prop_popup.h"
#include "ref.h"
#include "ref_popup.h"
#include "rowcol_popup.h"
#include "save_popup.h"
#include "script.h"
#include "timer.h"
#include "utility.h"
#include "window.h"

#define  DEFAULT_DATA_SCALE	1.0

static Widget extract_popup = (Widget) NULL;
static Widget extract_form;

static Widget param_field;
static Widget scale_field;
static Widget name_field;
static Widget dirn_field;
static Widget thick_field;
static Widget point_field;
static Widget first_field;
static Widget last_field;
static Widget step_field;
static Widget script_field;

static Textfield_item textfield_items0[] =
{
    { "parameter file: ", param_file, NO_CALLBACK, NO_DATA, &param_field }
};

static int ntexts0 = ARRAY_SIZE(textfield_items0);

static Textfield_item textfield_items1[] =
{
    { "data scale: ", data_scale, NO_CALLBACK, NO_DATA, &scale_field },
    { "name for plane: ", plane_name, NO_CALLBACK, NO_DATA, &name_field },
    { "plane directions: ", plane_dirns, NO_CALLBACK, NO_DATA, &dirn_field },
    { "plane thickness: ", plane_thick, NO_CALLBACK, NO_DATA, &thick_field },
    { "plane point: ", plane_point, NO_CALLBACK, NO_DATA, &point_field }
};

static int ntexts1 = ARRAY_SIZE(textfield_items1);

static Textfield_item textfield_items2[] =
{
    { "first points: ", first_points, NO_CALLBACK, NO_DATA, &first_field },
    { "last points: ", last_points, NO_CALLBACK, NO_DATA, &last_field },
    { "steps through points: ", step_points, NO_CALLBACK, NO_DATA, &step_field }
};

static int ntexts2 = ARRAY_SIZE(textfield_items2);

static Textfield_item textfield_items3[] =
{
    { "script file: ", script_file, NO_CALLBACK, NO_DATA, &script_field }
};

static int ntexts3 = ARRAY_SIZE(textfield_items3);

#define  NSUBSET_BOXES  2

static Widget subset_boxes[NSUBSET_BOXES];
static Radiobox_item subset_items[] =
{
    { "all of plane", NO_CALLBACK, NO_DATA, subset_boxes + SUBSET_ALL },
    { "chosen subset", NO_CALLBACK, NO_DATA, subset_boxes + SUBSET_SOME }
};

static int subset_type = SUBSET_ALL;
static int nsubset_types = ARRAY_SIZE(subset_boxes);

static Widget reference_boxes[NREF_TYPES];
static Radiobox_item reference_items[NREF_TYPES];

static int ref_type = REF_POINTS;
static int nref_types = ARRAY_SIZE(reference_boxes);

void update_extract_params()
{
    if (extract_popup)
    {
    	get_textfields(textfield_items0, ntexts0);
    	get_textfields(textfield_items1, ntexts1);
    	get_textfields(textfield_items2, ntexts2);
    	get_textfields(textfield_items3, ntexts3);
	subset_type = get_radio_state(subset_boxes, nsubset_types);
	ref_type = get_radio_state(reference_boxes, nref_types);

	sprintf(plane_subset, "%d", subset_type);
	sprintf(plane_ref, "%d", ref_type);
    }
    else
    {
	if (*plane_subset)
	    subset_type = atoi(plane_subset);

	if (*plane_ref)
	    ref_type = atoi(plane_ref);

	if (!*data_scale)
	    sprintf(data_scale, "%3.2f", DEFAULT_DATA_SCALE);

    }
}

static Status load_command(String error_msg)
{
    int data_set;
    Status status;
    static Timer_funcs timer_funcs = { start_timer, update_timer, stop_timer };


    if ((status = extract_load_func(&data_set, &timer_funcs, force_question,
							error_msg)) != OK)
    {
	remove_data_set(data_set);

	return  status;
    }

    if (data_set >= 0)
    {
	register_data_set(data_set, plane_name);
	register_property_set(data_set, plane_name);
	register_rowcol_set(data_set, plane_name);
	register_save_set(data_set, plane_name);
    }

    return  OK;
}

static void load_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_extract_params();

    if (load_command(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status extract_load_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(load_command(error_msg));

    return  OK;
}

static void chosen_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    set_radio_state(subset_boxes, NSUBSET_BOXES, SUBSET_SOME);
}

static void select_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    if (select_file(param_file) == YES)
	set_textfields(textfield_items0, ntexts0);
}

static void select2_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    if (select_file(script_file) == YES)
	set_textfields(textfield_items3, ntexts3);
}

static Status run_command(String error_msg)
{
    return run_script_file(script_file, script_action_table, error_msg);

    return  OK;
}

static void run_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_extract_params();

    if (run_command(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status extract_run_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(run_command(error_msg));

    return  OK;
}

static void create_extract_popup(Widget parent)
{
    int i, nbuttons;
    Widget buttons, texts, separator, radio, label;
    Apply_dismiss_help_info adh_info;
    char load_label[] = "load";
    Button_item button_items1[] =
    {
	{ "select file...",	select_callback,	NO_DATA }
    };
    Button_item button_items2[] =
    {
	{ "select script...",	select2_callback,	NO_DATA },
	{ "run script",		run_callback,		NO_DATA }
    };


    update_extract_params();

    extract_popup = create_popup(parent, "Extract Plane");
    CHECK_WIDGET_WARNING(extract_popup);

    extract_form = create_form(extract_popup);
    CHECK_WIDGET_DESTROY_WARNING(extract_form, extract_popup);

    texts = create_textfields(extract_form, textfield_items0, ntexts0);
    CHECK_WIDGET_DESTROY_WARNING(texts, extract_popup);
    attachments(texts, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    nbuttons = ARRAY_SIZE(button_items1);
    buttons = create_horizontal_buttons(extract_form, button_items1, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, extract_popup);
    attachments(buttons, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    texts = create_textfields(extract_form, textfield_items1, ntexts1);
    CHECK_WIDGET_DESTROY_WARNING(texts, extract_popup);
    attachments(texts, buttons, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    set_reference_items((Box_item *) reference_items, reference_boxes);
    radio = create_radiobox(extract_form, reference_items,
					nref_types, ref_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, extract_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(extract_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, extract_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(extract_form, subset_items, nsubset_types,
						subset_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, extract_popup);
    attachments(radio, separator, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(extract_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, extract_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    label = create_label(extract_form, "If chosen subset:");
    CHECK_WIDGET_DESTROY_WARNING(label, extract_popup);
    attachments(label, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    for (i = 0; i < ntexts2; i++)
	textfield_items2[i].callback = chosen_callback;

    texts = create_textfields(extract_form, textfield_items2, ntexts2);
    CHECK_WIDGET_DESTROY_WARNING(texts, extract_popup);
    attachments(texts, label, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(extract_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, extract_popup);
    attachments(separator, texts, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(extract_form, textfield_items3, ntexts3);
    CHECK_WIDGET_DESTROY_WARNING(texts, extract_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    nbuttons = ARRAY_SIZE(button_items2);
    buttons = create_horizontal_buttons(extract_form, button_items2, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, extract_popup);
    attachments(buttons, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(extract_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, extract_popup);
    attachments(separator, buttons, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    adh_info.apply_label = load_label;
    adh_info.apply_callback = load_callback;
    adh_info.dismiss_form = extract_form;
    adh_info.help_message = extract_help;

    buttons = create_apply_dismiss_help(extract_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, extract_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    manage_widget(extract_form);
}

void extract_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!extract_popup)
	create_extract_popup(parent);

    if (extract_popup)
	popup(extract_form);
}

Status extract_popup_command(String value, Generic_ptr data, String error_msg)
{
    extract_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
