#ifndef _incl_data
#define _incl_data

#include "macros.h"
#include "types.h"
#include "consts.h"
#include "defns.h"

#include "object.h"
#include "ref.h"

typedef struct
{
    String name;
    int nwords;
    float largest;
    int on_off;
    Bool property_selected;
    int npoints[DISPLAY_DIM];
    int npoints_orig[DISPLAY_DIM];
    int first[DISPLAY_DIM];
    int step[DISPLAY_DIM];
    float center[DISPLAY_DIM];
    float scale[DISPLAY_DIM];
    float offset[DISPLAY_DIM];
    float extremum;
    float level_scale;
    Ref_info ref[DISPLAY_DIM];
    Object_property property[NDATA_OBJECTS];
    Bool have_param;
    float param;
    float *data;
}   Data_info;

typedef Status (*Data_extremum_func)(int data_set, String set, String name,
			int x, float x_ppm, int y, float y_ppm,
			float extremum, Generic_ptr data, String error_msg);

extern float largest_data_value
	();

extern Object_property *get_data_property
	(int data_set, int object);

extern void set_data_on_off
	(int data_set, int on_off);

extern int get_data_on_off
	(int data_set);

extern void toggle_data_property
	(int data_set);

extern Bool data_property_selected
	(int data_set);

extern Status get_data_row
	(float **data, String error_msg);

extern void initialize_data_row
	(int data_set, int *begin);

extern Status get_data_info
	(int *ndata_sets, Data_info **data_info, String error_msg);

extern Data_info *get_data_set
	(int data_set);

extern Bool data_name_exists
	(String name, int *p_data_set);

extern String get_data_name
	(int data_set);

extern void free_data_set
	(int data_set);

extern Status allocate_data_set
	(int data_set, int nwords, String name, float **p_data);

extern void enrol_data_set
	(int data_set, Size_info *size_info, Ref_info *ref_info,
		Extract_info *extract_info, Param_info *param_info);

extern void print_point_stats
	(int ref_type, float *desired_point, Print_funcs *print_funcs);

extern void print_region_stats
	(int ref_type, float *lower, float *upper,
		Print_funcs *print_funcs, FILE *fp, String file);

extern Status find_data_extremum
	(String set, int ref_type, float *lower, float *upper,
	Data_extremum_func func, Generic_ptr data, String error_msg);

extern void reset_data_scale_offset
	();

extern void set_data_scale_offset
	(int data_set, float *x, float extremum);

#endif /* _incl_data */
