#include "callback.h"

#include "info_popup.h"

#define  APPLY_BUTTON		0
#define  DISMISS_BUTTON		1
#define  HELP_BUTTON		2

#define  NBUTTONS		3

#define  EXTRA_BUTTON		0

void dismiss_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Widget form = (Widget) data;

    popdown(form);
}

void help_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    char *message = (char *) data;
    Line error_msg;

    if (start_info(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);

    print_info(message);

    end_info();
}

Widget create_apply_dismiss_help(Widget parent, Apply_dismiss_help_info *info)
{
    Widget buttons;
    Button_item button_items[NBUTTONS];
    char dismiss_label[] = "dismiss";
    char help_label[] = "help";

    button_items[APPLY_BUTTON].label = info->apply_label;
    button_items[APPLY_BUTTON].callback = info->apply_callback;
    button_items[APPLY_BUTTON].data = info->apply_data;

    button_items[DISMISS_BUTTON].label = dismiss_label;
    button_items[DISMISS_BUTTON].callback = dismiss_callback;
    button_items[DISMISS_BUTTON].data = (Callback_ptr) (info->dismiss_form);

    button_items[HELP_BUTTON].label = help_label;
    button_items[HELP_BUTTON].callback = help_callback;
    button_items[HELP_BUTTON].data = (Callback_ptr) (info->help_message);

    buttons = create_horizontal_buttons(parent, button_items, NBUTTONS);

    return  buttons;
}

Widget create_extra_apply_dismiss_help(Widget parent,
				Extra_apply_dismiss_help_info *info)
{
    Widget buttons;
    Button_item button_items[NBUTTONS+1];
    char dismiss_label[] = "dismiss";
    char help_label[] = "help";

    button_items[EXTRA_BUTTON].label = info->extra_label;
    button_items[EXTRA_BUTTON].callback = info->extra_callback;
    button_items[EXTRA_BUTTON].data = info->extra_data;

    button_items[APPLY_BUTTON+1].label = info->apply_label;
    button_items[APPLY_BUTTON+1].callback = info->apply_callback;
    button_items[APPLY_BUTTON+1].data = info->apply_data;

    button_items[DISMISS_BUTTON+1].label = dismiss_label;
    button_items[DISMISS_BUTTON+1].callback = dismiss_callback;
    button_items[DISMISS_BUTTON+1].data = (Callback_ptr) (info->dismiss_form);

    button_items[HELP_BUTTON+1].label = help_label;
    button_items[HELP_BUTTON+1].callback = help_callback;
    button_items[HELP_BUTTON+1].data = (Callback_ptr) (info->help_message);

    buttons = create_horizontal_buttons(parent, button_items, NBUTTONS+1);

    return  buttons;
}
