#include "phase.h"

#include "parser.h"
#include "script.h"

#define  PHASE_PH0	2
#define  PHASE_PH1	3
#define  PHASE_PIV	4

void calculate_phasing(float piv, float ph0, float ph1, int n,
					float *data_in, float *data_out)
{
    int i, j, k;
    float c, s, d;
    double angle;

    ph0 *= RADIAN_SCALE;
    ph1 *= RADIAN_SCALE / ((float) n);

    for (i = 0, j = 0, k = 1; i < n; i++, j += 2, k += 2)
    {
	angle = ph0 + (i-piv) * ph1;
	c = cos(angle);  s = sin(angle);
	d = c*data_in[j] + s*data_in[k];
	data_out[k] = - s*data_in[j] + c*data_in[k];
	data_out[j] = d;
    }
}

static Status do_phasing(float piv, Parser_store **store, String error_msg)
{
    int n;
    float ph0, ph1, *data_in, *data_out;

    n = store[INPUT_X]->ndata;
    store_int_to_float(store[INPUT_X]);
    data_in = (float *) (store[INPUT_X]->data);

    store_int_to_float(store[PHASE_PH0]);
    ph0 = *((float *) (store[PHASE_PH0]->data));

    store_int_to_float(store[PHASE_PH1]);
    ph1 = *((float *) (store[PHASE_PH1]->data));

    store_type_float(store[OUTPUT_X]);
    CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], n, error_msg));
    data_out = (float *) (store[OUTPUT_X]->data);

    calculate_phasing(piv, ph0, ph1, n, data_in, data_out);

    return  OK;
}

static Status do_phase(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    float piv;

    piv = 0.0;

    return  do_phasing(piv, store, error_msg);
}

static Status do_phase2(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    float piv;

    store_int_to_float(store[PHASE_PIV]);
    piv = *((float *) (store[PHASE_PIV]->data));
    piv -= 1.0;

    return  do_phasing(piv, store, error_msg);
}

Status init_phase(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "phase", do_phase, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_FCA;

    return  OK;
}

Status init_phase2(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "phase2", do_phase2, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_FCA;

    return  OK;
}
