#ifndef _incl_object
#define _incl_object

#include "macros.h"
#include "types.h"
#include "consts.h"

#include "parser.h"

#define  CROSSHAIR_OBJECT	0
#define  X_RULER_OBJECT		1
#define  Y_RULER_OBJECT		2
#define  X_AXIS_OBJECT		3
#define  Y_AXIS_OBJECT		4

#define  NGLOBAL_OBJECTS	5

static String object_labels[] =
    { "crosshair", "x ruler", "y ruler", "x axis", "y axis" };

#define  VISIBILITY_ON		0
#define  VISIBILITY_OFF		1

typedef struct
{
    int visibility;
    int color;
    int style;
    int line_style;
    int point_style;
    float x_scale;
    float x_offset;
    float y_scale;
    float y_offset;
}   Object_property;

typedef struct
{
    int major_ticks[DISPLAY_DIM];
    int minor_ticks[DISPLAY_DIM];
    int visibility[NGLOBAL_OBJECTS];
    int color[NGLOBAL_OBJECTS];
}   Global_info;

extern void get_current_property
	(Bool first_run, Object_property *property);

extern Global_info *get_global_info
	();

extern void initialize_properties
	();

extern void initialize_objects
	();

extern Status init_color
	(int nstore, Parser_store **store, String error_msg);

extern Status init_x_offset
	(int nstore, Parser_store **store, String error_msg);

extern Status init_y_offset
	(int nstore, Parser_store **store, String error_msg);

extern Status init_x_scale
	(int nstore, Parser_store **store, String error_msg);

extern Status init_y_scale
	(int nstore, Parser_store **store, String error_msg);

#endif /* _incl_object */
