#include "maths.h"

#include "parser.h"
#include "script.h"

#define  SETUP_MATHS \
	 {   n = store[INPUT_X]->ndata; \
	     store_int_to_float(store[INPUT_X]); \
	     data_in = (float *) (store[INPUT_X]->data); \
	     store_type_float(store[OUTPUT_X]); \
	     CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], n, error_msg)); \
	     data_out = (float *) (store[OUTPUT_X]->data);   }

#define  MAX_EXP_SIZE  40

#define  CHECK_EXP_SIZE(x) \
	 {   if (x > MAX_EXP_SIZE) \
	     {   sprintf(error_msg, "argument = %2.0f, max allowed = %d", \
				x, MAX_EXP_SIZE);  return  ERROR;   } \
	     if (x < -MAX_EXP_SIZE) \
	     {   sprintf(error_msg, "argument = %2.0f, min allowed = %d", \
				x, -MAX_EXP_SIZE);  return  ERROR;   }   }

static int i;
static int n;
static float *data_in;
static float *data_out;

static Status do_cos(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_MATHS;

    for (i = 0; i < n; i++)
	data_out[i] = cos((double) (data_in[i]));

    return  OK;
}

static Status do_sin(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_MATHS;

    for (i = 0; i < n; i++)
	data_out[i] = sin((double) (data_in[i]));

    return  OK;
}

static Status do_tan(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_MATHS;

    for (i = 0; i < n; i++)
	data_out[i] = tan((double) (data_in[i]));

    return  OK;
}

static Status do_exp(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    float a, b, d;

    SETUP_MATHS;

    if (store[INPUT_X]->data_type & PARSER_REAL)
    {
	for (i = 0; i < n; i++)
	{
	    d = data_in[i];
	    CHECK_EXP_SIZE(d);

	    data_out[i] = exp((double) d);
	}
    }
    else
    {
	n *= 2;
	for (i = 0; i < n; i += 2)
	{
	    a = data_in[i];
	    b = data_in[i+1];
	    CHECK_EXP_SIZE(a);
	    a = exp((double) a);

	    data_out[i] = a * cos(b);
	    data_out[i+1] = a * sin(b);
	}
    }

    return  OK;
}

Status init_cos(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "cos", do_cos, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}

Status init_sin(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "sin", do_sin, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}

Status init_tan(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "tan", do_tan, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}

Status init_exp(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "exp", do_exp ,error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}
