#ifndef _incl_display
#define _incl_display

#include "widget.h"

extern void clear_region
	(Display *display, Drawable drawable, GC gc,
					int x, int y, int width, int height);

extern void copy_region
	(Display *display, Drawable src, Drawable dest, GC gc,
	int src_x, int src_y, int width, int height, int dest_x, int dest_y);

extern void copy_plane
	(Display *display, Drawable src, Drawable dest, GC gc,
	int src_x, int src_y, int width, int height, int dest_x, int dest_y);

extern GC create_gc
	(Display *display, Drawable drawable);

extern void free_gc
	(Display *display, GC gc);

extern void free_pixmap
	(Display *display, Pixmap pixmap);

extern Pixmap create_pixmap
	(Display *display, Window window, int width, int height, int depth);

extern void display_line
	(Display *display, Drawable drawable, GC gc,
					int x1, int y1, int x2, int y2);

extern void display_center_text
	(Display *display, Drawable drawable, GC gc, int x, int y, String text);

extern void display_text
	(Display *display, Drawable drawable, GC gc, int x, int y,
					float a, float b, String text);

extern void display_rectangle
	(Display *display, Drawable drawable, GC gc,
					int x1, int y1, int x2, int y2);

extern void display_circle
	(Display *display, Drawable drawable, GC gc, int x, int y, int r);

extern void set_gc_function
	(Display *display, GC gc, int function);

extern void set_gc_color
	(Display *display, GC gc, int color);

extern void set_gc_white
	(Display *display, GC gc);

extern void set_gc_black
	(Display *display, GC gc);

extern void set_gc_dash
	(Display *display, GC gc, int ndashes, char *dash_list);

extern void free_pixels
	();

extern void initialize_display
	(Display *display);

extern void initialize_font
	(Display *display);

#endif /* _incl_display */
