#include "data_popup.h"

#include "data.hlp"

#include "callback.h"
#include "data.h"
#include "display_popup.h"
#include "object.h"
#include "window.h"

#define  VISIBLE_ITEMS  7

static Widget data_popup = (Widget) NULL;
static Widget data_form;
static Widget data_list;

static int ndata_sets = 0;

static int nselected = 0;
static int *selected;

void update_data_params()
{
    ndata_sets = get_ndata_sets();
}

static void initial_selection()
{
    int i, visibility;

    for (i = 0; i < ndata_sets; i++)
    {
	visibility = get_data_visibility(i);

	if (visibility == VISIBILITY_ON)
	    select_from_list(data_list, i+1, FALSE);
    }

}

static Bool find_selected()
{
    if (!data_list)
	return  FALSE;

    return  selection_from_list(data_list, &selected, &nselected);
}

static void free_selected()
{
    FREE(selected, int);
    nselected = 0;
}

static void cycle_selected(int cycle)
{
    int i, j;
    Line error_msg;

    if (ndata_sets == 0)
	return;

    for (i = 0; i < nselected; i++)
    {
	j = selected[i] - 1;
	deselect_from_list(data_list, j+1);
	set_data_visibility(j, VISIBILITY_OFF);
    }

    for (i = 0; i < nselected; i++)
    {
	j = (selected[i] - 1 + ndata_sets + cycle) % ndata_sets;
	select_from_list(data_list, j+1, FALSE);
	set_data_visibility(j, VISIBILITY_ON);
    }

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

static void next_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    if (!find_selected())
	return;

    cycle_selected(1);
    free_selected();
}

static void previous_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    if (!find_selected())
	return;

    cycle_selected(-1);
    free_selected();
}

static void select_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int data_set, visibility;

    data_set = list_position(cbs);
    visibility = get_data_visibility(data_set);

    if (visibility == VISIBILITY_ON)
	set_data_visibility(data_set, VISIBILITY_OFF);
    else
	set_data_visibility(data_set, VISIBILITY_ON);
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

static void all_on_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
/*  this routine is slightly inefficient but should not matter  */

    int i, j;
    Line error_msg;

    if (find_selected())
    {
	for (i = 0; i < nselected; i++)
	{
	    j = selected[i] - 1;
	    deselect_from_list(data_list, j+1);
	}

	free_selected();
    }

    for (i = 0; i < ndata_sets; i++)
    {
	select_from_list(data_list, i+1, FALSE);
	set_data_visibility(i, VISIBILITY_ON);
    }

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

static String data_string_func(int n, Generic_ptr data)
{
    return  get_data_name(n);
}

static Widget create_data_list_form(Widget parent)
{
    Scrolled_list_info data_list_info;
    Widget label, buttons, form;
    static Button_item button_items[] =
    {
	{ "next",	next_callback,		NO_DATA },
	{ "previous",	previous_callback,	NO_DATA }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    form = create_form(parent);
    CHECK_WIDGET(form);

    label = create_label(form, "data sets:");
    CHECK_WIDGET_DESTROY(label, form);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    buttons = create_vertical_buttons(form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY(buttons, form);
    attachments(buttons, label, NO_ATTACH, FORM_ATTACH, NO_ATTACH);
    offsets(buttons, 2*UNIT_OFFSET, NO_OFFSET, 2*UNIT_OFFSET, NO_OFFSET);

    data_list_info.selection_policy = MULTIPLE_SELECT;
    data_list_info.nitems = ndata_sets;
    data_list_info.func = data_string_func;
    data_list_info.nvisible_items = VISIBLE_ITEMS;
    data_list_info.callback = select_callback;

    data_list = create_scrolled_list(form, &data_list_info);
    CHECK_WIDGET_DESTROY(data_list, form);
    attachments(WIDGET_PARENT(data_list), label, FORM_ATTACH, buttons,
								FORM_ATTACH);
    offsets(WIDGET_PARENT(data_list),
			UNIT_OFFSET, UNIT_OFFSET, 2*UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(form);

    return  form;
}

static void create_data_popup(Widget parent)
{
    Widget buttons, separator, form;
    static Button_item button_items[] =
    {
	{ "apply",	apply_callback,		NO_DATA },
	{ "all on",	all_on_callback,	NO_DATA },
#define  DISMISS_BUTTON  2
	{ "dismiss",	dismiss_callback,	NO_DATA },
	{ "help",	help_callback,		(Callback_ptr) data_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    update_data_params();

    data_popup = create_popup(parent, "Data Sets");
    CHECK_WIDGET_WARNING(data_popup);

    data_form = create_form(data_popup);
    CHECK_WIDGET_DESTROY_WARNING(data_form, data_popup);

    form = create_data_list_form(data_form);
    CHECK_WIDGET_DESTROY_WARNING(form, data_popup);

    separator = create_separator(data_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, data_popup);

    button_items[DISMISS_BUTTON].data = (Callback_ptr) data_form;
    buttons = create_horizontal_buttons(data_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, data_popup);

    attachments(buttons, NO_ATTACH, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    attachments(separator, NO_ATTACH, buttons, FORM_ATTACH, FORM_ATTACH);
    attachments(form, FORM_ATTACH, separator, FORM_ATTACH, FORM_ATTACH);

    offsets(buttons, UNIT_OFFSET, NO_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(data_form);

    initial_selection();
}

void data_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!data_popup)
	create_data_popup(parent);

    if (data_popup)
	popup(data_form);
}
