#include "button.h"

#include "parser.h"
#include "script.h"

#define  PARSER_BUTTON		(1 << 9)

#define  NBUTTONS_ALLOC		20

#define  BUTTON_VALUE		1
#define  BUTTON_LABEL		2

#define  BUTTON_ARGS		3

typedef struct
{
    int command;
    Parser_store *store[BUTTON_ARGS];
}   Button;

static int nbuttons = 0;
static int nbuttons_alloc = 0;
static Button *buttons;

static void free_button_memory()
{
    if (nbuttons_alloc > 0)
    {
	FREE(buttons, Button);
	nbuttons = nbuttons_alloc = 0;
    }
}

static Status alloc_button_memory(String error_msg)
{
    int n;

    if (nbuttons_alloc == 0)
    {
	sprintf(error_msg, "allocating button memory");

	n = NBUTTONS_ALLOC;
	MALLOC(buttons, Button, n);
	nbuttons_alloc = n;
    }
    else
    {
	sprintf(error_msg, "reallocating button memory");

	n = nbuttons_alloc + NBUTTONS_ALLOC;
	REALLOC(buttons, Button, n);
	nbuttons_alloc = n;
    }

    return  OK;
}

static void find_button(int command, Generic_ptr data)
{
    int i;

    for (i = 0; i < nbuttons; i++)
	if (((buttons[i].store[OUTPUT_X])->data == data) &&
						(buttons[i].command == -1))
	    buttons[i].command = command;
}

void check_for_button(int command, int nstore, Parser_store **store)
{
    int i;

    for (i = 1; i < nstore; i++)
	if (store[i] && (store[i]->data_type & PARSER_BUTTON))
	    find_button(command, store[i]->data);
}

int change_button(int button, int value)
{
    int *p;
    Button *b;

    b = buttons + button;
    p = (int *) (b->store[OUTPUT_X]->data);
    *p = value;
    store_type_int(b->store[OUTPUT_X]);

    return  (b->command);
}

static Status do_button(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int x, *p;

    if (!first_run)
	return  OK;

    store_float_to_int(store[BUTTON_VALUE]);
    x = *((int *) (store[BUTTON_VALUE]->data));

    store_type_int(store[OUTPUT_X]);
    CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], 1, error_msg));
    p = (int *) (store[OUTPUT_X]->data);

    *p = x;

    return  OK;
}

Status init_button(int nstore, Parser_store **store, String error_msg)
{
    if (nbuttons == nbuttons_alloc)
	CHECK_STATUS(alloc_button_memory(error_msg));

    if (setup_command(nstore, store, "button", do_button, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_IRS | PARSER_BUTTON;

    buttons[nbuttons].command = -1;
    COPY_VECTOR(buttons[nbuttons].store, store, nstore);

    nbuttons++;

    return  OK;
}

int number_buttons()
{
    return  nbuttons;
}

String button_label(int button)
{
    return  (String) (buttons[button].store[BUTTON_LABEL]->data);
}

int button_default(int button)
{
    int value;

    value = *((int *) (buttons[button].store[BUTTON_VALUE]->data));

    return  value;
}
