#include "peak_find.h"

#include "data.h"
#include "find.h"
#include "ref.h"
#include "script_find.h"

#define  MEGAWORD		(1024 * 1024)
#define  DEFAULT_STORE		(2 * MEGAWORD)

#define  NUMBER_TYPE_STRING	"N"

static void print_peak(int ndim, int *npoints, FILE *fp, Bool parabolic,
					Ref_info *ref_info, Find_info *info)
{
    int i;
    float p, ppm;

    fprintf(fp, "%1.0f", info->value);

    for (i = 0; i < ndim; i++)
    {
	ppm = p = info->center[i] + 1;
	convert_from_point(REF_PPM, npoints[i], ref_info+i, &ppm);

	if (parabolic)
	    fprintf(fp, "\t%2.1f\t%4.3f", p, ppm);
	else
	    fprintf(fp, "\t%1.0f\t%4.3f", p, ppm);
    }

    if (parabolic)
	fprintf(fp, "\t%2.1e", info->magnitude);

    fprintf(fp, "\n");
}

static void output_peaks(int ndim, int *npoints, FILE *fp, Bool parabolic,
			Ref_info *ref_info, int nfind, Find_info **find_info)
{
    int i;

    fprintf(fp, "extr");
    for (i = 0; i < ndim; i++)
	fprintf(fp, "\tpnt%d\tppm%d", i+1, i+1);

    if (parabolic)
	fprintf(fp, "\tmagn");

    fprintf(fp, "\n");

    for (i = 0; i < 2*ndim+1; i++)
    {
	if (i > 0)
	    fprintf(fp, "\t");

	fprintf(fp, NUMBER_TYPE_STRING);
    }

    if (parabolic)
    {
	fprintf(fp, "\t");
	fprintf(fp, NUMBER_TYPE_STRING);
    }

    fprintf(fp, "\n");

    for (i = 0; i < nfind; i++)
	print_peak(ndim, npoints, fp, parabolic, ref_info, find_info[i]);
}

void main(int argc, char **argv)
{
    int nstore, nfind;
    String script_file;
    Line error_msg;
    Size_info size_info;
    Ref_info *ref_info;
    File_info file_info;
    Find_param find_param;
    Find_info **find_info;

    printf(product);

    if (help_request(argc, argv, help_table))
	exit (0);

    if ((argc != 2) && (argc != 3))
    {
	sprintf(error_msg, "correct usage: %s", argv[0]);
	strcat(error_msg, " [<memory in Mwords>] <script file>");
	ERROR_AND_EXIT(error_msg);
    }

    if (argc == 3)
	nstore = MAX(1, atoi(argv[1])) * MEGAWORD;
    else
	nstore = DEFAULT_STORE;

    script_file = argv[argc-1];

    if (read_script_file(script_file, &size_info, &ref_info,
				&file_info, &find_param, error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    if (OPEN_FOR_BINARY_READING(file_info.file_data_in, file_info.input_data_file))
    {
	sprintf(error_msg, "opening \"%s\" for reading",
						file_info.input_data_file);
	ERROR_AND_EXIT(error_msg);
    }

    if (OPEN_FOR_WRITING(file_info.file_peak_out, file_info.output_peak_file))
    {
	sprintf(error_msg, "opening \"%s\" for writing",
						file_info.output_peak_file);
	ERROR_AND_EXIT(error_msg);
    }

    if (initialize_data(nstore, &size_info, &file_info, error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    if (find_peaks(&size_info, ref_info, &find_param, &nfind, &find_info,
							error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    output_peaks(size_info.ndim, size_info.npoints, file_info.file_peak_out,
			find_param.parabolic, ref_info, nfind, find_info);

    exit(0);
}
