#ifndef _incl_defns
#define _incl_defns

#include "command.h"

typedef struct
{
    int ndim;
    int *block_size;
    int *npoints;
}   Size_info;

typedef struct
{
    String input_data_file;
    String input_peak_file;
    String output_peak_file;
    String output_ansig_file;
    String output_ideal_file;
    String output_rest_file;
    String par_ideal_file;
    String par_rest_file;
    FILE *file_data_in;
    FILE *file_peak_in;
    FILE *file_peak_out;
    FILE *file_ansig_out;
    FILE *file_ideal_out;
    FILE *file_rest_out;
    Bool swapped;
    Bool integer;
    Bool blocked;
    int header;
    Bool deflated;
    int dir_size;
    int byte_size;
}   File_info;

/*  diagonal exclusion condition  */

typedef struct
{
    int dim1;		/* dim 1 */
    int dim2;		/* dim 2 */
    float delta;	/* amount by which dim 1 and 2 must differ in ppm */
}   Exclude;

typedef struct
{
    Bool have_high;
    Bool have_low;
    float high;
    float low;
    Bool nonadjacent;
    Bool parabolic;
    int *first;
    int *last;
    int *buffer;
    Bool *periodic;
    int nexclude;
    Exclude *exclude;
}   Find_param;

typedef struct
{
    float value;
    float magnitude;	/* for parabolic fit */
    int *position;
    float *center;	/* for parabolic fit */
}   Find_info;

typedef struct
{
    float chisq;
    Bool subtract;
    Bool group;
    float level;
    int nfitted;
    int nparams;
    int *dim_fitted;
    Script *script;
    int *npts;
    int *width;
    Bool *complex;
    float *freq_a;
    float *freq_b;
    Bool *periodic;
    int *first;
    int *last;
    Bool *fixed_phase;
    float *phase;
    Bool *fixed_decay;
    float *decay;
}   Fit_param;

typedef struct
{
    float magnitude;
    float chisq;
    float *phase;
    float *decay;
    float *center;
    float **fit;
}   Fit_peak;

typedef struct
{
    int n;
    Fit_peak *peak;
    Find_info before;
    Find_info after;
}   Fit_info;

typedef struct
{
    int ngroups;
    int group_max;
    int *upper;
}   Group_info;

/*  next two structures just for deflation purposes  */

typedef struct
{
    int nstore;
    int dir_size;
    float *store;
    int *directory;
}   Store_info;

typedef struct
{
    float level;
    int nblocks;
}   Deflate_info;

#endif /* _incl_defns */
