#include "command.h"

#include "parse.h"

#include "script_command.h"

static int data_type;
static int npoints;
static int max_npoints;
static int ncommands;
static Command *commands;

static String command_file;

Status setup_command(int *type, int *npts, int code, String cmd_msg,
				Do_process do_process, String error_msg)
{
    if (do_process)
    {
	if (ncommands >= MAX_NCOMMANDS)
	{
	    sprintf(error_msg, "too many commands in \"%s\", max allowed = %d",
						command_file, MAX_NCOMMANDS);
	    return  ERROR;
	}

	if (code >= MAX_NCODES)
	{
	    sprintf(error_msg, "too many '%s', max total allowed = %d",
						cmd_msg, MAX_NCODES);
	    return  ERROR;
	}

	commands[ncommands].code = code;
	commands[ncommands].do_process = do_process;
	strcpy(commands[ncommands].msg, cmd_msg);

	ncommands++;
    }

    *type = data_type;
    *npts = npoints;

    return  OK;
}

static Status check_validity(String cmd_msg, String error_msg)
{
    if (npoints < 1)
    {
	sprintf(error_msg, "'%s': number of points = %d", cmd_msg, npoints);
	return  ERROR;
    }

    if ((data_type == COMPLEX_DATA) && (npoints % 2))
    {
	sprintf(error_msg,
		"'%s': complex data but (odd) number of points = %d",
							cmd_msg, npoints);
	return  ERROR;
    }

    return  OK;
}

Status end_command(int type, int npts, String cmd_msg, String error_msg)
{
    Line msg;

    data_type = type;
    npoints = npts;
    max_npoints = MAX(max_npoints, npts);

    sprintf(msg, "%s: at end", cmd_msg);
    CHECK_STATUS(check_validity(msg, error_msg));

    return  OK;
}

void do_nothing(int code, float *data)
{
}

static Status start_command_file(int *npts, int *type, String file,
					Script *script, String error_msg)
{
    max_npoints = npoints = *npts;
    data_type = *type;

    CHECK_STATUS(check_validity("at beginning", error_msg));

    command_file = file;
    ncommands = 0;
    commands = script->commands;

    return  OK;
}

Status end_command_file(int *npts, int *max_npts, int *type, Script *script)
{
    *npts = npoints;
    *max_npts = max_npoints;
    *type = data_type;

    script->ncommands = ncommands;

    return  OK;
}

Status read_command_file(int *npts, int *max_npts, int *type,
			String file, Script *script, String error_msg)
{
    CHECK_STATUS(start_command_file(npts, type, file, script, error_msg));

    if (parse_file(command_file, command_parse_table, TRUE, error_msg) == ERROR)
	return  ERROR;

    end_command_file(npts, max_npts, type, script);

    return  OK;
}

Status read_command_subfile(int *npts, int *max_npts, int *type,
		String file, FILE *fp, Script *script, String error_msg)
{
    CHECK_STATUS(start_command_file(npts, type, file, script, error_msg));

    if (parse_subfile(fp, command_parse_table, TRUE, "end_script",
							error_msg) == ERROR)
	return  ERROR;

    end_command_file(npts, max_npts, type, script);

    return  OK;
}

Status skip_command_subfile(FILE *fp, String error_msg)
{
    CHECK_STATUS(skip_parse_subfile(fp, "end_script", error_msg));

    return  OK;
}
