#include "line_fit.h"

#include "gamma.h"

void line_fit(int n, float *x, float *y, float *sigma, float *yfit,
		float *p_a, float *p_b, float *p_std_a, float *p_std_b,
		float *corr_ab, float *goodness)
{
    int i;
    float *t = yfit, a, b, d, s, sx, sy, stt, sig2, std_a, std_b, chi2;

    if (n < 2)
	return;

    if (sigma)
    {
	for (i = 0; i < n; i++)
	{
	    sig2 = sigma[i] * sigma[i];
	    s += 1.0 / sig2;
	    sx += x[i] / sig2;
	    sy += y[i] / sig2;
	}
    } 
    else
    {
	s = n;

	for (i = 0; i < n; i++)
	{
	    sx += x[i];
	    sy += y[i];
	}
    }
/*
printf("sx = %f, sy = %f\n", sx, sy);
*/

    b = 0;

    for (i = 0; i < n; i++)
    {
	t[i] = x[i] - sx / s;

	if (sigma)
	    t[i] /= sigma[i];

	d = t[i] * y[i];

	if (sigma)
	    d /= sigma[i];

	b += d;
    }

    INNER_PRODUCT(stt, t, t, n);

    b /= stt;
    a = (sy - b * sx) / s;

    chi2 = 0;
    for (i = 0; i < n; i++)
    {
	yfit[i] = a + b * x[i];
	d = y[i] - yfit[i];

	if (sigma)
	    d /= sigma[i];

	chi2 += d * d;
    }

    std_a = (1.0 + sx*sx/(s*stt)) / s;
    std_b = 1.0 / stt;

    if (!sigma && (n > 2))
    {
	d = chi2 / (n - 2);
	std_a *= d;
	std_b *= d;
    }

    std_a = (float) sqrt((double) std_a);
    std_b = (float) sqrt((double) std_b);
printf("\n");

    *p_a = a;
    *p_b = b;
    *p_std_a = std_a;
    *p_std_b = std_b;

/*
printf("yfit[0] = %f, sx = %f, sigma = %d\n", yfit[0], sx, sigma);
*/
    *corr_ab = - sx / (s * stt * std_a * std_b);

    if (sigma)
	*goodness = complement_incomplete_gamma((double) (n-2)/2,
						(double) chi2/2);
    else
	*goodness = chi2;
}
