#include "complex.h"

float complex_abs(Complex x)
{
    float a = (float) sqrt((double) (x.r*x.r + x.i*x.i));

    return  a;
}

float complex_abs_p(Complex *x)
{
    float a = (float) sqrt((double) (x->r*x->r + x->i*x->i));

    return  a;
}

void complex_sqrt(Complex x, Complex *x_sqrt)
{
    float a = x.r, b = x.i;
    float c = sqrt((double) ((a + sqrt((double) (a*a + b*b)))/2));
    float d = sqrt((double) (c * c - a));

    /* sqrt lies in right half plane */

    x_sqrt->r = c;
    x_sqrt->i = d;
}

void complex_sqrt_p(Complex *x, Complex *x_sqrt)
{
    float a = x->r, b = x->i;
    float c = sqrt((double) ((a + sqrt((double) (a*a + b*b)))/2));
    float d = sqrt((double) (c * c - a));

    /* sqrt lies in right half plane */

    x_sqrt->r = c;
    x_sqrt->i = d;
}

/* x1 = x2 / x3 */
void complex_divide(Complex *x1, Complex x2, Complex x3)
{
    float denom = x3.r*x3.r + x3.i*x3.i;
    float a = (x2.r*x3.r + x2.i*x3.i) / denom;
    float b = (x2.i*x3.r - x2.r*x3.i) / denom;

    x1->r = a;
    x1->i = b;
}

/* x1 = x2 / x3 */
void complex_divide_p(Complex *x1, Complex *x2, Complex *x3)
{
    float denom = x3->r*x3->r + x3->i*x3->i;
    float a = (x2->r*x3->r + x2->i*x3->i) / denom;
    float b = (x2->i*x3->r - x2->r*x3->i) / denom;

    x1->r = a;
    x1->i = b;
}

/* x1 = x2 / x3 */
void complex_divide_vec(Complex *x1, Complex *x2, Complex *x3, int n)
{
    int i;

    for (i = 0; i < n; i++)
	complex_divide_p(x1 + i, x2 + i, x3 + i);
}

