#include "help.h"

#define  LINES_PER_PAGE  10

static String search_table(String word, Help_index *help_table)
{
    String match;

    for (match = help_table->match; match; match = (++help_table)->match)
	if (!strcmp(word, match))
	    return  (help_table->message);

    return  ((String) NULL);
}

static String next_message_point(char *ptr, int nlines)
{
    int i;

    for (i = 0; (i < nlines) && ptr; i++)
	if (ptr = strchr(ptr, NEW_LINE))
	    ptr++;

    if (ptr)
	*(ptr-1) = 0;

    return  ptr;
}

static int next_input_lines()
{
    Line line;

    printf("........");
    FLUSH;

    fgets(line, LINE_SIZE, stdin);

    if (*line == NEW_LINE)
	return  LINES_PER_PAGE;
    else
	return  0;
}

static void print_help_message(String message)
{
    int nlines;
    char *ptr1, *ptr2;

    nlines = LINES_PER_PAGE;

    for (ptr1 = message; ptr1 && (nlines > 0); ptr1 = ptr2)
    {
	ptr2 = next_message_point(ptr1, nlines);
	printf("%s\n", ptr1);

	if (ptr2)
	    nlines = next_input_lines();
    }
}

Bool help_request(int argc, char **argv, Help_index *help_table)
{
    String message;

    if (argc < 2)
	return  FALSE;

    if (strcmp(argv[1], "help"))
	return  FALSE;

    message = NULL;

    if (argc == 2)
	message = help_table[0].message;
    else if (argc == 3)
	message = search_table(argv[2], help_table+1);
    else
	message = NULL;

    if (message == NULL)
	printf("no help available for that subject\n");
    else
	print_help_message(message);

    return  TRUE;
}
