/*
 *  NOTE:  the code below assumes that the number of points in a
 *  subplane in the 1 direction is even!  It will not work otherwise!
 *  This allows no need to copy to and from the vector row_data,
 *  but, instead, to flip back and forth between two stores for data,
 *  one of which is row_data, and the other of which is work.
 */

#include "block.h"

#include "block_io.h"
#include "contour.h"
#include "utility.h"

static float *store;
static float *col_store;
static float *row_store;
static float *col_data;
static float *row_data;
static float *work;

static float *data1;
static float *data2;

static FILE *file_out;

static int dim0;
static int dim1;
static int nsub_chunks0;
static int nsub_chunks1;
static int nsub_blocks0;
static int nsub_blocks1;
static int nsub_points0;
static int nsub_points1;
static int cum_nblocks0;
static int cum_nblocks1;
static int block_size0;
static int block_size1;
static int cum_block_size0;
static int cum_block_size1;
static int nsub_blks0;
static int nsub_blks1;
static int nsub_pnts0;
static int nsub_pnts1;
static int npoints0;
static int npoints1;
static int first0;
static int first1;
static int last0;
static int last1;
static int first_pnt0;
static int first_pnt1;
static int npoints_cont0;
static int npoints_cont1;
static int nblocks_cont0;
static int nblocks_cont1;

static int ndim;
static int ndim_rest;
static int size_of_block;
static int base_block;
static int base_point;
static int row;
static int nchunks;
static int nsub_planes;
static int store_block;
static int base_first;
static int nrows;
static int ncols;

static Bool have_extra_row;
static Bool have_extra_col;

static int *npoints;
static int *block_size;
static int *first;
static int *last;

static int dim_rest[MAX_NDIM];
static int nblocks[MAX_NDIM];
static int cum_nblocks[MAX_NDIM];
static int cum_nblocks_rest1[MAX_NDIM];
static int cum_nblocks_rest2[MAX_NDIM];
static int cum_npoints_rest1[MAX_NDIM];
static int cum_npoints_rest2[MAX_NDIM];
static int cum_npoints_rest3[MAX_NDIM];
static int cum_block_size[MAX_NDIM];
static int block_rest[MAX_NDIM];
static int point_rest[MAX_NDIM];

static float lower[MAX_NDIM];
static float upper[MAX_NDIM];
static int npoints_cont[MAX_NDIM];
static int nblocks_cont[MAX_NDIM];
static int first_block[MAX_NDIM];
static int first_pnt[MAX_NDIM];
static int point_first[MAX_NDIM];

static int nlevels;
static float *levels;
static List *vertices;

static int neg_levels;
static int *directory;
static int dir_size;
static int dir_offset;
static float *output;
static int out_size;
static int out_record;
static int out_position;
static int sub_chunk;

static float lower0;
static float lower1;
static float sub_offset0;
static float sub_offset1;

static int npnts[2];
static Coord offset;
static Coord scale;
static Contour_info contour_info;

static Bool new_index;
static int dir_index;

static Block_IO block_io;

static Bool have_some_exclusions;
static Exclude_info *exclude;
static Diagonal_info *diagonal;
static float point_ppm[MAX_NDIM];
static Ref_info *ref;

static Timer_funcs no_timer_funcs =
			{ start_no_timer, update_no_timer, stop_no_timer };

#define  VERSION	3.0
#define  END_RECORD	0.0
#define  END_SUBPLANE	-1.0

static void init_directory()
{
    int i;
    float *dir_header = (float *) directory;

    dir_offset = 0;

    dir_header[dir_offset++] = VERSION;

    dir_header[dir_offset++] = ndim;

    dir_header[dir_offset++] = ndim - dim1;
    dir_header[dir_offset++] = ndim - dim0;
		/* Note backwards convention here */

    for (i = 0; i < ndim_rest; i++)
	dir_header[dir_offset++] = ndim - dim_rest[ndim_rest-i-1];
		/* Note backwards convention here */

/*  Extra complication below because lower subplanes have 1 less point than
    other subplanes, and subplane with extra point has given correction  */
		/* Note backwards convention here */

    dir_header[dir_offset++] = lower1 - scale.y;
    dir_header[dir_offset++] = upper[dim1];

    dir_header[dir_offset++] = lower0 - scale.x;
    dir_header[dir_offset++] = upper[dim0];

    for (i = 0; i < ndim_rest; i++)
    {
	dir_header[dir_offset++] = lower[dim_rest[ndim_rest-i-1]];
	dir_header[dir_offset++] = upper[dim_rest[ndim_rest-i-1]];
		/* Note backwards convention here */
    }

    dir_header[dir_offset++] = sub_offset1;
    dir_header[dir_offset++] = sub_offset0;
		/* Note backwards convention here */

    dir_header[dir_offset++] = nsub_chunks1;
    dir_header[dir_offset++] = nsub_chunks0;
		/* Note backwards convention here */

    for (i = 0; i < ndim_rest; i++)
	dir_header[dir_offset++] = npoints_cont[dim_rest[ndim_rest-i-1]];
		/* Note backwards convention here */
}

static void init_output()
{
    int i, j, l;
    float s;

    scale.x = (upper[dim0]-lower[dim0]) / ((float) (npoints0-1));
    lower0 = lower[dim0] + scale.x*first_block[dim0]*block_size0;
    upper[dim0] = lower0 + scale.x*(nblocks_cont0*block_size0-1);
    sub_offset0 = nsub_points0 * scale.x;

    scale.y = (upper[dim1]-lower[dim1]) / ((float) (npoints1-1));
    lower1 = lower[dim1] + scale.y*first_block[dim1]*block_size1;
    upper[dim1] = lower1 + scale.y*(nblocks_cont1*block_size1-1);
    sub_offset1 = nsub_points1 * scale.y;

    for (i = 0; i < ndim_rest; i++)
    {
	j = dim_rest[i];
	s = (upper[j]-lower[j]) / ((float) (npoints[j]-1));
	lower[j] += s * first[j];
	upper[j] = lower[j] + s*(npoints_cont[j]-1);
    }

    ZERO_VECTOR(directory, dir_size);

    init_directory();

    out_position = out_record = 0;

    neg_levels = 0;

    for (l = 0; l < nlevels; l++)
    {
	if (levels[l] < 0)
	{
	    if (l > neg_levels)
		SWAP(levels[l], levels[neg_levels], float);

	    neg_levels++;
	}
    }
}

static void directory_index(int type, Bool new_point)
{
    int i, j;
    static int point;

    if (new_point)
    {
	point = 0;
	for (i = 0; i < ndim_rest; i++)
	{
	    j = dim_rest[i];
	    point += cum_npoints_rest3[i] *
		(block_rest[i]*block_size[j] + point_rest[i] - point_first[i]);
	}

	point *= nsub_chunks0 * nsub_chunks1;
	point += sub_chunk;
    }

    new_index = TRUE;
    dir_index = dir_offset + 2*point + type;

/*
    printf("directory_index: dir_index = %d\n", dir_index);
*/
}

static void directory_entry()
{
    directory[dir_index] =
		dir_size + out_size*out_record + out_position + 1;
}

static Status record_output(String error_msg)
{
/*
    if (FWRITE(output, BYTES_PER_WORD, out_size, file_out))
*/
    if (endian_fwrite((char *) output, out_size, file_out) == ERROR)
    {
	sprintf(error_msg, "writing record %d in record_output", out_record);
        return  ERROR;
    }

    out_record++;
    out_position = 0;

    return  OK;
}

static Status polyline_output(int n, Vertex *v, String error_msg)
{
    int i, m;
    Vertex *vv;

/*
    printf("polyline output: n = %d\n", n);
    for (i = 0, vv=v; i < n; i++, vv = vv->v2)
	printf("  %d: p.x = %6.3f, p.y = %6.3f\n", i, vv->p.x, vv->p.y);
*/

    if (v->v1)  /* closed */
	m = n + 1;
    else
	m = n;

    if ((out_position + 2*m + 2) >= out_size)
    {
/*
	printf("next record: out_position = %d, m = %d\n", out_position, m);
*/

	output[out_position++] = END_RECORD;
	CHECK_STATUS(record_output(error_msg));

	if (new_index)
    	    directory_entry();
    }

    output[out_position++] = m;

    for (i = 0, vv = v; i < n; i++, vv = vv->v2)
    {
	output[out_position++] = vv->p.y;
	output[out_position++] = vv->p.x;
		/* Note backwards convention here */
    }

    if (m > n)  /* closed */
    {
	output[out_position++] = v->p.y;
	output[out_position++] = v->p.x;
		/* Note backwards convention here */
    }

    new_index = FALSE;

    return  OK;
}

static Bool include_point(int dim, float v)
{
    int i;
    Exclude_info *e = exclude + dim;

    for (i = 0; i < e->n; i++)
    {
	if ((v >= e->first[i]) && (v <= e->last[i]))
	    return  FALSE;
    }

    return  TRUE;
}

static Bool near_excluded_diagonal()
{
    int i, d0, d1, n = diagonal->n;
    float delta, p0, p1;

    for (i = 0; i < n; i++)
    {
	d0 = diagonal->dim0[i];
	d1 = diagonal->dim1[i];
	delta = diagonal->delta[i];

	p0 = point_ppm[d0];
	p1 = point_ppm[d1];

	if (ABS(p0 - p1) < delta)
	    return  TRUE;
    }

    return  FALSE;
}

static Bool include_vertex(Vertex *v)
{
    if (!include_point(dim0, v->p.x))
	return  FALSE;

    if (!include_point(dim1, v->p.y))
	return  FALSE;

    point_ppm[dim0] = v->p.x;
    point_ppm[dim1] = v->p.y;

    if (near_excluded_diagonal())
	return  FALSE;

    return  TRUE;
}

static int walk_chain(Vertex **v_start, Vertex **v_poly)
{
    int n;
    Vertex *v = *v_start, *vv;

    /* walk backwards as long as vertex included */

/*
for (n = 0, vv = v; vv && ((n == 0) || (vv != v)); n++, vv = vv->v2)
  printf("%d: %d (%4.3f, %4.3f)\n", n, vv, vv->p.x, vv->p.y);
*/

    for (n = 0, vv = v; vv->v1 && ((n == 0) || (vv != v)); n++, vv = vv->v1)
    {
	if (!include_vertex(vv->v1))
	{
	    vv->v1->v2 = NULL;
	    vv->v1 = NULL;

	    break;
	}
    }

    if (vv->v1) /* then have gone all way around and everything is included */
    {
	*v_poly = v;
	*v_start = NULL;

/*
printf("gone all way round, n = %d\n", n);
*/
	return  n;
    }

    /* if n > 0 then vv now points to first included vertex */

    if (n == 0) /* then have not made it any way backwards */
    {
	/* walk forwards as long as vertex not included */

	for (n = 0, vv = v; vv; n++, vv = vv->v2)
	{
	    if (include_vertex(vv))
	    {
		if (vv->v1) /* then previous vertex not included */
		{
		    vv->v1->v2 = NULL; /* this should not be needed */
		    vv->v1 = NULL;
		}

		break;
	    }
	}

	if (!vv) /* then nothing included */
	{
	    *v_start = NULL;

/*
printf("nothing included\n");
*/
	    return  0;
	}

	*v_poly = vv; /* know that vv included */
	n = 1;
    }
    else /* have made it some way backwards so know vv included */
    {
	*v_poly = vv;

	vv = v->v1; /* can start searching from (just past) here (i.e. v) */
    }

    /* walk forwards until vertex not included */

    for (vv = vv->v2; vv; n++, vv = vv->v2)
    {
	if (!include_vertex(vv))
	{
	    vv->v1->v2 = NULL;
	    vv->v1 = NULL;

	    break;
	}
    }

    *v_start = vv; /* for next time (not quite optimal) */

    if (n == 1)
	n = 0; /* need at least two vertices for polyline */

/*
printf("returning with n = %d\n", n);
*/
    return  n;
}

static int next_contour_chain(List *vertices, Vertex **vertex)
{
    int n;
    static Vertex *v = NULL;

    if (!v) /* then need to get next chain */
    {
        n = next_chain(vertices, &v);

        if (n == 0)
        {
            v = NULL;

            return 0;
	}
    }

    if (have_some_exclusions)
    {
	do
	{
	    n = walk_chain(&v, vertex);
	}   while ((n == 0) && v);

	if (n == 0)
	    return next_contour_chain(vertices, vertex);
    }
    else
    {
	*vertex = v;
	v = NULL;
    }

    return  n;
}

static Status contour_output(String error_msg)
{
    int l, n;
    Bool new_point, new_entry;
    List vert;
    Vertex *v;

    new_point = TRUE;
    new_entry = TRUE;

    for (l = 0; l < neg_levels; l++)
    {
	vert = vertices[l];

        while ((n = next_contour_chain(&vert, &v)) > 0)
	{
	    if (new_entry)
	    {
		directory_index(0, new_point);
		directory_entry();

		new_entry = FALSE;
		new_point = FALSE;
	    }

	    CHECK_STATUS(polyline_output(n, v, error_msg));
	}
    }

    if (!new_entry)
	output[out_position++] = END_SUBPLANE;

    new_entry = TRUE;

    for (l = neg_levels; l < nlevels; l++)
    {
	vert = vertices[l];

        while ((n = next_contour_chain(&vert, &v)) > 0)
	{
	    if (new_entry)
	    {
		directory_index(1, new_point);
		directory_entry();

		new_entry = FALSE;
		new_point = FALSE;
	    }

	    CHECK_STATUS(polyline_output(n, v, error_msg));
	}
    }

    if (!new_entry)
	output[out_position++] = END_SUBPLANE;

    return  OK;
}

static Status end_output(String error_msg)
{
    if (out_position > 0)
	CHECK_STATUS(record_output(error_msg));

    rewind(file_out);

/*
    if (FWRITE(directory, BYTES_PER_WORD, dir_size, file_out))
*/
    if (endian_fwrite((char *) directory, dir_size, file_out) == ERROR)
    {
	sprintf(error_msg, "writing directory in end_output");
        return  ERROR;
    }

    return  OK;
}

static void init_arrays()
{
    int i, j, n;

    first[dim1] -= first[dim1] % 2;
	/* make even so that swap of data1, data2 works */

    i = 0;
    for (j = 0; j < ndim; j++)
	if ((j != dim0) && (j != dim1))
	    dim_rest[i++] = j;

    ndim_rest = ndim - 2;

    BLOCKS(nblocks, npoints, block_size, ndim);
    CUMULATIVE(cum_nblocks, nblocks, n, ndim);

    CUMULATIVE(cum_block_size, block_size, size_of_block, ndim);

    for (i = 0; i < ndim; i++)
    {
	first_block[i] = first[i] / block_size[i];
	nblocks_cont[i] = (last[i]-1)/block_size[i] - first_block[i] + 1;
	npoints_cont[i] = last[i] - first[i];
    }

    nchunks = 1;
    for (i = 0; i < ndim_rest; i++)
    {
	j = dim_rest[i];
	cum_nblocks_rest1[i] = nchunks;
	cum_nblocks_rest2[i] = cum_nblocks[j];
	nchunks *= nblocks_cont[j];
    }

    n = 1;
    for (i = ndim_rest-1; i >= 0; i--)
    {
	j = dim_rest[i];
	cum_npoints_rest3[i] = n;
	n *= npoints_cont[j];
    }

    cum_nblocks0 = cum_nblocks[dim0];
    cum_nblocks1 = cum_nblocks[dim1];

    block_size0 = block_size[dim0];
    block_size1 = block_size[dim1];

    npoints0 = npoints[dim0];
    npoints1 = npoints[dim1];

    cum_block_size0 = cum_block_size[dim0];
    cum_block_size1 = cum_block_size[dim1];

    nsub_points0 = nsub_blocks0 * block_size0;
    nsub_points1 = nsub_blocks1 * block_size1;

    first0 = first[dim0];
    first1 = first[dim1];

    last0 = last[dim0];
    last1 = last[dim1];

    npoints_cont0 = npoints_cont[dim0];
    npoints_cont1 = npoints_cont[dim1];

    nblocks_cont0 = nblocks_cont[dim0];
    nblocks_cont1 = nblocks_cont[dim1];

    nsub_chunks0 = BLOCK(nblocks_cont0, nsub_blocks0);
    nsub_chunks1 = BLOCK(nblocks_cont1, nsub_blocks1);

    INDEX_OF_ARRAY(base_block, first_block, cum_nblocks, ndim);
}

static void init_chunk(int chunk)
{
    int i, j, f, n;

    ARRAY_OF_INDEX(block_rest, chunk, cum_nblocks_rest1, ndim_rest);
    INDEX_OF_ARRAY(base_block, block_rest, cum_nblocks_rest2, ndim_rest);

    nsub_planes = 1;
    for (i = 0; i < ndim_rest; i++)
    {
	j = dim_rest[i];
	f = first[j] % block_size[j];

	if (block_rest[i] == 0)
	{
	    first_pnt[j] = f;
	    point_first[i] = 0;

	    if (block_rest[i] == (nblocks_cont[j]-1))
		n = npoints_cont[j];
	    else
		n = block_size[j] - first_pnt[j];
	}
	else if (block_rest[i] == (nblocks_cont[j]-1))
	{
	    first_pnt[j] = 0;
	    point_first[i] = f;
	    n = 1 + ((last[j]-1) % block_size[j]);
	}
	else
	{
	    first_pnt[j] = 0;
	    point_first[i] = f;
	    n = block_size[j];
	}

	cum_npoints_rest1[i] = nsub_planes;
	cum_npoints_rest2[i] = cum_block_size[j];
	nsub_planes *= n;
    }
}

static void init_subchunk0(int sub_chunk0)
{
    if (sub_chunk0 == 0)
    {
	first_pnt0 = first0 % block_size0;

	if (sub_chunk0 == (nsub_chunks0-1))
	{
	    nsub_blks0 = nblocks_cont0;
	    nsub_pnts0 = npoints_cont0;
	}
	else
	{
	    nsub_blks0 = nsub_blocks0;
	    nsub_pnts0 = nsub_points0 - first_pnt0;
	}
    }
    else if (sub_chunk0 == (nsub_chunks0-1))
    {
	first_pnt0 = 0;
	nsub_blks0 = 1 + ((nblocks_cont0-1) % nsub_blocks0);
	nsub_pnts0 = 1 + ((last0-1)%block_size0) + (nsub_blks0-1)*block_size0;
    }
    else
    {
	first_pnt0 = 0;
	nsub_blks0 = nsub_blocks0;
	nsub_pnts0 = nsub_points0;
    }

    if (sub_chunk0 == 0)
    {
	npnts[0] = nsub_pnts0;
	offset.x = lower0 + first_pnt0*scale.x;
    }
    else
    {
	npnts[0] = nsub_pnts0 + 1;
	offset.x = lower0 + sub_chunk0*sub_offset0 - scale.x;
    }

    first_pnt[dim0] = first_pnt0;
    INDEX_OF_ARRAY(base_first, first_pnt, cum_block_size, ndim);

    ncols = block_size0 - first_pnt0;
    ncols = MIN(nsub_pnts0, ncols);
}

static void init_subchunk1(int sub_chunk1)
{
    if (sub_chunk1 == 0)
    {
	first_pnt1 = first1 % block_size1;

	if (sub_chunk1 == (nsub_chunks1-1))
	{
	    nsub_blks1 = nblocks_cont1;
	    nsub_pnts1 = npoints_cont1;
	}
	else
	{
	    nsub_blks1 = nsub_blocks1;
	    nsub_pnts1 = nsub_points1 - first_pnt1;
	}
    }
    else if (sub_chunk1 == (nsub_chunks1-1))
    {
	first_pnt1 = 0;
	nsub_blks1 = 1 + ((nblocks_cont1-1) % nsub_blocks1);
	nsub_pnts1 = 1 + ((last1-1)%block_size1) + (nsub_blks1-1)*block_size1;
    }
    else
    {
	first_pnt1 = 0;
	nsub_blks1 = nsub_blocks1;
	nsub_pnts1 = nsub_points1;
    }

    if (sub_chunk1 == 0)
    {
	npnts[1] = nsub_pnts1;
	offset.y = lower1 + first_pnt1*scale.y;
    }
    else
    {
	npnts[1] = nsub_pnts1 + 1;
	offset.y = lower1 + sub_chunk1*sub_offset1 - scale.y;
    }

    first_pnt[dim1] = first_pnt1;
}

static Status get_data_row(float **p_data, String error_msg)
{
    int i, j, point, store_point;
    float *data;

    if (have_extra_row)
    {
	have_extra_row = FALSE;

	*p_data = row_data;

/*
    	printf("      data** in get_data_row = %7.2f %7.2f %7.2f\n",
					**p_data,*(*p_data+1),*(*p_data+2));
*/

	return  OK;
    }

    *p_data = data = data1;

    if (have_extra_col)
	*data++ = col_data[row];

    /* extract rest of data from store */

    point = store_point = base_point;

    for (j = 0; j < ncols; j++)
    {
	*data++ = store[point];
	point += cum_block_size0;
    }

    store_point += size_of_block - first_pnt0*cum_block_size0;
/*  below is wrong!  bug fixed 25 Feb 95
    store_point += size_of_block;
*/

    for (i = block_size0; i < nsub_pnts0; i += block_size0)
    {
	point = store_point;

	for (j = 0; j < block_size0; j++)
	{
	    *data++ = store[point];
	    point += cum_block_size0;
	}

	store_point += size_of_block;
    }

    col_data[row++] = *(--data);

/*
    printf("      get_data_row: base_point = %d, row = %d, nrows = %d, data = %7.2f %7.2f %7.2f\n",
		base_point, row, nrows, **p_data,*(*p_data+1),*(*p_data+2));
*/

    base_point += cum_block_size1;

    if (!(row % block_size1))
    {
	base_point += nsub_blks0*size_of_block - cum_block_size1*nrows;
	nrows = block_size1;
    }

    SWAP(data1, data2, float *);

    return  OK;
}

static Bool include_subplane()
{
    int i, j;
    float p;

    if (have_some_exclusions)
    {
	for (i = 0; i < ndim_rest; i++)
	{
	    j = dim_rest[i];

	    p = point_rest[i] + first_pnt[i] +
		(block_rest[i] + first_block[j]) * block_size[j];

	    point_ppm[j] = p + 1;
	    convert_from_point(REF_PPM, npoints[j], ref+j, point_ppm+j);

	    if (!include_point(j, p))
		return  FALSE;
	}
    }

    return  TRUE;
}

static Status contour_subplane(int subplane, String error_msg)
{
    row = first_pnt1;
/*
    nrows = block_size1 - first_pnt1;
*/
    nrows = block_size1;

    ARRAY_OF_INDEX(point_rest, subplane, cum_npoints_rest1, ndim_rest);
    INDEX_OF_ARRAY(base_point, point_rest, cum_npoints_rest2, ndim_rest);

    base_point += base_first;

/*
    printf("contour_info\n");
    printf("  npoints[0] = %d, npoints[1] = %d\n",
		contour_info.npoints[0], contour_info.npoints[1]);
    printf("  offset.x = %6.3f, offset.y = %6.3f\n",
		contour_info.offset->x, contour_info.offset->y);
    printf("  scale.x = %f, scale.y = %f\n",
		contour_info.scale->x, contour_info.scale->y);
*/

    if (include_subplane())
    {
	CHECK_STATUS(construct_contours(&contour_info, error_msg));
	CHECK_STATUS(contour_output(error_msg));
    }

    return  OK;
}

static Status read_block(int block, String error_msg)
{
    float *s;

    s = store + size_of_block * store_block;

    CHECK_STATUS(read_file_block(&block_io, block, s, error_msg));

    store_block++;

    return  OK;
}

static Status process_chunk(String error_msg)
{
    int i0, i1, j0, j1, n, count0, count1, block0, block1, block;
    Bool extra_row;

    sub_chunk = 0;
    extra_row = FALSE;
    for (i1 = 0; i1 < nsub_chunks1; i1++)
    {
	count1 = 0;

	init_subchunk1(i1);

	have_extra_col = FALSE;
    	for (i0 = 0; i0 < nsub_chunks0; i0++)
	{
/*
	    if ((i1 == 0) && (i0 == 1))
		printf("i1 = %d, i0 = %d\n", i1, i0);
*/

	    count0 = 0;

	    block0 = i0 * nsub_blocks0;
	    block1 = i1 * nsub_blocks1;

	    init_subchunk0(i0);

	    store_block = 0;

	    for (j1 = 0; j1 < nsub_blks1; j1++)
	    {
		block = base_block + block0*cum_nblocks0 + block1*cum_nblocks1;

	    	for (j0 = 0; j0 < nsub_blks0; j0++)
		{
/*
		    printf("    **reading block %d (j1 = %d, j0 = %d)\n",
							block, j1, j0);
*/
		    CHECK_STATUS(read_block(block, error_msg));

		    block += cum_nblocks0;
		}

		block1++;
	    }

	    for (n = 0; n < nsub_planes; n++)
	    {
		have_extra_row = extra_row;
/*
printf("    i1 = %d, i0 = %d, n = %d, e_row = %d, count0 = %d, count1 = %d\n",
					i1, i0, n, extra_row, count0, count1);
*/

		col_data = col_store + count0*nsub_points1;
		row_data = row_store + count1*(nsub_points0+1);

		data1 = work;
		data2 = row_data;

	    	CHECK_STATUS(contour_subplane(n, error_msg));

		count0++;  count1++;
	    }

	    have_extra_col = TRUE;
	    sub_chunk++;
	}

	extra_row = TRUE;
    }

    return  OK;
}

static void init_contour()
{
    contour_info.nlevels = nlevels;
    contour_info.levels = levels;
    contour_info.npoints = npnts;
    contour_info.offset = &offset;
    contour_info.scale = &scale;
    contour_info.vertices = vertices;
    contour_info.get_row = get_data_row;
    contour_info.timer_funcs = &no_timer_funcs;
}

Status block_process(Size_info *size_info, Store_info *store_info,
			Level_info *level_info, Output_info *output_info,
			Plane_info *plane_info, File_info *file_info,
			Limit_info *limit_info, Exclude_info *exclude_info,
			Diagonal_info *diagonal_info, Ref_info *ref_info,
			String error_msg)
{
    int i;

    ndim = size_info->ndim;
    block_size = size_info->block_size;
    npoints = size_info->npoints;

    store = store_info->store;
    row_store = store_info->row_store;
    col_store = store_info->col_store;
    work = store_info->work;

    nlevels = level_info->nlevels;
    levels = level_info->levels;
    vertices = level_info->vertices;

    dim0 = plane_info->dim0;
    dim1 = plane_info->dim1;
    nsub_blocks0 = plane_info->nsub_blocks0;
    nsub_blocks1 = plane_info->nsub_blocks1;

    dir_size = output_info->dir_size;
    directory = output_info->directory;
    out_size = output_info->out_size;
    output = output_info->output;
    COPY_VECTOR(lower, output_info->lower, ndim);
    COPY_VECTOR(upper, output_info->upper, ndim);

    file_out = file_info->file_out;

    first = limit_info->first;
    last = limit_info->last;

    exclude = exclude_info;
    diagonal = diagonal_info;
    ref = ref_info;

    have_some_exclusions = FALSE;

    for (i = 0; i < ndim; i++)
    {
	if (exclude[i].n > 0)
	{
	    have_some_exclusions = TRUE;
	    break;
	}
    }

    if (diagonal->n > 0)
	have_some_exclusions = TRUE;
/*
    printf("first = %d, %d, %d, %d\n", first[0], first[1], first[2], first[3]);
    printf("last = %d, %d, %d, %d\n", last[0], last[1], last[2], last[3]);
*/

    if (!(file_info->blocked))
	RETURN_ERROR_MSG("input file must be blocked");

    init_arrays();
    init_contour();
    init_output();

/*    if (FSEEK_ABSOLUTE(file_out, dir_size)) */ /* skip over directory */
/*
    {
	sprintf(error_msg, "seeking over output directory in block_process");
        return  ERROR;
    }
*/
/*
    if (FWRITE(directory, BYTES_PER_WORD, dir_size, file_out))
*/
    if (endian_fwrite((char *) directory, dir_size, file_out) == ERROR)
    {
	sprintf(error_msg, "skipping over directory in block_process");
        return  ERROR;
    }

    block_io.name = file_info->input_file;
    block_io.file = file_info->file_in;
    block_io.swapped = file_info->swapped;
    block_io.integer = file_info->integer;
    block_io.deflated = file_info->deflated;
    block_io.header = file_info->header;
    block_io.dir_size = file_info->dir_size;
    block_io.directory = store_info->directory;
    block_io.block_size = size_of_block;
    block_io.byte_size = BYTES_PER_WORD;

    CHECK_STATUS(init_block_read(&block_io, error_msg));
    CHECK_STATUS(skip_file_blocks(&block_io, base_block, error_msg));

/*
    printf("base_block = %d\n", base_block);
*/

    printf("%d chunks to contour\n", nchunks);

    for (i = 0; i < nchunks; i++)
    {
	printf("\t... working on chunk %d of %d\n", i+1, nchunks);
	FLUSH;

	init_chunk(i);

	CHECK_STATUS(process_chunk(error_msg));
    }

    CHECK_STATUS(end_output(error_msg));

    return  OK;
}
