#ifndef _incl_defns
#define _incl_defns

#include "consts.h"

typedef struct
{
    int column;
    float low;
    float high;
    char atom_type;
    Bool exclusion;
    float shift;
    float delta;
}   Column_data;

typedef struct
{
    int ncolumns;
    int nshift_columns;
    Column_data data[MAX_COLUMNS];
    int nresidue_ranges;
    int residue1[MAX_RANGES], residue2[MAX_RANGES];
}   Columns;

typedef struct
{
    float intensity;
    float distance;
    float distance_minus;
    float distance_plus;
}   Intensity_dist;

typedef struct
{
    int ndim;
    int crosspeak_ndim;
    Columns *columns;
    int nintensity_dists;
    Intensity_dist *intensity_dists;
    Bool split_output;
}   Connect_info;

typedef struct
{
    String input_shift_file;
    String input_crosspeak_file;
    String output_crosspeak_file;
    String output_match_file;
    String output_xplor_file;
    String output_nilges_file;
    String output_null_file;
}   Connect_files;

#endif /* _incl_defns */
