#ifndef _incl_atom
#define _incl_atom

#include "macros.h"
#include "types.h"

#define  HYDROGEN		'H'
#define  CARBON			'C'
#define  NITROGEN		'N'
#define  OXYGEN			'O'
#define  SULFUR			'S'

typedef struct
{
    int residue;
    String chain;
    String res_name;
    String atom_name;
    char atom_type;
    float shift;
    float delta;
}   Atom;

extern Status find_atom_type
	(String string, char *atom_type, String error_msg);

extern Bool atom_assigned
	(Atom *atom);

extern Bool same_atom
	(Atom *atom1, Atom *atom2);

#endif /* _incl_atom */
