#include "atom.h"

#include "utility.h"

Status find_atom_type(String string, char *atom_type, String error_msg)
{
    int n;
    char type;

    for (n = 0; (n < strlen(string)) && isdigit(string[n]); n++)
	;

    type = string[n];

    if ((type != HYDROGEN) && (type != CARBON) && (type != NITROGEN) &&
        (type != OXYGEN) && (type != SULFUR))
    {
/*
	sprintf(error_msg, "unknown atom type for '%s'", string);
	return  ERROR;
*/
	printf("warning: unknown atom type for '%s', assuming heavy", string);
    }

    *atom_type = type;

    return  OK;
}

Bool atom_assigned(Atom *atom)
{
/*  changed condition 4 Sep 00
    if (empty_string(atom->res_name) || empty_string(atom->atom_name))
*/
    if (empty_string(atom->res_name) || empty_string(atom->atom_name)
				     || (atom->residue == 0))
	return  FALSE;
    else
	return  TRUE;
}

Bool same_atom(Atom *atom1, Atom *atom2)
{
    if (atom1->residue != atom2->residue)
	return FALSE;

    if (!equal_strings(atom1->atom_name, atom2->atom_name))
	return FALSE;

    if (!equal_strings(atom1->chain, atom2->chain))
	return FALSE;

    return TRUE;
}
