#include "simple.h"

static int ninput_files;
static int npoints;

void do_add(float **data_in, float *data_out)
{
    int i, j;

    for (i = 0; i < npoints; i++)
    {
	data_out[i] = data_in[0][i];

	for (j = 1; j < ninput_files; j++)
	    data_out[i] += data_in[j][i];
    }
}

void do_subtract(float **data_in, float *data_out)
{
    int i;

    for (i = 0; i < npoints; i++)
	data_out[i] = data_in[0][i] - data_in[1][i];
}

Status init_add(int nfiles, int npts, Combine_func *combine_func,
							String error_msg)
{
    ninput_files = nfiles;
    npoints = npts;
    *combine_func = do_add;

    return  OK;
}

Status init_subtract(int nfiles, int npts, Combine_func *combine_func,
							String error_msg)
{
    ninput_files = nfiles;

    if (ninput_files != 2)
    {
	sprintf(error_msg, "'subtract': must have 2 input files");
	return  ERROR;
    }

    npoints = npts;
    *combine_func = do_subtract;

    return  OK;
}
