#include "gradient.h"

static int npoints;

void do_gradient(float **data_in, float *data_out)
{
    int i;
    float *x1, *x2, *y, a1, b1, a2, b2;

    x1 = data_in[0];
    x2 = data_in[1];
    y = data_out;

    for (i = 0; i < npoints; i++)
    {
	a1 = *x1++;  b1 = *x1++;
	a2 = *x2++;  b2 = *x2++;

	*y++ = HALF * (a1 + a2);
	*y++ = HALF * (b1 + b2);
	*y++ = HALF * (b1 - b2);
	*y++ = HALF * (- a1 + a2);
    }
}

Status init_gradient(int ninput_files, int *npts, int *type,
			Combine_func *combine_func, String error_msg)
{
    if (ninput_files != 2)
    {
	sprintf(error_msg, "'gradient': must have 2 input files");
	return  ERROR;
    }

/*
    if (*npts % 2)
    {
	sprintf(error_msg, "'gradient': must have even number of points");
	return  ERROR;
    }
*/

    npoints = *npts;

    *npts *= 2;
    *type = COMPLEX_DATA;
    *combine_func = do_gradient;

    return  OK;
}
