#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

int parse_filesystem(char *newtoken, char *oldtoken)
{
int tokentype,l;
char token[TOKENSIZE];
char molecule[LINELENGTH];

  tokentype=gettoken(token);
  molecule[0]=0;

#ifdef DEBUG
printf("parse_filesystem(): %s (type=%i)\n",token,tokentype);
#endif

  if (strcasecmp(token,"folderexists")==0 || strcasecmp(token,"fileexists")==0)
  {
    strcat(newtoken,"file_exists");
    convert_funct(newtoken,"1",8);
    /* strcat(newtoken,";"); */
  }
    else
  if (strcasecmp(token,"createfolder")==0)
  {
    strcat(newtoken,"mkdir");
    convert_funct(newtoken,"1,@0777",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"copyfolder")==0 || strcasecmp(token,"copyfile")==0)
  {
    strcat(newtoken,"copy");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"movedir")==0 || strcasecmp(token,"movefile")==0)
  {
    strcat(newtoken,"rename");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"delete")==0 || strcasecmp(token,"deletefile")==0)
  {
    strcat(newtoken,"unlink");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"write")==0)
  {
    strcat(newtoken,"fputs($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,",");
    convert_funct(newtoken,"1",1);
    strcat(newtoken,");");
  }
    else
  if (strcasecmp(token,"readall")==0)
  {
    strcat(newtoken,"fgets($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,",65535);");
  }
    else
  if (strcasecmp(token,"close")==0)
  {
    strcat(newtoken,"fclose($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,");");
  }
    else
  if (strcasecmp(token,"opentextfile")==0)
  {
    strcat(newtoken,"fopen(");
    convert_funct(molecule,"1,2",9);

    l=strlen(molecule);
    while(l>0)
    {
      if (molecule[l]==',') break;
      l--;
    }

    molecule[l++]=0;
    strcat(newtoken,molecule);

    while(molecule[l]!=0 && molecule[l]==' ') l++;

    if (molecule[l]=='1') strcat(newtoken,",\"r\"");
      else
    if (molecule[l]=='2') strcat(newtoken,",\"w\"");
      else
    if (molecule[l]=='8') strcat(newtoken,",\"a\"");
      else
    { strcat(newtoken,",\"r\""); }

    strcat(newtoken,");");

    tokentype=gettoken(token);
    push(token,tokentype);
  }
    else
  if (strcasecmp(token,"getfolder")==0)
  {
    /* in ASP, getfolder returns a folder object */
    /* in PHP, the variable being set will contain the folder name */
    convert_funct(newtoken,"1",9);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"files")==0 && php>3)
  {
    strcat(newtoken,"glob($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,");");
  }
    else
  if (strcasecmp(token,"subfolders")==0 && php>3)
  {
    strcat(newtoken,"glob($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,",GLOB_ONLYDIR);");
  }
    else
  if (strcasecmp(token,"size")==0)
  {
    strcat(newtoken,"filesize($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,")");
  }
    else
  if (strcasecmp(token,"DateLastModified")==0)
  {
    strcat(newtoken,"filemtime($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,")");
  }
    else
  if (strcasecmp(token,"attributes")==0)
  {
    // ----------------------------------------
    // vbscript "attributes" property returns a bit-array:
    // 0 = Normal file
    // 1 = Read-only file
    // 2 = Hidden file
    // 4 = System file
    // 16 = Folder or directory
    // 32 = File has changed since last backup
    // 1024 = Link or shortcut
    // 2048 = Compressed file
    // ----------------------------------------
    // we implement 3 of the 8 bits using the following php function:
    // 1-(int)is_writeable($f)+16*(int)is_dir($f)+1024*(int)is_link($f)
    strcat(newtoken,"(1-(int)is_writeable($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,")+16*(int)is_dir($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,")+1024*(int)is_link($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,"))");
  }
    else
  if (strcasecmp(token,"GetBaseName")==0)
  {
    strcat(newtoken,"basename");
    convert_funct(newtoken,"1",0);
  }
    else
  if (strcasecmp(token,"createtextfile")==0)  /* Alex Combs */
  {
    strcat(newtoken, "fopen(");
    convert_funct(newtoken,"1",1);
    strcat(newtoken, ", \"w\");");
  }
    else
  if (strcasecmp(token,"writeline")==0)
  {
    strcat(newtoken,"fputs($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,",");
    convert_funct(newtoken,"1",1);
    strcat(newtoken,".\"\\n\"");
    strcat(newtoken,");");
  }
    else
  if (strcasecmp(token,"readline")==0)
  {
    strcat(newtoken,"fgets($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,")");
  }
    else
  if (strcasecmp(token,"atendofstream")==0)
  {
    strcat(newtoken,"feof($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,")");
  }
    else
  if (strcasecmp(token,"name")==0)
  {
    strcat(newtoken,"$");
    strcat(newtoken,oldtoken);
  }
    else
  {
    strcat(newtoken,token);
    convert_funct(newtoken,"1,2,3,4,5,6,7,8,9",4);
    strcat(newtoken," /* don't know how to convert this filesystem method */ ");
    //eval_expression(" ");
    printf("Unknown filesystem function \"%s\" on line: %d\n",token,line);
  }

  return 0;
}

