#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"

int parse_for_each()
{
char token[TOKENSIZE];
char variable[TOKENSIZE];
char molecule[LINELENGTH];
int tokentype,c;

  tokentype=gettoken(variable);
  tokentype=gettoken(token);

  if (strcasecmp(token,"in")!=0)
  {
    error(token,"In","For Each");
  }

  fprintf(out,"foreach (");

  tokentype=gettoken(token);
  eval_element(molecule,tokentype,token);

  fprintf(out,"%s as $%s)\n",molecule,variable);

  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  tokentype=gettoken(token);
/* printf("Extra token: %s\n",token); */

  return 0;
}

int parse_do()
{
char token[TOKENSIZE];
int c;

  loopcount++;

  if ((c=gettoken(token))!=2 || strcasecmp(token,"while")!=0)
  {
    push(token,c);
    parse_do_loop();
    return 0;
  }

  autoindent();
  fprintf(out,"while");
  c=parse_condition();
  fprintf(out,"\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  loopcount--;

  return 0;
}

int parse_do_until_loop()
{
int c;

  loopcount++;

  autoindent();
  fprintf(out,"while(!");
  c=parse_condition();
  fprintf(out,")\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  loopcount--;

  return 0;
}

int parse_do_loop()
{
char token[TOKENSIZE];
int c;

  loopcount++;

  c=gettoken(token);
  if (strcasecmp(token,"until")==0)
  {
    parse_do_until_loop();
    return 0;
  }

  autoindent();
  fprintf(out,"do\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  parse_body(0);
  indent--;

  c=gettoken(token);
  if (strcasecmp("until",token)!=0)
  { error(token,"Until","Do"); }

  autoindent();
  fprintf(out,"} while (!");
  c=parse_condition();
  fprintf(out,");\n");

  loopcount--;

  return 0;
}

int parse_while()
{
int c;

  loopcount++;

  autoindent();
  fprintf(out,"while");
  c=parse_condition();
  fprintf(out,"\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  loopcount--;

  return 0;
}

int parse_for()
{
char token[TOKENSIZE];
char variable[TOKENSIZE];
char expression[LINELENGTH];
char newtoken[LINELENGTH];
int c,tokentype;
int step=0;

  loopcount++;

  gettoken(token);

  if (strcasecmp(token,"each")==0)
  {
    parse_for_each();
    return 0;
  }

  strcpy(variable,token);
  autoindent();
  strcase(variable);
  fprintf(out,"for ($%s",variable);

  eval_expression(" ");
  fprintf(out,"; ");
  /* sprintf(expression,""); */
  strcpy(expression,"");

  while(1)
  {
    tokentype=gettoken(token);

    if (tokentype==0)
    { printf("Parse error: End of file reached early on line %d\n",line); return 0; }
      else
    if (strcasecmp("step",token)==0 || (tokentype==13 || tokentype==5 || tokentype==6))
    { break; }
      else
    {
      strcpy(newtoken,"");
      eval_element(newtoken,tokentype,token);
      strcat(expression,newtoken);
    }
  }

  if (strcasecmp(token,"step")==0)
  {
    tokentype=gettoken(token);
    if (strcmp("-",token)==0)
    { step=-1; }
      else
    { 
      push(token,tokentype);
/*
      strcpy(tokenpush,token); tokentypepush=tokentype; 
*/
      step=1;
    }
  }
    else
  {
    push(token,tokentype);
  }

  if (step==1 || step==0)
  { fprintf(out,"$%s<=%s; $%s=$%s+",variable,expression,variable,variable); }
    else
  if (step==-1)
  { fprintf(out,"$%s>=%s; $%s=$%s-",variable,expression,variable,variable); }

  if (step==0)
  { putc('1',out); }
    else
  { 
    while(1)
    {
      tokentype=gettoken(token);
      if (tokentype==5 || tokentype==13)
      { break; }
	else
      if (tokentype==6)
      { 
        push(token,tokentype);
        break;
      }
        else
      if (tokentype==0)
      { error(token,"?","For"); return 0; }
        else
      if (tokentype==2)
      { fprintf(out,"$%s",token); }
        else
      { fprintf(out,"%s",token); } 
    }
  }

  fprintf(out,")\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;

  if (column!=0)
  { putc('\n',out); column=0; }

  autoindent();
  fprintf(out,"} ");

  tokentype=gettoken(token);
  push(token,tokentype);
/*
  tokentypepush=tokentype;
  strcpy(tokenpush,token);
*/

  if (tokentype!=6) putc('\n',out);

  loopcount--;

  return 0;
}


