#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"


int eval_token(int tokentype,char *token)
{
char temptoken[TOKENSIZE];
char newtoken[1024];
char molecule1[LINELENGTH];
int t,ch;

  strcpy(newtoken,"");
  molecule1[0]=0;

  if (strcasecmp(token,"@")==0)
  { 
    t=gettoken(temptoken);
    if (strcasecmp(temptoken,"language")==0)
    { strcpy(token,"@language"); }
      else
    { push(temptoken,t); }
  }

  if (strcasecmp(token,"exit")==0)
  {
    t=gettoken(temptoken);
    autoindent();

    if (strcasecmp(temptoken,"function")==0)
    {
      fprintf(out,"return $function_ret;\n");
    }
      else
    if (strcasecmp(temptoken,"sub")==0)
    {
      fprintf(out,"return $function_ret;\n");
    }
      else
    if (strcasecmp(temptoken,"class")==0)
    {
      fprintf(out,"}\n");
    }
      else
    if (loopcount==0)
    { 
      push(temptoken,t);
      fprintf(out,"exit();\n"); 
    }
      else
    { 
      if (strcasecmp(temptoken,"for")==0  ||
          strcasecmp(temptoken,"while")==0 || 
          strcasecmp(temptoken,"do")==0)
      { fprintf(out,"break;\n"); }
        else
      { push(temptoken,t); }
    }
  }
    else
  if (strcasecmp(token,"do")==0)
  { parse_do(); }
    else
  if (strcasecmp(token,"while")==0)
  { parse_while(); }
    else
  if (strcasecmp(token,"select")==0)
  { parse_select(); }
    else
  if (strcasecmp(token,"if")==0)
  { parse_if(); }
    else
  if (strcasecmp(token,"rem")==0)
  { parse_rem(); }
    else
  if (strcasecmp(token,"randomize")==0)
  { parse_randomize(); }
    else
  if (strcasecmp(token,"dim")==0)
  { parse_dim(); }
    else
  if (strcasecmp(token,"redim")==0)
  { parse_dim(); }
    else
  if (strcasecmp(token,"@language")==0)
  { parse_at_language(); }
    else
  if (strcasecmp(token,"option")==0)
  { fprintf(out,"// Option "); eval_expression(" ");  }
    else
  if (tokentype==2 && strcasecmp(token,"set")==0)
  {
    parse_set(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"sub")==0)
  { parse_funct(2); }
    else
  if (strcasecmp(token,"function")==0)
  { parse_funct(1); }
    else
  if (strcasecmp(token,"class")==0)
  { parse_class(); }
    else
  if (strcasecmp(token,"call")==0)
  {
    t=gettoken(token);
    convert_funct(molecule1,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15",4);
    fprintf(out,"%s%s;",token,molecule1);
  }
    else
  if (strcasecmp(token,"session")==0)
  { parse_session(); }
    else
  if (strcasecmp(token,"response")==0)
  { parse_response(); }
    else
  if (strcasecmp(token,"request")==0)
  {
    parse_request(newtoken);
    fprintf(out,"%s",newtoken); 
  }
    else
  if (strcasecmp(token,"const")==0)
  { 
    tokentype=gettoken(token);
    eval_expression(token); 
  }
    else
  if (strcasecmp(token,"public")==0 || strcasecmp(token,"private")==0)
  { 
    tokentype=gettoken(token);
    if (strcasecmp(token,"function")==0)
    { parse_funct(1); }
      else
    if (strcasecmp(token,"sub")==0)
    { parse_funct(2); }
      else
    if (strcasecmp(token,"property")==0)
    {
      tokentype=gettoken(token);
      parse_funct(1);
    }
      else
    {
      push(token,tokentype);
      parse_dim();
    }
  }
    else
  if (strcasecmp(token,"const")==0)
  { 
    tokentype=gettoken(token);
    eval_expression(token); 
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    parse_server(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"for")==0)
  { parse_for(); }
    else
  if (strcmp(token,"=")==0)
  {
    autoindent();
    fprintf(out,"echo ");
    eval_expression(" ");
  }
    else
  if (tokentype==2 && ((t=getobject(token))!=0))
  {
    parse_object(newtoken,token);

    autoindent();
    fprintf(out,"%s",newtoken);
  }
    else
  if (tokentype==11)
  {
    /* This kinda sucks but.. if token is 11 at the beginning of the line
    lets assume that it's a comment line.. this might cause problems..
    if you have problems, comment this crap out */
    fprintf(out,"//%s",&token[1]);
    ch=0;
    while (ch!='\r' && ch!='\n')
    {
      if (pushback!=-1)
      { ch=pushback; pushback=-1; }
        else
      { ch=getc(in); }
      if (ch==EOF) break;

      if (ch=='%')
      {
        ch=getc(in);
        if (ch=='>')
        {
          putc('?',out);
          putc('>',out);
          /* copyhtml(); */
          return 0;
        }
          else
        { putc('%',out);}
      }

      putc(ch,out);
    }
    line++;
    pushback=getc(in);
    if (pushback=='\n' || pushback=='\r')
    { if (ch!=pushback) pushback=-1; }
  }
    else
  { 
    if (isfunction(token)==1)
    {
      fprintf(out,"%s",token);
      convert_funct(newtoken,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15",4);
      fprintf(out,"%s",newtoken);
/*
      eval_element(newtoken,token,tokentype);
      fprintf(out,"%s",newtoken);
*/
    }
      else
    if (isclass(token)==1 || strcasecmp(token,"this")==0)
    {
      eval_element(newtoken,tokentype,token);
      fprintf(out,"%s;",newtoken);
    }
     else
    { 
      tokentype=gettoken(temptoken);
      if (strcmp(temptoken,".")==0)
      {
        fprintf(out,"$%s->",token);
        tokentype=gettoken(token);
        if (isfunction(token)==1)
        {
          convert_funct(molecule1,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15",4);
          fprintf(out,"%s%s;\n",token,molecule1);
        }
          else
        {
          fprintf(out,"%s",token);
          /* tokentype=gettoken(token); */
          eval_expression(" ");
        }
      }
        else
      {
        push(temptoken,tokentype);
        eval_expression(token); 
      }
    }
  }

  return 0;
}

int eval_molecule(char *newtoken)
{
char token[TOKENSIZE];
char temptoken[LINELENGTH];
int tokentype;
int isstring=0;
int r;
int paren=0;

  strcpy(newtoken,"");

  while((tokentype=gettoken(token))!=0)
  {
    if (strcmp(token,"(")==0) paren++;
      else
    if (strcmp(token,")")==0) paren--;

    if (paren<0) return 1;

    if (tokentype==10 || tokentype==11)
    { isstring=1; strcat(newtoken,token); }
      else
    if (tokentype==6)
    {
      push(token,tokentype);
      break;
    }
      else
    if (tokentype==5 || tokentype==13)
    { break; }
      else
    if (strcmp(token,"&")==0)
    { strcat(newtoken,"."); }
      else
    if (strcmp(token,",")==0)
    { return 2; }
      else
/*
    if (strcmp(token,"+")==0 && isstring==1)
    { strcat(newtoken,"."); }
      else
*/
    if (tokentype==2 && strcasecmp(token,"AND")==0)
    { strcat(newtoken,"&"); }
      else
    if (tokentype==2 && strcasecmp(token,"OR")==0)
    { strcat(newtoken,"|"); }
      else
    if (tokentype==1)
    { strcat(newtoken,token); }
      else
    if (tokentype==3)
    {
      strcat(newtoken,"\n");
      for (r=0; r<indent+1; r++) strcat(newtoken,"  ");
    }
      else
    if (tokentype!=2)
    { strcat(newtoken,token); }
      else
    {
      eval_element(temptoken,tokentype,token);
      strcat(newtoken,temptoken);
    }
  }

  return 0;
}

