/******************************************************************************
This file is part of the argtable library. It contains the example program
discussed in the "Introduction to argtable" document.

Copyright (C) 1998, 1999 Stewart Heitmann (Stewart.Heitmann@tip.csiro.au)

The argtable library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This software is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
USA.
******************************************************************************/
#include "argtable.h"

int main(int argc, char **argv) 
   { 
   static char str[50]; 
   static double grad; 
   static int c; 
   arg_rec argtable[] = 
     { 
       { "-tit ","<title>",  arg_str, str,   "noname", "\t\t title"        }, 
       { "grad:","gradient", arg_dbl, &grad, NULL,     "\t line gradient"  }, 
       { NULL,   "y-int",    arg_int, &c,    "0",      "\t\t y-intercept"  } 
     }; 
   const size_t narg = sizeof(argtable)/sizeof(arg_rec); 

  /*-- process the command line args --*/ 
  if (argc==1) 
     { 
     /*-- display program usage and exit. --*/ 
     printf("Usage: %s %s\n", argv[0], arg_syntax(argtable,narg)); 
     printf("%s\n",arg_glossary(argtable,narg,"   ")); 
     return 0; 
     } 
  else 
     { 
     /*-- scan command line arguments from argv[] --*/ 
     char cmdline[200], errmsg[200], errmark[200]; 
     if (!arg_scanargv(argc,argv,argtable,narg,cmdline,errmsg,errmark)) 
        { 
        /*-- arg error occurred, print error message and exit --*/ 
        printf("ERROR: %s\n", cmdline); 
        printf("       %s %s\n", errmark, errmsg); 
        return 1; 
        } 
      } 

  /*-- get here only if command line args ok --*/ 
  printf("title:       \"%s\"\n",str); 
  printf("gradient:    %f\n",grad); 
  printf("y-intercept: %d\n",c); 
  return 0; 
  } 
