<!-- Generated with Stardoc, Do Not Edit! -->


# Helper rules for Apple platforms

On this page:

  * [apple_genrule](#apple_genrule)
  * [toolchain_substitution](#toolchain_substitution)
  * [universal_binary](#universal_binary)

<a id="#apple_genrule"></a>

## apple_genrule

<pre>
apple_genrule(<a href="#apple_genrule-name">name</a>, <a href="#apple_genrule-cmd">cmd</a>, <a href="#apple_genrule-executable">executable</a>, <a href="#apple_genrule-message">message</a>, <a href="#apple_genrule-no_sandbox">no_sandbox</a>, <a href="#apple_genrule-outs">outs</a>, <a href="#apple_genrule-srcs">srcs</a>, <a href="#apple_genrule-tools">tools</a>)
</pre>

Genrule which provides Apple specific environment and make variables.

This mirrors the native genrule except that it provides a different set of
make variables. This rule will only run on a Mac.

Example of use:

```
load("@build_bazel_apple_support//rules:apple_genrule.bzl", "apple_genrule")

apple_genrule(
    name = "world",
    outs = ["hi"],
    cmd = "touch $@",
)
```

This rule also does location expansion, much like the native genrule.
For example, `$(location hi)` may be used to refer to the output in the
above example.

The set of make variables that are supported for this rule:

* `OUTS`: The outs list. If you have only one output file, you can also use
          `$@`.
* `SRCS`: The srcs list (or more precisely, the pathnames of the files
          corresponding to labels in the srcs list). If you have only one
          source file, you can also use `$<`.
* `<`: srcs, if it's a single file.
* `@`: outs, if it's a single file.
* `@D`: The output directory. If there is only one filename in outs, this
        expands to the directory containing that file. If there are
        multiple filenames, this variable instead expands to the package's
        root directory in the genfiles tree, even if all the generated
        files belong to the same subdirectory.

The following environment variables are added to the rule action:

* `DEVELOPER_DIR`: The base developer directory as defined on Apple
                   architectures, most commonly used in invoking Apple
                   tools such as xcrun.
* `SDKROOT`: The base SDK directory as defined on Apple architectures, most
             commonly used in invoking Apple tools such as xcrun.


**ATTRIBUTES**


| Name  | Description | Type | Mandatory | Default |
| :------------- | :------------- | :------------- | :------------- | :------------- |
| <a id="apple_genrule-name"></a>name |  A unique name for this target.   | <a href="https://bazel.build/docs/build-ref.html#name">Name</a> | required |  |
| <a id="apple_genrule-cmd"></a>cmd |  The command to run. Subject the variable substitution.   | String | required |  |
| <a id="apple_genrule-executable"></a>executable |  Declare output to be executable. Setting this flag to 1 means the output is an executable file and can be run using the run command. The genrule must produce exactly one output in this case.   | Boolean | optional | False |
| <a id="apple_genrule-message"></a>message |  A progress message to be reported as the rule runs.   | String | optional | "" |
| <a id="apple_genrule-no_sandbox"></a>no_sandbox |  If the sandbox should be disabled when the action is run.   | Boolean | optional | False |
| <a id="apple_genrule-outs"></a>outs |  A list of files generated by this rule. If the executable flag is set, outs must contain exactly one label.   | List of labels | required |  |
| <a id="apple_genrule-srcs"></a>srcs |  A list of inputs for this rule, such as source files to process.   | <a href="https://bazel.build/docs/build-ref.html#labels">List of labels</a> | optional | [] |
| <a id="apple_genrule-tools"></a>tools |  A list of tool dependencies for this rule, they will be available when the action is run.   | <a href="https://bazel.build/docs/build-ref.html#labels">List of labels</a> | optional | [] |


<a id="#toolchain_substitution"></a>

## toolchain_substitution

<pre>
toolchain_substitution(<a href="#toolchain_substitution-name">name</a>, <a href="#toolchain_substitution-src">src</a>, <a href="#toolchain_substitution-var_name">var_name</a>)
</pre>


Register a subsitution, from a variable to a file, for use in arguments in a
target's attributes. Useful for passing custom tools to a compile or link.

### Example:

```bzl
load("@build_bazel_apple_support//rules:toolchain_substitution.bzl", "toolchain_substitution")

toolchain_substitution(
    name = "resource_rules",
    src = "resource_rules.plist",
    var_name = "RULES",
)

ios_application(
    ...
    codesignopts = ["--resource-rules=$(RULES)"],
    codesign_inputs = [":resource_rules"],
    toolchains = [":resource_rules"],
)
```


**ATTRIBUTES**


| Name  | Description | Type | Mandatory | Default |
| :------------- | :------------- | :------------- | :------------- | :------------- |
| <a id="toolchain_substitution-name"></a>name |  A unique name for this target.   | <a href="https://bazel.build/docs/build-ref.html#name">Name</a> | required |  |
| <a id="toolchain_substitution-src"></a>src |  Source file to substitute   | <a href="https://bazel.build/docs/build-ref.html#labels">Label</a> | required |  |
| <a id="toolchain_substitution-var_name"></a>var_name |  Name of the variable to substitute, ex: FOO   | String | required |  |


<a id="#universal_binary"></a>

## universal_binary

<pre>
universal_binary(<a href="#universal_binary-name">name</a>, <a href="#universal_binary-binary">binary</a>)
</pre>


This rule produces a multi-architecture ("fat") binary targeting Apple macOS
platforms *regardless* of the architecture of the macOS host platform. The
`lipo` tool is used to combine built binaries of multiple architectures. For
non-macOS platforms, this simply just creates a symbolic link of the input
binary.


**ATTRIBUTES**


| Name  | Description | Type | Mandatory | Default |
| :------------- | :------------- | :------------- | :------------- | :------------- |
| <a id="universal_binary-name"></a>name |  A unique name for this target.   | <a href="https://bazel.build/docs/build-ref.html#name">Name</a> | required |  |
| <a id="universal_binary-binary"></a>binary |  Target to generate a 'fat' binary from.   | <a href="https://bazel.build/docs/build-ref.html#labels">Label</a> | required |  |


