/*
 *      wlan.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <ncurses.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include "ap-utils.h"
#include <menu.h>
#include <unistd.h>

#define HIDE_ESSID _("[S] Insert ESSID in broadcast packets: %s")
#define RETRAIN _("[U] AutoRateFallBack: %s")
#define PREAMBULE _("[P] Preambule type: %s")
#define RATES_RECORD "[%d]  %4.1fM   %s"

extern short ap_type;

void wireless()
{
    char operChannelID[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x01,
	0x00
    };
    char operESSIDLength[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x02,
	0x00
    };
    char operESSID[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x03,
	0x00
    };
    char operRTSThreshold[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x04,
	0x00
    };
    char operFragmentationThreshold[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x05,
	0x00
    };
    char operPreambleType[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x06,
	0x00
    };
    char operAuthenticationType[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x07,
	0x00
    };
    char operBasicRates[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x08,
	0x00
    };
    char operAutoRateFallBack[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x09,
	0x00
    };
    char operAccessPointName[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x0A,
	0x00
    };
    char operSSIDBroadcasting[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x0B,
	0x00
    };
    char sysDeviceInfo[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01,
	0x01, 0x05, 0x00
    };

    struct HARD_CONFIGURATION_STUCT *HardConf;
    unsigned short int i, RTSThreshold, FragmentationThreshold,
	m_basic_rates = 0, first_channel=1;
    char *AuthenticationTypes[3] =
	{ OSYS, SH_KEY, BOTH_TYPE }, message[1024];
    extern WINDOW *main_sub;
    char domain[32], basic_rates[4], AutoRateFallBack, SSIDBroadcasting,
	ap_name[32], ch_num = 0;
    char m_channel = 0, m_essid = 0, m_broadcast = 0, m_rts =
	0, m_fragment = 0, m_auth = 0, m_ap_name = 0, m_preambule =
	0, m_auto_rate = 0, PreambleType, AuthenticationType, channel;
    varbind varbinds[11];
    char *item_name[14], *rates[3] = { ON, OFF, BASIC }, *preambules[2] = {
    _("Short"), _("Long")};
    short __rates[4] = { 2, 4, 11, 22 };
    int c=0;

	if (ME102 == ap_type) {
	    	operChannelID[5] = 0xE0;
    		operESSIDLength[5] = 0xE0;
    		operESSID[5] = 0xE0;
    		operRTSThreshold[5] = 0xE0;
    		operFragmentationThreshold[5] = 0xE0;
    		operPreambleType[5] = 0xE0;
    		operAuthenticationType[5] = 0xE0;
    		operBasicRates[5] = 0xE0;
    		operAutoRateFallBack[5] = 0xE0;
    		operAccessPointName[5] = 0xE0;
    		operSSIDBroadcasting[5] = 0xE0;
    		sysDeviceInfo[5] = 0xE0;
                operChannelID[6] = 0x3e;
                operESSIDLength[6] = 0x3e;
                operESSID[6] = 0x3e;
                operRTSThreshold[6] = 0x3e;
                operFragmentationThreshold[6] = 0x3e;
                operPreambleType[6] = 0x3e;
                operAuthenticationType[6] = 0x3e;
                operBasicRates[6] = 0x3e;
                operAutoRateFallBack[6] = 0x3e;
                operAccessPointName[6] = 0x3e;
                operSSIDBroadcasting[6] = 0x3e;
                sysDeviceInfo[6] = 0x3e;
	}
    
    print_title(_("Wireless Settings"));
    print_help(WAIT_RET);

    for (i = 0; i < 11; i++) {
	varbinds[i].type = NULL_VALUE;
	varbinds[i].len_val = 0;
	varbinds[i].len_oid = sizeof(operChannelID);
    }
    varbinds[0].oid = operChannelID;
    varbinds[1].oid = operESSID;
    varbinds[2].oid = operSSIDBroadcasting;
    varbinds[3].oid = operBasicRates;
    varbinds[4].oid = operAutoRateFallBack;
    varbinds[5].oid = operRTSThreshold;
    varbinds[6].oid = operFragmentationThreshold;
    varbinds[7].oid = operPreambleType;
    varbinds[8].oid = operAuthenticationType;
    varbinds[9].oid = operAccessPointName;
    varbinds[10].oid = sysDeviceInfo;


    if (snmp(varbinds, 11, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }

    channel = *(varbinds[0].value);
    memcpy(domain, varbinds[1].value, 32);
    memcpy(basic_rates, varbinds[3].value, 4);
    AutoRateFallBack = *(varbinds[4].value);
    SSIDBroadcasting = *(varbinds[2].value);
    memcpy(&RTSThreshold, (varbinds[5].value), 2);
    RTSThreshold = ntohs(RTSThreshold);
    memcpy(&FragmentationThreshold, (varbinds[6].value), 2);
    FragmentationThreshold = ntohs(FragmentationThreshold);
    PreambleType = *(varbinds[7].value);
    AuthenticationType = *(varbinds[8].value);
    memcpy(ap_name, varbinds[9].value, 32);

    HardConf =
	(struct HARD_CONFIGURATION_STUCT *) malloc(varbinds[10].len_val);
    memcpy(HardConf, varbinds[10].value, varbinds[10].len_val);
    HardConf->RegulationDomain = swap4(HardConf->RegulationDomain);
    if ((ch_num = ch_list(HardConf->RegulationDomain, item_name)) == 0) {
	print_help(ERR_RET);
	goto exit;
    }
    if (HardConf->RegulationDomain == 0x31 || HardConf->RegulationDomain == 0x32)
	first_channel=10;
    free(HardConf);

    sprintf(message, CHANNEL, channel, 2407 + 5 * channel);
    mvwaddstr(main_sub, 0, 0, message);
    mvwaddstr(main_sub, 1, 0, ESSID);
    for (i = 0; i < 32 && *(domain + i); i++) {
	mvwaddch(main_sub, 1, i + 24, *(domain + i));
    }
    mvwaddstr(main_sub, 2, 0, BSS_NAME);
    for (i = 0; i < 32 && *(ap_name + i); i++)
	mvwaddch(main_sub, 2, i + 21, *(ap_name + i));
    sprintf(message, RTS_TR, RTSThreshold);
    mvwaddstr(main_sub, 3, 0, message);
    sprintf(message, FRG_TR, FragmentationThreshold);
    mvwaddstr(main_sub, 4, 0, message);
    sprintf(message, PREAMBULE, preambules[PreambleType - 1]);
    mvwaddstr(main_sub, 5, 0, message);
    sprintf(message, AUTH, AuthenticationTypes[AuthenticationType - 1]);
    mvwaddstr(main_sub, 6, 0, message);
    sprintf(message, RETRAIN, (AutoRateFallBack == 1) ? ON : OFF);
    mvwaddstr(main_sub, 7, 0, message);
    sprintf(message, HIDE_ESSID, (SSIDBroadcasting == 1) ? ON : OFF);
    mvwaddstr(main_sub, 8, 0, message);
    mvwaddstr(main_sub, 9, 0, RATES);
    mvwaddstr(main_sub, 10, 2, RATES_HEAD);
    for (i = 0; i < 4; i++) {
	sprintf(message, RATES_RECORD, i + 1, (float) __rates[i] / 2,
		basic(basic_rates[i]));
	mvwaddstr(main_sub, 11 + i, 2, message);
    }
    wrefresh(main_sub);
    noecho();
    print_help(_("[key] - set option; W - write conf; Q - quit to menu"));

    while (1) {
	c = getch();
	switch (c) {
	case 'Q':
	case 'q':
	    goto quit;
	case '1':
	case '2':
	case '3':
	case '4':
	    message[0] = c;
	    message[1] = '\0';
	    i = atoi(message);
	    switch (menu_choose(15, 10 + i, rates, 3)) {
	    case 0:
		basic_rates[i - 1] = __rates[i - 1];
		break;
	    case 1:
		basic_rates[i - 1] = 0;
		break;
	    case 2:
		basic_rates[i - 1] = __rates[i - 1] + 0x80;
	    }
	    sprintf(message, RATES_RECORD, i, (float) __rates[i - 1] / 2,
		    basic(basic_rates[i - 1]));
	    clear_main_new(10 + i, 11 + i);
	    mvwaddstr(main_sub, 10 + i, 2, message);
	    wrefresh(main_sub);
	    m_basic_rates = 1;
	    break;
	case 'C':
	case 'c':
	    channel = menu_choose(22, 0, item_name, ch_num) + first_channel;
	    m_channel = 1;
	    sprintf(message, CHANNEL, channel, 2407 + 5 * channel);
	    mvwaddstr(main_sub, 0, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'A':
	case 'a':
	    AuthenticationType =
		menu_choose(15, 6, AuthenticationTypes, 3) + 1;
	    m_auth = 1;
	    clear_main_new(6, 7);
	    sprintf(message, AUTH,
		    AuthenticationTypes[AuthenticationType - 1]);
	    mvwaddstr(main_sub, 6, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'P':
	case 'p':
	    PreambleType = menu_choose(20, 5, preambules, 2) + 1;;
	    m_preambule = 1;
	    clear_main_new(5, 6);
	    sprintf(message, PREAMBULE, preambules[PreambleType - 1]);
	    mvwaddstr(main_sub, 5, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'U':
	case 'u':
	    AutoRateFallBack = on_off(22, 7);
	    m_auto_rate = 1;
	    clear_main_new(7, 8);
	    sprintf(message, RETRAIN, (AutoRateFallBack == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 7, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'S':
	case 's':
	    SSIDBroadcasting = on_off(39, 8);
	    m_broadcast = 1;
	    clear_main_new(8, 9);
	    sprintf(message, HIDE_ESSID,
		    (SSIDBroadcasting == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 8, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'N':
	case 'n':
//          make_field(2, 21, 32);
	    get_value(ap_name, 2, 21, 32);
	    m_ap_name = 1;
	    continue;
	case 'D':
	case 'd':
//          make_field(1, 24, 32);
	    get_value(domain, 1, 24, 32);
	    m_essid = 1;
	    continue;
	case 'F':
	case 'f':
//          make_field(4, 29, 6);
	    get_value(message, 4, 29, 6);
	    FragmentationThreshold = atoi(message);
	    m_fragment = 1;
	    continue;
	case 'R':
	case 'r':
//          make_field(3, 19, 6);
	    get_value(message, 3, 19, 6);
	    RTSThreshold = atoi(message);
	    m_rts = 1;
	    continue;
	case 'w':
	case 'W':
	    i = 0;
	    if (m_channel) {
		varbinds[i].oid = operChannelID;
		varbinds[i].len_oid = sizeof(operChannelID);
		varbinds[i].value = (char *) &channel;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }

	    if (m_basic_rates) {
		for (m_basic_rates = 0; m_basic_rates < 2; m_basic_rates++) {
		    c = basic_rates[3 - m_basic_rates];
		    basic_rates[3 - m_basic_rates] =
			basic_rates[m_basic_rates];
		    basic_rates[m_basic_rates] = c;
		}
		varbinds[i].oid = operBasicRates;
		varbinds[i].len_oid = sizeof(operBasicRates);
		varbinds[i].value = basic_rates;
		varbinds[i].len_val = 4;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_broadcast) {
		varbinds[i].oid = operSSIDBroadcasting;
		varbinds[i].len_oid = sizeof(operSSIDBroadcasting);
		varbinds[i].value = (char *) &SSIDBroadcasting;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_auth) {
		varbinds[i].oid = operAuthenticationType;
		varbinds[i].len_oid = sizeof(operAuthenticationType);
		varbinds[i].value = &AuthenticationType;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_preambule) {
		varbinds[i].oid = operPreambleType;
		varbinds[i].len_oid = sizeof(operPreambleType);
		varbinds[i].value = &PreambleType;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_auto_rate) {
		varbinds[i].oid = operAutoRateFallBack;
		varbinds[i].len_oid = sizeof(operAutoRateFallBack);
		varbinds[i].value = &AutoRateFallBack;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_ap_name) {
		c = strlen(ap_name);
		varbinds[i].oid = operAccessPointName;
		varbinds[i].len_oid = sizeof(operAccessPointName);
		varbinds[i].value = ap_name;
		varbinds[i].len_val = c;
		varbinds[i].type = STRING_VALUE;
		i++;
	    }
	    if (m_fragment) {
		varbinds[i].oid = operFragmentationThreshold;
		varbinds[i].len_oid = sizeof(operFragmentationThreshold);
		FragmentationThreshold = htons(FragmentationThreshold);
		varbinds[i].value = (char *) &FragmentationThreshold;
		varbinds[i].len_val = 2;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_rts) {
		varbinds[i].oid = operRTSThreshold;
		varbinds[i].len_oid = sizeof(operRTSThreshold);
		RTSThreshold = htons(RTSThreshold);
		varbinds[i].value = (char *) &RTSThreshold;
		varbinds[i].len_val = 2;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_essid) {
		m_essid = strlen(domain);
		varbinds[i].oid = operESSIDLength;
		varbinds[i].len_oid = sizeof(operESSIDLength);
		varbinds[i].value = &m_essid;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
		varbinds[i].oid = operESSID;
		varbinds[i].len_oid = sizeof(operESSID);
		varbinds[i].value = domain;
		varbinds[i].len_val = m_essid;
		varbinds[i].type = STRING_VALUE;
		i++;
	    }
	    print_help(WAIT_SET);
	    if (snmp(varbinds, i, SET) <= 0) {
		print_help(ERR_SET);
		goto exit;
	    }
	    print_help(DONE_SET);
	    goto exit;
	}
    }

  exit:
    getch();
  quit:
    /* free memory allocated for channel list */
    for (i = 0; i < ch_num; i++)
	free(item_name[i]);

    print_title("");
    clear_main(0);
}

void nwn_wireless()
{
    char *item_name[14];

    char oid_dot11SupportedAntenna[][11] = {
	{0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x08, 0x01, 0x02, 0x01, 0x01},
	{0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x08, 0x01, 0x02, 0x01, 0x02},
	{0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x08, 0x01, 0x03, 0x01, 0x01},
	{0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x08, 0x01, 0x03, 0x01, 0x02},
	{0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x08, 0x01, 0x04, 0x01, 0x01},
	{0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x08, 0x01, 0x04, 0x01, 0x02}
    };

    char ChannelPref[] =
	{ 0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x02, 0x01,
	0x06, 0x00
    };
    char operChannelID[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x04, 0x05, 0x01, 0x01, 0x01 };
    char sysTrapSwitch[] =
	{ 0x2B, 0x06, 0x01, 0x02, 0x01, 0x0b, 0x1e, 0x00 };

    char operESSID[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x01, 0x01, 0x01, 0x09, 0x01 };

    char operRTSThreshold[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x02, 0x01, 0x01, 0x02, 0x01 };
    char operFragmentationThreshold[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x02, 0x01, 0x01, 0x05, 0x01 };
    char OpenSystem[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x01, 0x02, 0x01, 0x03, 0x01,
	0x01
    };
    char SharedKey[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x01, 0x02, 0x01, 0x03, 0x01,
	0x02
    };
    char operBasicRates[] =
	{ 0x2a, 0x86, 0x48, 0xce, 0x34, 0x01, 0x01, 0x01, 0xb, 0x01 };
    char operAccessPointName[] =
	{ 0x2b, 0x06, 0x01, 0x02, 0x01, 0x01, 0x05, 0x00 };
    char operAccessPointContact[] =
	{ 0x2b, 0x06, 0x01, 0x02, 0x01, 0x01, 0x04, 0x00 };
    char operAccessPointLocation[] =
	{ 0x2b, 0x06, 0x01, 0x02, 0x01, 0x01, 0x06, 0x00 };

    unsigned short int i, RTSThreshold, FragmentationThreshold,
	m_basic_rates = 0, authi;
    char *auth[3] = { OSYS, SH_KEY, BOTH_TYPE }, *rates[3] = {
    ON, OFF, BASIC}, message[1024], m_antenna[6] = {
    0, 0, 0, 0, 0, 0}, antenna[6], channel_pref[2] = {
    0, 0};
    extern WINDOW *main_sub;
    char *domain, basic_rates[] =
	{ 0, 0, 0, 0 }, *ap_name, ap_location[32], ap_contact[32],
	m_ap_contact = 0, m_ap_location = 0;
    char m_channel = 0, m_essid = 0, m_rts = 0, m_fragment = 0, m_auth =
	0, m_ap_name = 0, channel, traps, m_traps = 0;
    varbind varbinds[11];
    int c=0, ch_num = 0, first_channel=1, reg_domain=0;
    short __rates[4] = { 2, 4, 11, 22};

    domain = (char *) calloc(32, 1);
    ap_name = (char *) calloc(32, 1);

    for (i = 0; i < 8; i++) {
	varbinds[i].len_val = 0;
	varbinds[i].type = NULL_VALUE;
    }
    varbinds[0].oid = operChannelID;
    varbinds[0].len_oid = sizeof(operChannelID);
    varbinds[1].oid = operESSID;
    varbinds[1].len_oid = sizeof(operESSID);
    varbinds[2].oid = operRTSThreshold;
    varbinds[2].len_oid = sizeof(operRTSThreshold);
    varbinds[3].oid = operFragmentationThreshold;
    varbinds[3].len_oid = sizeof(operFragmentationThreshold);
    varbinds[4].oid = operBasicRates;
    varbinds[4].len_oid = sizeof(operBasicRates);
    varbinds[5].oid = OpenSystem;
    varbinds[5].len_oid = sizeof(OpenSystem);
    varbinds[6].oid = SharedKey;
    varbinds[6].len_oid = sizeof(SharedKey);
    varbinds[7].oid = operAccessPointName;
    varbinds[7].len_oid = sizeof(operAccessPointName);
    print_help(WAIT_RET);
    if (snmp(varbinds, 8, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }

    channel = *(varbinds[0].value);
    memcpy(domain, varbinds[1].value, varbinds[1].len_val);
    memcpy(basic_rates, varbinds[4].value, varbinds[4].len_val);
    memcpy(&RTSThreshold, (varbinds[2].value), 2);
    RTSThreshold = ntohs(RTSThreshold);
    memcpy(&FragmentationThreshold, (varbinds[3].value), 2);
    FragmentationThreshold = ntohs(FragmentationThreshold);
    authi = (*(varbinds[5].value) == 1 && *(varbinds[6].value) == 1) ? 2 :
	(*(varbinds[5].value) == 1) ? 0 : 1;
    memcpy(ap_name, varbinds[7].value, varbinds[7].len_val);

    sprintf(message, CHANNEL, channel, 2407 + 5 * channel);
    mvwaddstr(main_sub, 0, 0, message);
    mvwaddstr(main_sub, 1, 0, ESSID);
    for (i = 0; i < 32 && *(domain + i); i++) {
	mvwaddch(main_sub, 1, i + 25, *(domain + i));
    }
    mvwaddstr(main_sub, 2, 0, BSS_NAME);
    for (i = 0; i < 32 && ap_name[i]; i++)
	mvwaddch(main_sub, 2, i + 25, *(ap_name + i));
    sprintf(message, RTS_TR, RTSThreshold);
    mvwaddstr(main_sub, 3, 0, message);
    sprintf(message, FRG_TR, FragmentationThreshold);
    mvwaddstr(main_sub, 4, 0, message);
    sprintf(message, AUTH, auth[authi]);
    mvwaddstr(main_sub, 6, 0, message);
    mvwaddstr(main_sub, 9, 0, RATES);
    mvwaddstr(main_sub, 10, 2, RATES_HEAD);
    for(i=0; i<4; i++) {
        sprintf(message, RATES_RECORD, i+1, (float) __rates[i]/2, basic(basic_rates[i]));
        mvwaddstr(main_sub, 11+i, 2, message);
    }
    
    reg_domain = get_RegDomain();
    if ((ch_num = ch_list(reg_domain, item_name)) == 0) {
	print_help(ERR_RET);
	goto exit;
    }

    if(reg_domain == 0x31 || reg_domain == 0x32)
	first_channel = 10;
	
    for (i = 0; i < 9; i++) {
	varbinds[i].len_val = 0;
	varbinds[i].type = NULL_VALUE;
    }

    for (i = 0; i < 6; i++) {
	varbinds[i].oid = oid_dot11SupportedAntenna[i];
	varbinds[i].len_oid = sizeof(oid_dot11SupportedAntenna[i]);
    }
    varbinds[6].oid = sysTrapSwitch;
    varbinds[6].len_oid = sizeof(sysTrapSwitch);
    varbinds[7].oid = operAccessPointContact;
    varbinds[7].len_oid = sizeof(operAccessPointContact);
    varbinds[8].oid = operAccessPointLocation;
    varbinds[8].len_oid = sizeof(operAccessPointLocation);

    if (snmp(varbinds, 9, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }

    for (i = 0; i < 6; i++) {
	antenna[i] = *varbinds[i].value;
    }

    traps = *(varbinds[6].value);
    memcpy(ap_contact, varbinds[7].value, varbinds[7].len_val);
    if (varbinds[7].len_val < 32)
	ap_contact[varbinds[7].len_val] = '\0';
    memcpy(ap_location, varbinds[8].value, varbinds[8].len_val);
    if (varbinds[8].len_val < 32)
	ap_location[varbinds[8].len_val] = '\0';

    sprintf(message, _("[L] AP Location:         %s"), ap_location);
    mvwaddstr(main_sub, 7, 0, message);
    sprintf(message, _("[E] AP Contact:          %s"), ap_contact);
    mvwaddstr(main_sub, 8, 0, message);
    sprintf(message, TRAPS, (traps == 1) ? ON : OFF);
    mvwaddstr(main_sub, 5, 0, message);

    mvwaddstr(main_sub, 16, 0, _("Antenna Configuration:"));
    sprintf(message, ANTENNA_RX,
	    (antenna[2] == 1) ? ON : OFF, (antenna[3] == 1) ? ON : OFF);
    mvwaddstr(main_sub, 17, 1, message);
    sprintf(message, ANTENNA_TX,
	    (antenna[0] == 1) ? ON : OFF, (antenna[1] == 1) ? ON : OFF);
    mvwaddstr(main_sub, 18, 1, message);
    sprintf(message, ANTENNA_DV,
	    (antenna[4] == 1) ? ON : OFF, (antenna[5] == 1) ? ON : OFF);
    mvwaddstr(main_sub, 19, 1, message);


    print_title(_("General Options"));
    print_help(_
	       ("UIOPTY - antenna; SCANLEDFR1234 - options; W - write conf; Q - quit to menu"));
    wrefresh(main_sub);


    noecho();
    while (1) {
	c = getch();
	switch (c) {
	case 'i':
	case 'I':
	    antenna[3] = on_off(43, 17);
	    sprintf(message,
		    ANTENNA_RX,
		    (antenna[2] == 1) ? ON : OFF,
		    (antenna[3] == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 17, 1, message);
	    m_antenna[3] = 1;
	    wrefresh(main_sub);
	    continue;
	case 'u':
	case 'U':
	    antenna[2] = on_off(28, 17);
	    m_antenna[2] = 1;
	    sprintf(message,
		    ANTENNA_RX,
		    (antenna[2] == 1) ? ON : OFF,
		    (antenna[3] == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 17, 1, message);
	    wrefresh(main_sub);
	    continue;
	case 'p':
	case 'P':
	    antenna[1] = on_off(43, 18);
	    m_antenna[1] = 1;
	    sprintf(message,
		    ANTENNA_TX,
		    (antenna[0] == 1) ? ON : OFF,
		    (antenna[1] == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 18, 1, message);
	    wrefresh(main_sub);
	    continue;
	case 'o':
	case 'O':
	    antenna[0] = on_off(28, 18);
	    m_antenna[0] = 1;
	    sprintf(message,
		    ANTENNA_TX,
		    (antenna[0] == 1) ? ON : OFF,
		    (antenna[1] == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 18, 1, message);
	    wrefresh(main_sub);
	    continue;
	case 'T':
	case 't':
	    antenna[4] = on_off(28, 19);
	    m_antenna[4] = 1;
	    sprintf(message,
		    ANTENNA_DV,
		    (antenna[4] == 1) ? ON : OFF,
		    (antenna[5] == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 19, 1, message);
	    wrefresh(main_sub);
	    continue;
	case 'Y':
	case 'y':
	    antenna[5] = on_off(43, 19);
	    m_antenna[5] = 1;
	    sprintf(message,
		    ANTENNA_DV,
		    (antenna[4] == 1) ? ON : OFF,
		    (antenna[5] == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 19, 1, message);
	    wrefresh(main_sub);
	    continue;
	case 'S':
	case 's':
	    traps = on_off(21, 5);
	    clear_main_new(5, 6);
	    sprintf(message, TRAPS, (traps == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 5, 0, message);
	    wrefresh(main_sub);
	    m_traps = 1;
	    continue;
	case 'Q':
	case 'q':
	    goto quit;
        case '1':
	case '2':
	case '3':
	case '4':
		i = c - '0';
            switch (menu_choose(15, 10+i, rates, 3)) {
                case 0:
                    basic_rates[i-1] = __rates[i-1];
                    break;
                case 1:
                    basic_rates[i-1] = 0;
                    break;
                case 2:
                    basic_rates[i-1] = __rates[i-1] + 0x80;
                }
            sprintf(message, RATES_RECORD, i, (float) __rates[i-1]/2, basic(basic_rates[i-1]));
            clear_main_new(10+i, 11+i);
            mvwaddstr(main_sub, 10+i, 2, message);
            m_basic_rates = 1;
	    wrefresh(main_sub);
            break;
	case 'C':
	case 'c':
	    channel = menu_choose(21, 0, item_name, ch_num) + first_channel;
	    m_channel = 1;
	    sprintf(message, CHANNEL, channel, 2407 + 5 * channel);
	    mvwaddstr(main_sub, 0, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'A':
	case 'a':
	    authi = menu_choose(14, 6, auth, 3);
	    m_auth = 1;
	    clear_main_new(6, 7);
	    sprintf(message, AUTH, auth[authi]);
	    mvwaddstr(main_sub, 6, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'N':
	case 'n':
	    get_value(ap_name, 2, 25, 32);
	    m_ap_name = 1;
	    continue;
	case 'L':
	case 'l':
	    get_value(ap_location, 7, 25, 32);
	    m_ap_location = 1;
	    continue;
	case 'E':
	case 'e':
	    get_value(ap_contact, 8, 25, 32);
	    m_ap_contact = 1;
	    continue;
	case 'D':
	case 'd':
	    get_value(domain, 1, 25, 32);
	    m_essid = 1;
	    continue;
	case 'F':
	case 'f':
	    get_value(message, 4, 29, 6);
	    FragmentationThreshold = atoi(message);
	    if (FragmentationThreshold < 256
		|| FragmentationThreshold > 2346)
		FragmentationThreshold = 2346;
	    m_fragment = 1;
	    continue;
	case 'R':
	case 'r':
	    get_value(message, 3, 19, 6);
	    RTSThreshold = atoi(message);
	    if (RTSThreshold > 2347)
		RTSThreshold = 2347;
	    m_rts = 1;
	    continue;
	case 'w':
	case 'W':
	    i = 0;
	    if (m_channel) {
		channel_pref[0] = channel;
		varbinds[i].oid = ChannelPref;
		varbinds[i].len_oid = sizeof(ChannelPref);
		varbinds[i].value = channel_pref;
		varbinds[i].len_val = 2;
		varbinds[i].type = STRING_VALUE;
		i++;
		varbinds[i].oid = operChannelID;
		varbinds[i].len_oid = sizeof(operChannelID);
		varbinds[i].value = (char *) &channel;
		varbinds[i].len_val = 1;
		varbinds[i].type = 0x02;
		i++;
	    }

	    if (m_basic_rates) {
		varbinds[i].oid = operBasicRates;
		varbinds[i].len_oid = sizeof(operBasicRates);
		varbinds[i].value = basic_rates;
		varbinds[i].len_val = 4;
		varbinds[i].type = STRING_VALUE;
		i++;
	    }

		print_help(WAIT_SET);
		if (snmp(varbinds, i, SET) <= 0) {
		    print_help(ERR_SET);
		    goto exit;
		}
	    i = 0;

	    if (m_auth) {
		m_auth = (authi == 1) ? 2 : 1;
		m_basic_rates = (authi == 0) ? 2 : 1;
		varbinds[i].oid = OpenSystem;
		varbinds[i].len_oid = sizeof(OpenSystem);
		varbinds[i].value = (char *) &m_auth;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
		varbinds[i].oid = SharedKey;
		varbinds[i].len_oid = sizeof(SharedKey);
		varbinds[i].value = (char *) &m_basic_rates;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
		print_help(WAIT_SET);
		if (snmp(varbinds, i, SET) <= 0) {
		    print_help(ERR_SET);
		    goto exit;
		}
	    i = 0;

	    if (m_ap_name) {
		c = strlen(ap_name);
		varbinds[i].oid = operAccessPointName;
		varbinds[i].len_oid = sizeof(operAccessPointName);
		varbinds[i].value = ap_name;
		varbinds[i].len_val = c;
		varbinds[i].type = STRING_VALUE;
		i++;
	    }

	    if (m_ap_location) {
		c = strlen(ap_location);
		varbinds[i].oid = operAccessPointLocation;
		varbinds[i].len_oid = sizeof(operAccessPointLocation);
		varbinds[i].value = ap_location;
		varbinds[i].len_val = c;
		varbinds[i].type = STRING_VALUE;
		i++;
	    }

		print_help(WAIT_SET);
		if (snmp(varbinds, i, SET) <= 0) {
		    print_help(ERR_SET);
		    goto exit;
		}

	    i = 0;
	    if (m_ap_contact) {
		c = strlen(ap_contact);
		varbinds[i].oid = operAccessPointContact;
		varbinds[i].len_oid = sizeof(operAccessPointContact);
		varbinds[i].value = ap_contact;
		varbinds[i].len_val = c;
		varbinds[i].type = STRING_VALUE;
		i++;
	    }
	    if (m_fragment) {
		varbinds[i].oid = operFragmentationThreshold;
		varbinds[i].len_oid = sizeof(operFragmentationThreshold);
		FragmentationThreshold = htons(FragmentationThreshold);
		varbinds[i].value = (char *) &FragmentationThreshold;
		varbinds[i].len_val = 2;
		varbinds[i].type = 0x02;
		i++;
	    }
	    if (m_rts) {
		varbinds[i].oid = operRTSThreshold;
		varbinds[i].len_oid = sizeof(operRTSThreshold);
		RTSThreshold = htons(RTSThreshold);
		varbinds[i].value = (char *) &RTSThreshold;
		varbinds[i].len_val = 2;
		varbinds[i].type = 0x02;
		i++;
	    }
	    if (m_traps) {
		varbinds[i].oid = sysTrapSwitch;
		varbinds[i].len_oid = sizeof(sysTrapSwitch);
		varbinds[i].value = &traps;
		varbinds[i].len_val = 1;
		varbinds[i].type = 0x02;
		i++;
	    }
		print_help(WAIT_SET);
		if (snmp(varbinds, i, SET) <= 0) {
		    print_help(ERR_SET);
		    goto exit;
		}
	    c = 0;
	    for (i = 0; i < 4; i++)
		if (m_antenna[i]) {
		    varbinds[c].oid = oid_dot11SupportedAntenna[i];
		    varbinds[c].len_oid =
			sizeof(oid_dot11SupportedAntenna[i]);
		    varbinds[c].value = &antenna[i];
		    varbinds[c].len_val = 1;
		    varbinds[c].type = INT_VALUE;
		    c++;
		}
		print_help(WAIT_SET);
		if (snmp(varbinds, c, SET) <= 0) {
		    print_help(ERR_SET);
		    goto exit;
		}
	    c = 0;
	    for (i = i; i < 6; i++)
		if (m_antenna[i]) {
		    varbinds[c].oid = oid_dot11SupportedAntenna[i];
		    varbinds[c].len_oid =
			sizeof(oid_dot11SupportedAntenna[i]);
		    varbinds[c].value = &antenna[i];
		    varbinds[c].len_val = 1;
		    varbinds[c].type = INT_VALUE;
		    c++;
		}
		print_help(WAIT_SET);
		if (snmp(varbinds, c, SET) <= 0) {
		    print_help(ERR_SET);
		    goto exit;
	    }
	    i = 0;
	    if (m_essid) {
		c = strlen(domain);
		varbinds[i].oid = operESSID;
		varbinds[i].len_oid = sizeof(operESSID);
		varbinds[i].value = domain;
		varbinds[i].len_val = c;
		varbinds[i].type = 0x04;
		i++;
	    }
		print_help(WAIT_SET);
		if (snmp(varbinds, i, SET) <= 0) {
		    print_help(ERR_SET);
		    goto exit;
		}

	    print_help(DONE_SET);
	    goto exit;
	default:
	    continue;
	}
    }

  exit:
    getch();
  quit:
    print_title("");

    /* free memory allocated for channel list */
    for (i = 0; i < ch_num; i++)
	free(item_name[i]);
    free(domain);
    free(ap_name);
    clear_main(0);
}
