/*
 *      auth.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <ncurses.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include "ap-utils.h"

extern WINDOW *main_sub;
extern short ap_type;

void AuthorizedSettings()
{

    char AuthorizedUserPass[3][12] = {
	{0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x09, 0x01,
	 0x00},
	{0x2B, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x02, 0x01, 0x02, 0x01,
	 0x00},
       {0x2B, 0x06, 0x01, 0x04, 0x01, 0xe0, 0x3e, 0x01, 0x01, 0x09, 0x01,
	 0x00}
    };
    char AuthorizedAdminPass[3][12] = {
	{0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x09, 0x02,
	 0x00},
	{0x2B, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x02, 0x01, 0x02, 0x02,
	 0x00},
        {0x2B, 0x06, 0x01, 0x04, 0x01, 0xe0, 0x3e, 0x01, 0x01, 0x09, 0x02,
         0x00}
    };
    char AuthorizedManufactPass[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x09, 0x03,
	0x00
    };

    varbind varbinds[3];
    char user[16], admin[16], manufact[16];
    int i;

	if (ME102 == ap_type) {
		AuthorizedManufactPass[5] = 0xe0;
		AuthorizedManufactPass[6] = 0x3e;
	}
    user[0] = admin[0] = manufact[0] = '\0';
    print_title(COMMUNITY_TOP_HEADER);

    mvwaddstr(main_sub, 0, 0, COMMUNITY_HEADER1);
    mvwaddstr(main_sub, 0, 25, COMMUNITY_HEADER2);
    mvwaddstr(main_sub, 1, 0, COMMUNITY_USER);
    mvwaddstr(main_sub, 2, 0, COMMUNITY_ADMIN);

    if (ap_type == ATMEL || ME102 == ap_type) {
	mvwaddstr(main_sub, 3, 0, _("[M] Manufacturer"));
    }
    wrefresh(main_sub);

    noecho();
    print_help(COMMUNITY_HELP);
    while (1) {
	switch (getch()) {
	default:
	    continue;
	case 'U':
	case 'u':
	    get_value(user, 1, 25, sizeof(user));
	    continue;
	case 'A':
	case 'a':
	    get_value(admin, 2, 25, sizeof(admin));
	    continue;
	case 'M':
	case 'm':
	    if (ap_type == ATMEL  || ME102 == ap_type)
		get_value(manufact, 3, 25, sizeof(manufact));
	    continue;
	case 'Q':
	case 'q':
	    goto quit;
	case 'W':
	case 'w':
	    i = 0;
	    if (strlen(user)) {
		varbinds[i].oid = AuthorizedUserPass[ap_type];
		varbinds[i].len_oid = sizeof(AuthorizedUserPass[ap_type]);
		varbinds[i].value = user;
		varbinds[i].len_val = strlen(user);
		varbinds[i].type = STRING_VALUE;
		i++;
	    }
	    if (strlen(admin)) {
		varbinds[i].oid = AuthorizedAdminPass[ap_type];
		varbinds[i].len_oid = sizeof(AuthorizedAdminPass[ap_type]);
		varbinds[i].value = admin;
		varbinds[i].len_val = strlen(admin);
		varbinds[i].type = STRING_VALUE;
		i++;
	    }
	    if ((ap_type == ATMEL || ME102 == ap_type) && strlen(manufact)) {
		varbinds[i].oid = AuthorizedManufactPass;
		varbinds[i].len_oid = sizeof(AuthorizedManufactPass);
		varbinds[i].value = manufact;
		varbinds[i].len_val = strlen(manufact);
		varbinds[i].type = STRING_VALUE;
		i++;
	    }
	    print_help(WAIT_SET);
	    if (snmp(varbinds, i, SET) <= 0) {
		print_help(ERR_SET);
		goto exit;
	    }
	    break;
	}
	break;
    }

    print_help(DONE_SET);
  exit:
    getch();
  quit:
    print_help("");
    print_title("");
    clear_main(0);
}
