/*
 *      oui.c from Wireless Access Point Utilites for Unix
 *	Transform OUI to Manufacturer name
 * 
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 */

#include "ap-utils.h"

char *oui2manufacturer(char *mac)
{

    struct oui {
	char oui1;
	char oui2;
	char oui3;
	char *organization;
    } oui_list[] = {
	{
	0x00, 0x00, 0x00, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x01, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x02, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x03, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x04, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x05, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x06, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x07, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x08, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x09, "XEROX CORPORATION"}, {
	0x00, 0x00, 0x0A, "OMRON TATEISI ELECTRONICS CO."}, {
	0x00, 0x00, 0x0B, "MATRIX CORPORATION"}, {
	0x00, 0x00, 0x0C, "CISCO SYSTEMS, INC."}, {
	0x00, 0x00, 0x0D, "FIBRONICS LTD."}, {
	0x00, 0x00, 0x0E, "FUJITSU LIMITED"}, {
	0x00, 0x00, 0x0F, "NEXT, INC."}, {
	0x00, 0x00, 0x10, "SYTEK INC."}, {
	0x00, 0x00, 0x11, "NORMEREL SYSTEMES"}, {
	0x00, 0x00, 0x12, "INFORMATION TECHNOLOGY LIMITED"}, {
	0x00, 0x00, 0x13, "CAMEX"}, {
	0x00, 0x00, 0x14, "NETRONIX"}, {
	0x00, 0x00, 0x15, "DATAPOINT CORPORATION"}, {
	0x00, 0x00, 0x16, "DU PONT PIXEL SYSTEMS     ."}, {
	0x00, 0x00, 0x18, "WEBSTER COMPUTER CORPORATION"}, {
	0x00, 0x00, 0x19, "APPLIED DYNAMICS INTERNATIONAL"}, {
	0x00, 0x00, 0x1A, "ADVANCED MICRO DEVICES"}, {
	0x00, 0x00, 0x1B, "NOVELL INC."}, {
	0x00, 0x00, 0x1C, "BELL TECHNOLOGIES"}, {
	0x00, 0x00, 0x1D, "CABLETRON SYSTEMS, INC."}, {
	0x00, 0x00, 0x1E, "TELSIST INDUSTRIA ELECTRONICA"}, {
	0x00, 0x00, 0x1F, "Telco Systems, Inc."}, {
	0x00, 0x00, 0x20, "DATAINDUSTRIER DIAB AB"}, {
	0x00, 0x00, 0x21, "SUREMAN COMP. & COMMUN. CORP."}, {
	0x00, 0x00, 0x22, "VISUAL TECHNOLOGY INC."}, {
	0x00, 0x00, 0x23, "ABB INDUSTRIAL SYSTEMS AB"}, {
	0x00, 0x00, 0x24, "CONNECT AS"}, {
	0x00, 0x00, 0x25, "RAMTEK CORP."}, {
	0x00, 0x00, 0x26, "SHA-KEN CO., LTD."}, {
	0x00, 0x00, 0x27, "JAPAN RADIO COMPANY"}, {
	0x00, 0x00, 0x28, "PRODIGY SYSTEMS CORPORATION"}, {
	0x00, 0x00, 0x29, "IMC NETWORKS CORP."}, {
	0x00, 0x00, 0x2A, "TRW - SEDD/INP"}, {
	0x00, 0x00, 0x2B, "CRISP AUTOMATION, INC"}, {
	0x00, 0x00, 0x2C, "AUTOTOTE LIMITED"}, {
	0x00, 0x00, 0x2D, "CHROMATICS INC"}, {
	0x00, 0x00, 0x2E, "SOCIETE EVIRA"}, {
	0x00, 0x00, 0x2F, "TIMEPLEX INC."}, {
	0x00, 0x00, 0x30, "VG LABORATORY SYSTEMS LTD"}, {
	0x00, 0x00, 0x31, "QPSX COMMUNICATIONS PTY LTD"}, {
	0x00, 0x00, 0x32, "Marconi plc"}, {
	0x00, 0x00, 0x33, "EGAN MACHINERY COMPANY"}, {
	0x00, 0x00, 0x34, "NETWORK RESOURCES CORPORATION"}, {
	0x00, 0x00, 0x35, "SPECTRAGRAPHICS CORPORATION"}, {
	0x00, 0x00, 0x36, "ATARI CORPORATION"}, {
	0x00, 0x00, 0x37, "OXFORD METRICS LIMITED"}, {
	0x00, 0x00, 0x38, "CSS LABS"}, {
	0x00, 0x00, 0x39, "TOSHIBA CORPORATION"}, {
	0x00, 0x00, 0x3A, "CHYRON CORPORATION"}, {
	0x00, 0x00, 0x3B, "i Controls, Inc."}, {
	0x00, 0x00, 0x3C, "AUSPEX SYSTEMS INC."}, {
	0x00, 0x00, 0x3D, "UNISYS"}, {
	0x00, 0x00, 0x3E, "SIMPACT"}, {
	0x00, 0x00, 0x3F, "SYNTREX, INC."}, {
	0x00, 0x00, 0x40, "APPLICON, INC."}, {
	0x00, 0x00, 0x41, "ICE CORPORATION"}, {
	0x00, 0x00, 0x42, "METIER MANAGEMENT SYSTEMS LTD."}, {
	0x00, 0x00, 0x43, "MICRO TECHNOLOGY"}, {
	0x00, 0x00, 0x44, "CASTELLE CORPORATION"}, {
	0x00, 0x00, 0x45, "FORD AEROSPACE & COMM. CORP."}, {
	0x00, 0x00, 0x46, "OLIVETTI NORTH AMERICA"}, {
	0x00, 0x00, 0x47, "NICOLET INSTRUMENTS CORP."}, {
	0x00, 0x00, 0x48, "SEIKO EPSON CORPORATION"}, {
	0x00, 0x00, 0x49, "APRICOT COMPUTERS, LTD"}, {
	0x00, 0x00, 0x4A, "ADC CODENOLL TECHNOLOGY CORP."}, {
	0x00, 0x00, 0x4B, "ICL DATA OY"}, {
	0x00, 0x00, 0x4C, "NEC CORPORATION"}, {
	0x00, 0x00, 0x4D, "DCI CORPORATION"}, {
	0x00, 0x00, 0x4E, "AMPEX CORPORATION"}, {
	0x00, 0x00, 0x4F, "LOGICRAFT, INC."}, {
	0x00, 0x00, 0x50, "RADISYS CORPORATION"}, {
	0x00, 0x00, 0x51, "HOB ELECTRONIC GMBH & CO. KG"}, {
	0x00, 0x00, 0x52, "Intrusion.com, Inc."}, {
	0x00, 0x00, 0x53, "COMPUCORP"}, {
	0x00, 0x00, 0x54, "MODICON, INC."}, {
	0x00, 0x00, 0x55, "COMMISSARIAT A L`ENERGIE ATOM."}, {
	0x00, 0x00, 0x56, "DR. B. STRUCK"}, {
	0x00, 0x00, 0x57, "SCITEX CORPORATION LTD."}, {
	0x00, 0x00, 0x58, "RACORE COMPUTER PRODUCTS INC."}, {
	0x00, 0x00, 0x59, "HELLIGE GMBH"}, {
	0x00, 0x00, 0x5A, "SysKonnect GmbH"}, {
	0x00, 0x00, 0x5B, "ELTEC ELEKTRONIK AG"}, {
	0x00, 0x00, 0x5C, "TELEMATICS INTERNATIONAL INC."}, {
	0x00, 0x00, 0x5D, "CS TELECOM"}, {
	0x00, 0x00, 0x5E, "USC INFORMATION SCIENCES INST"}, {
	0x00, 0x00, 0x5F, "SUMITOMO ELECTRIC IND., LTD."}, {
	0x00, 0x00, 0x60, "KONTRON ELEKTRONIK GMBH"}, {
	0x00, 0x00, 0x61, "GATEWAY COMMUNICATIONS"}, {
	0x00, 0x00, 0x62, "BULL HN INFORMATION SYSTEMS"}, {
	0x00, 0x00, 0x63, "DR.ING.SEUFERT GMBH"}, {
	0x00, 0x00, 0x64, "YOKOGAWA DIGITAL COMPUTER CORP"}, {
	0x00, 0x00, 0x65, "NETWORK ASSOCIATES, INC."}, {
	0x00, 0x00, 0x66, "TALARIS SYSTEMS, INC."}, {
	0x00, 0x00, 0x67, "SOFT * RITE, INC."}, {
	0x00, 0x00, 0x68, "ROSEMOUNT CONTROLS"}, {
	0x00, 0x00, 0x69, "CONCORD COMMUNICATIONS INC"}, {
	0x00, 0x00, 0x6A, "COMPUTER CONSOLES INC."}, {
	0x00, 0x00, 0x6B, "SILICON GRAPHICS INC./MIPS"}, {
	0x00, 0x00, 0x6D, "CRAY COMMUNICATIONS, LTD."}, {
	0x00, 0x00, 0x6E, "ARTISOFT, INC."}, {
	0x00, 0x00, 0x6F, "MADGE NETWORKS LTD."}, {
	0x00, 0x00, 0x70, "HCL LIMITED"}, {
	0x00, 0x00, 0x71, "ADRA SYSTEMS INC."}, {
	0x00, 0x00, 0x72, "MINIWARE TECHNOLOGY"}, {
	0x00, 0x00, 0x73, "SIECOR CORPORATION"}, {
	0x00, 0x00, 0x74, "RICOH COMPANY LTD."}, {
	0x00, 0x00, 0x75, "Nortel Networks"}, {
	0x00, 0x00, 0x76, "ABEKAS VIDEO SYSTEM"}, {
	0x00, 0x00, 0x77, "INTERPHASE CORPORATION"}, {
	0x00, 0x00, 0x78, "LABTAM LIMITED"}, {
	0x00, 0x00, 0x79, "NETWORTH INCORPORATED"}, {
	0x00, 0x00, 0x7A, "DANA COMPUTER INC."}, {
	0x00, 0x00, 0x7B, "RESEARCH MACHINES"}, {
	0x00, 0x00, 0x7C, "AMPERE INCORPORATED"}, {
	0x00, 0x00, 0x7D, "SUN MICROSYSTEMS, INC."}, {
	0x00, 0x00, 0x7E, "CLUSTRIX CORPORATION"}, {
	0x00, 0x00, 0x7F, "LINOTYPE-HELL AG"}, {
	0x00, 0x00, 0x80, "CRAY COMMUNICATIONS A/S"}, {
	0x00, 0x00, 0x81, "BAY NETWORKS"}, {
	0x00, 0x00, 0x82, "LECTRA SYSTEMES SA"}, {
	0x00, 0x00, 0x83, "TADPOLE TECHNOLOGY PLC"}, {
	0x00, 0x00, 0x84, "SUPERNET"}, {
	0x00, 0x00, 0x85, "CANON INC."}, {
	0x00, 0x00, 0x86, "MEGAHERTZ CORPORATION"}, {
	0x00, 0x00, 0x87, "HITACHI, LTD."}, {
	0x00, 0x00, 0x88, "COMPUTER NETWORK TECH. CORP."}, {
	0x00, 0x00, 0x89, "CAYMAN SYSTEMS INC."}, {
	0x00, 0x00, 0x8A, "DATAHOUSE INFORMATION SYSTEMS"}, {
	0x00, 0x00, 0x8B, "INFOTRON"}, {
	0x00, 0x00, 0x8C, "ALLOY COMPUTER PRODUCTS, INC."}, {
	0x00, 0x00, 0x8D, "VERDIX CORPORATION"}, {
	0x00, 0x00, 0x8E, "SOLBOURNE COMPUTER, INC."}, {
	0x00, 0x00, 0x8F, "RAYTHEON COMPANY"}, {
	0x00, 0x00, 0x90, "MICROCOM"}, {
	0x00, 0x00, 0x91, "ANRITSU CORPORATION"}, {
	0x00, 0x00, 0x92, "COGENT DATA TECHNOLOGIES"}, {
	0x00, 0x00, 0x93, "PROTEON INC."}, {
	0x00, 0x00, 0x94, "ASANTE TECHNOLOGIES"}, {
	0x00, 0x00, 0x95, "SONY TEKTRONIX CORP."}, {
	0x00, 0x00, 0x96, "MARCONI ELECTRONICS LTD."}, {
	0x00, 0x00, 0x97, "EPOCH SYSTEMS"}, {
	0x00, 0x00, 0x98, "CROSSCOMM CORPORATION"}, {
	0x00, 0x00, 0x99, "MTX, INC."}, {
	0x00, 0x00, 0x9A, "RC COMPUTER A/S"}, {
	0x00, 0x00, 0x9B, "INFORMATION INTERNATIONAL, INC"}, {
	0x00, 0x00, 0x9C, "ROLM MIL-SPEC COMPUTERS"}, {
	0x00, 0x00, 0x9D, "LOCUS COMPUTING CORPORATION"}, {
	0x00, 0x00, 0x9E, "MARLI S.A."}, {
	0x00, 0x00, 0x9F, "AMERISTAR TECHNOLOGIES INC."}, {
	0x00, 0x00, 0xA0, "TOKYO SANYO ELECTRIC CO. LTD."}, {
	0x00, 0x00, 0xA1, "MARQUETTE ELECTRIC CO."}, {
	0x00, 0x00, 0xA2, "BAY NETWORKS"}, {
	0x00, 0x00, 0xA3, "NETWORK APPLICATION TECHNOLOGY"}, {
	0x00, 0x00, 0xA4, "ACORN COMPUTERS LIMITED"}, {
	0x00, 0x00, 0xA5, "COMPATIBLE SYSTEMS CORP."}, {
	0x00, 0x00, 0xA6, "NETWORK GENERAL CORPORATION"}, {
	0x00, 0x00, 0xA7, "NETWORK COMPUTING DEVICES INC."}, {
	0x00, 0x00, 0xA8, "STRATUS COMPUTER INC."}, {
	0x00, 0x00, 0xA9, "NETWORK SYSTEMS CORP."}, {
	0x00, 0x00, 0xAA, "XEROX CORPORATION"}, {
	0x00, 0x00, 0xAB, "LOGIC MODELING CORPORATION"}, {
	0x00, 0x00, 0xAC, "CONWARE COMPUTER CONSULTING"}, {
	0x00, 0x00, 0xAD, "BRUKER INSTRUMENTS INC."}, {
	0x00, 0x00, 0xAE, "DASSAULT ELECTRONIQUE"}, {
	0x00, 0x00, 0xAF, "NUCLEAR DATA INSTRUMENTATION"}, {
	0x00, 0x00, 0xB0, "RND-RAD NETWORK DEVICES"}, {
	0x00, 0x00, 0xB1, "ALPHA MICROSYSTEMS INC."}, {
	0x00, 0x00, 0xB2, "TELEVIDEO SYSTEMS, INC."}, {
	0x00, 0x00, 0xB3, "CIMLINC INCORPORATED"}, {
	0x00, 0x00, 0xB4, "EDIMAX COMPUTER COMPANY"}, {
	0x00, 0x00, 0xB5, "DATABILITY SOFTWARE SYS. INC."}, {
	0x00, 0x00, 0xB6, "MICRO-MATIC RESEARCH"}, {
	0x00, 0x00, 0xB7, "DOVE COMPUTER CORPORATION"}, {
	0x00, 0x00, 0xB8, "SEIKOSHA CO., LTD."}, {
	0x00, 0x00, 0xB9, "MCDONNELL DOUGLAS COMPUTER SYS"}, {
	0x00, 0x00, 0xBA, "SIIG, INC."}, {
	0x00, 0x00, 0xBB, "TRI-DATA"}, {
	0x00, 0x00, 0xBC, "ALLEN-BRADLEY CO. INC."}, {
	0x00, 0x00, 0xBD, "MITSUBISHI CABLE COMPANY"}, {
	0x00, 0x00, 0xBE, "THE NTI GROUP"}, {
	0x00, 0x00, 0xBF, "SYMMETRIC COMPUTER SYSTEMS"}, {
	0x00, 0x00, 0xC0, "WESTERN DIGITAL CORPORATION"}, {
	0x00, 0x00, 0xC1, "Madge Networks Ltd."}, {
	0x00, 0x00, 0xC2, "INFORMATION PRESENTATION TECH."}, {
	0x00, 0x00, 0xC3, "HARRIS CORP COMPUTER SYS DIV"}, {
	0x00, 0x00, 0xC4, "WATERS DIV. OF MILLIPORE"}, {
	0x00, 0x00, 0xC5, "FARALLON COMPUTING/NETOPIA"}, {
	0x00, 0x00, 0xC6, "EON SYSTEMS"}, {
	0x00, 0x00, 0xC7, "ARIX CORPORATION"}, {
	0x00, 0x00, 0xC8, "ALTOS COMPUTER SYSTEMS"}, {
	0x00, 0x00, 0xC9, "EMULEX CORPORATION"}, {
	0x00, 0x00, 0xCA, "APPLITEK"}, {
	0x00, 0x00, 0xCB, "COMPU-SHACK ELECTRONIC GMBH"}, {
	0x00, 0x00, 0xCC, "DENSAN CO., LTD."}, {
	0x00, 0x00, 0xCD, "Centrecom Systems, Ltd."}, {
	0x00, 0x00, 0xCE, "MEGADATA CORP."}, {
	0x00, 0x00, 0xCF, "HAYES MICROCOMPUTER PRODUCTS"}, {
	0x00, 0x00, 0xD0, "DEVELCON ELECTRONICS LTD."}, {
	0x00, 0x00, 0xD1, "ADAPTEC INCORPORATED"}, {
	0x00, 0x00, 0xD2, "SBE, INC."}, {
	0x00, 0x00, 0xD3, "WANG LABORATORIES INC."}, {
	0x00, 0x00, 0xD4, "PURE DATA LTD."}, {
	0x00, 0x00, 0xD5, "MICROGNOSIS INTERNATIONAL"}, {
	0x00, 0x00, 0xD6, "PUNCH LINE HOLDING"}, {
	0x00, 0x00, 0xD7, "DARTMOUTH COLLEGE"}, {
	0x00, 0x00, 0xD8, "NOVELL, INC."}, {
	0x00, 0x00, 0xD9, "NIPPON TELEGRAPH & TELEPHONE"}, {
	0x00, 0x00, 0xDA, "ATEX"}, {
	0x00, 0x00, 0xDB, "BRITISH TELECOMMUNICATIONS PLC"}, {
	0x00, 0x00, 0xDC, "HAYES MICROCOMPUTER PRODUCTS"}, {
	0x00, 0x00, 0xDD, "TCL INCORPORATED"}, {
	0x00, 0x00, 0xDE, "CETIA"}, {
	0x00, 0x00, 0xDF, "BELL & HOWELL PUB SYS DIV"}, {
	0x00, 0x00, 0xE0, "QUADRAM CORP."}, {
	0x00, 0x00, 0xE1, "GRID SYSTEMS"}, {
	0x00, 0x00, 0xE2, "ACER TECHNOLOGIES CORP."}, {
	0x00, 0x00, 0xE3, "INTEGRATED MICRO PRODUCTS LTD"}, {
	0x00, 0x00, 0xE4, "IN2 GROUPE INTERTECHNIQUE"}, {
	0x00, 0x00, 0xE5, "SIGMEX LTD."}, {
	0x00, 0x00, 0xE6, "APTOR PRODUITS DE COMM INDUST"}, {
	0x00, 0x00, 0xE7, "STAR GATE TECHNOLOGIES"}, {
	0x00, 0x00, 0xE8, "ACCTON TECHNOLOGY CORP."}, {
	0x00, 0x00, 0xE9, "ISICAD, INC."}, {
	0x00, 0x00, 0xEA, "UPNOD AB"}, {
	0x00, 0x00, 0xEB, "MATSUSHITA COMM. IND. CO. LTD."}, {
	0x00, 0x00, 0xEC, "MICROPROCESS"}, {
	0x00, 0x00, 0xED, "APRIL"}, {
	0x00, 0x00, 0xEE, "NETWORK DESIGNERS, LTD."}, {
	0x00, 0x00, 0xEF, "KTI"}, {
	0x00, 0x00, 0xF0, "SAMSUNG ELECTRONICS CO., LTD."}, {
	0x00, 0x00, 0xF1, "MAGNA COMPUTER CORPORATION"}, {
	0x00, 0x00, 0xF2, "SPIDER COMMUNICATIONS"}, {
	0x00, 0x00, 0xF3, "GANDALF DATA LIMITED"}, {
	0x00, 0x00, 0xF4, "ALLIED TELESYN INTERNATIONAL"}, {
	0x00, 0x00, 0xF5, "DIAMOND SALES LIMITED"}, {
	0x00, 0x00, 0xF6, "APPLIED MICROSYSTEMS CORP."}, {
	0x00, 0x00, 0xF7, "YOUTH KEEP ENTERPRISE CO LTD"}, {
	0x00, 0x00, 0xF8, "DIGITAL EQUIPMENT CORPORATION"}, {
	0x00, 0x00, 0xF9, "QUOTRON SYSTEMS INC."}, {
	0x00, 0x00, 0xFA, "MICROSAGE COMPUTER SYSTEMS INC"}, {
	0x00, 0x00, 0xFB, "RECHNER ZUR KOMMUNIKATION"}, {
	0x00, 0x00, 0xFC, "MEIKO"}, {
	0x00, 0x00, 0xFD, "HIGH LEVEL HARDWARE"}, {
	0x00, 0x00, 0xFE, "ANNAPOLIS MICRO SYSTEMS"}, {
	0x00, 0x00, 0xFF, "CAMTEC ELECTRONICS LTD."}, {
	0x00, 0x01, 0x00, "EQUIP'TRANS"}, {
	0x00, 0x01, 0x02, "3COM CORPORATION"}, {
	0x00, 0x01, 0x03, "3COM CORPORATION"}, {
	0x00, 0x01, 0x04, "DVICO Co., Ltd."}, {
	0x00, 0x01, 0x05, "BECKHOFF GmbH"}, {
	0x00, 0x01, 0x06, "Tews Datentechnik GmbH"}, {
	0x00, 0x01, 0x07, "Leiser GmbH"}, {
	0x00, 0x01, 0x08, "AVLAB Technology, Inc."}, {
	0x00, 0x01, 0x09, "Nagano Japan Radio Co., Ltd."}, {
	0x00, 0x01, 0x0A, "CIS TECHNOLOGY INC."}, {
	0x00, 0x01, 0x0B, "Space CyberLink, Inc."}, {
	0x00, 0x01, 0x0C, "System Talks Inc."}, {
	0x00, 0x01, 0x0D, "CORECO, INC."}, {
	0x00, 0x01, 0x0E, "Bri-Link Technologies Co., Ltd"}, {
	0x00, 0x01, 0x0F, "Nishan Systems, Inc."}, {
	0x00, 0x01, 0x10, "Gotham Networks"}, {
	0x00, 0x01, 0x11, "iDigm Inc."}, {
	0x00, 0x01, 0x12, "Shark Multimedia Inc."}, {
	0x00, 0x01, 0x13, "OLYMPUS OPTICAL CO., LTD."}, {
	0x00, 0x01, 0x14, "KANDA TSUSHIN KOGYO CO., LTD."}, {
	0x00, 0x01, 0x15, "EXTRATECH CORPORATION"}, {
	0x00, 0x01, 0x16, "Netspect Technologies, Inc."}, {
	0x00, 0x01, 0x17, "CANAL +"}, {
	0x00, 0x01, 0x18, "EZ Digital Co., Ltd."}, {
	0x00, 0x01, 0x19, "Action Controls Pty. Ltd."}, {
	0x00, 0x01, 0x1A, "EEH DataLink GmbH"}, {
	0x00, 0x01, 0x1B, "Unizone Technologies, Inc."}, {
	0x00, 0x01, 0x1C, "Universal Talkware Corporation"}, {
	0x00, 0x01, 0x1D, "Centillium Communications"}, {
	0x00, 0x01, 0x1E, "Precidia Technologies, Inc."}, {
	0x00, 0x01, 0x1F, "RC Networks, Inc."}, {
	0x00, 0x01, 0x20, "OSCILLOQUARTZ S.A."}, {
	0x00, 0x01, 0x21, "RapidStream Inc."}, {
	0x00, 0x01, 0x22, "Trend Communications, Ltd."}, {
	0x00, 0x01, 0x23, "DIGITAL ELECTRONICS CORP."}, {
	0x00, 0x01, 0x24, "Acer Incorporated"}, {
	0x00, 0x01, 0x25, "YAESU MUSEN CO., LTD."}, {
	0x00, 0x01, 0x26, "PAC Labs"}, {
	0x00, 0x01, 0x27, "The OPEN Group Limited"}, {
	0x00, 0x01, 0x28, "EnjoyWeb, Inc."}, {
	0x00, 0x01, 0x29, "DFI Inc."}, {
	0x00, 0x01, 0x2A, "Telematica Sistems Inteligente"}, {
	0x00, 0x01, 0x2B, "TELENET Co., Ltd."}, {
	0x00, 0x01, 0x2C, "Aravox Technologies, Inc."}, {
	0x00, 0x01, 0x2D, "Komodo Technology"}, {
	0x00, 0x01, 0x2E, "PC Partner Ltd."}, {
	0x00, 0x01, 0x2F, "Twinhead International Corp"}, {
	0x00, 0x01, 0x30, "Extreme Networks"}, {
	0x00, 0x01, 0x31, "Detection Systems, Inc."}, {
	0x00, 0x01, 0x32, "Dranetz - BMI"}, {
	0x00, 0x01, 0x33, "KYOWA Electronic Instruments C"}, {
	0x00, 0x01, 0x34, "SIG Positec Systems AG"}, {
	0x00, 0x01, 0x35, "KDC Corp."}, {
	0x00, 0x01, 0x36, "CyberTAN Technology, Inc."}, {
	0x00, 0x01, 0x37, "IT Farm Corporation"}, {
	0x00, 0x01, 0x38, "XAVi Technologies Corp."}, {
	0x00, 0x01, 0x39, "Point Multimedia Systems"}, {
	0x00, 0x01, 0x3A, "SHELCAD COMMUNICATIONS, LTD."}, {
	0x00, 0x01, 0x3B, "BNA SYSTEMS"}, {
	0x00, 0x01, 0x3C, "TIW SYSTEMS"}, {
	0x00, 0x01, 0x3D, "RiscStation Ltd."}, {
	0x00, 0x01, 0x3E, "Ascom Tateco AB"}, {
	0x00, 0x01, 0x3F, "Neighbor World Co., Ltd."}, {
	0x00, 0x01, 0x40, "Sendtek Corporation"}, {
	0x00, 0x01, 0x41, "CABLE PRINT"}, {
	0x00, 0x01, 0x42, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0x43, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0x44, "Cereva Networks, Inc."}, {
	0x00, 0x01, 0x45, "WINSYSTEMS, INC."}, {
	0x00, 0x01, 0x46, "Tesco Controls, Inc."}, {
	0x00, 0x01, 0x47, "Zhone Technologies"}, {
	0x00, 0x01, 0x48, "X-traWeb Inc."}, {
	0x00, 0x01, 0x49, "T.D.T. Transfer Data Test GmbH"}, {
	0x00, 0x01, 0x4A, "SONY COMPUTER SCIENCE LABS., I"}, {
	0x00, 0x01, 0x4B, "Ennovate Networks, Inc."}, {
	0x00, 0x01, 0x4C, "Berkeley Process Control"}, {
	0x00, 0x01, 0x4D, "Shin Kin Enterprises Co., Ltd"}, {
	0x00, 0x01, 0x4E, "WIN Enterprises, Inc."}, {
	0x00, 0x01, 0x4F, "LUMINOUS Networks, Inc."}, {
	0x00, 0x01, 0x50, "GILAT COMMUNICATIONS, LTD."}, {
	0x00, 0x01, 0x51, "Ensemble Communications"}, {
	0x00, 0x01, 0x52, "CHROMATEK INC."}, {
	0x00, 0x01, 0x53, "ARCHTEK TELECOM CORPORATION"}, {
	0x00, 0x01, 0x54, "G3M Corporation"}, {
	0x00, 0x01, 0x55, "Promise Technology, Inc."}, {
	0x00, 0x01, 0x56, "FIREWIREDIRECT.COM, INC."}, {
	0x00, 0x01, 0x57, "SYSWAVE CO., LTD"}, {
	0x00, 0x01, 0x58, "Electro Industries/Gauge Tech"}, {
	0x00, 0x01, 0x59, "S1 Corporation"}, {
	0x00, 0x01, 0x5A, "Digital Video Broadcasting"}, {
	0x00, 0x01, 0x5B, "ITALTEL S.p.A/RF-UP-I"}, {
	0x00, 0x01, 0x5C, "CADANT INC."}, {
	0x00, 0x01, 0x5D, "Pirus Networks"}, {
	0x00, 0x01, 0x5E, "BEST TECHNOLOGY CO., LTD."}, {
	0x00, 0x01, 0x5F, "DIGITAL DESIGN GmbH"}, {
	0x00, 0x01, 0x60, "ELMEX Co., LTD."}, {
	0x00, 0x01, 0x61, "Meta Machine Technology"}, {
	0x00, 0x01, 0x62, "Cygnet Technologies, Inc."}, {
	0x00, 0x01, 0x63, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0x64, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0x65, "AirSwitch Corporation"}, {
	0x00, 0x01, 0x66, "TC GROUP A/S"}, {
	0x00, 0x01, 0x67, "HIOKI E.E. CORPORATION"}, {
	0x00, 0x01, 0x68, "VITANA CORPORATION"}, {
	0x00, 0x01, 0x69, "Celestix Networks Pte Ltd."}, {
	0x00, 0x01, 0x6A, "ALITEC"}, {
	0x00, 0x01, 0x6B, "LightChip, Inc."}, {
	0x00, 0x01, 0x6C, "FOXCONN"}, {
	0x00, 0x01, 0x6D, "Triton Network Systems"}, {
	0x00, 0x01, 0x6E, "Conklin Corporation"}, {
	0x00, 0x01, 0x6F, "HAITAI ELECTRONICS CO., LTD."}, {
	0x00, 0x01, 0x70, "ESE Embedded System Engineer'g"}, {
	0x00, 0x01, 0x71, "Allied Data Technologies"}, {
	0x00, 0x01, 0x72, "TechnoLand Co., LTD."}, {
	0x00, 0x01, 0x73, "JNI Corporation"}, {
	0x00, 0x01, 0x74, "CyberOptics Corporation"}, {
	0x00, 0x01, 0x75, "Radiant Communications Corp."}, {
	0x00, 0x01, 0x76, "Orient Silver Enterprises"}, {
	0x00, 0x01, 0x77, "EDSL"}, {
	0x00, 0x01, 0x78, "MARGI Systems, Inc."}, {
	0x00, 0x01, 0x79, "WIRELESS TECHNOLOGY, INC."}, {
	0x00, 0x01, 0x7A, "Chengdu Maipu Electric Industrial Co., Ltd."}, {
	0x00, 0x01, 0x7B, "Heidelberger Druckmaschinen AG"}, {
	0x00, 0x01, 0x7C, "AG-E GmbH"}, {
	0x00, 0x01, 0x7D, "ThermoQuest"}, {
	0x00, 0x01, 0x7E, "ADTEK System Science Co., Ltd."}, {
	0x00, 0x01, 0x7F, "Experience Music Project"}, {
	0x00, 0x01, 0x80, "AOpen, Inc."}, {
	0x00, 0x01, 0x81, "Nortel Networks"}, {
	0x00, 0x01, 0x82, "DICA TECHNOLOGIES AG"}, {
	0x00, 0x01, 0x83, "ANITE TELECOMS"}, {
	0x00, 0x01, 0x84, "SIEB & MEYER AG"}, {
	0x00, 0x01, 0x85, "Aloka Co., Ltd."}, {
	0x00, 0x01, 0x86, "DISCH GmbH"}, {
	0x00, 0x01, 0x87, "i2SE GmbH"}, {
	0x00, 0x01, 0x88, "LXCO Technologies ag"}, {
	0x00, 0x01, 0x89, "Refraction Technology, Inc."}, {
	0x00, 0x01, 0x8A, "ROI COMPUTER AG"}, {
	0x00, 0x01, 0x8B, "NetLinks Co., Ltd."}, {
	0x00, 0x01, 0x8C, "Mega Vision"}, {
	0x00, 0x01, 0x8D, "AudeSi Technologies"}, {
	0x00, 0x01, 0x8E, "Logitec Corporation"}, {
	0x00, 0x01, 0x8F, "Kenetec, Inc."}, {
	0x00, 0x01, 0x90, "SMK-M"}, {
	0x00, 0x01, 0x91, "SYRED Data Systems"}, {
	0x00, 0x01, 0x92, "Texas Digital Systems"}, {
	0x00, 0x01, 0x93, "Hanbyul Telecom Co., Ltd."}, {
	0x00, 0x01, 0x94, "Capital Equipment Corporation"}, {
	0x00, 0x01, 0x95, "Sena Technologies, Inc."}, {
	0x00, 0x01, 0x96, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0x97, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0x98, "Darim Vision"}, {
	0x00, 0x01, 0x99, "HeiSei Electronics"}, {
	0x00, 0x01, 0x9A, "LEUNIG GmbH"}, {
	0x00, 0x01, 0x9B, "Kyoto Microcomputer Co., Ltd."}, {
	0x00, 0x01, 0x9C, "JDS Uniphase Inc."}, {
	0x00, 0x01, 0x9D, "E-Control Systems, Inc."}, {
	0x00, 0x01, 0x9E, "ESS Technology, Inc."}, {
	0x00, 0x01, 0x9F, "Phonex Broadband"}, {
	0x00, 0x01, 0xA0, "Infinilink Corporation"}, {
	0x00, 0x01, 0xA1, "Mag-Tek, Inc."}, {
	0x00, 0x01, 0xA2, "Logical Co., Ltd."}, {
	0x00, 0x01, 0xA3, "GENESYS LOGIC, INC."}, {
	0x00, 0x01, 0xA4, "Microlink Corporation"}, {
	0x00, 0x01, 0xA5, "Nextcomm, Inc."}, {
	0x00, 0x01, 0xA6, "Scientific-Atlanta Arcodan A/S"}, {
	0x00, 0x01, 0xA7, "UNEX TECHNOLOGY CORPORATION"}, {
	0x00, 0x01, 0xA8, "Welltech Computer Co., Ltd."}, {
	0x00, 0x01, 0xA9, "BMW AG"}, {
	0x00, 0x01, 0xAA, "Airspan Communications, Ltd."}, {
	0x00, 0x01, 0xAB, "Main Street Networks"}, {
	0x00, 0x01, 0xAC, "Sitara Networks, Inc."}, {
	0x00, 0x01, 0xAD,
		"Coach Master International  d.b.a. CMI Worldwide, Inc."},
	{
	0x00, 0x01, 0xAE, "Trex Enterprises"}, {
	0x00, 0x01, 0xAF, "Motorola Computer Group"}, {
	0x00, 0x01, 0xB0, "Fulltek Technology Co., Ltd."}, {
	0x00, 0x01, 0xB1, "General Bandwidth"}, {
	0x00, 0x01, 0xB2, "Digital Processing Systems, Inc."}, {
	0x00, 0x01, 0xB3, "Precision Electronic Manufacturing"}, {
	0x00, 0x01, 0xB4, "Wayport, Inc."}, {
	0x00, 0x01, 0xB5, "Turin Networks, Inc."}, {
	0x00, 0x01, 0xB6, "SAEJIN T&M Co., Ltd."}, {
	0x00, 0x01, 0xB7, "Centos, Inc."}, {
	0x00, 0x01, 0xB8, "Netsensity, Inc."}, {
	0x00, 0x01, 0xB9, "SKF Condition Monitoring"}, {
	0x00, 0x01, 0xBA, "IC-Net, Inc."}, {
	0x00, 0x01, 0xBB, "Frequentis"}, {
	0x00, 0x01, 0xBC, "Brains Corporation"}, {
	0x00, 0x01, 0xBD, "Peterson Electro-Musical Products, Inc."}, {
	0x00, 0x01, 0xBE, "Gigalink Co., Ltd."}, {
	0x00, 0x01, 0xBF, "Teleforce Co., Ltd."}, {
	0x00, 0x01, 0xC0, "CompuLab, Ltd."}, {
	0x00, 0x01, 0xC1, "Exbit Technology"}, {
	0x00, 0x01, 0xC2, "ARK Research Corp."}, {
	0x00, 0x01, 0xC3, "Acromag, Inc."}, {
	0x00, 0x01, 0xC4, "NeoWave, Inc."}, {
	0x00, 0x01, 0xC5, "Simpler Networks"}, {
	0x00, 0x01, 0xC6, "Quarry Technologies"}, {
	0x00, 0x01, 0xC7, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0xC8, "THOMAS CONRAD CORP."}, {
	0x00, 0x01, 0xC8, "CONRAD CORP."}, {
	0x00, 0x01, 0xC9, "Cisco Systems, Inc."}, {
	0x00, 0x01, 0xCA, "Geocast Network Systems, Inc."}, {
	0x00, 0x01, 0xCB, "NetGame, Ltd."}, {
	0x00, 0x01, 0xCC, "Japan Total Design Communication Co., Ltd."}, {
	0x00, 0x01, 0xCD, "ARtem"}, {
	0x00, 0x01, 0xCE, "Custom Micro Products, Ltd."}, {
	0x00, 0x01, 0xCF, "Alpha Data Parallel Systems, Ltd."}, {
	0x00, 0x01, 0xD0, "VitalPoint, Inc."}, {
	0x00, 0x01, 0xD1, "CoNet Communications, Inc."}, {
	0x00, 0x01, 0xD2, "MacPower Peripherals, Ltd."}, {
	0x00, 0x01, 0xD3, "PAXCOMM, Inc."}, {
	0x00, 0x01, 0xD4, "Leisure Time, Inc."}, {
	0x00, 0x01, 0xD5, "HAEDONG INFO & COMM CO., LTD"}, {
	0x00, 0x01, 0xD6, "MAN Roland Druckmaschinen AG"}, {
	0x00, 0x01, 0xD7, "F5 Networks, Inc."}, {
	0x00, 0x01, 0xD8, "Teltronics, Inc."}, {
	0x00, 0x01, 0xD9, "Sigma, Inc."}, {
	0x00, 0x01, 0xDA, "WINCOMM Corporation"}, {
	0x00, 0x01, 0xDB, "Freecom Technologies GmbH"}, {
	0x00, 0x01, 0xDC, "Activetelco"}, {
	0x00, 0x01, 0xDD, "Avail Networks"}, {
	0x00, 0x01, 0xDE, "Trango Systems, Inc."}, {
	0x00, 0x01, 0xDF, "ISDN Communications, Ltd."}, {
	0x00, 0x01, 0xE0, "Fast Systems, Inc."}, {
	0x00, 0x01, 0xE1, "Kinpo Electronics, Inc."}, {
	0x00, 0x01, 0xE2, "Ando Electric Corporation"}, {
	0x00, 0x01, 0xE3, "Siemens AG"}, {
	0x00, 0x01, 0xE4, "Sitera, Inc."}, {
	0x00, 0x01, 0xE5, "Supernet, Inc."}, {
	0x00, 0x01, 0xE6, "Hewlett-Packard Company"}, {
	0x00, 0x01, 0xE7, "Hewlett-Packard Company"}, {
	0x00, 0x01, 0xE8, "Force10 Networks, Inc."}, {
	0x00, 0x01, 0xE9, "Litton Marine Systems B.V."}, {
	0x00, 0x01, 0xEA, "Cirilium Corp."}, {
	0x00, 0x01, 0xEB, "C-COM Corporation"}, {
	0x00, 0x01, 0xEC, "Ericsson Group"}, {
	0x00, 0x01, 0xED, "SETA Corp."}, {
	0x00, 0x01, 0xEE, "Comtrol Europe, Ltd."}, {
	0x00, 0x01, 0xEF, "Camtel Technology Corp."}, {
	0x00, 0x01, 0xF0, "Tridium, Inc."}, {
	0x00, 0x01, 0xF1, "Innovative Concepts, Inc."}, {
	0x00, 0x01, 0xF2, "Mark of the Unicorn, Inc."}, {
	0x00, 0x01, 0xF3, "QPS, Inc."}, {
	0x00, 0x01, 0xF4, "Enterasys Networks"}, {
	0x00, 0x01, 0xF5, "ERIM S.A."}, {
	0x00, 0x01, 0xF6, "Association of Musical Electronics Industry"}, {
	0x00, 0x01, 0xF7, "Image Display Systems, Inc."}, {
	0x00, 0x01, 0xF8, "Adherent Systems, Ltd."}, {
	0x00, 0x01, 0xF9, "TeraGlobal Communications Corp."}, {
	0x00, 0x01, 0xFA, "HOROSCAS"}, {
	0x00, 0x01, 0xFB, "DoTop Technology, Inc."}, {
	0x00, 0x01, 0xFC, "Keyence Corporation"}, {
	0x00, 0x01, 0xFD, "Digital Voice Systems, Inc."}, {
	0x00, 0x01, 0xFE, "DIGITAL EQUIPMENT CORPORATION"}, {
	0x00, 0x01, 0xFF, "Data Direct Networks, Inc."}, {
	0x00, 0x02, 0x00, "Net & Sys Co., Ltd."}, {
	0x00, 0x02, 0x01, "IFM Electronic gmbh"}, {
	0x00, 0x02, 0x02, "Amino Communications, Ltd."}, {
	0x00, 0x02, 0x03, "Woonsang Telecom, Inc."}, {
	0x00, 0x02, 0x04, "Bodmann Industries Elektronik GmbH"}, {
	0x00, 0x02, 0x05, "Hitachi Denshi, Ltd."}, {
	0x00, 0x02, 0x06, "Telital R&D Denmark A/S"}, {
	0x00, 0x02, 0x08, "Unify Networks, Inc."}, {
	0x00, 0x02, 0x09, "Shenzhen SED Information Technology Co., Ltd."},
	{
	0x00, 0x02, 0x0A, "Gefran Spa"}, {
	0x00, 0x02, 0x0B, "Native Networks, Inc."}, {
	0x00, 0x02, 0x0C, "Metro-Optix"}, {
	0x00, 0x02, 0x0D, "Micronpc.com"}, {
	0x00, 0x02, 0x0E, "Laurel Networks, Inc."}, {
	0x00, 0x02, 0x0F, "AATR"}, {
	0x00, 0x02, 0x10, "Fenecom"}, {
	0x00, 0x02, 0x11, "Nature Worldwide Technology Corp."}, {
	0x00, 0x02, 0x12, "SierraCom"}, {
	0x00, 0x02, 0x13, "S.D.E.L."}, {
	0x00, 0x02, 0x14, "DTVRO"}, {
	0x00, 0x02, 0x15, "Cotas Computer Technology A/B"}, {
	0x00, 0x02, 0x16, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0x17, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0x18, "Advanced Scientific Corp"}, {
	0x00, 0x02, 0x19, "Paralon Technologies"}, {
	0x00, 0x02, 0x1A, "Zuma Networks"}, {
	0x00, 0x02, 0x1B, "Kollmorgen-Servotronix"}, {
	0x00, 0x02, 0x1C, "Network Elements, Inc."}, {
	0x00, 0x02, 0x1D, "Data General Communication Ltd."}, {
	0x00, 0x02, 0x1E, "SIMTEL S.R.L."}, {
	0x00, 0x02, 0x1F, "Aculab PLC"}, {
	0x00, 0x02, 0x20, "Canon Aptex, Inc."}, {
	0x00, 0x02, 0x21, "DSP Application, Ltd."}, {
	0x00, 0x02, 0x22, "Chromisys, Inc."}, {
	0x00, 0x02, 0x23, "ClickTV"}, {
	0x00, 0x02, 0x24, "Lantern Communications, Inc."}, {
	0x00, 0x02, 0x25, "Certus Technology, Inc."}, {
	0x00, 0x02, 0x26, "XESystems, Inc."}, {
	0x00, 0x02, 0x27, "ESD GmbH"}, {
	0x00, 0x02, 0x28, "Necsom, Ltd."}, {
	0x00, 0x02, 0x29, "Adtec Corporation"}, {
	0x00, 0x02, 0x2A, "Asound Electronic"}, {
	0x00, 0x02, 0x2B, "Tamura Electric Works, Ltd."}, {
	0x00, 0x02, 0x2C, "ABB Bomem, Inc."}, {
	0x00, 0x02, 0x2D, "Agere Systems"}, {
	0x00, 0x02, 0x2E, "TEAC Corp. R& D"}, {
	0x00, 0x02, 0x2F, "P-Cube, Ltd."}, {
	0x00, 0x02, 0x30, "Intersoft Electronics"}, {
	0x00, 0x02, 0x31, "Ingersoll-Rand"}, {
	0x00, 0x02, 0x32, "Avision, Inc."}, {
	0x00, 0x02, 0x33, "Mantra Communications, Inc."}, {
	0x00, 0x02, 0x34, "Imperial Technology, Inc."}, {
	0x00, 0x02, 0x35, "Paragon Networks International"}, {
	0x00, 0x02, 0x36, "INIT GmbH"}, {
	0x00, 0x02, 0x37, "Cosmo Research Corp."}, {
	0x00, 0x02, 0x38, "Serome Technology, Inc."}, {
	0x00, 0x02, 0x39, "Visicom"}, {
	0x00, 0x02, 0x3A, "ZSK Stickmaschinen GmbH"}, {
	0x00, 0x02, 0x3B, "Redback Networks"}, {
	0x00, 0x02, 0x3C, "Creative Technology, Ltd."}, {
	0x00, 0x02, 0x3D, "NuSpeed, Inc."}, {
	0x00, 0x02, 0x3E, "Selta Telematica S.p.a"}, {
	0x00, 0x02, 0x3F, "Compal Electronics, Inc."}, {
	0x00, 0x02, 0x40, "Seedek Co., Ltd."}, {
	0x00, 0x02, 0x41, "Amer.com"}, {
	0x00, 0x02, 0x42, "Videoframe Systems"}, {
	0x00, 0x02, 0x43, "Raysis Co., Ltd."}, {
	0x00, 0x02, 0x44, "SURECOM Technology Co."}, {
	0x00, 0x02, 0x45, "Lampus Co, Ltd."}, {
	0x00, 0x02, 0x46, "All-Win Tech Co., Ltd."}, {
	0x00, 0x02, 0x47,
		"Great Dragon Information Technology (Group) Co., Ltd."}, {
	0x00, 0x02, 0x48, "Pilz GmbH & Co."}, {
	0x00, 0x02, 0x49, "Aviv Infocom Co, Ltd."}, {
	0x00, 0x02, 0x4A, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0x4B, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0x4C, "SiByte, Inc."}, {
	0x00, 0x02, 0x4D, "Mannesman Dematic Colby Pty. Ltd."}, {
	0x00, 0x02, 0x4E, "Datacard Group"}, {
	0x00, 0x02, 0x4F, "IPM Datacom S.R.L."}, {
	0x00, 0x02, 0x50, "Geyser Networks, Inc."}, {
	0x00, 0x02, 0x51, "Soma Networks"}, {
	0x00, 0x02, 0x52, "Carrier Corporation"}, {
	0x00, 0x02, 0x53, "Televideo, Inc."}, {
	0x00, 0x02, 0x54, "WorldGate"}, {
	0x00, 0x02, 0x55, "IBM Corporation"}, {
	0x00, 0x02, 0x56, "Alpha Processor, Inc."}, {
	0x00, 0x02, 0x57, "Microcom Corp."}, {
	0x00, 0x02, 0x58, "Flying Packets Communications"}, {
	0x00, 0x02, 0x59,
		"Tsann Kuen China (Shanghai)Enterprise Co., Ltd. IT Group"},
	{
	0x00, 0x02, 0x5A, "Catena Networks"}, {
	0x00, 0x02, 0x5B, "Cambridge Silicon Radio"}, {
	0x00, 0x02, 0x5C, "SCI Systems (Kunshan) Co., Ltd."}, {
	0x00, 0x02, 0x5D, "Calix Networks"}, {
	0x00, 0x02, 0x5E, "High Technology Ltd"}, {
	0x00, 0x02, 0x5F, "Nortel Networks"}, {
	0x00, 0x02, 0x60, "Accordion Networks, Inc."}, {
	0x00, 0x02, 0x61, "i3 Micro Technology AB"}, {
	0x00, 0x02, 0x62, "Soyo Group Soyo Com Tech Co., Ltd"}, {
	0x00, 0x02, 0x63, "UPS Manufacturing SRL"}, {
	0x00, 0x02, 0x64, "AudioRamp.com"}, {
	0x00, 0x02, 0x65, "Virditech Co. Ltd."}, {
	0x00, 0x02, 0x66, "Thermalogic Corporation"}, {
	0x00, 0x02, 0x67, "NODE RUNNER, INC."}, {
	0x00, 0x02, 0x68, "Harris Government Communications"}, {
	0x00, 0x02, 0x69, "Nadatel Co., Ltd"}, {
	0x00, 0x02, 0x6A, "Cocess Telecom Co., Ltd."}, {
	0x00, 0x02, 0x6B, "BCM Computers Co., Ltd."}, {
	0x00, 0x02, 0x6C, "Philips CFT"}, {
	0x00, 0x02, 0x6D, "Adept Telecom"}, {
	0x00, 0x02, 0x6E, "NeGeN Access, Inc."}, {
	0x00, 0x02, 0x6F, "Senao International Co., Ltd."}, {
	0x00, 0x02, 0x70, "Crewave Co., Ltd."}, {
	0x00, 0x02, 0x71, "Vpacket Communications"}, {
	0x00, 0x02, 0x72, "CC&C Technologies, Inc."}, {
	0x00, 0x02, 0x73, "Coriolis Networks"}, {
	0x00, 0x02, 0x74, "Tommy Technologies Corp."}, {
	0x00, 0x02, 0x75, "SMART Technologies, Inc."}, {
	0x00, 0x02, 0x76, "Primax Electronics Ltd."}, {
	0x00, 0x02, 0x77, "Cash Systemes Industrie"}, {
	0x00, 0x02, 0x78, "Samsung Electro-Mechanics Co., Ltd."}, {
	0x00, 0x02, 0x79, "Control Applications, Ltd."}, {
	0x00, 0x02, 0x7A, "IOI Technology Corporation"}, {
	0x00, 0x02, 0x7B, "Amplify Net, Inc."}, {
	0x00, 0x02, 0x7C, "Trilithic, Inc."}, {
	0x00, 0x02, 0x7D, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0x7E, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0x7F, "ask-technologies.com"}, {
	0x00, 0x02, 0x80, "Mu Net, Inc."}, {
	0x00, 0x02, 0x81, "Madge Networks Limited"}, {
	0x00, 0x02, 0x82, "ViaClix, Inc."}, {
	0x00, 0x02, 0x83, "Spectrum Controls, Inc."}, {
	0x00, 0x02, 0x84, "Alstom T&D P&C"}, {
	0x00, 0x02, 0x85, "Riverstone Networks"}, {
	0x00, 0x02, 0x86, "Occam Networks"}, {
	0x00, 0x02, 0x87, "Adapcom"}, {
	0x00, 0x02, 0x88, "GLOBAL VILLAGE COMMUNICATION"}, {
	0x00, 0x02, 0x89, "DNE Technologies"}, {
	0x00, 0x02, 0x8A, "Ambit Microsystems Corporation"}, {
	0x00, 0x02, 0x8B, "VDSL Systems OY"}, {
	0x00, 0x02, 0x8C, "Micrel-Synergy Semiconductor"}, {
	0x00, 0x02, 0x8D, "Movita Technologies, Inc."}, {
	0x00, 0x02, 0x8E, "Rapid 5 Networks, Inc."}, {
	0x00, 0x02, 0x8F, "Globetek, Inc."}, {
	0x00, 0x02, 0x90, "Woorigisool, Inc."}, {
	0x00, 0x02, 0x91, "Open Network Co., Ltd."}, {
	0x00, 0x02, 0x92, "Logic Innovations, Inc."}, {
	0x00, 0x02, 0x93, "Solid Data Systems"}, {
	0x00, 0x02, 0x94, "Tokyo Sokushin Co., Ltd."}, {
	0x00, 0x02, 0x95, "IP.Access Limited"}, {
	0x00, 0x02, 0x96, "Lectron Co,. Ltd."}, {
	0x00, 0x02, 0x97, "C-COR.net"}, {
	0x00, 0x02, 0x98, "Broadframe Corporation"}, {
	0x00, 0x02, 0x99, "Apex, Inc."}, {
	0x00, 0x02, 0x9A, "Storage Apps"}, {
	0x00, 0x02, 0x9B, "Kreatel Communications AB"}, {
	0x00, 0x02, 0x9C, "3COM"}, {
	0x00, 0x02, 0x9D, "Merix Corp."}, {
	0x00, 0x02, 0x9E, "Information Equipment Co., Ltd."}, {
	0x00, 0x02, 0x9F, "L-3 Communication Aviation Recorders"}, {
	0x00, 0x02, 0xA0, "Flatstack Ltd."}, {
	0x00, 0x02, 0xA1, "World Wide Packets"}, {
	0x00, 0x02, 0xA2, "Hilscher GmbH"}, {
	0x00, 0x02, 0xA3, "ABB Power Automation"}, {
	0x00, 0x02, 0xA4, "AddPac Technology Co., Ltd."}, {
	0x00, 0x02, 0xA5, "Compaq Computer Corporation"}, {
	0x00, 0x02, 0xA6, "Effinet Systems Co., Ltd."}, {
	0x00, 0x02, 0xA7, "Vivace Networks"}, {
	0x00, 0x02, 0xA8, "Air Link Technology"}, {
	0x00, 0x02, 0xA9, "RACOM, s.r.o."}, {
	0x00, 0x02, 0xAA, "PLcom Co., Ltd."}, {
	0x00, 0x02, 0xAB, "CTC Union Technologies Co., Ltd."}, {
	0x00, 0x02, 0xAC, "3PAR data"}, {
	0x00, 0x02, 0xAD, "Asahi Optical Co., Ltd."}, {
	0x00, 0x02, 0xAE, "Scannex Electronics Ltd."}, {
	0x00, 0x02, 0xAF, "TeleCruz Technology, Inc."}, {
	0x00, 0x02, 0xB0, "Hokubu Communication & Industrial Co., Ltd."}, {
	0x00, 0x02, 0xB1, "Anritsu, Ltd."}, {
	0x00, 0x02, 0xB2, "Cablevision"}, {
	0x00, 0x02, 0xB3, "Intel Corporation"}, {
	0x00, 0x02, 0xB4, "DAPHNE"}, {
	0x00, 0x02, 0xB5, "Avnet, Inc."}, {
	0x00, 0x02, 0xB6, "Acrosser Technology Co., Ltd."}, {
	0x00, 0x02, 0xB7, "Watanabe Electric Industry Co., Ltd."}, {
	0x00, 0x02, 0xB8, "WHI KONSULT AB"}, {
	0x00, 0x02, 0xB9, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0xBA, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0xBB, "Continuous Computing"}, {
	0x00, 0x02, 0xBC, "LVL 7 Systems, Inc."}, {
	0x00, 0x02, 0xBD, "Bionet Co., Ltd."}, {
	0x00, 0x02, 0xBE, "Totsu Engineering, Inc."}, {
	0x00, 0x02, 0xBF, "dotRocket, Inc."}, {
	0x00, 0x02, 0xC0, "Bencent Tzeng Industry Co., Ltd."}, {
	0x00, 0x02, 0xC1, "Innovative Electronic Designs, Inc."}, {
	0x00, 0x02, 0xC2, "Net Vision Telecom"}, {
	0x00, 0x02, 0xC3, "Arelnet Ltd."}, {
	0x00, 0x02, 0xC4, "Vector International BUBA"}, {
	0x00, 0x02, 0xC5, "Evertz Microsystems Ltd."}, {
	0x00, 0x02, 0xC6, "Data Track Technology PLC"}, {
	0x00, 0x02, 0xC7, "ALPS ELECTRIC Co., Ltd."}, {
	0x00, 0x02, 0xC8, "Technocom Communications Technology (pte) Ltd"},
	{
	0x00, 0x02, 0xC9, "Mellanox Technologies"}, {
	0x00, 0x02, 0xCA, "EndPoints, Inc."}, {
	0x00, 0x02, 0xCB, "TriState Ltd."}, {
	0x00, 0x02, 0xCC, "M.C.C.I"}, {
	0x00, 0x02, 0xCD, "TeleDream, Inc."}, {
	0x00, 0x02, 0xCE, "FoxJet, Inc."}, {
	0x00, 0x02, 0xCF, "ZyGate Communications, Inc."}, {
	0x00, 0x02, 0xD0, "Comdial Corporation"}, {
	0x00, 0x02, 0xD1, "Vivotek, Inc."}, {
	0x00, 0x02, 0xD2, "Workstation AG"}, {
	0x00, 0x02, 0xD3, "NetBotz, Inc."}, {
	0x00, 0x02, 0xD4, "PDA Peripherals, Inc."}, {
	0x00, 0x02, 0xD5, "ACR"}, {
	0x00, 0x02, 0xD6, "NICE Systems"}, {
	0x00, 0x02, 0xD7, "EMPEG Ltd"}, {
	0x00, 0x02, 0xD8, "BRECIS Communications Corporation"}, {
	0x00, 0x02, 0xD9, "Reliable Controls"}, {
	0x00, 0x02, 0xDA, "ExiO Communications, Inc."}, {
	0x00, 0x02, 0xDB, "NETSEC"}, {
	0x00, 0x02, 0xDC, "Fujitsu General Limited"}, {
	0x00, 0x02, 0xDD, "Bromax Communications, Ltd."}, {
	0x00, 0x02, 0xDE, "Astrodesign, Inc."}, {
	0x00, 0x02, 0xDF, "Net Com Systems, Inc."}, {
	0x00, 0x02, 0xE0, "ETAS GmbH"}, {
	0x00, 0x02, 0xE1, "Integrated Network Corporation"}, {
	0x00, 0x02, 0xE2, "NDC Infared Engineering"}, {
	0x00, 0x02, 0xE3, "LITE-ON Communications, Inc."}, {
	0x00, 0x02, 0xE4, "JC HYUN Systems, Inc."}, {
	0x00, 0x02, 0xE5, "Timeware Ltd."}, {
	0x00, 0x02, 0xE6, "Gould Instrument Systems, Inc."}, {
	0x00, 0x02, 0xE7, "CAB GmbH & Co KG"}, {
	0x00, 0x02, 0xE8, "E.D.&A."}, {
	0x00, 0x02, 0xE9, "CS Systemes De Securite - C3S"}, {
	0x00, 0x02, 0xEA, "Videonics, Inc."}, {
	0x00, 0x02, 0xEB, "Pico Communications"}, {
	0x00, 0x02, 0xEC, "Maschoff Design Engineering"}, {
	0x00, 0x02, 0xED, "DXO Telecom Co., Ltd."}, {
	0x00, 0x02, 0xEE, "Nokia Danmark A/S"}, {
	0x00, 0x02, 0xEF, "CCC Network Systems Group Ltd."}, {
	0x00, 0x02, 0xF0, "AME Optimedia Technology Co., Ltd."}, {
	0x00, 0x02, 0xF1, "Pinetron Co., Ltd."}, {
	0x00, 0x02, 0xF2, "eDevice, Inc."}, {
	0x00, 0x02, 0xF3, "Media Serve Co., Ltd."}, {
	0x00, 0x02, 0xF4, "PCTEL, Inc."}, {
	0x00, 0x02, 0xF5, "VIVE Synergies, Inc."}, {
	0x00, 0x02, 0xF6, "Equipe Communications"}, {
	0x00, 0x02, 0xF7, "ARM"}, {
	0x00, 0x02, 0xF8, "SEAKR Engineering, Inc."}, {
	0x00, 0x02, 0xF9, "Mimos Semiconductor SDN BHD"}, {
	0x00, 0x02, 0xFA, "DX Antenna Co., Ltd."}, {
	0x00, 0x02, 0xFB, "Baumuller Aulugen-Systemtechnik GmbH"}, {
	0x00, 0x02, 0xFC, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0xFD, "Cisco Systems, Inc."}, {
	0x00, 0x02, 0xFE, "Viditec, Inc."}, {
	0x00, 0x02, 0xFF, "Handan Broad InfoCom"}, {
	0x00, 0x03, 0x00, "NetContinuum, Inc."}, {
	0x00, 0x03, 0x01, "Avantas Networks Corporation"}, {
	0x00, 0x03, 0x02, "Oasys Telecom, Inc."}, {
	0x00, 0x03, 0x03, "JAMA Electronics Co., Ltd."}, {
	0x00, 0x03, 0x04, "Pacific Broadband Communications"}, {
	0x00, 0x03, 0x05, "Smart Network Devices GmbH"}, {
	0x00, 0x03, 0x06, "Fusion In Tech Co., Ltd."}, {
	0x00, 0x03, 0x07, "Secure Works, Inc."}, {
	0x00, 0x03, 0x08, "AM Communications, Inc."}, {
	0x00, 0x03, 0x09, "Texcel Technology PLC"}, {
	0x00, 0x03, 0x0A, "Argus Technologies"}, {
	0x00, 0x03, 0x0B, "Hunter Technology, Inc."}, {
	0x00, 0x03, 0x0C, "Telesoft Technologies Ltd."}, {
	0x00, 0x03, 0x0D, "Uniwill Computer Corp."}, {
	0x00, 0x03, 0x0E, "Core Communications Co., Ltd."}, {
	0x00, 0x03, 0x0F, "Digital China (Shanghai) Networks Ltd."}, {
	0x00, 0x03, 0x10, "Link Evolution Corp."}, {
	0x00, 0x03, 0x11, "Micro Technology Co., Ltd."}, {
	0x00, 0x03, 0x12, "TR-Systemtechnik GmbH"}, {
	0x00, 0x03, 0x13, "Access Media SPA"}, {
	0x00, 0x03, 0x14, "Teleware Network Systems"}, {
	0x00, 0x03, 0x15, "Cidco Incorporated"}, {
	0x00, 0x03, 0x16, "Nobell Communications, Inc."}, {
	0x00, 0x03, 0x17, "Merlin Systems, Inc."}, {
	0x00, 0x03, 0x18, "Cyras Systems, Inc."}, {
	0x00, 0x03, 0x19, "Infineon AG"}, {
	0x00, 0x03, 0x1A, "Beijing Broad Telecom Ltd., China"}, {
	0x00, 0x03, 0x1B, "Cellvision Systems, Inc."}, {
	0x00, 0x03, 0x1C, "Svenska Hardvarufabriken AB"}, {
	0x00, 0x03, 0x1D, "Taiwan Commate Computer, Inc."}, {
	0x00, 0x03, 0x1E, "Optranet, Inc."}, {
	0x00, 0x03, 0x1F, "Condev Ltd."}, {
	0x00, 0x03, 0x20, "Xpeed, Inc."}, {
	0x00, 0x03, 0x21, "Reco Research Co., Ltd."}, {
	0x00, 0x03, 0x22, "IDIS Co., Ltd."}, {
	0x00, 0x03, 0x23, "Cornet Technology, Inc."}, {
	0x00, 0x03, 0x24, "Tottori SANYO Electric Co., Ltd."}, {
	0x00, 0x03, 0x25, "Arima Computer Corp."}, {
	0x00, 0x03, 0x26, "Iwasaki Information Systems Co., Ltd."}, {
	0x00, 0x03, 0x27, "ACT'L"}, {
	0x00, 0x03, 0x29, "F3, Inc."}, {
	0x00, 0x03, 0x2A, "UniData Communication Systems, Inc."}, {
	0x00, 0x03, 0x2B, "GAI Datenfunksysteme GmbH"}, {
	0x00, 0x03, 0x2C, "ABB Industrie AG"}, {
	0x00, 0x03, 0x2D, "IBASE Technology, Inc."}, {
	0x00, 0x03, 0x2E, "Scope Information Management, Ltd."}, {
	0x00, 0x03, 0x2F, "Global Sun Technology, Inc."}, {
	0x00, 0x03, 0x30, "Imagenics, Co., Ltd."}, {
	0x00, 0x03, 0x31, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0x32, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0x33, "Digitel Co., Ltd."}, {
	0x00, 0x03, 0x34, "Newport Electronics"}, {
	0x00, 0x03, 0x35, "Mirae Technology"}, {
	0x00, 0x03, 0x36, "Zetes Technologies"}, {
	0x00, 0x03, 0x37, "Vaone, Inc."}, {
	0x00, 0x03, 0x38, "Oak Technology"}, {
	0x00, 0x03, 0x39, "Eurologic Systems, Ltd."}, {
	0x00, 0x03, 0x3A, "Silicon Wave, Inc."}, {
	0x00, 0x03, 0x3B, "TAMI Tech Co., Ltd."}, {
	0x00, 0x03, 0x3C, "Daiden Co., Ltd."}, {
	0x00, 0x03, 0x3D, "ILSHin Lab"}, {
	0x00, 0x03, 0x3E, "Tateyama System Laboratory Co., Ltd."}, {
	0x00, 0x03, 0x3F, "BigBand Networks, Ltd."}, {
	0x00, 0x03, 0x40, "Floware Wireless Systems, Ltd."}, {
	0x00, 0x03, 0x41, "Axon Digital Design"}, {
	0x00, 0x03, 0x42, "Nortel Networks"}, {
	0x00, 0x03, 0x43, "Martin Professional A/S"}, {
	0x00, 0x03, 0x44, "Tietech.Co., Ltd."}, {
	0x00, 0x03, 0x45, "Routrek Networks Corporation"}, {
	0x00, 0x03, 0x46, "Hitachi Kokusai Electric, Inc."}, {
	0x00, 0x03, 0x47, "Intel Corporation"}, {
	0x00, 0x03, 0x48, "Norscan Instruments, Ltd."}, {
	0x00, 0x03, 0x49, "Vidicode Datacommunicatie B.V."}, {
	0x00, 0x03, 0x4A, "RIAS Corporation"}, {
	0x00, 0x03, 0x4B, "Nortel Networks"}, {
	0x00, 0x03, 0x4C, "Shanghai DigiVision Technology Co., Ltd."}, {
	0x00, 0x03, 0x4D, "Chiaro Networks, Ltd."}, {
	0x00, 0x03, 0x4E, "Pos Data Company, Ltd."}, {
	0x00, 0x03, 0x4F, "Sur-Gard Security"}, {
	0x00, 0x03, 0x50, "BTICINO SPA"}, {
	0x00, 0x03, 0x51, "Diebold, Inc."}, {
	0x00, 0x03, 0x52, "Colubris Networks"}, {
	0x00, 0x03, 0x53, "Mitac, Inc."}, {
	0x00, 0x03, 0x54, "Fiber Logic Communications"}, {
	0x00, 0x03, 0x55, "TeraBeam Internet Systems"}, {
	0x00, 0x03, 0x56, "Wincor Nixdorf GmbH & Co KG"}, {
	0x00, 0x03, 0x57, "Intervoice-Brite, Inc."}, {
	0x00, 0x03, 0x58, "iCable System Co., Ltd."}, {
	0x00, 0x03, 0x59, "DigitalSis"}, {
	0x00, 0x03, 0x5A, "Photron Limited"}, {
	0x00, 0x03, 0x5B, "BridgeWave Communications"}, {
	0x00, 0x03, 0x5C, "Saint Song Corp."}, {
	0x00, 0x03, 0x5D, "Bosung Hi-Net Co., Ltd."}, {
	0x00, 0x03, 0x5E, "Metropolitan Area Networks, Inc."}, {
	0x00, 0x03, 0x5F, "Schuehle Mess - und. Kontrollsysteme"}, {
	0x00, 0x03, 0x60, "PAC Interactive Technology, Inc."}, {
	0x00, 0x03, 0x61, "Widcomm, Inc."}, {
	0x00, 0x03, 0x62, "Vodtel Communications, Inc."}, {
	0x00, 0x03, 0x63, "Miraesys Co., Ltd."}, {
	0x00, 0x03, 0x64, "Scenix Semiconductor, Inc."}, {
	0x00, 0x03, 0x65, "Kira Information & Communications, Ltd."}, {
	0x00, 0x03, 0x66, "ASM Pacific Technology"}, {
	0x00, 0x03, 0x67, "Jasmine Networks, Inc."}, {
	0x00, 0x03, 0x68, "Embedone Co., Ltd."}, {
	0x00, 0x03, 0x69, "Nippon Antenna Co., Ltd."}, {
	0x00, 0x03, 0x6A, "Mainnet, Ltd."}, {
	0x00, 0x03, 0x6B, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0x6C, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0x6D, "Runtop, Inc."}, {
	0x00, 0x03, 0x6E, "Nicon Systems (Pty) Limited"}, {
	0x00, 0x03, 0x6F, "Telsey SPA"}, {
	0x00, 0x03, 0x70, "NXTV, Inc."}, {
	0x00, 0x03, 0x71, "Acomz Networks Corp."}, {
	0x00, 0x03, 0x72, "ULAN"}, {
	0x00, 0x03, 0x73, "Aselsan A.S"}, {
	0x00, 0x03, 0x74, "Hunter Watertech"}, {
	0x00, 0x03, 0x75, "NetMedia, Inc."}, {
	0x00, 0x03, 0x76, "Graphtec Technology, Inc."}, {
	0x00, 0x03, 0x77, "Gigabit Wireless"}, {
	0x00, 0x03, 0x78, "HUMAX Co., Ltd."}, {
	0x00, 0x03, 0x79, "Proscend Communications, Inc."}, {
	0x00, 0x03, 0x7A, "Taiyo Yuden Co., Ltd."}, {
	0x00, 0x03, 0x7B, "IDEC IZUMI Corporation"}, {
	0x00, 0x03, 0x7C, "Coax Media"}, {
	0x00, 0x03, 0x7D, "Stellcom"}, {
	0x00, 0x03, 0x7E, "PORTech Communications, Inc."}, {
	0x00, 0x03, 0x7F, "Atheros Communications, Inc."}, {
	0x00, 0x03, 0x80, "SSH Communications Security Corp."}, {
	0x00, 0x03, 0x81, "Ingenico International"}, {
	0x00, 0x03, 0x82, "A-One Co., Ltd."}, {
	0x00, 0x03, 0x83, "Metera Networks, Inc."}, {
	0x00, 0x03, 0x84, "AETA"}, {
	0x00, 0x03, 0x85, "Actelis Networks, Inc."}, {
	0x00, 0x03, 0x86, "Ho Net, Inc."}, {
	0x00, 0x03, 0x87, "Blaze Network Products"}, {
	0x00, 0x03, 0x88, "Fastfame Technology Co., Ltd."}, {
	0x00, 0x03, 0x89, "Plantronics"}, {
	0x00, 0x03, 0x8A, "America Online, Inc."}, {
	0x00, 0x03, 0x8B, "PLUS-ONE I&T, Inc."}, {
	0x00, 0x03, 0x8C, "Total Impact"}, {
	0x00, 0x03, 0x8D, "PCS Revenue Control Systems, Inc."}, {
	0x00, 0x03, 0x8E, "Atoga Systems, Inc."}, {
	0x00, 0x03, 0x8F, "Weinschel Corporation"}, {
	0x00, 0x03, 0x90, "Digital Video Communications, Inc."}, {
	0x00, 0x03, 0x92, "Hyundai Teletek Co., Ltd."}, {
	0x00, 0x03, 0x93, "Apple Computer, Inc."}, {
	0x00, 0x03, 0x94, "Connect One"}, {
	0x00, 0x03, 0x95, "California Amplifier"}, {
	0x00, 0x03, 0x96, "EZ Cast Co., Ltd."}, {
	0x00, 0x03, 0x97, "Watchfront Electronics"}, {
	0x00, 0x03, 0x98, "WISI"}, {
	0x00, 0x03, 0x99,
		"Dongju Informations & Communications Co., Ltd."}, {
	0x00, 0x03, 0x9A, "nSine, Ltd."}, {
	0x00, 0x03, 0x9B, "NetChip Technology, Inc."}, {
	0x00, 0x03, 0x9C, "OptiMight Communications, Inc."}, {
	0x00, 0x03, 0x9D, "BENQ CORPORATION"}, {
	0x00, 0x03, 0x9E, "Tera System Co., Ltd."}, {
	0x00, 0x03, 0x9F, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0xA0, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0xA1, "HIPER Information & Communication, Inc."}, {
	0x00, 0x03, 0xA2, "Catapult Communications"}, {
	0x00, 0x03, 0xA3, "MAVIX, Ltd."}, {
	0x00, 0x03, 0xA4, "Data Storage and Information Management"}, {
	0x00, 0x03, 0xA5, "Medea Corporation"}, {
	0x00, 0x03, 0xA7, "Unixtar Technology, Inc."}, {
	0x00, 0x03, 0xA8, "IDOT Computers, Inc."}, {
	0x00, 0x03, 0xA9, "AXCENT Media AG"}, {
	0x00, 0x03, 0xAA, "Watlow"}, {
	0x00, 0x03, 0xAB, "Bridge Information Systems"}, {
	0x00, 0x03, 0xAC, "Fronius Schweissmaschinen"}, {
	0x00, 0x03, 0xAD, "Emerson Energy Systems AB"}, {
	0x00, 0x03, 0xAE, "Allied Advanced Manufacturing Pte, Ltd."}, {
	0x00, 0x03, 0xAF, "Paragea Communications"}, {
	0x00, 0x03, 0xB0, "Xsense Technology Corp."}, {
	0x00, 0x03, 0xB1, "Abbott Laboratories HPD"}, {
	0x00, 0x03, 0xB2, "Radware"}, {
	0x00, 0x03, 0xB3, "IA Link Systems Co., Ltd."}, {
	0x00, 0x03, 0xB4, "Macrotek International Corp."}, {
	0x00, 0x03, 0xB5, "Entra Technology Co."}, {
	0x00, 0x03, 0xB6, "QSI Corporation"}, {
	0x00, 0x03, 0xB7, "ZACCESS Systems"}, {
	0x00, 0x03, 0xB8, "NetKit Solutions, LLC"}, {
	0x00, 0x03, 0xB9, "Hualong Telecom Co., Ltd."}, {
	0x00, 0x03, 0xBA, "Sun Microsystems"}, {
	0x00, 0x03, 0xBB, "Signal Communications Limited"}, {
	0x00, 0x03, 0xBC, "COT GmbH"}, {
	0x00, 0x03, 0xBD, "OmniCluster Technologies, Inc."}, {
	0x00, 0x03, 0xBE, "Netility"}, {
	0x00, 0x03, 0xBF, "Centerpoint Broadband Technologies, Inc."}, {
	0x00, 0x03, 0xC0, "RFTNC Co., Ltd."}, {
	0x00, 0x03, 0xC1, "Packet Dynamics Ltd"}, {
	0x00, 0x03, 0xC2, "Solphone K.K."}, {
	0x00, 0x03, 0xC3, "Micronik Multimedia"}, {
	0x00, 0x03, 0xC4, "Tomra Systems ASA"}, {
	0x00, 0x03, 0xC5, "Mobotix AG"}, {
	0x00, 0x03, 0xC6, "ICUE Systems, Inc."}, {
	0x00, 0x03, 0xC7, "hopf Elektronik GmbH"}, {
	0x00, 0x03, 0xC8, "CML Emergency Services"}, {
	0x00, 0x03, 0xC9, "TECOM Co., Ltd."}, {
	0x00, 0x03, 0xCA, "MTS Systems Corp."}, {
	0x00, 0x03, 0xCB, "Nippon Systems Development Co., Ltd."}, {
	0x00, 0x03, 0xCC, "Momentum Computer, Inc."}, {
	0x00, 0x03, 0xCD, "Clovertech, Inc."}, {
	0x00, 0x03, 0xCE, "ETEN Technologies, Inc."}, {
	0x00, 0x03, 0xCF, "Muxcom, Inc."}, {
	0x00, 0x03, 0xD0, "KOANKEISO Co., Ltd."}, {
	0x00, 0x03, 0xD1, "Takaya Corporation"}, {
	0x00, 0x03, 0xD2, "Crossbeam Systems, Inc."}, {
	0x00, 0x03, 0xD3, "Internet Energy Systems, Inc."}, {
	0x00, 0x03, 0xD4, "Alloptic, Inc."}, {
	0x00, 0x03, 0xD5, "Advanced Communications Co., Ltd."}, {
	0x00, 0x03, 0xD6, "RADVision, Ltd."}, {
	0x00, 0x03, 0xD7, "NextNet Wireless, Inc."}, {
	0x00, 0x03, 0xD8, "iMPath Networks, Inc."}, {
	0x00, 0x03, 0xD9, "Secheron SA"}, {
	0x00, 0x03, 0xDA, "Takamisawa Cybernetics Co., Ltd."}, {
	0x00, 0x03, 0xDB, "Apogee Electronics Corp."}, {
	0x00, 0x03, 0xDC, "Lexar Media, Inc."}, {
	0x00, 0x03, 0xDD, "Comark Corp."}, {
	0x00, 0x03, 0xDE, "OTC Wireless"}, {
	0x00, 0x03, 0xDF, "Desana Systems"}, {
	0x00, 0x03, 0xE0, "RadioFrame Networks, Inc."}, {
	0x00, 0x03, 0xE1, "Winmate Communication, Inc."}, {
	0x00, 0x03, 0xE2, "Comspace Corporation"}, {
	0x00, 0x03, 0xE3, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0xE4, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0xE5, "Hermstedt SG"}, {
	0x00, 0x03, 0xE6, "Entone Technologies, Inc."}, {
	0x00, 0x03, 0xE7, "Logostek Co. Ltd."}, {
	0x00, 0x03, 0xE8, "Wavelength Digital Limited"}, {
	0x00, 0x03, 0xE9, "Akara Canada, Inc."}, {
	0x00, 0x03, 0xEA, "Mega System Technologies, Inc."}, {
	0x00, 0x03, 0xEB, "Atrica"}, {
	0x00, 0x03, 0xEC, "ICG Research, Inc."}, {
	0x00, 0x03, 0xED, "Shinkawa Electric Co., Ltd."}, {
	0x00, 0x03, 0xEE, "MKNet Corporation"}, {
	0x00, 0x03, 0xEF, "Oneline AG"}, {
	0x00, 0x03, 0xF0, "Redfern Broadband Networks"}, {
	0x00, 0x03, 0xF1, "Cicada Semiconductor, Inc."}, {
	0x00, 0x03, 0xF2, "Seneca Networks"}, {
	0x00, 0x03, 0xF3, "Dazzle Multimedia, Inc."}, {
	0x00, 0x03, 0xF4, "NetBurner"}, {
	0x00, 0x03, 0xF5, "Chip2Chip"}, {
	0x00, 0x03, 0xF6, "Allegro Networks, Inc."}, {
	0x00, 0x03, 0xF7, "Plast-Control GmbH"}, {
	0x00, 0x03, 0xF8, "SanCastle Technologies, Inc."}, {
	0x00, 0x03, 0xF9, "Pleiades Communications, Inc."}, {
	0x00, 0x03, 0xFA, "TiMetra Networks"}, {
	0x00, 0x03, 0xFB, "Toko Seiki Company, Ltd."}, {
	0x00, 0x03, 0xFC, "Intertex Data AB"}, {
	0x00, 0x03, 0xFD, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0xFE, "Cisco Systems, Inc."}, {
	0x00, 0x03, 0xFF, "Connectix"}, {
	0x00, 0x04, 0x00, "LEXMARK INTERNATIONAL, INC."}, {
	0x00, 0x04, 0x01, "Osaki Electric Co., Ltd."}, {
	0x00, 0x04, 0x02, "Nexsan Technologies, Ltd."}, {
	0x00, 0x04, 0x03, "Nexsi Corporation"}, {
	0x00, 0x04, 0x04, "Makino Milling Machine Co., Ltd."}, {
	0x00, 0x04, 0x05, "ACN Technologies"}, {
	0x00, 0x04, 0x06, "Fa. Metabox AG"}, {
	0x00, 0x04, 0x07, "Topcon Positioning Systems, Inc."}, {
	0x00, 0x04, 0x08, "Sanko Electronics Co., Ltd."}, {
	0x00, 0x04, 0x09, "Cratos Networks"}, {
	0x00, 0x04, 0x0A, "Sage Systems"}, {
	0x00, 0x04, 0x0B, "3com Europe Ltd."}, {
	0x00, 0x04, 0x0C, "KANNO Work's Ltd."}, {
	0x00, 0x04, 0x0D, "Avaya, Inc."}, {
	0x00, 0x04, 0x0E, "AVM GmbH"}, {
	0x00, 0x04, 0x0F, "Asus Network Technologies, Inc."}, {
	0x00, 0x04, 0x10, "Spinnaker Networks, Inc."}, {
	0x00, 0x04, 0x11, "Inkra Networks, Inc."}, {
	0x00, 0x04, 0x12, "WaveSmith Networks, Inc."}, {
	0x00, 0x04, 0x13, "SNOM Technology AG"}, {
	0x00, 0x04, 0x14, "Umezawa Musen Denki Co., Ltd."}, {
	0x00, 0x04, 0x15, "Rasteme Systems Co., Ltd."}, {
	0x00, 0x04, 0x16, "Parks S/A Comunicacoes Digitais"}, {
	0x00, 0x04, 0x17, "ELAU AG"}, {
	0x00, 0x04, 0x18, "Teltronic S.A.U."}, {
	0x00, 0x04, 0x19, "Fibercycle Networks, Inc."}, {
	0x00, 0x04, 0x1A, "ines GmbH"}, {
	0x00, 0x04, 0x1B, "Digital Interfaces Ltd."}, {
	0x00, 0x04, 0x1C, "ipDialog, Inc."}, {
	0x00, 0x04, 0x1D, "Corega of America"}, {
	0x00, 0x04, 0x1E, "Shikoku Instrumentation Co., Ltd."}, {
	0x00, 0x04, 0x1F, "Sony Computer Entertainment, Inc."}, {
	0x00, 0x04, 0x20, "Slim Devices, Inc."}, {
	0x00, 0x04, 0x21, "Ocular Networks"}, {
	0x00, 0x04, 0x22, "Gordon Kapes, Inc."}, {
	0x00, 0x04, 0x23, "Intel Corporation"}, {
	0x00, 0x04, 0x24, "TMC s.r.l."}, {
	0x00, 0x04, 0x25, "Atmel Corporation"}, {
	0x00, 0x04, 0x26, "Autosys"}, {
	0x00, 0x04, 0x27, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x28, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x29, "Pixord Corporation"}, {
	0x00, 0x04, 0x2A, "Wireless Networks, Inc."}, {
	0x00, 0x04, 0x2B, "IT Access Co., Ltd."}, {
	0x00, 0x04, 0x2C, "Minet, Inc."}, {
	0x00, 0x04, 0x2D, "Sarian Systems, Ltd."}, {
	0x00, 0x04, 0x2E, "Netous Technologies, Ltd."}, {
	0x00, 0x04, 0x2F, "International Communications Products, Inc."}, {
	0x00, 0x04, 0x30, "Netgem"}, {
	0x00, 0x04, 0x31, "GlobalStreams, Inc."}, {
	0x00, 0x04, 0x32, "Voyetra Turtle Beach, Inc."}, {
	0x00, 0x04, 0x33, "Cyberboard A/S"}, {
	0x00, 0x04, 0x34, "Accelent Systems, Inc."}, {
	0x00, 0x04, 0x35, "Comptek International, Inc."}, {
	0x00, 0x04, 0x36, "ELANsat Technologies, Inc."}, {
	0x00, 0x04, 0x37, "Powin Information Technology, Inc."}, {
	0x00, 0x04, 0x38, "Nortel Networks"}, {
	0x00, 0x04, 0x39, "Rosco Entertainment Technology, Inc."}, {
	0x00, 0x04, 0x3A, "Intelligent Telecommunications, Inc."}, {
	0x00, 0x04, 0x3B, "Lava Computer Mfg., Inc."}, {
	0x00, 0x04, 0x3C, "SONOS Co., Ltd."}, {
	0x00, 0x04, 0x3D, "INDEL AG"}, {
	0x00, 0x04, 0x3E, "Telencomm"}, {
	0x00, 0x04, 0x3F, "Electronic Systems Technology, Inc."}, {
	0x00, 0x04, 0x40, "cyberPIXIE, Inc."}, {
	0x00, 0x04, 0x41, "Half Dome Systems, Inc."}, {
	0x00, 0x04, 0x42, "NACT"}, {
	0x00, 0x04, 0x43, "Agilent Technologies, Inc."}, {
	0x00, 0x04, 0x44, "Western Multiplex Corporation"}, {
	0x00, 0x04, 0x45, "LMS Skalar Instruments GmbH"}, {
	0x00, 0x04, 0x46, "CYZENTECH Co., Ltd."}, {
	0x00, 0x04, 0x47, "Acrowave Systems Co., Ltd."}, {
	0x00, 0x04, 0x48, "Polaroid Professional Imaging"}, {
	0x00, 0x04, 0x49, "Mapletree Networks"}, {
	0x00, 0x04, 0x4A, "iPolicy Networks, Inc."}, {
	0x00, 0x04, 0x4B, "NVIDIA"}, {
	0x00, 0x04, 0x4C, "JENOPTIK"}, {
	0x00, 0x04, 0x4D, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x4E, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x4F, "Leukhardt Systemelektronik GmbH"}, {
	0x00, 0x04, 0x50, "DMD Computers SRL"}, {
	0x00, 0x04, 0x51, "Medrad, Inc."}, {
	0x00, 0x04, 0x52, "RocketLogix, Inc."}, {
	0x00, 0x04, 0x53, "YottaYotta, Inc."}, {
	0x00, 0x04, 0x54, "Quadriga UK"}, {
	0x00, 0x04, 0x55, "ANTARA.net"}, {
	0x00, 0x04, 0x56, "PipingHot Networks"}, {
	0x00, 0x04, 0x57, "Universal Access Technology, Inc."}, {
	0x00, 0x04, 0x58, "Fusion X Co., Ltd."}, {
	0x00, 0x04, 0x59, "Veristar Corporation"}, {
	0x00, 0x04, 0x5A, "The Linksys Group, Inc."}, {
	0x00, 0x04, 0x5B, "Techsan Electronics Co., Ltd."}, {
	0x00, 0x04, 0x5C, "Mobiwave Pte Ltd"}, {
	0x00, 0x04, 0x5D, "BEKA Elektronik"}, {
	0x00, 0x04, 0x5E, "PolyTrax Information Technology AG"}, {
	0x00, 0x04, 0x5F, "Evalue Technology, Inc."}, {
	0x00, 0x04, 0x60, "Knilink Technology, Inc."}, {
	0x00, 0x04, 0x61, "EPOX Computer Co., Ltd."}, {
	0x00, 0x04, 0x62, "DAKOS Data & Communication Co., Ltd."}, {
	0x00, 0x04, 0x63, "Philips Communication Security & Imaging"}, {
	0x00, 0x04, 0x64, "Fantasma Networks, Inc."}, {
	0x00, 0x04, 0x65, "i.s.t isdn-support technik GmbH"}, {
	0x00, 0x04, 0x66, "ARMITEL Co."}, {
	0x00, 0x04, 0x67, "Wuhan Research Institute of MII"}, {
	0x00, 0x04, 0x68, "Vivity, Inc."}, {
	0x00, 0x04, 0x69, "Innocom, Inc."}, {
	0x00, 0x04, 0x6A, "Navini Networks"}, {
	0x00, 0x04, 0x6B, "Palm Wireless, Inc."}, {
	0x00, 0x04, 0x6C, "Cyber Technology Co., Ltd."}, {
	0x00, 0x04, 0x6D, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x6E, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x6F, "Digitel S/A Industria Eletronica"}, {
	0x00, 0x04, 0x70, "ipUnplugged AB"}, {
	0x00, 0x04, 0x71, "IPrad"}, {
	0x00, 0x04, 0x72, "Telelynx, Inc."}, {
	0x00, 0x04, 0x73, "Photonex Corporation"}, {
	0x00, 0x04, 0x74, "LEGRAND"}, {
	0x00, 0x04, 0x75, "3 Com Corporation"}, {
	0x00, 0x04, 0x76, "3 Com Corporation"}, {
	0x00, 0x04, 0x77, "Scalant Systems, Inc."}, {
	0x00, 0x04, 0x78, "G. Star Technology Corporation"}, {
	0x00, 0x04, 0x79, "Radius Co., Ltd."}, {
	0x00, 0x04, 0x7A, "AXXESSIT ASA"}, {
	0x00, 0x04, 0x7B, "Schlumberger"}, {
	0x00, 0x04, 0x7C, "Skidata AG"}, {
	0x00, 0x04, 0x7D, "Pelco"}, {
	0x00, 0x04, 0x7E, "NKF Electronics"}, {
	0x00, 0x04, 0x7F, "Chr. Mayr GmbH & Co. KG"}, {
	0x00, 0x04, 0x80, "Foundry Networks, Inc."}, {
	0x00, 0x04, 0x81, "Econolite Control Products, Inc."}, {
	0x00, 0x04, 0x82, "Medialogic Corp."}, {
	0x00, 0x04, 0x83, "Deltron Technology, Inc."}, {
	0x00, 0x04, 0x84, "Amann GmbH"}, {
	0x00, 0x04, 0x85, "PicoLight"}, {
	0x00, 0x04, 0x86, "ITTC, University of Kansas"}, {
	0x00, 0x04, 0x87, "Cogency Semiconductor, Inc."}, {
	0x00, 0x04, 0x88, "Eurotherm Action Incorporated."}, {
	0x00, 0x04, 0x89, "YAFO Networks, Inc."}, {
	0x00, 0x04, 0x8A, "Temia Vertriebs GmbH"}, {
	0x00, 0x04, 0x8B, "Poscon Corporation"}, {
	0x00, 0x04, 0x8C, "Nayna Networks, Inc."}, {
	0x00, 0x04, 0x8D, "Tone Commander Systems, Inc."}, {
	0x00, 0x04, 0x8E, "Ohm Tech Labs, Inc."}, {
	0x00, 0x04, 0x8F, "TD Systems Corp."}, {
	0x00, 0x04, 0x90, "Optical Access"}, {
	0x00, 0x04, 0x91, "Technovision, Inc."}, {
	0x00, 0x04, 0x92, "Hive Internet, Ltd."}, {
	0x00, 0x04, 0x93, "Tsinghua Unisplendour Co., Ltd."}, {
	0x00, 0x04, 0x94, "Breezecom, Ltd."}, {
	0x00, 0x04, 0x95, "Tejas Networks"}, {
	0x00, 0x04, 0x96, "Extreme Networks"}, {
	0x00, 0x04, 0x97, "MacroSystem Digital Video AG"}, {
	0x00, 0x04, 0x99, "Chino Corporation"}, {
	0x00, 0x04, 0x9A, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x9B, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0x9C, "Surgient Networks, Inc."}, {
	0x00, 0x04, 0x9D, "Ipanema Technologies"}, {
	0x00, 0x04, 0x9E, "Wirelink Co., Ltd."}, {
	0x00, 0x04, 0x9F, "Metrowerks"}, {
	0x00, 0x04, 0xA0, "Verity Instruments, Inc."}, {
	0x00, 0x04, 0xA1, "Pathway Connectivity"}, {
	0x00, 0x04, 0xA2, "L.S.I. Japan Co., Ltd."}, {
	0x00, 0x04, 0xA3, "Microchip Technology, Inc."}, {
	0x00, 0x04, 0xA4, "NetEnabled, Inc."}, {
	0x00, 0x04, 0xA5, "Barco Projection Systems NV"}, {
	0x00, 0x04, 0xA6, "SAF Tehnika Ltd."}, {
	0x00, 0x04, 0xA7, "FabiaTech Corporation"}, {
	0x00, 0x04, 0xA8, "Broadmax Technologies, Inc."}, {
	0x00, 0x04, 0xA9, "SandStream Technologies, Inc."}, {
	0x00, 0x04, 0xAA, "Jetstream Communications"}, {
	0x00, 0x04, 0xAB, "Comverse Network Systems, Inc."}, {
	0x00, 0x04, 0xAC, "IBM CORP."}, {
	0x00, 0x04, 0xAD, "Malibu Networks"}, {
	0x00, 0x04, 0xAE, "Liquid Metronics"}, {
	0x00, 0x04, 0xAF, "Digital Fountain, Inc."}, {
	0x00, 0x04, 0xB0, "ELESIGN Co., Ltd."}, {
	0x00, 0x04, 0xB1, "Signal Technology, Inc."}, {
	0x00, 0x04, 0xB2, "ESSEGI SRL"}, {
	0x00, 0x04, 0xB3, "Videotek, Inc."}, {
	0x00, 0x04, 0xB4, "CIAC"}, {
	0x00, 0x04, 0xB5, "Equitrac Corporation"}, {
	0x00, 0x04, 0xB6, "Tellumat (Pty) Ltd."}, {
	0x00, 0x04, 0xB7, "AMB i.t. Holding"}, {
	0x00, 0x04, 0xB8, "Kumahira Co., Ltd."}, {
	0x00, 0x04, 0xB9, "S.I. Soubou, Inc."}, {
	0x00, 0x04, 0xBA, "KDD Media Will Corporation"}, {
	0x00, 0x04, 0xBB, "Bardac Corporation"}, {
	0x00, 0x04, 0xBC, "Giantec, Inc."}, {
	0x00, 0x04, 0xBD, "Motorola BCS"}, {
	0x00, 0x04, 0xBE, "OptXCon, Inc."}, {
	0x00, 0x04, 0xBF, "VersaLogic Corp."}, {
	0x00, 0x04, 0xC0, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0xC1, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0xC2, "Magnipix, Inc."}, {
	0x00, 0x04, 0xC3, "CASTOR Informatique"}, {
	0x00, 0x04, 0xC4, "Allen & Health Limited"}, {
	0x00, 0x04, 0xC5, "ASE Technologies, USA"}, {
	0x00, 0x04, 0xC6, "Yamaha Motor Co., Ltd."}, {
	0x00, 0x04, 0xC7, "NetMount"}, {
	0x00, 0x04, 0xC8, "LIBA Maschinenfabrik GmbH"}, {
	0x00, 0x04, 0xC9, "Micro Electron Co., Ltd."}, {
	0x00, 0x04, 0xCA, "FreeMs Corp."}, {
	0x00, 0x04, 0xCB, "Tdsoft Communication, Ltd."}, {
	0x00, 0x04, 0xCC, "Peek Traffic B.V."}, {
	0x00, 0x04, 0xCD, "Informedia Research Group"}, {
	0x00, 0x04, 0xCE, "Patria Ailon"}, {
	0x00, 0x04, 0xCF, "Seagate Technology"}, {
	0x00, 0x04, 0xD0, "Softlink s.r.o."}, {
	0x00, 0x04, 0xD1, "Drew Technologies, Inc."}, {
	0x00, 0x04, 0xD2, "Adcon Telemetry AG"}, {
	0x00, 0x04, 0xD3, "Toyokeiki Co., Ltd."}, {
	0x00, 0x04, 0xD4, "Proview Electronics Co., Ltd."}, {
	0x00, 0x04, 0xD5, "Hitachi Communication Systems, Inc."}, {
	0x00, 0x04, 0xD6, "Takagi Industrial Co., Ltd."}, {
	0x00, 0x04, 0xD7, "Omitec Instrumentation Ltd."}, {
	0x00, 0x04, 0xD8, "IPWireless, Inc."}, {
	0x00, 0x04, 0xD9, "Titan Electronics, Inc."}, {
	0x00, 0x04, 0xDA, "Relax Technology, Inc."}, {
	0x00, 0x04, 0xDB, "Tellus Group Corp."}, {
	0x00, 0x04, 0xDC, "Nortel Networks"}, {
	0x00, 0x04, 0xDD, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0xDE, "Cisco Systems, Inc."}, {
	0x00, 0x04, 0xDF, "Teracom Telematica Ltda."}, {
	0x00, 0x04, 0xE0, "Procket Networks"}, {
	0x00, 0x04, 0xE1, "Infinior Microsystems"}, {
	0x00, 0x04, 0xE2, "SMC Networks, Inc."}, {
	0x00, 0x04, 0xE3, "Accton Technology Corp."}, {
	0x00, 0x04, 0xE4, "Daeryung Ind., Inc."}, {
	0x00, 0x04, 0xE5, "Glonet Systems, Inc."}, {
	0x00, 0x04, 0xE6, "Banyan Network Private Limited"}, {
	0x00, 0x04, 0xE7, "Lightpointe Communications, Inc"}, {
	0x00, 0x04, 0xE8, "IER, Inc."}, {
	0x00, 0x04, 0xE9, "Infiniswitch Corporation"}, {
	0x00, 0x04, 0xEA, "Hewlett-Packard Company"}, {
	0x00, 0x04, 0xEB, "Paxonet Communications, Inc."}, {
	0x00, 0x04, 0xEC, "Memobox SA"}, {
	0x00, 0x04, 0xED, "Billion Electric Co., Ltd."}, {
	0x00, 0x04, 0xEE, "Lincoln Electric Company"}, {
	0x00, 0x04, 0xEF, "Polestar Corp."}, {
	0x00, 0x04, 0xF0, "International Computers, Ltd"}, {
	0x00, 0x04, 0xF1, "WhereNet"}, {
	0x00, 0x04, 0xF2, "Circa Communications, Ltd."}, {
	0x00, 0x04, 0xF3, "FS FORTH-SYSTEME GmbH"}, {
	0x00, 0x04, 0xF4, "Infinite Electronics Inc."}, {
	0x00, 0x04, 0xF5, "SnowShore Networks, Inc."}, {
	0x00, 0x04, 0xF6, "Amphus"}, {
	0x00, 0x04, 0xF7, "Omega Band, Inc."}, {
	0x00, 0x04, 0xF8, "QUALICABLE TV Industria E Com., Ltda"}, {
	0x00, 0x04, 0xF9, "Xtera Communications, Inc."}, {
	0x00, 0x04, 0xFA, "MIST Inc."}, {
	0x00, 0x04, 0xFB, "Commtech, Inc."}, {
	0x00, 0x04, 0xFC, "Stratus Computer (DE), Inc."}, {
	0x00, 0x04, 0xFD, "Japan Control Engineering Co., Ltd."}, {
	0x00, 0x04, 0xFE, "Pelago Networks"}, {
	0x00, 0x04, 0xFF, "Acronet Co., Ltd."}, {
	0x00, 0x05, 0x00, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x01, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x02, "APPLE COMPUTER"}, {
	0x00, 0x05, 0x03, "ICONAG"}, {
	0x00, 0x05, 0x04, "Naray Information & Communication Enterprise"},
	{
	0x00, 0x05, 0x05, "Systems Integration Solutions, Inc."}, {
	0x00, 0x05, 0x06, "Reddo Networks AB"}, {
	0x00, 0x05, 0x07, "Fine Appliance Corp."}, {
	0x00, 0x05, 0x08, "Inetcam, Inc."}, {
	0x00, 0x05, 0x09, "AVOC Nishimura Ltd."}, {
	0x00, 0x05, 0x0A, "ICS Spa"}, {
	0x00, 0x05, 0x0B, "SICOM Systems, Inc."}, {
	0x00, 0x05, 0x0C, "Network Photonics, Inc."}, {
	0x00, 0x05, 0x0D, "Midstream Technologies, Inc."}, {
	0x00, 0x05, 0x0E, "3ware, Inc."}, {
	0x00, 0x05, 0x0F, "Tanaka S/S Ltd."}, {
	0x00, 0x05, 0x10,
		"Infinite Shanghai Communication Terminals Ltd."}, {
	0x00, 0x05, 0x11, "Complementary Technologies Ltd"}, {
	0x00, 0x05, 0x12, "MeshNetworks, Inc."}, {
	0x00, 0x05, 0x13, "VTLinx Multimedia Systems, Inc."}, {
	0x00, 0x05, 0x14, "KDT Systems Co., Ltd."}, {
	0x00, 0x05, 0x15, "Nuark Co., Ltd."}, {
	0x00, 0x05, 0x16, "SMART Modular Technologies"}, {
	0x00, 0x05, 0x17, "Shellcomm, Inc."}, {
	0x00, 0x05, 0x18, "Jupiters Technology"}, {
	0x00, 0x05, 0x19, "Siemens Building Technologies AG,"}, {
	0x00, 0x05, 0x1A, "3Com Europe Ltd."}, {
	0x00, 0x05, 0x1B, "Magic Control Technology Corporation"}, {
	0x00, 0x05, 0x1C, "Xnet Technology Corp."}, {
	0x00, 0x05, 0x1D, "Airocon, Inc."}, {
	0x00, 0x05, 0x1E, "Rhapsody Networks"}, {
	0x00, 0x05, 0x1F, "Taijin Media Co., Ltd."}, {
	0x00, 0x05, 0x20, "Smartronix, Inc."}, {
	0x00, 0x05, 0x21, "Control Microsystems"}, {
	0x00, 0x05, 0x22, "LEA*D Corporation, Inc."}, {
	0x00, 0x05, 0x23, "AVL List GmbH"}, {
	0x00, 0x05, 0x24, "BTL System (HK) Limited"}, {
	0x00, 0x05, 0x25, "Puretek Industrial Co., Ltd."}, {
	0x00, 0x05, 0x26, "IPAS GmbH"}, {
	0x00, 0x05, 0x27, "SJ Tek Co. Ltd"}, {
	0x00, 0x05, 0x28, "New Focus, Inc."}, {
	0x00, 0x05, 0x29,
		"Shanghai Broadan Communication Technology Co., Ltd"}, {
	0x00, 0x05, 0x2A, "Ikegami Tsushinki Co., Ltd."}, {
	0x00, 0x05, 0x2B, "HORIBA, Ltd."}, {
	0x00, 0x05, 0x2C, "Supreme Magic Corporation"}, {
	0x00, 0x05, 0x2D, "Zoltrix International Limited"}, {
	0x00, 0x05, 0x2E, "Cinta Networks"}, {
	0x00, 0x05, 0x2F, "Leviton Voice and Data"}, {
	0x00, 0x05, 0x30, "Andiamo Systems, Inc."}, {
	0x00, 0x05, 0x31, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x32, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x33, "Sanera Systems, Inc."}, {
	0x00, 0x05, 0x34, "Northstar Engineering Ltd."}, {
	0x00, 0x05, 0x35, "Chip PC Ltd."}, {
	0x00, 0x05, 0x36, "Danam Communications, Inc."}, {
	0x00, 0x05, 0x37, "Nets Technology Co., Ltd."}, {
	0x00, 0x05, 0x38, "Merilus, Inc."}, {
	0x00, 0x05, 0x39, "A Brand New World in Sweden AB"}, {
	0x00, 0x05, 0x3A, "Willowglen Services Pte Ltd"}, {
	0x00, 0x05, 0x3B, "Harbour Networks Ltd., Co. Beijing"}, {
	0x00, 0x05, 0x3C, "Xircom"}, {
	0x00, 0x05, 0x3D, "Agere Systems"}, {
	0x00, 0x05, 0x3E, "KID Systeme GmbH"}, {
	0x00, 0x05, 0x3F, "VisionTek, Inc."}, {
	0x00, 0x05, 0x40, "FAST Corporation"}, {
	0x00, 0x05, 0x41, "Advanced Systems Co., Ltd."}, {
	0x00, 0x05, 0x42, "Otari, Inc."}, {
	0x00, 0x05, 0x43, "IQ Wireless GmbH"}, {
	0x00, 0x05, 0x44, "Valley Technologies, Inc."}, {
	0x00, 0x05, 0x45, "Internet Photonics"}, {
	0x00, 0x05, 0x46, "KDD Network Systems Co., Ltd."}, {
	0x00, 0x05, 0x47, "Starent Networks"}, {
	0x00, 0x05, 0x48, "Disco Corporation"}, {
	0x00, 0x05, 0x49, "Salira Optical Network Systems"}, {
	0x00, 0x05, 0x4A, "Ario Data Networks, Inc."}, {
	0x00, 0x05, 0x4B, "Micro Innovation AG"}, {
	0x00, 0x05, 0x4C, "RF Innovations Pty Ltd"}, {
	0x00, 0x05, 0x4D, "Brans Technologies, Inc."}, {
	0x00, 0x05, 0x4E, "Philips Components"}, {
	0x00, 0x05, 0x50, "Digi-Tech Communications Limited"}, {
	0x00, 0x05, 0x51, "F & S Elektronik Systeme GmbH"}, {
	0x00, 0x05, 0x52, "Xycotec Computer GmbH"}, {
	0x00, 0x05, 0x53, "DVC Company, Inc."}, {
	0x00, 0x05, 0x54, "Rangestar Wireless"}, {
	0x00, 0x05, 0x55, "Japan Cash Machine Co., Ltd."}, {
	0x00, 0x05, 0x56, "360 Systems"}, {
	0x00, 0x05, 0x57, "Agile TV Corporation"}, {
	0x00, 0x05, 0x58, "Synchronous, Inc."}, {
	0x00, 0x05, 0x59, "Intracom S.A."}, {
	0x00, 0x05, 0x5A, "Power Dsine Ltd."}, {
	0x00, 0x05, 0x5B, "Charles Industries, Ltd."}, {
	0x00, 0x05, 0x5C, "Kowa Company, Ltd."}, {
	0x00, 0x05, 0x5D, "D-Link Systems, Inc."}, {
	0x00, 0x05, 0x5E, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x5F, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x60, "LEADER COMM.CO., LTD"}, {
	0x00, 0x05, 0x61, "nac Image Technology, Inc."}, {
	0x00, 0x05, 0x62, "Digital View Limited"}, {
	0x00, 0x05, 0x63, "J-Works, Inc."}, {
	0x00, 0x05, 0x64, "Tsinghua Bitway Co., Ltd."}, {
	0x00, 0x05, 0x65, "Tailyn Communication Company Ltd."}, {
	0x00, 0x05, 0x66, "Secui.com Corporation"}, {
	0x00, 0x05, 0x67, "Etymonic Design, Inc."}, {
	0x00, 0x05, 0x68, "Piltofish Networks AB"}, {
	0x00, 0x05, 0x69, "VMWARE, Inc."}, {
	0x00, 0x05, 0x6B, "C.P. Technology Co., Ltd."}, {
	0x00, 0x05, 0x6C, "Hung Chang Co., Ltd."}, {
	0x00, 0x05, 0x6D, "Pacific Corporation"}, {
	0x00, 0x05, 0x6E, "National Enhance Technology, Inc."}, {
	0x00, 0x05, 0x6F, "Innomedia Technologies Pvt. Ltd."}, {
	0x00, 0x05, 0x70, "Baydel Ltd."}, {
	0x00, 0x05, 0x71, "Seiwa Electronics Co."}, {
	0x00, 0x05, 0x72, "Deonet Co., Ltd."}, {
	0x00, 0x05, 0x73, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x74, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x75, "CDS-Electronics BV"}, {
	0x00, 0x05, 0x76, "NSM Technology Ltd."}, {
	0x00, 0x05, 0x77, "SM Information & Communication"}, {
	0x00, 0x05, 0x79, "Universal Control Solution Corp."}, {
	0x00, 0x05, 0x7A, "Hatteras Networks"}, {
	0x00, 0x05, 0x7B, "Chung Nam Electronic Co., Ltd."}, {
	0x00, 0x05, 0x7C, "RCO Security AB"}, {
	0x00, 0x05, 0x7D, "Sun Communications, Inc."}, {
	0x00, 0x05, 0x7E, "Eckelmann Steuerungstechnik GmbH"}, {
	0x00, 0x05, 0x7F, "Acqis Technology"}, {
	0x00, 0x05, 0x80, "Fibrolan Ltd."}, {
	0x00, 0x05, 0x81, "Snell & Wilcox Ltd."}, {
	0x00, 0x05, 0x82, "ClearCube Technology"}, {
	0x00, 0x05, 0x83, "ImageCom Limited"}, {
	0x00, 0x05, 0x84, "AbsoluteValue Systems, Inc."}, {
	0x00, 0x05, 0x85, "Juniper Networks, Inc."}, {
	0x00, 0x05, 0x86, "Lucent Technologies"}, {
	0x00, 0x05, 0x87, "Locus, Incorporated"}, {
	0x00, 0x05, 0x88, "Sensoria Corp."}, {
	0x00, 0x05, 0x89, "National Datacomputer"}, {
	0x00, 0x05, 0x8A, "Netcom Co., Ltd."}, {
	0x00, 0x05, 0x8B, "IPmental, Inc."}, {
	0x00, 0x05, 0x8C, "Opentech Inc."}, {
	0x00, 0x05, 0x8D, "Lynx Photonic Networks, Inc."}, {
	0x00, 0x05, 0x8E, "Ahead Communications System GmbH"}, {
	0x00, 0x05, 0x8F, "CLCsoft co."}, {
	0x00, 0x05, 0x90, "Swissvoice Ltd."}, {
	0x00, 0x05, 0x91, "Active Silicon Ltd."}, {
	0x00, 0x05, 0x92, "Pultek Corp."}, {
	0x00, 0x05, 0x93, "Grammar Engine Inc."}, {
	0x00, 0x05, 0x94, "IXXAT Automation GmbH"}, {
	0x00, 0x05, 0x95, "Alesis Corporation"}, {
	0x00, 0x05, 0x96, "Genotech Co., Ltd."}, {
	0x00, 0x05, 0x97, "Eagle Traffic Control Systems"}, {
	0x00, 0x05, 0x98, "CRONOS S.r.l."}, {
	0x00, 0x05, 0x99, "PEI Electronics, Inc."}, {
	0x00, 0x05, 0x9A, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x9B, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0x9C, "Kleinknecht GmbH, Ing. Buero"}, {
	0x00, 0x05, 0x9D, "Daniel Computing Systems, Inc."}, {
	0x00, 0x05, 0x9E, "Zinwell Corporation"}, {
	0x00, 0x05, 0x9F, "Yotta Networks, Inc."}, {
	0x00, 0x05, 0xA0, "MOBILINE Kft."}, {
	0x00, 0x05, 0xA1, "Zenocom"}, {
	0x00, 0x05, 0xA2, "CELOX Networks"}, {
	0x00, 0x05, 0xA3, "QEI, Inc."}, {
	0x00, 0x05, 0xA4, "Lucid Voice Ltd."}, {
	0x00, 0x05, 0xA5, "KOTT"}, {
	0x00, 0x05, 0xA6, "Extron Electronics"}, {
	0x00, 0x05, 0xA7, "Hyperchip, Inc."}, {
	0x00, 0x05, 0xA8, "WYLE ELECTRONICS"}, {
	0x00, 0x05, 0xA9, "Princeton Networks, Inc."}, {
	0x00, 0x05, 0xAA, "Moore Industries International Inc."}, {
	0x00, 0x05, 0xAB, "Cyber Fone, Inc."}, {
	0x00, 0x05, 0xAC, "Northern Digital, Inc."}, {
	0x00, 0x05, 0xAD, "Topspin Communications, Inc."}, {
	0x00, 0x05, 0xAE, "Mediaport USA"}, {
	0x00, 0x05, 0xAF, "InnoScan Computing A/S"}, {
	0x00, 0x05, 0xB0, "Korea Computer Technology Co., Ltd."}, {
	0x00, 0x05, 0xB1, "ASB Technology BV"}, {
	0x00, 0x05, 0xB2, "Medison Co., Ltd."}, {
	0x00, 0x05, 0xB3, "Asahi-Engineering Co., Ltd."}, {
	0x00, 0x05, 0xB4, "Aceex Corporation"}, {
	0x00, 0x05, 0xB5, "Broadcom Technologies"}, {
	0x00, 0x05, 0xB6, "INSYS Microelectronics GmbH"}, {
	0x00, 0x05, 0xB7, "Arbor Technology Corp."}, {
	0x00, 0x05, 0xB8, "Electronic Design Associates, Inc."}, {
	0x00, 0x05, 0xB9, "Airvana, Inc."}, {
	0x00, 0x05, 0xBA, "Area Netwoeks, Inc."}, {
	0x00, 0x05, 0xBB, "Myspace AB"}, {
	0x00, 0x05, 0xBC, "Resorsys Ltd."}, {
	0x00, 0x05, 0xBD, "ROAX BV"}, {
	0x00, 0x05, 0xBE, "Kongsberg Seatex AS"}, {
	0x00, 0x05, 0xBF, "JustEzy Technology, Inc."}, {
	0x00, 0x05, 0xC0, "Digital Network Alacarte Co., Ltd."}, {
	0x00, 0x05, 0xC1, "A-Kyung Motion, Inc."}, {
	0x00, 0x05, 0xC2, "Digital Archway, Inc."}, {
	0x00, 0x05, 0xC3, "Pacific Instruments, Inc."}, {
	0x00, 0x05, 0xC4, "Telect, Inc."}, {
	0x00, 0x05, 0xC5, "Flaga HF"}, {
	0x00, 0x05, 0xC6, "Triz Communications"}, {
	0x00, 0x05, 0xC7, "I/F-COM A/S"}, {
	0x00, 0x05, 0xC8, "VERYTECH"}, {
	0x00, 0x05, 0xC9, "LG Innotek"}, {
	0x00, 0x05, 0xCA, "Hitron Technology, Inc."}, {
	0x00, 0x05, 0xCB, "ROIS Technologies, Inc."}, {
	0x00, 0x05, 0xCC, "Sumtel Communications, Inc."}, {
	0x00, 0x05, 0xCD, "Denon, Ltd."}, {
	0x00, 0x05, 0xCE, "Prolink Microsystems Corporation"}, {
	0x00, 0x05, 0xCF, "Thunder River Technologies, Inc."}, {
	0x00, 0x05, 0xD0, "Solinet Systems"}, {
	0x00, 0x05, 0xD1, "Metavector Technologies"}, {
	0x00, 0x05, 0xD2, "DAP Technologies"}, {
	0x00, 0x05, 0xD3, "eProduction Solutions, Inc."}, {
	0x00, 0x05, 0xD4, "FutureSmart Networks, Inc."}, {
	0x00, 0x05, 0xD5, "Speedcom Wireless"}, {
	0x00, 0x05, 0xD6, "Titan Wireless"}, {
	0x00, 0x05, 0xD7, "Vista Imaging, Inc."}, {
	0x00, 0x05, 0xD8, "Arescom, Inc."}, {
	0x00, 0x05, 0xD9, "Techno Valley, Inc."}, {
	0x00, 0x05, 0xDA, "Apex Automationstechnik"}, {
	0x00, 0x05, 0xDB, "Nentec GmbH"}, {
	0x00, 0x05, 0xDC, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0xDD, "Cisco Systems, Inc."}, {
	0x00, 0x05, 0xDE, "Gi Fone Korea, Inc."}, {
	0x00, 0x05, 0xDF, "Electronic Innovation, Inc."}, {
	0x00, 0x05, 0xE0, "Empirix Corp."}, {
	0x00, 0x05, 0xE1, "Trellis Photonics, Ltd."}, {
	0x00, 0x05, 0xE2, "Creativ Network Technologies"}, {
	0x00, 0x05, 0xE3, "LightSand Communications, Inc."}, {
	0x00, 0x05, 0xE4, "Red Lion Controls L.P."}, {
	0x00, 0x05, 0xE5, "Renishaw PLC"}, {
	0x00, 0x05, 0xE6, "Egenera, Inc."}, {
	0x00, 0x05, 0xE7, "Netrake Corp."}, {
	0x00, 0x05, 0xE8, "TurboWave, Inc."}, {
	0x00, 0x05, 0xE9, "Unicess Network, Inc."}, {
	0x00, 0x05, 0xEA, "Rednix"}, {
	0x00, 0x05, 0xEB, "Blue Ridge Networks, Inc."}, {
	0x00, 0x05, 0xEC, "Mosaic Systems Inc."}, {
	0x00, 0x05, 0xED, "Technikum Joanneum GmbH"}, {
	0x00, 0x05, 0xEE, "BEWATOR Group"}, {
	0x00, 0x05, 0xEF, "ADOIR Digital Technology"}, {
	0x00, 0x05, 0xF0, "SATEC"}, {
	0x00, 0x05, 0xF1, "Vrcom, Inc."}, {
	0x00, 0x05, 0xF2, "Power R, Inc."}, {
	0x00, 0x05, 0xF3, "Weboyn"}, {
	0x00, 0x05, 0xF4, "System Base Co., Ltd."}, {
	0x00, 0x05, 0xF5, "OYO Geospace Corp."}, {
	0x00, 0x05, 0xF6, "Young Chang Co. Ltd."}, {
	0x00, 0x05, 0xF7, "Analog Devices, Inc."}, {
	0x00, 0x05, 0xF8, "Real Time Access, Inc."}, {
	0x00, 0x05, 0xF9, "TOA Corporation"}, {
	0x00, 0x05, 0xFA, "IPOptical, Inc."}, {
	0x00, 0x05, 0xFB, "ShareGate, Inc."}, {
	0x00, 0x05, 0xFC, "Schenck Pegasus Corp."}, {
	0x00, 0x05, 0xFD, "PacketLight Networks Ltd."}, {
	0x00, 0x05, 0xFE, "Traficon N.V."}, {
	0x00, 0x05, 0xFF, "SNS Solutions, Inc."}, {
	0x00, 0x06, 0x00, "Tokyo Electronic Industry Co., Ltd."}, {
	0x00, 0x06, 0x01, "Otanikeiki Co., Ltd."}, {
	0x00, 0x06, 0x02, "Cirkitech Electronics Co."}, {
	0x00, 0x06, 0x03, "Baker Hughes Inc."}, {
	0x00, 0x06, 0x04, "@Track Communications, Inc."}, {
	0x00, 0x06, 0x05, "Inncom International, Inc."}, {
	0x00, 0x06, 0x06, "RapidWAN, Inc."}, {
	0x00, 0x06, 0x07, "Omni Directional Control Technology Inc."}, {
	0x00, 0x06, 0x08, "At-Sky SAS"}, {
	0x00, 0x06, 0x09, "Crossport Systems"}, {
	0x00, 0x06, 0x0A, "Blue2space"}, {
	0x00, 0x06, 0x0B, "Paceline Systems Corporation"}, {
	0x00, 0x06, 0x0C, "Melco Industries, Inc."}, {
	0x00, 0x06, 0x0D, "Wave7 Optics"}, {
	0x00, 0x06, 0x0E, "IGYS Systems, Inc."}, {
	0x00, 0x06, 0x0F, "Narad Networks Inc"}, {
	0x00, 0x06, 0x10, "Abeona Networks Inc"}, {
	0x00, 0x06, 0x11, "Zeus Wireless, Inc."}, {
	0x00, 0x06, 0x12, "Accusys, Inc."}, {
	0x00, 0x06, 0x13, "Kawasaki Microelectronics Incorporated"}, {
	0x00, 0x06, 0x14, "Prism Holdings"}, {
	0x00, 0x06, 0x15, "Kimoto Electric Co., Ltd."}, {
	0x00, 0x06, 0x16, "Tel Net Co., Ltd."}, {
	0x00, 0x06, 0x17, "Redswitch Inc."}, {
	0x00, 0x06, 0x18, "DigiPower Manufacturing Inc."}, {
	0x00, 0x06, 0x19, "Connection Technology Systems"}, {
	0x00, 0x06, 0x1A, "Zetari Inc."}, {
	0x00, 0x06, 0x1B, "Portable Systems, IBM Japan Co, Ltd"}, {
	0x00, 0x06, 0x1C, "Hoshino Metal Industries, Ltd."}, {
	0x00, 0x06, 0x1D, "MIP Telecom, Inc."}, {
	0x00, 0x06, 0x1E, "Maxan Systems"}, {
	0x00, 0x06, 0x1F, "Vision Components GmbH"}, {
	0x00, 0x06, 0x20, "Serial System Ltd."}, {
	0x00, 0x06, 0x21, "Hinox, Co., Ltd."}, {
	0x00, 0x06, 0x22, "Chung Fu Chen Yeh Enterprise Corp."}, {
	0x00, 0x06, 0x23, "MGE UPS Systems France"}, {
	0x00, 0x06, 0x24, "Gentner Communications Corp."}, {
	0x00, 0x06, 0x25, "The Linksys Group, Inc."}, {
	0x00, 0x06, 0x26, "MWE GmbH"}, {
	0x00, 0x06, 0x27, "Uniwide Technologies, Inc."}, {
	0x00, 0x06, 0x28, "Cisco Systems, Inc."}, {
	0x00, 0x06, 0x29, "IBM CORPORATION"}, {
	0x00, 0x06, 0x2A, "Cisco Systems, Inc."}, {
	0x00, 0x06, 0x2B, "INTRASERVER TECHNOLOGY"}, {
	0x00, 0x06, 0x2C, "Network Robots, Inc."}, {
	0x00, 0x06, 0x2D, "TouchStar Technologies, L.L.C."}, {
	0x00, 0x06, 0x2E, "Aristos Logic Corp."}, {
	0x00, 0x06, 0x2F, "Pivotech Systems Inc."}, {
	0x00, 0x06, 0x30, "Adtranz Sweden"}, {
	0x00, 0x06, 0x31, "Optical Solutions, Inc."}, {
	0x00, 0x06, 0x32, "Mesco Engineering GmbH"}, {
	0x00, 0x06, 0x33, "Heimann Biometric Systems GmbH"}, {
	0x00, 0x06, 0x34, "GTE Airfone Inc."}, {
	0x00, 0x06, 0x35, "PacketAir Networks, Inc."}, {
	0x00, 0x06, 0x36, "Jedai Broadband Networks"}, {
	0x00, 0x06, 0x37, "Toptrend-Meta Information (ShenZhen) Inc."}, {
	0x00, 0x06, 0x38, "Sungjin C&C Co., Ltd."}, {
	0x00, 0x06, 0x39, "Newtec"}, {
	0x00, 0x06, 0x3A, "Dura Micro, Inc."}, {
	0x00, 0x06, 0x3B, "Arcturus Networks, Inc."}, {
	0x00, 0x06, 0x3C, "NMI Electronics Ltd"}, {
	0x00, 0x06, 0x3D, "Microwave Data Systems Inc."}, {
	0x00, 0x06, 0x3E, "Opthos Inc."}, {
	0x00, 0x06, 0x3F, "Everex Communications Inc."}, {
	0x00, 0x06, 0x40, "White Rock Networks"}, {
	0x00, 0x06, 0x41, "ITCN"}, {
	0x00, 0x06, 0x42, "Genetel Systems Inc."}, {
	0x00, 0x06, 0x43, "SONO Computer Co., Ltd."}, {
	0x00, 0x06, 0x44, "NEIX Inc."}, {
	0x00, 0x06, 0x45, "Meisei Electric Co. Ltd."}, {
	0x00, 0x06, 0x46, "ShenZhen XunBao Network Technology Co Ltd"}, {
	0x00, 0x06, 0x47, "Etrali S.A."}, {
	0x00, 0x06, 0x48, "Seedsware, Inc."}, {
	0x00, 0x06, 0x49, "Quante"}, {
	0x00, 0x06, 0x4A, "Honeywell Co., Ltd. (KOREA)"}, {
	0x00, 0x06, 0x4B, "Alexon Co., Ltd."}, {
	0x00, 0x06, 0x4C, "Invicta Networks, Inc."}, {
	0x00, 0x06, 0x4D, "Sencore"}, {
	0x00, 0x06, 0x4E, "Broad Net Technology Inc."}, {
	0x00, 0x06, 0x4F, "PRO-NETS Technology Corporation"}, {
	0x00, 0x06, 0x50, "Tiburon Networks, Inc."}, {
	0x00, 0x06, 0x51, "Aspen Networks Inc."}, {
	0x00, 0x06, 0x52, "Cisco Systems, Inc."}, {
	0x00, 0x06, 0x53, "Cisco Systems, Inc."}, {
	0x00, 0x06, 0x54, "Maxxio Technologies"}, {
	0x00, 0x06, 0x55, "Yipee, Inc."}, {
	0x00, 0x06, 0x56, "Tactel AB"}, {
	0x00, 0x06, 0x57, "Market Central, Inc."}, {
	0x00, 0x06, 0x58, "Helmut Fischer GmbH & Co. KG"}, {
	0x00, 0x06, 0x59, "EAL (Apeldoorn) B.V."}, {
	0x00, 0x06, 0x5A, "Strix Systems"}, {
	0x00, 0x06, 0x5B, "Dell Computer Corp."}, {
	0x00, 0x06, 0x5C, "Malachite Technologies, Inc."}, {
	0x00, 0x06, 0x5D, "Heidelberg Web Systems"}, {
	0x00, 0x06, 0x5E, "Photuris, Inc."}, {
	0x00, 0x06, 0x5F, "ECI Telecom - NGTS Ltd."}, {
	0x00, 0x06, 0x60, "NADEX Co., Ltd."}, {
	0x00, 0x06, 0x61, "NIA Home Technologies Corp."}, {
	0x00, 0x06, 0x62, "MBM Technology Ltd."}, {
	0x00, 0x06, 0x63, "Human Technology Co., Ltd."}, {
	0x00, 0x06, 0x64, "Fostex Corporation"}, {
	0x00, 0x06, 0x65, "Sunny Giken, Inc."}, {
	0x00, 0x06, 0x66, "Roving Networks"}, {
	0x00, 0x06, 0x67, "Tripp Lite"}, {
	0x00, 0x06, 0x68, "Vicon Industries Inc."}, {
	0x00, 0x06, 0x69, "Datasound Laboratories Ltd"}, {
	0x00, 0x06, 0x6A, "InfiniCon Systems, Inc."}, {
	0x00, 0x06, 0x6B, "Sysmex Corporation"}, {
	0x00, 0x06, 0x6C, "Robinson Corporation"}, {
	0x00, 0x06, 0x6D, "Compuprint S.P.A."}, {
	0x00, 0x06, 0x6E, "Delta Electronics, Inc."}, {
	0x00, 0x06, 0x6F, "Korea Data Systems"}, {
	0x00, 0x06, 0x70, "Upponetti Oy"}, {
	0x00, 0x06, 0x71, "Softing AG"}, {
	0x00, 0x06, 0x72, "Netezza"}, {
	0x00, 0x06, 0x73, "Optelecom, Inc."}, {
	0x00, 0x06, 0x74, "Spectrum Control, Inc."}, {
	0x00, 0x06, 0x75, "Banderacom, Inc."}, {
	0x00, 0x06, 0x76, "Novra Technologies Inc."}, {
	0x00, 0x06, 0x77, "SICK AG"}, {
	0x00, 0x06, 0x78, "Marantz Japan, Inc."}, {
	0x00, 0x06, 0x79, "Konami Corporation"}, {
	0x00, 0x06, 0x7A, "JMP Systems"}, {
	0x00, 0x06, 0x7B, "Toplink C&C Corporation"}, {
	0x00, 0x06, 0x7C, "CISCO SYSTEMS, INC."}, {
	0x00, 0x06, 0x7D, "Takasago Ltd."}, {
	0x00, 0x06, 0x7E, "WinCom Systems, Inc."}, {
	0x00, 0x06, 0x7F, "Rearden Steel Technologies"}, {
	0x00, 0x06, 0x80, "Card Access, Inc."}, {
	0x00, 0x06, 0x81, "Goepel Electronic GmbH"}, {
	0x00, 0x06, 0x82, "Convedia"}, {
	0x00, 0x06, 0x83, "Bravara Communications, Inc."}, {
	0x00, 0x06, 0x84, "Biacore AB"}, {
	0x00, 0x06, 0x85, "NetNearU Corporation"}, {
	0x00, 0x06, 0x86, "ZARDCOM Co., Ltd."}, {
	0x00, 0x06, 0x87, "Omnitron Systems Technology, Inc."}, {
	0x00, 0x06, 0x88, "Telways Communication Co., Ltd."}, {
	0x00, 0x06, 0x89, "yLez Technologies Pte Ltd"}, {
	0x00, 0x06, 0x8A, "NeuronNet Co. Ltd. R&D Center"}, {
	0x00, 0x06, 0x8B, "AirRunner Technologies, Inc."}, {
	0x00, 0x06, 0x8C, "3Com Corporation"}, {
	0x00, 0x06, 0x8D, "SANgate Systems"}, {
	0x00, 0x06, 0x8E, "HID Corporation"}, {
	0x00, 0x06, 0x8F, "Telemonitor, Inc."}, {
	0x00, 0x06, 0x90, "Euracom Communication GmbH"}, {
	0x00, 0x06, 0x91, "PT Inovacao"}, {
	0x00, 0x06, 0x92, "Intruvert Networks, Inc."}, {
	0x00, 0x06, 0x93, "Flexus Computer Technology, Inc."}, {
	0x00, 0x06, 0x94, "Mobillian Corporation"}, {
	0x00, 0x06, 0x95, "Ensure Technologies, Inc."}, {
	0x00, 0x06, 0x96, "Advent Networks"}, {
	0x00, 0x06, 0x97, "R & D Center"}, {
	0x00, 0x06, 0x98, "egnite Software GmbH"}, {
	0x00, 0x06, 0x99, "Vida Design Co."}, {
	0x00, 0x06, 0x9A, "e & Tel"}, {
	0x00, 0x06, 0x9B, "AVT Audio Video Technologies GmbH"}, {
	0x00, 0x06, 0x9C, "Transmode Systems AB"}, {
	0x00, 0x06, 0x9D, "Petards Mobile Intelligence"}, {
	0x00, 0x06, 0x9E, "UNIQA, Inc."}, {
	0x00, 0x06, 0x9F, "Kuokoa Networks"}, {
	0x00, 0x06, 0xA0, "Mx Imaging"}, {
	0x00, 0x06, 0xA1, "Celsian Technologies, Inc."}, {
	0x00, 0x06, 0xA2, "Transilica, Inc."}, {
	0x00, 0x06, 0xA3, "Bitran Corporation"}, {
	0x00, 0x06, 0xA4, "INNOWELL Corp."}, {
	0x00, 0x06, 0xA5, "PINON Corp."}, {
	0x00, 0x06, 0xA6, "Artistic Licence (UK) Ltd"}, {
	0x00, 0x06, 0xA7, "Primarion"}, {
	0x00, 0x06, 0xA8, "KC Technology, Inc."}, {
	0x00, 0x06, 0xA9, "Universal Instruments Corp."}, {
	0x00, 0x06, 0xAA, "Miltope Corporation"}, {
	0x00, 0x06, 0xAB, "W-Link Systems, Inc."}, {
	0x00, 0x06, 0xAC, "Intersoft Co."}, {
	0x00, 0x06, 0xAD, "KB Electronics Ltd."}, {
	0x00, 0x06, 0xAE, "Himachal Futuristic Communications Ltd"}, {
	0x00, 0x06, 0xB0, "Comtech EF Data Corp."}, {
	0x00, 0x06, 0xB1, "Sonicwall"}, {
	0x00, 0x06, 0xB2, "Linxtek Co."}, {
	0x00, 0x06, 0xB3, "Diagraph Corporation"}, {
	0x00, 0x06, 0xB4, "Vorne Industries, Inc."}, {
	0x00, 0x06, 0xB5, "Luminent, Inc."}, {
	0x00, 0x06, 0xB6, "Nir-Or Israel Ltd."}, {
	0x00, 0x06, 0xB7, "TELEM GmbH"}, {
	0x00, 0x06, 0xB8, "Bandspeed Pty Ltd"}, {
	0x00, 0x06, 0xB9, "A5TEK Corp."}, {
	0x00, 0x06, 0xBA, "Westwave Communications"}, {
	0x00, 0x06, 0xBB, "ATI Technologies Inc."}, {
	0x00, 0x06, 0xBC, "Macrolink, Inc."}, {
	0x00, 0x06, 0xBD, "BNTECHNOLOGY Co., Ltd."}, {
	0x00, 0x06, 0xBE, "Baumer Optronic GmbH"}, {
	0x00, 0x06, 0xBF, "Accella Technologies Co., Ltd."}, {
	0x00, 0x06, 0xC0, "United Internetworks, Inc."}, {
	0x00, 0x06, 0xC1, "CISCO SYSTEMS, INC."}, {
	0x00, 0x06, 0xC2, "Smartmatic Corporation"}, {
	0x00, 0x06, 0xC3, "Schindler Elevators Ltd."}, {
	0x00, 0x06, 0xC4, "Piolink Inc."}, {
	0x00, 0x06, 0xC5, "INNOVI Technologies Limited"}, {
	0x00, 0x06, 0xC6, "lesswire AG"}, {
	0x00, 0x06, 0xC7, "RFNET Technologies Pte Ltd (S)"}, {
	0x00, 0x06, 0xC8, "Sumitomo Metal Micro Devices, Inc."}, {
	0x00, 0x06, 0xC9, "Technical Marketing Research, Inc."}, {
	0x00, 0x06, 0xCA,
		"American Computer & Digital Components, Inc. (ACDC)"}, {
	0x00, 0x06, 0xCB, "Jotron Electronics A/S"}, {
	0x00, 0x06, 0xCC, "JMI Electronics Co., Ltd."}, {
	0x00, 0x06, 0xCD, "CreoScitex Corporation Ltd."}, {
	0x00, 0x06, 0xCE, "DATENO"}, {
	0x00, 0x06, 0xCF, "Thales Avionics In-Flight Systems, LLC"}, {
	0x00, 0x06, 0xD0, "Elgar Electronics Corp."}, {
	0x00, 0x06, 0xD1, "Tahoe Networks, Inc."}, {
	0x00, 0x06, 0xD2, "Tundra Semiconductor Corp."}, {
	0x00, 0x06, 0xD3, "Alpha Telecom, Inc. U.S.A."}, {
	0x00, 0x06, 0xD4, "Interactive Objects, Inc."}, {
	0x00, 0x06, 0xD5, "Diamond Systems Corp."}, {
	0x00, 0x06, 0xD6, "Cisco Systems, Inc."}, {
	0x00, 0x06, 0xD7, "Cisco Systems, Inc."}, {
	0x00, 0x06, 0xD8, "Maple Optical Systems"}, {
	0x00, 0x06, 0xD9, "IPM-Net S.p.A."}, {
	0x00, 0x06, 0xDA, "ITRAN Communications Ltd."}, {
	0x00, 0x06, 0xDB, "ICHIPS Co., Ltd."}, {
	0x00, 0x06, 0xDC, "Syabas Technology (Amquest)"}, {
	0x00, 0x06, 0xDD, "AT & T Laboratories - Cambridge Ltd"}, {
	0x00, 0x06, 0xDE, "Flash Technology"}, {
	0x00, 0x06, 0xDF, "AIDONIC Corporation"}, {
	0x00, 0x06, 0xE0, "MAT Co., Ltd."}, {
	0x00, 0x06, 0xE1, "Techno Trade s.a"}, {
	0x00, 0x06, 0xE2, "Ceemax Technology Co., Ltd."}, {
	0x00, 0x06, 0xE3, "Quantitative Imaging Corporation"}, {
	0x00, 0x06, 0xE4, "Citel Technologies Ltd."}, {
	0x00, 0x06, 0xE5, "Fujian Newland Computer Ltd. Co."}, {
	0x00, 0x06, 0xE6, "DongYang Telecom Co., Ltd."}, {
	0x00, 0x06, 0xE7, "Bit Blitz Communications Inc."}, {
	0x00, 0x06, 0xE8, "Optical Network Testing, Inc."}, {
	0x00, 0x06, 0xE9, "Intime Corp."}, {
	0x00, 0x06, 0xEA, "ELZET80 Mikrocomputer GmbH&Co. KG"}, {
	0x00, 0x06, 0xEB, "Global Data"}, {
	0x00, 0x06, 0xEC, "M/A COM Private Radio System Inc."}, {
	0x00, 0x06, 0xED, "Inara Networks"}, {
	0x00, 0x06, 0xEE,
		"Shenyang Neu-era Information & Technology Stock Co., Ltd"},
	{
	0x00, 0x06, 0xEF, "Maxxan Systems, Inc."}, {
	0x00, 0x06, 0xF0, "Digeo, Inc."}, {
	0x00, 0x06, 0xF1, "Optillion"}, {
	0x00, 0x06, 0xF2, "Platys Communications"}, {
	0x00, 0x06, 0xF3, "AcceLight Networks"}, {
	0x00, 0x06, 0xF4, "Prime Electronics & Satellitics Inc."}, {
	0x00, 0x06, 0xF9, "Mitsui Zosen Systems Research Inc."}, {
	0x00, 0x06, 0xFA, "IP SQUARE Co, Ltd."}, {
	0x00, 0x06, 0xFB, "Hitachi Koki Co., Ltd."}, {
	0x00, 0x06, 0xFC, "Fnet Co., Ltd."}, {
	0x00, 0x06, 0xFD, "Comjet Information Systems Corp."}, {
	0x00, 0x06, 0xFE, "Celion Networks, Inc."}, {
	0x00, 0x06, 0xFF, "Sheba Systems Co., Ltd."}, {
	0x00, 0x07, 0x00, "Zettamedia Korea"}, {
	0x00, 0x07, 0x01, "RACAL-DATACOM"}, {
	0x00, 0x07, 0x02, "Varian Medical Systems"}, {
	0x00, 0x07, 0x03, "CSEE Transport"}, {
	0x00, 0x07, 0x05, "Endress & Hauser GmbH & Co"}, {
	0x00, 0x07, 0x06, "Sanritz Corporation"}, {
	0x00, 0x07, 0x07, "Interalia Inc."}, {
	0x00, 0x07, 0x08, "Bitrage Inc."}, {
	0x00, 0x07, 0x09, "Westerstrand Urfabrik AB"}, {
	0x00, 0x07, 0x0A, "Unicom Automation Co., Ltd."}, {
	0x00, 0x07, 0x0B, "Octal, SA"}, {
	0x00, 0x07, 0x0C, "SVA-Intrusion.com Co. Ltd."}, {
	0x00, 0x07, 0x0D, "Cisco Systems Inc."}, {
	0x00, 0x07, 0x0E, "Cisco Systems Inc."}, {
	0x00, 0x07, 0x0F, "Fujant, Inc."}, {
	0x00, 0x07, 0x10, "Adax, Inc."}, {
	0x00, 0x07, 0x11, "Acterna"}, {
	0x00, 0x07, 0x12, "JAL Information Technology"}, {
	0x00, 0x07, 0x13, "IP One, Inc."}, {
	0x00, 0x07, 0x14, "Brightcom"}, {
	0x00, 0x07, 0x15, "General Research of Electronics, Inc."}, {
	0x00, 0x07, 0x16, "J & S Marine Ltd."}, {
	0x00, 0x07, 0x17, "Wieland Electric GmbH"}, {
	0x00, 0x07, 0x18, "iCanTek Co., Ltd."}, {
	0x00, 0x07, 0x19, "Mobiis Co., Ltd."}, {
	0x00, 0x07, 0x1A, "Finedigital Inc."}, {
	0x00, 0x07, 0x1B, "Position Technology Inc."}, {
	0x00, 0x07, 0x1C, "AT&T Fixed Wireless Services"}, {
	0x00, 0x07, 0x1D,
		"Satelsa Sistemas Y Aplicaciones De Telecomunicaciones, S.A."},
	{
	0x00, 0x07, 0x1E, "Tri-M Engineering / Nupak Dev. Corp."}, {
	0x00, 0x07, 0x1F, "European Systems Integration"}, {
	0x00, 0x07, 0x20, "Trutzschler GmbH & Co. KG"}, {
	0x00, 0x07, 0x21, "Formac Elektronik GmbH"}, {
	0x00, 0x07, 0x22, "Nielsen Media Research"}, {
	0x00, 0x07, 0x23, "ELCON Systemtechnik GmbH"}, {
	0x00, 0x07, 0x24, "Telemax Co., Ltd."}, {
	0x00, 0x07, 0x25, "Bematech International Corp."}, {
	0x00, 0x07, 0x27, "Zi Corporation (HK) Ltd."}, {
	0x00, 0x07, 0x28, "Neo Telecom"}, {
	0x00, 0x07, 0x29, "Kistler Instrumente AG"}, {
	0x00, 0x07, 0x2A, "Innovance Networks"}, {
	0x00, 0x07, 0x2B, "Jung Myung Telecom Co., Ltd."}, {
	0x00, 0x07, 0x2C, "Fabricom"}, {
	0x00, 0x07, 0x2D, "CNSystems"}, {
	0x00, 0x07, 0x2E, "North Node AB"}, {
	0x00, 0x07, 0x2F, "Instransa, Inc."}, {
	0x00, 0x07, 0x30, "Hutchison OPTEL Telecom Technology Co., Ltd."},
	{
	0x00, 0x07, 0x31, "Spiricon, Inc."}, {
	0x00, 0x07, 0x32, "AAEON Technology Inc."}, {
	0x00, 0x07, 0x33, "DANCONTROL Engineering"}, {
	0x00, 0x07, 0x34, "Agile Storage, Inc."}, {
	0x00, 0x07, 0x35, "Flarion Technologies, Inc."}, {
	0x00, 0x07, 0x36, "Data Video Technologies Co., Ltd."}, {
	0x00, 0x07, 0x37, "Soriya Co. Ltd."}, {
	0x00, 0x07, 0x38, "Young Technology Co., Ltd."}, {
	0x00, 0x07, 0x39, "Motion Media Technology Ltd."}, {
	0x00, 0x07, 0x3A, "Inventel Systemes"}, {
	0x00, 0x07, 0x3B, "Tenovis GmbH & Co KG"}, {
	0x00, 0x07, 0x3C, "Telecom Design"}, {
	0x00, 0x07, 0x3D, "Nanjing Postel Telecommunications Co., Ltd."}, {
	0x00, 0x07, 0x3E, "China Great-Wall Computer Shenzhen Co., Ltd."},
	{
	0x00, 0x07, 0x3F, "Woojyun Systec Co., Ltd."}, {
	0x00, 0x07, 0x40, "Melco Inc."}, {
	0x00, 0x07, 0x41, "Sierra Automated Systems"}, {
	0x00, 0x07, 0x42, "Current Technologies"}, {
	0x00, 0x07, 0x43, "Chelsio Communications"}, {
	0x00, 0x07, 0x44, "Unico, Inc."}, {
	0x00, 0x07, 0x45, "Radlan Computer Communications Ltd."}, {
	0x00, 0x07, 0x46, "Interlink BT, LLC"}, {
	0x00, 0x07, 0x47, "Mecalc"}, {
	0x00, 0x07, 0x48, "The Imaging Source Europe"}, {
	0x00, 0x07, 0x49, "CENiX Inc."}, {
	0x00, 0x07, 0x4A, "Carl Valentin GmbH"}, {
	0x00, 0x07, 0x4B, "Daihen Corporation"}, {
	0x00, 0x07, 0x4C, "Beicom Inc."}, {
	0x00, 0x07, 0x4D, "Zebra Technologies Corp."}, {
	0x00, 0x07, 0x4E, "Naughty boy co., Ltd."}, {
	0x00, 0x07, 0x4F, "Cisco Systems, Inc."}, {
	0x00, 0x07, 0x50, "Cisco Systems, Inc."}, {
	0x00, 0x07, 0x51, "m.u.t. - GmbH"}, {
	0x00, 0x07, 0x52, "Rhythm Watch Co., Ltd."}, {
	0x00, 0x07, 0x53, "Beijing Qxcomm Technology Co., Ltd."}, {
	0x00, 0x07, 0x54, "Xyterra Computing, Inc."}, {
	0x00, 0x07, 0x55, "Lafon SA"}, {
	0x00, 0x07, 0x56, "Juyoung Telecom"}, {
	0x00, 0x07, 0x57, "Topcall International AG"}, {
	0x00, 0x07, 0x58, "Dragonwave"}, {
	0x00, 0x07, 0x59, "Boris Manufacturing Corp."}, {
	0x00, 0x07, 0x5A, "Air Products and Chemicals, Inc."}, {
	0x00, 0x07, 0x5B, "Gibson Guitars"}, {
	0x00, 0x07, 0x5C, "ENCAD, Inc."}, {
	0x00, 0x07, 0x5D, "Celleritas Inc."}, {
	0x00, 0x07, 0x5E, "Pulsar Technologies, Inc."}, {
	0x00, 0x07, 0x5F, "VCS Video Communication Systems AG"}, {
	0x00, 0x07, 0x60, "TOMIS Information & Telecom Corp."}, {
	0x00, 0x07, 0x61, "Logitech SA"}, {
	0x00, 0x07, 0x62, "Group Sense Limited"}, {
	0x00, 0x07, 0x63, "Sunniwell Cyber Tech. Co., Ltd."}, {
	0x00, 0x07, 0x64, "YoungWoo Telecom Co. Ltd."}, {
	0x00, 0x07, 0x65, "Jade Quantum Technologies, Inc."}, {
	0x00, 0x07, 0x66, "Chou Chin Industrial Co., Ltd."}, {
	0x00, 0x07, 0x67, "Yuxing Electronics Company Limited"}, {
	0x00, 0x07, 0x68, "Danfoss A/S"}, {
	0x00, 0x07, 0x69, "Italiana Macchi SpA"}, {
	0x00, 0x07, 0x6A, "NEXTEYE Co., Ltd."}, {
	0x00, 0x07, 0x6B, "Stralfors AB"}, {
	0x00, 0x07, 0x6C, "Daehanet, Inc."}, {
	0x00, 0x07, 0x6D, "Flexlight Networks"}, {
	0x00, 0x07, 0x6E, "Sinetica Corporation Ltd."}, {
	0x00, 0x07, 0x6F, "Synoptics Limited"}, {
	0x00, 0x07, 0x70, "Locusnetworks Corporation"}, {
	0x00, 0x07, 0x71, "Embedded System Corporation"}, {
	0x00, 0x07, 0x72, "Shanghai Bell Company Limited"}, {
	0x00, 0x07, 0x73, "Ascom Powerline Communications Ltd."}, {
	0x00, 0x07, 0x74, "GuangZhou Thinker Technology Co. Ltd."}, {
	0x00, 0x07, 0x75, "Valence Semiconductor, Inc."}, {
	0x00, 0x07, 0x76, "Federal APD"}, {
	0x00, 0x07, 0x77, "Motah Ltd."}, {
	0x00, 0x07, 0x78, "GERSTEL GmbH & Co. KG"}, {
	0x00, 0x07, 0x79, "Sungil Telecom Co., Ltd."}, {
	0x00, 0x07, 0x7A, "Infoware System Co., Ltd."}, {
	0x00, 0x07, 0x7B, "Millimetrix Broadband Networks"}, {
	0x00, 0x07, 0x7C, "OnTime Networks"}, {
	0x00, 0x07, 0x7E, "Elrest GmbH"}, {
	0x00, 0x07, 0x7F, "J Communications Co., Ltd."}, {
	0x00, 0x07, 0x80, "Bluegiga Technologies OY"}, {
	0x00, 0x07, 0x81, "Itron Inc."}, {
	0x00, 0x07, 0x82, "Nauticus Networks, Inc."}, {
	0x00, 0x07, 0x83, "SynCom Network, Inc."}, {
	0x00, 0x07, 0x84, "Cisco Systems Inc."}, {
	0x00, 0x07, 0x85, "Cisco Systems Inc."}, {
	0x00, 0x07, 0x86, "Wireless Networks Inc."}, {
	0x00, 0x07, 0x87, "Idea System Co., Ltd."}, {
	0x00, 0x07, 0x88, "Clipcomm, Inc."}, {
	0x00, 0x07, 0x89, "Eastel Systems Corporation"}, {
	0x00, 0x07, 0x8A, "Mentor Data System Inc."}, {
	0x00, 0x07, 0x8B, "Wegener Communications, Inc."}, {
	0x00, 0x07, 0x8C, "Elektronikspecialisten i Borlange AB"}, {
	0x00, 0x07, 0x8D, "NetEngines Ltd."}, {
	0x00, 0x07, 0x8E, "Garz & Friche GmbH"}, {
	0x00, 0x07, 0x8F, "Emkay Innovative Products"}, {
	0x00, 0x07, 0x90, "Tri-M Technologies (s) Limited"}, {
	0x00, 0x07, 0x91, "International Data Communications, Inc."}, {
	0x00, 0x07, 0x92, "Suetron Electronic GmbH"}, {
	0x00, 0x07, 0x94, "Simple Devices, Inc."}, {
	0x00, 0x07, 0x95, "Elitegroup Computer System Co. (ECS)"}, {
	0x00, 0x07, 0x96, "LSI Systems, Inc."}, {
	0x00, 0x07, 0x97, "Netpower Co., Ltd."}, {
	0x00, 0x07, 0x98, "Selea SRL"}, {
	0x00, 0x07, 0x99, "Tipping Point Technologies, Inc."}, {
	0x00, 0x07, 0x9A, "SmartSight Networks Inc."}, {
	0x00, 0x07, 0x9B, "Aurora Networks"}, {
	0x00, 0x07, 0x9C, "Golden Electronics Technology Co., Ltd."}, {
	0x00, 0x07, 0x9D, "Musashi Co., Ltd."}, {
	0x00, 0x07, 0x9E, "Ilinx Co., Ltd."}, {
	0x00, 0x07, 0x9F, "Action Digital Inc."}, {
	0x00, 0x07, 0xA0, "e-Watch Inc."}, {
	0x00, 0x07, 0xA1, "Viasys Critical Care"}, {
	0x00, 0x07, 0xA2, "Opteon Corporation"}, {
	0x00, 0x07, 0xA3, "Ositis Software, Inc."}, {
	0x00, 0x07, 0xA4, "GN Netcom Ltd."}, {
	0x00, 0x07, 0xA5, "Y.D.K Co. Ltd."}, {
	0x00, 0x07, 0xA6, "Home Automation, Inc."}, {
	0x00, 0x07, 0xA7, "A-Z Inc."}, {
	0x00, 0x07, 0xA8, "Haier Group Technologies Ltd."}, {
	0x00, 0x07, 0xA9, "Novasonics"}, {
	0x00, 0x07, 0xAA, "Quantum Data Inc."}, {
	0x00, 0x07, 0xAC, "Eolring"}, {
	0x00, 0x07, 0xAD, "Pentacon GmbH Foto-und Feinwerktechnik"}, {
	0x00, 0x07, 0xAE, "Layer N Networks"}, {
	0x00, 0x07, 0xAF, "N-Tron Corp."}, {
	0x00, 0x07, 0xB0, "Office Details, Inc."}, {
	0x00, 0x07, 0xB1, "Equator Technologies"}, {
	0x00, 0x07, 0xB2, "Transaccess S.A."}, {
	0x00, 0x07, 0xB3, "Cisco Systems Inc."}, {
	0x00, 0x07, 0xB4, "Cisco Systems Inc."}, {
	0x00, 0x07, 0xB5, "Any One Wireless Ltd."}, {
	0x00, 0x07, 0xB6, "Telecom Technology Ltd."}, {
	0x00, 0x07, 0xB7, "Samurai Ind. Prods Eletronicos Ltda"}, {
	0x00, 0x07, 0xB8, "American Predator Corp."}, {
	0x00, 0x07, 0xB9, "Ginganet Corporation"}, {
	0x00, 0x07, 0xBA, "Xebeo Communications, Inc."}, {
	0x00, 0x07, 0xBB, "Confluence Networks"}, {
	0x00, 0x07, 0xBC, "Identix Inc."}, {
	0x00, 0x07, 0xBD, "Radionet Ltd."}, {
	0x00, 0x07, 0xBE, "DataLogic SpA"}, {
	0x00, 0x07, 0xBF, "Armillaire Technologies, Inc."}, {
	0x00, 0x07, 0xC0, "NetZerver Inc."}, {
	0x00, 0x07, 0xC1, "Overture Networks, Inc."}, {
	0x00, 0x07, 0xC2, "Netsys Telecom"}, {
	0x00, 0x07, 0xC3, "Cirpack"}, {
	0x00, 0x07, 0xC4, "JEAN Co. Ltd."}, {
	0x00, 0x07, 0xC5, "Gcom, Inc."}, {
	0x00, 0x07, 0xC6, "VDS Vosskuhler GmbH"}, {
	0x00, 0x07, 0xC7, "Synectics Systems Limited"}, {
	0x00, 0x07, 0xC8, "Brain21, Inc."}, {
	0x00, 0x07, 0xC9, "Technol Seven Co., Ltd."}, {
	0x00, 0x07, 0xCA,
		"Creatix Polymedia Ges Fur Kommunikaitonssysteme"}, {
	0x00, 0x07, 0xCB, "Freebox SA"}, {
	0x00, 0x07, 0xCC, "Kaba Benzing GmbH"}, {
	0x00, 0x07, 0xCD, "NMTEL Co., Ltd."}, {
	0x00, 0x07, 0xCE, "Cabletime Limited"}, {
	0x00, 0x07, 0xCF, "Anoto AB"}, {
	0x00, 0x07, 0xD0, "Automat Engenharia de Automaoa Ltda."}, {
	0x00, 0x07, 0xD1, "Spectrum Signal Processing Inc."}, {
	0x00, 0x07, 0xD2, "Logopak Systeme"}, {
	0x00, 0x07, 0xD3, "Stork Digital Imaging B.V."}, {
	0x00, 0x07, 0xD4, "Zhejiang Yutong Network Communication Co Ltd."},
	{
	0x00, 0x07, 0xD5, "3e Technologies Int;., Inc."}, {
	0x00, 0x07, 0xD6, "Commil Ltd."}, {
	0x00, 0x07, 0xD7, "Caporis Networks AG"}, {
	0x00, 0x07, 0xD8, "Hitron Systems Inc."}, {
	0x00, 0x07, 0xD9, "Splicecom"}, {
	0x00, 0x07, 0xDA, "Neuro Telecom Co., Ltd."}, {
	0x00, 0x07, 0xDB, "Kirana Networks, Inc."}, {
	0x00, 0x07, 0xDC, "Atek Co, Ltd."}, {
	0x00, 0x07, 0xDD, "Cradle Technologies"}, {
	0x00, 0x07, 0xDE, "eCopilt AB"}, {
	0x00, 0x07, 0xDF, "Vbrick Systems Inc."}, {
	0x00, 0x07, 0xE0, "Palm Inc."}, {
	0x00, 0x07, 0xE1, "WIS Communications Co. Ltd."}, {
	0x00, 0x07, 0xE2, "Bitworks, Inc."}, {
	0x00, 0x07, 0xE3, "Navcom Technology, Inc."}, {
	0x00, 0x07, 0xE4, "SoftRadio Co., Ltd."}, {
	0x00, 0x07, 0xE5, "Coup Corporation"}, {
	0x00, 0x07, 0xE6, "edgeflow Canada Inc."}, {
	0x00, 0x07, 0xE7, "FreeWave Technologies"}, {
	0x00, 0x07, 0xE8, "St. Bernard Software"}, {
	0x00, 0x07, 0xE9, "Intel Corporation"}, {
	0x00, 0x07, 0xEA, "Massana, Inc."}, {
	0x00, 0x07, 0xEB, "Cisco Systems Inc."}, {
	0x00, 0x07, 0xEC, "Cisco Systems Inc."}, {
	0x00, 0x07, 0xED, "Altera Corporation"}, {
	0x00, 0x07, 0xEE, "telco Informationssysteme GmbH"}, {
	0x00, 0x07, 0xEF, "Lockheed Martin Tactical Systems"}, {
	0x00, 0x07, 0xF0, "LogiSync Corporation"}, {
	0x00, 0x07, 0xF1, "TeraBurst Networks Inc."}, {
	0x00, 0x07, 0xF2, "IOA Corporation"}, {
	0x00, 0x07, 0xF3, "Think Engine Networks"}, {
	0x00, 0x07, 0xF4, "Eletex Co., Ltd."}, {
	0x00, 0x07, 0xF5, "Bridgeco Co AG"}, {
	0x00, 0x07, 0xF6, "Qqest Software Systems"}, {
	0x00, 0x07, 0xF7, "Galtronics"}, {
	0x00, 0x07, 0xF8, "ITDevices, Inc."}, {
	0x00, 0x07, 0xF9, "Phonetics, Inc."}, {
	0x00, 0x07, 0xFA, "ITT Co., Ltd."}, {
	0x00, 0x07, 0xFB, "Giga Stream UMTS Technologies GmbH"}, {
	0x00, 0x07, 0xFC, "Adept Systems Inc."}, {
	0x00, 0x07, 0xFD, "LANergy Ltd."}, {
	0x00, 0x07, 0xFE, "Rigaku Corporation"}, {
	0x00, 0x07, 0xFF, "Gluon Networks"}, {
	0x00, 0x08, 0x00, "MULTITECH SYSTEMS, INC."}, {
	0x00, 0x08, 0x01, "HighSpeed Surfing Inc."}, {
	0x00, 0x08, 0x02, "Compaq Computer Corporation"}, {
	0x00, 0x08, 0x03, "Cos Tron"}, {
	0x00, 0x08, 0x04, "ICA Inc."}, {
	0x00, 0x08, 0x05, "Techno-Holon Corporation"}, {
	0x00, 0x08, 0x06, "Raonet Systems, Inc."}, {
	0x00, 0x08, 0x07, "Access Devices Limited"}, {
	0x00, 0x08, 0x08, "PPT Vision, Inc."}, {
	0x00, 0x08, 0x09, "Systemonic AG"}, {
	0x00, 0x08, 0x0A, "Espera-Werke GmbH"}, {
	0x00, 0x08, 0x0B, "Birka BPA Informationssystem AB"}, {
	0x00, 0x08, 0x0C, "VDA elettronica SrL"}, {
	0x00, 0x08, 0x0D, "Toshiba"}, {
	0x00, 0x08, 0x0E, "Motorola, BCS"}, {
	0x00, 0x08, 0x0F, "Proximion Fiber Optics AB"}, {
	0x00, 0x08, 0x10, "Key Technology, Inc."}, {
	0x00, 0x08, 0x11, "VOIX Corporation"}, {
	0x00, 0x08, 0x12, "GM-2 Corporation"}, {
	0x00, 0x08, 0x13, "Diskbank, Inc."}, {
	0x00, 0x08, 0x14, "TIL Technologies"}, {
	0x00, 0x08, 0x15, "CATS Co., Ltd."}, {
	0x00, 0x08, 0x16, "Bluetags A/S"}, {
	0x00, 0x08, 0x17, "EmergeCore Networks LLC"}, {
	0x00, 0x08, 0x18, "Pixelworks, Inc."}, {
	0x00, 0x08, 0x19, "Banksys"}, {
	0x00, 0x08, 0x1A,
		"Sanrad Intelligence Storage Communications (2000) Ltd."},
	{
	0x00, 0x08, 0x1B, "Windigo Systems"}, {
	0x00, 0x08, 0x1C, "@pos.com"}, {
	0x00, 0x08, 0x1D, "Ipsil, Incorporated"}, {
	0x00, 0x08, 0x1E, "Repeatit AB"}, {
	0x00, 0x08, 0x1F, "Pou Yuen Tech Corp. Ltd."}, {
	0x00, 0x08, 0x20, "Cisco Systems Inc."}, {
	0x00, 0x08, 0x21, "Cisco Systems Inc."}, {
	0x00, 0x08, 0x22, "InPro Comm"}, {
	0x00, 0x08, 0x23, "Texa Corp."}, {
	0x00, 0x08, 0x24, "Promatek Industries Ltd."}, {
	0x00, 0x08, 0x25, "Acme Packet"}, {
	0x00, 0x08, 0x26, "Colorado Med Tech"}, {
	0x00, 0x08, 0x27, "Pirelli Cables & Systems"}, {
	0x00, 0x08, 0x28, "Koei Engineering Ltd."}, {
	0x00, 0x08, 0x29, "Aval Nagasaki Corporation"}, {
	0x00, 0x08, 0x2A, "Powerwallz Network Security"}, {
	0x00, 0x08, 0x2B, "Wooksung Electronics, Inc."}, {
	0x00, 0x08, 0x2C, "Homag AG"}, {
	0x00, 0x08, 0x2D, "Indus Teqsite Private Limited"}, {
	0x00, 0x08, 0x2E, "Multitone Electronics PLC"}, {
	0x00, 0x08, 0x4E, "DivergeNet, Inc."}, {
	0x00, 0x08, 0x4F, "Qualstar Corporation"}, {
	0x00, 0x08, 0x50, "Arizona Instrument Corp."}, {
	0x00, 0x08, 0x51, "Canadian Bank Note Company, Ltd."}, {
	0x00, 0x08, 0x52, "Davolink Co. Inc."}, {
	0x00, 0x08, 0x53, "Schleicher GmbH & Co. Relaiswerke KG"}, {
	0x00, 0x08, 0x54, "Netronix, Inc."}, {
	0x00, 0x08, 0x55, "NASA-Goddard Space Flight Center"}, {
	0x00, 0x08, 0x56, "Gamatronic Electronic Industries Ltd."}, {
	0x00, 0x08, 0x57, "Polaris Networks, Inc."}, {
	0x00, 0x08, 0x58, "Novatechnology Inc."}, {
	0x00, 0x08, 0x59, "ShenZhen Unitone Electronics Co., Ltd."}, {
	0x00, 0x08, 0x5A, "IntiGate Inc."}, {
	0x00, 0x08, 0x5B, "Hanbit Electronics Co., Ltd."}, {
	0x00, 0x08, 0x5C, "Shanghai Dare Technologies Co. Ltd."}, {
	0x00, 0x08, 0x5D, "Aastra"}, {
	0x00, 0x08, 0x5E, "PCO Computer Optics GmbH"}, {
	0x00, 0x08, 0x5F, "Picanol N.V."}, {
	0x00, 0x08, 0x60, "LodgeNet Entertainment Corp."}, {
	0x00, 0x08, 0x61, "SoftEnergy Co., Ltd."}, {
	0x00, 0x08, 0x62, "NEC Eluminant Technologies, Inc."}, {
	0x00, 0x08, 0x63, "Entrisphere Inc."}, {
	0x00, 0x08, 0x64, "Fasy S.p.A."}, {
	0x00, 0x08, 0x65, "JASCOM CO., LTD"}, {
	0x00, 0x08, 0x66, "DSX Access Systems, Inc."}, {
	0x00, 0x08, 0x67, "Uptime Devices"}, {
	0x00, 0x08, 0x68, "PurOptix"}, {
	0x00, 0x08, 0x69, "Command-e Technology Co.,Ltd."}, {
	0x00, 0x08, 0x6A, "Industrie Technik IPS GmbH"}, {
	0x00, 0x08, 0x6B, "MIPSYS"}, {
	0x00, 0x08, 0x6C, "Plasmon LMS"}, {
	0x00, 0x08, 0x6D, "Missouri FreeNet"}, {
	0x00, 0x08, 0x6E, "Hyglo AB"}, {
	0x00, 0x08, 0x6F, "Resources Computer Network Ltd."}, {
	0x00, 0x08, 0x70, "Rasvia Systems, Inc."}, {
	0x00, 0x08, 0x71, "NORTHDATA Co., Ltd."}, {
	0x00, 0x08, 0x72, "Sorenson Technologies, Inc."}, {
	0x00, 0x08, 0x73, "DAP Design B.V."}, {
	0x00, 0x08, 0x74, "Dell Computer Corp."}, {
	0x00, 0x08, 0x75, "Acorp Electronics Corp."}, {
	0x00, 0x08, 0x76, "SDSystem"}, {
	0x00, 0x08, 0x77, "Liebert HIROSS S.p.A."}, {
	0x00, 0x08, 0x78, "Benchmark Storage Innovations"}, {
	0x00, 0x08, 0x79, "CEM Corporation"}, {
	0x00, 0x08, 0x7A, "Wipotec GmbH"}, {
	0x00, 0x08, 0x7B, "RTX Telecom A/S"}, {
	0x00, 0x08, 0x7C, "Cisco Systems, Inc."}, {
	0x00, 0x08, 0x7D, "Cisco Systems Inc."}, {
	0x00, 0x08, 0x7E, "Bon Electro-Telecom Inc."}, {
	0x00, 0x08, 0x7F, "SPAUN electronic GmbH & Co. KG"}, {
	0x00, 0x08, 0x80, "BroadTel Canada Communications inc."}, {
	0x00, 0x08, 0x81, "DIGITAL HANDS CO.,LTD."}, {
	0x00, 0x08, 0x82, "SIGMA CORPORATION"}, {
	0x00, 0x08, 0x83, "Hewlett-Packard Company"}, {
	0x00, 0x08, 0x84, "Index Braille AB"}, {
	0x00, 0x08, 0x85, "EMS Dr. Thomas Wuensche"}, {
	0x00, 0x08, 0x86, "Hansung Teliann, Inc."}, {
	0x00, 0x08, 0x88, "OULLIM Information Technology Inc,."}, {
	0x00, 0x08, 0x89, "Echostar Technologies Corp"}, {
	0x00, 0x08, 0x8A, "Minds@Work"}, {
	0x00, 0x08, 0x8B, "Tropic Networks Inc."}, {
	0x00, 0x08, 0x8C, "Quanta Network Systems Inc."}, {
	0x00, 0x08, 0x8D, "Sigma-Links Inc."}, {
	0x00, 0x08, 0x8E, "Nihon Computer Co., Ltd."}, {
	0x00, 0x08, 0x8F, "ADVANCED DIGITAL TECHNOLOGY"}, {
	0x00, 0x08, 0x90, "AVILINKS SA"}, {
	0x00, 0x08, 0x91, "Lyan Inc."}, {
	0x00, 0x08, 0x92, "EM Solutions"}, {
	0x00, 0x08, 0x94, "InnoVISION Multimedia Ltd."}, {
	0x00, 0x08, 0x96, "Printronix, Inc."}, {
	0x00, 0x08, 0x97, "Quake Technologies"}, {
	0x00, 0x08, 0x98, "Gigabit Optics Corporation"}, {
	0x00, 0x08, 0x99, "Netbind, Inc."}, {
	0x00, 0x08, 0x9A, "Alcatel Microelectronics"}, {
	0x00, 0x08, 0x9B, "ICP Electronics Inc."}, {
	0x00, 0x08, 0x9C, "Elecs Industry Co., Ltd."}, {
	0x00, 0x08, 0x9D, "UHD-Elektronik"}, {
	0x00, 0x08, 0x9E, "Beijing Enter-Net co.LTD"}, {
	0x00, 0x08, 0x9F, "EFM Networks"}, {
	0x00, 0x08, 0xA0, "Stotz Feinmesstechnik GmbH"}, {
	0x00, 0x08, 0xA1, "CNet Technology Inc."}, {
	0x00, 0x08, 0xA2, "ADI Engineering, Inc."}, {
	0x00, 0x08, 0xA3, "Cisco Systems"}, {
	0x00, 0x08, 0xA4, "Cisco Systems"}, {
	0x00, 0x08, 0xA5, "Peninsula Systems Inc."}, {
	0x00, 0x08, 0xA6, "Multiware & Image Co., Ltd."}, {
	0x00, 0x08, 0xA7, "iLogic Inc."}, {
	0x00, 0x08, 0xA8, "Systec Co., Ltd."}, {
	0x00, 0x08, 0xA9, "SangSang Technology, Inc."}, {
	0x00, 0x08, 0xAA, "KARAM"}, {
	0x00, 0x08, 0xAB, "EnerLinx.com, Inc."}, {
	0x00, 0x08, 0xAD, "Toyo-Linx Co., Ltd."}, {
	0x00, 0x08, 0xAE, "Packetfront"}, {
	0x00, 0x08, 0xAF, "Novatec Corporation"}, {
	0x00, 0x08, 0xB0, "BKtel communications GmbH"}, {
	0x00, 0x08, 0xB1, "ProQuent Systems"}, {
	0x00, 0x08, 0xB2,
		"SHENZHEN COMPASS TECHNOLOGY DEVELOPMENT CO.,LTD"}, {
	0x00, 0x08, 0xB3, "Fastwel"}, {
	0x00, 0x08, 0xB4, "SYSPOL"}, {
	0x00, 0x08, 0xB5, "TAI GUEN ENTERPRISE CO., LTD"}, {
	0x00, 0x08, 0xB6, "RouteFree, Inc."}, {
	0x00, 0x08, 0xB7, "HIT Incorporated"}, {
	0x00, 0x08, 0xB8, "E.F. Johnson"}, {
	0x00, 0x08, 0xB9, "KAON MEDIA Co., Ltd."}, {
	0x00, 0x08, 0xBA, "Erskine Systems Ltd"}, {
	0x00, 0x08, 0xBB, "NetExcell"}, {
	0x00, 0x08, 0xBC, "Ilevo AB"}, {
	0x00, 0x08, 0xBD, "TEPG-US"}, {
	0x00, 0x08, 0xBE, "XENPAK MSA Group"}, {
	0x00, 0x08, 0xBF, "Aptus Elektronik AB"}, {
	0x00, 0x08, 0xC0, "ASA SYSTEMS"}, {
	0x00, 0x08, 0xC1, "Avistar Communications Corporation"}, {
	0x00, 0x08, 0xC2, "Cisco Systems"}, {
	0x00, 0x08, 0xC3, "Contex A/S"}, {
	0x00, 0x08, 0xC5, "Liontech Co., Ltd."}, {
	0x00, 0x08, 0xC6, "Philips Consumer Communications"}, {
	0x00, 0x08, 0xC7, "COMPAQ COMPUTER CORPORATION"}, {
	0x00, 0x08, 0xC8, "Soneticom, Inc."}, {
	0x00, 0x08, 0xC9, "TechniSat Digital GmbH"}, {
	0x00, 0x08, 0xCA, "TwinHan Technology Co.,Ltd"}, {
	0x00, 0x08, 0xCB, "Zeta Broadband Inc."}, {
	0x00, 0x08, 0xCC, "Remotec, Inc."}, {
	0x00, 0x08, 0xCD, "With-Net Inc"}, {
	0x00, 0x08, 0xCF, "Nippon Koei Power Systems Co., Ltd."}, {
	0x00, 0x08, 0xD0, "Musashi Engineering Co., LTD."}, {
	0x00, 0x08, 0xD1, "KAREL INC."}, {
	0x00, 0x08, 0xD2, "ZOOM Networks Inc."}, {
	0x00, 0x08, 0xD3, "Hercules Technologies S.A."}, {
	0x00, 0x08, 0xD4, "IneoQuest Technologies, Inc"}, {
	0x00, 0x08, 0xD5, "Vanguard Managed Solutions"}, {
	0x00, 0x08, 0xD6, "HASSNET Inc."}, {
	0x00, 0x08, 0xD7, "HOW CORPORATION"}, {
	0x00, 0x08, 0xD8, "Dowkey Microwave"}, {
	0x00, 0x08, 0xD9, "Mitadenshi Co.,LTD"}, {
	0x00, 0x08, 0xDA, "SofaWare Technologies Ltd."}, {
	0x00, 0x08, 0xDB, "Corrigent Systems"}, {
	0x00, 0x08, 0xDC, "Wiznet"}, {
	0x00, 0x08, 0xDD, "Telena Communications, Inc."}, {
	0x00, 0x08, 0xDE, "3UP Systems"}, {
	0x00, 0x08, 0xDF, "Alistel Inc."}, {
	0x00, 0x08, 0xE0, "ATO Technology Ltd."}, {
	0x00, 0x08, 0xE1, "Barix AG"}, {
	0x00, 0x08, 0xE2, "Cisco Systems"}, {
	0x00, 0x08, 0xE3, "Cisco Systems"}, {
	0x00, 0x08, 0xE4, "Envenergy Inc"}, {
	0x00, 0x08, 0xE5, "IDK Corporation"}, {
	0x00, 0x08, 0xE6, "Littlefeet"}, {
	0x00, 0x08, 0xE7, "SHI ControlSystems,Ltd."}, {
	0x00, 0x08, 0xE8, "Excel Master Ltd."}, {
	0x00, 0x08, 0xE9, "NextGig"}, {
	0x00, 0x08, 0xEA, "Motion Control Engineering, Inc"}, {
	0x00, 0x08, 0xEB, "ROMWin Co.,Ltd."}, {
	0x00, 0x08, 0xEC, "Zonu, Inc."}, {
	0x00, 0x08, 0xED, "ST&T Instrument Corp."}, {
	0x00, 0x08, 0xEE, "Logic Product Development"}, {
	0x00, 0x08, 0xEF, "DIBAL,S.A."}, {
	0x00, 0x08, 0xF0, "Next Generation Systems, Inc."}, {
	0x00, 0x08, 0xF1, "Voltaire"}, {
	0x00, 0x08, 0xF3, "WANY"}, {
	0x00, 0x08, 0xF4, "Bluetake Technology Co., Ltd."}, {
	0x00, 0x08, 0xF5, "YESTECHNOLOGY Co.,Ltd."}, {
	0x00, 0x08, 0xF6, "SUMITOMO ELECTRIC HIGHTECHS.co.,ltd."}, {
	0x00, 0x08, 0xF7,
		"Hitachi Ltd, Semiconductor &amp; Integrated Circuits Gr"},
	{
	0x00, 0x08, 0xF8, "Guardall Ltd"}, {
	0x00, 0x08, 0xF9, "Padcom, Inc."}, {
	0x00, 0x08, 0xFA, "Karl E.Brinkmann GmbH"}, {
	0x00, 0x08, 0xFC, "Gigaphoton Inc."}, {
	0x00, 0x08, 0xFD, "BlueKorea Co., Ltd."}, {
	0x00, 0x08, 0xFF, "Trilogy Broadcast (Holdings) Ltd"}, {
	0x00, 0x09, 0x00, "TMT"}, {
	0x00, 0x09, 0x01,
		"Shenzhen Shixuntong Information & Technoligy Co"}, {
	0x00, 0x09, 0x02, "Redline Communications Inc."}, {
	0x00, 0x09, 0x03, "Panasas, Inc"}, {
	0x00, 0x09, 0x04, "MONDIAL electronic"}, {
	0x00, 0x09, 0x05, "iTEC Technologies Ltd."}, {
	0x00, 0x09, 0x06, "Esteem Networks"}, {
	0x00, 0x09, 0x07, "Chrysalis Development"}, {
	0x00, 0x09, 0x08, "VTech Technology Corp."}, {
	0x00, 0x09, 0x09, "Telenor Connect A/S"}, {
	0x00, 0x09, 0x0A, "SnedFar Technology Co., Ltd."}, {
	0x00, 0x09, 0x0B, "MTL  Instruments PLC"}, {
	0x00, 0x09, 0x0C, "Mayekawa Mfg. Co. Ltd."}, {
	0x00, 0x09, 0x0E, "Helix Technology Inc."}, {
	0x00, 0x09, 0x10, "Simple Access Inc."}, {
	0x00, 0x09, 0x11, "Cisco Systems"}, {
	0x00, 0x09, 0x12, "Cisco Systems"}, {
	0x00, 0x09, 0x14, "COMPUTROLS INC."}, {
	0x00, 0x09, 0x15, "CAS Corp."}, {
	0x00, 0x09, 0x16, "Listman Home Technologies, Inc."}, {
	0x00, 0x09, 0x17, "WEM Technology Inc"}, {
	0x00, 0x09, 0x18, "SAMSUNG TECHWIN CO.,LTD"}, {
	0x00, 0x09, 0x19, "MDS Gateways"}, {
	0x00, 0x09, 0x1A, "Macat Optics & Electronics Co., Ltd."}, {
	0x00, 0x09, 0x1B, "Digital Generation Inc."}, {
	0x00, 0x09, 0x1C, "CacheVision, Inc"}, {
	0x00, 0x09, 0x1D, "Proteam Computer Corporation"}, {
	0x00, 0x09, 0x1E, "Firstech Technology Corp."}, {
	0x00, 0x09, 0x1F, "A&amp;D Co., Ltd."}, {
	0x00, 0x09, 0x21, "Planmeca Oy"}, {
	0x00, 0x09, 0x22, "Touchless Sensor Technology AG"}, {
	0x00, 0x09, 0x23, "Heaman System Co., Ltd"}, {
	0x00, 0x09, 0x24, "Telebau GmbH"}, {
	0x00, 0x09, 0x25, "VSN Systemen BV"}, {
	0x00, 0x09, 0x26, "YODA COMMUNICATIONS, INC."}, {
	0x00, 0x09, 0x27, "TOYOKEIKI CO.,LTD."}, {
	0x00, 0x09, 0x28, "Telecore Inc"}, {
	0x00, 0x09, 0x29, "Sanyo Industries (UK) Limited"}, {
	0x00, 0x09, 0x2A, "MYTECS Co.,Ltd."}, {
	0x00, 0x09, 0x2B, "iQstor Networks, Inc."}, {
	0x00, 0x09, 0x2C, "Hitpoint Inc."}, {
	0x00, 0x09, 0x2D, "High Tech Computer, Corp."}, {
	0x00, 0x09, 0x2E, "B&Tech System Inc."}, {
	0x00, 0x09, 0x2F, "Akom Technology Corporation"}, {
	0x00, 0x09, 0x30, "AeroConcierge Inc."}, {
	0x00, 0x09, 0x31, "Future Internet, Inc."}, {
	0x00, 0x09, 0x32, "Omnilux"}, {
	0x00, 0x09, 0x33, "OPTOVALLEY Co. Ltd."}, {
	0x00, 0x09, 0x34, "Dream-Multimedia-Tv GmbH"}, {
	0x00, 0x09, 0x35, "Sandvine Incorporated"}, {
	0x00, 0x09, 0x36, "Ipetronik GmbH & Co.KG"}, {
	0x00, 0x09, 0x37, "Inventec Appliance Corp"}, {
	0x00, 0x09, 0x38, "Allot Communications"}, {
	0x00, 0x09, 0x39, "ShibaSoku Co.,Ltd."}, {
	0x00, 0x09, 0x3A, "Molex Fiber Optics"}, {
	0x00, 0x09, 0x3B, "HYUNDAI NETWORKS INC."}, {
	0x00, 0x09, 0x3C, "Jacques Technologies P/L"}, {
	0x00, 0x09, 0x3E, "C&I Technologies"}, {
	0x00, 0x09, 0x3F, "Double-Win Enterpirse CO., LTD"}, {
	0x00, 0x09, 0x40, "AGFEO GmbH & Co. KG"}, {
	0x00, 0x09, 0x41, "Allied Telesis K.K."}, {
	0x00, 0x09, 0x42, "CRESCO, LTD."}, {
	0x00, 0x09, 0x43, "Cisco Systems"}, {
	0x00, 0x09, 0x44, "Cisco Systems"}, {
	0x00, 0x09, 0x45, "Palmmicro Communications Inc"}, {
	0x00, 0x09, 0x46, "Cluster Labs GmbH"}, {
	0x00, 0x09, 0x47, "Aztek, Inc."}, {
	0x00, 0x09, 0x48, "Vista Control Systems, Corp."}, {
	0x00, 0x09, 0x49, "Glyph Technologies Inc."}, {
	0x00, 0x09, 0x4A, "Homenet Communications"}, {
	0x00, 0x09, 0x4B, "FillFactory NV"}, {
	0x00, 0x09, 0x4C, "Communication Weaver Co.,Ltd."}, {
	0x00, 0x09, 0x4D, "Braintree Communications Pty Ltd"}, {
	0x00, 0x09, 0x4E, "BARTECH SYSTEMS INTERNATIONAL, INC"}, {
	0x00, 0x09, 0x50, "Independent Storage Corporation"}, {
	0x00, 0x09, 0x52, "Auerswald GmbH & Co. KG"}, {
	0x00, 0x09, 0x53, "Linkage System Integration Co.Ltd."}, {
	0x00, 0x09, 0x54, "AMiT spol. s. r. o."}, {
	0x00, 0x09, 0x55, "Young Generation International Corp."}, {
	0x00, 0x09, 0x56, "Network Systems Group, Ltd. (NSG)"}, {
	0x00, 0x09, 0x57, "Supercaller, Inc."}, {
	0x00, 0x09, 0x58, "INTELNET S.A."}, {
	0x00, 0x09, 0x59, "Sitecsoft"}, {
	0x00, 0x09, 0x5A, "RACEWOOD TECHNOLOGY"}, {
	0x00, 0x09, 0x5B, "Netgear, Inc."}, {
	0x00, 0x09, 0x5D, "Dialogue Technology Corp."}, {
	0x00, 0x09, 0x5E, "Masstech Group Inc."}, {
	0x00, 0x09, 0x5F, "Telebyte, Inc."}, {
	0x00, 0x09, 0x60, "YOZAN Inc."}, {
	0x00, 0x09, 0x61, "Switchgear and Instrumentation Ltd"}, {
	0x00, 0x09, 0x62, "Filetrac AS"}, {
	0x00, 0x09, 0x64, "Hi-Techniques"}, {
	0x00, 0x09, 0x66, "Thales Navigation"}, {
	0x00, 0x09, 0x67, "Tachyon, Inc"}, {
	0x00, 0x09, 0x68, "TECHNOVENTURE, INC."}, {
	0x00, 0x09, 0x69, "Meret Optical Communications"}, {
	0x00, 0x09, 0x6A, "Cloverleaf Communications Inc."}, {
	0x00, 0x09, 0x6B, "IBM Corporation"}, {
	0x00, 0x09, 0x6C, "Imedia Semiconductor Corp."}, {
	0x00, 0x09, 0x6D, "Powernet Technologies Corp."}, {
	0x00, 0x09, 0x6E, "GIANT ELECTRONICS LTD."}, {
	0x00, 0x09, 0x6F, "Beijing Zhongqing Elegant Tech. Corp.,Limited"},
	{
	0x00, 0x09, 0x70, "Vibration Research Corporation"}, {
	0x00, 0x09, 0x71, "Time Management, Inc."}, {
	0x00, 0x09, 0x72, "Securebase,Inc"}, {
	0x00, 0x09, 0x73, "Lenten Technology Co., Ltd."}, {
	0x00, 0x09, 0x74, "Innopia Technologies, Inc."}, {
	0x00, 0x09, 0x75, "fSONA Communications Corporation"}, {
	0x00, 0x09, 0x77, "Brunner Elektronik AG"}, {
	0x00, 0x09, 0x78, "AIJI System Co., Ltd."}, {
	0x00, 0x09, 0x79, "Advanced Television Systems Committee, Inc."}, {
	0x00, 0x09, 0x7A, "Louis Design Labs."}, {
	0x00, 0x09, 0x7B, "Cisco Systems"}, {
	0x00, 0x09, 0x7C, "Cisco Systems"}, {
	0x00, 0x09, 0x7D, "SecWell Networks Oy"}, {
	0x00, 0x09, 0x7E, "IMI TECHNOLOGY CO., LTD"}, {
	0x00, 0x09, 0x80, "Power Zenith Inc."}, {
	0x00, 0x09, 0x81, "Newport Networks"}, {
	0x00, 0x09, 0x82, "Loewe Opta GmbH"}, {
	0x00, 0x09, 0x83, "Gvision Incorporated"}, {
	0x00, 0x09, 0x84, "MyCasa Network Inc."}, {
	0x00, 0x09, 0x85, "Auto Telecom Company"}, {
	0x00, 0x09, 0x86, "Metalink LTD."}, {
	0x00, 0x09, 0x87, "NISHI NIPPON ELECTRIC WIRE & CABLE CO.,LTD."}, {
	0x00, 0x09, 0x88, "Nudian Electron Co., Ltd."}, {
	0x00, 0x09, 0x89, "VividLogic Inc."}, {
	0x00, 0x09, 0x8A, "EqualLogic Inc"}, {
	0x00, 0x09, 0x8B, "Entropic Communications, Inc."}, {
	0x00, 0x09, 0x8C, "Possio AB"}, {
	0x00, 0x09, 0x8D,
		"DCT Ltd (Digital Communication Technologies Ltd)"}, {
	0x00, 0x09, 0x8E, "ipcas GmbH"}, {
	0x00, 0x09, 0x8F, "Cetacean Networks"}, {
	0x00, 0x09, 0x90, "ACKSYS Communications & systems"}, {
	0x00, 0x09, 0x91, "GE Fanuc Automation Manufacturing, Inc."}, {
	0x00, 0x09, 0x92, "InterEpoch Technology,INC."}, {
	0x00, 0x09, 0x93, "Visteon Corporation"}, {
	0x00, 0x09, 0x94, "Cronyx Engineering"}, {
	0x00, 0x09, 0x95, "Castle Technology Ltd"}, {
	0x00, 0x09, 0x96, "RDI"}, {
	0x00, 0x09, 0x97, "Nortel Networks"}, {
	0x00, 0x09, 0x99, "CP GEORGES RENAULT"}, {
	0x00, 0x09, 0x9A, "ELMO COMPANY, LIMITED"}, {
	0x00, 0x09, 0x9B, "Western Telematic Inc."}, {
	0x00, 0x09, 0x9C, "Naval Research Laboratory"}, {
	0x00, 0x09, 0x9D, "Haliplex Communications"}, {
	0x00, 0x09, 0x9E, "Testech, Inc."}, {
	0x00, 0x09, 0xA0, "Microtechno Corporation"}, {
	0x00, 0x09, 0xA1, "Telewise Communications, Inc."}, {
	0x00, 0x09, 0xA2, "Interface Co., Ltd."}, {
	0x00, 0x09, 0xA3, "Leadfly Techologies Corp. Ltd."}, {
	0x00, 0x09, 0xA4, "HARTEC Corporation"}, {
	0x00, 0x09, 0xA5,
		"HANSUNG ELETRONIC INDUSTRIES DEVELOPMENT CO., LTD"}, {
	0x00, 0x09, 0xA6, "Ignis Optics, Inc."}, {
	0x00, 0x09, 0xA7, "Bang & Olufsen A/S"}, {
	0x00, 0x09, 0xA8, "Eastmode Pte Ltd"}, {
	0x00, 0x09, 0xA9, "Ikanos Communications"}, {
	0x00, 0x09, 0xAA, "Data Comm for Business, Inc."}, {
	0x00, 0x09, 0xAB, "Netcontrol Oy"}, {
	0x00, 0x09, 0xAC, "LANVOICE"}, {
	0x00, 0x09, 0xAD, "HYUNDAI SYSCOMM, INC."}, {
	0x00, 0x09, 0xAE, "OKANO ELECTRIC CO.,LTD"}, {
	0x00, 0x09, 0xAF, "e-generis"}, {
	0x00, 0x09, 0xB0, "Onkyo Corporation"}, {
	0x00, 0x09, 0xB1, "Kanematsu Electronics, Ltd."}, {
	0x00, 0x09, 0xB2, "L&F Inc."}, {
	0x00, 0x09, 0xB3, "MCM Systems Ltd"}, {
	0x00, 0x09, 0xB4, "KISAN TELECOM CO., LTD."}, {
	0x00, 0x09, 0xB5, "3J Tech. Co., Ltd."}, {
	0x00, 0x09, 0xB6, "Cisco Systems"}, {
	0x00, 0x09, 0xB7, "Cisco Systems"}, {
	0x00, 0x09, 0xB8, "Entise Systems"}, {
	0x00, 0x09, 0xB9, "Action Imaging Solutions"}, {
	0x00, 0x09, 0xBA, "MAKU Informationstechik GmbH"}, {
	0x00, 0x09, 0xBB, "MathStar, Inc."}, {
	0x00, 0x09, 0xBD, "Epygi Technologies, Ltd."}, {
	0x00, 0x09, 0xBE, "Mamiya-OP Co.,Ltd."}, {
	0x00, 0x09, 0xBF, "Nintendo Co.,Ltd."}, {
	0x00, 0x09, 0xC0, "6WIND"}, {
	0x00, 0x09, 0xC1, "PROCES-DATA A/S"}, {
	0x00, 0x09, 0xC3, "NETAS"}, {
	0x00, 0x09, 0xC4, "Medicore Co., Ltd"}, {
	0x00, 0x09, 0xC5, "KINGENE Technology Corporation"}, {
	0x00, 0x09, 0xC6, "Visionics Corporation"}, {
	0x00, 0x09, 0xC7, "Movistec"}, {
	0x00, 0x09, 0xC8, "SINAGAWA TSUSHIN KEISOU SERVICE"}, {
	0x00, 0x09, 0xC9, "BlueWINC Co., Ltd."}, {
	0x00, 0x09, 0xCA, "iMaxNetworks(Shenzhen)Limited."}, {
	0x00, 0x09, 0xCB, "HBrain"}, {
	0x00, 0x09, 0xCC, "Moog GmbH"}, {
	0x00, 0x09, 0xCD, "HUDSON SOFT CO.,LTD."}, {
	0x00, 0x09, 0xCE, "SpaceBridge Semiconductor Corp."}, {
	0x00, 0x09, 0xCF, "iAd GmbH"}, {
	0x00, 0x09, 0xD0, "Versatel Networks"}, {
	0x00, 0x09, 0xD1, "SERANOA NETWORKS INC"}, {
	0x00, 0x09, 0xD2, "Mai Logic Inc."}, {
	0x00, 0x09, 0xD3, "Western DataCom Co., Inc."}, {
	0x00, 0x09, 0xD4, "Transtech Networks"}, {
	0x00, 0x09, 0xD5, "Signal Communication, Inc."}, {
	0x00, 0x09, 0xD6, "KNC One GmbH"}, {
	0x00, 0x09, 0xD7, "DC Security Products"}, {
	0x00, 0x09, 0xDA, "Control Module Inc."}, {
	0x00, 0x09, 0xDB, "eSpace"}, {
	0x00, 0x09, 0xDC, "Galaxis Technology AG"}, {
	0x00, 0x09, 0xDD, "Mavin Technology Inc."}, {
	0x00, 0x09, 0xDE, "Samjin Information & Communications Co., Ltd."},
	{
	0x00, 0x09, 0xDF, "Vestel Komunikasyon Sanayi ve Ticaret A.S."}, {
	0x00, 0x09, 0xE0, "XEMICS S.A."}, {
	0x00, 0x09, 0xE1, "Gemtek Technology Co., Ltd."}, {
	0x00, 0x09, 0xE2, "Sinbon Electronics Co., Ltd."}, {
	0x00, 0x09, 0xE3, "Angel Iglesias S.A."}, {
	0x00, 0x09, 0xE4, "K Tech Infosystem Inc."}, {
	0x00, 0x09, 0xE5, "Hottinger Baldwin Messtechnik GmbH"}, {
	0x00, 0x09, 0xE6, "Cyber Switching Inc."}, {
	0x00, 0x09, 0xE7, "ADC Techonology"}, {
	0x00, 0x09, 0xE8, "Cisco Systems"}, {
	0x00, 0x09, 0xE9, "Cisco Systems"}, {
	0x00, 0x09, 0xEA, "YEM Inc."}, {
	0x00, 0x09, 0xEB, "HuMANDATA LTD."}, {
	0x00, 0x09, 0xEC, "Daktronics, Inc."}, {
	0x00, 0x09, 0xED, "CipherOptics"}, {
	0x00, 0x09, 0xEE, "MEIKYO ELECTRIC CO.,LTD"}, {
	0x00, 0x09, 0xEF, "Vocera Communications"}, {
	0x00, 0x09, 0xF0, "Shimizu Technology Inc."}, {
	0x00, 0x09, 0xF1, "Yamaki Electric Corporation"}, {
	0x00, 0x09, 0xF2, "Cohu, Inc., Electronics Division"}, {
	0x00, 0x09, 0xF3, "WELL Communication Corp."}, {
	0x00, 0x09, 0xF4, "Alcon Laboratories, Inc."}, {
	0x00, 0x09, 0xF5, "Emerson Network Power Co.,Ltd"}, {
	0x00, 0x09, 0xF6, "Shenzhen Eastern Digital Tech Ltd."}, {
	0x00, 0x09, 0xF7, "SED, a division of Calian"}, {
	0x00, 0x09, 0xF8, "UNIMO TECHNOLOGY CO., LTD."}, {
	0x00, 0x09, 0xF9, "ART JAPAN CO., LTD."}, {
	0x00, 0x09, 0xFB, "Philips Medizinsysteme Boeblingen GmbH"}, {
	0x00, 0x09, 0xFC, "IPFLEX Inc."}, {
	0x00, 0x09, 0xFD, "Ubinetics Limited"}, {
	0x00, 0x09, 0xFE, "Daisy Technologies, Inc."}, {
	0x00, 0x09, 0xFF, "X.net 2000 GmbH"}, {
	0x00, 0x0A, 0x00, "Mediatek Corp."}, {
	0x00, 0x0A, 0x01, "SOHOware, Inc."}, {
	0x00, 0x0A, 0x02, "ANNSO CO., LTD."}, {
	0x00, 0x0A, 0x03, "ENDESA SERVICIOS, S.L."}, {
	0x00, 0x0A, 0x04, "3Com Europe Ltd"}, {
	0x00, 0x0A, 0x05, "Widax Corp."}, {
	0x00, 0x0A, 0x06, "Teledex LLC"}, {
	0x00, 0x0A, 0x07, "Beijing Comsys Technologies Co.,Ltd."}, {
	0x00, 0x0A, 0x08, "ALPINE ELECTRONICS, INC."}, {
	0x00, 0x0A, 0x0A, "SUNIX Co., Ltd."}, {
	0x00, 0x0A, 0x0B, "Sealevel Systems, Inc."}, {
	0x00, 0x0A, 0x0C, "Scientific Research Corporation"}, {
	0x00, 0x0A, 0x0D, "MergeOptics GmbH"}, {
	0x00, 0x0A, 0x0E, "Invivo Research Inc."}, {
	0x00, 0x0A, 0x0F, "Ilryung Telesys, Inc"}, {
	0x00, 0x0A, 0x10, "FAST media integrations AG"}, {
	0x00, 0x0A, 0x11, "ExPet Technologies, Inc"}, {
	0x00, 0x0A, 0x12, "Azylex Technology, Inc"}, {
	0x00, 0x0A, 0x13, "Silent Witness"}, {
	0x00, 0x0A, 0x14, "TECO a.s."}, {
	0x00, 0x0A, 0x15, "Silicon Data, Inc"}, {
	0x00, 0x0A, 0x16, "Lassen Research"}, {
	0x00, 0x0A, 0x17, "NESTAR COMMUNICATIONS, INC"}, {
	0x00, 0x0A, 0x18, "Vichel Inc."}, {
	0x00, 0x0A, 0x19, "Valere Power, Inc."}, {
	0x00, 0x0A, 0x1A, "Imerge Ltd"}, {
	0x00, 0x0A, 0x1B, "Stream Labs"}, {
	0x00, 0x0A, 0x1C, "Bridge Information Co., Ltd."}, {
	0x00, 0x0A, 0x1D, "Optical Communications Products Inc."}, {
	0x00, 0x0A, 0x1E, "Red-M (Communications) Limited"}, {
	0x00, 0x0A, 0x1F, "ART WARE Telecommunication Co., Ltd."}, {
	0x00, 0x0A, 0x20, "SVA Networks, Inc."}, {
	0x00, 0x0A, 0x21, "Integra Telecom Co. Ltd"}, {
	0x00, 0x0A, 0x22, "Amperion Inc"}, {
	0x00, 0x0A, 0x23, "Parama Networks Inc"}, {
	0x00, 0x0A, 0x24, "Octave Communications"}, {
	0x00, 0x0A, 0x25, "CERAGON NETWORKS"}, {
	0x00, 0x0A, 0x27, "Apple Computer, Inc."}, {
	0x00, 0x0A, 0x28, "Motorola Personal Communications Sector"}, {
	0x00, 0x0A, 0x29, "Pan Dacom Networking AG"}, {
	0x00, 0x0A, 0x2A, "QSI Systems Inc."}, {
	0x00, 0x0A, 0x2B, "Etherstuff"}, {
	0x00, 0x0A, 0x2C, "Active Tchnology Corporation"}, {
	0x00, 0x0A, 0x2E, "MAPLE NETWORKS CO., LTD"}, {
	0x00, 0x0A, 0x30, "Johnson Controls-ASG"}, {
	0x00, 0x0A, 0x31, "HCV Wireless"}, {
	0x00, 0x0A, 0x32, "Xsido Corporation"}, {
	0x00, 0x0A, 0x33, "Sierra Logic, Inc."}, {
	0x00, 0x0A, 0x34, "Identicard Systems Incorporated"}, {
	0x00, 0x0A, 0x35, "Xilinx"}, {
	0x00, 0x0A, 0x36, "Synelec Telecom Multimedia"}, {
	0x00, 0x0A, 0x37, "Procera Networks, Inc."}, {
	0x00, 0x0A, 0x38, "Netlock Technologies, Inc."}, {
	0x00, 0x0A, 0x3A, "J-THREE INTERNATIONAL Holding Co., Ltd."}, {
	0x00, 0x0A, 0x3B, "GCT Semiconductor, Inc"}, {
	0x00, 0x0A, 0x3C, "Enerpoint Ltd."}, {
	0x00, 0x0A, 0x3D, "Elo Sistemas Eletronicos S.A."}, {
	0x00, 0x0A, 0x3E, "EADS Telecom"}, {
	0x00, 0x0A, 0x3F, "Data East Corporation"}, {
	0x00, 0x0A, 0x40, "Crown Audio"}, {
	0x00, 0x0A, 0x41, "Cisco Systems"}, {
	0x00, 0x0A, 0x42, "Cisco Systems"}, {
	0x00, 0x0A, 0x43, "Chunghwa Telecom Co., Ltd."}, {
	0x00, 0x0A, 0x44, "Avery Dennison Deutschland GmbH"}, {
	0x00, 0x0A, 0x45, "Audio-Technica Corp."}, {
	0x00, 0x0A, 0x46, "ARO Controls SAS"}, {
	0x00, 0x0A, 0x47, "Allied Vision Technologies"}, {
	0x00, 0x0A, 0x48, "Albatron Technology"}, {
	0x00, 0x0A, 0x49, "Acopia Networks"}, {
	0x00, 0x0A, 0x4A, "Targa Systems Ltd."}, {
	0x00, 0x0A, 0x4B, "DataPower Technology, Inc."}, {
	0x00, 0x0A, 0x4C, "Molecular Devices Corporation"}, {
	0x00, 0x0A, 0x4D, "Noritz Corporation"}, {
	0x00, 0x0A, 0x4E, "UNITEK Electronics INC."}, {
	0x00, 0x0A, 0x4F, "Brain Boxes Limited"}, {
	0x00, 0x0A, 0x50, "REMOTEK CORPORATION"}, {
	0x00, 0x0A, 0x51, "GyroSignal Technology Co., Ltd."}, {
	0x00, 0x0A, 0x52, "Venitek Co. Ltd."}, {
	0x00, 0x0A, 0x53, "Intronics, Incorporated"}, {
	0x00, 0x0A, 0x54, "Laguna Hills, Inc."}, {
	0x00, 0x0A, 0x55, "MARKEM Corporation"}, {
	0x00, 0x0A, 0x56, "HITACHI Maxell Ltd."}, {
	0x00, 0x0A, 0x57, "Hewlett-Packard Company - Standards"}, {
	0x00, 0x0A, 0x58, "Ingenieur-Buero Freyer & Siegel"}, {
	0x00, 0x0A, 0x59, "HW server"}, {
	0x00, 0x0A, 0x5A, "GreenNET Technologies Co.,Ltd."}, {
	0x00, 0x0A, 0x5B, "Power-One as"}, {
	0x00, 0x0A, 0x5C, "Carel s.p.a."}, {
	0x00, 0x0A, 0x5D, "PUC Founder (MSC) Berhad"}, {
	0x00, 0x0A, 0x5E, "3COM Corporation"}, {
	0x00, 0x0A, 0x5F, "almedio inc."}, {
	0x00, 0x0A, 0x60, "Autostar Technology Pte Ltd"}, {
	0x00, 0x0A, 0x61, "Cellinx Systems Inc."}, {
	0x00, 0x0A, 0x62, "Crinis Networks, Inc."}, {
	0x00, 0x0A, 0x63, "DHD GmbH"}, {
	0x00, 0x0A, 0x64, "Eracom Technologies"}, {
	0x00, 0x0A, 0x65, "GentechMedia.co.,ltd."}, {
	0x00, 0x0A, 0x66, "MITSUBISHI ELECTRIC SYSTEM & SERVICE CO.,LTD."},
	{
	0x00, 0x0A, 0x67, "OngCorp"}, {
	0x00, 0x0A, 0x68, "SolarFlare Communications, Inc."}, {
	0x00, 0x0A, 0x69, "SUNNY bell Technology Co., Ltd."}, {
	0x00, 0x0A, 0x6A, "SVM Microwaves s.r.o."}, {
	0x00, 0x0A, 0x6B, "Tadiran Telecom Business Systems LTD"}, {
	0x00, 0x0A, 0x6C, "Walchem Corporation"}, {
	0x00, 0x0A, 0x6D, "EKS Elektronikservice GmbH"}, {
	0x00, 0x0A, 0x6E, "Broadcast Technology Limited"}, {
	0x00, 0x0A, 0x6F, "ZyTera Technologies Inc."}, {
	0x00, 0x0A, 0x70, "MPLS Forum"}, {
	0x00, 0x0A, 0x71, "Avrio Technologies, Inc"}, {
	0x00, 0x0A, 0x72, "SimpleTech, Inc."}, {
	0x00, 0x0A, 0x73, "Scientific Atlanta"}, {
	0x00, 0x0A, 0x74, "Manticom Networks Inc."}, {
	0x00, 0x0A, 0x75, "Cat Electronics"}, {
	0x00, 0x0A, 0x76, "Beida Jade Bird Huaguang Technology Co.,Ltd"}, {
	0x00, 0x0A, 0x77, "Bluewire Technologies LLC"}, {
	0x00, 0x0A, 0x78, "OLITEC"}, {
	0x00, 0x0A, 0x79, "corega K.K."}, {
	0x00, 0x0A, 0x7A, "Kyoritsu Electric Co., Ltd."}, {
	0x00, 0x0A, 0x7C, "Tecton Ltd"}, {
	0x00, 0x0A, 0x7D, "Valo, Inc."}, {
	0x00, 0x0A, 0x7E, "The Advantage Group"}, {
	0x00, 0x0A, 0x7F, "Teradon Industries, Inc"}, {
	0x00, 0x0A, 0x80, "Telkonet Inc."}, {
	0x00, 0x0A, 0x81, "TEIMA Audiotex S.L."}, {
	0x00, 0x0A, 0x82, "TATSUTA SYSTEM ELECTRONICS CO.,LTD."}, {
	0x00, 0x0A, 0x83, "SALTO SYSTEMS S.L."}, {
	0x00, 0x0A, 0x84, "Rainsun Enterprise Co., Ltd."}, {
	0x00, 0x0A, 0x85, "PLAT'C2,Inc"}, {
	0x00, 0x0A, 0x86, "Lenze"}, {
	0x00, 0x0A, 0x87, "Integrated Micromachines Inc."}, {
	0x00, 0x0A, 0x88, "InCypher S.A."}, {
	0x00, 0x0A, 0x89, "Creval Systems, Inc."}, {
	0x00, 0x0A, 0x8A, "Cisco Systems"}, {
	0x00, 0x0A, 0x8B, "Cisco Systems"}, {
	0x00, 0x0A, 0x8C, "Guardware Systems Ltd."}, {
	0x00, 0x0A, 0x8D, "EUROTHERM LIMITED"}, {
	0x00, 0x0A, 0x8E, "Invacom Ltd"}, {
	0x00, 0x0A, 0x8F, "Aska International Inc."}, {
	0x00, 0x0A, 0x90, "Bayside Interactive, Inc."}, {
	0x00, 0x0A, 0x91, "HemoCue AB"}, {
	0x00, 0x0A, 0x92, "Presonus Corporation"}, {
	0x00, 0x0A, 0x93, "W2 Networks, Inc."}, {
	0x00, 0x0A, 0x94, "ShangHai cellink CO., LTD"}, {
	0x00, 0x0A, 0x95, "Apple Computer, Inc."}, {
	0x00, 0x0A, 0x96, "MEWTEL TECHNOLOGY INC."}, {
	0x00, 0x0A, 0x97, "SONICblue, Inc."}, {
	0x00, 0x0A, 0x98, "M+F Gwinner GmbH & Co"}, {
	0x00, 0x0A, 0x99, "Dataradio Inc."}, {
	0x00, 0x0A, 0x9A, "Aiptek International Inc"}, {
	0x00, 0x0A, 0x9B, "Towa Meccs Corporation"}, {
	0x00, 0x0A, 0x9C, "Server Technology, Inc."}, {
	0x00, 0x0A, 0x9D, "King Young Technology Co. Ltd."}, {
	0x00, 0x0A, 0x9E, "BroadWeb Corportation"}, {
	0x00, 0x0A, 0xA0, "Cedar Point Communications"}, {
	0x00, 0x0A, 0xA1, "V V S Limited"}, {
	0x00, 0x0A, 0xA2, "SYSTEK INC."}, {
	0x00, 0x0A, 0xA3, "SHIMAFUJI ELECTRIC CO.,LTD."}, {
	0x00, 0x0A, 0xA4, "SHANGHAI SURVEILLANCE TECHNOLOGY CO,LTD"}, {
	0x00, 0x0A, 0xA5, "MAXLINK INDUSTRIES LIMITED"}, {
	0x00, 0x0A, 0xA6, "Hochiki Corporation"}, {
	0x00, 0x0A, 0xA7, "FEI Company"}, {
	0x00, 0x0A, 0xA8, "ePipe Pty. Ltd."}, {
	0x00, 0x0A, 0xA9, "Brooks Automation GmbH"}, {
	0x00, 0x0A, 0xAA, "AltiGen Communications Inc."}, {
	0x00, 0x0A, 0xAB, "TOYOTA MACS, INC."}, {
	0x00, 0x0A, 0xAC, "TerraTec Electronic GmbH"}, {
	0x00, 0x0A, 0xAD, "Stargames Corporation"}, {
	0x00, 0x0A, 0xAE, "Rosemount Process Analytical"}, {
	0x00, 0x0A, 0xB0, "LOYTEC electronics GmbH"}, {
	0x00, 0x0A, 0xB1, "GENETEC Corporation"}, {
	0x00, 0x0A, 0xB2, "Fresnel Wireless Systems"}, {
	0x00, 0x0A, 0xB3, "Fa. GIRA"}, {
	0x00, 0x0A, 0xB4, "ETIC Telecommunications"}, {
	0x00, 0x0A, 0xB5, "Digital Electronic Network"}, {
	0x00, 0x0A, 0xB6, "COMPUNETIX, INC"}, {
	0x00, 0x0A, 0xB7, "Cisco Systems"}, {
	0x00, 0x0A, 0xB8, "Cisco Systems"}, {
	0x00, 0x0A, 0xB9, "Astera Technologies Corp."}, {
	0x00, 0x0A, 0xBA, "Arcon Technology Limited"}, {
	0x00, 0x0A, 0xBB, "Taiwan Secom Co,. Ltd"}, {
	0x00, 0x0A, 0xBC, "Seabridge Ltd."}, {
	0x00, 0x0A, 0xBE, "OPNET Technologies CO., LTD."}, {
	0x00, 0x0A, 0xBF, "HIROTA SS"}, {
	0x00, 0x0A, 0xC0, "Fuyoh Video Industry CO., LTD."}, {
	0x00, 0x0A, 0xC1, "Futuretel"}, {
	0x00, 0x0A, 0xC2,
		"FiberHome Telecommunication Technologies CO.,LTD"}, {
	0x00, 0x0A, 0xC3, "eM Technics Co., Ltd."}, {
	0x00, 0x0A, 0xC4, "Daewoo Teletech Co., Ltd"}, {
	0x00, 0x0A, 0xC5, "Color Kinetics"}, {
	0x00, 0x0A, 0xC7, "Unication Group"}, {
	0x00, 0x10, 0x00, "CABLE TELEVISION LABORATIES, INC."}, {
	0x00, 0x10, 0x01, "MCK COMMUNICATIONS"}, {
	0x00, 0x10, 0x02, "ACTIA"}, {
	0x00, 0x10, 0x03, "IMATRON, INC."}, {
	0x00, 0x10, 0x04, "THE BRANTLEY COILE COMPANY,INC"}, {
	0x00, 0x10, 0x05, "UEC COMMERCIAL"}, {
	0x00, 0x10, 0x06, "Thales Contact Solutions Ltd."}, {
	0x00, 0x10, 0x07, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x08, "VIENNA SYSTEMS CORPORATION"}, {
	0x00, 0x10, 0x09, "HORO QUARTZ"}, {
	0x00, 0x10, 0x0A, "WILLIAMS COMMUNICATIONS GROUP"}, {
	0x00, 0x10, 0x0B, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x0C, "ITO CO., LTD."}, {
	0x00, 0x10, 0x0D, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x0E, "MICRO LINEAR COPORATION"}, {
	0x00, 0x10, 0x0F, "INDUSTRIAL CPU SYSTEMS"}, {
	0x00, 0x10, 0x10, "INITIO CORPORATION"}, {
	0x00, 0x10, 0x11, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x12, "PROCESSOR SYSTEMS (I) PVT LTD"}, {
	0x00, 0x10, 0x13, "INDUSTRIAL COMPUTER SOURCE"}, {
	0x00, 0x10, 0x14, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x15, "OOmon Inc."}, {
	0x00, 0x10, 0x16, "T.SQWARE"}, {
	0x00, 0x10, 0x17, "MICOS GmbH"}, {
	0x00, 0x10, 0x18, "BROADCOM CORPORATION"}, {
	0x00, 0x10, 0x19, "SIRONA DENTAL SYSTEMS GmbH & Co. KG"}, {
	0x00, 0x10, 0x1A, "PictureTel Corp."}, {
	0x00, 0x10, 0x1B, "CORNET TECHNOLOGY, INC."}, {
	0x00, 0x10, 0x1C, "OHM TECHNOLOGIES INTL, LLC"}, {
	0x00, 0x10, 0x1D, "WINBOND ELECTRONICS CORP."}, {
	0x00, 0x10, 0x1E, "MATSUSHITA ELECTRONIC INSTRUMENTS CORP."}, {
	0x00, 0x10, 0x1F, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x20, "WELCH ALLYN, DATA COLLECTION"}, {
	0x00, 0x10, 0x21, "ENCANTO NETWORKS, INC."}, {
	0x00, 0x10, 0x22, "SatCom Media Corporation"}, {
	0x00, 0x10, 0x23, "FLOWWISE NETWORKS, INC."}, {
	0x00, 0x10, 0x24, "NAGOYA ELECTRIC WORKS CO., LTD"}, {
	0x00, 0x10, 0x25, "GRAYHILL INC."}, {
	0x00, 0x10, 0x26, "ACCELERATED NETWORKS, INC."}, {
	0x00, 0x10, 0x27, "L-3 COMMUNICATIONS EAST"}, {
	0x00, 0x10, 0x28, "COMPUTER TECHNICA, INC."}, {
	0x00, 0x10, 0x29, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x2A, "ZF MICROSYSTEMS, INC."}, {
	0x00, 0x10, 0x2B, "UMAX DATA SYSTEMS, INC."}, {
	0x00, 0x10, 0x2C, "Lasat Networks A/S"}, {
	0x00, 0x10, 0x2D, "HITACHI SOFTWARE ENGINEERING"}, {
	0x00, 0x10, 0x2E, "NETWORK SYSTEMS & TECHNOLOGIES PVT. LTD."}, {
	0x00, 0x10, 0x2F, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x30, "Wi-LAN, Inc."}, {
	0x00, 0x10, 0x31, "OBJECTIVE COMMUNICATIONS, INC."}, {
	0x00, 0x10, 0x32, "ALTA TECHNOLOGY"}, {
	0x00, 0x10, 0x33, "ACCESSLAN COMMUNICATIONS, INC."}, {
	0x00, 0x10, 0x34, "GNP COMPUTERS"}, {
	0x00, 0x10, 0x35, "ELITEGROUP COMPUTER SYSTEMS CO., LTD"}, {
	0x00, 0x10, 0x36, "INTER-TEL INTEGRATED SYSTEMS"}, {
	0x00, 0x10, 0x37, "CYQ've Technology Co., Ltd."}, {
	0x00, 0x10, 0x38, "MICRO RESEARCH INSTITUTE, INC."}, {
	0x00, 0x10, 0x39, "Vectron Systems AG"}, {
	0x00, 0x10, 0x3A, "DIAMOND NETWORK TECH"}, {
	0x00, 0x10, 0x3B, "HIPPI NETWORKING FORUM"}, {
	0x00, 0x10, 0x3C, "IC ENSEMBLE, INC."}, {
	0x00, 0x10, 0x3D, "PHASECOM, LTD."}, {
	0x00, 0x10, 0x3E, "NETSCHOOLS CORPORATION"}, {
	0x00, 0x10, 0x3F, "TOLLGRADE COMMUNICATIONS, INC."}, {
	0x00, 0x10, 0x40, "INTERMEC CORPORATION"}, {
	0x00, 0x10, 0x41, "BRISTOL BABCOCK, INC."}, {
	0x00, 0x10, 0x42, "AlacriTech"}, {
	0x00, 0x10, 0x43, "A2 CORPORATION"}, {
	0x00, 0x10, 0x44, "InnoLabs Corporation"}, {
	0x00, 0x10, 0x45, "Nortel Networks"}, {
	0x00, 0x10, 0x46, "ALCORN MCBRIDE INC."}, {
	0x00, 0x10, 0x47, "ECHO ELETRIC CO. LTD."}, {
	0x00, 0x10, 0x48, "HTRC AUTOMATION, INC."}, {
	0x00, 0x10, 0x49, "SHORELINE TELEWORKS, INC."}, {
	0x00, 0x10, 0x4A, "THE PARVUC CORPORATION"}, {
	0x00, 0x10, 0x4B, "3COM CORPORATION"}, {
	0x00, 0x10, 0x4C, "COMPUTER ACCESS TECHNOLOGY"}, {
	0x00, 0x10, 0x4D, "SURTEC INDUSTRIES, INC."}, {
	0x00, 0x10, 0x4E, "CEOLOGIC"}, {
	0x00, 0x10, 0x4F, "STORAGE TECHNOLOGY CORPORATION"}, {
	0x00, 0x10, 0x50, "RION CO., LTD."}, {
	0x00, 0x10, 0x51, "CMICRO CORPORATION"}, {
	0x00, 0x10, 0x52, "METTLER-TOLEDO (ALBSTADT) GMBH"}, {
	0x00, 0x10, 0x53, "COMPUTER TECHNOLOGY CORP."}, {
	0x00, 0x10, 0x54, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x55, "FUJITSU MICROELECTRONICS, INC."}, {
	0x00, 0x10, 0x56, "SODICK CO., LTD."}, {
	0x00, 0x10, 0x57, "Rebel.com, Inc."}, {
	0x00, 0x10, 0x58, "ArrowPoint Communications"}, {
	0x00, 0x10, 0x59, "DIABLO RESEARCH CO. LLC"}, {
	0x00, 0x10, 0x5A, "3COM CORPORATION"}, {
	0x00, 0x10, 0x5B, "NET INSIGHT AB"}, {
	0x00, 0x10, 0x5C, "QUANTUM DESIGNS (H.K.) LTD."}, {
	0x00, 0x10, 0x5D, "DRAGER, BUSINESS UNIT MONITORING"}, {
	0x00, 0x10, 0x5E, "HEKIMIAN LABORATORIES, INC."}, {
	0x00, 0x10, 0x5F, "IN-SNEC"}, {
	0x00, 0x10, 0x60, "BILLIONTON SYSTEMS, INC."}, {
	0x00, 0x10, 0x61, "HOSTLINK CORP."}, {
	0x00, 0x10, 0x62, "NX SERVER, ILNC."}, {
	0x00, 0x10, 0x63, "STARGUIDE DIGITAL NETWORKS"}, {
	0x00, 0x10, 0x64, "DIGITAL EQUIPMENT CORP."}, {
	0x00, 0x10, 0x65, "RADYNE CORPORATION"}, {
	0x00, 0x10, 0x66, "ADVANCED CONTROL SYSTEMS, INC."}, {
	0x00, 0x10, 0x67, "REDBACK NETWORKS, INC."}, {
	0x00, 0x10, 0x68, "COMOS TELECOM"}, {
	0x00, 0x10, 0x69, "HELIOSS COMMUNICATIONS, INC."}, {
	0x00, 0x10, 0x6A, "DIGITAL MICROWAVE CORPORATION"}, {
	0x00, 0x10, 0x6B, "SONUS NETWORKS, INC."}, {
	0x00, 0x10, 0x6C, "INFRATEC PLUS GmbH"}, {
	0x00, 0x10, 0x6D, "INTEGRITY COMMUNICATIONS, INC."}, {
	0x00, 0x10, 0x6E, "TADIRAN COM. LTD."}, {
	0x00, 0x10, 0x6F, "TRENTON TECHNOLOGY INC."}, {
	0x00, 0x10, 0x70, "CARADON TREND LTD."}, {
	0x00, 0x10, 0x71, "ADVANET INC."}, {
	0x00, 0x10, 0x72, "GVN TECHNOLOGIES, INC."}, {
	0x00, 0x10, 0x73, "TECHNOBOX, INC."}, {
	0x00, 0x10, 0x74, "ATEN INTERNATIONAL CO., LTD."}, {
	0x00, 0x10, 0x75, "Maxtor Corporation"}, {
	0x00, 0x10, 0x76, "EUREM GmbH"}, {
	0x00, 0x10, 0x77, "SAF DRIVE SYSTEMS, LTD."}, {
	0x00, 0x10, 0x78, "NUERA COMMUNICATIONS, INC."}, {
	0x00, 0x10, 0x79, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x7A, "AmbiCom, Inc."}, {
	0x00, 0x10, 0x7B, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0x7C, "P-COM, INC."}, {
	0x00, 0x10, 0x7D, "AURORA COMMUNICATIONS, LTD."}, {
	0x00, 0x10, 0x7E, "BACHMANN ELECTRONIC GmbH"}, {
	0x00, 0x10, 0x7F, "CRESTRON ELECTRONICS, INC."}, {
	0x00, 0x10, 0x80, "METAWAVE COMMUNICATIONS"}, {
	0x00, 0x10, 0x81, "DPS, INC."}, {
	0x00, 0x10, 0x82, "JNA TELECOMMUNICATIONS LIMITED"}, {
	0x00, 0x10, 0x83, "HEWLETT-PACKARD COMPANY"}, {
	0x00, 0x10, 0x84, "K-BOT COMMUNICATIONS"}, {
	0x00, 0x10, 0x85, "POLARIS COMMUNICATIONS, INC."}, {
	0x00, 0x10, 0x86, "ATTO TECHNOLOGY, INC."}, {
	0x00, 0x10, 0x87, "Xstreamis PLC"}, {
	0x00, 0x10, 0x88, "AMERICAN NETWORKS INC."}, {
	0x00, 0x10, 0x89, "WebSonic"}, {
	0x00, 0x10, 0x8A, "TeraLogic, Inc."}, {
	0x00, 0x10, 0x8B, "LASERANIMATION SOLLINGER GmbH"}, {
	0x00, 0x10, 0x8C, "FUJITSU TELECOMMUNICATIONS EUROPE, LTD."}, {
	0x00, 0x10, 0x8D, "JOHNSON CONTROLS, INC."}, {
	0x00, 0x10, 0x8E, "HUGH SYMONS CONCEPT Technologies Ltd."}, {
	0x00, 0x10, 0x8F, "RAPTOR SYSTEMS"}, {
	0x00, 0x10, 0x90, "CIMETRICS, INC."}, {
	0x00, 0x10, 0x91, "NO WIRES NEEDED BV"}, {
	0x00, 0x10, 0x92, "NETCORE INC."}, {
	0x00, 0x10, 0x93, "CMS COMPUTERS, LTD."}, {
	0x00, 0x10, 0x94, "ADTECH, INC."}, {
	0x00, 0x10, 0x95, "Thomson Multimedia, Inc."}, {
	0x00, 0x10, 0x96, "TRACEWELL SYSTEMS, INC."}, {
	0x00, 0x10, 0x97,
		"WinNet Metropolitan Communications Systems, Inc."}, {
	0x00, 0x10, 0x98, "STARNET TECHNOLOGIES, INC."}, {
	0x00, 0x10, 0x99, "InnoMedia, Inc."}, {
	0x00, 0x10, 0x9A, "NETLINE"}, {
	0x00, 0x10, 0x9B, "VIXEL CORPORATION"}, {
	0x00, 0x10, 0x9C, "M-SYSTEM CO., LTD."}, {
	0x00, 0x10, 0x9D, "CLARINET SYSTEMS, INC."}, {
	0x00, 0x10, 0x9E, "AWARE, INC."}, {
	0x00, 0x10, 0x9F, "PAVO, INC."}, {
	0x00, 0x10, 0xA0, "INNOVEX TECHNOLOGIES, INC."}, {
	0x00, 0x10, 0xA1, "KENDIN SEMICONDUCTOR, INC."}, {
	0x00, 0x10, 0xA2, "TNS"}, {
	0x00, 0x10, 0xA3, "OMNITRONIX, INC."}, {
	0x00, 0x10, 0xA4, "XIRCOM"}, {
	0x00, 0x10, 0xA5, "OXFORD INSTRUMENTS"}, {
	0x00, 0x10, 0xA6, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0xA7, "UNEX TECHNOLOGY CORPORATION"}, {
	0x00, 0x10, 0xA8, "RELIANCE COMPUTER CORP."}, {
	0x00, 0x10, 0xA9, "ADHOC TECHNOLOGIES"}, {
	0x00, 0x10, 0xAA, "MEDIA4, INC."}, {
	0x00, 0x10, 0xAB, "KOITO INDUSTRIES, LTD."}, {
	0x00, 0x10, 0xAC, "IMCI TECHNOLOGIES"}, {
	0x00, 0x10, 0xAD, "SOFTRONICS USB, INC."}, {
	0x00, 0x10, 0xAE, "SHINKO ELECTRIC INDUSTRIES CO."}, {
	0x00, 0x10, 0xAF, "TAC SYSTEMS, INC."}, {
	0x00, 0x10, 0xB0, "MERIDIAN TECHNOLOGY CORP."}, {
	0x00, 0x10, 0xB1, "FOR-A CO., LTD."}, {
	0x00, 0x10, 0xB2, "COACTIVE AESTHETICS"}, {
	0x00, 0x10, 0xB3, "NOKIA MULTIMEDIA TERMINALS"}, {
	0x00, 0x10, 0xB4, "ATMOSPHERE NETWORKS"}, {
	0x00, 0x10, 0xB5, "ACCTON TECHNOLOGY CORPORATION"}, {
	0x00, 0x10, 0xB6, "ENTRATA COMMUNICATIONS CORP."}, {
	0x00, 0x10, 0xB7, "COYOTE TECHNOLOGIES, LLC"}, {
	0x00, 0x10, 0xB8, "ISHIGAKI COMPUTER SYSTEM CO."}, {
	0x00, 0x10, 0xB9, "MAXTOR CORP."}, {
	0x00, 0x10, 0xBA, "MARTINHO-DAVIS SYSTEMS, INC."}, {
	0x00, 0x10, 0xBB, "DATA & INFORMATION TECHNOLOGY"}, {
	0x00, 0x10, 0xBC, "Nortel Networks"}, {
	0x00, 0x10, 0xBD, "THE TELECOMMUNICATION TECHNOLOGY COMMITTEE"}, {
	0x00, 0x10, 0xBE, "TELEXIS CORP."}, {
	0x00, 0x10, 0xBF, "InterAir Wireless"}, {
	0x00, 0x10, 0xC0, "ARMA, INC."}, {
	0x00, 0x10, 0xC1, "OI ELECTRIC CO., LTD."}, {
	0x00, 0x10, 0xC2, "WILLNET, INC."}, {
	0x00, 0x10, 0xC3, "CSI-CONTROL SYSTEMS"}, {
	0x00, 0x10, 0xC4, "MEDIA LINKS CO., LTD."}, {
	0x00, 0x10, 0xC5, "PROTOCOL TECHNOLOGIES, INC."}, {
	0x00, 0x10, 0xC6, "USI"}, {
	0x00, 0x10, 0xC7, "DATA TRANSMISSION NETWORK"}, {
	0x00, 0x10, 0xC8, "COMMUNICATIONS ELECTRONICS SECURITY GROUP"}, {
	0x00, 0x10, 0xC9, "MITSUBISHI ELECTRONICS LOGISTIC SUPPORT CO."}, {
	0x00, 0x10, 0xCA, "INTEGRAL ACCESS"}, {
	0x00, 0x10, 0xCB, "FACIT K.K."}, {
	0x00, 0x10, 0xCC, "CLP COMPUTER LOGISTIK PLANUNG GmbH"}, {
	0x00, 0x10, 0xCD, "INTERFACE CONCEPT"}, {
	0x00, 0x10, 0xCE, "VOLAMP, LTD."}, {
	0x00, 0x10, 0xCF, "FIBERLANE COMMUNICATIONS"}, {
	0x00, 0x10, 0xD0, "WITCOM, LTD."}, {
	0x00, 0x10, 0xD1, "Top Layer Networks, Inc."}, {
	0x00, 0x10, 0xD2, "NITTO TSUSHINKI CO., LTD"}, {
	0x00, 0x10, 0xD3, "GRIPS ELECTRONIC GMBH"}, {
	0x00, 0x10, 0xD4, "STORAGE COMPUTER CORPORATION"}, {
	0x00, 0x10, 0xD5, "IMASDE CANARIAS, S.A."}, {
	0x00, 0x10, 0xD6, "ITT - A/CD"}, {
	0x00, 0x10, 0xD7, "ARGOSY RESEARCH INC."}, {
	0x00, 0x10, 0xD8, "CALISTA"}, {
	0x00, 0x10, 0xD9, "IBM JAPAN, FUJISAWA MT+D"}, {
	0x00, 0x10, 0xDA, "MOTION ENGINEERING, INC."}, {
	0x00, 0x10, 0xDB, "NetScreen Technologies, Inc."}, {
	0x00, 0x10, 0xDC, "MICRO-STAR INTERNATIONAL CO., LTD."}, {
	0x00, 0x10, 0xDD, "ENABLE SEMICONDUCTOR, INC."}, {
	0x00, 0x10, 0xDE, "INTERNATIONAL DATACASTING CORPORATION"}, {
	0x00, 0x10, 0xDF, "RISE COMPUTER INC."}, {
	0x00, 0x10, 0xE0, "COBALT MICROSERVER, INC."}, {
	0x00, 0x10, 0xE1, "S.I. TECH, INC."}, {
	0x00, 0x10, 0xE2, "ArrayComm, Inc."}, {
	0x00, 0x10, 0xE3, "COMPAQ COMPUTER CORPORATION"}, {
	0x00, 0x10, 0xE4, "NSI CORPORATION"}, {
	0x00, 0x10, 0xE5, "SOLECTRON TEXAS"}, {
	0x00, 0x10, 0xE6, "APPLIED INTELLIGENT SYSTEMS, INC."}, {
	0x00, 0x10, 0xE7, "BreezeCom"}, {
	0x00, 0x10, 0xE8, "TELOCITY, INCORPORATED"}, {
	0x00, 0x10, 0xE9, "RAIDTEC LTD."}, {
	0x00, 0x10, 0xEA, "ADEPT TECHNOLOGY"}, {
	0x00, 0x10, 0xEB, "SELSIUS SYSTEMS, INC."}, {
	0x00, 0x10, 0xEC, "RPCG, LLC"}, {
	0x00, 0x10, 0xED, "SUNDANCE TECHNOLOGY, INC."}, {
	0x00, 0x10, 0xEE, "CTI PRODUCTS, INC."}, {
	0x00, 0x10, 0xEF, "DBTEL INCORPORATED"}, {
	0x00, 0x10, 0xF1, "I-O CORPORATION"}, {
	0x00, 0x10, 0xF2, "ANTEC"}, {
	0x00, 0x10, 0xF3, "NEXCOM INTERNATIONAL CO., LTD."}, {
	0x00, 0x10, 0xF4, "VERTICAL NETWORKS, INC."}, {
	0x00, 0x10, 0xF5, "AMHERST SYSTEMS, INC."}, {
	0x00, 0x10, 0xF6, "CISCO SYSTEMS, INC."}, {
	0x00, 0x10, 0xF7, "IRIICHI TECHNOLOGIES Inc."}, {
	0x00, 0x10, 0xF8, "KENWOOD TMI CORPORATION"}, {
	0x00, 0x10, 0xF9, "UNIQUE SYSTEMS, INC."}, {
	0x00, 0x10, 0xFA, "ZAYANTE, INC."}, {
	0x00, 0x10, 0xFB, "ZIDA TECHNOLOGIES LIMITED"}, {
	0x00, 0x10, 0xFC, "BROADBAND NETWORKS, INC."}, {
	0x00, 0x10, 0xFD, "COCOM A/S"}, {
	0x00, 0x10, 0xFE, "DIGITAL EQUIPMENT CORPORATION"}, {
	0x00, 0x10, 0xFF, "CISCO SYSTEMS, INC."}, {
	0x00, 0x1C, 0x7C, "PERQ SYSTEMS CORPORATION"}, {
	0x00, 0x20, 0x00, "LEXMARK INTERNATIONAL, INC."}, {
	0x00, 0x20, 0x01, "DSP SOLUTIONS, INC."}, {
	0x00, 0x20, 0x02, "SERITECH ENTERPRISE CO., LTD."}, {
	0x00, 0x20, 0x03, "PIXEL POWER LTD."}, {
	0x00, 0x20, 0x04, "YAMATAKE-HONEYWELL CO., LTD."}, {
	0x00, 0x20, 0x05, "SIMPLE TECHNOLOGY"}, {
	0x00, 0x20, 0x06, "GARRETT COMMUNICATIONS, INC."}, {
	0x00, 0x20, 0x07, "SFA, INC."}, {
	0x00, 0x20, 0x08, "CABLE & COMPUTER TECHNOLOGY"}, {
	0x00, 0x20, 0x09, "PACKARD BELL ELEC., INC."}, {
	0x00, 0x20, 0x0A, "SOURCE-COMM CORP."}, {
	0x00, 0x20, 0x0B, "OCTAGON SYSTEMS CORP."}, {
	0x00, 0x20, 0x0C, "ADASTRA SYSTEMS CORP."}, {
	0x00, 0x20, 0x0D, "CARL ZEISS"}, {
	0x00, 0x20, 0x0E, "SATELLITE TECHNOLOGY MGMT, INC"}, {
	0x00, 0x20, 0x0F, "TANBAC CO., LTD."}, {
	0x00, 0x20, 0x10, "JEOL SYSTEM TECHNOLOGY CO. LTD"}, {
	0x00, 0x20, 0x11, "CANOPUS CO., LTD."}, {
	0x00, 0x20, 0x12, "CAMTRONICS MEDICAL SYSTEMS"}, {
	0x00, 0x20, 0x13, "DIVERSIFIED TECHNOLOGY, INC."}, {
	0x00, 0x20, 0x14, "GLOBAL VIEW CO., LTD."}, {
	0x00, 0x20, 0x15, "ACTIS COMPUTER SA"}, {
	0x00, 0x20, 0x16, "SHOWA ELECTRIC WIRE & CABLE CO"}, {
	0x00, 0x20, 0x17, "ORBOTECH"}, {
	0x00, 0x20, 0x18, "CIS TECHNOLOGY INC."}, {
	0x00, 0x20, 0x19, "OHLER GmbH"}, {
	0x00, 0x20, 0x1A, "N-BASE SWITCH COMMUNICATIONS"}, {
	0x00, 0x20, 0x1B, "NORTHERN TELECOM/NETWORK"}, {
	0x00, 0x20, 0x1C, "EXCEL, INC."}, {
	0x00, 0x20, 0x1D, "KATANA PRODUCTS"}, {
	0x00, 0x20, 0x1E, "NETQUEST CORPORATION"}, {
	0x00, 0x20, 0x1F, "BEST POWER TECHNOLOGY, INC."}, {
	0x00, 0x20, 0x20, "MEGATRON COMPUTER INDUSTRIES PTY, LTD."}, {
	0x00, 0x20, 0x21, "ALGORITHMS SOFTWARE PVT. LTD."}, {
	0x00, 0x20, 0x22, "TEKNIQUE, INC."}, {
	0x00, 0x20, 0x23, "T.C. TECHNOLOGIES PTY. LTD"}, {
	0x00, 0x20, 0x24, "PACIFIC COMMUNICATION SCIENCES"}, {
	0x00, 0x20, 0x25, "CONTROL TECHNOLOGY, INC."}, {
	0x00, 0x20, 0x26, "AMKLY SYSTEMS, INC."}, {
	0x00, 0x20, 0x27, "MING FORTUNE INDUSTRY CO., LTD"}, {
	0x00, 0x20, 0x28, "WEST EGG SYSTEMS, INC."}, {
	0x00, 0x20, 0x29, "TELEPROCESSING PRODUCTS, INC."}, {
	0x00, 0x20, 0x2A, "N.V. DZINE"}, {
	0x00, 0x20, 0x2B, "ADVANCED TELECOMMUNICATIONS MODULES, LTD."}, {
	0x00, 0x20, 0x2C, "WELLTRONIX CO., LTD."}, {
	0x00, 0x20, 0x2D, "TAIYO CORPORATION"}, {
	0x00, 0x20, 0x2E, "DAYSTAR DIGITAL"}, {
	0x00, 0x20, 0x2F, "ZETA COMMUNICATIONS, LTD."}, {
	0x00, 0x20, 0x30, "ANALOG & DIGITAL SYSTEMS"}, {
	0x00, 0x20, 0x31, "ERTEC GmbH"}, {
	0x00, 0x20, 0x32, "ALCATEL TAISEL"}, {
	0x00, 0x20, 0x33, "SYNAPSE TECHNOLOGIES, INC."}, {
	0x00, 0x20, 0x34, "ROTEC INDUSTRIEAUTOMATION GMBH"}, {
	0x00, 0x20, 0x35, "IBM CORPORATION"}, {
	0x00, 0x20, 0x36, "BMC SOFTWARE"}, {
	0x00, 0x20, 0x37, "SEAGATE TECHNOLOGY"}, {
	0x00, 0x20, 0x38, "VME MICROSYSTEMS INTERNATIONAL CORPORATION"}, {
	0x00, 0x20, 0x39, "SCINETS"}, {
	0x00, 0x20, 0x3A, "DIGITAL BI0METRICS INC."}, {
	0x00, 0x20, 0x3B, "WISDM LTD."}, {
	0x00, 0x20, 0x3C, "EUROTIME AB"}, {
	0x00, 0x20, 0x3D, "NOVAR ELECTRONICS CORPORATION"}, {
	0x00, 0x20, 0x3E, "LogiCan Technologies, Inc."}, {
	0x00, 0x20, 0x3F, "JUKI CORPORATION"}, {
	0x00, 0x20, 0x40, "Motorola Broadband Communications Sector"}, {
	0x00, 0x20, 0x41, "DATA NET"}, {
	0x00, 0x20, 0x42, "DATAMETRICS CORP."}, {
	0x00, 0x20, 0x43, "NEURON COMPANY LIMITED"}, {
	0x00, 0x20, 0x44, "GENITECH PTY LTD"}, {
	0x00, 0x20, 0x45, "ION Networks, Inc."}, {
	0x00, 0x20, 0x46, "CIPRICO, INC."}, {
	0x00, 0x20, 0x47, "STEINBRECHER CORP."}, {
	0x00, 0x20, 0x48, "Marconi Communications"}, {
	0x00, 0x20, 0x49, "COMTRON, INC."}, {
	0x00, 0x20, 0x4A, "PRONET GMBH"}, {
	0x00, 0x20, 0x4B, "AUTOCOMPUTER CO., LTD."}, {
	0x00, 0x20, 0x4C, "MITRON COMPUTER PTE LTD."}, {
	0x00, 0x20, 0x4D, "INOVIS GMBH"}, {
	0x00, 0x20, 0x4E, "NETWORK SECURITY SYSTEMS, INC."}, {
	0x00, 0x20, 0x4F, "DEUTSCHE AEROSPACE AG"}, {
	0x00, 0x20, 0x50, "KOREA COMPUTER INC."}, {
	0x00, 0x20, 0x51, "PHOENIX DATA COMMUNUNICATIONS"}, {
	0x00, 0x20, 0x52, "RAGULA SYSTEMS"}, {
	0x00, 0x20, 0x53, "HUNTSVILLE MICROSYSTEMS, INC."}, {
	0x00, 0x20, 0x54, "EASTERN RESEARCH, INC."}, {
	0x00, 0x20, 0x55, "ALTECH CO., LTD."}, {
	0x00, 0x20, 0x56, "NEOPRODUCTS"}, {
	0x00, 0x20, 0x57, "TITZE DATENTECHNIK GmbH"}, {
	0x00, 0x20, 0x58, "ALLIED SIGNAL INC."}, {
	0x00, 0x20, 0x59, "MIRO COMPUTER PRODUCTS AG"}, {
	0x00, 0x20, 0x5A, "COMPUTER IDENTICS"}, {
	0x00, 0x20, 0x5B, "SKYLINE TECHNOLOGY"}, {
	0x00, 0x20, 0x5C, "InterNet Systems of Florida, Inc."}, {
	0x00, 0x20, 0x5D, "NANOMATIC OY"}, {
	0x00, 0x20, 0x5E, "CASTLE ROCK, INC."}, {
	0x00, 0x20, 0x5F, "GAMMADATA COMPUTER GMBH"}, {
	0x00, 0x20, 0x60, "ALCATEL ITALIA S.p.A."}, {
	0x00, 0x20, 0x61, "DYNATECH COMMUNICATIONS, INC."}, {
	0x00, 0x20, 0x62, "SCORPION LOGIC, LTD."}, {
	0x00, 0x20, 0x63, "WIPRO INFOTECH LTD."}, {
	0x00, 0x20, 0x64, "PROTEC MICROSYSTEMS, INC."}, {
	0x00, 0x20, 0x65, "SUPERNET NETWORKING INC."}, {
	0x00, 0x20, 0x66, "GENERAL MAGIC, INC."}, {
	0x00, 0x20, 0x68, "ISDYNE"}, {
	0x00, 0x20, 0x69, "ISDN SYSTEMS CORPORATION"}, {
	0x00, 0x20, 0x6A, "OSAKA COMPUTER CORP."}, {
	0x00, 0x20, 0x6B, "MINOLTA CAMERA CO., LTD."}, {
	0x00, 0x20, 0x6C, "EVERGREEN TECHNOLOGY CORP."}, {
	0x00, 0x20, 0x6D, "DATA RACE, INC."}, {
	0x00, 0x20, 0x6E, "XACT, INC."}, {
	0x00, 0x20, 0x6F, "FLOWPOINT CORPORATION"}, {
	0x00, 0x20, 0x70, "HYNET, LTD."}, {
	0x00, 0x20, 0x71, "IBR GMBH"}, {
	0x00, 0x20, 0x72, "WORKLINK INNOVATIONS"}, {
	0x00, 0x20, 0x73, "FUSION SYSTEMS CORPORATION"}, {
	0x00, 0x20, 0x74, "SUNGWOON SYSTEMS"}, {
	0x00, 0x20, 0x75, "MOTOROLA COMMUNICATION ISRAEL"}, {
	0x00, 0x20, 0x76, "REUDO CORPORATION"}, {
	0x00, 0x20, 0x77, "KARDIOS SYSTEMS CORP."}, {
	0x00, 0x20, 0x78, "RUNTOP, INC."}, {
	0x00, 0x20, 0x79, "MIKRON GMBH"}, {
	0x00, 0x20, 0x7A, "WiSE Communications, Inc."}, {
	0x00, 0x20, 0x7B, "Intel Corporation"}, {
	0x00, 0x20, 0x7C, "AUTEC GmbH"}, {
	0x00, 0x20, 0x7D, "ADVANCED COMPUTER APPLICATIONS"}, {
	0x00, 0x20, 0x7E, "FINECOM Co., Ltd."}, {
	0x00, 0x20, 0x7F, "KYOEI SANGYO CO., LTD."}, {
	0x00, 0x20, 0x80, "SYNERGY (UK) LTD."}, {
	0x00, 0x20, 0x81, "TITAN ELECTRONICS"}, {
	0x00, 0x20, 0x82, "ONEAC CORPORATION"}, {
	0x00, 0x20, 0x83, "PRESTICOM INCORPORATED"}, {
	0x00, 0x20, 0x84, "OCE PRINTING SYSTEMS, GMBH"}, {
	0x00, 0x20, 0x85, "EXIDE ELECTRONICS"}, {
	0x00, 0x20, 0x86, "MICROTECH ELECTRONICS LIMITED"}, {
	0x00, 0x20, 0x87, "MEMOTEC COMMUNICATIONS CORP."}, {
	0x00, 0x20, 0x88, "GLOBAL VILLAGE COMMUNICATION"}, {
	0x00, 0x20, 0x89, "T3PLUS NETWORKING, INC."}, {
	0x00, 0x20, 0x8A, "SONIX COMMUNICATIONS, LTD."}, {
	0x00, 0x20, 0x8B, "LAPIS TECHNOLOGIES, INC."}, {
	0x00, 0x20, 0x8C, "GALAXY NETWORKS, INC."}, {
	0x00, 0x20, 0x8D, "CMD TECHNOLOGY"}, {
	0x00, 0x20, 0x8E, "CHEVIN SOFTWARE ENG. LTD."}, {
	0x00, 0x20, 0x8F, "ECI TELECOM LTD."}, {
	0x00, 0x20, 0x90, "ADVANCED COMPRESSION TECHNOLOGY, INC."}, {
	0x00, 0x20, 0x91, "J125, NATIONAL SECURITY AGENCY"}, {
	0x00, 0x20, 0x92, "CHESS ENGINEERING B.V."}, {
	0x00, 0x20, 0x93, "LANDINGS TECHNOLOGY CORP."}, {
	0x00, 0x20, 0x94, "CUBIX CORPORATION"}, {
	0x00, 0x20, 0x95, "RIVA ELECTRONICS"}, {
	0x00, 0x20, 0x96, "Invensys"}, {
	0x00, 0x20, 0x97, "APPLIED SIGNAL TECHNOLOGY"}, {
	0x00, 0x20, 0x98, "HECTRONIC AB"}, {
	0x00, 0x20, 0x99, "BON ELECTRIC CO., LTD."}, {
	0x00, 0x20, 0x9A, "THE 3DO COMPANY"}, {
	0x00, 0x20, 0x9B, "ERSAT ELECTRONIC GMBH"}, {
	0x00, 0x20, 0x9C, "PRIMARY ACCESS CORP."}, {
	0x00, 0x20, 0x9D, "LIPPERT AUTOMATIONSTECHNIK"}, {
	0x00, 0x20, 0x9E, "BROWN'S OPERATING SYSTEM SERVICES, LTD."}, {
	0x00, 0x20, 0x9F, "MERCURY COMPUTER SYSTEMS, INC."}, {
	0x00, 0x20, 0xA0, "OA LABORATORY CO., LTD."}, {
	0x00, 0x20, 0xA1, "DOVATRON"}, {
	0x00, 0x20, 0xA2, "GALCOM NETWORKING LTD."}, {
	0x00, 0x20, 0xA3, "DIVICOM INC."}, {
	0x00, 0x20, 0xA4, "MULTIPOINT NETWORKS"}, {
	0x00, 0x20, 0xA5, "API ENGINEERING"}, {
	0x00, 0x20, 0xA6, "PROXIM, INC."}, {
	0x00, 0x20, 0xA7, "PAIRGAIN TECHNOLOGIES, INC."}, {
	0x00, 0x20, 0xA8, "SAST TECHNOLOGY CORP."}, {
	0x00, 0x20, 0xA9, "WHITE HORSE INDUSTRIAL"}, {
	0x00, 0x20, 0xAA, "DIGIMEDIA VISION LTD."}, {
	0x00, 0x20, 0xAB, "MICRO INDUSTRIES CORP."}, {
	0x00, 0x20, 0xAC, "INTERFLEX DATENSYSTEME GMBH"}, {
	0x00, 0x20, 0xAD, "LINQ SYSTEMS"}, {
	0x00, 0x20, 0xAE, "ORNET DATA COMMUNICATION TECH."}, {
	0x00, 0x20, 0xAF, "3COM CORPORATION"}, {
	0x00, 0x20, 0xB0, "GATEWAY DEVICES, INC."}, {
	0x00, 0x20, 0xB1, "COMTECH RESEARCH INC."}, {
	0x00, 0x20, 0xB2,
		"GKD Gesellschaft Fur Kommunikation Und Datentechnik"}, {
	0x00, 0x20, 0xB3, "SCLTEC COMMUNICATIONS SYSTEMS"}, {
	0x00, 0x20, 0xB4, "TERMA ELEKTRONIK AS"}, {
	0x00, 0x20, 0xB5, "YASKAWA ELECTRIC CORPORATION"}, {
	0x00, 0x20, 0xB6, "AGILE NETWORKS, INC."}, {
	0x00, 0x20, 0xB7, "NAMAQUA COMPUTERWARE"}, {
	0x00, 0x20, 0xB8, "PRIME OPTION, INC."}, {
	0x00, 0x20, 0xB9, "METRICOM, INC."}, {
	0x00, 0x20, 0xBA, "CENTER FOR HIGH PERFORMANCE"}, {
	0x00, 0x20, 0xBB, "ZAX CORPORATION"}, {
	0x00, 0x20, 0xBC, "JTEC PTY LTD."}, {
	0x00, 0x20, 0xBD, "NIOBRARA R & D CORPORATION"}, {
	0x00, 0x20, 0xBE, "LAN ACCESS CORP."}, {
	0x00, 0x20, 0xBF, "AEHR TEST SYSTEMS"}, {
	0x00, 0x20, 0xC0, "PULSE ELECTRONICS, INC."}, {
	0x00, 0x20, 0xC1, "TAIKO ELECTRIC WORKS, LTD."}, {
	0x00, 0x20, 0xC2, "TEXAS MEMORY SYSTEMS, INC."}, {
	0x00, 0x20, 0xC3, "COUNTER SOLUTIONS LTD."}, {
	0x00, 0x20, 0xC4, "INET,INC."}, {
	0x00, 0x20, 0xC5, "EAGLE TECHNOLOGY"}, {
	0x00, 0x20, 0xC6, "NECTEC"}, {
	0x00, 0x20, 0xC7, "AKAI Professional M.I. Corp."}, {
	0x00, 0x20, 0xC8, "LARSCOM INCORPORATED"}, {
	0x00, 0x20, 0xC9, "VICTRON BV"}, {
	0x00, 0x20, 0xCA, "DIGITAL OCEAN"}, {
	0x00, 0x20, 0xCB, "PRETEC ELECTRONICS CORP."}, {
	0x00, 0x20, 0xCC, "DIGITAL SERVICES, LTD."}, {
	0x00, 0x20, 0xCD, "HYBRID NETWORKS, INC."}, {
	0x00, 0x20, 0xCE, "LOGICAL DESIGN GROUP, INC."}, {
	0x00, 0x20, 0xCF, "TEST & MEASUREMENT SYSTEMS INC"}, {
	0x00, 0x20, 0xD0, "VERSALYNX CORPORATION"}, {
	0x00, 0x20, 0xD1, "MICROCOMPUTER SYSTEMS (M) SDN."}, {
	0x00, 0x20, 0xD2, "RAD DATA COMMUNICATIONS, LTD."}, {
	0x00, 0x20, 0xD3, "OST (OUEST STANDARD TELEMATIQU"}, {
	0x00, 0x20, 0xD4, "CABLETRON - ZEITTNET INC."}, {
	0x00, 0x20, 0xD5, "VIPA GMBH"}, {
	0x00, 0x20, 0xD6, "BREEZECOM"}, {
	0x00, 0x20, 0xD7, "JAPAN MINICOMPUTER SYSTEMS CO., Ltd."}, {
	0x00, 0x20, 0xD8, "Nortel Networks"}, {
	0x00, 0x20, 0xD9, "PANASONIC TECHNOLOGIES, INC./MIECO-US"}, {
	0x00, 0x20, 0xDA, "XYLAN CORPORATION"}, {
	0x00, 0x20, 0xDB, "XNET TECHNOLOGY, INC."}, {
	0x00, 0x20, 0xDC, "DENSITRON TAIWAN LTD."}, {
	0x00, 0x20, 0xDD, "AWA LTD."}, {
	0x00, 0x20, 0xDE, "JAPAN DIGITAL LABORAT'Y CO.LTD"}, {
	0x00, 0x20, 0xDF, "KYOSAN ELECTRIC MFG. CO., LTD."}, {
	0x00, 0x20, 0xE0, "PREMAX ELECTRONICS, INC."}, {
	0x00, 0x20, 0xE1, "ALAMAR ELECTRONICS"}, {
	0x00, 0x20, 0xE2, "INFORMATION RESOURCE ENGINEERING"}, {
	0x00, 0x20, 0xE3, "MCD KENCOM CORPORATION"}, {
	0x00, 0x20, 0xE4, "HSING TECH ENTERPRISE CO., LTD"}, {
	0x00, 0x20, 0xE5, "APEX DATA, INC."}, {
	0x00, 0x20, 0xE6, "LIDKOPING MACHINE TOOLS AB"}, {
	0x00, 0x20, 0xE7, "B&W NUCLEAR SERVICE COMPANY"}, {
	0x00, 0x20, 0xE8, "DATATREK CORPORATION"}, {
	0x00, 0x20, 0xE9, "DANTEL"}, {
	0x00, 0x20, 0xEA, "EFFICIENT NETWORKS, INC."}, {
	0x00, 0x20, 0xEB, "CINCINNATI MICROWAVE, INC."}, {
	0x00, 0x20, 0xEC, "TECHWARE SYSTEMS CORP."}, {
	0x00, 0x20, 0xED, "GIGA-BYTE TECHNOLOGY CO., LTD."}, {
	0x00, 0x20, 0xEE, "GTECH CORPORATION"}, {
	0x00, 0x20, 0xEF, "USC CORPORATION"}, {
	0x00, 0x20, 0xF0, "UNIVERSAL MICROELECTRONICS CO."}, {
	0x00, 0x20, 0xF1, "ALTOS INDIA LIMITED"}, {
	0x00, 0x20, 0xF2, "SUN MICROSYSTEMS, INC."}, {
	0x00, 0x20, 0xF3, "RAYNET CORPORATION"}, {
	0x00, 0x20, 0xF4, "SPECTRIX CORPORATION"}, {
	0x00, 0x20, 0xF5, "PANDATEL AG"}, {
	0x00, 0x20, 0xF6, "NET TEK  AND KARLNET, INC."}, {
	0x00, 0x20, 0xF7, "CYBERDATA"}, {
	0x00, 0x20, 0xF8, "CARRERA COMPUTERS, INC."}, {
	0x00, 0x20, 0xF9, "PARALINK NETWORKS, INC."}, {
	0x00, 0x20, 0xFA, "GDE SYSTEMS, INC."}, {
	0x00, 0x20, 0xFB, "OCTEL COMMUNICATIONS CORP."}, {
	0x00, 0x20, 0xFC, "MATROX"}, {
	0x00, 0x20, 0xFD, "ITV TECHNOLOGIES, INC."}, {
	0x00, 0x20, 0xFE, "TOPWARE INC. / GRAND COMPUTER"}, {
	0x00, 0x20, 0xFF, "SYMMETRICAL TECHNOLOGIES"}, {
	0x00, 0x30, 0x00, "ALLWELL TECHNOLOGY CORP."}, {
	0x00, 0x30, 0x01, "SMP"}, {
	0x00, 0x30, 0x02, "Expand Networks"}, {
	0x00, 0x30, 0x03, "Phasys Ltd."}, {
	0x00, 0x30, 0x04, "LEADTEK RESEARCH INC."}, {
	0x00, 0x30, 0x05, "Fujitsu Siemens Computers"}, {
	0x00, 0x30, 0x06, "SUPERPOWER COMPUTER"}, {
	0x00, 0x30, 0x07, "OPTI, INC."}, {
	0x00, 0x30, 0x08, "AVIO DIGITAL, INC."}, {
	0x00, 0x30, 0x09, "Tachion Networks, Inc."}, {
	0x00, 0x30, 0x0A, "AZTECH SYSTEMS LTD."}, {
	0x00, 0x30, 0x0B, "mPHASE Technologies, Inc."}, {
	0x00, 0x30, 0x0C, "CONGRUENCY, LTD."}, {
	0x00, 0x30, 0x0D, "MMC Technology, Inc."}, {
	0x00, 0x30, 0x0E, "Klotz Digital AG"}, {
	0x00, 0x30, 0x0F, "IMT - Information Management T"}, {
	0x00, 0x30, 0x10, "VISIONETICS INTERNATIONAL"}, {
	0x00, 0x30, 0x11, "HMS FIELDBUS SYSTEMS AB"}, {
	0x00, 0x30, 0x12, "DIGITAL ENGINEERING LTD."}, {
	0x00, 0x30, 0x13, "NEC Corporation"}, {
	0x00, 0x30, 0x14, "DIVIO, INC."}, {
	0x00, 0x30, 0x15, "CP CLARE CORP."}, {
	0x00, 0x30, 0x16, "ISHIDA CO., LTD."}, {
	0x00, 0x30, 0x17, "TERASTACK LTD."}, {
	0x00, 0x30, 0x18, "Jetway Information Co., Ltd."}, {
	0x00, 0x30, 0x19, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0x1A, "SMARTBRIDGES PTE. LTD."}, {
	0x00, 0x30, 0x1B, "SHUTTLE, INC."}, {
	0x00, 0x30, 0x1C, "ALTVATER AIRDATA SYSTEMS"}, {
	0x00, 0x30, 0x1D, "SKYSTREAM, INC."}, {
	0x00, 0x30, 0x1E, "3COM Europe Ltd."}, {
	0x00, 0x30, 0x1F, "OPTICAL NETWORKS, INC."}, {
	0x00, 0x30, 0x20, "TSI, Inc.."}, {
	0x00, 0x30, 0x21, "HSING TECH. ENTERPRISE CO.,LTD"}, {
	0x00, 0x30, 0x22, "Fong Kai Industrial Co., Ltd."}, {
	0x00, 0x30, 0x23, "COGENT COMPUTER SYSTEMS, INC."}, {
	0x00, 0x30, 0x24, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0x25, "CHECKOUT COMPUTER SYSTEMS, LTD"}, {
	0x00, 0x30, 0x26, "HEITEL"}, {
	0x00, 0x30, 0x27, "KERBANGO, INC."}, {
	0x00, 0x30, 0x28, "FASE Saldatura srl"}, {
	0x00, 0x30, 0x29, "OPICOM"}, {
	0x00, 0x30, 0x2A, "SOUTHERN INFORMATION"}, {
	0x00, 0x30, 0x2B, "INALP NETWORKS, INC."}, {
	0x00, 0x30, 0x2C, "SYLANTRO SYSTEMS CORPORATION"}, {
	0x00, 0x30, 0x2D, "QUANTUM BRIDGE COMMUNICATIONS"}, {
	0x00, 0x30, 0x2E, "Hoft & Wessel AG"}, {
	0x00, 0x30, 0x2F, "Smiths Industries"}, {
	0x00, 0x30, 0x30, "HARMONIX CORPORATION"}, {
	0x00, 0x30, 0x31, "LIGHTWAVE COMMUNICATIONS, INC."}, {
	0x00, 0x30, 0x32, "MagicRam, Inc."}, {
	0x00, 0x30, 0x33, "ORIENT TELECOM CO., LTD."}, {
	0x00, 0x30, 0x36, "RMP ELEKTRONIKSYSTEME GMBH"}, {
	0x00, 0x30, 0x37, "Packard Bell Nec Services"}, {
	0x00, 0x30, 0x38, "XCP, INC."}, {
	0x00, 0x30, 0x39, "SOFTBOOK PRESS"}, {
	0x00, 0x30, 0x3A, "MAATEL"}, {
	0x00, 0x30, 0x3B, "PowerCom Technology"}, {
	0x00, 0x30, 0x3C, "ONNTO CORP."}, {
	0x00, 0x30, 0x3D, "IVA CORPORATION"}, {
	0x00, 0x30, 0x3E, "Radcom Ltd."}, {
	0x00, 0x30, 0x3F, "TurboComm Tech Inc."}, {
	0x00, 0x30, 0x40, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0x41, "SAEJIN T & M CO., LTD."}, {
	0x00, 0x30, 0x42, "DeTeWe-Deutsche Telephonwerke"}, {
	0x00, 0x30, 0x43, "IDREAM TECHNOLOGIES, PTE. LTD."}, {
	0x00, 0x30, 0x44, "Portsmith LLC"}, {
	0x00, 0x30, 0x45, "Village Networks, Inc. (VNI)"}, {
	0x00, 0x30, 0x46, "Controlled Electronic Manageme"}, {
	0x00, 0x30, 0x47, "NISSEI ELECTRIC CO., LTD."}, {
	0x00, 0x30, 0x48, "Supermicro Computer, Inc."}, {
	0x00, 0x30, 0x49, "BRYANT TECHNOLOGY, LTD."}, {
	0x00, 0x30, 0x4A, "FRAUNHOFER INSTITUTE IMS"}, {
	0x00, 0x30, 0x4B, "ORBACOM SYSTEMS, INC."}, {
	0x00, 0x30, 0x4C, "APPIAN COMMUNICATIONS, INC."}, {
	0x00, 0x30, 0x4D, "ESI"}, {
	0x00, 0x30, 0x4E, "BUSTEC PRODUCTION LTD."}, {
	0x00, 0x30, 0x4F, "PLANET Technology Corporation"}, {
	0x00, 0x30, 0x50, "Versa Technology"}, {
	0x00, 0x30, 0x51, "ORBIT AVIONIC & COMMUNICATION"}, {
	0x00, 0x30, 0x52, "ELASTIC NETWORKS"}, {
	0x00, 0x30, 0x53, "Basler AG"}, {
	0x00, 0x30, 0x54, "CASTLENET TECHNOLOGY, INC."}, {
	0x00, 0x30, 0x55, "Hitachi Semiconductor America,"}, {
	0x00, 0x30, 0x56, "Beck IPC GmbH"}, {
	0x00, 0x30, 0x57, "E-Tel Corporation"}, {
	0x00, 0x30, 0x58, "API MOTION"}, {
	0x00, 0x30, 0x59, "DIGITAL-LOGIC AG"}, {
	0x00, 0x30, 0x5A, "TELGEN CORPORATION"}, {
	0x00, 0x30, 0x5B, "MODULE DEPARTMENT"}, {
	0x00, 0x30, 0x5C, "SMAR Laboratories Corp."}, {
	0x00, 0x30, 0x5D, "DIGITRA SYSTEMS, INC."}, {
	0x00, 0x30, 0x5E, "Abelko Innovation"}, {
	0x00, 0x30, 0x5F, "IMACON APS"}, {
	0x00, 0x30, 0x60, "STARMATIX, INC."}, {
	0x00, 0x30, 0x61, "MobyTEL"}, {
	0x00, 0x30, 0x62, "PATH 1 NETWORK TECHNOL'S INC."}, {
	0x00, 0x30, 0x63, "SANTERA SYSTEMS, INC."}, {
	0x00, 0x30, 0x64, "ADLINK TECHNOLOGY, INC."}, {
	0x00, 0x30, 0x65, "APPLE COMPUTER, INC."}, {
	0x00, 0x30, 0x66, "DIGITAL WIRELESS CORPORATION"}, {
	0x00, 0x30, 0x67, "BIOSTAR MICROTECH INT'L CORP."}, {
	0x00, 0x30, 0x68, "CYBERNETICS TECH. CO., LTD."}, {
	0x00, 0x30, 0x69, "IMPACCT TECHNOLOGY CORP."}, {
	0x00, 0x30, 0x6A, "PENTA MEDIA CO., LTD."}, {
	0x00, 0x30, 0x6B, "CMOS SYSTEMS, INC."}, {
	0x00, 0x30, 0x6C, "Hitex Holding GmbH"}, {
	0x00, 0x30, 0x6D, "LUCENT TECHNOLOGIES"}, {
	0x00, 0x30, 0x6E, "HEWLETT PACKARD"}, {
	0x00, 0x30, 0x6F, "SEYEON TECH. CO., LTD."}, {
	0x00, 0x30, 0x70, "1Net Corporation"}, {
	0x00, 0x30, 0x71, "Cisco Systems, Inc."}, {
	0x00, 0x30, 0x72, "INTELLIBYTE INC."}, {
	0x00, 0x30, 0x73, "International Microsystems, In"}, {
	0x00, 0x30, 0x74, "EQUIINET LTD."}, {
	0x00, 0x30, 0x75, "ADTECH"}, {
	0x00, 0x30, 0x76, "Akamba Corporation"}, {
	0x00, 0x30, 0x77, "ONPREM NETWORKS"}, {
	0x00, 0x30, 0x78, "Cisco Systems, Inc."}, {
	0x00, 0x30, 0x79, "CQOS, INC."}, {
	0x00, 0x30, 0x7A, "Advanced Technology & Systems"}, {
	0x00, 0x30, 0x7B, "Cisco Systems, Inc."}, {
	0x00, 0x30, 0x7C, "ADID SA"}, {
	0x00, 0x30, 0x7D, "GRE AMERICA, INC."}, {
	0x00, 0x30, 0x7E, "Redflex Communication Systems"}, {
	0x00, 0x30, 0x7F, "IRLAN LTD."}, {
	0x00, 0x30, 0x80, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0x81, "ALTOS C&C"}, {
	0x00, 0x30, 0x82, "TAIHAN ELECTRIC WIRE CO., LTD."}, {
	0x00, 0x30, 0x83, "Ivron Systems"}, {
	0x00, 0x30, 0x84, "ALLIED TELESYN INTERNAIONAL"}, {
	0x00, 0x30, 0x85, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0x86, "Transistor Devices, Inc."}, {
	0x00, 0x30, 0x87, "VEGA GRIESHABER KG"}, {
	0x00, 0x30, 0x88, "Siara Systems, Inc."}, {
	0x00, 0x30, 0x89, "Spectrapoint Wireless, LLC"}, {
	0x00, 0x30, 0x8A, "NICOTRA SISTEMI S.P.A"}, {
	0x00, 0x30, 0x8B, "Brix Networks"}, {
	0x00, 0x30, 0x8C, "ADVANCED DIGITAL INFORMATION"}, {
	0x00, 0x30, 0x8D, "PINNACLE SYSTEMS, INC."}, {
	0x00, 0x30, 0x8E, "CROSS MATCH TECHNOLOGIES, INC."}, {
	0x00, 0x30, 0x8F, "MICRILOR, Inc."}, {
	0x00, 0x30, 0x90, "CYRA TECHNOLOGIES, INC."}, {
	0x00, 0x30, 0x91, "TAIWAN FIRST LINE ELEC. CORP."}, {
	0x00, 0x30, 0x92, "ModuNORM GmbH"}, {
	0x00, 0x30, 0x93, "SONNET TECHNOLOGIES, INC."}, {
	0x00, 0x30, 0x94, "Cisco Systems, Inc."}, {
	0x00, 0x30, 0x95, "Procomp Informatics, Ltd."}, {
	0x00, 0x30, 0x96, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0x97, "EXOMATIC AB"}, {
	0x00, 0x30, 0x98, "Global Converging Technologies"}, {
	0x00, 0x30, 0x99, "BOENIG UND KALLENBACH OHG"}, {
	0x00, 0x30, 0x9A, "ASTRO TERRA CORP."}, {
	0x00, 0x30, 0x9B, "Smartware"}, {
	0x00, 0x30, 0x9C, "Timing Applications, Inc."}, {
	0x00, 0x30, 0x9D, "Nimble Microsystems, Inc."}, {
	0x00, 0x30, 0x9E, "WORKBIT CORPORATION."}, {
	0x00, 0x30, 0x9F, "AMBER NETWORKS"}, {
	0x00, 0x30, 0xA0, "TYCO SUBMARINE SYSTEMS, LTD."}, {
	0x00, 0x30, 0xA1, "OPTI TECH CO., LTD."}, {
	0x00, 0x30, 0xA2, "Lightner Engineering"}, {
	0x00, 0x30, 0xA3, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0xA4, "Woodwind Communications System"}, {
	0x00, 0x30, 0xA5, "ACTIVE POWER"}, {
	0x00, 0x30, 0xA6, "VIANET TECHNOLOGIES, LTD."}, {
	0x00, 0x30, 0xA7, "SCHWEITZER ENGINEERING"}, {
	0x00, 0x30, 0xA8, "OL'E COMMUNICATIONS, INC."}, {
	0x00, 0x30, 0xA9, "Netiverse, Inc."}, {
	0x00, 0x30, 0xAA, "AXUS MICROSYSTEMS, INC."}, {
	0x00, 0x30, 0xAB, "DELTA NETWORKS, INC."}, {
	0x00, 0x30, 0xAC, "Systeme Lauer GmbH & Co., Ltd."}, {
	0x00, 0x30, 0xAD, "SHANGHAI COMMUNICATION"}, {
	0x00, 0x30, 0xAE, "Times N System, Inc."}, {
	0x00, 0x30, 0xAF, "Honeywell Reqelsysteme GmbH"}, {
	0x00, 0x30, 0xB0, "Convergenet Technologies"}, {
	0x00, 0x30, 0xB1, "GOC GESELLSCHAFT FUR OPTISCHE"}, {
	0x00, 0x30, 0xB2, "WESCAM - HEALDSBURG"}, {
	0x00, 0x30, 0xB3, "San Valley Systems, Inc."}, {
	0x00, 0x30, 0xB4, "INTERSIL CORP."}, {
	0x00, 0x30, 0xB5, "Tadiran Microwave Networks"}, {
	0x00, 0x30, 0xB6, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0xB7, "Teletrol Systems, Inc."}, {
	0x00, 0x30, 0xB8, "RiverDelta Networks"}, {
	0x00, 0x30, 0xB9, "ECTEL"}, {
	0x00, 0x30, 0xBA, "AC&T SYSTEM CO., LTD."}, {
	0x00, 0x30, 0xBB, "CacheFlow, Inc."}, {
	0x00, 0x30, 0xBC, "Optronic AG"}, {
	0x00, 0x30, 0xBD, "BELKIN COMPONENTS"}, {
	0x00, 0x30, 0xBE, "City-Net Technology, Inc."}, {
	0x00, 0x30, 0xBF, "MULTIDATA GMBH"}, {
	0x00, 0x30, 0xC0, "Lara Technology, Inc."}, {
	0x00, 0x30, 0xC1, "HEWLETT-PACKARD"}, {
	0x00, 0x30, 0xC2, "COMONE"}, {
	0x00, 0x30, 0xC3, "FLUECKIGER ELEKTRONIK AG"}, {
	0x00, 0x30, 0xC4, "Niigata Canotec Co., Inc."}, {
	0x00, 0x30, 0xC5, "CADENCE DESIGN SYSTEMS"}, {
	0x00, 0x30, 0xC6, "CONTROL SOLUTIONS, INC."}, {
	0x00, 0x30, 0xC7, "MACROMATE CORP."}, {
	0x00, 0x30, 0xC8, "GAD LINE, LTD."}, {
	0x00, 0x30, 0xC9, "LuxN, N"}, {
	0x00, 0x30, 0xCA, "Discovery Com"}, {
	0x00, 0x30, 0xCB, "OMNI FLOW COMPUTERS, INC."}, {
	0x00, 0x30, 0xCC, "Tenor Networks, Inc."}, {
	0x00, 0x30, 0xCD, "CONEXANT SYSTEMS, INC."}, {
	0x00, 0x30, 0xCE, "Zaffire"}, {
	0x00, 0x30, 0xCF, "TWO TECHNOLOGIES, INC."}, {
	0x00, 0x30, 0xD1, "INOVA CORPORATION"}, {
	0x00, 0x30, 0xD2, "WIN TECHNOLOGIES, CO., LTD."}, {
	0x00, 0x30, 0xD3, "Agilent Technologies"}, {
	0x00, 0x30, 0xD4, "COMTIER"}, {
	0x00, 0x30, 0xD5, "DResearch GmbH"}, {
	0x00, 0x30, 0xD6, "MSC VERTRIEBS GMBH"}, {
	0x00, 0x30, 0xD7, "Innovative Systems, L.L.C."}, {
	0x00, 0x30, 0xD8, "SITEK"}, {
	0x00, 0x30, 0xD9, "DATACORE SOFTWARE CORP."}, {
	0x00, 0x30, 0xDA, "COMTREND CO."}, {
	0x00, 0x30, 0xDB, "Mindready Solutions, Inc."}, {
	0x00, 0x30, 0xDC, "RIGHTECH CORPORATION"}, {
	0x00, 0x30, 0xDD, "INDIGITA CORPORATION"}, {
	0x00, 0x30, 0xDE, "WAGO Kontakttechnik GmbH"}, {
	0x00, 0x30, 0xDF, "KB/TEL TELECOMUNICACIONES"}, {
	0x00, 0x30, 0xE0, "OXFORD SEMICONDUCTOR LTD."}, {
	0x00, 0x30, 0xE1, "ACROTRON SYSTEMS, INC."}, {
	0x00, 0x30, 0xE2, "GARNET SYSTEMS CO., LTD."}, {
	0x00, 0x30, 0xE3, "SEDONA NETWORKS CORP."}, {
	0x00, 0x30, 0xE4, "CHIYODA SYSTEM RIKEN"}, {
	0x00, 0x30, 0xE5, "Amper Datos S.A."}, {
	0x00, 0x30, 0xE6, "SIEMENS MEDICAL SYSTEMS"}, {
	0x00, 0x30, 0xE7, "CNF MOBILE SOLUTIONS, INC."}, {
	0x00, 0x30, 0xE8, "ENSIM CORP."}, {
	0x00, 0x30, 0xE9, "GMA COMMUNICATION MANUFACT'G"}, {
	0x00, 0x30, 0xEA, "TeraForce Technology Corporation"}, {
	0x00, 0x30, 0xEB, "TURBONET COMMUNICATIONS, INC."}, {
	0x00, 0x30, 0xEC, "BORGARDT"}, {
	0x00, 0x30, 0xED, "Expert Magnetics Corp."}, {
	0x00, 0x30, 0xEE, "DSG Technology, Inc."}, {
	0x00, 0x30, 0xEF, "NEON TECHNOLOGY, INC."}, {
	0x00, 0x30, 0xF0, "Uniform Industrial Corp."}, {
	0x00, 0x30, 0xF1, "Accton Technology Corp."}, {
	0x00, 0x30, 0xF2, "CISCO SYSTEMS, INC."}, {
	0x00, 0x30, 0xF3, "At Work Computers"}, {
	0x00, 0x30, 0xF4, "STARDOT TECHNOLOGIES"}, {
	0x00, 0x30, 0xF5, "Wild Lab. Ltd."}, {
	0x00, 0x30, 0xF6, "SECURELOGIX CORPORATION"}, {
	0x00, 0x30, 0xF7, "RAMIX INC."}, {
	0x00, 0x30, 0xF8, "Dynapro Systems, Inc."}, {
	0x00, 0x30, 0xF9, "Sollae Systems Co., Ltd."}, {
	0x00, 0x30, 0xFA, "TELICA, INC."}, {
	0x00, 0x30, 0xFB, "AZS Technology AG"}, {
	0x00, 0x30, 0xFC, "Terawave Communications, Inc."}, {
	0x00, 0x30, 0xFD, "INTEGRATED SYSTEMS DESIGN"}, {
	0x00, 0x30, 0xFE, "DSA GmbH"}, {
	0x00, 0x30, 0xFF, "DATAFAB SYSTEMS, INC."}, {
	0x00, 0x40, 0x00, "PCI COMPONENTES DA AMZONIA LTD"}, {
	0x00, 0x40, 0x01, "ZYXEL COMMUNICATIONS, INC."}, {
	0x00, 0x40, 0x02, "PERLE SYSTEMS LIMITED"}, {
	0x00, 0x40, 0x03, "WESTINGHOUSE PROCESS CONTROL"}, {
	0x00, 0x40, 0x04, "ICM CO. LTD."}, {
	0x00, 0x40, 0x05, "ANI COMMUNICATIONS INC."}, {
	0x00, 0x40, 0x06, "SAMPO TECHNOLOGY CORPORATION"}, {
	0x00, 0x40, 0x07, "TELMAT INFORMATIQUE"}, {
	0x00, 0x40, 0x08, "A PLUS INFO CORPORATION"}, {
	0x00, 0x40, 0x09, "TACHIBANA TECTRON CO., LTD."}, {
	0x00, 0x40, 0x0A, "PIVOTAL TECHNOLOGIES, INC."}, {
	0x00, 0x40, 0x0B, "CISCO SYSTEMS, INC."}, {
	0x00, 0x40, 0x0C, "GENERAL MICRO SYSTEMS, INC."}, {
	0x00, 0x40, 0x0D, "LANNET DATA COMMUNICATIONS,LTD"}, {
	0x00, 0x40, 0x0E, "MEMOTEC COMMUNICATIONS, INC."}, {
	0x00, 0x40, 0x0F, "DATACOM TECHNOLOGIES"}, {
	0x00, 0x40, 0x10, "SONIC SYSTEMS, INC."}, {
	0x00, 0x40, 0x11, "ANDOVER CONTROLS CORPORATION"}, {
	0x00, 0x40, 0x12, "WINDATA, INC."}, {
	0x00, 0x40, 0x13, "NTT DATA COMM. SYSTEMS CORP."}, {
	0x00, 0x40, 0x14, "COMSOFT GMBH"}, {
	0x00, 0x40, 0x15, "ASCOM INFRASYS AG"}, {
	0x00, 0x40, 0x16, "HADAX ELECTRONICS, INC."}, {
	0x00, 0x40, 0x17, "XCD INC."}, {
	0x00, 0x40, 0x18, "ADOBE SYSTEMS, INC."}, {
	0x00, 0x40, 0x19, "AEON SYSTEMS, INC."}, {
	0x00, 0x40, 0x1A, "FUJI ELECTRIC CO., LTD."}, {
	0x00, 0x40, 0x1B, "PRINTER SYSTEMS CORP."}, {
	0x00, 0x40, 0x1C, "AST RESEARCH, INC."}, {
	0x00, 0x40, 0x1D, "INVISIBLE SOFTWARE, INC."}, {
	0x00, 0x40, 0x1E, "ICC"}, {
	0x00, 0x40, 0x1F, "COLORGRAPH LTD"}, {
	0x00, 0x40, 0x20, "PINACL COMMUNICATION"}, {
	0x00, 0x40, 0x21, "RASTER GRAPHICS"}, {
	0x00, 0x40, 0x22, "KLEVER COMPUTERS, INC."}, {
	0x00, 0x40, 0x23, "LOGIC CORPORATION"}, {
	0x00, 0x40, 0x24, "COMPAC INC."}, {
	0x00, 0x40, 0x25, "MOLECULAR DYNAMICS"}, {
	0x00, 0x40, 0x26, "MELCO, INC."}, {
	0x00, 0x40, 0x27, "SMC MASSACHUSETTS, INC."}, {
	0x00, 0x40, 0x28, "NETCOMM LIMITED"}, {
	0x00, 0x40, 0x29, "COMPEX"}, {
	0x00, 0x40, 0x2A, "CANOGA-PERKINS"}, {
	0x00, 0x40, 0x2B, "TRIGEM COMPUTER, INC."}, {
	0x00, 0x40, 0x2C, "ISIS DISTRIBUTED SYSTEMS, INC."}, {
	0x00, 0x40, 0x2D, "HARRIS ADACOM CORPORATION"}, {
	0x00, 0x40, 0x2E, "PRECISION SOFTWARE, INC."}, {
	0x00, 0x40, 0x2F, "XLNT DESIGNS INC."}, {
	0x00, 0x40, 0x30, "GK COMPUTER"}, {
	0x00, 0x40, 0x31, "KOKUSAI ELECTRIC CO., LTD"}, {
	0x00, 0x40, 0x32, "DIGITAL COMMUNICATIONS"}, {
	0x00, 0x40, 0x33, "ADDTRON TECHNOLOGY CO., LTD."}, {
	0x00, 0x40, 0x34, "BUSTEK CORPORATION"}, {
	0x00, 0x40, 0x35, "OPCOM"}, {
	0x00, 0x40, 0x36, "TRIBE COMPUTER WORKS, INC."}, {
	0x00, 0x40, 0x37, "SEA-ILAN, INC."}, {
	0x00, 0x40, 0x38, "TALENT ELECTRIC INCORPORATED"}, {
	0x00, 0x40, 0x39, "OPTEC DAIICHI DENKO CO., LTD."}, {
	0x00, 0x40, 0x3A, "IMPACT TECHNOLOGIES"}, {
	0x00, 0x40, 0x3B, "SYNERJET INTERNATIONAL CORP."}, {
	0x00, 0x40, 0x3C, "FORKS, INC."}, {
	0x00, 0x40, 0x3D, "TERADATA"}, {
	0x00, 0x40, 0x3E, "RASTER OPS CORPORATION"}, {
	0x00, 0x40, 0x3F, "SSANGYONG COMPUTER SYSTEMS"}, {
	0x00, 0x40, 0x40, "RING ACCESS, INC."}, {
	0x00, 0x40, 0x41, "FUJIKURA LTD."}, {
	0x00, 0x40, 0x42, "N.A.T. GMBH"}, {
	0x00, 0x40, 0x43, "NOKIA TELECOMMUNICATIONS"}, {
	0x00, 0x40, 0x44, "QNIX COMPUTER CO., LTD."}, {
	0x00, 0x40, 0x45, "TWINHEAD CORPORATION"}, {
	0x00, 0x40, 0x46, "UDC RESEARCH LIMITED"}, {
	0x00, 0x40, 0x47, "WIND RIVER SYSTEMS"}, {
	0x00, 0x40, 0x48, "SMD INFORMATICA S.A."}, {
	0x00, 0x40, 0x49, "TEGIMENTA AG"}, {
	0x00, 0x40, 0x4A, "WEST AUSTRALIAN DEPARTMENT"}, {
	0x00, 0x40, 0x4B, "MAPLE COMPUTER SYSTEMS"}, {
	0x00, 0x40, 0x4C, "HYPERTEC PTY LTD."}, {
	0x00, 0x40, 0x4D, "TELECOMMUNICATIONS TECHNIQUES"}, {
	0x00, 0x40, 0x4E, "FLUENT, INC."}, {
	0x00, 0x40, 0x4F, "SPACE & NAVAL WARFARE SYSTEMS"}, {
	0x00, 0x40, 0x50, "IRONICS, INCORPORATED"}, {
	0x00, 0x40, 0x51, "GRACILIS, INC."}, {
	0x00, 0x40, 0x52, "STAR TECHNOLOGIES, INC."}, {
	0x00, 0x40, 0x53, "AMPRO COMPUTERS"}, {
	0x00, 0x40, 0x54, "CONNECTION MACHINES SERVICES"}, {
	0x00, 0x40, 0x55, "METRONIX GMBH"}, {
	0x00, 0x40, 0x56, "MCM JAPAN LTD."}, {
	0x00, 0x40, 0x57, "LOCKHEED - SANDERS"}, {
	0x00, 0x40, 0x58, "KRONOS, INC."}, {
	0x00, 0x40, 0x59, "YOSHIDA KOGYO K. K."}, {
	0x00, 0x40, 0x5A, "GOLDSTAR INFORMATION & COMM."}, {
	0x00, 0x40, 0x5B, "FUNASSET LIMITED"}, {
	0x00, 0x40, 0x5C, "FUTURE SYSTEMS, INC."}, {
	0x00, 0x40, 0x5D, "STAR-TEK, INC."}, {
	0x00, 0x40, 0x5E, "NORTH HILLS ISRAEL"}, {
	0x00, 0x40, 0x5F, "AFE COMPUTERS LTD."}, {
	0x00, 0x40, 0x60, "COMENDEC LTD"}, {
	0x00, 0x40, 0x61, "DATATECH ENTERPRISES CO., LTD."}, {
	0x00, 0x40, 0x62, "E-SYSTEMS, INC./GARLAND DIV."}, {
	0x00, 0x40, 0x63, "VIA TECHNOLOGIES, INC."}, {
	0x00, 0x40, 0x64, "KLA INSTRUMENTS CORPORATION"}, {
	0x00, 0x40, 0x65, "GTE SPACENET"}, {
	0x00, 0x40, 0x66, "HITACHI CABLE, LTD."}, {
	0x00, 0x40, 0x67, "OMNIBYTE CORPORATION"}, {
	0x00, 0x40, 0x68, "EXTENDED SYSTEMS"}, {
	0x00, 0x40, 0x69, "LEMCOM SYSTEMS, INC."}, {
	0x00, 0x40, 0x6A, "KENTEK INFORMATION SYSTEMS,INC"}, {
	0x00, 0x40, 0x6B, "SYSGEN"}, {
	0x00, 0x40, 0x6C, "COPERNIQUE"}, {
	0x00, 0x40, 0x6D, "LANCO, INC."}, {
	0x00, 0x40, 0x6E, "COROLLARY, INC."}, {
	0x00, 0x40, 0x6F, "SYNC RESEARCH INC."}, {
	0x00, 0x40, 0x70, "INTERWARE CO., LTD."}, {
	0x00, 0x40, 0x71, "ATM COMPUTER GMBH"}, {
	0x00, 0x40, 0x72, "APPLIED INNOVATION, INC."}, {
	0x00, 0x40, 0x73, "BASS ASSOCIATES"}, {
	0x00, 0x40, 0x74, "CABLE AND WIRELESS"}, {
	0x00, 0x40, 0x75, "M-TRADE (UK) LTD"}, {
	0x00, 0x40, 0x76, "Sun Conversion Technologies"}, {
	0x00, 0x40, 0x77, "MAXTON TECHNOLOGY CORPORATION"}, {
	0x00, 0x40, 0x78, "WEARNES AUTOMATION PTE LTD"}, {
	0x00, 0x40, 0x79, "JUKO MANUFACTURE COMPANY, LTD."}, {
	0x00, 0x40, 0x7A, "SOCIETE D'EXPLOITATION DU CNIT"}, {
	0x00, 0x40, 0x7B, "SCIENTIFIC ATLANTA"}, {
	0x00, 0x40, 0x7C, "QUME CORPORATION"}, {
	0x00, 0x40, 0x7D, "EXTENSION TECHNOLOGY CORP."}, {
	0x00, 0x40, 0x7E, "EVERGREEN SYSTEMS, INC."}, {
	0x00, 0x40, 0x7F, "FLIR Systems"}, {
	0x00, 0x40, 0x80, "ATHENIX CORPORATION"}, {
	0x00, 0x40, 0x81, "MANNESMANN SCANGRAPHIC GMBH"}, {
	0x00, 0x40, 0x82, "LABORATORY EQUIPMENT CORP."}, {
	0x00, 0x40, 0x83, "TDA INDUSTRIA DE PRODUTOS"}, {
	0x00, 0x40, 0x84, "HONEYWELL INC."}, {
	0x00, 0x40, 0x85, "SAAB INSTRUMENTS AB"}, {
	0x00, 0x40, 0x86, "MICHELS & KLEBERHOFF COMPUTER"}, {
	0x00, 0x40, 0x87, "UBITREX CORPORATION"}, {
	0x00, 0x40, 0x88, "MOBIUS TECHNOLOGIES, INC."}, {
	0x00, 0x40, 0x89, "MEIDENSHA CORPORATION"}, {
	0x00, 0x40, 0x8A, "TPS TELEPROCESSING SYS. GMBH"}, {
	0x00, 0x40, 0x8B, "RAYLAN CORPORATION"}, {
	0x00, 0x40, 0x8C, "AXIS COMMUNICATIONS AB"}, {
	0x00, 0x40, 0x8D, "THE GOODYEAR TIRE & RUBBER CO."}, {
	0x00, 0x40, 0x8E, "DIGILOG, INC."}, {
	0x00, 0x40, 0x8F, "WM-DATA MINFO AB"}, {
	0x00, 0x40, 0x90, "ANSEL COMMUNICATIONS"}, {
	0x00, 0x40, 0x91, "PROCOMP INDUSTRIA ELETRONICA"}, {
	0x00, 0x40, 0x92, "ASP COMPUTER PRODUCTS, INC."}, {
	0x00, 0x40, 0x93, "PAXDATA NETWORKS LTD."}, {
	0x00, 0x40, 0x94, "SHOGRAPHICS, INC."}, {
	0x00, 0x40, 0x95, "R.P.T. INTERGROUPS INT'L LTD."}, {
	0x00, 0x40, 0x96, "Aironet Wireless Communication"}, {
	0x00, 0x40, 0x97, "DATEX DIVISION OF"}, {
	0x00, 0x40, 0x98, "DRESSLER GMBH & CO."}, {
	0x00, 0x40, 0x99, "NEWGEN SYSTEMS CORP."}, {
	0x00, 0x40, 0x9A, "NETWORK EXPRESS, INC."}, {
	0x00, 0x40, 0x9B, "HAL COMPUTER SYSTEMS INC."}, {
	0x00, 0x40, 0x9C, "TRANSWARE"}, {
	0x00, 0x40, 0x9D, "DIGIBOARD, INC."}, {
	0x00, 0x40, 0x9E, "CONCURRENT TECHNOLOGIES  LTD."}, {
	0x00, 0x40, 0x9F, "LANCAST/CASAT TECHNOLOGY, INC."}, {
	0x00, 0x40, 0xA0, "GOLDSTAR CO., LTD."}, {
	0x00, 0x40, 0xA1, "ERGO COMPUTING"}, {
	0x00, 0x40, 0xA2, "KINGSTAR TECHNOLOGY INC."}, {
	0x00, 0x40, 0xA3, "MICROUNITY SYSTEMS ENGINEERING"}, {
	0x00, 0x40, 0xA4, "ROSE ELECTRONICS"}, {
	0x00, 0x40, 0xA5, "CLINICOMP INTL."}, {
	0x00, 0x40, 0xA6, "Cray, Inc."}, {
	0x00, 0x40, 0xA7, "ITAUTEC PHILCO S.A."}, {
	0x00, 0x40, 0xA8, "IMF INTERNATIONAL LTD."}, {
	0x00, 0x40, 0xA9, "DATACOM INC."}, {
	0x00, 0x40, 0xAA, "VALMET AUTOMATION INC."}, {
	0x00, 0x40, 0xAB, "ROLAND DG CORPORATION"}, {
	0x00, 0x40, 0xAC, "SUPER WORKSTATION, INC."}, {
	0x00, 0x40, 0xAD, "SMA REGELSYSTEME GMBH"}, {
	0x00, 0x40, 0xAE, "DELTA CONTROLS, INC."}, {
	0x00, 0x40, 0xAF, "DIGITAL PRODUCTS, INC."}, {
	0x00, 0x40, 0xB0, "BYTEX CORPORATION, ENGINEERING"}, {
	0x00, 0x40, 0xB1, "CODONICS INC."}, {
	0x00, 0x40, 0xB2, "SYSTEMFORSCHUNG"}, {
	0x00, 0x40, 0xB3, "PAR MICROSYSTEMS CORPORATION"}, {
	0x00, 0x40, 0xB4, "NEXTCOM K.K."}, {
	0x00, 0x40, 0xB5, "VIDEO TECHNOLOGY COMPUTERS LTD"}, {
	0x00, 0x40, 0xB6, "COMPUTERM  CORPORATION"}, {
	0x00, 0x40, 0xB7, "STEALTH COMPUTER SYSTEMS"}, {
	0x00, 0x40, 0xB8, "IDEA ASSOCIATES"}, {
	0x00, 0x40, 0xB9, "MACQ ELECTRONIQUE SA"}, {
	0x00, 0x40, 0xBA, "ALLIANT COMPUTER SYSTEMS CORP."}, {
	0x00, 0x40, 0xBB, "GOLDSTAR CABLE CO., LTD."}, {
	0x00, 0x40, 0xBC, "ALGORITHMICS LTD."}, {
	0x00, 0x40, 0xBD, "STARLIGHT NETWORKS, INC."}, {
	0x00, 0x40, 0xBE, "BOEING DEFENSE & SPACE"}, {
	0x00, 0x40, 0xBF, "CHANNEL SYSTEMS INTERN'L INC."}, {
	0x00, 0x40, 0xC0, "VISTA CONTROLS CORPORATION"}, {
	0x00, 0x40, 0xC1, "BIZERBA-WERKE WILHEIM KRAUT"}, {
	0x00, 0x40, 0xC2, "APPLIED COMPUTING DEVICES"}, {
	0x00, 0x40, 0xC3, "FISCHER AND PORTER CO."}, {
	0x00, 0x40, 0xC4, "KINKEI SYSTEM CORPORATION"}, {
	0x00, 0x40, 0xC5, "MICOM COMMUNICATIONS INC."}, {
	0x00, 0x40, 0xC6, "FIBERNET RESEARCH, INC."}, {
	0x00, 0x40, 0xC7, "RUBY TECH CORPORATION"}, {
	0x00, 0x40, 0xC8, "MILAN TECHNOLOGY CORPORATION"}, {
	0x00, 0x40, 0xC9, "NCUBE"}, {
	0x00, 0x40, 0xCA, "FIRST INTERNAT'L COMPUTER, INC"}, {
	0x00, 0x40, 0xCB, "LANWAN TECHNOLOGIES"}, {
	0x00, 0x40, 0xCC, "SILCOM MANUF'G TECHNOLOGY INC."}, {
	0x00, 0x40, 0xCD, "TERA MICROSYSTEMS, INC."}, {
	0x00, 0x40, 0xCE, "NET-SOURCE, INC."}, {
	0x00, 0x40, 0xCF, "STRAWBERRY TREE, INC."}, {
	0x00, 0x40, 0xD0, "MITAC INTERNATIONAL CORP."}, {
	0x00, 0x40, 0xD1, "FUKUDA DENSHI CO., LTD."}, {
	0x00, 0x40, 0xD2, "PAGINE CORPORATION"}, {
	0x00, 0x40, 0xD3, "KIMPSION INTERNATIONAL CORP."}, {
	0x00, 0x40, 0xD4, "GAGE TALKER CORP."}, {
	0x00, 0x40, 0xD5, "SARTORIUS AG"}, {
	0x00, 0x40, 0xD6, "LOCAMATION B.V."}, {
	0x00, 0x40, 0xD7, "STUDIO GEN INC."}, {
	0x00, 0x40, 0xD8, "OCEAN OFFICE AUTOMATION LTD."}, {
	0x00, 0x40, 0xD9, "AMERICAN MEGATRENDS INC."}, {
	0x00, 0x40, 0xDA, "TELSPEC LTD"}, {
	0x00, 0x40, 0xDB, "ADVANCED TECHNICAL SOLUTIONS"}, {
	0x00, 0x40, 0xDC, "TRITEC ELECTRONIC GMBH"}, {
	0x00, 0x40, 0xDD, "HONG TECHNOLOGIES"}, {
	0x00, 0x40, 0xDE, "ELETTRONICA SAN GIORGIO"}, {
	0x00, 0x40, 0xDF, "DIGALOG SYSTEMS, INC."}, {
	0x00, 0x40, 0xE0, "ATOMWIDE LTD."}, {
	0x00, 0x40, 0xE1, "MARNER INTERNATIONAL, INC."}, {
	0x00, 0x40, 0xE2, "MESA RIDGE TECHNOLOGIES, INC."}, {
	0x00, 0x40, 0xE3, "QUIN SYSTEMS LTD"}, {
	0x00, 0x40, 0xE4, "E-M TECHNOLOGY, INC."}, {
	0x00, 0x40, 0xE5, "SYBUS CORPORATION"}, {
	0x00, 0x40, 0xE6, "C.A.E.N."}, {
	0x00, 0x40, 0xE7, "ARNOS INSTRUMENTS & COMPUTER"}, {
	0x00, 0x40, 0xE8, "CHARLES RIVER DATA SYSTEMS,INC"}, {
	0x00, 0x40, 0xE9, "ACCORD SYSTEMS, INC."}, {
	0x00, 0x40, 0xEA, "PLAIN TREE SYSTEMS INC"}, {
	0x00, 0x40, 0xEB, "MARTIN MARIETTA CORPORATION"}, {
	0x00, 0x40, 0xEC, "MIKASA SYSTEM ENGINEERING"}, {
	0x00, 0x40, 0xED, "NETWORK CONTROLS INT'NATL INC."}, {
	0x00, 0x40, 0xEE, "OPTIMEM"}, {
	0x00, 0x40, 0xEF, "HYPERCOM, INC."}, {
	0x00, 0x40, 0xF0, "MICRO SYSTEMS, INC."}, {
	0x00, 0x40, 0xF1, "CHUO ELECTRONICS CO., LTD."}, {
	0x00, 0x40, 0xF2, "JANICH & KLASS COMPUTERTECHNIK"}, {
	0x00, 0x40, 0xF3, "NETCOR"}, {
	0x00, 0x40, 0xF4, "CAMEO COMMUNICATIONS, INC."}, {
	0x00, 0x40, 0xF5, "OEM ENGINES"}, {
	0x00, 0x40, 0xF6, "KATRON COMPUTERS INC."}, {
	0x00, 0x40, 0xF7, "POLAROID MEDICAL IMAGING SYS."}, {
	0x00, 0x40, 0xF8, "SYSTEMHAUS DISCOM"}, {
	0x00, 0x40, 0xF9, "COMBINET"}, {
	0x00, 0x40, 0xFA, "MICROBOARDS, INC."}, {
	0x00, 0x40, 0xFB, "CASCADE COMMUNICATIONS CORP."}, {
	0x00, 0x40, 0xFC, "IBR COMPUTER TECHNIK GMBH"}, {
	0x00, 0x40, 0xFD, "LXE"}, {
	0x00, 0x40, 0xFE, "SYMPLEX COMMUNICATIONS"}, {
	0x00, 0x40, 0xFF, "TELEBIT CORPORATION"}, {
	0x00, 0x42, 0x52, "RLX Technologies"}, {
	0x00, 0x50, 0x00, "NEXO COMMUNICATIONS, INC."}, {
	0x00, 0x50, 0x01, "YAMASHITA SYSTEMS CORP."}, {
	0x00, 0x50, 0x02, "OMNISEC AG"}, {
	0x00, 0x50, 0x03, "GRETAG MACBETH AG"}, {
	0x00, 0x50, 0x04, "3COM CORPORATION"}, {
	0x00, 0x50, 0x06, "TAC AB"}, {
	0x00, 0x50, 0x07, "SIEMENS TELECOMMUNICATION SYSTEMS LIMITED"}, {
	0x00, 0x50, 0x08, "TIVA MICROCOMPUTER CORP. (TMC)"}, {
	0x00, 0x50, 0x09, "PHILIPS BROADBAND NETWORKS"}, {
	0x00, 0x50, 0x0A, "IRIS TECHNOLOGIES, INC."}, {
	0x00, 0x50, 0x0B, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x0C, "e-Tek Labs, Inc."}, {
	0x00, 0x50, 0x0D, "SATORI ELECTORIC CO., LTD."}, {
	0x00, 0x50, 0x0E, "CHROMATIS NETWORKS, INC."}, {
	0x00, 0x50, 0x0F, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x10, "NovaNET Learning, Inc."}, {
	0x00, 0x50, 0x12, "CBL - GMBH"}, {
	0x00, 0x50, 0x13, "Chaparral Network Storage"}, {
	0x00, 0x50, 0x14, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x15, "BRIGHT STAR ENGINEERING"}, {
	0x00, 0x50, 0x16, "SST/WOODHEAD INDUSTRIES"}, {
	0x00, 0x50, 0x17, "RSR S.R.L."}, {
	0x00, 0x50, 0x18, "ADVANCED MULTIMEDIA INTERNET TECHNOLOGY INC."},
	{
	0x00, 0x50, 0x19, "SPRING TIDE NETWORKS, INC."}, {
	0x00, 0x50, 0x1A, "UISIQN"}, {
	0x00, 0x50, 0x1B, "ABL CANADA, INC."}, {
	0x00, 0x50, 0x1C, "JATOM SYSTEMS, INC."}, {
	0x00, 0x50, 0x1E, "MIRANDA TECHNOLOGIES, INC."}, {
	0x00, 0x50, 0x1F, "MRG SYSTEMS, LTD."}, {
	0x00, 0x50, 0x20, "MEDIASTAR CO., LTD."}, {
	0x00, 0x50, 0x21, "EIS INTERNATIONAL, INC."}, {
	0x00, 0x50, 0x22, "ZONET TECHNOLOGY, INC."}, {
	0x00, 0x50, 0x23, "PG DESIGN ELECTRONICS, INC."}, {
	0x00, 0x50, 0x24, "NAVIC SYSTEMS, INC."}, {
	0x00, 0x50, 0x26, "COSYSTEMS, INC."}, {
	0x00, 0x50, 0x27, "GENICOM CORPORATION"}, {
	0x00, 0x50, 0x28, "AVAL COMMUNICATIONS"}, {
	0x00, 0x50, 0x29, "1394 PRINTER WORKING GROUP"}, {
	0x00, 0x50, 0x2A, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x2B, "GENRAD LTD."}, {
	0x00, 0x50, 0x2C, "SOYO COMPUTER, INC."}, {
	0x00, 0x50, 0x2D, "ACCEL, INC."}, {
	0x00, 0x50, 0x2E, "CAMBEX CORPORATION"}, {
	0x00, 0x50, 0x2F, "TollBridge Technologies, Inc."}, {
	0x00, 0x50, 0x30, "FUTURE PLUS SYSTEMS"}, {
	0x00, 0x50, 0x31, "AEROFLEX LABORATORIES, INC."}, {
	0x00, 0x50, 0x32, "PICAZO COMMUNICATIONS, INC."}, {
	0x00, 0x50, 0x33, "MAYAN NETWORKS"}, {
	0x00, 0x50, 0x36, "NETCAM, LTD."}, {
	0x00, 0x50, 0x37, "KOGA ELECTRONICS CO."}, {
	0x00, 0x50, 0x38, "DAIN TELECOM CO., LTD."}, {
	0x00, 0x50, 0x39, "MARINER NETWORKS"}, {
	0x00, 0x50, 0x3A, "DATONG ELECTRONICS LTD."}, {
	0x00, 0x50, 0x3B, "MEDIAFIRE CORPORATION"}, {
	0x00, 0x50, 0x3C, "TSINGHUA NOVEL ELECTRONICS"}, {
	0x00, 0x50, 0x3E, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x3F, "ANCHOR GAMES"}, {
	0x00, 0x50, 0x40, "EMWARE, INC."}, {
	0x00, 0x50, 0x41, "CTX OPTO ELECTRONIC CORP."}, {
	0x00, 0x50, 0x42, "SCI MANUFACTURING SINGAPORE PTE, LTD."}, {
	0x00, 0x50, 0x43, "MARVELL SEMICONDUCTOR, INC."}, {
	0x00, 0x50, 0x44, "ASACA CORPORATION"}, {
	0x00, 0x50, 0x45, "RIOWORKS SOLUTIONS, INC."}, {
	0x00, 0x50, 0x46, "MENICX INTERNATIONAL CO., LTD."}, {
	0x00, 0x50, 0x48, "INFOLIBRIA"}, {
	0x00, 0x50, 0x49, "ELLACOYA NETWORKS, INC."}, {
	0x00, 0x50, 0x4A, "ELTECO A.S."}, {
	0x00, 0x50, 0x4B, "BARCONET N.V."}, {
	0x00, 0x50, 0x4C, "GALIL MOTION CONTROL, INC."}, {
	0x00, 0x50, 0x4D, "TOKYO ELECTRON DEVICE LTD."}, {
	0x00, 0x50, 0x4E, "SIERRA MONITOR CORP."}, {
	0x00, 0x50, 0x4F, "OLENCOM ELECTRONICS"}, {
	0x00, 0x50, 0x50, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x51, "IWATSU ELECTRIC CO., LTD."}, {
	0x00, 0x50, 0x52, "TIARA NETWORKS, INC."}, {
	0x00, 0x50, 0x53, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x54, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x55, "DOMS A/S"}, {
	0x00, 0x50, 0x56, "VMWare, Inc."}, {
	0x00, 0x50, 0x57, "BROADBAND ACCESS SYSTEMS"}, {
	0x00, 0x50, 0x58, "VEGASTREAM LIMITED"}, {
	0x00, 0x50, 0x59, "SUITE TECHNOLOGY SYSTEMS NETWORK"}, {
	0x00, 0x50, 0x5A, "NETWORK ALCHEMY, INC."}, {
	0x00, 0x50, 0x5B, "KAWASAKI LSI U.S.A., INC."}, {
	0x00, 0x50, 0x5C, "TUNDO CORPORATION"}, {
	0x00, 0x50, 0x5E, "DIGITEK MICROLOGIC S.A."}, {
	0x00, 0x50, 0x5F, "BRAND INNOVATORS"}, {
	0x00, 0x50, 0x60, "TANDBERG TELECOM AS"}, {
	0x00, 0x50, 0x62, "KOUWELL ELECTRONICS CORP.  **"}, {
	0x00, 0x50, 0x63, "OY COMSEL SYSTEM AB"}, {
	0x00, 0x50, 0x64, "CAE ELECTRONICS"}, {
	0x00, 0x50, 0x65, "DENSEI-LAMBAD Co., Ltd."}, {
	0x00, 0x50, 0x66, "AtecoM GmbH advanced telecomunication modules"},
	{
	0x00, 0x50, 0x67, "AEROCOMM, INC."}, {
	0x00, 0x50, 0x68, "ELECTRONIC INDUSTRIES ASSOCIATION"}, {
	0x00, 0x50, 0x69, "PixStream Incorporated"}, {
	0x00, 0x50, 0x6A, "EDEVA, INC."}, {
	0x00, 0x50, 0x6B, "SPX-ATEG"}, {
	0x00, 0x50, 0x6C, "G & L BEIJER ELECTRONICS AB"}, {
	0x00, 0x50, 0x6D, "VIDEOJET SYSTEMS"}, {
	0x00, 0x50, 0x6E, "CORDER ENGINEERING CORPORATION"}, {
	0x00, 0x50, 0x6F, "G-CONNECT"}, {
	0x00, 0x50, 0x70, "CHAINTECH COMPUTER CO., LTD."}, {
	0x00, 0x50, 0x71, "AIWA CO., LTD."}, {
	0x00, 0x50, 0x72, "CORVIS CORPORATION"}, {
	0x00, 0x50, 0x73, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x74, "ADVANCED HI-TECH CORP."}, {
	0x00, 0x50, 0x75, "KESTREL SOLUTIONS"}, {
	0x00, 0x50, 0x76, "IBM"}, {
	0x00, 0x50, 0x77, "PROLIFIC TECHNOLOGY, INC."}, {
	0x00, 0x50, 0x78, "MEGATON HOUSE, LTD."}, {
	0x00, 0x50, 0x7A, "XPEED, INC."}, {
	0x00, 0x50, 0x7B, "MERLOT COMMUNICATIONS"}, {
	0x00, 0x50, 0x7C, "VIDEOCON AG"}, {
	0x00, 0x50, 0x7D, "IFP"}, {
	0x00, 0x50, 0x7E, "NEWER TECHNOLOGY"}, {
	0x00, 0x50, 0x7F, "DrayTek Corp."}, {
	0x00, 0x50, 0x80, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0x81, "MURATA MACHINERY, LTD."}, {
	0x00, 0x50, 0x82, "FORESSON CORPORATION"}, {
	0x00, 0x50, 0x83, "GILBARCO, INC."}, {
	0x00, 0x50, 0x84, "ATL PRODUCTS"}, {
	0x00, 0x50, 0x86, "TELKOM SA, LTD."}, {
	0x00, 0x50, 0x87, "TERASAKI ELECTRIC CO., LTD."}, {
	0x00, 0x50, 0x88, "AMANO CORPORATION"}, {
	0x00, 0x50, 0x89, "SAFETY MANAGEMENT SYSTEMS"}, {
	0x00, 0x50, 0x8B, "COMPAQ COMPUTER CORPORATION"}, {
	0x00, 0x50, 0x8C, "RSI SYSTEMS"}, {
	0x00, 0x50, 0x8D, "ABIT COMPUTER CORPORATION"}, {
	0x00, 0x50, 0x8E, "OPTIMATION, INC."}, {
	0x00, 0x50, 0x8F, "ASITA TECHNOLOGIES INT'L LTD."}, {
	0x00, 0x50, 0x90, "DCTRI"}, {
	0x00, 0x50, 0x91, "NETACCESS, INC."}, {
	0x00, 0x50, 0x92, "RIGAKU INDUSTRIAL CORPORATION"}, {
	0x00, 0x50, 0x93, "BOEING"}, {
	0x00, 0x50, 0x94, "PACE MICRO TECHNOLOGY PLC"}, {
	0x00, 0x50, 0x95, "PERACOM NETWORKS"}, {
	0x00, 0x50, 0x96, "SALIX TECHNOLOGIES, INC."}, {
	0x00, 0x50, 0x97, "MMC-EMBEDDED COMPUTERTECHNIK GmbH"}, {
	0x00, 0x50, 0x98, "GLOBALOOP, LTD."}, {
	0x00, 0x50, 0x99, "3COM EUROPE, LTD."}, {
	0x00, 0x50, 0x9A, "TAG ELECTRONIC SYSTEMS"}, {
	0x00, 0x50, 0x9B, "SWITCHCORE AB"}, {
	0x00, 0x50, 0x9C, "BETA RESEARCH"}, {
	0x00, 0x50, 0x9D, "THE INDUSTREE B.V."}, {
	0x00, 0x50, 0x9E, "Les Technologies SoftAcoustik Inc."}, {
	0x00, 0x50, 0x9F, "HORIZON COMPUTER"}, {
	0x00, 0x50, 0xA0, "DELTA COMPUTER SYSTEMS, INC."}, {
	0x00, 0x50, 0xA1, "CARLO GAVAZZI, INC."}, {
	0x00, 0x50, 0xA2, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0xA3, "TransMedia Communications, Inc."}, {
	0x00, 0x50, 0xA4, "IO TECH, INC."}, {
	0x00, 0x50, 0xA5, "CAPITOL BUSINESS SYSTEMS, LTD."}, {
	0x00, 0x50, 0xA6, "OPTRONICS"}, {
	0x00, 0x50, 0xA7, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0xA8, "OpenCon Systems, Inc."}, {
	0x00, 0x50, 0xA9, "MOLDAT WIRELESS TECHNOLGIES"}, {
	0x00, 0x50, 0xAA, "KONICA CORPORATION"}, {
	0x00, 0x50, 0xAB, "NALTEC, INC."}, {
	0x00, 0x50, 0xAC, "MAPLE COMPUTER CORPORATION"}, {
	0x00, 0x50, 0xAD, "CommUnique Wireless Corp."}, {
	0x00, 0x50, 0xAE, "IWAKI ELECTRONICS CO., LTD."}, {
	0x00, 0x50, 0xAF, "INTERGON, INC."}, {
	0x00, 0x50, 0xB0, "TECHNOLOGY ATLANTA CORPORATION"}, {
	0x00, 0x50, 0xB1, "GIDDINGS & LEWIS"}, {
	0x00, 0x50, 0xB2, "BRODEL AUTOMATION"}, {
	0x00, 0x50, 0xB3, "VOICEBOARD CORPORATION"}, {
	0x00, 0x50, 0xB4, "SATCHWELL CONTROL SYSTEMS, LTD"}, {
	0x00, 0x50, 0xB5, "FICHET-BAUCHE"}, {
	0x00, 0x50, 0xB6, "GOOD WAY IND. CO., LTD."}, {
	0x00, 0x50, 0xB7, "BOSER TECHNOLOGY CO., LTD."}, {
	0x00, 0x50, 0xB8, "INOVA COMPUTERS GMBH & CO. KG"}, {
	0x00, 0x50, 0xB9, "XITRON TECHNOLOGIES, INC."}, {
	0x00, 0x50, 0xBA, "D-LINK"}, {
	0x00, 0x50, 0xBB, "CMS TECHNOLOGIES"}, {
	0x00, 0x50, 0xBC, "HAMMER STORAGE SOLUTIONS"}, {
	0x00, 0x50, 0xBD, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0xBE, "FAST MULTIMEDIA AG"}, {
	0x00, 0x50, 0xBF, "MOTOTECH INC."}, {
	0x00, 0x50, 0xC0, "GATAN, INC."}, {
	0x00, 0x50, 0xC1, "GEMFLEX NETWORKS, LTD."}, {
	0x00, 0x50, 0xC2, "IEEE REGISTRATION AUTHORITY"}, {
	0x00, 0x50, 0xC4, "IMD"}, {
	0x00, 0x50, 0xC5, "ADS TECHNOLOGIES, INC."}, {
	0x00, 0x50, 0xC6, "LOOP TELECOMMUNICATION INTERNATIONAL, INC."}, {
	0x00, 0x50, 0xC8, "ADDONICS COMMUNICATIONS, INC."}, {
	0x00, 0x50, 0xC9, "MASPRO DENKOH CORP."}, {
	0x00, 0x50, 0xCA, "NET TO NET TECHNOLOGIES"}, {
	0x00, 0x50, 0xCB, "JETTER"}, {
	0x00, 0x50, 0xCC, "XYRATEX"}, {
	0x00, 0x50, 0xCD, "DIGIANSWER A/S"}, {
	0x00, 0x50, 0xCE, "LG INTERNATIONAL CORP."}, {
	0x00, 0x50, 0xCF,
		"VANLINK COMMUNICATION TECHNOLOGY RESEARCH INSTITUTE"}, {
	0x00, 0x50, 0xD0, "MINERVA SYSTEMS"}, {
	0x00, 0x50, 0xD1, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0xD2, "BAE Systems Canada, Inc."}, {
	0x00, 0x50, 0xD3, "DIGITAL AUDIO PROCESSING PTY. LTD."}, {
	0x00, 0x50, 0xD4, "JOOHONG INFORMATION &"}, {
	0x00, 0x50, 0xD5, "AD SYSTEMS CORP."}, {
	0x00, 0x50, 0xD6, "ATLAS COPCO TOOLS AB"}, {
	0x00, 0x50, 0xD7, "TELSTRAT"}, {
	0x00, 0x50, 0xD8, "UNICORN COMPUTER CORP."}, {
	0x00, 0x50, 0xD9,
		"ENGETRON-ENGENHARIA ELETRONICA IND. e COM. LTDA"}, {
	0x00, 0x50, 0xDA, "3COM CORPORATION"}, {
	0x00, 0x50, 0xDB, "CONTEMPORARY CONTROL"}, {
	0x00, 0x50, 0xDC, "TAS TELEFONBAU A. SCHWABE GMBH & CO. KG"}, {
	0x00, 0x50, 0xDD, "SERRA SOLDADURA, S.A."}, {
	0x00, 0x50, 0xDE, "SIGNUM SYSTEMS CORP."}, {
	0x00, 0x50, 0xDF, "AirFiber, Inc."}, {
	0x00, 0x50, 0xE1, "NS TECH ELECTRONICS SDN BHD"}, {
	0x00, 0x50, 0xE2, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0xE3, "TELEGATE"}, {
	0x00, 0x50, 0xE4, "APPLE COMPUTER, INC."}, {
	0x00, 0x50, 0xE6, "HAKUSAN CORPORATION"}, {
	0x00, 0x50, 0xE7, "PARADISE INNOVATIONS (ASIA)"}, {
	0x00, 0x50, 0xE8, "NOMADIX INC."}, {
	0x00, 0x50, 0xEA, "XEL COMMUNICATIONS, INC."}, {
	0x00, 0x50, 0xEB, "ALPHA-TOP CORPORATION"}, {
	0x00, 0x50, 0xEC, "OLICOM A/S"}, {
	0x00, 0x50, 0xED, "ANDA NETWORKS"}, {
	0x00, 0x50, 0xEE, "TEK DIGITEL CORPORATION"}, {
	0x00, 0x50, 0xEF, "SPE Systemhaus GmbH"}, {
	0x00, 0x50, 0xF0, "CISCO SYSTEMS, INC."}, {
	0x00, 0x50, 0xF1, "LIBIT SIGNAL PROCESSING, LTD."}, {
	0x00, 0x50, 0xF2, "MICROSOFT CORP."}, {
	0x00, 0x50, 0xF3, "GLOBAL NET INFORMATION CO., Ltd."}, {
	0x00, 0x50, 0xF4, "SIGMATEK GMBH & CO. KG"}, {
	0x00, 0x50, 0xF6, "PAN-INTERNATIONAL INDUSTRIAL CORP."}, {
	0x00, 0x50, 0xF7, "VENTURE MANUFACTURING (SINGAPORE) LTD."}, {
	0x00, 0x50, 0xF8, "ENTREGA TECHNOLOGIES, INC."}, {
	0x00, 0x50, 0xFA, "OXTEL, LTD."}, {
	0x00, 0x50, 0xFB, "VSK ELECTRONICS"}, {
	0x00, 0x50, 0xFC, "EDIMAX TECHNOLOGY CO., LTD."}, {
	0x00, 0x50, 0xFD, "VISIONCOMM CO., LTD."}, {
	0x00, 0x50, 0xFE, "PCTVnet ASA"}, {
	0x00, 0x50, 0xFF, "HAKKO ELECTRONICS CO., LTD."}, {
	0x00, 0x60, 0x00, "XYCOM INC."}, {
	0x00, 0x60, 0x01, "InnoSys, Inc."}, {
	0x00, 0x60, 0x02, "SCREEN SUBTITLING SYSTEMS, LTD"}, {
	0x00, 0x60, 0x03, "TERAOKA WEIGH SYSTEM PTE, LTD."}, {
	0x00, 0x60, 0x04, "COMPUTADORES MODULARES SA"}, {
	0x00, 0x60, 0x05, "FEEDBACK DATA LTD."}, {
	0x00, 0x60, 0x06, "SOTEC CO., LTD"}, {
	0x00, 0x60, 0x07, "ACRES GAMING, INC."}, {
	0x00, 0x60, 0x08, "3COM CORPORATION"}, {
	0x00, 0x60, 0x09, "CISCO SYSTEMS, INC."}, {
	0x00, 0x60, 0x0A, "SORD COMPUTER CORPORATION"}, {
	0x00, 0x60, 0x0B, "LOGWARE GmbH"}, {
	0x00, 0x60, 0x0C, "APPLIED DATA SYSTEMS, INC."}, {
	0x00, 0x60, 0x0D, "Digital Logic GmbH"}, {
	0x00, 0x60, 0x0E, "WAVENET INTERNATIONAL, INC."}, {
	0x00, 0x60, 0x0F, "WESTELL, INC."}, {
	0x00, 0x60, 0x10, "NETWORK MACHINES, INC."}, {
	0x00, 0x60, 0x11, "CRYSTAL SEMICONDUCTOR CORP."}, {
	0x00, 0x60, 0x12, "POWER COMPUTING CORPORATION"}, {
	0x00, 0x60, 0x13, "NETSTAL MASCHINEN AG"}, {
	0x00, 0x60, 0x14, "EDEC CO., LTD."}, {
	0x00, 0x60, 0x15, "NET2NET CORPORATION"}, {
	0x00, 0x60, 0x16, "CLARIION"}, {
	0x00, 0x60, 0x17, "TOKIMEC INC."}, {
	0x00, 0x60, 0x18, "STELLAR ONE CORPORATION"}, {
	0x00, 0x60, 0x19, "BOEHRINGER MANNHEIM CORP."}, {
	0x00, 0x60, 0x1A, "KEITHLEY INSTRUMENTS"}, {
	0x00, 0x60, 0x1B, "MESA ELECTRONICS"}, {
	0x00, 0x60, 0x1C, "TELXON CORPORATION"}, {
	0x00, 0x60, 0x1D, "LUCENT TECHNOLOGIES"}, {
	0x00, 0x60, 0x1E, "SOFTLAB, INC."}, {
	0x00, 0x60, 0x1F, "STALLION TECHNOLOGIES"}, {
	0x00, 0x60, 0x20, "PIVOTAL NETWORKING, INC."}, {
	0x00, 0x60, 0x21, "DSC CORPORATION"}, {
	0x00, 0x60, 0x22, "VICOM SYSTEMS, INC."}, {
	0x00, 0x60, 0x23, "PERICOM SEMICONDUCTOR CORP."}, {
	0x00, 0x60, 0x24, "GRADIENT TECHNOLOGIES, INC."}, {
	0x00, 0x60, 0x25, "ACTIVE IMAGING PLC"}, {
	0x00, 0x60, 0x26, "VIKING COMPONENTS, INC."}, {
	0x00, 0x60, 0x27, "Superior Modular Products"}, {
	0x00, 0x60, 0x28, "MACROVISION CORPORATION"}, {
	0x00, 0x60, 0x29, "CARY PERIPHERALS INC."}, {
	0x00, 0x60, 0x2A, "SYMICRON COMPUTER COMMUNICATIONS, LTD."}, {
	0x00, 0x60, 0x2B, "PEAK AUDIO"}, {
	0x00, 0x60, 0x2C, "LINX Data Terminals, Inc."}, {
	0x00, 0x60, 0x2D, "ALERTON TECHNOLOGIES, INC."}, {
	0x00, 0x60, 0x2E, "CYCLADES CORPORATION"}, {
	0x00, 0x60, 0x2F, "CISCO SYSTEMS, INC."}, {
	0x00, 0x60, 0x30, "VILLAGE TRONIC ENTWICKLUNG"}, {
	0x00, 0x60, 0x31, "HRK SYSTEMS"}, {
	0x00, 0x60, 0x32, "I-CUBE, INC."}, {
	0x00, 0x60, 0x33, "ACUITY IMAGING, INC."}, {
	0x00, 0x60, 0x34, "ROBERT BOSCH GmbH"}, {
	0x00, 0x60, 0x35, "DALLAS SEMICONDUCTOR, INC."}, {
	0x00, 0x60, 0x36, "AUSTRIAN RESEARCH CENTER SEIBERSDORF"}, {
	0x00, 0x60, 0x37, "PHILIPS SEMICONDUCTORS"}, {
	0x00, 0x60, 0x38, "Nortel Networks"}, {
	0x00, 0x60, 0x39, "SanCom Technology, Inc."}, {
	0x00, 0x60, 0x3A, "QUICK CONTROLS LTD."}, {
	0x00, 0x60, 0x3B, "AMTEC spa"}, {
	0x00, 0x60, 0x3C, "HAGIWARA SYS-COM CO., LTD."}, {
	0x00, 0x60, 0x3D, "3CX"}, {
	0x00, 0x60, 0x3E, "CISCO SYSTEMS, INC."}, {
	0x00, 0x60, 0x3F, "PATAPSCO DESIGNS"}, {
	0x00, 0x60, 0x40, "NETRO CORP."}, {
	0x00, 0x60, 0x41, "Yokogawa Electric Corporation"}, {
	0x00, 0x60, 0x42, "TKS (USA), INC."}, {
	0x00, 0x60, 0x43, "ComSoft Systems, Inc."}, {
	0x00, 0x60, 0x44, "LITTON/POLY-SCIENTIFIC"}, {
	0x00, 0x60, 0x45, "PATHLIGHT TECHNOLOGIES"}, {
	0x00, 0x60, 0x46, "VMETRO, INC."}, {
	0x00, 0x60, 0x47, "CISCO SYSTEMS, INC."}, {
	0x00, 0x60, 0x48, "EMC CORPORATION"}, {
	0x00, 0x60, 0x49, "VINA TECHNOLOGIES"}, {
	0x00, 0x60, 0x4A, "SAIC IDEAS GROUP"}, {
	0x00, 0x60, 0x4B, "BIODATA GmbH"}, {
	0x00, 0x60, 0x4C, "SAT"}, {
	0x00, 0x60, 0x4D, "MMC NETWORKS, INC."}, {
	0x00, 0x60, 0x4E, "CYCLE COMPUTER CORPORATION, INC."}, {
	0x00, 0x60, 0x4F, "SUZUKI MFG. CO., LTD."}, {
	0x00, 0x60, 0x50, "INTERNIX INC."}, {
	0x00, 0x60, 0x51, "QUALITY SEMICONDUCTOR"}, {
	0x00, 0x60, 0x52, "PERIPHERALS ENTERPRISE CO., Ltd."}, {
	0x00, 0x60, 0x53, "TOYODA MACHINE WORKS, LTD."}, {
	0x00, 0x60, 0x54, "CONTROLWARE GMBH"}, {
	0x00, 0x60, 0x55, "CORNELL UNIVERSITY"}, {
	0x00, 0x60, 0x56, "NETWORK TOOLS, INC."}, {
	0x00, 0x60, 0x57, "MURATA MANUFACTURING CO., LTD."}, {
	0x00, 0x60, 0x58, "COPPER MOUNTAIN COMMUNICATIONS, INC."}, {
	0x00, 0x60, 0x59, "TECHNICAL COMMUNICATIONS CORP."}, {
	0x00, 0x60, 0x5A, "CELCORE, INC."}, {
	0x00, 0x60, 0x5B, "IntraServer Technology, Inc."}, {
	0x00, 0x60, 0x5C, "CISCO SYSTEMS, INC."}, {
	0x00, 0x60, 0x5D, "SCANIVALVE CORP."}, {
	0x00, 0x60, 0x5E, "LIBERTY TECHNOLOGY NETWORKING"}, {
	0x00, 0x60, 0x5F, "NIPPON UNISOFT CORPORATION"}, {
	0x00, 0x60, 0x60, "DAWNING TECHNOLOGIES, INC."}, {
	0x00, 0x60, 0x61, "WHISTLE COMMUNICATIONS CORP."}, {
	0x00, 0x60, 0x62, "TELESYNC, INC."}, {
	0x00, 0x60, 0x63, "PSION DACOM PLC."}, {
	0x00, 0x60, 0x64, "NETCOMM LIMITED"}, {
	0x00, 0x60, 0x65, "BERNECKER & RAINER INDUSTRIE-ELEKTRONIC GmbH"},
	{
	0x00, 0x60, 0x66, "LACROIX TECHNOLGIE"}, {
	0x00, 0x60, 0x67, "ACER NETXUS INC."}, {
	0x00, 0x60, 0x68, "EICON TECHNOLOGY CORPORATION"}, {
	0x00, 0x60, 0x69, "BROCADE COMMUNICATIONS SYSTEMS, Inc."}, {
	0x00, 0x60, 0x6A, "MITSUBISHI WIRELESS COMMUNICATIONS. INC."}, {
	0x00, 0x60, 0x6B, "AICHI ELECTRONICS CO., LTD."}, {
	0x00, 0x60, 0x6C, "ARESCOM"}, {
	0x00, 0x60, 0x6D, "DIGITAL EQUIPMENT CORP."}, {
	0x00, 0x60, 0x6E, "DAVICOM SEMICONDUCTOR, INC."}, {
	0x00, 0x60, 0x6F, "CLARION CORPORATION OF AMERICA"}, {
	0x00, 0x60, 0x70, "CISCO SYSTEMS, INC."}, {
	0x00, 0x60, 0x71, "MIDAS LAB, INC."}, {
	0x00, 0x60, 0x72, "VXL INSTRUMENTS, LIMITED"}, {
	0x00, 0x60, 0x73, "REDCREEK COMMUNICATIONS, INC."}, {
	0x00, 0x60, 0x74, "QSC AUDIO PRODUCTS"}, {
	0x00, 0x60, 0x75, "PENTEK, INC."}, {
	0x00, 0x60, 0x76,
		"SCHLUMBERGER TECHNOLOGIES RETAIL PETROLEUM SYSTEMS"}, {
	0x00, 0x60, 0x77, "PRISA NETWORKS"}, {
	0x00, 0x60, 0x78, "POWER MEASUREMENT LTD."}, {
	0x00, 0x60, 0x79, "WAVEPHORE NETWORKS, INC."}, {
	0x00, 0x60, 0x7A, "DVS GmbH"}, {
	0x00, 0x60, 0x7B, "FORE SYSTEMS, INC."}, {
	0x00, 0x60, 0x7C, "WaveAccess, Ltd."}, {
	0x00, 0x60, 0x7D, "SENTIENT NETWORKS INC."}, {
	0x00, 0x60, 0x7E, "GIGALABS, INC."}, {
	0x00, 0x60, 0x7F, "AURORA TECHNOLOGIES, INC."}, {
	0x00, 0x60, 0x80, "MICROTRONIX DATACOM LTD."}, {
	0x00, 0x60, 0x81, "TV/COM INTERNATIONAL"}, {
	0x00, 0x60, 0x82, "NOVALINK TECHNOLOGIES, INC."}, {
	0x00, 0x60, 0x83, "CISCO SYSTEMS, INC."}, {
	0x00, 0x60, 0x84, "DIGITAL VIDEO"}, {
	0x00, 0x60, 0x85, "Storage Concepts"}, {
	0x00, 0x60, 0x86, "LOGIC REPLACEMENT TECH. LTD."}, {
	0x00, 0x60, 0x87, "KANSAI ELECTRIC CO., LTD."}, {
	0x00, 0x60, 0x88, "WHITE MOUNTAIN DSP, INC."}, {
	0x00, 0x60, 0x89, "XATA"}, {
	0x00, 0x60, 0x8A, "CITADEL COMPUTER"}, {
	0x00, 0x60, 0x8B, "ConferTech International"}, {
	0x00, 0x60, 0x8C, "3COM CORPORATION"}, {
	0x00, 0x60, 0x8D, "UNIPULSE CORP."}, {
	0x00, 0x60, 0x8E,
		"HE ELECTRONICS, TECHNOLOGIE & SYSTEMTECHNIK GmbH"}, {
	0x00, 0x60, 0x8F, "TEKRAM TECHNOLOGY CO., LTD."}, {
	0x00, 0x60, 0x90, "ABLE COMMUNICATIONS, INC."}, {
	0x00, 0x60, 0x91, "FIRST PACIFIC NETWORKS, INC."}, {
	0x00, 0x60, 0x92, "MICRO/SYS, INC."}, {
	0x00, 0x60, 0x93, "VARIAN"}, {
	0x00, 0x60, 0x94, "IBM CORP."}, {
	0x00, 0x60, 0x95, "ACCU-TIME SYSTEMS, INC."}, {
	0x00, 0x60, 0x96, "T.S. MICROTECH INC."}, {
	0x00, 0x60, 0x97, "3COM CORPORATION"}, {
	0x00, 0x60, 0x98, "HT COMMUNICATIONS"}, {
	0x00, 0x60, 0x99, "LAN MEDIA CORPORATION"}, {
	0x00, 0x60, 0x9A, "NJK TECHNO CO."}, {
	0x00, 0x60, 0x9B, "ASTRO-MED, INC."}, {
	0x00, 0x60, 0x9C, "Perkin-Elmer Incorporated"}, {
	0x00, 0x60, 0x9D, "PMI FOOD EQUIPMENT GROUP"}, {
	0x00, 0x60, 0x9E,
		"ASC X3 - INFORMATION TECHNOLOGY STANDARDS SECRETARIATS"},
	{
	0x00, 0x60, 0x9F, "PHAST CORPORATION"}, {
	0x00, 0x60, 0xA0, "SWITCHED NETWORK TECHNOLOGIES, INC."}, {
	0x00, 0x60, 0xA1, "VPNet, Inc."}, {
	0x00, 0x60, 0xA2, "NIHON UNISYS LIMITED CO."}, {
	0x00, 0x60, 0xA3, "CONTINUUM TECHNOLOGY CORP."}, {
	0x00, 0x60, 0xA4, "GRINAKER SYSTEM TECHNOLOGIES"}, {
	0x00, 0x60, 0xA5, "PERFORMANCE TELECOM CORP."}, {
	0x00, 0x60, 0xA6, "PARTICLE MEASURING SYSTEMS"}, {
	0x00, 0x60, 0xA7, "MICROSENS GmbH & CO. KG"}, {
	0x00, 0x60, 0xA8, "TIDOMAT AB"}, {
	0x00, 0x60, 0xA9, "GESYTEC MbH"}, {
	0x00, 0x60, 0xAA, "INTELLIGENT DEVICES INC. (IDI)"}, {
	0x00, 0x60, 0xAB, "LARSCOM INCORPORATED"}, {
	0x00, 0x60, 0xAC, "RESILIENCE CORPORATION"}, {
	0x00, 0x60, 0xAD, "MegaChips Corporation"}, {
	0x00, 0x60, 0xAE, "TRIO INFORMATION SYSTEMS AB"}, {
	0x00, 0x60, 0xAF, "PACIFIC MICRO DATA, INC."}, {
	0x00, 0x60, 0xB0, "HEWLETT-PACKARD CO."}, {
	0x00, 0x60, 0xB1, "INPUT/OUTPUT, INC."}, {
	0x00, 0x60, 0xB2, "PROCESS CONTROL CORP."}, {
	0x00, 0x60, 0xB3, "Z-COM, INC."}, {
	0x00, 0x60, 0xB4, "GLENAYRE R&D INC."}, {
	0x00, 0x60, 0xB5, "KEBA GmbH"}, {
	0x00, 0x60, 0xB6, "LAND COMPUTER CO., LTD."}, {
	0x00, 0x60, 0xB7, "CHANNELMATIC, INC."}, {
	0x00, 0x60, 0xB8, "CORELIS INC."}, {
	0x00, 0x60, 0xB9, "NITSUKO CORPORATION"}, {
	0x00, 0x60, 0xBA, "SAHARA NETWORKS, INC."}, {
	0x00, 0x60, 0xBB, "CABLETRON - NETLINK, INC."}, {
	0x00, 0x60, 0xBC,
		"KeunYoung Electronics & Communication Co., Ltd."}, {
	0x00, 0x60, 0xBD, "HUBBELL-PULSECOM"}, {
	0x00, 0x60, 0xBE, "WEBTRONICS"}, {
	0x00, 0x60, 0xBF, "MACRAIGOR SYSTEMS, INC."}, {
	0x00, 0x60, 0xC0, "NERA AS"}, {
	0x00, 0x60, 0xC1, "WaveSpan Corporation"}, {
	0x00, 0x60, 0xC2, "MPL AG"}, {
	0x00, 0x60, 0xC3, "NETVISION CORPORATION"}, {
	0x00, 0x60, 0xC4, "SOLITON SYSTEMS K.K."}, {
	0x00, 0x60, 0xC5, "ANCOT CORP."}, {
	0x00, 0x60, 0xC6, "DCS AG"}, {
	0x00, 0x60, 0xC7, "AMATI COMMUNICATIONS CORP."}, {
	0x00, 0x60, 0xC8, "KUKA WELDING SYSTEMS & ROBOTS"}, {
	0x00, 0x60, 0xC9, "ControlNet, Inc."}, {
	0x00, 0x60, 0xCA, "HARMONIC SYSTEMS INCORPORATED"}, {
	0x00, 0x60, 0xCB, "HITACHI ZOSEN CORPORATION"}, {
	0x00, 0x60, 0xCC, "EMTRAK, INCORPORATED"}, {
	0x00, 0x60, 0xCD, "VideoServer, Inc."}, {
	0x00, 0x60, 0xCE, "ACCLAIM COMMUNICATIONS"}, {
	0x00, 0x60, 0xCF, "ALTEON NETWORKS, INC."}, {
	0x00, 0x60, 0xD0, "SNMP RESEARCH INCORPORATED"}, {
	0x00, 0x60, 0xD1, "CASCADE COMMUNICATIONS"}, {
	0x00, 0x60, 0xD2,
		"LUCENT TECHNOLOGIES TAIWAN TELECOMMUNICATIONS CO., LTD."},
	{
	0x00, 0x60, 0xD3, "AT&T"}, {
	0x00, 0x60, 0xD4, "ELDAT COMMUNICATION LTD."}, {
	0x00, 0x60, 0xD5, "MIYACHI TECHNOS CORP."}, {
	0x00, 0x60, 0xD6, "NovAtel Wireless Technologies Ltd."}, {
	0x00, 0x60, 0xD7,
		"ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE (EPFL)"}, {
	0x00, 0x60, 0xD8, "ELMIC SYSTEMS, INC."}, {
	0x00, 0x60, 0xD9, "TRANSYS NETWORKS INC."}, {
	0x00, 0x60, 0xDA, "JBM ELECTRONICS CO."}, {
	0x00, 0x60, 0xDB, "NTP ELEKTRONIK A/S"}, {
	0x00, 0x60, 0xDC, "TOYO COMMUNICATION EQUIPMENT Co., Ltd."}, {
	0x00, 0x60, 0xDD, "MYRICOM, INC."}, {
	0x00, 0x60, 0xDE, "KAYSER-THREDE GmbH"}, {
	0x00, 0x60, 0xDF, "INRANGE TECHNOLOGIES CORP."}, {
	0x00, 0x60, 0xE0, "AXIOM TECHNOLOGY CO., LTD."}, {
	0x00, 0x60, 0xE1, "ORCKIT COMMUNICATIONS LTD."}, {
	0x00, 0x60, 0xE2, "QUEST ENGINEERING & DEVELOPMENT"}, {
	0x00, 0x60, 0xE3, "ARBIN INSTRUMENTS"}, {
	0x00, 0x60, 0xE4, "COMPUSERVE, INC."}, {
	0x00, 0x60, 0xE5, "FUJI AUTOMATION CO., LTD."}, {
	0x00, 0x60, 0xE6, "SHOMITI SYSTEMS INCORPORATED"}, {
	0x00, 0x60, 0xE7, "RANDATA"}, {
	0x00, 0x60, 0xE8, "HITACHI COMPUTER PRODUCTS (AMERICA), INC."}, {
	0x00, 0x60, 0xE9, "ATOP TECHNOLOGIES, INC."}, {
	0x00, 0x60, 0xEA, "StreamLogic"}, {
	0x00, 0x60, 0xEB, "FOURTHTRACK SYSTEMS"}, {
	0x00, 0x60, 0xEC, "HERMARY OPTO ELECTRONICS INC."}, {
	0x00, 0x60, 0xED, "RICARDO TEST AUTOMATION LTD."}, {
	0x00, 0x60, 0xEE, "APOLLO"}, {
	0x00, 0x60, 0xEF, "FLYTECH TECHNOLOGY CO., LTD."}, {
	0x00, 0x60, 0xF0, "JOHNSON & JOHNSON MEDICAL, INC"}, {
	0x00, 0x60, 0xF1, "EXP COMPUTER, INC."}, {
	0x00, 0x60, 0xF2, "LASERGRAPHICS, INC."}, {
	0x00, 0x60, 0xF3, "NETCOM SYSTEMS, INC."}, {
	0x00, 0x60, 0xF4, "ADVANCED COMPUTER SOLUTIONS, Inc."}, {
	0x00, 0x60, 0xF5, "ICON WEST, INC."}, {
	0x00, 0x60, 0xF6, "NEXTEST COMMUNICATIONS PRODUCTS, INC."}, {
	0x00, 0x60, 0xF7, "DATAFUSION SYSTEMS"}, {
	0x00, 0x60, 0xF8, "Loran International Technologies Inc."}, {
	0x00, 0x60, 0xF9, "DIAMOND LANE COMMUNICATIONS"}, {
	0x00, 0x60, 0xFA, "EDUCATIONAL TECHNOLOGY RESOURCES, INC."}, {
	0x00, 0x60, 0xFB, "PACKETEER, INC."}, {
	0x00, 0x60, 0xFC, "CONSERVATION THROUGH INNOVATION LTD."}, {
	0x00, 0x60, 0xFD, "NetICs, Inc."}, {
	0x00, 0x60, 0xFE, "LYNX SYSTEM DEVELOPERS, INC."}, {
	0x00, 0x60, 0xFF, "QuVis, Inc."}, {
	0x00, 0x70, 0xB0, "M/A-COM INC. COMPANIES"}, {
	0x00, 0x70, 0xB3, "DATA RECALL LTD."}, {
	0x00, 0x80, 0x00, "MULTITECH SYSTEMS, INC."}, {
	0x00, 0x80, 0x01, "PERIPHONICS CORPORATION"}, {
	0x00, 0x80, 0x02, "SATELCOM (UK) LTD"}, {
	0x00, 0x80, 0x03, "HYTEC ELECTRONICS LTD."}, {
	0x00, 0x80, 0x04, "ANTLOW COMMUNICATIONS, LTD."}, {
	0x00, 0x80, 0x05, "CACTUS COMPUTER INC."}, {
	0x00, 0x80, 0x06, "COMPUADD CORPORATION"}, {
	0x00, 0x80, 0x07, "DLOG NC-SYSTEME"}, {
	0x00, 0x80, 0x08, "DYNATECH COMPUTER SYSTEMS"}, {
	0x00, 0x80, 0x09, "JUPITER SYSTEMS, INC."}, {
	0x00, 0x80, 0x0A, "JAPAN COMPUTER CORP."}, {
	0x00, 0x80, 0x0B, "CSK CORPORATION"}, {
	0x00, 0x80, 0x0C, "VIDECOM LIMITED"}, {
	0x00, 0x80, 0x0D, "VOSSWINKEL F.U."}, {
	0x00, 0x80, 0x0E, "ATLANTIX CORPORATION"}, {
	0x00, 0x80, 0x0F, "STANDARD MICROSYSTEMS"}, {
	0x00, 0x80, 0x10, "COMMODORE INTERNATIONAL"}, {
	0x00, 0x80, 0x11, "DIGITAL SYSTEMS INT'L. INC."}, {
	0x00, 0x80, 0x12, "INTEGRATED MEASUREMENT SYSTEMS"}, {
	0x00, 0x80, 0x13, "THOMAS-CONRAD CORPORATION"}, {
	0x00, 0x80, 0x14, "ESPRIT SYSTEMS"}, {
	0x00, 0x80, 0x15, "SEIKO SYSTEMS, INC."}, {
	0x00, 0x80, 0x16, "WANDEL AND GOLTERMANN"}, {
	0x00, 0x80, 0x17, "PFU LIMITED"}, {
	0x00, 0x80, 0x18, "KOBE STEEL, LTD."}, {
	0x00, 0x80, 0x19, "DAYNA COMMUNICATIONS, INC."}, {
	0x00, 0x80, 0x1A, "BELL ATLANTIC"}, {
	0x00, 0x80, 0x1B, "KODIAK TECHNOLOGY"}, {
	0x00, 0x80, 0x1C, "NEWPORT SYSTEMS SOLUTIONS"}, {
	0x00, 0x80, 0x1D, "INTEGRATED INFERENCE MACHINES"}, {
	0x00, 0x80, 0x1E, "XINETRON, INC."}, {
	0x00, 0x80, 0x1F, "KRUPP ATLAS ELECTRONIK GMBH"}, {
	0x00, 0x80, 0x20, "NETWORK PRODUCTS"}, {
	0x00, 0x80, 0x21, "NEWBRIDGE RESEARCH CORP."}, {
	0x00, 0x80, 0x22, "SCAN-OPTICS"}, {
	0x00, 0x80, 0x23, "INTEGRATED BUSINESS NETWORKS"}, {
	0x00, 0x80, 0x24, "KALPANA, INC."}, {
	0x00, 0x80, 0x25, "STOLLMANN GMBH"}, {
	0x00, 0x80, 0x26, "NETWORK PRODUCTS CORPORATION"}, {
	0x00, 0x80, 0x27, "ADAPTIVE SYSTEMS, INC."}, {
	0x00, 0x80, 0x28, "TRADPOST (HK) LTD"}, {
	0x00, 0x80, 0x29, "EAGLE TECHNOLOGY, INC."}, {
	0x00, 0x80, 0x2A, "TEST SYSTEMS & SIMULATIONS INC"}, {
	0x00, 0x80, 0x2B, "INTEGRATED MARKETING CO"}, {
	0x00, 0x80, 0x2C, "THE SAGE GROUP PLC"}, {
	0x00, 0x80, 0x2D, "XYLOGICS INC"}, {
	0x00, 0x80, 0x2E, "CASTLE ROCK COMPUTING"}, {
	0x00, 0x80, 0x2F, "NATIONAL INSTRUMENTS CORP."}, {
	0x00, 0x80, 0x30, "NEXUS ELECTRONICS"}, {
	0x00, 0x80, 0x31, "BASYS, CORP."}, {
	0x00, 0x80, 0x32, "ACCESS CO., LTD."}, {
	0x00, 0x80, 0x33, "FORMATION, INC."}, {
	0x00, 0x80, 0x34, "SMT GOUPIL"}, {
	0x00, 0x80, 0x35, "TECHNOLOGY WORKS, INC."}, {
	0x00, 0x80, 0x36, "REFLEX MANUFACTURING SYSTEMS"}, {
	0x00, 0x80, 0x37, "Ericsson Group"}, {
	0x00, 0x80, 0x38, "DATA RESEARCH & APPLICATIONS"}, {
	0x00, 0x80, 0x39, "ALCATEL STC AUSTRALIA"}, {
	0x00, 0x80, 0x3A, "VARITYPER, INC."}, {
	0x00, 0x80, 0x3B, "APT COMMUNICATIONS, INC."}, {
	0x00, 0x80, 0x3C, "TVS ELECTRONICS LTD"}, {
	0x00, 0x80, 0x3D, "SURIGIKEN CO.,  LTD."}, {
	0x00, 0x80, 0x3E, "SYNERNETICS"}, {
	0x00, 0x80, 0x3F, "TATUNG COMPANY"}, {
	0x00, 0x80, 0x40, "JOHN FLUKE MANUFACTURING CO."}, {
	0x00, 0x80, 0x41, "VEB KOMBINAT ROBOTRON"}, {
	0x00, 0x80, 0x42, "FORCE COMPUTERS"}, {
	0x00, 0x80, 0x43, "NETWORLD, INC."}, {
	0x00, 0x80, 0x44, "SYSTECH COMPUTER CORP."}, {
	0x00, 0x80, 0x45, "MATSUSHITA ELECTRIC IND. CO"}, {
	0x00, 0x80, 0x46, "UNIVERSITY OF TORONTO"}, {
	0x00, 0x80, 0x47, "IN-NET CORP."}, {
	0x00, 0x80, 0x48, "COMPEX INCORPORATED"}, {
	0x00, 0x80, 0x49, "NISSIN ELECTRIC CO., LTD."}, {
	0x00, 0x80, 0x4A, "PRO-LOG"}, {
	0x00, 0x80, 0x4B, "EAGLE TECHNOLOGIES PTY.LTD."}, {
	0x00, 0x80, 0x4C, "CONTEC CO., LTD."}, {
	0x00, 0x80, 0x4D, "CYCLONE MICROSYSTEMS, INC."}, {
	0x00, 0x80, 0x4E, "APEX COMPUTER COMPANY"}, {
	0x00, 0x80, 0x4F, "DAIKIN INDUSTRIES, LTD."}, {
	0x00, 0x80, 0x50, "ZIATECH CORPORATION"}, {
	0x00, 0x80, 0x51, "FIBERMUX"}, {
	0x00, 0x80, 0x52, "TECHNICALLY ELITE CONCEPTS"}, {
	0x00, 0x80, 0x53, "INTELLICOM, INC."}, {
	0x00, 0x80, 0x54, "FRONTIER TECHNOLOGIES CORP."}, {
	0x00, 0x80, 0x55, "FERMILAB"}, {
	0x00, 0x80, 0x56, "SPHINX ELEKTRONIK GMBH"}, {
	0x00, 0x80, 0x57, "ADSOFT, LTD."}, {
	0x00, 0x80, 0x58, "PRINTER SYSTEMS CORPORATION"}, {
	0x00, 0x80, 0x59, "STANLEY ELECTRIC CO., LTD"}, {
	0x00, 0x80, 0x5A, "TULIP COMPUTERS INTERNAT'L B.V"}, {
	0x00, 0x80, 0x5B, "CONDOR SYSTEMS, INC."}, {
	0x00, 0x80, 0x5C, "AGILIS CORPORATION"}, {
	0x00, 0x80, 0x5D, "CANSTAR"}, {
	0x00, 0x80, 0x5E, "LSI LOGIC CORPORATION"}, {
	0x00, 0x80, 0x5F, "COMPAQ COMPUTER CORPORATION"}, {
	0x00, 0x80, 0x60, "NETWORK INTERFACE CORPORATION"}, {
	0x00, 0x80, 0x61, "LITTON SYSTEMS, INC."}, {
	0x00, 0x80, 0x62, "INTERFACE  CO."}, {
	0x00, 0x80, 0x63, "RICHARD HIRSCHMANN GMBH & CO."}, {
	0x00, 0x80, 0x64, "WYSE TECHNOLOGY"}, {
	0x00, 0x80, 0x65, "CYBERGRAPHIC SYSTEMS PTY LTD."}, {
	0x00, 0x80, 0x66, "ARCOM CONTROL SYSTEMS, LTD."}, {
	0x00, 0x80, 0x67, "SQUARE D COMPANY"}, {
	0x00, 0x80, 0x68, "YAMATECH SCIENTIFIC LTD."}, {
	0x00, 0x80, 0x69, "COMPUTONE SYSTEMS"}, {
	0x00, 0x80, 0x6A, "ERI (EMPAC RESEARCH INC.)"}, {
	0x00, 0x80, 0x6B, "SCHMID TELECOMMUNICATION"}, {
	0x00, 0x80, 0x6C, "CEGELEC PROJECTS LTD"}, {
	0x00, 0x80, 0x6D, "CENTURY SYSTEMS CORP."}, {
	0x00, 0x80, 0x6E, "NIPPON STEEL CORPORATION"}, {
	0x00, 0x80, 0x6F, "ONELAN LTD."}, {
	0x00, 0x80, 0x70, "COMPUTADORAS MICRON"}, {
	0x00, 0x80, 0x71, "SAI TECHNOLOGY"}, {
	0x00, 0x80, 0x72, "MICROPLEX SYSTEMS LTD."}, {
	0x00, 0x80, 0x73, "DWB ASSOCIATES"}, {
	0x00, 0x80, 0x74, "FISHER CONTROLS"}, {
	0x00, 0x80, 0x75, "PARSYTEC GMBH"}, {
	0x00, 0x80, 0x76, "MCNC"}, {
	0x00, 0x80, 0x77, "BROTHER INDUSTRIES, LTD."}, {
	0x00, 0x80, 0x78, "PRACTICAL PERIPHERALS, INC."}, {
	0x00, 0x80, 0x79, "MICROBUS DESIGNS LTD."}, {
	0x00, 0x80, 0x7A, "AITECH SYSTEMS LTD."}, {
	0x00, 0x80, 0x7B, "ARTEL COMMUNICATIONS CORP."}, {
	0x00, 0x80, 0x7C, "FIBERCOM, INC."}, {
	0x00, 0x80, 0x7D, "EQUINOX SYSTEMS INC."}, {
	0x00, 0x80, 0x7E, "SOUTHERN PACIFIC LTD."}, {
	0x00, 0x80, 0x7F, "DY-4 INCORPORATED"}, {
	0x00, 0x80, 0x80, "DATAMEDIA CORPORATION"}, {
	0x00, 0x80, 0x81, "KENDALL SQUARE RESEARCH CORP."}, {
	0x00, 0x80, 0x82, "PEP MODULAR COMPUTERS GMBH"}, {
	0x00, 0x80, 0x83, "AMDAHL"}, {
	0x00, 0x80, 0x84, "THE CLOUD INC."}, {
	0x00, 0x80, 0x85, "H-THREE SYSTEMS CORPORATION"}, {
	0x00, 0x80, 0x86, "COMPUTER GENERATION INC."}, {
	0x00, 0x80, 0x87, "OKI ELECTRIC INDUSTRY CO., LTD"}, {
	0x00, 0x80, 0x88, "VICTOR COMPANY OF JAPAN, LTD."}, {
	0x00, 0x80, 0x89, "TECNETICS (PTY) LTD."}, {
	0x00, 0x80, 0x8A, "SUMMIT MICROSYSTEMS CORP."}, {
	0x00, 0x80, 0x8B, "DACOLL LIMITED"}, {
	0x00, 0x80, 0x8C, "NetScout Systems, Inc."}, {
	0x00, 0x80, 0x8D, "WESTCOAST TECHNOLOGY B.V."}, {
	0x00, 0x80, 0x8E, "RADSTONE TECHNOLOGY"}, {
	0x00, 0x80, 0x8F, "C. ITOH ELECTRONICS, INC."}, {
	0x00, 0x80, 0x90, "MICROTEK INTERNATIONAL, INC."}, {
	0x00, 0x80, 0x91, "TOKYO ELECTRIC CO.,LTD"}, {
	0x00, 0x80, 0x92, "JAPAN COMPUTER INDUSTRY, INC."}, {
	0x00, 0x80, 0x93, "XYRON CORPORATION"}, {
	0x00, 0x80, 0x94, "ALFA LAVAL AUTOMATION AB"}, {
	0x00, 0x80, 0x95, "BASIC MERTON HANDELSGES.M.B.H."}, {
	0x00, 0x80, 0x96, "HUMAN DESIGNED SYSTEMS, INC."}, {
	0x00, 0x80, 0x97, "CENTRALP AUTOMATISMES"}, {
	0x00, 0x80, 0x98, "TDK CORPORATION"}, {
	0x00, 0x80, 0x99, "KLOCKNER MOELLER IPC"}, {
	0x00, 0x80, 0x9A, "NOVUS NETWORKS LTD"}, {
	0x00, 0x80, 0x9B, "JUSTSYSTEM CORPORATION"}, {
	0x00, 0x80, 0x9C, "LUXCOM, INC."}, {
	0x00, 0x80, 0x9D, "Commscraft Ltd."}, {
	0x00, 0x80, 0x9E, "DATUS GMBH"}, {
	0x00, 0x80, 0x9F, "ALCATEL BUSINESS SYSTEMS"}, {
	0x00, 0x80, 0xA0, "EDISA HEWLETT PACKARD S/A"}, {
	0x00, 0x80, 0xA1, "MICROTEST, INC."}, {
	0x00, 0x80, 0xA2, "CREATIVE ELECTRONIC SYSTEMS"}, {
	0x00, 0x80, 0xA3, "LANTRONIX"}, {
	0x00, 0x80, 0xA4, "LIBERTY ELECTRONICS"}, {
	0x00, 0x80, 0xA5, "SPEED INTERNATIONAL"}, {
	0x00, 0x80, 0xA6, "REPUBLIC TECHNOLOGY, INC."}, {
	0x00, 0x80, 0xA7, "MEASUREX CORP."}, {
	0x00, 0x80, 0xA8, "VITACOM CORPORATION"}, {
	0x00, 0x80, 0xA9, "CLEARPOINT RESEARCH"}, {
	0x00, 0x80, 0xAA, "MAXPEED"}, {
	0x00, 0x80, 0xAB, "DUKANE NETWORK INTEGRATION"}, {
	0x00, 0x80, 0xAC, "IMLOGIX, DIVISION OF GENESYS"}, {
	0x00, 0x80, 0xAD, "CNET TECHNOLOGY, INC."}, {
	0x00, 0x80, 0xAE, "HUGHES NETWORK SYSTEMS"}, {
	0x00, 0x80, 0xAF, "ALLUMER CO., LTD."}, {
	0x00, 0x80, 0xB0, "ADVANCED INFORMATION"}, {
	0x00, 0x80, 0xB1, "SOFTCOM A/S"}, {
	0x00, 0x80, 0xB2, "NETWORK EQUIPMENT TECHNOLOGIES"}, {
	0x00, 0x80, 0xB3, "AVAL DATA CORPORATION"}, {
	0x00, 0x80, 0xB4, "SOPHIA SYSTEMS"}, {
	0x00, 0x80, 0xB5, "UNITED NETWORKS INC."}, {
	0x00, 0x80, 0xB6, "THEMIS COMPUTER"}, {
	0x00, 0x80, 0xB7, "STELLAR COMPUTER"}, {
	0x00, 0x80, 0xB8, "BUG, INCORPORATED"}, {
	0x00, 0x80, 0xB9, "ARCHE TECHNOLIGIES INC."}, {
	0x00, 0x80, 0xBA, "SPECIALIX (ASIA) PTE, LTD"}, {
	0x00, 0x80, 0xBB, "HUGHES LAN SYSTEMS"}, {
	0x00, 0x80, 0xBC, "HITACHI ENGINEERING CO., LTD"}, {
	0x00, 0x80, 0xBD, "THE FURUKAWA ELECTRIC CO., LTD"}, {
	0x00, 0x80, 0xBE, "ARIES RESEARCH"}, {
	0x00, 0x80, 0xBF, "TAKAOKA ELECTRIC MFG. CO. LTD."}, {
	0x00, 0x80, 0xC0, "PENRIL DATACOMM"}, {
	0x00, 0x80, 0xC1, "LANEX CORPORATION"}, {
	0x00, 0x80, 0xC2, "IEEE 802 COMMITTEE"}, {
	0x00, 0x80, 0xC3, "BICC INFORMATION SYSTEMS & SVC"}, {
	0x00, 0x80, 0xC4, "DOCUMENT TECHNOLOGIES, INC."}, {
	0x00, 0x80, 0xC5, "NOVELLCO DE MEXICO"}, {
	0x00, 0x80, 0xC6, "NATIONAL DATACOMM CORPORATION"}, {
	0x00, 0x80, 0xC7, "XIRCOM"}, {
	0x00, 0x80, 0xC8, "D-LINK SYSTEMS, INC."}, {
	0x00, 0x80, 0xC9, "ALBERTA MICROELECTRONIC CENTRE"}, {
	0x00, 0x80, 0xCA, "NETCOM RESEARCH INCORPORATED"}, {
	0x00, 0x80, 0xCB, "FALCO DATA PRODUCTS"}, {
	0x00, 0x80, 0xCC, "MICROWAVE BYPASS SYSTEMS"}, {
	0x00, 0x80, 0xCD, "MICRONICS COMPUTER, INC."}, {
	0x00, 0x80, 0xCE, "BROADCAST TELEVISION SYSTEMS"}, {
	0x00, 0x80, 0xCF, "EMBEDDED PERFORMANCE INC."}, {
	0x00, 0x80, 0xD0, "COMPUTER PERIPHERALS, INC."}, {
	0x00, 0x80, 0xD1, "KIMTRON CORPORATION"}, {
	0x00, 0x80, 0xD2, "SHINNIHONDENKO CO., LTD."}, {
	0x00, 0x80, 0xD3, "SHIVA CORP."}, {
	0x00, 0x80, 0xD4, "CHASE RESEARCH LTD."}, {
	0x00, 0x80, 0xD5, "CADRE TECHNOLOGIES"}, {
	0x00, 0x80, 0xD6, "NUVOTECH, INC."}, {
	0x00, 0x80, 0xD7, "Fantum Engineering"}, {
	0x00, 0x80, 0xD8, "NETWORK PERIPHERALS INC."}, {
	0x00, 0x80, 0xD9, "EMK ELEKTRONIK"}, {
	0x00, 0x80, 0xDA, "BRUEL & KJAER"}, {
	0x00, 0x80, 0xDB, "GRAPHON CORPORATION"}, {
	0x00, 0x80, 0xDC, "PICKER INTERNATIONAL"}, {
	0x00, 0x80, 0xDD, "GMX INC/GIMIX"}, {
	0x00, 0x80, 0xDE, "GIPSI S.A."}, {
	0x00, 0x80, 0xDF, "ADC CODENOLL TECHNOLOGY CORP."}, {
	0x00, 0x80, 0xE0, "XTP SYSTEMS, INC."}, {
	0x00, 0x80, 0xE1, "STMICROELECTRONICS"}, {
	0x00, 0x80, 0xE2, "T.D.I. CO., LTD."}, {
	0x00, 0x80, 0xE3, "CORAL NETWORK CORPORATION"}, {
	0x00, 0x80, 0xE4, "NORTHWEST DIGITAL SYSTEMS, INC"}, {
	0x00, 0x80, 0xE5, "MYLEX CORPORATION"}, {
	0x00, 0x80, 0xE6, "PEER NETWORKS, INC."}, {
	0x00, 0x80, 0xE7, "LYNWOOD SCIENTIFIC DEV. LTD."}, {
	0x00, 0x80, 0xE8, "CUMULUS CORPORATIION"}, {
	0x00, 0x80, 0xE9, "MADGE NETWORKS"}, {
	0x00, 0x80, 0xEA, "ADVA Optical Networking Ltd."}, {
	0x00, 0x80, 0xEB, "COMPCONTROL B.V."}, {
	0x00, 0x80, 0xEC, "SUPERCOMPUTING SOLUTIONS, INC."}, {
	0x00, 0x80, 0xED, "IQ TECHNOLOGIES, INC."}, {
	0x00, 0x80, 0xEE, "THOMSON CSF"}, {
	0x00, 0x80, 0xEF, "RATIONAL"}, {
	0x00, 0x80, 0xF0, "KYUSHU MATSUSHITA ELECTRIC CO."}, {
	0x00, 0x80, 0xF1, "OPUS SYSTEMS"}, {
	0x00, 0x80, 0xF2, "RAYCOM SYSTEMS INC"}, {
	0x00, 0x80, 0xF3, "SUN ELECTRONICS CORP."}, {
	0x00, 0x80, 0xF4, "TELEMECANIQUE ELECTRIQUE"}, {
	0x00, 0x80, 0xF5, "QUANTEL LTD"}, {
	0x00, 0x80, 0xF6, "SYNERGY MICROSYSTEMS"}, {
	0x00, 0x80, 0xF7, "ZENITH ELECTRONICS"}, {
	0x00, 0x80, 0xF8, "MIZAR, INC."}, {
	0x00, 0x80, 0xF9, "HEURIKON CORPORATION"}, {
	0x00, 0x80, 0xFA, "RWT GMBH"}, {
	0x00, 0x80, 0xFB, "BVM LIMITED"}, {
	0x00, 0x80, 0xFC, "AVATAR CORPORATION"}, {
	0x00, 0x80, 0xFD, "EXSCEED CORPRATION"}, {
	0x00, 0x80, 0xFE, "AZURE TECHNOLOGIES, INC."}, {
	0x00, 0x80, 0xFF, "SOC. DE TELEINFORMATIQUE RTC"}, {
	0x00, 0x90, 0x00, "DIAMOND MULTIMEDIA"}, {
	0x00, 0x90, 0x01, "NISHIMU ELECTRONICS INDUSTRIES CO., LTD."}, {
	0x00, 0x90, 0x02, "ALLGON AB"}, {
	0x00, 0x90, 0x03, "APLIO"}, {
	0x00, 0x90, 0x04, "3COM EUROPE LTD."}, {
	0x00, 0x90, 0x05, "PROTECH SYSTEMS CO., LTD."}, {
	0x00, 0x90, 0x06, "HAMAMATSU PHOTONICS K.K."}, {
	0x00, 0x90, 0x07, "DOMEX TECHNOLOGY CORP."}, {
	0x00, 0x90, 0x08, "HanA Systems Inc."}, {
	0x00, 0x90, 0x09, "i Controls, Inc."}, {
	0x00, 0x90, 0x0A, "PROTON ELECTRONIC INDUSTRIAL CO., LTD."}, {
	0x00, 0x90, 0x0B, "LANNER ELECTRONICS, INC."}, {
	0x00, 0x90, 0x0C, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x0D, "OVERLAND DATA INC."}, {
	0x00, 0x90, 0x0E, "HANDLINK TECHNOLOGIES, INC."}, {
	0x00, 0x90, 0x0F, "KAWASAKI HEAVY INDUSTRIES, LTD"}, {
	0x00, 0x90, 0x10, "SIMULATION LABORATORIES, INC."}, {
	0x00, 0x90, 0x11, "WAVTrace, Inc."}, {
	0x00, 0x90, 0x12, "GLOBESPAN SEMICONDUCTOR, INC."}, {
	0x00, 0x90, 0x13, "SAMSAN CORP."}, {
	0x00, 0x90, 0x14, "ROTORK INSTRUMENTS, LTD."}, {
	0x00, 0x90, 0x15, "CENTIGRAM COMMUNICATIONS CORP."}, {
	0x00, 0x90, 0x16, "ZAC"}, {
	0x00, 0x90, 0x17, "ZYPCOM, INC."}, {
	0x00, 0x90, 0x18, "ITO ELECTRIC INDUSTRY CO, LTD."}, {
	0x00, 0x90, 0x19, "HERMES ELECTRONICS CO., LTD."}, {
	0x00, 0x90, 0x1A, "UNISPHERE SOLUTIONS"}, {
	0x00, 0x90, 0x1B, "DIGITAL CONTROLS"}, {
	0x00, 0x90, 0x1C, "mps Software Gmbh"}, {
	0x00, 0x90, 0x1D, "PEC (NZ) LTD."}, {
	0x00, 0x90, 0x1E, "SELESTA INGEGNE RIA S.P.A."}, {
	0x00, 0x90, 0x1F, "ADTEC PRODUCTIONS, INC."}, {
	0x00, 0x90, 0x20, "PHILIPS ANALYTICAL X-RAY B.V."}, {
	0x00, 0x90, 0x21, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x22, "IVEX"}, {
	0x00, 0x90, 0x23, "ZILOG INC."}, {
	0x00, 0x90, 0x24, "PIPELINKS, INC."}, {
	0x00, 0x90, 0x25, "VISION SYSTEMS LTD. PTY"}, {
	0x00, 0x90, 0x26, "ADVANCED SWITCHING COMMUNICATIONS, INC."}, {
	0x00, 0x90, 0x27, "INTEL CORPORATION"}, {
	0x00, 0x90, 0x28, "NIPPON SIGNAL CO., LTD."}, {
	0x00, 0x90, 0x29, "CRYPTO AG"}, {
	0x00, 0x90, 0x2A, "COMMUNICATION DEVICES, INC."}, {
	0x00, 0x90, 0x2B, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x2C, "DATA & CONTROL EQUIPMENT LTD."}, {
	0x00, 0x90, 0x2D, "DATA ELECTRONICS (AUST.) PTY, LTD."}, {
	0x00, 0x90, 0x2E, "NAMCO LIMITED"}, {
	0x00, 0x90, 0x2F, "NETCORE SYSTEMS, INC."}, {
	0x00, 0x90, 0x30, "HONEYWELL-DATING"}, {
	0x00, 0x90, 0x31, "MYSTICOM, LTD."}, {
	0x00, 0x90, 0x32, "PELCOMBE GROUP LTD."}, {
	0x00, 0x90, 0x33, "INNOVAPHONE GmbH"}, {
	0x00, 0x90, 0x34, "IMAGIC, INC."}, {
	0x00, 0x90, 0x35, "ALPHA TELECOM, INC."}, {
	0x00, 0x90, 0x36, "ens, inc."}, {
	0x00, 0x90, 0x37, "ACUCOMM, INC."}, {
	0x00, 0x90, 0x38, "FOUNTAIN TECHNOLOGIES, INC."}, {
	0x00, 0x90, 0x39, "SHASTA NETWORKS"}, {
	0x00, 0x90, 0x3A, "NIHON MEDIA TOOL INC."}, {
	0x00, 0x90, 0x3B, "TriEMS Research Lab, Inc."}, {
	0x00, 0x90, 0x3C, "ATLANTIC NETWORK SYSTEMS"}, {
	0x00, 0x90, 0x3D, "BIOPAC SYSTEMS, INC."}, {
	0x00, 0x90, 0x3E, "N.V. PHILIPS INDUSTRIAL ACTIVITIES"}, {
	0x00, 0x90, 0x3F, "AZTEC RADIOMEDIA"}, {
	0x00, 0x90, 0x40, "CASTLE NETWORKS, INC."}, {
	0x00, 0x90, 0x41, "APPLIED DIGITAL ACCESS"}, {
	0x00, 0x90, 0x42, "ECCS, Inc."}, {
	0x00, 0x90, 0x43, "NICHIBEI DENSHI CO., LTD."}, {
	0x00, 0x90, 0x44, "ASSURED DIGITAL, INC."}, {
	0x00, 0x90, 0x45, "Marconi Communications"}, {
	0x00, 0x90, 0x46, "DEXDYNE, LTD."}, {
	0x00, 0x90, 0x47, "GIGA FAST E. LTD."}, {
	0x00, 0x90, 0x48, "ZEAL CORPORATION"}, {
	0x00, 0x90, 0x49, "ENTRIDIA CORPORATION"}, {
	0x00, 0x90, 0x4A, "CONCUR SYSTEM TECHNOLOGIES"}, {
	0x00, 0x90, 0x4B, "GemTek Technology Co., Ltd."}, {
	0x00, 0x90, 0x4C, "EPIGRAM, INC."}, {
	0x00, 0x90, 0x4D, "SPEC S.A."}, {
	0x00, 0x90, 0x4E, "DELEM BV"}, {
	0x00, 0x90, 0x4F, "ABB POWER T&D COMPANY, INC."}, {
	0x00, 0x90, 0x50, "TELESTE OY"}, {
	0x00, 0x90, 0x51, "ULTIMATE TECHNOLOGY CORP."}, {
	0x00, 0x90, 0x52, "SELCOM ELETTRONICA S.R.L."}, {
	0x00, 0x90, 0x53, "DAEWOO ELECTRONICS CO., LTD."}, {
	0x00, 0x90, 0x54, "INNOVATIVE SEMICONDUCTORS, INC"}, {
	0x00, 0x90, 0x55,
		"PARKER HANNIFIN CORPORATION COMPUMOTOR DIVISION"}, {
	0x00, 0x90, 0x56, "TELESTREAM, INC."}, {
	0x00, 0x90, 0x57, "AANetcom, Inc."}, {
	0x00, 0x90, 0x58,
		"Ultra Electronics Ltd., Command and Control Systems"}, {
	0x00, 0x90, 0x59, "TELECOM DEVICE K.K."}, {
	0x00, 0x90, 0x5A, "DEARBORN GROUP, INC."}, {
	0x00, 0x90, 0x5B, "RAYMOND AND LAE ENGINEERING"}, {
	0x00, 0x90, 0x5C, "EDMI"}, {
	0x00, 0x90, 0x5D, "NETCOM SICHERHEITSTECHNIK GmbH"}, {
	0x00, 0x90, 0x5E, "RAULAND-BORG CORPORATION"}, {
	0x00, 0x90, 0x5F, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x60, "SYSTEM CREATE CORP."}, {
	0x00, 0x90, 0x61, "PACIFIC RESEARCH & ENGINEERING CORPORATION"}, {
	0x00, 0x90, 0x62, "ICP VORTEX COMPUTERSYSTEME GmbH"}, {
	0x00, 0x90, 0x63, "COHERENT COMMUNICATIONS SYSTEMS CORPORATION"}, {
	0x00, 0x90, 0x64, "THOMSON BROADCAST SYSTEMS"}, {
	0x00, 0x90, 0x65, "FINISAR CORPORATION"}, {
	0x00, 0x90, 0x66, "Troika Networks, Inc."}, {
	0x00, 0x90, 0x67, "WalkAbout Computers, Inc."}, {
	0x00, 0x90, 0x68, "DVT CORP."}, {
	0x00, 0x90, 0x69, "JUNIPER NETWORKS, INC."}, {
	0x00, 0x90, 0x6A, "TURNSTONE SYSTEMS, INC."}, {
	0x00, 0x90, 0x6B, "APPLIED RESOURCES, INC."}, {
	0x00, 0x90, 0x6C, "GWT GLOBAL WEIGHING TECHNOLOGIES GmbH"}, {
	0x00, 0x90, 0x6D, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x6E, "PRAXON, INC."}, {
	0x00, 0x90, 0x6F, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x70, "NEO NETWORKS, INC."}, {
	0x00, 0x90, 0x71, "BADGER TECHNOLOGY, INC."}, {
	0x00, 0x90, 0x72, "SIMRAD AS"}, {
	0x00, 0x90, 0x73, "GAIO TECHNOLOGY"}, {
	0x00, 0x90, 0x74, "ARGON NETWORKS, INC."}, {
	0x00, 0x90, 0x75, "NEC DO BRASIL S.A."}, {
	0x00, 0x90, 0x76, "FMT AIRCRAFT GATE SUPPORT SYSTEMS AB"}, {
	0x00, 0x90, 0x77, "ADVANCED FIBRE COMMUNICATIONS"}, {
	0x00, 0x90, 0x78, "MER TELEMANAGEMENT SOLUTIONS, LTD."}, {
	0x00, 0x90, 0x79, "ClearOne, Inc."}, {
	0x00, 0x90, 0x7A, "SPECTRALINK CORP."}, {
	0x00, 0x90, 0x7B, "E-TECH, INC."}, {
	0x00, 0x90, 0x7C, "DIGITALCAST, INC."}, {
	0x00, 0x90, 0x7D, "Lake Communications"}, {
	0x00, 0x90, 0x7E, "VETRONIX CORP."}, {
	0x00, 0x90, 0x7F, "WatchGuard Technologies, Inc."}, {
	0x00, 0x90, 0x80, "NOT LIMITED, INC."}, {
	0x00, 0x90, 0x81, "ALOHA NETWORKS, INC."}, {
	0x00, 0x90, 0x82, "FORCE INSTITUTE"}, {
	0x00, 0x90, 0x83, "TURBO COMMUNICATION, INC."}, {
	0x00, 0x90, 0x84, "ATECH SYSTEM"}, {
	0x00, 0x90, 0x85, "GOLDEN ENTERPRISES, INC."}, {
	0x00, 0x90, 0x86, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x87, "ITIS"}, {
	0x00, 0x90, 0x88, "BAXALL SECURITY LTD."}, {
	0x00, 0x90, 0x89, "SOFTCOM MICROSYSTEMS, INC."}, {
	0x00, 0x90, 0x8A, "BAYLY COMMUNICATIONS, INC."}, {
	0x00, 0x90, 0x8B, "CELL COMPUTING, INC."}, {
	0x00, 0x90, 0x8C, "ETREND ELECTRONICS, INC."}, {
	0x00, 0x90, 0x8D, "VICKERS ELECTRONICS SYSTEMS"}, {
	0x00, 0x90, 0x8E, "Nortel Networks Broadband Access"}, {
	0x00, 0x90, 0x8F, "AUDIO CODES LTD."}, {
	0x00, 0x90, 0x90, "I-BUS"}, {
	0x00, 0x90, 0x91, "DigitalScape, Inc."}, {
	0x00, 0x90, 0x92, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0x93, "NANAO CORPORATION"}, {
	0x00, 0x90, 0x94, "OSPREY TECHNOLOGIES, INC."}, {
	0x00, 0x90, 0x95, "UNIVERSAL AVIONICS"}, {
	0x00, 0x90, 0x96, "ASKEY COMPUTER CORP."}, {
	0x00, 0x90, 0x97, "SYCAMORE NETWORKS"}, {
	0x00, 0x90, 0x98, "SBC DESIGNS, INC."}, {
	0x00, 0x90, 0x99, "ALLIED TELESIS, K.K."}, {
	0x00, 0x90, 0x9A, "ONE WORLD SYSTEMS, INC."}, {
	0x00, 0x90, 0x9B, "MARKPOINT AB"}, {
	0x00, 0x90, 0x9C, "COMBOX, LTD."}, {
	0x00, 0x90, 0x9D, "GSE SYSTEMS, INC."}, {
	0x00, 0x90, 0x9E, "Broadband Storage, Inc."}, {
	0x00, 0x90, 0x9F, "DIGI-DATA CORPORATION"}, {
	0x00, 0x90, 0xA0, "8X8 INC."}, {
	0x00, 0x90, 0xA1, "FLYING PIG SYSTEMS, LTD."}, {
	0x00, 0x90, 0xA2, "CYBERTAN TECHNOLOGY, INC."}, {
	0x00, 0x90, 0xA3, "Corecess Inc."}, {
	0x00, 0x90, 0xA4, "ALTIGA NETWORKS"}, {
	0x00, 0x90, 0xA5, "SPECTRA LOGIC"}, {
	0x00, 0x90, 0xA6, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0xA7, "CLIENTEC CORPORATION"}, {
	0x00, 0x90, 0xA8, "NineTiles Networks, Ltd."}, {
	0x00, 0x90, 0xA9, "WESTERN DIGITAL"}, {
	0x00, 0x90, 0xAA, "INDIGO ACTIVE VISION SYSTEMS LIMITED"}, {
	0x00, 0x90, 0xAB, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0xAC, "OPTIVISION, INC."}, {
	0x00, 0x90, 0xAD, "ASPECT ELECTRONICS, INC."}, {
	0x00, 0x90, 0xAE, "ITALTEL S.p.A."}, {
	0x00, 0x90, 0xAF, "J. MORITA MFG. CORP."}, {
	0x00, 0x90, 0xB0, "VADEM"}, {
	0x00, 0x90, 0xB1, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0xB2, "AVICI SYSTEMS INC."}, {
	0x00, 0x90, 0xB3, "AGRANAT SYSTEMS"}, {
	0x00, 0x90, 0xB4, "WILLOWBROOK TECHNOLOGIES"}, {
	0x00, 0x90, 0xB5, "NIKON CORPORATION"}, {
	0x00, 0x90, 0xB6, "FIBEX SYSTEMS"}, {
	0x00, 0x90, 0xB7, "DIGITAL LIGHTWAVE, INC."}, {
	0x00, 0x90, 0xB8, "ROHDE & SCHWARZ GMBH & CO. KG"}, {
	0x00, 0x90, 0xB9, "BERAN INSTRUMENTS LTD."}, {
	0x00, 0x90, 0xBA, "VALID NETWORKS, INC."}, {
	0x00, 0x90, 0xBB, "TAINET COMMUNICATION SYSTEM Corp."}, {
	0x00, 0x90, 0xBC, "TELEMANN CO., LTD."}, {
	0x00, 0x90, 0xBD, "OMNIA COMMUNICATIONS, INC."}, {
	0x00, 0x90, 0xBE, "IBC/INTEGRATED BUSINESS COMPUTERS"}, {
	0x00, 0x90, 0xBF, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0xC0, "K.J. LAW ENGINEERS, INC."}, {
	0x00, 0x90, 0xC1, "Peco II, Inc."}, {
	0x00, 0x90, 0xC2, "JK microsystems, Inc."}, {
	0x00, 0x90, 0xC3, "TOPIC SEMICONDUCTOR CORP."}, {
	0x00, 0x90, 0xC4, "JAVELIN SYSTEMS, INC."}, {
	0x00, 0x90, 0xC5, "INTERNET MAGIC, INC."}, {
	0x00, 0x90, 0xC6, "OPTIM SYSTEMS, INC."}, {
	0x00, 0x90, 0xC7, "ICOM INC."}, {
	0x00, 0x90, 0xC8, "WAVERIDER COMMUNICATIONS (CANADA) INC."}, {
	0x00, 0x90, 0xC9, "PRODUCTIVITY ENHANCEMENT PRODUCTS., INC."}, {
	0x00, 0x90, 0xCA, "ACCORD VIDEO TELECOMMUNICATIONS, LTD."}, {
	0x00, 0x90, 0xCB, "Wireless OnLine, Inc."}, {
	0x00, 0x90, 0xCC, "PLANET COMMUNICATIONS, INC."}, {
	0x00, 0x90, 0xCD,
		"ENT-EMPRESA NACIONAL DE TELECOMMUNICACOES, S.A."}, {
	0x00, 0x90, 0xCE, "TETRA GmbH"}, {
	0x00, 0x90, 0xCF, "NORTEL"}, {
	0x00, 0x90, 0xD0, "ALCATEL BELL"}, {
	0x00, 0x90, 0xD1, "LEICHU ENTERPRISE CO., LTD."}, {
	0x00, 0x90, 0xD2, "ARTEL VIDEO SYSTEMS"}, {
	0x00, 0x90, 0xD3, "GIESECKE & DEVRIENT GmbH"}, {
	0x00, 0x90, 0xD4, "BindView Development Corp."}, {
	0x00, 0x90, 0xD5, "EUPHONIX, INC."}, {
	0x00, 0x90, 0xD6, "CRYSTAL GROUP"}, {
	0x00, 0x90, 0xD7, "NetBoost Corp."}, {
	0x00, 0x90, 0xD8, "WHITECROSS SYSTEMS"}, {
	0x00, 0x90, 0xD9, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0xDA, "DYNARC, INC."}, {
	0x00, 0x90, 0xDB, "NEXT LEVEL COMMUNICATIONS"}, {
	0x00, 0x90, 0xDC, "TECO INFORMATION SYSTEMS"}, {
	0x00, 0x90, 0xDD, "THE MIHARU COMMUNICATIONS CO., LTD."}, {
	0x00, 0x90, 0xDE, "CARDKEY SYSTEMS, INC."}, {
	0x00, 0x90, 0xDF, "MITSUBISHI CHEMICAL AMERICA, INC."}, {
	0x00, 0x90, 0xE0, "SYSTRAN CORP."}, {
	0x00, 0x90, 0xE1, "TELENA S.P.A."}, {
	0x00, 0x90, 0xE2, "DISTRIBUTED PROCESSING TECHNOLOGY"}, {
	0x00, 0x90, 0xE3, "AVEX ELECTRONICS INC."}, {
	0x00, 0x90, 0xE4, "NEC AMERICA, INC."}, {
	0x00, 0x90, 0xE5, "TEKNEMA, INC."}, {
	0x00, 0x90, 0xE6, "ACER LABORATORIES, INC."}, {
	0x00, 0x90, 0xE7, "HORSCH ELEKTRONIK AG"}, {
	0x00, 0x90, 0xE8, "MOXA TECHNOLOGIES CORP., LTD."}, {
	0x00, 0x90, 0xE9, "JANZ COMPUTER AG"}, {
	0x00, 0x90, 0xEA, "ALPHA TECHNOLOGIES, INC."}, {
	0x00, 0x90, 0xEB, "SENTRY TELECOM SYSTEMS"}, {
	0x00, 0x90, 0xEC, "PYRESCOM"}, {
	0x00, 0x90, 0xED, "CENTRAL SYSTEM RESEARCH CO., LTD."}, {
	0x00, 0x90, 0xEE, "PERSONAL COMMUNICATIONS TECHNOLOGIES"}, {
	0x00, 0x90, 0xEF, "INTEGRIX, INC."}, {
	0x00, 0x90, 0xF0, "HARMONIC LIGHTWAVES, LTD."}, {
	0x00, 0x90, 0xF1, "DOT HILL SYSTEMS CORPORATION"}, {
	0x00, 0x90, 0xF2, "CISCO SYSTEMS, INC."}, {
	0x00, 0x90, 0xF3, "ASPECT COMMUNICATIONS"}, {
	0x00, 0x90, 0xF4, "LIGHTNING INSTRUMENTATION"}, {
	0x00, 0x90, 0xF5, "CLEVO CO."}, {
	0x00, 0x90, 0xF6, "ESCALATE NETWORKS, INC."}, {
	0x00, 0x90, 0xF7, "NBASE COMMUNICATIONS LTD."}, {
	0x00, 0x90, 0xF8, "MEDIATRIX TELECOM"}, {
	0x00, 0x90, 0xF9, "LEITCH"}, {
	0x00, 0x90, 0xFA, "GigaNet, Inc."}, {
	0x00, 0x90, 0xFB, "PORTWELL, INC."}, {
	0x00, 0x90, 0xFC, "NETWORK COMPUTING DEVICES"}, {
	0x00, 0x90, 0xFD, "CopperCom, Inc."}, {
	0x00, 0x90, 0xFE, "ELECOM CO., LTD.  (LANEED DIV.)"}, {
	0x00, 0x90, 0xFF, "TELLUS TECHNOLOGY INC."}, {
	0x00, 0x9D, 0x8E, "CARDIAC RECORDERS, INC."}, {
	0x00, 0xA0, 0x00, "CENTILLION NETWORKS, INC."}, {
	0x00, 0xA0, 0x01, "WATKINS-JOHNSON COMPANY"}, {
	0x00, 0xA0, 0x02, "LEEDS & NORTHRUP AUSTRALIA PTY LTD"}, {
	0x00, 0xA0, 0x03, "STAEFA CONTROL SYSTEM"}, {
	0x00, 0xA0, 0x04, "NETPOWER, INC."}, {
	0x00, 0xA0, 0x05, "DANIEL INSTRUMENTS, LTD."}, {
	0x00, 0xA0, 0x06, "IMAGE DATA PROCESSING SYSTEM GROUP"}, {
	0x00, 0xA0, 0x07, "APEXX TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x08, "NETCORP"}, {
	0x00, 0xA0, 0x09, "WHITETREE NETWORK"}, {
	0x00, 0xA0, 0x0A, "R.D.C. COMMUNICATION"}, {
	0x00, 0xA0, 0x0B, "COMPUTEX CO., LTD."}, {
	0x00, 0xA0, 0x0C, "KINGMAX TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x0D, "THE PANDA PROJECT"}, {
	0x00, 0xA0, 0x0E, "VISUAL NETWORKS, INC."}, {
	0x00, 0xA0, 0x0F, "Broadband Technologies"}, {
	0x00, 0xA0, 0x10, "SYSLOGIC DATENTECHNIK AG"}, {
	0x00, 0xA0, 0x11, "MUTOH INDUSTRIES LTD."}, {
	0x00, 0xA0, 0x12, "B.A.T.M. ADVANCED TECHNOLOGIES"}, {
	0x00, 0xA0, 0x13, "TELTREND LTD."}, {
	0x00, 0xA0, 0x14, "CSIR"}, {
	0x00, 0xA0, 0x15, "WYLE"}, {
	0x00, 0xA0, 0x16, "MICROPOLIS CORP."}, {
	0x00, 0xA0, 0x17, "J B M CORPORATION"}, {
	0x00, 0xA0, 0x18, "CREATIVE CONTROLLERS, INC."}, {
	0x00, 0xA0, 0x19, "NEBULA CONSULTANTS, INC."}, {
	0x00, 0xA0, 0x1A, "BINAR ELEKTRONIK AB"}, {
	0x00, 0xA0, 0x1B, "PREMISYS COMMUNICATIONS, INC."}, {
	0x00, 0xA0, 0x1C, "NASCENT NETWORKS CORPORATION"}, {
	0x00, 0xA0, 0x1D, "SIXNET"}, {
	0x00, 0xA0, 0x1E, "EST CORPORATION"}, {
	0x00, 0xA0, 0x1F, "TRICORD SYSTEMS, INC."}, {
	0x00, 0xA0, 0x20, "CITICORP/TTI"}, {
	0x00, 0xA0, 0x21, "GENERAL DYNAMICS-"}, {
	0x00, 0xA0, 0x22, "CENTRE FOR DEVELOPMENT OF ADVANCED COMPUTING"},
	{
	0x00, 0xA0, 0x23, "APPLIED CREATIVE TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x24, "3COM CORPORATION"}, {
	0x00, 0xA0, 0x25, "REDCOM LABS INC."}, {
	0x00, 0xA0, 0x26, "TELDAT, S.A."}, {
	0x00, 0xA0, 0x27, "FIREPOWER SYSTEMS, INC."}, {
	0x00, 0xA0, 0x28, "CONNER PERIPHERALS"}, {
	0x00, 0xA0, 0x29, "COULTER CORPORATION"}, {
	0x00, 0xA0, 0x2A, "TRANCELL SYSTEMS"}, {
	0x00, 0xA0, 0x2B, "TRANSITIONS RESEARCH CORP."}, {
	0x00, 0xA0, 0x2C, "interWAVE Communications"}, {
	0x00, 0xA0, 0x2D, "1394 Trade Association"}, {
	0x00, 0xA0, 0x2E, "BRAND COMMUNICATIONS, LTD."}, {
	0x00, 0xA0, 0x2F, "PIRELLI CAVI"}, {
	0x00, 0xA0, 0x30, "CAPTOR NV/SA"}, {
	0x00, 0xA0, 0x31, "HAZELTINE CORPORATION, MS 1-17"}, {
	0x00, 0xA0, 0x32, "GES SINGAPORE PTE. LTD."}, {
	0x00, 0xA0, 0x33, "imc MeBsysteme GmbH"}, {
	0x00, 0xA0, 0x34, "AXEL"}, {
	0x00, 0xA0, 0x35, "CYLINK CORPORATION"}, {
	0x00, 0xA0, 0x36, "APPLIED NETWORK TECHNOLOGY"}, {
	0x00, 0xA0, 0x37, "DATASCOPE CORPORATION"}, {
	0x00, 0xA0, 0x38, "EMAIL ELECTRONICS"}, {
	0x00, 0xA0, 0x39, "ROSS TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x3A, "KUBOTEK CORPORATION"}, {
	0x00, 0xA0, 0x3B, "TOSHIN ELECTRIC CO., LTD."}, {
	0x00, 0xA0, 0x3C, "EG&G NUCLEAR INSTRUMENTS"}, {
	0x00, 0xA0, 0x3D, "OPTO-22"}, {
	0x00, 0xA0, 0x3E, "ATM FORUM"}, {
	0x00, 0xA0, 0x3F,
		"COMPUTER SOCIETY MICROPROCESSOR & MICROPROCESSOR STANDARDS C"},
	{
	0x00, 0xA0, 0x40, "APPLE COMPUTER"}, {
	0x00, 0xA0, 0x41, "LEYBOLD-INFICON"}, {
	0x00, 0xA0, 0x42, "SPUR PRODUCTS CORP."}, {
	0x00, 0xA0, 0x43, "AMERICAN TECHNOLOGY LABS, INC."}, {
	0x00, 0xA0, 0x44, "NTT INTELLIGENT TECHNOLOGY"}, {
	0x00, 0xA0, 0x45, "PHOENIX CONTACT GMBH & CO."}, {
	0x00, 0xA0, 0x46, "SCITEX CORP. LTD."}, {
	0x00, 0xA0, 0x47, "INTEGRATED FITNESS CORP."}, {
	0x00, 0xA0, 0x48, "QUESTECH, LTD."}, {
	0x00, 0xA0, 0x49, "DIGITECH INDUSTRIES, INC."}, {
	0x00, 0xA0, 0x4A, "NISSHIN ELECTRIC CO., LTD."}, {
	0x00, 0xA0, 0x4B, "TFL LAN INC."}, {
	0x00, 0xA0, 0x4C, "INNOVATIVE SYSTEMS & TECHNOLOGIES, INC."}, {
	0x00, 0xA0, 0x4D, "EDA INSTRUMENTS, INC."}, {
	0x00, 0xA0, 0x4E, "VOELKER TECHNOLOGIES, INC."}, {
	0x00, 0xA0, 0x4F, "AMERITEC CORP."}, {
	0x00, 0xA0, 0x50, "CYPRESS SEMICONDUCTOR"}, {
	0x00, 0xA0, 0x51, "ANGIA COMMUNICATIONS. INC."}, {
	0x00, 0xA0, 0x52, "STANILITE ELECTRONICS PTY. LTD"}, {
	0x00, 0xA0, 0x53, "COMPACT DEVICES, INC."}, {
	0x00, 0xA0, 0x55, "LINKTECH, INC."}, {
	0x00, 0xA0, 0x56, "MICROPROSS"}, {
	0x00, 0xA0, 0x57, "LANCOM Systems GmbH"}, {
	0x00, 0xA0, 0x58, "GLORY, LTD."}, {
	0x00, 0xA0, 0x59, "HAMILTON HALLMARK"}, {
	0x00, 0xA0, 0x5A, "KOFAX IMAGE PRODUCTS"}, {
	0x00, 0xA0, 0x5B, "MARQUIP, INC."}, {
	0x00, 0xA0, 0x5C, "INVENTORY CONVERSION, INC./"}, {
	0x00, 0xA0, 0x5D, "CS COMPUTER SYSTEME GmbH"}, {
	0x00, 0xA0, 0x5E, "MYRIAD LOGIC INC."}, {
	0x00, 0xA0, 0x5F, "BTG ENGINEERING BV"}, {
	0x00, 0xA0, 0x60, "ACER PERIPHERALS, INC."}, {
	0x00, 0xA0, 0x61, "PURITAN BENNETT"}, {
	0x00, 0xA0, 0x62, "AES PRODATA"}, {
	0x00, 0xA0, 0x63, "JRL SYSTEMS, INC."}, {
	0x00, 0xA0, 0x64, "KVB/ANALECT"}, {
	0x00, 0xA0, 0x65, "NEXLAND, INC."}, {
	0x00, 0xA0, 0x66, "ISA CO., LTD."}, {
	0x00, 0xA0, 0x67, "NETWORK SERVICES GROUP"}, {
	0x00, 0xA0, 0x69, "TrueTime"}, {
	0x00, 0xA0, 0x6A, "VERILINK CORP."}, {
	0x00, 0xA0, 0x6B, "DMS DORSCH MIKROSYSTEM GMBH"}, {
	0x00, 0xA0, 0x6C, "SHINDENGEN ELECTRIC MFG. CO., LTD."}, {
	0x00, 0xA0, 0x6D, "MANNESMANN TALLY CORPORATION"}, {
	0x00, 0xA0, 0x6E, "AUSTRON, INC."}, {
	0x00, 0xA0, 0x6F, "THE APPCON GROUP, INC."}, {
	0x00, 0xA0, 0x70, "COASTCOM"}, {
	0x00, 0xA0, 0x71, "VIDEO LOTTERY TECHNOLOGIES,INC"}, {
	0x00, 0xA0, 0x72, "OVATION SYSTEMS LTD."}, {
	0x00, 0xA0, 0x73, "COM21, INC."}, {
	0x00, 0xA0, 0x74, "PERCEPTION TECHNOLOGY"}, {
	0x00, 0xA0, 0x75, "MICRON TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x76, "CARDWARE LAB, INC."}, {
	0x00, 0xA0, 0x77, "FUJITSU NEXION, INC."}, {
	0x00, 0xA0, 0x78, "Marconi Communications"}, {
	0x00, 0xA0, 0x79, "ALPS ELECTRIC (USA), INC."}, {
	0x00, 0xA0, 0x7A, "ADVANCED PERIPHERALS TECHNOLOGIES, INC."}, {
	0x00, 0xA0, 0x7B, "DAWN COMPUTER INCORPORATION"}, {
	0x00, 0xA0, 0x7C, "TONYANG NYLON CO., LTD."}, {
	0x00, 0xA0, 0x7D, "SEEQ TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x7E, "AVID TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x7F, "GSM-SYNTEL, LTD."}, {
	0x00, 0xA0, 0x80, "ANTARES MICROSYSTEMS"}, {
	0x00, 0xA0, 0x81, "ALCATEL DATA NETWORKS"}, {
	0x00, 0xA0, 0x82, "NKT ELEKTRONIK A/S"}, {
	0x00, 0xA0, 0x83, "ASIMMPHONY TURKEY"}, {
	0x00, 0xA0, 0x84, "DATAPLEX PTY. LTD."}, {
	0x00, 0xA0, 0x86, "AMBER WAVE SYSTEMS, INC."}, {
	0x00, 0xA0, 0x87, "Zarlink Semiconductor Ltd."}, {
	0x00, 0xA0, 0x88, "ESSENTIAL COMMUNICATIONS"}, {
	0x00, 0xA0, 0x89, "XPOINT TECHNOLOGIES, INC."}, {
	0x00, 0xA0, 0x8A, "BROOKTROUT TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0x8B, "ASTON ELECTRONIC DESIGNS LTD."}, {
	0x00, 0xA0, 0x8C, "MultiMedia LANs, Inc."}, {
	0x00, 0xA0, 0x8D, "JACOMO CORPORATION"}, {
	0x00, 0xA0, 0x8E, "Nokia Internet Communications"}, {
	0x00, 0xA0, 0x8F, "DESKNET SYSTEMS, INC."}, {
	0x00, 0xA0, 0x90, "TimeStep Corporation"}, {
	0x00, 0xA0, 0x91, "APPLICOM INTERNATIONAL"}, {
	0x00, 0xA0, 0x92, "H. BOLLMANN MANUFACTURERS, LTD"}, {
	0x00, 0xA0, 0x93, "B/E AEROSPACE, Inc."}, {
	0x00, 0xA0, 0x94, "COMSAT CORPORATION"}, {
	0x00, 0xA0, 0x95, "ACACIA NETWORKS, INC."}, {
	0x00, 0xA0, 0x96, "MITUMI ELECTRIC CO., LTD."}, {
	0x00, 0xA0, 0x97, "JC INFORMATION SYSTEMS"}, {
	0x00, 0xA0, 0x98, "NETWORK APPLIANCE CORP."}, {
	0x00, 0xA0, 0x99, "K-NET LTD."}, {
	0x00, 0xA0, 0x9A, "NIHON KOHDEN AMERICA"}, {
	0x00, 0xA0, 0x9B, "QPSX COMMUNICATIONS, LTD."}, {
	0x00, 0xA0, 0x9C, "Xyplex, Inc."}, {
	0x00, 0xA0, 0x9D, "JOHNATHON FREEMAN TECHNOLOGIES"}, {
	0x00, 0xA0, 0x9E, "ICTV"}, {
	0x00, 0xA0, 0x9F, "COMMVISION CORP."}, {
	0x00, 0xA0, 0xA0, "COMPACT DATA, LTD."}, {
	0x00, 0xA0, 0xA1, "EPIC DATA INC."}, {
	0x00, 0xA0, 0xA2, "DIGICOM S.P.A."}, {
	0x00, 0xA0, 0xA3, "RELIABLE POWER METERS"}, {
	0x00, 0xA0, 0xA4, "MICROS SYSTEMS, INC."}, {
	0x00, 0xA0, 0xA5, "TEKNOR MICROSYSTEME, INC."}, {
	0x00, 0xA0, 0xA6, "M.I. SYSTEMS, K.K."}, {
	0x00, 0xA0, 0xA7, "VORAX CORPORATION"}, {
	0x00, 0xA0, 0xA8, "RENEX CORPORATION"}, {
	0x00, 0xA0, 0xA9, "GN NETTEST (CANADA) NAVTEL DIVISION"}, {
	0x00, 0xA0, 0xAA, "SPACELABS MEDICAL"}, {
	0x00, 0xA0, 0xAB, "NETCS INFORMATIONSTECHNIK GMBH"}, {
	0x00, 0xA0, 0xAC, "GILAT SATELLITE NETWORKS, LTD."}, {
	0x00, 0xA0, 0xAD, "MARCONI SPA"}, {
	0x00, 0xA0, 0xAE, "NUCOM SYSTEMS, INC."}, {
	0x00, 0xA0, 0xAF, "WMS INDUSTRIES"}, {
	0x00, 0xA0, 0xB0, "I-O DATA DEVICE, INC."}, {
	0x00, 0xA0, 0xB1, "FIRST VIRTUAL CORPORATION"}, {
	0x00, 0xA0, 0xB2, "SHIMA SEIKI"}, {
	0x00, 0xA0, 0xB3, "ZYKRONIX"}, {
	0x00, 0xA0, 0xB4, "TEXAS MICROSYSTEMS, INC."}, {
	0x00, 0xA0, 0xB5, "3H TECHNOLOGY"}, {
	0x00, 0xA0, 0xB6, "SANRITZ AUTOMATION CO., LTD."}, {
	0x00, 0xA0, 0xB7, "CORDANT, INC."}, {
	0x00, 0xA0, 0xB8, "SYMBIOS LOGIC INC."}, {
	0x00, 0xA0, 0xB9, "EAGLE TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0xBA, "PATTON ELECTRONICS CO."}, {
	0x00, 0xA0, 0xBB, "HILAN GMBH"}, {
	0x00, 0xA0, 0xBC, "VIASAT, INCORPORATED"}, {
	0x00, 0xA0, 0xBD, "I-TECH CORP."}, {
	0x00, 0xA0, 0xBE,
		"INTEGRATED CIRCUIT SYSTEMS, INC. COMMUNICATIONS GROUP"}, {
	0x00, 0xA0, 0xBF, "WIRELESS DATA GROUP MOTOROLA"}, {
	0x00, 0xA0, 0xC0, "DIGITAL LINK CORP."}, {
	0x00, 0xA0, 0xC1, "ORTIVUS MEDICAL AB"}, {
	0x00, 0xA0, 0xC2, "R.A. SYSTEMS CO., LTD."}, {
	0x00, 0xA0, 0xC3, "UNICOMPUTER GMBH"}, {
	0x00, 0xA0, 0xC4, "CRISTIE ELECTRONICS LTD."}, {
	0x00, 0xA0, 0xC5, "ZYXEL COMMUNICATION"}, {
	0x00, 0xA0, 0xC6, "QUALCOMM INCORPORATED"}, {
	0x00, 0xA0, 0xC7, "TADIRAN TELECOMMUNICATIONS"}, {
	0x00, 0xA0, 0xC8, "ADTRAN INC."}, {
	0x00, 0xA0, 0xC9, "INTEL CORPORATION - HF1-06"}, {
	0x00, 0xA0, 0xCA, "FUJITSU DENSO LTD."}, {
	0x00, 0xA0, 0xCB, "ARK TELECOMMUNICATIONS, INC."}, {
	0x00, 0xA0, 0xCC, "LITE-ON COMMUNICATIONS, INC."}, {
	0x00, 0xA0, 0xCD, "DR. JOHANNES HEIDENHAIN GmbH"}, {
	0x00, 0xA0, 0xCE, "ASTROCOM CORPORATION"}, {
	0x00, 0xA0, 0xCF, "SOTAS, INC."}, {
	0x00, 0xA0, 0xD0, "TEN X TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0xD1, "INVENTEC CORPORATION"}, {
	0x00, 0xA0, 0xD2, "ALLIED TELESIS INTERNATIONAL CORPORATION"}, {
	0x00, 0xA0, 0xD3, "INSTEM COMPUTER SYSTEMS, LTD."}, {
	0x00, 0xA0, 0xD4, "RADIOLAN,  INC."}, {
	0x00, 0xA0, 0xD5, "SIERRA WIRELESS INC."}, {
	0x00, 0xA0, 0xD6, "SBE, INC."}, {
	0x00, 0xA0, 0xD7, "KASTEN CHASE APPLIED RESEARCH"}, {
	0x00, 0xA0, 0xD8, "SPECTRA - TEK"}, {
	0x00, 0xA0, 0xD9, "CONVEX COMPUTER CORPORATION"}, {
	0x00, 0xA0, 0xDA, "INTEGRATED SYSTEMS Technology, Inc."}, {
	0x00, 0xA0, 0xDB, "FISHER & PAYKEL PRODUCTION"}, {
	0x00, 0xA0, 0xDC, "O.N. ELECTRONIC CO., LTD."}, {
	0x00, 0xA0, 0xDD, "AZONIX CORPORATION"}, {
	0x00, 0xA0, 0xDE, "YAMAHA CORPORATION"}, {
	0x00, 0xA0, 0xDF, "STS TECHNOLOGIES, INC."}, {
	0x00, 0xA0, 0xE0, "TENNYSON TECHNOLOGIES PTY LTD"}, {
	0x00, 0xA0, 0xE1, "WESTPORT RESEARCH ASSOCIATES, INC."}, {
	0x00, 0xA0, 0xE2, "KEISOKU GIKEN CORP."}, {
	0x00, 0xA0, 0xE3, "XKL SYSTEMS CORP."}, {
	0x00, 0xA0, 0xE4, "OPTIQUEST"}, {
	0x00, 0xA0, 0xE5, "NHC COMMUNICATIONS"}, {
	0x00, 0xA0, 0xE6, "DIALOGIC CORPORATION"}, {
	0x00, 0xA0, 0xE7, "CENTRAL DATA CORPORATION"}, {
	0x00, 0xA0, 0xE8, "REUTERS HOLDINGS PLC"}, {
	0x00, 0xA0, 0xE9, "ELECTRONIC RETAILING SYSTEMS INTERNATIONAL"}, {
	0x00, 0xA0, 0xEA, "ETHERCOM CORP."}, {
	0x00, 0xA0, 0xEB, "FASTCOMM COMMUNICATIONS CORP."}, {
	0x00, 0xA0, 0xEC, "TRANSMITTON LTD."}, {
	0x00, 0xA0, 0xED, "PRI AUTOMATION"}, {
	0x00, 0xA0, 0xEE, "NASHOBA NETWORKS"}, {
	0x00, 0xA0, 0xEF, "LUCIDATA LTD."}, {
	0x00, 0xA0, 0xF0, "TORONTO MICROELECTRONICS INC."}, {
	0x00, 0xA0, 0xF1, "MTI"}, {
	0x00, 0xA0, 0xF2, "INFOTEK COMMUNICATIONS, INC."}, {
	0x00, 0xA0, 0xF3, "STAUBLI"}, {
	0x00, 0xA0, 0xF4, "GE"}, {
	0x00, 0xA0, 0xF5, "RADGUARD LTD."}, {
	0x00, 0xA0, 0xF6, "AutoGas Systems Inc."}, {
	0x00, 0xA0, 0xF7, "V.I COMPUTER CORP."}, {
	0x00, 0xA0, 0xF8, "SYMBOL TECHNOLOGIES, INC."}, {
	0x00, 0xA0, 0xF9, "BINTEC COMMUNICATIONS GMBH"}, {
	0x00, 0xA0, 0xFA, "Marconi Communication GmbH"}, {
	0x00, 0xA0, 0xFB, "TORAY ENGINEERING CO., LTD."}, {
	0x00, 0xA0, 0xFC, "IMAGE SCIENCES, INC."}, {
	0x00, 0xA0, 0xFD, "SCITEX DIGITAL PRINTING, INC."}, {
	0x00, 0xA0, 0xFE, "BOSTON TECHNOLOGY, INC."}, {
	0x00, 0xA0, 0xFF, "TELLABS OPERATIONS, INC."}, {
	0x00, 0xAA, 0x00, "INTEL CORPORATION"}, {
	0x00, 0xAA, 0x01, "INTEL CORPORATION"}, {
	0x00, 0xAA, 0x02, "INTEL CORPORATION"}, {
	0x00, 0xAA, 0x3C, "OLIVETTI TELECOM SPA (OLTECO)"}, {
	0x00, 0xB0, 0x09, "Grass Valley Group"}, {
	0x00, 0xB0, 0x17, "InfoGear Technology Corp."}, {
	0x00, 0xB0, 0x19, "Casi-Rusco"}, {
	0x00, 0xB0, 0x1C, "Westport Technologies"}, {
	0x00, 0xB0, 0x1E, "Rantic Labs, Inc."}, {
	0x00, 0xB0, 0x2A, "ORSYS GmbH"}, {
	0x00, 0xB0, 0x2D, "ViaGate Technologies, Inc."}, {
	0x00, 0xB0, 0x3B, "HiQ Networks"}, {
	0x00, 0xB0, 0x48, "Marconi Communications Inc."}, {
	0x00, 0xB0, 0x4A, "Cisco Systems, Inc."}, {
	0x00, 0xB0, 0x52, "Intellon Corporation"}, {
	0x00, 0xB0, 0x64, "Cisco Systems, Inc."}, {
	0x00, 0xB0, 0x69, "Honewell Oy"}, {
	0x00, 0xB0, 0x6D, "Jones Futurex Inc."}, {
	0x00, 0xB0, 0x80, "Mannesmann Ipulsys B.V."}, {
	0x00, 0xB0, 0x86, "LocSoft Limited"}, {
	0x00, 0xB0, 0x8E, "Cisco Systems, Inc."}, {
	0x00, 0xB0, 0x91, "Transmeta Corp."}, {
	0x00, 0xB0, 0x94, "Alaris, Inc."}, {
	0x00, 0xB0, 0x9A, "Morrow Technologies Corp."}, {
	0x00, 0xB0, 0x9D, "Point Grey Research Inc."}, {
	0x00, 0xB0, 0xAC, "SIAE-Microelettronica S.p.A."}, {
	0x00, 0xB0, 0xAE, "Symmetricom"}, {
	0x00, 0xB0, 0xB3, "Xstreamis PLC"}, {
	0x00, 0xB0, 0xC2, "Cisco Systems, Inc."}, {
	0x00, 0xB0, 0xC7, "Tellabs Operations, Inc."}, {
	0x00, 0xB0, 0xCE, "TECHNOLOGY RESCUE"}, {
	0x00, 0xB0, 0xD0, "Dell Computer Corp."}, {
	0x00, 0xB0, 0xDB, "Nextcell, Inc."}, {
	0x00, 0xB0, 0xDF, "Reliable Data Technology, Inc."}, {
	0x00, 0xB0, 0xE7, "British Federal Ltd."}, {
	0x00, 0xB0, 0xEC, "EACEM"}, {
	0x00, 0xB0, 0xEE, "Ajile Systems, Inc."}, {
	0x00, 0xB0, 0xF0, "CALY NETWORKS"}, {
	0x00, 0xB0, 0xF5, "NetWorth Technologies, Inc."}, {
	0x00, 0xBB, 0x01, "OCTOTHORPE CORP."}, {
	0x00, 0xBB, 0xF0, "UNGERMANN-BASS INC."}, {
	0x00, 0xC0, 0x00, "LANOPTICS, LTD."}, {
	0x00, 0xC0, 0x01, "DIATEK PATIENT MANAGMENT"}, {
	0x00, 0xC0, 0x02, "SERCOMM CORPORATION"}, {
	0x00, 0xC0, 0x03, "GLOBALNET COMMUNICATIONS"}, {
	0x00, 0xC0, 0x04, "JAPAN BUSINESS COMPUTER CO.LTD"}, {
	0x00, 0xC0, 0x05, "LIVINGSTON ENTERPRISES, INC."}, {
	0x00, 0xC0, 0x06, "NIPPON AVIONICS CO., LTD."}, {
	0x00, 0xC0, 0x07, "PINNACLE DATA SYSTEMS, INC."}, {
	0x00, 0xC0, 0x08, "SECO SRL"}, {
	0x00, 0xC0, 0x09, "KT TECHNOLOGY (S) PTE LTD"}, {
	0x00, 0xC0, 0x0A, "MICRO CRAFT"}, {
	0x00, 0xC0, 0x0B, "NORCONTROL A.S."}, {
	0x00, 0xC0, 0x0C, "RELIA TECHNOLGIES"}, {
	0x00, 0xC0, 0x0D, "ADVANCED LOGIC RESEARCH, INC."}, {
	0x00, 0xC0, 0x0E, "PSITECH, INC."}, {
	0x00, 0xC0, 0x0F, "QUANTUM SOFTWARE SYSTEMS LTD."}, {
	0x00, 0xC0, 0x10, "HIRAKAWA HEWTECH CORP."}, {
	0x00, 0xC0, 0x11, "INTERACTIVE COMPUTING DEVICES"}, {
	0x00, 0xC0, 0x12, "NETSPAN CORPORATION"}, {
	0x00, 0xC0, 0x13, "NETRIX"}, {
	0x00, 0xC0, 0x14, "TELEMATICS CALABASAS INT'L,INC"}, {
	0x00, 0xC0, 0x15, "NEW MEDIA CORPORATION"}, {
	0x00, 0xC0, 0x16, "ELECTRONIC THEATRE CONTROLS"}, {
	0x00, 0xC0, 0x17, "FORTE NETWORKS"}, {
	0x00, 0xC0, 0x18, "LANART CORPORATION"}, {
	0x00, 0xC0, 0x19, "LEAP TECHNOLOGY, INC."}, {
	0x00, 0xC0, 0x1A, "COROMETRICS MEDICAL SYSTEMS"}, {
	0x00, 0xC0, 0x1B, "SOCKET COMMUNICATIONS, INC."}, {
	0x00, 0xC0, 0x1C, "INTERLINK COMMUNICATIONS LTD."}, {
	0x00, 0xC0, 0x1D, "GRAND JUNCTION NETWORKS, INC."}, {
	0x00, 0xC0, 0x1E, "LA FRANCAISE DES JEUX"}, {
	0x00, 0xC0, 0x1F, "S.E.R.C.E.L."}, {
	0x00, 0xC0, 0x20, "ARCO ELECTRONIC, CONTROL LTD."}, {
	0x00, 0xC0, 0x21, "NETEXPRESS"}, {
	0x00, 0xC0, 0x22, "LASERMASTER TECHNOLOGIES, INC."}, {
	0x00, 0xC0, 0x23, "TUTANKHAMON ELECTRONICS"}, {
	0x00, 0xC0, 0x24, "EDEN SISTEMAS DE COMPUTACAO SA"}, {
	0x00, 0xC0, 0x25, "DATAPRODUCTS CORPORATION"}, {
	0x00, 0xC0, 0x26, "LANS TECHNOLOGY CO., LTD."}, {
	0x00, 0xC0, 0x27, "CIPHER SYSTEMS, INC."}, {
	0x00, 0xC0, 0x28, "JASCO CORPORATION"}, {
	0x00, 0xC0, 0x29, "Nexans Deutschland AG - ANS"}, {
	0x00, 0xC0, 0x2A, "OHKURA ELECTRIC CO., LTD."}, {
	0x00, 0xC0, 0x2B, "GERLOFF GESELLSCHAFT FUR"}, {
	0x00, 0xC0, 0x2C, "CENTRUM COMMUNICATIONS, INC."}, {
	0x00, 0xC0, 0x2D, "FUJI PHOTO FILM CO., LTD."}, {
	0x00, 0xC0, 0x2E, "NETWIZ"}, {
	0x00, 0xC0, 0x2F, "OKUMA CORPORATION"}, {
	0x00, 0xC0, 0x30, "INTEGRATED ENGINEERING B. V."}, {
	0x00, 0xC0, 0x31, "DESIGN RESEARCH SYSTEMS, INC."}, {
	0x00, 0xC0, 0x32, "I-CUBED LIMITED"}, {
	0x00, 0xC0, 0x33, "TELEBIT COMMUNICATIONS APS"}, {
	0x00, 0xC0, 0x34, "TRANSACTION NETWORK"}, {
	0x00, 0xC0, 0x35, "QUINTAR COMPANY"}, {
	0x00, 0xC0, 0x36, "RAYTECH ELECTRONIC CORP."}, {
	0x00, 0xC0, 0x37, "DYNATEM"}, {
	0x00, 0xC0, 0x38, "RASTER IMAGE PROCESSING SYSTEM"}, {
	0x00, 0xC0, 0x39, "TDK SEMICONDUCTOR CORPORATION"}, {
	0x00, 0xC0, 0x3A, "MEN-MIKRO ELEKTRONIK GMBH"}, {
	0x00, 0xC0, 0x3B, "MULTIACCESS COMPUTING CORP."}, {
	0x00, 0xC0, 0x3C, "TOWER TECH S.R.L."}, {
	0x00, 0xC0, 0x3D, "WIESEMANN & THEIS GMBH"}, {
	0x00, 0xC0, 0x3E, "FA. GEBR. HELLER GMBH"}, {
	0x00, 0xC0, 0x3F, "STORES AUTOMATED SYSTEMS, INC."}, {
	0x00, 0xC0, 0x40, "ECCI"}, {
	0x00, 0xC0, 0x41, "DIGITAL TRANSMISSION SYSTEMS"}, {
	0x00, 0xC0, 0x42, "DATALUX CORP."}, {
	0x00, 0xC0, 0x43, "STRATACOM"}, {
	0x00, 0xC0, 0x44, "EMCOM CORPORATION"}, {
	0x00, 0xC0, 0x45, "ISOLATION SYSTEMS, LTD."}, {
	0x00, 0xC0, 0x46, "KEMITRON LTD."}, {
	0x00, 0xC0, 0x47, "UNIMICRO SYSTEMS, INC."}, {
	0x00, 0xC0, 0x48, "BAY TECHNICAL ASSOCIATES"}, {
	0x00, 0xC0, 0x49, "U.S. ROBOTICS, INC."}, {
	0x00, 0xC0, 0x4A, "GROUP 2000 AG"}, {
	0x00, 0xC0, 0x4B, "CREATIVE MICROSYSTEMS"}, {
	0x00, 0xC0, 0x4C, "DEPARTMENT OF FOREIGN AFFAIRS"}, {
	0x00, 0xC0, 0x4D, "MITEC, INC."}, {
	0x00, 0xC0, 0x4E, "COMTROL CORPORATION"}, {
	0x00, 0xC0, 0x4F, "DELL COMPUTER CORPORATION"}, {
	0x00, 0xC0, 0x50, "TOYO DENKI SEIZO K.K."}, {
	0x00, 0xC0, 0x51, "ADVANCED INTEGRATION RESEARCH"}, {
	0x00, 0xC0, 0x52, "BURR-BROWN"}, {
	0x00, 0xC0, 0x53, "DAVOX CORPORATION"}, {
	0x00, 0xC0, 0x54, "NETWORK PERIPHERALS, LTD."}, {
	0x00, 0xC0, 0x55, "MODULAR COMPUTING TECHNOLOGIES"}, {
	0x00, 0xC0, 0x56, "SOMELEC"}, {
	0x00, 0xC0, 0x57, "MYCO ELECTRONICS"}, {
	0x00, 0xC0, 0x58, "DATAEXPERT CORP."}, {
	0x00, 0xC0, 0x59, "NIPPON DENSO CO., LTD."}, {
	0x00, 0xC0, 0x5A, "SEMAPHORE COMMUNICATIONS CORP."}, {
	0x00, 0xC0, 0x5B, "NETWORKS NORTHWEST, INC."}, {
	0x00, 0xC0, 0x5C, "ELONEX PLC"}, {
	0x00, 0xC0, 0x5D, "L&N TECHNOLOGIES"}, {
	0x00, 0xC0, 0x5E, "VARI-LITE, INC."}, {
	0x00, 0xC0, 0x5F, "FINE-PAL COMPANY LIMITED"}, {
	0x00, 0xC0, 0x60, "ID SCANDINAVIA AS"}, {
	0x00, 0xC0, 0x61, "SOLECTEK CORPORATION"}, {
	0x00, 0xC0, 0x62, "IMPULSE TECHNOLOGY"}, {
	0x00, 0xC0, 0x63, "MORNING STAR TECHNOLOGIES, INC"}, {
	0x00, 0xC0, 0x64, "GENERAL DATACOMM IND. INC."}, {
	0x00, 0xC0, 0x65, "SCOPE COMMUNICATIONS, INC."}, {
	0x00, 0xC0, 0x66, "DOCUPOINT, INC."}, {
	0x00, 0xC0, 0x67, "UNITED BARCODE INDUSTRIES"}, {
	0x00, 0xC0, 0x68, "PHILIP DRAKE ELECTRONICS LTD."}, {
	0x00, 0xC0, 0x69, "ADAPTIVE BROADBAND CORPORATION"}, {
	0x00, 0xC0, 0x6A, "ZAHNER-ELEKTRIK GMBH & CO. KG"}, {
	0x00, 0xC0, 0x6B, "OSI PLUS CORPORATION"}, {
	0x00, 0xC0, 0x6C, "SVEC COMPUTER CORP."}, {
	0x00, 0xC0, 0x6D, "BOCA RESEARCH, INC."}, {
	0x00, 0xC0, 0x6E, "HAFT TECHNOLOGY, INC."}, {
	0x00, 0xC0, 0x6F, "KOMATSU LTD."}, {
	0x00, 0xC0, 0x70, "SECTRA SECURE-TRANSMISSION AB"}, {
	0x00, 0xC0, 0x71, "AREANEX COMMUNICATIONS, INC."}, {
	0x00, 0xC0, 0x72, "KNX LTD."}, {
	0x00, 0xC0, 0x73, "XEDIA CORPORATION"}, {
	0x00, 0xC0, 0x74, "TOYODA AUTOMATIC LOOM"}, {
	0x00, 0xC0, 0x75, "XANTE CORPORATION"}, {
	0x00, 0xC0, 0x76, "I-DATA INTERNATIONAL A-S"}, {
	0x00, 0xC0, 0x77, "DAEWOO TELECOM LTD."}, {
	0x00, 0xC0, 0x78, "COMPUTER SYSTEMS ENGINEERING"}, {
	0x00, 0xC0, 0x79, "FONSYS CO.,LTD."}, {
	0x00, 0xC0, 0x7A, "PRIVA B.V."}, {
	0x00, 0xC0, 0x7B, "ASCEND COMMUNICATIONS, INC."}, {
	0x00, 0xC0, 0x7C, "HIGHTECH INFORMATION"}, {
	0x00, 0xC0, 0x7D, "RISC DEVELOPMENTS LTD."}, {
	0x00, 0xC0, 0x7E, "KUBOTA CORPORATION ELECTRONIC"}, {
	0x00, 0xC0, 0x7F, "NUPON COMPUTING CORP."}, {
	0x00, 0xC0, 0x80, "NETSTAR, INC."}, {
	0x00, 0xC0, 0x81, "METRODATA LTD."}, {
	0x00, 0xC0, 0x82, "MOORE PRODUCTS CO."}, {
	0x00, 0xC0, 0x83, "TRACE MOUNTAIN PRODUCTS, INC."}, {
	0x00, 0xC0, 0x84, "DATA LINK CORP. LTD."}, {
	0x00, 0xC0, 0x85, "ELECTRONICS FOR IMAGING, INC."}, {
	0x00, 0xC0, 0x86, "THE LYNK CORPORATION"}, {
	0x00, 0xC0, 0x87, "UUNET TECHNOLOGIES, INC."}, {
	0x00, 0xC0, 0x88, "EKF ELEKTRONIK GMBH"}, {
	0x00, 0xC0, 0x89, "TELINDUS DISTRIBUTION"}, {
	0x00, 0xC0, 0x8A, "LAUTERBACH DATENTECHNIK GMBH"}, {
	0x00, 0xC0, 0x8B, "RISQ MODULAR SYSTEMS, INC."}, {
	0x00, 0xC0, 0x8C, "PERFORMANCE TECHNOLOGIES, INC."}, {
	0x00, 0xC0, 0x8D, "TRONIX PRODUCT DEVELOPMENT"}, {
	0x00, 0xC0, 0x8E, "NETWORK INFORMATION TECHNOLOGY"}, {
	0x00, 0xC0, 0x8F, "MATSUSHITA ELECTRIC WORKS, LTD"}, {
	0x00, 0xC0, 0x90, "PRAIM S.R.L."}, {
	0x00, 0xC0, 0x91, "JABIL CIRCUIT, INC."}, {
	0x00, 0xC0, 0x92, "MENNEN MEDICAL INC."}, {
	0x00, 0xC0, 0x93, "ALTA RESEARCH CORP."}, {
	0x00, 0xC0, 0x94, "VMX INC."}, {
	0x00, 0xC0, 0x95, "ZNYX"}, {
	0x00, 0xC0, 0x96, "TAMURA CORPORATION"}, {
	0x00, 0xC0, 0x97, "ARCHIPEL SA"}, {
	0x00, 0xC0, 0x98, "CHUNTEX ELECTRONIC CO., LTD."}, {
	0x00, 0xC0, 0x99, "YOSHIKI INDUSTRIAL CO.,LTD."}, {
	0x00, 0xC0, 0x9A, "PHOTONICS CORPORATION"}, {
	0x00, 0xC0, 0x9B, "RELIANCE COMM/TEC, R-TEC"}, {
	0x00, 0xC0, 0x9C, "TOA ELECTRONIC LTD."}, {
	0x00, 0xC0, 0x9D, "DISTRIBUTED SYSTEMS INT'L, INC"}, {
	0x00, 0xC0, 0x9E, "CACHE COMPUTERS, INC."}, {
	0x00, 0xC0, 0x9F, "QUANTA COMPUTER, INC."}, {
	0x00, 0xC0, 0xA0, "ADVANCE MICRO RESEARCH, INC."}, {
	0x00, 0xC0, 0xA1, "TOKYO DENSHI SEKEI CO."}, {
	0x00, 0xC0, 0xA2, "INTERMEDIUM A/S"}, {
	0x00, 0xC0, 0xA3, "DUAL ENTERPRISES CORPORATION"}, {
	0x00, 0xC0, 0xA4, "UNIGRAF OY"}, {
	0x00, 0xC0, 0xA5, "DICKENS DATA SYSTEMS"}, {
	0x00, 0xC0, 0xA6, "EXICOM AUSTRALIA PTY. LTD"}, {
	0x00, 0xC0, 0xA7, "SEEL LTD."}, {
	0x00, 0xC0, 0xA8, "GVC CORPORATION"}, {
	0x00, 0xC0, 0xA9, "BARRON MCCANN LTD."}, {
	0x00, 0xC0, 0xAA, "SILICON VALLEY COMPUTER"}, {
	0x00, 0xC0, 0xAB, "Telco Systems, Inc."}, {
	0x00, 0xC0, 0xAC, "GAMBIT COMPUTER COMMUNICATIONS"}, {
	0x00, 0xC0, 0xAD, "MARBEN COMMUNICATION SYSTEMS"}, {
	0x00, 0xC0, 0xAE, "TOWERCOM CO. INC. DBA PC HOUSE"}, {
	0x00, 0xC0, 0xAF, "TEKLOGIX INC."}, {
	0x00, 0xC0, 0xB0, "GCC TECHNOLOGIES,INC."}, {
	0x00, 0xC0, 0xB1, "GENIUS NET CO."}, {
	0x00, 0xC0, 0xB2, "NORAND CORPORATION"}, {
	0x00, 0xC0, 0xB3, "COMSTAT DATACOMM CORPORATION"}, {
	0x00, 0xC0, 0xB4, "MYSON TECHNOLOGY, INC."}, {
	0x00, 0xC0, 0xB5, "CORPORATE NETWORK SYSTEMS,INC."}, {
	0x00, 0xC0, 0xB6, "MERIDIAN DATA, INC."}, {
	0x00, 0xC0, 0xB7, "AMERICAN POWER CONVERSION CORP"}, {
	0x00, 0xC0, 0xB8, "FRASER'S HILL LTD."}, {
	0x00, 0xC0, 0xB9, "FUNK SOFTWARE, INC."}, {
	0x00, 0xC0, 0xBA, "NETVANTAGE"}, {
	0x00, 0xC0, 0xBB, "FORVAL CREATIVE, INC."}, {
	0x00, 0xC0, 0xBC, "TELECOM AUSTRALIA/CSSC"}, {
	0x00, 0xC0, 0xBD, "INEX TECHNOLOGIES, INC."}, {
	0x00, 0xC0, 0xBE, "ALCATEL - SEL"}, {
	0x00, 0xC0, 0xBF, "TECHNOLOGY CONCEPTS, LTD."}, {
	0x00, 0xC0, 0xC0, "SHORE MICROSYSTEMS, INC."}, {
	0x00, 0xC0, 0xC1, "QUAD/GRAPHICS, INC."}, {
	0x00, 0xC0, 0xC2, "INFINITE NETWORKS LTD."}, {
	0x00, 0xC0, 0xC3, "ACUSON COMPUTED SONOGRAPHY"}, {
	0x00, 0xC0, 0xC4, "COMPUTER OPERATIONAL"}, {
	0x00, 0xC0, 0xC5, "SID INFORMATICA"}, {
	0x00, 0xC0, 0xC6, "PERSONAL MEDIA CORP."}, {
	0x00, 0xC0, 0xC7, "SPARKTRUM MICROSYSTEMS, INC."}, {
	0x00, 0xC0, 0xC8, "MICRO BYTE PTY. LTD."}, {
	0x00, 0xC0, 0xC9, "ELSAG BAILEY PROCESS"}, {
	0x00, 0xC0, 0xCA, "ALFA, INC."}, {
	0x00, 0xC0, 0xCB, "CONTROL TECHNOLOGY CORPORATION"}, {
	0x00, 0xC0, 0xCC, "TELESCIENCES CO SYSTEMS, INC."}, {
	0x00, 0xC0, 0xCD, "COMELTA, S.A."}, {
	0x00, 0xC0, 0xCE, "CEI SYSTEMS & ENGINEERING PTE"}, {
	0x00, 0xC0, 0xCF, "IMATRAN VOIMA OY"}, {
	0x00, 0xC0, 0xD0, "RATOC SYSTEM INC."}, {
	0x00, 0xC0, 0xD1, "COMTREE TECHNOLOGY CORPORATION"}, {
	0x00, 0xC0, 0xD2, "SYNTELLECT, INC."}, {
	0x00, 0xC0, 0xD3, "OLYMPUS IMAGE SYSTEMS, INC."}, {
	0x00, 0xC0, 0xD4, "AXON NETWORKS, INC."}, {
	0x00, 0xC0, 0xD5, "QUANCOM ELECTRONIC GMBH"}, {
	0x00, 0xC0, 0xD6, "J1 SYSTEMS, INC."}, {
	0x00, 0xC0, 0xD7, "TAIWAN TRADING CENTER DBA"}, {
	0x00, 0xC0, 0xD8, "UNIVERSAL DATA SYSTEMS"}, {
	0x00, 0xC0, 0xD9, "QUINTE NETWORK CONFIDENTIALITY"}, {
	0x00, 0xC0, 0xDA, "NICE SYSTEMS LTD."}, {
	0x00, 0xC0, 0xDB, "IPC CORPORATION (PTE) LTD."}, {
	0x00, 0xC0, 0xDC, "EOS TECHNOLOGIES, INC."}, {
	0x00, 0xC0, 0xDD, "QLogic Corporation"}, {
	0x00, 0xC0, 0xDE, "ZCOMM, INC."}, {
	0x00, 0xC0, 0xDF, "KYE SYSTEMS CORP."}, {
	0x00, 0xC0, 0xE0, "DSC COMMUNICATION CORP."}, {
	0x00, 0xC0, 0xE1, "SONIC SOLUTIONS"}, {
	0x00, 0xC0, 0xE2, "CALCOMP, INC."}, {
	0x00, 0xC0, 0xE3, "OSITECH COMMUNICATIONS, INC."}, {
	0x00, 0xC0, 0xE4, "SIEMENS BUILDING"}, {
	0x00, 0xC0, 0xE5, "GESPAC, S.A."}, {
	0x00, 0xC0, 0xE6, "Verilink Corporation"}, {
	0x00, 0xC0, 0xE7, "FIBERDATA AB"}, {
	0x00, 0xC0, 0xE8, "PLEXCOM, INC."}, {
	0x00, 0xC0, 0xE9, "OAK SOLUTIONS, LTD."}, {
	0x00, 0xC0, 0xEA, "ARRAY TECHNOLOGY LTD."}, {
	0x00, 0xC0, 0xEB, "SEH COMPUTERTECHNIK GMBH"}, {
	0x00, 0xC0, 0xEC, "DAUPHIN TECHNOLOGY"}, {
	0x00, 0xC0, 0xED, "US ARMY ELECTRONIC"}, {
	0x00, 0xC0, 0xEE, "KYOCERA CORPORATION"}, {
	0x00, 0xC0, 0xEF, "ABIT CORPORATION"}, {
	0x00, 0xC0, 0xF0, "KINGSTON TECHNOLOGY CORP."}, {
	0x00, 0xC0, 0xF1, "SHINKO ELECTRIC CO., LTD."}, {
	0x00, 0xC0, 0xF2, "TRANSITION NETWORKS"}, {
	0x00, 0xC0, 0xF3, "NETWORK COMMUNICATIONS CORP."}, {
	0x00, 0xC0, 0xF4, "INTERLINK SYSTEM CO., LTD."}, {
	0x00, 0xC0, 0xF5, "METACOMP, INC."}, {
	0x00, 0xC0, 0xF6, "CELAN TECHNOLOGY INC."}, {
	0x00, 0xC0, 0xF7, "ENGAGE COMMUNICATION, INC."}, {
	0x00, 0xC0, 0xF8, "ABOUT COMPUTING INC."}, {
	0x00, 0xC0, 0xF9, "HARRIS AND JEFFRIES, INC."}, {
	0x00, 0xC0, 0xFA, "CANARY COMMUNICATIONS, INC."}, {
	0x00, 0xC0, 0xFB, "ADVANCED TECHNOLOGY LABS"}, {
	0x00, 0xC0, 0xFC, "ELASTIC REALITY, INC."}, {
	0x00, 0xC0, 0xFD, "PROSUM"}, {
	0x00, 0xC0, 0xFE, "APTEC COMPUTER SYSTEMS, INC."}, {
	0x00, 0xC0, 0xFF, "DOT HILL SYSTEMS CORPORATION"}, {
	0x00, 0xCB, 0xBD, "Cambridge Broadband Ltd."}, {
	0x00, 0xCF, 0x1C, "COMMUNICATION MACHINERY CORP."}, {
	0x00, 0xD0, 0x00, "FERRAN SCIENTIFIC, INC."}, {
	0x00, 0xD0, 0x01, "VST TECHNOLOGIES, INC."}, {
	0x00, 0xD0, 0x02, "DITECH CORPORATION"}, {
	0x00, 0xD0, 0x03, "COMDA ENTERPRISES CORP."}, {
	0x00, 0xD0, 0x04, "PENTACOM LTD."}, {
	0x00, 0xD0, 0x05, "ZHS ZEITMANAGEMENTSYSTEME"}, {
	0x00, 0xD0, 0x06, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0x07, "MIC ASSOCIATES, INC."}, {
	0x00, 0xD0, 0x08, "MACTELL CORPORATION"}, {
	0x00, 0xD0, 0x09, "HSING TECH. ENTERPRISE CO. LTD"}, {
	0x00, 0xD0, 0x0A, "LANACCESS TELECOM S.A."}, {
	0x00, 0xD0, 0x0B, "RHK TECHNOLOGY, INC."}, {
	0x00, 0xD0, 0x0C, "SNIJDER MICRO SYSTEMS"}, {
	0x00, 0xD0, 0x0D, "MICROMERITICS INSTRUMENT"}, {
	0x00, 0xD0, 0x0E, "PLURIS, INC."}, {
	0x00, 0xD0, 0x0F, "SPEECH DESIGN GMBH"}, {
	0x00, 0xD0, 0x10, "CONVERGENT NETWORKS, INC."}, {
	0x00, 0xD0, 0x11, "PRISM VIDEO, INC."}, {
	0x00, 0xD0, 0x12, "GATEWORKS CORP."}, {
	0x00, 0xD0, 0x13, "PRIMEX AEROSPACE COMPANY"}, {
	0x00, 0xD0, 0x14, "ROOT, INC."}, {
	0x00, 0xD0, 0x15, "UNIVEX MICROTECHNOLOGY CORP."}, {
	0x00, 0xD0, 0x16, "SCM MICROSYSTEMS, INC."}, {
	0x00, 0xD0, 0x17, "SYNTECH INFORMATION CO., LTD."}, {
	0x00, 0xD0, 0x18, "QWES. COM, INC."}, {
	0x00, 0xD0, 0x19, "DAINIPPON SCREEN CORPORATE"}, {
	0x00, 0xD0, 0x1A, "URMET SUD S.P.A."}, {
	0x00, 0xD0, 0x1B, "MIMAKI ENGINEERING CO., LTD."}, {
	0x00, 0xD0, 0x1C, "SBS TECHNOLOGIES,"}, {
	0x00, 0xD0, 0x1D, "FURUNO ELECTRIC CO., LTD."}, {
	0x00, 0xD0, 0x1E, "PINGTEL CORP."}, {
	0x00, 0xD0, 0x1F, "CTAM PTY. LTD."}, {
	0x00, 0xD0, 0x20, "AIM SYSTEM, INC."}, {
	0x00, 0xD0, 0x21, "REGENT ELECTRONICS CORP."}, {
	0x00, 0xD0, 0x22, "INCREDIBLE TECHNOLOGIES, INC."}, {
	0x00, 0xD0, 0x23, "INFORTREND TECHNOLOGY, INC."}, {
	0x00, 0xD0, 0x24, "Cognex Corporation"}, {
	0x00, 0xD0, 0x25, "XROSSTECH, INC."}, {
	0x00, 0xD0, 0x26, "HIRSCHMANN AUSTRIA GMBH"}, {
	0x00, 0xD0, 0x27, "APPLIED AUTOMATION, INC."}, {
	0x00, 0xD0, 0x28, "OMNEON VIDEO NETWORKS"}, {
	0x00, 0xD0, 0x29, "WAKEFERN FOOD CORPORATION"}, {
	0x00, 0xD0, 0x2A, "FLEXION SYSTEMS"}, {
	0x00, 0xD0, 0x2B, "JETCELL, INC."}, {
	0x00, 0xD0, 0x2C, "CAMPBELL SCIENTIFIC, INC."}, {
	0x00, 0xD0, 0x2D, "ADEMCO"}, {
	0x00, 0xD0, 0x2E, "COMMUNICATION AUTOMATION CORP."}, {
	0x00, 0xD0, 0x2F, "VLSI TECHNOLOGY INC."}, {
	0x00, 0xD0, 0x30, "SAFETRAN SYSTEMS CORP."}, {
	0x00, 0xD0, 0x31, "INDUSTRIAL LOGIC CORPORATION"}, {
	0x00, 0xD0, 0x32, "YANO ELECTRIC CO., LTD."}, {
	0x00, 0xD0, 0x33, "DALIAN DAXIAN NETWORK"}, {
	0x00, 0xD0, 0x34, "ORMEC SYSTEMS CORP."}, {
	0x00, 0xD0, 0x35, "BEHAVIOR TECH. COMPUTER CORP."}, {
	0x00, 0xD0, 0x36, "TECHNOLOGY ATLANTA CORP."}, {
	0x00, 0xD0, 0x37, "PHILIPS-DVS-LO BDR"}, {
	0x00, 0xD0, 0x38, "FIVEMERE, LTD."}, {
	0x00, 0xD0, 0x39, "UTILICOM, INC."}, {
	0x00, 0xD0, 0x3A, "ZONEWORX, INC."}, {
	0x00, 0xD0, 0x3B, "VISION PRODUCTS PTY. LTD."}, {
	0x00, 0xD0, 0x3C, "Vieo, Inc."}, {
	0x00, 0xD0, 0x3E, "ROCKETCHIPS, INC."}, {
	0x00, 0xD0, 0x3F, "AMERICAN COMMUNICATION"}, {
	0x00, 0xD0, 0x40, "SYSMATE CO., LTD."}, {
	0x00, 0xD0, 0x41, "AMIGO TECHNOLOGY CO., LTD."}, {
	0x00, 0xD0, 0x42, "MAHLO GMBH & CO. UG"}, {
	0x00, 0xD0, 0x43, "ZONAL RETAIL DATA SYSTEMS"}, {
	0x00, 0xD0, 0x44, "ALIDIAN NETWORKS, INC."}, {
	0x00, 0xD0, 0x45, "KVASER AB"}, {
	0x00, 0xD0, 0x46, "DOLBY LABORATORIES, INC."}, {
	0x00, 0xD0, 0x47, "XN TECHNOLOGIES"}, {
	0x00, 0xD0, 0x48, "ECTON, INC."}, {
	0x00, 0xD0, 0x49, "IMPRESSTEK CO., LTD."}, {
	0x00, 0xD0, 0x4A, "PRESENCE TECHNOLOGY GMBH"}, {
	0x00, 0xD0, 0x4B, "LA CIE GROUP S.A."}, {
	0x00, 0xD0, 0x4C, "EUROTEL TELECOM LTD."}, {
	0x00, 0xD0, 0x4D, "DIV OF RESEARCH & STATISTICS"}, {
	0x00, 0xD0, 0x4E, "LOGIBAG"}, {
	0x00, 0xD0, 0x4F, "BITRONICS, INC."}, {
	0x00, 0xD0, 0x50, "ISKRATEL"}, {
	0x00, 0xD0, 0x51, "O2 MICRO, INC."}, {
	0x00, 0xD0, 0x52, "ASCEND COMMUNICATIONS, INC."}, {
	0x00, 0xD0, 0x53, "CONNECTED SYSTEMS"}, {
	0x00, 0xD0, 0x54, "SAS INSTITUTE INC."}, {
	0x00, 0xD0, 0x55, "KATHREIN-WERKE KG"}, {
	0x00, 0xD0, 0x56, "SOMAT CORPORATION"}, {
	0x00, 0xD0, 0x57, "ULTRAK, INC."}, {
	0x00, 0xD0, 0x58, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0x59, "AMBIT MICROSYSTEMS CORP."}, {
	0x00, 0xD0, 0x5A, "SYMBIONICS, LTD."}, {
	0x00, 0xD0, 0x5B, "ACROLOOP MOTION CONTROL"}, {
	0x00, 0xD0, 0x5C, "TECHNOTREND SYSTEMTECHNIK GMBH"}, {
	0x00, 0xD0, 0x5D, "INTELLIWORXX, INC."}, {
	0x00, 0xD0, 0x5E, "STRATABEAM TECHNOLOGY, INC."}, {
	0x00, 0xD0, 0x5F, "VALCOM, INC."}, {
	0x00, 0xD0, 0x60, "PANASONIC EUROPEAN"}, {
	0x00, 0xD0, 0x61, "TREMON ENTERPRISES CO., LTD."}, {
	0x00, 0xD0, 0x62, "DIGIGRAM"}, {
	0x00, 0xD0, 0x63, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0x64, "MULTITEL"}, {
	0x00, 0xD0, 0x65, "TOKO ELECTRIC"}, {
	0x00, 0xD0, 0x66, "WINTRISS ENGINEERING CORP."}, {
	0x00, 0xD0, 0x67, "CAMPIO COMMUNICATIONS"}, {
	0x00, 0xD0, 0x68, "IWILL CORPORATION"}, {
	0x00, 0xD0, 0x69, "TECHNOLOGIC SYSTEMS"}, {
	0x00, 0xD0, 0x6A, "LINKUP SYSTEMS CORPORATION"}, {
	0x00, 0xD0, 0x6B, "SR TELECOM INC."}, {
	0x00, 0xD0, 0x6C, "SHAREWAVE, INC."}, {
	0x00, 0xD0, 0x6D, "ACRISON, INC."}, {
	0x00, 0xD0, 0x6E, "TRENDVIEW RECORDERS LTD."}, {
	0x00, 0xD0, 0x6F, "KMC CONTROLS"}, {
	0x00, 0xD0, 0x70, "LONG WELL ELECTRONICS CORP."}, {
	0x00, 0xD0, 0x71, "ECHELON CORP."}, {
	0x00, 0xD0, 0x72, "BROADLOGIC"}, {
	0x00, 0xD0, 0x73, "ACN ADVANCED COMMUNICATIONS"}, {
	0x00, 0xD0, 0x74, "TAQUA SYSTEMS, INC."}, {
	0x00, 0xD0, 0x75, "ALARIS MEDICAL SYSTEMS, INC."}, {
	0x00, 0xD0, 0x76, "MERRILL LYNCH & CO., INC."}, {
	0x00, 0xD0, 0x77, "LUCENT TECHNOLOGIES"}, {
	0x00, 0xD0, 0x78, "ELTEX OF SWEDEN AB"}, {
	0x00, 0xD0, 0x79, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0x7A, "AMAQUEST COMPUTER CORP."}, {
	0x00, 0xD0, 0x7B, "COMCAM INTERNATIONAL LTD."}, {
	0x00, 0xD0, 0x7C, "KOYO ELECTRONICS INC. CO.,LTD."}, {
	0x00, 0xD0, 0x7D, "COSINE COMMUNICATIONS"}, {
	0x00, 0xD0, 0x7E, "KEYCORP LTD."}, {
	0x00, 0xD0, 0x7F, "STRATEGY & TECHNOLOGY, LIMITED"}, {
	0x00, 0xD0, 0x80, "EXABYTE CORPORATION"}, {
	0x00, 0xD0, 0x81, "REAL TIME DEVICES USA, INC."}, {
	0x00, 0xD0, 0x82, "IOWAVE INC."}, {
	0x00, 0xD0, 0x83, "INVERTEX, INC."}, {
	0x00, 0xD0, 0x84, "NEXCOMM SYSTEMS, INC."}, {
	0x00, 0xD0, 0x85, "OTIS ELEVATOR COMPANY"}, {
	0x00, 0xD0, 0x86, "FOVEON, INC."}, {
	0x00, 0xD0, 0x87, "MICROFIRST INC."}, {
	0x00, 0xD0, 0x88, "MAINSAIL NETWORKS, INC."}, {
	0x00, 0xD0, 0x89, "DYNACOLOR, INC."}, {
	0x00, 0xD0, 0x8A, "PHOTRON USA"}, {
	0x00, 0xD0, 0x8B, "ADVA Limited"}, {
	0x00, 0xD0, 0x8C, "GENOA TECHNOLOGY, INC."}, {
	0x00, 0xD0, 0x8D, "PHOENIX GROUP, INC."}, {
	0x00, 0xD0, 0x8E, "NVISION INC."}, {
	0x00, 0xD0, 0x8F, "ARDENT TECHNOLOGIES, INC."}, {
	0x00, 0xD0, 0x90, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0x91, "SMARTSAN SYSTEMS, INC."}, {
	0x00, 0xD0, 0x92, "GLENAYRE WESTERN MULTIPLEX"}, {
	0x00, 0xD0, 0x93, "TQ - COMPONENTS GMBH"}, {
	0x00, 0xD0, 0x94, "TIMELINE VISTA, INC."}, {
	0x00, 0xD0, 0x95, "XYLAN CORPORATION"}, {
	0x00, 0xD0, 0x96, "3COM EUROPE LTD."}, {
	0x00, 0xD0, 0x97, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0x98, "Photon Dynamics Canada Inc."}, {
	0x00, 0xD0, 0x99, "ELCARD OY"}, {
	0x00, 0xD0, 0x9A, "FILANET CORPORATION"}, {
	0x00, 0xD0, 0x9B, "SPECTEL LTD."}, {
	0x00, 0xD0, 0x9C, "KAPADIA COMMUNICATIONS"}, {
	0x00, 0xD0, 0x9D, "VERIS INDUSTRIES"}, {
	0x00, 0xD0, 0x9E, "2WIRE, INC."}, {
	0x00, 0xD0, 0x9F, "NOVTEK TEST SYSTEMS"}, {
	0x00, 0xD0, 0xA0, "MIPS DENMARK"}, {
	0x00, 0xD0, 0xA1, "OSKAR VIERLING GMBH + CO. KG"}, {
	0x00, 0xD0, 0xA2, "INTEGRATED DEVICE"}, {
	0x00, 0xD0, 0xA3, "VOCAL DATA, INC."}, {
	0x00, 0xD0, 0xA4, "ALANTRO COMMUNICATIONS"}, {
	0x00, 0xD0, 0xA5, "AMERICAN ARIUM"}, {
	0x00, 0xD0, 0xA6, "LANBIRD TECHNOLOGY CO., LTD."}, {
	0x00, 0xD0, 0xA7, "TOKYO SOKKI KENKYUJO CO., LTD."}, {
	0x00, 0xD0, 0xA8, "NETWORK ENGINES, INC."}, {
	0x00, 0xD0, 0xA9, "SHINANO KENSHI CO., LTD."}, {
	0x00, 0xD0, 0xAA, "CHASE COMMUNICATIONS"}, {
	0x00, 0xD0, 0xAB, "DELTAKABEL TELECOM CV"}, {
	0x00, 0xD0, 0xAC, "GRAYSON WIRELESS"}, {
	0x00, 0xD0, 0xAD, "TL INDUSTRIES"}, {
	0x00, 0xD0, 0xAE, "ORESIS COMMUNICATIONS, INC."}, {
	0x00, 0xD0, 0xAF, "CUTLER-HAMMER, INC."}, {
	0x00, 0xD0, 0xB0, "BITSWITCH LTD."}, {
	0x00, 0xD0, 0xB1, "OMEGA ELECTRONICS SA"}, {
	0x00, 0xD0, 0xB2, "XIOTECH CORPORATION"}, {
	0x00, 0xD0, 0xB3, "DRS FLIGHT SAFETY AND"}, {
	0x00, 0xD0, 0xB4, "KATSUJIMA CO., LTD."}, {
	0x00, 0xD0, 0xB5, "DOTCOM"}, {
	0x00, 0xD0, 0xB6, "CRESCENT NETWORKS, INC."}, {
	0x00, 0xD0, 0xB7, "INTEL CORPORATION"}, {
	0x00, 0xD0, 0xB8, "IOMEGA CORP."}, {
	0x00, 0xD0, 0xB9, "MICROTEK INTERNATIONAL, INC."}, {
	0x00, 0xD0, 0xBA, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0xBB, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0xBC, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0xBD, "SICAN GMBH"}, {
	0x00, 0xD0, 0xBE, "EMUTEC INC."}, {
	0x00, 0xD0, 0xBF, "PIVOTAL TECHNOLOGIES"}, {
	0x00, 0xD0, 0xC0, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0xC1, "HARMONIC DATA SYSTEMS, LTD."}, {
	0x00, 0xD0, 0xC2, "BALTHAZAR TECHNOLOGY AB"}, {
	0x00, 0xD0, 0xC3, "VIVID TECHNOLOGY PTE, LTD."}, {
	0x00, 0xD0, 0xC4, "TERATECH CORPORATION"}, {
	0x00, 0xD0, 0xC5, "COMPUTATIONAL SYSTEMS, INC."}, {
	0x00, 0xD0, 0xC6, "THOMAS & BETTS CORP."}, {
	0x00, 0xD0, 0xC7, "PATHWAY, INC."}, {
	0x00, 0xD0, 0xC8, "I/O CONSULTING A/S"}, {
	0x00, 0xD0, 0xC9, "ADVANTECH CO., LTD."}, {
	0x00, 0xD0, 0xCA, "INTRINSYC SOFTWARE INC."}, {
	0x00, 0xD0, 0xCB, "DASAN CO., LTD."}, {
	0x00, 0xD0, 0xCC, "TECHNOLOGIES LYRE INC."}, {
	0x00, 0xD0, 0xCD, "ATAN TECHNOLOGY INC."}, {
	0x00, 0xD0, 0xCE, "ASYST ELECTRONIC"}, {
	0x00, 0xD0, 0xCF, "MORETON BAY"}, {
	0x00, 0xD0, 0xD0, "ZHONGXING TELECOM LTD."}, {
	0x00, 0xD0, 0xD1, "SIROCCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0xD2, "EPILOG CORPORATION"}, {
	0x00, 0xD0, 0xD3, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0xD4, "V-BITS, INC."}, {
	0x00, 0xD0, 0xD5, "GRUNDIG AG"}, {
	0x00, 0xD0, 0xD6, "AETHRA TELECOMUNICAZIONI"}, {
	0x00, 0xD0, 0xD7, "B2C2, INC."}, {
	0x00, 0xD0, 0xD8, "3Com Corporation"}, {
	0x00, 0xD0, 0xD9, "DEDICATED MICROCOMPUTERS"}, {
	0x00, 0xD0, 0xDA, "TAICOM DATA SYSTEMS CO., LTD."}, {
	0x00, 0xD0, 0xDB, "MCQUAY INTERNATIONAL"}, {
	0x00, 0xD0, 0xDC, "MODULAR MINING SYSTEMS, INC."}, {
	0x00, 0xD0, 0xDD, "SUNRISE TELECOM, INC."}, {
	0x00, 0xD0, 0xDE, "PHILIPS MULTIMEDIA NETWORK"}, {
	0x00, 0xD0, 0xDF, "KUZUMI ELECTRONICS, INC."}, {
	0x00, 0xD0, 0xE0, "DOOIN ELECTRONICS CO."}, {
	0x00, 0xD0, 0xE1, "AVIONITEK ISRAEL INC."}, {
	0x00, 0xD0, 0xE2, "MRT MICRO, INC."}, {
	0x00, 0xD0, 0xE3, "ELE-CHEM ENGINEERING CO., LTD."}, {
	0x00, 0xD0, 0xE4, "CISCO SYSTEMS, INC."}, {
	0x00, 0xD0, 0xE5, "SOLIDUM SYSTEMS CORP."}, {
	0x00, 0xD0, 0xE6, "IBOND INC."}, {
	0x00, 0xD0, 0xE7, "VCON TELECOMMUNICATION LTD."}, {
	0x00, 0xD0, 0xE8, "MAC SYSTEM CO., LTD."}, {
	0x00, 0xD0, 0xE9, "ADVANTAGE CENTURY"}, {
	0x00, 0xD0, 0xEA, "NEXTONE COMMUNICATIONS, INC."}, {
	0x00, 0xD0, 0xEB, "LIGHTERA NETWORKS, INC."}, {
	0x00, 0xD0, 0xEC, "NAKAYO TELECOMMUNICATIONS, INC"}, {
	0x00, 0xD0, 0xED, "XIOX"}, {
	0x00, 0xD0, 0xEE, "DICTAPHONE CORPORATION"}, {
	0x00, 0xD0, 0xEF, "IGT"}, {
	0x00, 0xD0, 0xF0, "CONVISION TECHNOLOGY GMBH"}, {
	0x00, 0xD0, 0xF1, "SEGA ENTERPRISES, LTD."}, {
	0x00, 0xD0, 0xF2, "MONTEREY NETWORKS"}, {
	0x00, 0xD0, 0xF3, "SOLARI DI UDINE SPA"}, {
	0x00, 0xD0, 0xF4, "CARINTHIAN TECH INSTITUTE"}, {
	0x00, 0xD0, 0xF5, "ORANGE MICRO, INC."}, {
	0x00, 0xD0, 0xF6, "Alcatel Canada"}, {
	0x00, 0xD0, 0xF7, "NEXT NETS CORPORATION"}, {
	0x00, 0xD0, 0xF8, "FUJIAN STAR TERMINAL"}, {
	0x00, 0xD0, 0xF9, "ACUTE COMMUNICATIONS CORP."}, {
	0x00, 0xD0, 0xFA, "RACAL GUARDATA"}, {
	0x00, 0xD0, 0xFB, "TEK MICROSYSTEMS, INCORPORATED"}, {
	0x00, 0xD0, 0xFC, "GRANITE MICROSYSTEMS"}, {
	0x00, 0xD0, 0xFD, "OPTIMA TELE.COM, INC."}, {
	0x00, 0xD0, 0xFE, "ASTRAL POINT"}, {
	0x00, 0xD0, 0xFF, "CISCO SYSTEMS, INC."}, {
	0x00, 0xDD, 0x00, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x01, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x02, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x03, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x04, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x05, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x06, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x07, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x08, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x09, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x0A, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x0B, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x0C, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x0D, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x0E, "UNGERMANN-BASS INC."}, {
	0x00, 0xDD, 0x0F, "UNGERMANN-BASS INC."}, {
	0x00, 0xE0, 0x00, "FUJITSU, LTD"}, {
	0x00, 0xE0, 0x01, "STRAND LIGHTING LIMITED"}, {
	0x00, 0xE0, 0x02, "CROSSROADS SYSTEMS, INC."}, {
	0x00, 0xE0, 0x03, "NOKIA WIRELESS BUSINESS COMMUN"}, {
	0x00, 0xE0, 0x04, "PMC-SIERRA, INC."}, {
	0x00, 0xE0, 0x05, "TECHNICAL CORP."}, {
	0x00, 0xE0, 0x06, "SILICON INTEGRATED SYS. CORP."}, {
	0x00, 0xE0, 0x07, "NETWORK ALCHEMY LTD."}, {
	0x00, 0xE0, 0x08, "AMAZING CONTROLS! INC."}, {
	0x00, 0xE0, 0x09, "MARATHON TECHNOLOGIES CORP."}, {
	0x00, 0xE0, 0x0A, "DIBA, INC."}, {
	0x00, 0xE0, 0x0B, "ROOFTOP COMMUNICATIONS CORP."}, {
	0x00, 0xE0, 0x0C, "MOTOROLA"}, {
	0x00, 0xE0, 0x0D, "RADIANT SYSTEMS"}, {
	0x00, 0xE0, 0x0E, "AVALON IMAGING SYSTEMS, INC."}, {
	0x00, 0xE0, 0x0F, "SHANGHAI BAUD DATA"}, {
	0x00, 0xE0, 0x10, "HESS SB-AUTOMATENBAU GmbH"}, {
	0x00, 0xE0, 0x11, "UNIDEN SAN DIEGO R&D CENTER, INC."}, {
	0x00, 0xE0, 0x12, "PLUTO TECHNOLOGIES INTERNATIONAL INC."}, {
	0x00, 0xE0, 0x13, "EASTERN ELECTRONIC CO., LTD."}, {
	0x00, 0xE0, 0x14, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0x15, "HEIWA CORPORATION"}, {
	0x00, 0xE0, 0x16, "RAPID CITY COMMUNICATIONS"}, {
	0x00, 0xE0, 0x17, "EXXACT GmbH"}, {
	0x00, 0xE0, 0x18, "ASUSTEK COMPUTER INC."}, {
	0x00, 0xE0, 0x19, "ING. GIORDANO ELETTRONICA"}, {
	0x00, 0xE0, 0x1A, "COMTEC SYSTEMS. CO., LTD."}, {
	0x00, 0xE0, 0x1B, "SPHERE COMMUNICATIONS, INC."}, {
	0x00, 0xE0, 0x1C, "MOBILITY ELECTRONICSY"}, {
	0x00, 0xE0, 0x1D, "WebTV NETWORKS, INC."}, {
	0x00, 0xE0, 0x1E, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0x1F, "AVIDIA Systems, Inc."}, {
	0x00, 0xE0, 0x20, "TECNOMEN OY"}, {
	0x00, 0xE0, 0x21, "FREEGATE CORP."}, {
	0x00, 0xE0, 0x22, "MediaLight, Inc."}, {
	0x00, 0xE0, 0x23, "TELRAD"}, {
	0x00, 0xE0, 0x24, "GADZOOX NETWORKS"}, {
	0x00, 0xE0, 0x25, "dit CO., LTD."}, {
	0x00, 0xE0, 0x26, "EASTMAN KODAK CO."}, {
	0x00, 0xE0, 0x27, "DUX, INC."}, {
	0x00, 0xE0, 0x28, "APTIX CORPORATION"}, {
	0x00, 0xE0, 0x29, "STANDARD MICROSYSTEMS CORP."}, {
	0x00, 0xE0, 0x2A, "TANDBERG TELEVISION AS"}, {
	0x00, 0xE0, 0x2B, "EXTREME NETWORKS"}, {
	0x00, 0xE0, 0x2C, "AST COMPUTER"}, {
	0x00, 0xE0, 0x2D, "InnoMediaLogic, Inc."}, {
	0x00, 0xE0, 0x2E, "SPC ELECTRONICS CORPORATION"}, {
	0x00, 0xE0, 0x2F, "MCNS HOLDINGS, L.P."}, {
	0x00, 0xE0, 0x30, "MELITA INTERNATIONAL CORP."}, {
	0x00, 0xE0, 0x31, "HAGIWARA ELECTRIC CO., LTD."}, {
	0x00, 0xE0, 0x32, "MISYS FINANCIAL SYSTEMS, LTD."}, {
	0x00, 0xE0, 0x33, "E.E.P.D. GmbH"}, {
	0x00, 0xE0, 0x34, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0x35, "LOUGHBOROUGH SOUND IMAGES, PLC"}, {
	0x00, 0xE0, 0x36, "PIONEER CORPORATION"}, {
	0x00, 0xE0, 0x37, "CENTURY CORPORATION"}, {
	0x00, 0xE0, 0x38, "PROXIMA CORPORATION"}, {
	0x00, 0xE0, 0x39, "PARADYNE CORP."}, {
	0x00, 0xE0, 0x3A, "CABLETRON SYSTEMS, INC."}, {
	0x00, 0xE0, 0x3B, "PROMINET CORPORATION"}, {
	0x00, 0xE0, 0x3C, "AdvanSys"}, {
	0x00, 0xE0, 0x3D, "FOCON ELECTRONIC SYSTEMS A/S"}, {
	0x00, 0xE0, 0x3E, "ALFATECH, INC."}, {
	0x00, 0xE0, 0x3F, "JATON CORPORATION"}, {
	0x00, 0xE0, 0x40, "DeskStation Technology, Inc."}, {
	0x00, 0xE0, 0x41, "CSPI"}, {
	0x00, 0xE0, 0x42, "Pacom Systems Ltd."}, {
	0x00, 0xE0, 0x43, "VitalCom"}, {
	0x00, 0xE0, 0x44, "LSICS CORPORATION"}, {
	0x00, 0xE0, 0x45, "TOUCHWAVE, INC."}, {
	0x00, 0xE0, 0x46, "BENTLY NEVADA CORP."}, {
	0x00, 0xE0, 0x47, "INFOCUS SYSTEMS"}, {
	0x00, 0xE0, 0x48, "SDL COMMUNICATIONS, INC."}, {
	0x00, 0xE0, 0x49, "MICROWI ELECTRONIC GmbH"}, {
	0x00, 0xE0, 0x4A, "ENHANCED MESSAGING SYSTEMS, INC"}, {
	0x00, 0xE0, 0x4B, "JUMP INDUSTRIELLE COMPUTERTECHNIK GmbH"}, {
	0x00, 0xE0, 0x4C, "REALTEK SEMICONDUCTOR CORP."}, {
	0x00, 0xE0, 0x4D, "INTERNET INITIATIVE JAPAN, INC"}, {
	0x00, 0xE0, 0x4E, "SANYO DENKI CO., LTD."}, {
	0x00, 0xE0, 0x4F, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0x50, "EXECUTONE INFORMATION SYSTEMS, INC."}, {
	0x00, 0xE0, 0x51, "TALX CORPORATION"}, {
	0x00, 0xE0, 0x52, "FOUNDRY NETWORKS, INC."}, {
	0x00, 0xE0, 0x53, "CELLPORT LABS, INC."}, {
	0x00, 0xE0, 0x54, "KODAI HITEC CO., LTD."}, {
	0x00, 0xE0, 0x55, "INGENIERIA ELECTRONICA COMERCIAL INELCOM S.A."},
	{
	0x00, 0xE0, 0x56, "HOLONTECH CORPORATION"}, {
	0x00, 0xE0, 0x57, "HAN MICROTELECOM. CO., LTD."}, {
	0x00, 0xE0, 0x58, "PHASE ONE DENMARK A/S"}, {
	0x00, 0xE0, 0x59, "CONTROLLED ENVIRONMENTS, LTD."}, {
	0x00, 0xE0, 0x5A, "GALEA NETWORK SECURITY"}, {
	0x00, 0xE0, 0x5B, "WEST END SYSTEMS CORP."}, {
	0x00, 0xE0, 0x5C,
		"MATSUSHITA KOTOBUKI ELECTRONICS INDUSTRIES, LTD."}, {
	0x00, 0xE0, 0x5D, "UNITEC CO., LTD."}, {
	0x00, 0xE0, 0x5E, "JAPAN AVIATION ELECTRONICS INDUSTRY, LTD."}, {
	0x00, 0xE0, 0x5F, "e-Net, Inc."}, {
	0x00, 0xE0, 0x60, "SHERWOOD"}, {
	0x00, 0xE0, 0x61, "EdgePoint Networks, Inc."}, {
	0x00, 0xE0, 0x62, "HOST ENGINEERING"}, {
	0x00, 0xE0, 0x63, "CABLETRON - YAGO SYSTEMS, INC."}, {
	0x00, 0xE0, 0x64, "SAMSUNG ELECTRONICS"}, {
	0x00, 0xE0, 0x65, "OPTICAL ACCESS INTERNATIONAL"}, {
	0x00, 0xE0, 0x66, "ProMax Systems, Inc."}, {
	0x00, 0xE0, 0x67, "eac AUTOMATION-CONSULTING GmbH"}, {
	0x00, 0xE0, 0x68, "MERRIMAC SYSTEMS INC."}, {
	0x00, 0xE0, 0x69, "JAYCOR"}, {
	0x00, 0xE0, 0x6A, "KAPSCH AG"}, {
	0x00, 0xE0, 0x6B, "W&G SPECIAL PRODUCTS"}, {
	0x00, 0xE0, 0x6C, "BALTIMORE TECHNOLOGIES, LTD."}, {
	0x00, 0xE0, 0x6D, "COMPUWARE CORPORATION"}, {
	0x00, 0xE0, 0x6E, "FAR SYSTEMS S.p.A."}, {
	0x00, 0xE0, 0x6F, "TERAYON CORP."}, {
	0x00, 0xE0, 0x70, "DH TECHNOLOGY"}, {
	0x00, 0xE0, 0x71, "EPIS MICROCOMPUTER"}, {
	0x00, 0xE0, 0x72, "LYNK"}, {
	0x00, 0xE0, 0x73, "NATIONAL AMUSEMENT NETWORK, INC."}, {
	0x00, 0xE0, 0x74, "TIERNAN COMMUNICATIONS, INC."}, {
	0x00, 0xE0, 0x75, "ATLAS COMPUTER EQUIPMENT, INC."}, {
	0x00, 0xE0, 0x76, "DEVELOPMENT CONCEPTS, INC."}, {
	0x00, 0xE0, 0x77, "WEBGEAR, INC."}, {
	0x00, 0xE0, 0x78, "BERKELEY NETWORKS"}, {
	0x00, 0xE0, 0x79, "A.T.N.R."}, {
	0x00, 0xE0, 0x7A, "MIKRODIDAKT AB"}, {
	0x00, 0xE0, 0x7B, "BAY NETWORKS"}, {
	0x00, 0xE0, 0x7C, "METTLER-TOLEDO, INC."}, {
	0x00, 0xE0, 0x7D, "NETRONIX, INC."}, {
	0x00, 0xE0, 0x7E, "WALT DISNEY IMAGINEERING"}, {
	0x00, 0xE0, 0x7F, "LOGISTISTEM s.r.l."}, {
	0x00, 0xE0, 0x80, "CONTROL RESOURCES CORPORATION"}, {
	0x00, 0xE0, 0x81, "TYAN COMPUTER CORP."}, {
	0x00, 0xE0, 0x82, "ANERMA"}, {
	0x00, 0xE0, 0x83, "JATO TECHNOLOGIES, INC."}, {
	0x00, 0xE0, 0x84, "COMPULITE R&D"}, {
	0x00, 0xE0, 0x85, "GLOBAL MAINTECH, INC."}, {
	0x00, 0xE0, 0x86, "CYBEX COMPUTER PRODUCTS"}, {
	0x00, 0xE0, 0x87, "LeCroy - Networking Productions Division"}, {
	0x00, 0xE0, 0x88, "LTX CORPORATION"}, {
	0x00, 0xE0, 0x89, "ION Networks, Inc."}, {
	0x00, 0xE0, 0x8A, "GEC AVERY, LTD."}, {
	0x00, 0xE0, 0x8B, "QLogic Corp."}, {
	0x00, 0xE0, 0x8C, "NEOPARADIGM LABS, INC."}, {
	0x00, 0xE0, 0x8D, "PRESSURE SYSTEMS, INC."}, {
	0x00, 0xE0, 0x8E, "UTSTARCOM"}, {
	0x00, 0xE0, 0x8F, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0x90, "BECKMAN LAB. AUTOMATION DIV."}, {
	0x00, 0xE0, 0x91, "LG ELECTRONICS, INC."}, {
	0x00, 0xE0, 0x92, "ADMTEK INCORPORATED"}, {
	0x00, 0xE0, 0x93, "ACKFIN NETWORKS"}, {
	0x00, 0xE0, 0x94, "OSAI SRL"}, {
	0x00, 0xE0, 0x95, "ADVANCED-VISION TECHNOLGIES CORP."}, {
	0x00, 0xE0, 0x96, "SHIMADZU CORPORATION"}, {
	0x00, 0xE0, 0x97, "CARRIER ACCESS CORPORATION"}, {
	0x00, 0xE0, 0x98, "AboCom Systems, Inc."}, {
	0x00, 0xE0, 0x99, "SAMSON AG"}, {
	0x00, 0xE0, 0x9A, "POSITRON INDUSTRIES, INC."}, {
	0x00, 0xE0, 0x9B, "ENGAGE NETWORKS, INC."}, {
	0x00, 0xE0, 0x9C, "MII"}, {
	0x00, 0xE0, 0x9D, "SARNOFF CORPORATION"}, {
	0x00, 0xE0, 0x9E, "QUANTUM CORPORATION"}, {
	0x00, 0xE0, 0x9F, "PIXEL VISION"}, {
	0x00, 0xE0, 0xA0, "WILTRON CO."}, {
	0x00, 0xE0, 0xA1, "HIMA PAUL HILDEBRANDT GmbH Co. KG"}, {
	0x00, 0xE0, 0xA2, "MICROSLATE INC."}, {
	0x00, 0xE0, 0xA3, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0xA4, "ESAOTE S.p.A."}, {
	0x00, 0xE0, 0xA5, "ComCore Semiconductor, Inc."}, {
	0x00, 0xE0, 0xA6, "TELOGY NETWORKS, INC."}, {
	0x00, 0xE0, 0xA7, "IPC INFORMATION SYSTEMS, INC."}, {
	0x00, 0xE0, 0xA8, "SAT GmbH & Co."}, {
	0x00, 0xE0, 0xA9, "FUNAI ELECTRIC CO., LTD."}, {
	0x00, 0xE0, 0xAA, "ELECTROSONIC LTD."}, {
	0x00, 0xE0, 0xAB, "DIMAT S.A."}, {
	0x00, 0xE0, 0xAC, "MIDSCO, INC."}, {
	0x00, 0xE0, 0xAD, "EES TECHNOLOGY, LTD."}, {
	0x00, 0xE0, 0xAE, "XAQTI CORPORATION"}, {
	0x00, 0xE0, 0xAF, "GENERAL DYNAMICS INFORMATION SYSTEMS"}, {
	0x00, 0xE0, 0xB0, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0xB1, "PACKET ENGINES, INC."}, {
	0x00, 0xE0, 0xB2, "TELMAX COMMUNICATIONS CORP."}, {
	0x00, 0xE0, 0xB3, "EtherWAN Systems, Inc."}, {
	0x00, 0xE0, 0xB4, "TECHNO SCOPE CO., LTD."}, {
	0x00, 0xE0, 0xB5, "ARDENT COMMUNICATIONS CORP."}, {
	0x00, 0xE0, 0xB6, "Entrada Networks"}, {
	0x00, 0xE0, 0xB7, "PI GROUP, LTD."}, {
	0x00, 0xE0, 0xB8, "GATEWAY 2000"}, {
	0x00, 0xE0, 0xB9, "BYAS SYSTEMS"}, {
	0x00, 0xE0, 0xBA, "BERGHOF AUTOMATIONSTECHNIK GmbH"}, {
	0x00, 0xE0, 0xBB, "NBX CORPORATION"}, {
	0x00, 0xE0, 0xBC, "SYMON COMMUNICATIONS, INC."}, {
	0x00, 0xE0, 0xBD, "INTERFACE SYSTEMS, INC."}, {
	0x00, 0xE0, 0xBE, "GENROCO INTERNATIONAL, INC."}, {
	0x00, 0xE0, 0xBF, "TORRENT NETWORKING TECHNOLOGIES CORP."}, {
	0x00, 0xE0, 0xC0, "SEIWA ELECTRIC MFG. CO., LTD."}, {
	0x00, 0xE0, 0xC1, "MEMOREX TELEX JAPAN, LTD."}, {
	0x00, 0xE0, 0xC2, "NECSY S.p.A."}, {
	0x00, 0xE0, 0xC3, "SAKAI SYSTEM DEVELOPMENT CORP."}, {
	0x00, 0xE0, 0xC4, "HORNER ELECTRIC, INC."}, {
	0x00, 0xE0, 0xC5, "BCOM ELECTRONICS INC."}, {
	0x00, 0xE0, 0xC6, "LINK2IT, L.L.C."}, {
	0x00, 0xE0, 0xC7, "EUROTECH SRL"}, {
	0x00, 0xE0, 0xC8, "VIRTUAL ACCESS, LTD."}, {
	0x00, 0xE0, 0xC9, "AutomatedLogic Corporation"}, {
	0x00, 0xE0, 0xCA, "BEST DATA PRODUCTS"}, {
	0x00, 0xE0, 0xCB, "RESON, INC."}, {
	0x00, 0xE0, 0xCC, "HERO SYSTEMS, LTD."}, {
	0x00, 0xE0, 0xCD, "SENSIS CORPORATION"}, {
	0x00, 0xE0, 0xCE, "ARN"}, {
	0x00, 0xE0, 0xCF, "INTEGRATED DEVICE TECHNOLOGY, INC."}, {
	0x00, 0xE0, 0xD0, "NETSPEED, INC."}, {
	0x00, 0xE0, 0xD1, "TELSIS LIMITED"}, {
	0x00, 0xE0, 0xD2, "VERSANET COMMUNICATIONS, INC."}, {
	0x00, 0xE0, 0xD3, "DATENTECHNIK GmbH"}, {
	0x00, 0xE0, 0xD4, "EXCELLENT COMPUTER"}, {
	0x00, 0xE0, 0xD5, "ARCXEL TECHNOLOGIES, INC."}, {
	0x00, 0xE0, 0xD6, "COMPUTER & COMMUNICATION RESEARCH LAB."}, {
	0x00, 0xE0, 0xD7, "SUNSHINE ELECTRONICS, INC."}, {
	0x00, 0xE0, 0xD8, "LANBit Computer, Inc."}, {
	0x00, 0xE0, 0xD9, "TAZMO CO., LTD."}, {
	0x00, 0xE0, 0xDA, "ASSURED ACCESS TECHNOLOGY, INC."}, {
	0x00, 0xE0, 0xDB, "ViaVideo Communications, Inc."}, {
	0x00, 0xE0, 0xDC, "NEXWARE CORP."}, {
	0x00, 0xE0, 0xDD, "ZENITH ELECTRONICS CORPORATION"}, {
	0x00, 0xE0, 0xDE, "DATAX NV"}, {
	0x00, 0xE0, 0xDF, "KE KOMMUNIKATIONS-ELECTRONIK"}, {
	0x00, 0xE0, 0xE0, "SI ELECTRONICS, LTD."}, {
	0x00, 0xE0, 0xE1, "G2 NETWORKS, INC."}, {
	0x00, 0xE0, 0xE2, "INNOVA CORP."}, {
	0x00, 0xE0, 0xE3, "SK-ELEKTRONIK GmbH"}, {
	0x00, 0xE0, 0xE4, "FANUC ROBOTICS NORTH AMERICA, Inc."}, {
	0x00, 0xE0, 0xE5, "CINCO NETWORKS, INC."}, {
	0x00, 0xE0, 0xE6, "INCAA DATACOM B.V."}, {
	0x00, 0xE0, 0xE7, "RAYTHEON E-SYSTEMS, INC."}, {
	0x00, 0xE0, 0xE8, "GRETACODER Data Systems AG"}, {
	0x00, 0xE0, 0xE9, "DATA LABS, INC."}, {
	0x00, 0xE0, 0xEA, "INNOVAT COMMUNICATIONS, INC."}, {
	0x00, 0xE0, 0xEB, "DIGICOM SYSTEMS, INCORPORATED"}, {
	0x00, 0xE0, 0xEC, "CELESTICA INC."}, {
	0x00, 0xE0, 0xED, "SILICOM, LTD."}, {
	0x00, 0xE0, 0xEE, "MAREL HF"}, {
	0x00, 0xE0, 0xEF, "DIONEX"}, {
	0x00, 0xE0, 0xF0, "ABLER TECHNOLOGY, INC."}, {
	0x00, 0xE0, 0xF1, "THAT CORPORATION"}, {
	0x00, 0xE0, 0xF2, "ARLOTTO COMNET, INC."}, {
	0x00, 0xE0, 0xF3, "WebSprint Communications, Inc."}, {
	0x00, 0xE0, 0xF4, "INSIDE Technology A/S"}, {
	0x00, 0xE0, 0xF5, "TELES AG"}, {
	0x00, 0xE0, 0xF6, "DECISION EUROPE"}, {
	0x00, 0xE0, 0xF7, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0xF8, "DICNA CONTROL AB"}, {
	0x00, 0xE0, 0xF9, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0xFA, "TRL TECHNOLOGY, LTD."}, {
	0x00, 0xE0, 0xFB, "LEIGHTRONIX, INC."}, {
	0x00, 0xE0, 0xFC, "HUAWEI TECHNOLOGIES CO., LTD."}, {
	0x00, 0xE0, 0xFD, "A-TREND TECHNOLOGY CO., LTD."}, {
	0x00, 0xE0, 0xFE, "CISCO SYSTEMS, INC."}, {
	0x00, 0xE0, 0xFF, "SECURITY DYNAMICS TECHNOLOGIES, Inc."}, {
	0x00, 0xE6, 0xD3, "NIXDORF COMPUTER CORP."}, {
	0x02, 0x07, 0x01, "RACAL-DATACOM"}, {
	0x02, 0x1C, 0x7C, "PERQ SYSTEMS CORPORATION"}, {
	0x02, 0x60, 0x86, "LOGIC REPLACEMENT TECH. LTD."}, {
	0x02, 0x60, 0x8C, "3COM CORPORATION"}, {
	0x02, 0x70, 0x01, "RACAL-DATACOM"}, {
	0x02, 0x70, 0xB0, "M/A-COM INC. COMPANIES"}, {
	0x02, 0x70, 0xB3, "DATA RECALL LTD"}, {
	0x02, 0x9D, 0x8E, "CARDIAC RECORDERS INC."}, {
	0x02, 0xAA, 0x3C, "OLIVETTI TELECOMM SPA (OLTECO)"}, {
	0x02, 0xBB, 0x01, "OCTOTHORPE CORP."}, {
	0x02, 0xC0, 0x8C, "3COM CORPORATION"}, {
	0x02, 0xCF, 0x1C, "COMMUNICATION MACHINERY CORP."}, {
	0x02, 0xE6, 0xD3, "NIXDORF COMPUTER CORPORATION"}, {
	0x04, 0x0A, 0xE0, "XMIT AG COMPUTER NETWORKS"}, {
	0x04, 0xE0, 0xC4, "TRIUMPH-ADLER AG"}, {
	0x08, 0x00, 0x01, "COMPUTERVISION CORPORATION"}, {
	0x08, 0x00, 0x02, "BRIDGE COMMUNICATIONS INC."}, {
	0x08, 0x00, 0x03, "ADVANCED COMPUTER COMM."}, {
	0x08, 0x00, 0x04, "CROMEMCO INCORPORATED"}, {
	0x08, 0x00, 0x05, "SYMBOLICS INC."}, {
	0x08, 0x00, 0x06, "SIEMENS AG"}, {
	0x08, 0x00, 0x07, "APPLE COMPUTER INC."}, {
	0x08, 0x00, 0x08, "BOLT BERANEK AND NEWMAN INC."}, {
	0x08, 0x00, 0x09, "HEWLETT PACKARD"}, {
	0x08, 0x00, 0x0A, "NESTAR SYSTEMS INCORPORATED"}, {
	0x08, 0x00, 0x0B, "UNISYS CORPORATION"}, {
	0x08, 0x00, 0x0C, "MIKLYN DEVELOPMENT CO."}, {
	0x08, 0x00, 0x0D, "INTERNATIONAL COMPUTERS LTD."}, {
	0x08, 0x00, 0x0E, "NCR CORPORATION"}, {
	0x08, 0x00, 0x0F, "MITEL CORPORATION"}, {
	0x08, 0x00, 0x11, "TEKTRONIX INC."}, {
	0x08, 0x00, 0x12, "BELL ATLANTIC INTEGRATED SYST."}, {
	0x08, 0x00, 0x13, "EXXON"}, {
	0x08, 0x00, 0x14, "EXCELAN"}, {
	0x08, 0x00, 0x15, "STC BUSINESS SYSTEMS"}, {
	0x08, 0x00, 0x16, "BARRISTER INFO SYS CORP"}, {
	0x08, 0x00, 0x17, "NATIONAL SEMICONDUCTOR"}, {
	0x08, 0x00, 0x18, "PIRELLI FOCOM NETWORKS"}, {
	0x08, 0x00, 0x19, "GENERAL ELECTRIC CORPORATION"}, {
	0x08, 0x00, 0x1A, "TIARA/ 10NET"}, {
	0x08, 0x00, 0x1B, "DATA GENERAL"}, {
	0x08, 0x00, 0x1C, "KDD-KOKUSAI DEBNSIN DENWA CO."}, {
	0x08, 0x00, 0x1D, "ABLE COMMUNICATIONS INC."}, {
	0x08, 0x00, 0x1E, "APOLLO COMPUTER INC."}, {
	0x08, 0x00, 0x1F, "SHARP CORPORATION"}, {
	0x08, 0x00, 0x20, "SUN MICROSYSTEMS INC."}, {
	0x08, 0x00, 0x21, "3M COMPANY"}, {
	0x08, 0x00, 0x22, "NBI INC."}, {
	0x08, 0x00, 0x23, "MATSUHITA GRAPHIC COMM SYS INC"}, {
	0x08, 0x00, 0x24, "10NET COMMUNICATIONS/DCA"}, {
	0x08, 0x00, 0x25, "CONTROL DATA"}, {
	0x08, 0x00, 0x26, "NORSK DATA A.S."}, {
	0x08, 0x00, 0x27, "CADMUS COMPUTER SYSTEMS"}, {
	0x08, 0x00, 0x28, "Texas Instruments"}, {
	0x08, 0x00, 0x29, "MEGATEK CORPORATION"}, {
	0x08, 0x00, 0x2A, "MOSAIC TECHNOLOGIES INC."}, {
	0x08, 0x00, 0x2B, "DIGITAL EQUIPMENT CORPORATION"}, {
	0x08, 0x00, 0x2C, "BRITTON LEE INC."}, {
	0x08, 0x00, 0x2D, "LAN-TEC INC."}, {
	0x08, 0x00, 0x2E, "METAPHOR COMPUTER SYSTEMS"}, {
	0x08, 0x00, 0x2F, "PRIME COMPUTER INC."}, {
	0x08, 0x00, 0x30, "NETWORK RESEARCH CORPORATION"}, {
	0x08, 0x00, 0x30, "CERN"}, {
	0x08, 0x00, 0x30, "ROYAL MELBOURNE INST OF TECH"}, {
	0x08, 0x00, 0x31, "LITTLE MACHINES INC."}, {
	0x08, 0x00, 0x32, "TIGAN INCORPORATED"}, {
	0x08, 0x00, 0x33, "BAUSCH & LOMB"}, {
	0x08, 0x00, 0x34, "FILENET CORPORATION"}, {
	0x08, 0x00, 0x35, "MICROFIVE CORPORATION"}, {
	0x08, 0x00, 0x36, "INTERGRAPH CORPORATION"}, {
	0x08, 0x00, 0x37, "FUJI-XEROX CO. LTD."}, {
	0x08, 0x00, 0x38, "CII HONEYWELL BULL"}, {
	0x08, 0x00, 0x39, "SPIDER SYSTEMS LIMITED"}, {
	0x08, 0x00, 0x3A, "ORCATECH INC."}, {
	0x08, 0x00, 0x3B, "TORUS SYSTEMS LIMITED"}, {
	0x08, 0x00, 0x3C, "SCHLUMBERGER WELL SERVICES"}, {
	0x08, 0x00, 0x3D, "CADNETIX CORPORATIONS"}, {
	0x08, 0x00, 0x3E, "CODEX CORPORATION"}, {
	0x08, 0x00, 0x3F, "FRED KOSCHARA ENTERPRISES"}, {
	0x08, 0x00, 0x40, "FERRANTI COMPUTER SYS. LIMITED"}, {
	0x08, 0x00, 0x41, "RACAL-MILGO INFORMATION SYS.."}, {
	0x08, 0x00, 0x42, "JAPAN MACNICS CORP."}, {
	0x08, 0x00, 0x43, "PIXEL COMPUTER INC."}, {
	0x08, 0x00, 0x44, "DAVID SYSTEMS INC."}, {
	0x08, 0x00, 0x45, "CONCURRENT COMPUTER CORP."}, {
	0x08, 0x00, 0x46, "SONY CORPORATION LTD."}, {
	0x08, 0x00, 0x47, "SEQUENT COMPUTER SYSTEMS INC."}, {
	0x08, 0x00, 0x48, "EUROTHERM GAUGING SYSTEMS"}, {
	0x08, 0x00, 0x49, "UNIVATION"}, {
	0x08, 0x00, 0x4A, "BANYAN SYSTEMS INC."}, {
	0x08, 0x00, 0x4B, "PLANNING RESEARCH CORP."}, {
	0x08, 0x00, 0x4C, "HYDRA COMPUTER SYSTEMS INC."}, {
	0x08, 0x00, 0x4D, "CORVUS SYSTEMS INC."}, {
	0x08, 0x00, 0x4E, "3COM EUROPE LTD."}, {
	0x08, 0x00, 0x4F, "CYGNET SYSTEMS"}, {
	0x08, 0x00, 0x50, "DAISY SYSTEMS CORP."}, {
	0x08, 0x00, 0x51, "EXPERDATA"}, {
	0x08, 0x00, 0x52, "INSYSTEC"}, {
	0x08, 0x00, 0x53, "MIDDLE EAST TECH. UNIVERSITY"}, {
	0x08, 0x00, 0x55, "STANFORD TELECOMM. INC."}, {
	0x08, 0x00, 0x56, "STANFORD LINEAR ACCEL. CENTER"}, {
	0x08, 0x00, 0x57, "EVANS & SUTHERLAND"}, {
	0x08, 0x00, 0x58, "SYSTEMS CONCEPTS"}, {
	0x08, 0x00, 0x59, "A/S MYCRON"}, {
	0x08, 0x00, 0x5A, "IBM CORPORATION"}, {
	0x08, 0x00, 0x5B, "VTA TECHNOLOGIES INC."}, {
	0x08, 0x00, 0x5C, "FOUR PHASE SYSTEMS"}, {
	0x08, 0x00, 0x5D, "GOULD INC."}, {
	0x08, 0x00, 0x5E, "COUNTERPOINT COMPUTER INC."}, {
	0x08, 0x00, 0x5F, "SABER TECHNOLOGY CORP."}, {
	0x08, 0x00, 0x60, "INDUSTRIAL NETWORKING INC."}, {
	0x08, 0x00, 0x61, "JAROGATE LTD."}, {
	0x08, 0x00, 0x62, "GENERAL DYNAMICS"}, {
	0x08, 0x00, 0x63, "PLESSEY"}, {
	0x08, 0x00, 0x64, "AUTOPHON AG"}, {
	0x08, 0x00, 0x65, "GENRAD INC."}, {
	0x08, 0x00, 0x66, "AGFA CORPORATION"}, {
	0x08, 0x00, 0x67, "COMDESIGN"}, {
	0x08, 0x00, 0x68, "RIDGE COMPUTERS"}, {
	0x08, 0x00, 0x69, "SILICON GRAPHICS INC."}, {
	0x08, 0x00, 0x6A, "ATT BELL LABORATORIES"}, {
	0x08, 0x00, 0x6B, "ACCEL TECHNOLOGIES INC."}, {
	0x08, 0x00, 0x6C, "SUNTEK TECHNOLOGY INT'L"}, {
	0x08, 0x00, 0x6D, "WHITECHAPEL COMPUTER WORKS"}, {
	0x08, 0x00, 0x6E, "MASSCOMP"}, {
	0x08, 0x00, 0x6F, "PHILIPS APELDOORN B.V."}, {
	0x08, 0x00, 0x70, "MITSUBISHI ELECTRIC CORP."}, {
	0x08, 0x00, 0x71, "MATRA (DSIE)"}, {
	0x08, 0x00, 0x72, "XEROX CORP UNIV GRANT PROGRAM"}, {
	0x08, 0x00, 0x73, "TECMAR INC."}, {
	0x08, 0x00, 0x74, "CASIO COMPUTER CO. LTD."}, {
	0x08, 0x00, 0x75, "DANSK DATA ELECTRONIK"}, {
	0x08, 0x00, 0x76, "PC LAN TECHNOLOGIES"}, {
	0x08, 0x00, 0x77, "TSL COMMUNICATIONS LTD."}, {
	0x08, 0x00, 0x78, "ACCELL CORPORATION"}, {
	0x08, 0x00, 0x79, "THE DROID WORKS"}, {
	0x08, 0x00, 0x7A, "INDATA"}, {
	0x08, 0x00, 0x7B, "SANYO ELECTRIC CO. LTD."}, {
	0x08, 0x00, 0x7C, "VITALINK COMMUNICATIONS CORP."}, {
	0x08, 0x00, 0x7E, "AMALGAMATED WIRELESS(AUS) LTD"}, {
	0x08, 0x00, 0x7F, "CARNEGIE-MELLON UNIVERSITY"}, {
	0x08, 0x00, 0x80, "AES DATA INC."}, {
	0x08, 0x00, 0x81, ",ASTECH INC."}, {
	0x08, 0x00, 0x82, "VERITAS SOFTWARE"}, {
	0x08, 0x00, 0x83, "SEIKO INSTRUM. AND ELECTRONICS"}, {
	0x08, 0x00, 0x84, "TOMEN ELECTRONICS CORP."}, {
	0x08, 0x00, 0x85, "ELXSI"}, {
	0x08, 0x00, 0x86, "IMAGEN CORPORATION"}, {
	0x08, 0x00, 0x87, "XYPLEX"}, {
	0x08, 0x00, 0x88, "MCDATA CORPORATION"}, {
	0x08, 0x00, 0x89, "KINETICS"}, {
	0x08, 0x00, 0x8A, "PERFORMANCE TECHNOLOGY"}, {
	0x08, 0x00, 0x8B, "PYRAMID TECHNOLOGY CORP."}, {
	0x08, 0x00, 0x8C, "NETWORK RESEARCH CORPORATION"}, {
	0x08, 0x00, 0x8D, "XYVISION INC."}, {
	0x08, 0x00, 0x8E, "TANDEM COMPUTERS"}, {
	0x08, 0x00, 0x8F, "CHIPCOM CORPORATION"}, {
	0x08, 0x00, 0x90, "SONOMA SYSTEMS"}, {
	0x08, 0x14, 0x43, "UNIBRAIN S.A."}, {
	0x08, 0xBB, 0xCC, "AK-NORD EDV VERTRIEBSGES. mbH"}, {
	0x10, 0x00, 0x5A, "IBM CORPORATION"}, {
	0x10, 0x00, 0xE8, "NATIONAL SEMICONDUCTOR"}, {
	0x80, 0x00, 0x10, "ATT BELL LABORATORIES"}, {
	0xA0, 0x6A, 0x00, "Verilink Corporation"}, {
	0xAA, 0x00, 0x00, "DIGITAL EQUIPMENT CORPORATION"}, {
	0xAA, 0x00, 0x01, "DIGITAL EQUIPMENT CORPORATION"}, {
	0xAA, 0x00, 0x02, "DIGITAL EQUIPMENT CORPORATION"}, {
	0xAA, 0x00, 0x03, "DIGITAL EQUIPMENT CORPORATION"}, {
	0xAA, 0x00, 0x04, "DIGITAL EQUIPMENT CORPORATION"}
    };

    int i = sizeof(oui_list) / sizeof(oui_list[1]) - 1;

    while (i > 0) {
	if (oui_list[i].oui1 == mac[0] && oui_list[i].oui2 == mac[1]
	    && oui_list[i].oui3 == mac[2])
	    return oui_list[i].organization;
	i--;
    }
    return _("Unknown or Private");
}
