// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/aws-sdk-go/service/resourcegroupstaggingapi/resourcegroupstaggingapiiface (interfaces: ResourceGroupsTaggingAPIAPI)

// Package mock_resourcegroupstaggingapiiface is a generated GoMock package.
package mock_resourcegroupstaggingapiiface

import (
	context "context"
	reflect "reflect"

	request "github.com/aws/aws-sdk-go/aws/request"
	resourcegroupstaggingapi "github.com/aws/aws-sdk-go/service/resourcegroupstaggingapi"
	gomock "github.com/golang/mock/gomock"
)

// MockResourceGroupsTaggingAPIAPI is a mock of ResourceGroupsTaggingAPIAPI interface
type MockResourceGroupsTaggingAPIAPI struct {
	ctrl     *gomock.Controller
	recorder *MockResourceGroupsTaggingAPIAPIMockRecorder
}

// MockResourceGroupsTaggingAPIAPIMockRecorder is the mock recorder for MockResourceGroupsTaggingAPIAPI
type MockResourceGroupsTaggingAPIAPIMockRecorder struct {
	mock *MockResourceGroupsTaggingAPIAPI
}

// NewMockResourceGroupsTaggingAPIAPI creates a new mock instance
func NewMockResourceGroupsTaggingAPIAPI(ctrl *gomock.Controller) *MockResourceGroupsTaggingAPIAPI {
	mock := &MockResourceGroupsTaggingAPIAPI{ctrl: ctrl}
	mock.recorder = &MockResourceGroupsTaggingAPIAPIMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockResourceGroupsTaggingAPIAPI) EXPECT() *MockResourceGroupsTaggingAPIAPIMockRecorder {
	return m.recorder
}

// DescribeReportCreation mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) DescribeReportCreation(arg0 *resourcegroupstaggingapi.DescribeReportCreationInput) (*resourcegroupstaggingapi.DescribeReportCreationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReportCreation", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.DescribeReportCreationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReportCreation indicates an expected call of DescribeReportCreation
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) DescribeReportCreation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReportCreation", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).DescribeReportCreation), arg0)
}

// DescribeReportCreationRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) DescribeReportCreationRequest(arg0 *resourcegroupstaggingapi.DescribeReportCreationInput) (*request.Request, *resourcegroupstaggingapi.DescribeReportCreationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeReportCreationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.DescribeReportCreationOutput)
	return ret0, ret1
}

// DescribeReportCreationRequest indicates an expected call of DescribeReportCreationRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) DescribeReportCreationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReportCreationRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).DescribeReportCreationRequest), arg0)
}

// DescribeReportCreationWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) DescribeReportCreationWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.DescribeReportCreationInput, arg2 ...request.Option) (*resourcegroupstaggingapi.DescribeReportCreationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeReportCreationWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.DescribeReportCreationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeReportCreationWithContext indicates an expected call of DescribeReportCreationWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) DescribeReportCreationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeReportCreationWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).DescribeReportCreationWithContext), varargs...)
}

// GetComplianceSummary mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetComplianceSummary(arg0 *resourcegroupstaggingapi.GetComplianceSummaryInput) (*resourcegroupstaggingapi.GetComplianceSummaryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetComplianceSummary", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetComplianceSummaryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetComplianceSummary indicates an expected call of GetComplianceSummary
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetComplianceSummary(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetComplianceSummary", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetComplianceSummary), arg0)
}

// GetComplianceSummaryPages mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetComplianceSummaryPages(arg0 *resourcegroupstaggingapi.GetComplianceSummaryInput, arg1 func(*resourcegroupstaggingapi.GetComplianceSummaryOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetComplianceSummaryPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetComplianceSummaryPages indicates an expected call of GetComplianceSummaryPages
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetComplianceSummaryPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetComplianceSummaryPages", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetComplianceSummaryPages), arg0, arg1)
}

// GetComplianceSummaryPagesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetComplianceSummaryPagesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetComplianceSummaryInput, arg2 func(*resourcegroupstaggingapi.GetComplianceSummaryOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetComplianceSummaryPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetComplianceSummaryPagesWithContext indicates an expected call of GetComplianceSummaryPagesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetComplianceSummaryPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetComplianceSummaryPagesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetComplianceSummaryPagesWithContext), varargs...)
}

// GetComplianceSummaryRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetComplianceSummaryRequest(arg0 *resourcegroupstaggingapi.GetComplianceSummaryInput) (*request.Request, *resourcegroupstaggingapi.GetComplianceSummaryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetComplianceSummaryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.GetComplianceSummaryOutput)
	return ret0, ret1
}

// GetComplianceSummaryRequest indicates an expected call of GetComplianceSummaryRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetComplianceSummaryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetComplianceSummaryRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetComplianceSummaryRequest), arg0)
}

// GetComplianceSummaryWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetComplianceSummaryWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetComplianceSummaryInput, arg2 ...request.Option) (*resourcegroupstaggingapi.GetComplianceSummaryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetComplianceSummaryWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetComplianceSummaryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetComplianceSummaryWithContext indicates an expected call of GetComplianceSummaryWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetComplianceSummaryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetComplianceSummaryWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetComplianceSummaryWithContext), varargs...)
}

// GetResources mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetResources(arg0 *resourcegroupstaggingapi.GetResourcesInput) (*resourcegroupstaggingapi.GetResourcesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetResources", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetResources indicates an expected call of GetResources
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetResources(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetResources", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetResources), arg0)
}

// GetResourcesPages mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetResourcesPages(arg0 *resourcegroupstaggingapi.GetResourcesInput, arg1 func(*resourcegroupstaggingapi.GetResourcesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetResourcesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetResourcesPages indicates an expected call of GetResourcesPages
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetResourcesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetResourcesPages", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetResourcesPages), arg0, arg1)
}

// GetResourcesPagesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetResourcesPagesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetResourcesInput, arg2 func(*resourcegroupstaggingapi.GetResourcesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetResourcesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetResourcesPagesWithContext indicates an expected call of GetResourcesPagesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetResourcesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetResourcesPagesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetResourcesPagesWithContext), varargs...)
}

// GetResourcesRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetResourcesRequest(arg0 *resourcegroupstaggingapi.GetResourcesInput) (*request.Request, *resourcegroupstaggingapi.GetResourcesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetResourcesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.GetResourcesOutput)
	return ret0, ret1
}

// GetResourcesRequest indicates an expected call of GetResourcesRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetResourcesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetResourcesRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetResourcesRequest), arg0)
}

// GetResourcesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetResourcesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetResourcesInput, arg2 ...request.Option) (*resourcegroupstaggingapi.GetResourcesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetResourcesWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetResourcesWithContext indicates an expected call of GetResourcesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetResourcesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetResourcesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetResourcesWithContext), varargs...)
}

// GetTagKeys mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagKeys(arg0 *resourcegroupstaggingapi.GetTagKeysInput) (*resourcegroupstaggingapi.GetTagKeysOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTagKeys", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetTagKeysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTagKeys indicates an expected call of GetTagKeys
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagKeys(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagKeys", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagKeys), arg0)
}

// GetTagKeysPages mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagKeysPages(arg0 *resourcegroupstaggingapi.GetTagKeysInput, arg1 func(*resourcegroupstaggingapi.GetTagKeysOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTagKeysPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTagKeysPages indicates an expected call of GetTagKeysPages
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagKeysPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagKeysPages", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagKeysPages), arg0, arg1)
}

// GetTagKeysPagesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagKeysPagesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetTagKeysInput, arg2 func(*resourcegroupstaggingapi.GetTagKeysOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTagKeysPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTagKeysPagesWithContext indicates an expected call of GetTagKeysPagesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagKeysPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagKeysPagesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagKeysPagesWithContext), varargs...)
}

// GetTagKeysRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagKeysRequest(arg0 *resourcegroupstaggingapi.GetTagKeysInput) (*request.Request, *resourcegroupstaggingapi.GetTagKeysOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTagKeysRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.GetTagKeysOutput)
	return ret0, ret1
}

// GetTagKeysRequest indicates an expected call of GetTagKeysRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagKeysRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagKeysRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagKeysRequest), arg0)
}

// GetTagKeysWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagKeysWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetTagKeysInput, arg2 ...request.Option) (*resourcegroupstaggingapi.GetTagKeysOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTagKeysWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetTagKeysOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTagKeysWithContext indicates an expected call of GetTagKeysWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagKeysWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagKeysWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagKeysWithContext), varargs...)
}

// GetTagValues mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagValues(arg0 *resourcegroupstaggingapi.GetTagValuesInput) (*resourcegroupstaggingapi.GetTagValuesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTagValues", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetTagValuesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTagValues indicates an expected call of GetTagValues
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagValues(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagValues", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagValues), arg0)
}

// GetTagValuesPages mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagValuesPages(arg0 *resourcegroupstaggingapi.GetTagValuesInput, arg1 func(*resourcegroupstaggingapi.GetTagValuesOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTagValuesPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTagValuesPages indicates an expected call of GetTagValuesPages
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagValuesPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagValuesPages", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagValuesPages), arg0, arg1)
}

// GetTagValuesPagesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagValuesPagesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetTagValuesInput, arg2 func(*resourcegroupstaggingapi.GetTagValuesOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTagValuesPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetTagValuesPagesWithContext indicates an expected call of GetTagValuesPagesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagValuesPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagValuesPagesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagValuesPagesWithContext), varargs...)
}

// GetTagValuesRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagValuesRequest(arg0 *resourcegroupstaggingapi.GetTagValuesInput) (*request.Request, *resourcegroupstaggingapi.GetTagValuesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTagValuesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.GetTagValuesOutput)
	return ret0, ret1
}

// GetTagValuesRequest indicates an expected call of GetTagValuesRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagValuesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagValuesRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagValuesRequest), arg0)
}

// GetTagValuesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) GetTagValuesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.GetTagValuesInput, arg2 ...request.Option) (*resourcegroupstaggingapi.GetTagValuesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetTagValuesWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.GetTagValuesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetTagValuesWithContext indicates an expected call of GetTagValuesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) GetTagValuesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTagValuesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).GetTagValuesWithContext), varargs...)
}

// StartReportCreation mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) StartReportCreation(arg0 *resourcegroupstaggingapi.StartReportCreationInput) (*resourcegroupstaggingapi.StartReportCreationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartReportCreation", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.StartReportCreationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartReportCreation indicates an expected call of StartReportCreation
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) StartReportCreation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartReportCreation", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).StartReportCreation), arg0)
}

// StartReportCreationRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) StartReportCreationRequest(arg0 *resourcegroupstaggingapi.StartReportCreationInput) (*request.Request, *resourcegroupstaggingapi.StartReportCreationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartReportCreationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.StartReportCreationOutput)
	return ret0, ret1
}

// StartReportCreationRequest indicates an expected call of StartReportCreationRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) StartReportCreationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartReportCreationRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).StartReportCreationRequest), arg0)
}

// StartReportCreationWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) StartReportCreationWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.StartReportCreationInput, arg2 ...request.Option) (*resourcegroupstaggingapi.StartReportCreationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartReportCreationWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.StartReportCreationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartReportCreationWithContext indicates an expected call of StartReportCreationWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) StartReportCreationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartReportCreationWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).StartReportCreationWithContext), varargs...)
}

// TagResources mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) TagResources(arg0 *resourcegroupstaggingapi.TagResourcesInput) (*resourcegroupstaggingapi.TagResourcesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagResources", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.TagResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TagResources indicates an expected call of TagResources
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) TagResources(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagResources", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).TagResources), arg0)
}

// TagResourcesRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) TagResourcesRequest(arg0 *resourcegroupstaggingapi.TagResourcesInput) (*request.Request, *resourcegroupstaggingapi.TagResourcesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagResourcesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.TagResourcesOutput)
	return ret0, ret1
}

// TagResourcesRequest indicates an expected call of TagResourcesRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) TagResourcesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagResourcesRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).TagResourcesRequest), arg0)
}

// TagResourcesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) TagResourcesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.TagResourcesInput, arg2 ...request.Option) (*resourcegroupstaggingapi.TagResourcesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "TagResourcesWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.TagResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TagResourcesWithContext indicates an expected call of TagResourcesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) TagResourcesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagResourcesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).TagResourcesWithContext), varargs...)
}

// UntagResources mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) UntagResources(arg0 *resourcegroupstaggingapi.UntagResourcesInput) (*resourcegroupstaggingapi.UntagResourcesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UntagResources", arg0)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.UntagResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UntagResources indicates an expected call of UntagResources
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) UntagResources(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UntagResources", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).UntagResources), arg0)
}

// UntagResourcesRequest mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) UntagResourcesRequest(arg0 *resourcegroupstaggingapi.UntagResourcesInput) (*request.Request, *resourcegroupstaggingapi.UntagResourcesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UntagResourcesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*resourcegroupstaggingapi.UntagResourcesOutput)
	return ret0, ret1
}

// UntagResourcesRequest indicates an expected call of UntagResourcesRequest
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) UntagResourcesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UntagResourcesRequest", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).UntagResourcesRequest), arg0)
}

// UntagResourcesWithContext mocks base method
func (m *MockResourceGroupsTaggingAPIAPI) UntagResourcesWithContext(arg0 context.Context, arg1 *resourcegroupstaggingapi.UntagResourcesInput, arg2 ...request.Option) (*resourcegroupstaggingapi.UntagResourcesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UntagResourcesWithContext", varargs...)
	ret0, _ := ret[0].(*resourcegroupstaggingapi.UntagResourcesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UntagResourcesWithContext indicates an expected call of UntagResourcesWithContext
func (mr *MockResourceGroupsTaggingAPIAPIMockRecorder) UntagResourcesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UntagResourcesWithContext", reflect.TypeOf((*MockResourceGroupsTaggingAPIAPI)(nil).UntagResourcesWithContext), varargs...)
}
