// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/awslabs/amazon-ecr-credential-helper/ecr-login/api (interfaces: Client)

// Package mock_api is a generated GoMock package.
package mock_api

import (
	reflect "reflect"

	api "github.com/awslabs/amazon-ecr-credential-helper/ecr-login/api"
	gomock "github.com/golang/mock/gomock"
)

// MockClient is a mock of Client interface
type MockClient struct {
	ctrl     *gomock.Controller
	recorder *MockClientMockRecorder
}

// MockClientMockRecorder is the mock recorder for MockClient
type MockClientMockRecorder struct {
	mock *MockClient
}

// NewMockClient creates a new mock instance
func NewMockClient(ctrl *gomock.Controller) *MockClient {
	mock := &MockClient{ctrl: ctrl}
	mock.recorder = &MockClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockClient) EXPECT() *MockClientMockRecorder {
	return m.recorder
}

// GetCredentials mocks base method
func (m *MockClient) GetCredentials(arg0 string) (*api.Auth, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCredentials", arg0)
	ret0, _ := ret[0].(*api.Auth)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCredentials indicates an expected call of GetCredentials
func (mr *MockClientMockRecorder) GetCredentials(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCredentials", reflect.TypeOf((*MockClient)(nil).GetCredentials), arg0)
}

// GetCredentialsByRegistryID mocks base method
func (m *MockClient) GetCredentialsByRegistryID(arg0 string) (*api.Auth, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCredentialsByRegistryID", arg0)
	ret0, _ := ret[0].(*api.Auth)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCredentialsByRegistryID indicates an expected call of GetCredentialsByRegistryID
func (mr *MockClientMockRecorder) GetCredentialsByRegistryID(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCredentialsByRegistryID", reflect.TypeOf((*MockClient)(nil).GetCredentialsByRegistryID), arg0)
}

// ListCredentials mocks base method
func (m *MockClient) ListCredentials() ([]*api.Auth, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCredentials")
	ret0, _ := ret[0].([]*api.Auth)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListCredentials indicates an expected call of ListCredentials
func (mr *MockClientMockRecorder) ListCredentials() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCredentials", reflect.TypeOf((*MockClient)(nil).ListCredentials))
}
