// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/amazon-ecs-cli/ecs-cli/modules/clients/aws/cloudwatchlogs (interfaces: Client)

// Package mock_cloudwatchlogs is a generated GoMock package.
package mock_cloudwatchlogs

import (
	reflect "reflect"

	cloudwatchlogs "github.com/aws/aws-sdk-go/service/cloudwatchlogs"
	gomock "github.com/golang/mock/gomock"
)

// MockClient is a mock of Client interface
type MockClient struct {
	ctrl     *gomock.Controller
	recorder *MockClientMockRecorder
}

// MockClientMockRecorder is the mock recorder for MockClient
type MockClientMockRecorder struct {
	mock *MockClient
}

// NewMockClient creates a new mock instance
func NewMockClient(ctrl *gomock.Controller) *MockClient {
	mock := &MockClient{ctrl: ctrl}
	mock.recorder = &MockClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockClient) EXPECT() *MockClientMockRecorder {
	return m.recorder
}

// CreateLogGroup mocks base method
func (m *MockClient) CreateLogGroup(arg0 *string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateLogGroup", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateLogGroup indicates an expected call of CreateLogGroup
func (mr *MockClientMockRecorder) CreateLogGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateLogGroup", reflect.TypeOf((*MockClient)(nil).CreateLogGroup), arg0)
}

// FilterAllLogEvents mocks base method
func (m *MockClient) FilterAllLogEvents(arg0 *cloudwatchlogs.FilterLogEventsInput, arg1 func([]*cloudwatchlogs.FilteredLogEvent)) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FilterAllLogEvents", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// FilterAllLogEvents indicates an expected call of FilterAllLogEvents
func (mr *MockClientMockRecorder) FilterAllLogEvents(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FilterAllLogEvents", reflect.TypeOf((*MockClient)(nil).FilterAllLogEvents), arg0, arg1)
}
