// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/amazon-ecs-cli/ecs-cli/modules/clients/aws/cloudformation (interfaces: CloudformationClient)

// Package mock_cloudformation is a generated GoMock package.
package mock_cloudformation

import (
	reflect "reflect"

	cloudformation "github.com/aws/amazon-ecs-cli/ecs-cli/modules/clients/aws/cloudformation"
	cloudformation0 "github.com/aws/aws-sdk-go/service/cloudformation"
	gomock "github.com/golang/mock/gomock"
)

// MockCloudformationClient is a mock of CloudformationClient interface
type MockCloudformationClient struct {
	ctrl     *gomock.Controller
	recorder *MockCloudformationClientMockRecorder
}

// MockCloudformationClientMockRecorder is the mock recorder for MockCloudformationClient
type MockCloudformationClientMockRecorder struct {
	mock *MockCloudformationClient
}

// NewMockCloudformationClient creates a new mock instance
func NewMockCloudformationClient(ctrl *gomock.Controller) *MockCloudformationClient {
	mock := &MockCloudformationClient{ctrl: ctrl}
	mock.recorder = &MockCloudformationClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockCloudformationClient) EXPECT() *MockCloudformationClientMockRecorder {
	return m.recorder
}

// CreateStack mocks base method
func (m *MockCloudformationClient) CreateStack(arg0, arg1 string, arg2 bool, arg3 *cloudformation.CfnStackParams, arg4 []*cloudformation0.Tag) (string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateStack", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateStack indicates an expected call of CreateStack
func (mr *MockCloudformationClientMockRecorder) CreateStack(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateStack", reflect.TypeOf((*MockCloudformationClient)(nil).CreateStack), arg0, arg1, arg2, arg3, arg4)
}

// DeleteStack mocks base method
func (m *MockCloudformationClient) DeleteStack(arg0 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteStack", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteStack indicates an expected call of DeleteStack
func (mr *MockCloudformationClientMockRecorder) DeleteStack(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteStack", reflect.TypeOf((*MockCloudformationClient)(nil).DeleteStack), arg0)
}

// DescribeNetworkResources mocks base method
func (m *MockCloudformationClient) DescribeNetworkResources(arg0 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeNetworkResources", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeNetworkResources indicates an expected call of DescribeNetworkResources
func (mr *MockCloudformationClientMockRecorder) DescribeNetworkResources(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeNetworkResources", reflect.TypeOf((*MockCloudformationClient)(nil).DescribeNetworkResources), arg0)
}

// DescribeStacks mocks base method
func (m *MockCloudformationClient) DescribeStacks(arg0 string) (*cloudformation0.DescribeStacksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeStacks", arg0)
	ret0, _ := ret[0].(*cloudformation0.DescribeStacksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeStacks indicates an expected call of DescribeStacks
func (mr *MockCloudformationClientMockRecorder) DescribeStacks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeStacks", reflect.TypeOf((*MockCloudformationClient)(nil).DescribeStacks), arg0)
}

// GetStackParameters mocks base method
func (m *MockCloudformationClient) GetStackParameters(arg0 string) ([]*cloudformation0.Parameter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetStackParameters", arg0)
	ret0, _ := ret[0].([]*cloudformation0.Parameter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetStackParameters indicates an expected call of GetStackParameters
func (mr *MockCloudformationClientMockRecorder) GetStackParameters(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetStackParameters", reflect.TypeOf((*MockCloudformationClient)(nil).GetStackParameters), arg0)
}

// UpdateStack mocks base method
func (m *MockCloudformationClient) UpdateStack(arg0 string, arg1 *cloudformation.CfnStackParams) (string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateStack", arg0, arg1)
	ret0, _ := ret[0].(string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateStack indicates an expected call of UpdateStack
func (mr *MockCloudformationClientMockRecorder) UpdateStack(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateStack", reflect.TypeOf((*MockCloudformationClient)(nil).UpdateStack), arg0, arg1)
}

// ValidateStackExists mocks base method
func (m *MockCloudformationClient) ValidateStackExists(arg0 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateStackExists", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// ValidateStackExists indicates an expected call of ValidateStackExists
func (mr *MockCloudformationClientMockRecorder) ValidateStackExists(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateStackExists", reflect.TypeOf((*MockCloudformationClient)(nil).ValidateStackExists), arg0)
}

// WaitUntilCreateComplete mocks base method
func (m *MockCloudformationClient) WaitUntilCreateComplete(arg0 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilCreateComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilCreateComplete indicates an expected call of WaitUntilCreateComplete
func (mr *MockCloudformationClientMockRecorder) WaitUntilCreateComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilCreateComplete", reflect.TypeOf((*MockCloudformationClient)(nil).WaitUntilCreateComplete), arg0)
}

// WaitUntilDeleteComplete mocks base method
func (m *MockCloudformationClient) WaitUntilDeleteComplete(arg0 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilDeleteComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilDeleteComplete indicates an expected call of WaitUntilDeleteComplete
func (mr *MockCloudformationClientMockRecorder) WaitUntilDeleteComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilDeleteComplete", reflect.TypeOf((*MockCloudformationClient)(nil).WaitUntilDeleteComplete), arg0)
}

// WaitUntilUpdateComplete mocks base method
func (m *MockCloudformationClient) WaitUntilUpdateComplete(arg0 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WaitUntilUpdateComplete", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// WaitUntilUpdateComplete indicates an expected call of WaitUntilUpdateComplete
func (mr *MockCloudformationClientMockRecorder) WaitUntilUpdateComplete(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitUntilUpdateComplete", reflect.TypeOf((*MockCloudformationClient)(nil).WaitUntilUpdateComplete), arg0)
}
