// Copyright 2015-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/aws/aws-sdk-go/service/ssm/ssmiface (interfaces: SSMAPI)

// Package mock_ssmiface is a generated GoMock package.
package mock_ssmiface

import (
	context "context"
	reflect "reflect"

	request "github.com/aws/aws-sdk-go/aws/request"
	ssm "github.com/aws/aws-sdk-go/service/ssm"
	gomock "github.com/golang/mock/gomock"
)

// MockSSMAPI is a mock of SSMAPI interface
type MockSSMAPI struct {
	ctrl     *gomock.Controller
	recorder *MockSSMAPIMockRecorder
}

// MockSSMAPIMockRecorder is the mock recorder for MockSSMAPI
type MockSSMAPIMockRecorder struct {
	mock *MockSSMAPI
}

// NewMockSSMAPI creates a new mock instance
func NewMockSSMAPI(ctrl *gomock.Controller) *MockSSMAPI {
	mock := &MockSSMAPI{ctrl: ctrl}
	mock.recorder = &MockSSMAPIMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockSSMAPI) EXPECT() *MockSSMAPIMockRecorder {
	return m.recorder
}

// AddTagsToResource mocks base method
func (m *MockSSMAPI) AddTagsToResource(arg0 *ssm.AddTagsToResourceInput) (*ssm.AddTagsToResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTagsToResource", arg0)
	ret0, _ := ret[0].(*ssm.AddTagsToResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTagsToResource indicates an expected call of AddTagsToResource
func (mr *MockSSMAPIMockRecorder) AddTagsToResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTagsToResource", reflect.TypeOf((*MockSSMAPI)(nil).AddTagsToResource), arg0)
}

// AddTagsToResourceRequest mocks base method
func (m *MockSSMAPI) AddTagsToResourceRequest(arg0 *ssm.AddTagsToResourceInput) (*request.Request, *ssm.AddTagsToResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTagsToResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.AddTagsToResourceOutput)
	return ret0, ret1
}

// AddTagsToResourceRequest indicates an expected call of AddTagsToResourceRequest
func (mr *MockSSMAPIMockRecorder) AddTagsToResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTagsToResourceRequest", reflect.TypeOf((*MockSSMAPI)(nil).AddTagsToResourceRequest), arg0)
}

// AddTagsToResourceWithContext mocks base method
func (m *MockSSMAPI) AddTagsToResourceWithContext(arg0 context.Context, arg1 *ssm.AddTagsToResourceInput, arg2 ...request.Option) (*ssm.AddTagsToResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "AddTagsToResourceWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.AddTagsToResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddTagsToResourceWithContext indicates an expected call of AddTagsToResourceWithContext
func (mr *MockSSMAPIMockRecorder) AddTagsToResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTagsToResourceWithContext", reflect.TypeOf((*MockSSMAPI)(nil).AddTagsToResourceWithContext), varargs...)
}

// CancelCommand mocks base method
func (m *MockSSMAPI) CancelCommand(arg0 *ssm.CancelCommandInput) (*ssm.CancelCommandOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelCommand", arg0)
	ret0, _ := ret[0].(*ssm.CancelCommandOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelCommand indicates an expected call of CancelCommand
func (mr *MockSSMAPIMockRecorder) CancelCommand(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelCommand", reflect.TypeOf((*MockSSMAPI)(nil).CancelCommand), arg0)
}

// CancelCommandRequest mocks base method
func (m *MockSSMAPI) CancelCommandRequest(arg0 *ssm.CancelCommandInput) (*request.Request, *ssm.CancelCommandOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelCommandRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CancelCommandOutput)
	return ret0, ret1
}

// CancelCommandRequest indicates an expected call of CancelCommandRequest
func (mr *MockSSMAPIMockRecorder) CancelCommandRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelCommandRequest", reflect.TypeOf((*MockSSMAPI)(nil).CancelCommandRequest), arg0)
}

// CancelCommandWithContext mocks base method
func (m *MockSSMAPI) CancelCommandWithContext(arg0 context.Context, arg1 *ssm.CancelCommandInput, arg2 ...request.Option) (*ssm.CancelCommandOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelCommandWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CancelCommandOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelCommandWithContext indicates an expected call of CancelCommandWithContext
func (mr *MockSSMAPIMockRecorder) CancelCommandWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelCommandWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CancelCommandWithContext), varargs...)
}

// CancelMaintenanceWindowExecution mocks base method
func (m *MockSSMAPI) CancelMaintenanceWindowExecution(arg0 *ssm.CancelMaintenanceWindowExecutionInput) (*ssm.CancelMaintenanceWindowExecutionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelMaintenanceWindowExecution", arg0)
	ret0, _ := ret[0].(*ssm.CancelMaintenanceWindowExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelMaintenanceWindowExecution indicates an expected call of CancelMaintenanceWindowExecution
func (mr *MockSSMAPIMockRecorder) CancelMaintenanceWindowExecution(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelMaintenanceWindowExecution", reflect.TypeOf((*MockSSMAPI)(nil).CancelMaintenanceWindowExecution), arg0)
}

// CancelMaintenanceWindowExecutionRequest mocks base method
func (m *MockSSMAPI) CancelMaintenanceWindowExecutionRequest(arg0 *ssm.CancelMaintenanceWindowExecutionInput) (*request.Request, *ssm.CancelMaintenanceWindowExecutionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelMaintenanceWindowExecutionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CancelMaintenanceWindowExecutionOutput)
	return ret0, ret1
}

// CancelMaintenanceWindowExecutionRequest indicates an expected call of CancelMaintenanceWindowExecutionRequest
func (mr *MockSSMAPIMockRecorder) CancelMaintenanceWindowExecutionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelMaintenanceWindowExecutionRequest", reflect.TypeOf((*MockSSMAPI)(nil).CancelMaintenanceWindowExecutionRequest), arg0)
}

// CancelMaintenanceWindowExecutionWithContext mocks base method
func (m *MockSSMAPI) CancelMaintenanceWindowExecutionWithContext(arg0 context.Context, arg1 *ssm.CancelMaintenanceWindowExecutionInput, arg2 ...request.Option) (*ssm.CancelMaintenanceWindowExecutionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CancelMaintenanceWindowExecutionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CancelMaintenanceWindowExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelMaintenanceWindowExecutionWithContext indicates an expected call of CancelMaintenanceWindowExecutionWithContext
func (mr *MockSSMAPIMockRecorder) CancelMaintenanceWindowExecutionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelMaintenanceWindowExecutionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CancelMaintenanceWindowExecutionWithContext), varargs...)
}

// CreateActivation mocks base method
func (m *MockSSMAPI) CreateActivation(arg0 *ssm.CreateActivationInput) (*ssm.CreateActivationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateActivation", arg0)
	ret0, _ := ret[0].(*ssm.CreateActivationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateActivation indicates an expected call of CreateActivation
func (mr *MockSSMAPIMockRecorder) CreateActivation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateActivation", reflect.TypeOf((*MockSSMAPI)(nil).CreateActivation), arg0)
}

// CreateActivationRequest mocks base method
func (m *MockSSMAPI) CreateActivationRequest(arg0 *ssm.CreateActivationInput) (*request.Request, *ssm.CreateActivationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateActivationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreateActivationOutput)
	return ret0, ret1
}

// CreateActivationRequest indicates an expected call of CreateActivationRequest
func (mr *MockSSMAPIMockRecorder) CreateActivationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateActivationRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreateActivationRequest), arg0)
}

// CreateActivationWithContext mocks base method
func (m *MockSSMAPI) CreateActivationWithContext(arg0 context.Context, arg1 *ssm.CreateActivationInput, arg2 ...request.Option) (*ssm.CreateActivationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateActivationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreateActivationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateActivationWithContext indicates an expected call of CreateActivationWithContext
func (mr *MockSSMAPIMockRecorder) CreateActivationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateActivationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreateActivationWithContext), varargs...)
}

// CreateAssociation mocks base method
func (m *MockSSMAPI) CreateAssociation(arg0 *ssm.CreateAssociationInput) (*ssm.CreateAssociationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssociation", arg0)
	ret0, _ := ret[0].(*ssm.CreateAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAssociation indicates an expected call of CreateAssociation
func (mr *MockSSMAPIMockRecorder) CreateAssociation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssociation", reflect.TypeOf((*MockSSMAPI)(nil).CreateAssociation), arg0)
}

// CreateAssociationBatch mocks base method
func (m *MockSSMAPI) CreateAssociationBatch(arg0 *ssm.CreateAssociationBatchInput) (*ssm.CreateAssociationBatchOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssociationBatch", arg0)
	ret0, _ := ret[0].(*ssm.CreateAssociationBatchOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAssociationBatch indicates an expected call of CreateAssociationBatch
func (mr *MockSSMAPIMockRecorder) CreateAssociationBatch(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssociationBatch", reflect.TypeOf((*MockSSMAPI)(nil).CreateAssociationBatch), arg0)
}

// CreateAssociationBatchRequest mocks base method
func (m *MockSSMAPI) CreateAssociationBatchRequest(arg0 *ssm.CreateAssociationBatchInput) (*request.Request, *ssm.CreateAssociationBatchOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssociationBatchRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreateAssociationBatchOutput)
	return ret0, ret1
}

// CreateAssociationBatchRequest indicates an expected call of CreateAssociationBatchRequest
func (mr *MockSSMAPIMockRecorder) CreateAssociationBatchRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssociationBatchRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreateAssociationBatchRequest), arg0)
}

// CreateAssociationBatchWithContext mocks base method
func (m *MockSSMAPI) CreateAssociationBatchWithContext(arg0 context.Context, arg1 *ssm.CreateAssociationBatchInput, arg2 ...request.Option) (*ssm.CreateAssociationBatchOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateAssociationBatchWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreateAssociationBatchOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAssociationBatchWithContext indicates an expected call of CreateAssociationBatchWithContext
func (mr *MockSSMAPIMockRecorder) CreateAssociationBatchWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssociationBatchWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreateAssociationBatchWithContext), varargs...)
}

// CreateAssociationRequest mocks base method
func (m *MockSSMAPI) CreateAssociationRequest(arg0 *ssm.CreateAssociationInput) (*request.Request, *ssm.CreateAssociationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateAssociationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreateAssociationOutput)
	return ret0, ret1
}

// CreateAssociationRequest indicates an expected call of CreateAssociationRequest
func (mr *MockSSMAPIMockRecorder) CreateAssociationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssociationRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreateAssociationRequest), arg0)
}

// CreateAssociationWithContext mocks base method
func (m *MockSSMAPI) CreateAssociationWithContext(arg0 context.Context, arg1 *ssm.CreateAssociationInput, arg2 ...request.Option) (*ssm.CreateAssociationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateAssociationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreateAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateAssociationWithContext indicates an expected call of CreateAssociationWithContext
func (mr *MockSSMAPIMockRecorder) CreateAssociationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateAssociationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreateAssociationWithContext), varargs...)
}

// CreateDocument mocks base method
func (m *MockSSMAPI) CreateDocument(arg0 *ssm.CreateDocumentInput) (*ssm.CreateDocumentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDocument", arg0)
	ret0, _ := ret[0].(*ssm.CreateDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDocument indicates an expected call of CreateDocument
func (mr *MockSSMAPIMockRecorder) CreateDocument(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDocument", reflect.TypeOf((*MockSSMAPI)(nil).CreateDocument), arg0)
}

// CreateDocumentRequest mocks base method
func (m *MockSSMAPI) CreateDocumentRequest(arg0 *ssm.CreateDocumentInput) (*request.Request, *ssm.CreateDocumentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateDocumentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreateDocumentOutput)
	return ret0, ret1
}

// CreateDocumentRequest indicates an expected call of CreateDocumentRequest
func (mr *MockSSMAPIMockRecorder) CreateDocumentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDocumentRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreateDocumentRequest), arg0)
}

// CreateDocumentWithContext mocks base method
func (m *MockSSMAPI) CreateDocumentWithContext(arg0 context.Context, arg1 *ssm.CreateDocumentInput, arg2 ...request.Option) (*ssm.CreateDocumentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateDocumentWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreateDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateDocumentWithContext indicates an expected call of CreateDocumentWithContext
func (mr *MockSSMAPIMockRecorder) CreateDocumentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateDocumentWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreateDocumentWithContext), varargs...)
}

// CreateMaintenanceWindow mocks base method
func (m *MockSSMAPI) CreateMaintenanceWindow(arg0 *ssm.CreateMaintenanceWindowInput) (*ssm.CreateMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.CreateMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateMaintenanceWindow indicates an expected call of CreateMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) CreateMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).CreateMaintenanceWindow), arg0)
}

// CreateMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) CreateMaintenanceWindowRequest(arg0 *ssm.CreateMaintenanceWindowInput) (*request.Request, *ssm.CreateMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreateMaintenanceWindowOutput)
	return ret0, ret1
}

// CreateMaintenanceWindowRequest indicates an expected call of CreateMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) CreateMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreateMaintenanceWindowRequest), arg0)
}

// CreateMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) CreateMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.CreateMaintenanceWindowInput, arg2 ...request.Option) (*ssm.CreateMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreateMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateMaintenanceWindowWithContext indicates an expected call of CreateMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) CreateMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreateMaintenanceWindowWithContext), varargs...)
}

// CreateOpsItem mocks base method
func (m *MockSSMAPI) CreateOpsItem(arg0 *ssm.CreateOpsItemInput) (*ssm.CreateOpsItemOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateOpsItem", arg0)
	ret0, _ := ret[0].(*ssm.CreateOpsItemOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateOpsItem indicates an expected call of CreateOpsItem
func (mr *MockSSMAPIMockRecorder) CreateOpsItem(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateOpsItem", reflect.TypeOf((*MockSSMAPI)(nil).CreateOpsItem), arg0)
}

// CreateOpsItemRequest mocks base method
func (m *MockSSMAPI) CreateOpsItemRequest(arg0 *ssm.CreateOpsItemInput) (*request.Request, *ssm.CreateOpsItemOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateOpsItemRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreateOpsItemOutput)
	return ret0, ret1
}

// CreateOpsItemRequest indicates an expected call of CreateOpsItemRequest
func (mr *MockSSMAPIMockRecorder) CreateOpsItemRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateOpsItemRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreateOpsItemRequest), arg0)
}

// CreateOpsItemWithContext mocks base method
func (m *MockSSMAPI) CreateOpsItemWithContext(arg0 context.Context, arg1 *ssm.CreateOpsItemInput, arg2 ...request.Option) (*ssm.CreateOpsItemOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateOpsItemWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreateOpsItemOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateOpsItemWithContext indicates an expected call of CreateOpsItemWithContext
func (mr *MockSSMAPIMockRecorder) CreateOpsItemWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateOpsItemWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreateOpsItemWithContext), varargs...)
}

// CreatePatchBaseline mocks base method
func (m *MockSSMAPI) CreatePatchBaseline(arg0 *ssm.CreatePatchBaselineInput) (*ssm.CreatePatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreatePatchBaseline", arg0)
	ret0, _ := ret[0].(*ssm.CreatePatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreatePatchBaseline indicates an expected call of CreatePatchBaseline
func (mr *MockSSMAPIMockRecorder) CreatePatchBaseline(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreatePatchBaseline", reflect.TypeOf((*MockSSMAPI)(nil).CreatePatchBaseline), arg0)
}

// CreatePatchBaselineRequest mocks base method
func (m *MockSSMAPI) CreatePatchBaselineRequest(arg0 *ssm.CreatePatchBaselineInput) (*request.Request, *ssm.CreatePatchBaselineOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreatePatchBaselineRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreatePatchBaselineOutput)
	return ret0, ret1
}

// CreatePatchBaselineRequest indicates an expected call of CreatePatchBaselineRequest
func (mr *MockSSMAPIMockRecorder) CreatePatchBaselineRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreatePatchBaselineRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreatePatchBaselineRequest), arg0)
}

// CreatePatchBaselineWithContext mocks base method
func (m *MockSSMAPI) CreatePatchBaselineWithContext(arg0 context.Context, arg1 *ssm.CreatePatchBaselineInput, arg2 ...request.Option) (*ssm.CreatePatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreatePatchBaselineWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreatePatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreatePatchBaselineWithContext indicates an expected call of CreatePatchBaselineWithContext
func (mr *MockSSMAPIMockRecorder) CreatePatchBaselineWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreatePatchBaselineWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreatePatchBaselineWithContext), varargs...)
}

// CreateResourceDataSync mocks base method
func (m *MockSSMAPI) CreateResourceDataSync(arg0 *ssm.CreateResourceDataSyncInput) (*ssm.CreateResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateResourceDataSync", arg0)
	ret0, _ := ret[0].(*ssm.CreateResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateResourceDataSync indicates an expected call of CreateResourceDataSync
func (mr *MockSSMAPIMockRecorder) CreateResourceDataSync(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateResourceDataSync", reflect.TypeOf((*MockSSMAPI)(nil).CreateResourceDataSync), arg0)
}

// CreateResourceDataSyncRequest mocks base method
func (m *MockSSMAPI) CreateResourceDataSyncRequest(arg0 *ssm.CreateResourceDataSyncInput) (*request.Request, *ssm.CreateResourceDataSyncOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateResourceDataSyncRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.CreateResourceDataSyncOutput)
	return ret0, ret1
}

// CreateResourceDataSyncRequest indicates an expected call of CreateResourceDataSyncRequest
func (mr *MockSSMAPIMockRecorder) CreateResourceDataSyncRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateResourceDataSyncRequest", reflect.TypeOf((*MockSSMAPI)(nil).CreateResourceDataSyncRequest), arg0)
}

// CreateResourceDataSyncWithContext mocks base method
func (m *MockSSMAPI) CreateResourceDataSyncWithContext(arg0 context.Context, arg1 *ssm.CreateResourceDataSyncInput, arg2 ...request.Option) (*ssm.CreateResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateResourceDataSyncWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.CreateResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateResourceDataSyncWithContext indicates an expected call of CreateResourceDataSyncWithContext
func (mr *MockSSMAPIMockRecorder) CreateResourceDataSyncWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateResourceDataSyncWithContext", reflect.TypeOf((*MockSSMAPI)(nil).CreateResourceDataSyncWithContext), varargs...)
}

// DeleteActivation mocks base method
func (m *MockSSMAPI) DeleteActivation(arg0 *ssm.DeleteActivationInput) (*ssm.DeleteActivationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteActivation", arg0)
	ret0, _ := ret[0].(*ssm.DeleteActivationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteActivation indicates an expected call of DeleteActivation
func (mr *MockSSMAPIMockRecorder) DeleteActivation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteActivation", reflect.TypeOf((*MockSSMAPI)(nil).DeleteActivation), arg0)
}

// DeleteActivationRequest mocks base method
func (m *MockSSMAPI) DeleteActivationRequest(arg0 *ssm.DeleteActivationInput) (*request.Request, *ssm.DeleteActivationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteActivationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteActivationOutput)
	return ret0, ret1
}

// DeleteActivationRequest indicates an expected call of DeleteActivationRequest
func (mr *MockSSMAPIMockRecorder) DeleteActivationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteActivationRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteActivationRequest), arg0)
}

// DeleteActivationWithContext mocks base method
func (m *MockSSMAPI) DeleteActivationWithContext(arg0 context.Context, arg1 *ssm.DeleteActivationInput, arg2 ...request.Option) (*ssm.DeleteActivationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteActivationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteActivationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteActivationWithContext indicates an expected call of DeleteActivationWithContext
func (mr *MockSSMAPIMockRecorder) DeleteActivationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteActivationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteActivationWithContext), varargs...)
}

// DeleteAssociation mocks base method
func (m *MockSSMAPI) DeleteAssociation(arg0 *ssm.DeleteAssociationInput) (*ssm.DeleteAssociationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAssociation", arg0)
	ret0, _ := ret[0].(*ssm.DeleteAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteAssociation indicates an expected call of DeleteAssociation
func (mr *MockSSMAPIMockRecorder) DeleteAssociation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssociation", reflect.TypeOf((*MockSSMAPI)(nil).DeleteAssociation), arg0)
}

// DeleteAssociationRequest mocks base method
func (m *MockSSMAPI) DeleteAssociationRequest(arg0 *ssm.DeleteAssociationInput) (*request.Request, *ssm.DeleteAssociationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAssociationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteAssociationOutput)
	return ret0, ret1
}

// DeleteAssociationRequest indicates an expected call of DeleteAssociationRequest
func (mr *MockSSMAPIMockRecorder) DeleteAssociationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssociationRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteAssociationRequest), arg0)
}

// DeleteAssociationWithContext mocks base method
func (m *MockSSMAPI) DeleteAssociationWithContext(arg0 context.Context, arg1 *ssm.DeleteAssociationInput, arg2 ...request.Option) (*ssm.DeleteAssociationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteAssociationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteAssociationWithContext indicates an expected call of DeleteAssociationWithContext
func (mr *MockSSMAPIMockRecorder) DeleteAssociationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAssociationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteAssociationWithContext), varargs...)
}

// DeleteDocument mocks base method
func (m *MockSSMAPI) DeleteDocument(arg0 *ssm.DeleteDocumentInput) (*ssm.DeleteDocumentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteDocument", arg0)
	ret0, _ := ret[0].(*ssm.DeleteDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteDocument indicates an expected call of DeleteDocument
func (mr *MockSSMAPIMockRecorder) DeleteDocument(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDocument", reflect.TypeOf((*MockSSMAPI)(nil).DeleteDocument), arg0)
}

// DeleteDocumentRequest mocks base method
func (m *MockSSMAPI) DeleteDocumentRequest(arg0 *ssm.DeleteDocumentInput) (*request.Request, *ssm.DeleteDocumentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteDocumentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteDocumentOutput)
	return ret0, ret1
}

// DeleteDocumentRequest indicates an expected call of DeleteDocumentRequest
func (mr *MockSSMAPIMockRecorder) DeleteDocumentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDocumentRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteDocumentRequest), arg0)
}

// DeleteDocumentWithContext mocks base method
func (m *MockSSMAPI) DeleteDocumentWithContext(arg0 context.Context, arg1 *ssm.DeleteDocumentInput, arg2 ...request.Option) (*ssm.DeleteDocumentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteDocumentWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteDocumentWithContext indicates an expected call of DeleteDocumentWithContext
func (mr *MockSSMAPIMockRecorder) DeleteDocumentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteDocumentWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteDocumentWithContext), varargs...)
}

// DeleteInventory mocks base method
func (m *MockSSMAPI) DeleteInventory(arg0 *ssm.DeleteInventoryInput) (*ssm.DeleteInventoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteInventory", arg0)
	ret0, _ := ret[0].(*ssm.DeleteInventoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteInventory indicates an expected call of DeleteInventory
func (mr *MockSSMAPIMockRecorder) DeleteInventory(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteInventory", reflect.TypeOf((*MockSSMAPI)(nil).DeleteInventory), arg0)
}

// DeleteInventoryRequest mocks base method
func (m *MockSSMAPI) DeleteInventoryRequest(arg0 *ssm.DeleteInventoryInput) (*request.Request, *ssm.DeleteInventoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteInventoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteInventoryOutput)
	return ret0, ret1
}

// DeleteInventoryRequest indicates an expected call of DeleteInventoryRequest
func (mr *MockSSMAPIMockRecorder) DeleteInventoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteInventoryRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteInventoryRequest), arg0)
}

// DeleteInventoryWithContext mocks base method
func (m *MockSSMAPI) DeleteInventoryWithContext(arg0 context.Context, arg1 *ssm.DeleteInventoryInput, arg2 ...request.Option) (*ssm.DeleteInventoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteInventoryWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteInventoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteInventoryWithContext indicates an expected call of DeleteInventoryWithContext
func (mr *MockSSMAPIMockRecorder) DeleteInventoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteInventoryWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteInventoryWithContext), varargs...)
}

// DeleteMaintenanceWindow mocks base method
func (m *MockSSMAPI) DeleteMaintenanceWindow(arg0 *ssm.DeleteMaintenanceWindowInput) (*ssm.DeleteMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.DeleteMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteMaintenanceWindow indicates an expected call of DeleteMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) DeleteMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).DeleteMaintenanceWindow), arg0)
}

// DeleteMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) DeleteMaintenanceWindowRequest(arg0 *ssm.DeleteMaintenanceWindowInput) (*request.Request, *ssm.DeleteMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteMaintenanceWindowOutput)
	return ret0, ret1
}

// DeleteMaintenanceWindowRequest indicates an expected call of DeleteMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) DeleteMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteMaintenanceWindowRequest), arg0)
}

// DeleteMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) DeleteMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.DeleteMaintenanceWindowInput, arg2 ...request.Option) (*ssm.DeleteMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteMaintenanceWindowWithContext indicates an expected call of DeleteMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) DeleteMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteMaintenanceWindowWithContext), varargs...)
}

// DeleteParameter mocks base method
func (m *MockSSMAPI) DeleteParameter(arg0 *ssm.DeleteParameterInput) (*ssm.DeleteParameterOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteParameter", arg0)
	ret0, _ := ret[0].(*ssm.DeleteParameterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteParameter indicates an expected call of DeleteParameter
func (mr *MockSSMAPIMockRecorder) DeleteParameter(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteParameter", reflect.TypeOf((*MockSSMAPI)(nil).DeleteParameter), arg0)
}

// DeleteParameterRequest mocks base method
func (m *MockSSMAPI) DeleteParameterRequest(arg0 *ssm.DeleteParameterInput) (*request.Request, *ssm.DeleteParameterOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteParameterRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteParameterOutput)
	return ret0, ret1
}

// DeleteParameterRequest indicates an expected call of DeleteParameterRequest
func (mr *MockSSMAPIMockRecorder) DeleteParameterRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteParameterRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteParameterRequest), arg0)
}

// DeleteParameterWithContext mocks base method
func (m *MockSSMAPI) DeleteParameterWithContext(arg0 context.Context, arg1 *ssm.DeleteParameterInput, arg2 ...request.Option) (*ssm.DeleteParameterOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteParameterWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteParameterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteParameterWithContext indicates an expected call of DeleteParameterWithContext
func (mr *MockSSMAPIMockRecorder) DeleteParameterWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteParameterWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteParameterWithContext), varargs...)
}

// DeleteParameters mocks base method
func (m *MockSSMAPI) DeleteParameters(arg0 *ssm.DeleteParametersInput) (*ssm.DeleteParametersOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteParameters", arg0)
	ret0, _ := ret[0].(*ssm.DeleteParametersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteParameters indicates an expected call of DeleteParameters
func (mr *MockSSMAPIMockRecorder) DeleteParameters(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteParameters", reflect.TypeOf((*MockSSMAPI)(nil).DeleteParameters), arg0)
}

// DeleteParametersRequest mocks base method
func (m *MockSSMAPI) DeleteParametersRequest(arg0 *ssm.DeleteParametersInput) (*request.Request, *ssm.DeleteParametersOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteParametersRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteParametersOutput)
	return ret0, ret1
}

// DeleteParametersRequest indicates an expected call of DeleteParametersRequest
func (mr *MockSSMAPIMockRecorder) DeleteParametersRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteParametersRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteParametersRequest), arg0)
}

// DeleteParametersWithContext mocks base method
func (m *MockSSMAPI) DeleteParametersWithContext(arg0 context.Context, arg1 *ssm.DeleteParametersInput, arg2 ...request.Option) (*ssm.DeleteParametersOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteParametersWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteParametersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteParametersWithContext indicates an expected call of DeleteParametersWithContext
func (mr *MockSSMAPIMockRecorder) DeleteParametersWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteParametersWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteParametersWithContext), varargs...)
}

// DeletePatchBaseline mocks base method
func (m *MockSSMAPI) DeletePatchBaseline(arg0 *ssm.DeletePatchBaselineInput) (*ssm.DeletePatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeletePatchBaseline", arg0)
	ret0, _ := ret[0].(*ssm.DeletePatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeletePatchBaseline indicates an expected call of DeletePatchBaseline
func (mr *MockSSMAPIMockRecorder) DeletePatchBaseline(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePatchBaseline", reflect.TypeOf((*MockSSMAPI)(nil).DeletePatchBaseline), arg0)
}

// DeletePatchBaselineRequest mocks base method
func (m *MockSSMAPI) DeletePatchBaselineRequest(arg0 *ssm.DeletePatchBaselineInput) (*request.Request, *ssm.DeletePatchBaselineOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeletePatchBaselineRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeletePatchBaselineOutput)
	return ret0, ret1
}

// DeletePatchBaselineRequest indicates an expected call of DeletePatchBaselineRequest
func (mr *MockSSMAPIMockRecorder) DeletePatchBaselineRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePatchBaselineRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeletePatchBaselineRequest), arg0)
}

// DeletePatchBaselineWithContext mocks base method
func (m *MockSSMAPI) DeletePatchBaselineWithContext(arg0 context.Context, arg1 *ssm.DeletePatchBaselineInput, arg2 ...request.Option) (*ssm.DeletePatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeletePatchBaselineWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeletePatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeletePatchBaselineWithContext indicates an expected call of DeletePatchBaselineWithContext
func (mr *MockSSMAPIMockRecorder) DeletePatchBaselineWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePatchBaselineWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeletePatchBaselineWithContext), varargs...)
}

// DeleteResourceDataSync mocks base method
func (m *MockSSMAPI) DeleteResourceDataSync(arg0 *ssm.DeleteResourceDataSyncInput) (*ssm.DeleteResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteResourceDataSync", arg0)
	ret0, _ := ret[0].(*ssm.DeleteResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteResourceDataSync indicates an expected call of DeleteResourceDataSync
func (mr *MockSSMAPIMockRecorder) DeleteResourceDataSync(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteResourceDataSync", reflect.TypeOf((*MockSSMAPI)(nil).DeleteResourceDataSync), arg0)
}

// DeleteResourceDataSyncRequest mocks base method
func (m *MockSSMAPI) DeleteResourceDataSyncRequest(arg0 *ssm.DeleteResourceDataSyncInput) (*request.Request, *ssm.DeleteResourceDataSyncOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteResourceDataSyncRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeleteResourceDataSyncOutput)
	return ret0, ret1
}

// DeleteResourceDataSyncRequest indicates an expected call of DeleteResourceDataSyncRequest
func (mr *MockSSMAPIMockRecorder) DeleteResourceDataSyncRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteResourceDataSyncRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeleteResourceDataSyncRequest), arg0)
}

// DeleteResourceDataSyncWithContext mocks base method
func (m *MockSSMAPI) DeleteResourceDataSyncWithContext(arg0 context.Context, arg1 *ssm.DeleteResourceDataSyncInput, arg2 ...request.Option) (*ssm.DeleteResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteResourceDataSyncWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeleteResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteResourceDataSyncWithContext indicates an expected call of DeleteResourceDataSyncWithContext
func (mr *MockSSMAPIMockRecorder) DeleteResourceDataSyncWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteResourceDataSyncWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeleteResourceDataSyncWithContext), varargs...)
}

// DeregisterManagedInstance mocks base method
func (m *MockSSMAPI) DeregisterManagedInstance(arg0 *ssm.DeregisterManagedInstanceInput) (*ssm.DeregisterManagedInstanceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterManagedInstance", arg0)
	ret0, _ := ret[0].(*ssm.DeregisterManagedInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterManagedInstance indicates an expected call of DeregisterManagedInstance
func (mr *MockSSMAPIMockRecorder) DeregisterManagedInstance(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterManagedInstance", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterManagedInstance), arg0)
}

// DeregisterManagedInstanceRequest mocks base method
func (m *MockSSMAPI) DeregisterManagedInstanceRequest(arg0 *ssm.DeregisterManagedInstanceInput) (*request.Request, *ssm.DeregisterManagedInstanceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterManagedInstanceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeregisterManagedInstanceOutput)
	return ret0, ret1
}

// DeregisterManagedInstanceRequest indicates an expected call of DeregisterManagedInstanceRequest
func (mr *MockSSMAPIMockRecorder) DeregisterManagedInstanceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterManagedInstanceRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterManagedInstanceRequest), arg0)
}

// DeregisterManagedInstanceWithContext mocks base method
func (m *MockSSMAPI) DeregisterManagedInstanceWithContext(arg0 context.Context, arg1 *ssm.DeregisterManagedInstanceInput, arg2 ...request.Option) (*ssm.DeregisterManagedInstanceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterManagedInstanceWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeregisterManagedInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterManagedInstanceWithContext indicates an expected call of DeregisterManagedInstanceWithContext
func (mr *MockSSMAPIMockRecorder) DeregisterManagedInstanceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterManagedInstanceWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterManagedInstanceWithContext), varargs...)
}

// DeregisterPatchBaselineForPatchGroup mocks base method
func (m *MockSSMAPI) DeregisterPatchBaselineForPatchGroup(arg0 *ssm.DeregisterPatchBaselineForPatchGroupInput) (*ssm.DeregisterPatchBaselineForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterPatchBaselineForPatchGroup", arg0)
	ret0, _ := ret[0].(*ssm.DeregisterPatchBaselineForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterPatchBaselineForPatchGroup indicates an expected call of DeregisterPatchBaselineForPatchGroup
func (mr *MockSSMAPIMockRecorder) DeregisterPatchBaselineForPatchGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterPatchBaselineForPatchGroup", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterPatchBaselineForPatchGroup), arg0)
}

// DeregisterPatchBaselineForPatchGroupRequest mocks base method
func (m *MockSSMAPI) DeregisterPatchBaselineForPatchGroupRequest(arg0 *ssm.DeregisterPatchBaselineForPatchGroupInput) (*request.Request, *ssm.DeregisterPatchBaselineForPatchGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterPatchBaselineForPatchGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeregisterPatchBaselineForPatchGroupOutput)
	return ret0, ret1
}

// DeregisterPatchBaselineForPatchGroupRequest indicates an expected call of DeregisterPatchBaselineForPatchGroupRequest
func (mr *MockSSMAPIMockRecorder) DeregisterPatchBaselineForPatchGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterPatchBaselineForPatchGroupRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterPatchBaselineForPatchGroupRequest), arg0)
}

// DeregisterPatchBaselineForPatchGroupWithContext mocks base method
func (m *MockSSMAPI) DeregisterPatchBaselineForPatchGroupWithContext(arg0 context.Context, arg1 *ssm.DeregisterPatchBaselineForPatchGroupInput, arg2 ...request.Option) (*ssm.DeregisterPatchBaselineForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterPatchBaselineForPatchGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeregisterPatchBaselineForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterPatchBaselineForPatchGroupWithContext indicates an expected call of DeregisterPatchBaselineForPatchGroupWithContext
func (mr *MockSSMAPIMockRecorder) DeregisterPatchBaselineForPatchGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterPatchBaselineForPatchGroupWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterPatchBaselineForPatchGroupWithContext), varargs...)
}

// DeregisterTargetFromMaintenanceWindow mocks base method
func (m *MockSSMAPI) DeregisterTargetFromMaintenanceWindow(arg0 *ssm.DeregisterTargetFromMaintenanceWindowInput) (*ssm.DeregisterTargetFromMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTargetFromMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.DeregisterTargetFromMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTargetFromMaintenanceWindow indicates an expected call of DeregisterTargetFromMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) DeregisterTargetFromMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTargetFromMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterTargetFromMaintenanceWindow), arg0)
}

// DeregisterTargetFromMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) DeregisterTargetFromMaintenanceWindowRequest(arg0 *ssm.DeregisterTargetFromMaintenanceWindowInput) (*request.Request, *ssm.DeregisterTargetFromMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTargetFromMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeregisterTargetFromMaintenanceWindowOutput)
	return ret0, ret1
}

// DeregisterTargetFromMaintenanceWindowRequest indicates an expected call of DeregisterTargetFromMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) DeregisterTargetFromMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTargetFromMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterTargetFromMaintenanceWindowRequest), arg0)
}

// DeregisterTargetFromMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) DeregisterTargetFromMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.DeregisterTargetFromMaintenanceWindowInput, arg2 ...request.Option) (*ssm.DeregisterTargetFromMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterTargetFromMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeregisterTargetFromMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTargetFromMaintenanceWindowWithContext indicates an expected call of DeregisterTargetFromMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) DeregisterTargetFromMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTargetFromMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterTargetFromMaintenanceWindowWithContext), varargs...)
}

// DeregisterTaskFromMaintenanceWindow mocks base method
func (m *MockSSMAPI) DeregisterTaskFromMaintenanceWindow(arg0 *ssm.DeregisterTaskFromMaintenanceWindowInput) (*ssm.DeregisterTaskFromMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTaskFromMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.DeregisterTaskFromMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTaskFromMaintenanceWindow indicates an expected call of DeregisterTaskFromMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) DeregisterTaskFromMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTaskFromMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterTaskFromMaintenanceWindow), arg0)
}

// DeregisterTaskFromMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) DeregisterTaskFromMaintenanceWindowRequest(arg0 *ssm.DeregisterTaskFromMaintenanceWindowInput) (*request.Request, *ssm.DeregisterTaskFromMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeregisterTaskFromMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DeregisterTaskFromMaintenanceWindowOutput)
	return ret0, ret1
}

// DeregisterTaskFromMaintenanceWindowRequest indicates an expected call of DeregisterTaskFromMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) DeregisterTaskFromMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTaskFromMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterTaskFromMaintenanceWindowRequest), arg0)
}

// DeregisterTaskFromMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) DeregisterTaskFromMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.DeregisterTaskFromMaintenanceWindowInput, arg2 ...request.Option) (*ssm.DeregisterTaskFromMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeregisterTaskFromMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DeregisterTaskFromMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeregisterTaskFromMaintenanceWindowWithContext indicates an expected call of DeregisterTaskFromMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) DeregisterTaskFromMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeregisterTaskFromMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DeregisterTaskFromMaintenanceWindowWithContext), varargs...)
}

// DescribeActivations mocks base method
func (m *MockSSMAPI) DescribeActivations(arg0 *ssm.DescribeActivationsInput) (*ssm.DescribeActivationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeActivations", arg0)
	ret0, _ := ret[0].(*ssm.DescribeActivationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeActivations indicates an expected call of DescribeActivations
func (mr *MockSSMAPIMockRecorder) DescribeActivations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeActivations", reflect.TypeOf((*MockSSMAPI)(nil).DescribeActivations), arg0)
}

// DescribeActivationsPages mocks base method
func (m *MockSSMAPI) DescribeActivationsPages(arg0 *ssm.DescribeActivationsInput, arg1 func(*ssm.DescribeActivationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeActivationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeActivationsPages indicates an expected call of DescribeActivationsPages
func (mr *MockSSMAPIMockRecorder) DescribeActivationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeActivationsPages", reflect.TypeOf((*MockSSMAPI)(nil).DescribeActivationsPages), arg0, arg1)
}

// DescribeActivationsPagesWithContext mocks base method
func (m *MockSSMAPI) DescribeActivationsPagesWithContext(arg0 context.Context, arg1 *ssm.DescribeActivationsInput, arg2 func(*ssm.DescribeActivationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeActivationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeActivationsPagesWithContext indicates an expected call of DescribeActivationsPagesWithContext
func (mr *MockSSMAPIMockRecorder) DescribeActivationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeActivationsPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeActivationsPagesWithContext), varargs...)
}

// DescribeActivationsRequest mocks base method
func (m *MockSSMAPI) DescribeActivationsRequest(arg0 *ssm.DescribeActivationsInput) (*request.Request, *ssm.DescribeActivationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeActivationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeActivationsOutput)
	return ret0, ret1
}

// DescribeActivationsRequest indicates an expected call of DescribeActivationsRequest
func (mr *MockSSMAPIMockRecorder) DescribeActivationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeActivationsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeActivationsRequest), arg0)
}

// DescribeActivationsWithContext mocks base method
func (m *MockSSMAPI) DescribeActivationsWithContext(arg0 context.Context, arg1 *ssm.DescribeActivationsInput, arg2 ...request.Option) (*ssm.DescribeActivationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeActivationsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeActivationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeActivationsWithContext indicates an expected call of DescribeActivationsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeActivationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeActivationsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeActivationsWithContext), varargs...)
}

// DescribeAssociation mocks base method
func (m *MockSSMAPI) DescribeAssociation(arg0 *ssm.DescribeAssociationInput) (*ssm.DescribeAssociationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAssociation", arg0)
	ret0, _ := ret[0].(*ssm.DescribeAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAssociation indicates an expected call of DescribeAssociation
func (mr *MockSSMAPIMockRecorder) DescribeAssociation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociation", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociation), arg0)
}

// DescribeAssociationExecutionTargets mocks base method
func (m *MockSSMAPI) DescribeAssociationExecutionTargets(arg0 *ssm.DescribeAssociationExecutionTargetsInput) (*ssm.DescribeAssociationExecutionTargetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAssociationExecutionTargets", arg0)
	ret0, _ := ret[0].(*ssm.DescribeAssociationExecutionTargetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAssociationExecutionTargets indicates an expected call of DescribeAssociationExecutionTargets
func (mr *MockSSMAPIMockRecorder) DescribeAssociationExecutionTargets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationExecutionTargets", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationExecutionTargets), arg0)
}

// DescribeAssociationExecutionTargetsRequest mocks base method
func (m *MockSSMAPI) DescribeAssociationExecutionTargetsRequest(arg0 *ssm.DescribeAssociationExecutionTargetsInput) (*request.Request, *ssm.DescribeAssociationExecutionTargetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAssociationExecutionTargetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeAssociationExecutionTargetsOutput)
	return ret0, ret1
}

// DescribeAssociationExecutionTargetsRequest indicates an expected call of DescribeAssociationExecutionTargetsRequest
func (mr *MockSSMAPIMockRecorder) DescribeAssociationExecutionTargetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationExecutionTargetsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationExecutionTargetsRequest), arg0)
}

// DescribeAssociationExecutionTargetsWithContext mocks base method
func (m *MockSSMAPI) DescribeAssociationExecutionTargetsWithContext(arg0 context.Context, arg1 *ssm.DescribeAssociationExecutionTargetsInput, arg2 ...request.Option) (*ssm.DescribeAssociationExecutionTargetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAssociationExecutionTargetsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeAssociationExecutionTargetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAssociationExecutionTargetsWithContext indicates an expected call of DescribeAssociationExecutionTargetsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeAssociationExecutionTargetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationExecutionTargetsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationExecutionTargetsWithContext), varargs...)
}

// DescribeAssociationExecutions mocks base method
func (m *MockSSMAPI) DescribeAssociationExecutions(arg0 *ssm.DescribeAssociationExecutionsInput) (*ssm.DescribeAssociationExecutionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAssociationExecutions", arg0)
	ret0, _ := ret[0].(*ssm.DescribeAssociationExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAssociationExecutions indicates an expected call of DescribeAssociationExecutions
func (mr *MockSSMAPIMockRecorder) DescribeAssociationExecutions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationExecutions", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationExecutions), arg0)
}

// DescribeAssociationExecutionsRequest mocks base method
func (m *MockSSMAPI) DescribeAssociationExecutionsRequest(arg0 *ssm.DescribeAssociationExecutionsInput) (*request.Request, *ssm.DescribeAssociationExecutionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAssociationExecutionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeAssociationExecutionsOutput)
	return ret0, ret1
}

// DescribeAssociationExecutionsRequest indicates an expected call of DescribeAssociationExecutionsRequest
func (mr *MockSSMAPIMockRecorder) DescribeAssociationExecutionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationExecutionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationExecutionsRequest), arg0)
}

// DescribeAssociationExecutionsWithContext mocks base method
func (m *MockSSMAPI) DescribeAssociationExecutionsWithContext(arg0 context.Context, arg1 *ssm.DescribeAssociationExecutionsInput, arg2 ...request.Option) (*ssm.DescribeAssociationExecutionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAssociationExecutionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeAssociationExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAssociationExecutionsWithContext indicates an expected call of DescribeAssociationExecutionsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeAssociationExecutionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationExecutionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationExecutionsWithContext), varargs...)
}

// DescribeAssociationRequest mocks base method
func (m *MockSSMAPI) DescribeAssociationRequest(arg0 *ssm.DescribeAssociationInput) (*request.Request, *ssm.DescribeAssociationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAssociationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeAssociationOutput)
	return ret0, ret1
}

// DescribeAssociationRequest indicates an expected call of DescribeAssociationRequest
func (mr *MockSSMAPIMockRecorder) DescribeAssociationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationRequest), arg0)
}

// DescribeAssociationWithContext mocks base method
func (m *MockSSMAPI) DescribeAssociationWithContext(arg0 context.Context, arg1 *ssm.DescribeAssociationInput, arg2 ...request.Option) (*ssm.DescribeAssociationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAssociationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAssociationWithContext indicates an expected call of DescribeAssociationWithContext
func (mr *MockSSMAPIMockRecorder) DescribeAssociationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAssociationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAssociationWithContext), varargs...)
}

// DescribeAutomationExecutions mocks base method
func (m *MockSSMAPI) DescribeAutomationExecutions(arg0 *ssm.DescribeAutomationExecutionsInput) (*ssm.DescribeAutomationExecutionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAutomationExecutions", arg0)
	ret0, _ := ret[0].(*ssm.DescribeAutomationExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAutomationExecutions indicates an expected call of DescribeAutomationExecutions
func (mr *MockSSMAPIMockRecorder) DescribeAutomationExecutions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAutomationExecutions", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAutomationExecutions), arg0)
}

// DescribeAutomationExecutionsRequest mocks base method
func (m *MockSSMAPI) DescribeAutomationExecutionsRequest(arg0 *ssm.DescribeAutomationExecutionsInput) (*request.Request, *ssm.DescribeAutomationExecutionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAutomationExecutionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeAutomationExecutionsOutput)
	return ret0, ret1
}

// DescribeAutomationExecutionsRequest indicates an expected call of DescribeAutomationExecutionsRequest
func (mr *MockSSMAPIMockRecorder) DescribeAutomationExecutionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAutomationExecutionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAutomationExecutionsRequest), arg0)
}

// DescribeAutomationExecutionsWithContext mocks base method
func (m *MockSSMAPI) DescribeAutomationExecutionsWithContext(arg0 context.Context, arg1 *ssm.DescribeAutomationExecutionsInput, arg2 ...request.Option) (*ssm.DescribeAutomationExecutionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAutomationExecutionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeAutomationExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAutomationExecutionsWithContext indicates an expected call of DescribeAutomationExecutionsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeAutomationExecutionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAutomationExecutionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAutomationExecutionsWithContext), varargs...)
}

// DescribeAutomationStepExecutions mocks base method
func (m *MockSSMAPI) DescribeAutomationStepExecutions(arg0 *ssm.DescribeAutomationStepExecutionsInput) (*ssm.DescribeAutomationStepExecutionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAutomationStepExecutions", arg0)
	ret0, _ := ret[0].(*ssm.DescribeAutomationStepExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAutomationStepExecutions indicates an expected call of DescribeAutomationStepExecutions
func (mr *MockSSMAPIMockRecorder) DescribeAutomationStepExecutions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAutomationStepExecutions", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAutomationStepExecutions), arg0)
}

// DescribeAutomationStepExecutionsRequest mocks base method
func (m *MockSSMAPI) DescribeAutomationStepExecutionsRequest(arg0 *ssm.DescribeAutomationStepExecutionsInput) (*request.Request, *ssm.DescribeAutomationStepExecutionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAutomationStepExecutionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeAutomationStepExecutionsOutput)
	return ret0, ret1
}

// DescribeAutomationStepExecutionsRequest indicates an expected call of DescribeAutomationStepExecutionsRequest
func (mr *MockSSMAPIMockRecorder) DescribeAutomationStepExecutionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAutomationStepExecutionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAutomationStepExecutionsRequest), arg0)
}

// DescribeAutomationStepExecutionsWithContext mocks base method
func (m *MockSSMAPI) DescribeAutomationStepExecutionsWithContext(arg0 context.Context, arg1 *ssm.DescribeAutomationStepExecutionsInput, arg2 ...request.Option) (*ssm.DescribeAutomationStepExecutionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAutomationStepExecutionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeAutomationStepExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAutomationStepExecutionsWithContext indicates an expected call of DescribeAutomationStepExecutionsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeAutomationStepExecutionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAutomationStepExecutionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAutomationStepExecutionsWithContext), varargs...)
}

// DescribeAvailablePatches mocks base method
func (m *MockSSMAPI) DescribeAvailablePatches(arg0 *ssm.DescribeAvailablePatchesInput) (*ssm.DescribeAvailablePatchesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAvailablePatches", arg0)
	ret0, _ := ret[0].(*ssm.DescribeAvailablePatchesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAvailablePatches indicates an expected call of DescribeAvailablePatches
func (mr *MockSSMAPIMockRecorder) DescribeAvailablePatches(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAvailablePatches", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAvailablePatches), arg0)
}

// DescribeAvailablePatchesRequest mocks base method
func (m *MockSSMAPI) DescribeAvailablePatchesRequest(arg0 *ssm.DescribeAvailablePatchesInput) (*request.Request, *ssm.DescribeAvailablePatchesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeAvailablePatchesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeAvailablePatchesOutput)
	return ret0, ret1
}

// DescribeAvailablePatchesRequest indicates an expected call of DescribeAvailablePatchesRequest
func (mr *MockSSMAPIMockRecorder) DescribeAvailablePatchesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAvailablePatchesRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAvailablePatchesRequest), arg0)
}

// DescribeAvailablePatchesWithContext mocks base method
func (m *MockSSMAPI) DescribeAvailablePatchesWithContext(arg0 context.Context, arg1 *ssm.DescribeAvailablePatchesInput, arg2 ...request.Option) (*ssm.DescribeAvailablePatchesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeAvailablePatchesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeAvailablePatchesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeAvailablePatchesWithContext indicates an expected call of DescribeAvailablePatchesWithContext
func (mr *MockSSMAPIMockRecorder) DescribeAvailablePatchesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeAvailablePatchesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeAvailablePatchesWithContext), varargs...)
}

// DescribeDocument mocks base method
func (m *MockSSMAPI) DescribeDocument(arg0 *ssm.DescribeDocumentInput) (*ssm.DescribeDocumentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeDocument", arg0)
	ret0, _ := ret[0].(*ssm.DescribeDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeDocument indicates an expected call of DescribeDocument
func (mr *MockSSMAPIMockRecorder) DescribeDocument(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDocument", reflect.TypeOf((*MockSSMAPI)(nil).DescribeDocument), arg0)
}

// DescribeDocumentPermission mocks base method
func (m *MockSSMAPI) DescribeDocumentPermission(arg0 *ssm.DescribeDocumentPermissionInput) (*ssm.DescribeDocumentPermissionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeDocumentPermission", arg0)
	ret0, _ := ret[0].(*ssm.DescribeDocumentPermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeDocumentPermission indicates an expected call of DescribeDocumentPermission
func (mr *MockSSMAPIMockRecorder) DescribeDocumentPermission(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDocumentPermission", reflect.TypeOf((*MockSSMAPI)(nil).DescribeDocumentPermission), arg0)
}

// DescribeDocumentPermissionRequest mocks base method
func (m *MockSSMAPI) DescribeDocumentPermissionRequest(arg0 *ssm.DescribeDocumentPermissionInput) (*request.Request, *ssm.DescribeDocumentPermissionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeDocumentPermissionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeDocumentPermissionOutput)
	return ret0, ret1
}

// DescribeDocumentPermissionRequest indicates an expected call of DescribeDocumentPermissionRequest
func (mr *MockSSMAPIMockRecorder) DescribeDocumentPermissionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDocumentPermissionRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeDocumentPermissionRequest), arg0)
}

// DescribeDocumentPermissionWithContext mocks base method
func (m *MockSSMAPI) DescribeDocumentPermissionWithContext(arg0 context.Context, arg1 *ssm.DescribeDocumentPermissionInput, arg2 ...request.Option) (*ssm.DescribeDocumentPermissionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeDocumentPermissionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeDocumentPermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeDocumentPermissionWithContext indicates an expected call of DescribeDocumentPermissionWithContext
func (mr *MockSSMAPIMockRecorder) DescribeDocumentPermissionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDocumentPermissionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeDocumentPermissionWithContext), varargs...)
}

// DescribeDocumentRequest mocks base method
func (m *MockSSMAPI) DescribeDocumentRequest(arg0 *ssm.DescribeDocumentInput) (*request.Request, *ssm.DescribeDocumentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeDocumentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeDocumentOutput)
	return ret0, ret1
}

// DescribeDocumentRequest indicates an expected call of DescribeDocumentRequest
func (mr *MockSSMAPIMockRecorder) DescribeDocumentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDocumentRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeDocumentRequest), arg0)
}

// DescribeDocumentWithContext mocks base method
func (m *MockSSMAPI) DescribeDocumentWithContext(arg0 context.Context, arg1 *ssm.DescribeDocumentInput, arg2 ...request.Option) (*ssm.DescribeDocumentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeDocumentWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeDocumentWithContext indicates an expected call of DescribeDocumentWithContext
func (mr *MockSSMAPIMockRecorder) DescribeDocumentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeDocumentWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeDocumentWithContext), varargs...)
}

// DescribeEffectiveInstanceAssociations mocks base method
func (m *MockSSMAPI) DescribeEffectiveInstanceAssociations(arg0 *ssm.DescribeEffectiveInstanceAssociationsInput) (*ssm.DescribeEffectiveInstanceAssociationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeEffectiveInstanceAssociations", arg0)
	ret0, _ := ret[0].(*ssm.DescribeEffectiveInstanceAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeEffectiveInstanceAssociations indicates an expected call of DescribeEffectiveInstanceAssociations
func (mr *MockSSMAPIMockRecorder) DescribeEffectiveInstanceAssociations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEffectiveInstanceAssociations", reflect.TypeOf((*MockSSMAPI)(nil).DescribeEffectiveInstanceAssociations), arg0)
}

// DescribeEffectiveInstanceAssociationsRequest mocks base method
func (m *MockSSMAPI) DescribeEffectiveInstanceAssociationsRequest(arg0 *ssm.DescribeEffectiveInstanceAssociationsInput) (*request.Request, *ssm.DescribeEffectiveInstanceAssociationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeEffectiveInstanceAssociationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeEffectiveInstanceAssociationsOutput)
	return ret0, ret1
}

// DescribeEffectiveInstanceAssociationsRequest indicates an expected call of DescribeEffectiveInstanceAssociationsRequest
func (mr *MockSSMAPIMockRecorder) DescribeEffectiveInstanceAssociationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEffectiveInstanceAssociationsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeEffectiveInstanceAssociationsRequest), arg0)
}

// DescribeEffectiveInstanceAssociationsWithContext mocks base method
func (m *MockSSMAPI) DescribeEffectiveInstanceAssociationsWithContext(arg0 context.Context, arg1 *ssm.DescribeEffectiveInstanceAssociationsInput, arg2 ...request.Option) (*ssm.DescribeEffectiveInstanceAssociationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeEffectiveInstanceAssociationsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeEffectiveInstanceAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeEffectiveInstanceAssociationsWithContext indicates an expected call of DescribeEffectiveInstanceAssociationsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeEffectiveInstanceAssociationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEffectiveInstanceAssociationsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeEffectiveInstanceAssociationsWithContext), varargs...)
}

// DescribeEffectivePatchesForPatchBaseline mocks base method
func (m *MockSSMAPI) DescribeEffectivePatchesForPatchBaseline(arg0 *ssm.DescribeEffectivePatchesForPatchBaselineInput) (*ssm.DescribeEffectivePatchesForPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeEffectivePatchesForPatchBaseline", arg0)
	ret0, _ := ret[0].(*ssm.DescribeEffectivePatchesForPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeEffectivePatchesForPatchBaseline indicates an expected call of DescribeEffectivePatchesForPatchBaseline
func (mr *MockSSMAPIMockRecorder) DescribeEffectivePatchesForPatchBaseline(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEffectivePatchesForPatchBaseline", reflect.TypeOf((*MockSSMAPI)(nil).DescribeEffectivePatchesForPatchBaseline), arg0)
}

// DescribeEffectivePatchesForPatchBaselineRequest mocks base method
func (m *MockSSMAPI) DescribeEffectivePatchesForPatchBaselineRequest(arg0 *ssm.DescribeEffectivePatchesForPatchBaselineInput) (*request.Request, *ssm.DescribeEffectivePatchesForPatchBaselineOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeEffectivePatchesForPatchBaselineRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeEffectivePatchesForPatchBaselineOutput)
	return ret0, ret1
}

// DescribeEffectivePatchesForPatchBaselineRequest indicates an expected call of DescribeEffectivePatchesForPatchBaselineRequest
func (mr *MockSSMAPIMockRecorder) DescribeEffectivePatchesForPatchBaselineRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEffectivePatchesForPatchBaselineRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeEffectivePatchesForPatchBaselineRequest), arg0)
}

// DescribeEffectivePatchesForPatchBaselineWithContext mocks base method
func (m *MockSSMAPI) DescribeEffectivePatchesForPatchBaselineWithContext(arg0 context.Context, arg1 *ssm.DescribeEffectivePatchesForPatchBaselineInput, arg2 ...request.Option) (*ssm.DescribeEffectivePatchesForPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeEffectivePatchesForPatchBaselineWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeEffectivePatchesForPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeEffectivePatchesForPatchBaselineWithContext indicates an expected call of DescribeEffectivePatchesForPatchBaselineWithContext
func (mr *MockSSMAPIMockRecorder) DescribeEffectivePatchesForPatchBaselineWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeEffectivePatchesForPatchBaselineWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeEffectivePatchesForPatchBaselineWithContext), varargs...)
}

// DescribeInstanceAssociationsStatus mocks base method
func (m *MockSSMAPI) DescribeInstanceAssociationsStatus(arg0 *ssm.DescribeInstanceAssociationsStatusInput) (*ssm.DescribeInstanceAssociationsStatusOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceAssociationsStatus", arg0)
	ret0, _ := ret[0].(*ssm.DescribeInstanceAssociationsStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceAssociationsStatus indicates an expected call of DescribeInstanceAssociationsStatus
func (mr *MockSSMAPIMockRecorder) DescribeInstanceAssociationsStatus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceAssociationsStatus", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceAssociationsStatus), arg0)
}

// DescribeInstanceAssociationsStatusRequest mocks base method
func (m *MockSSMAPI) DescribeInstanceAssociationsStatusRequest(arg0 *ssm.DescribeInstanceAssociationsStatusInput) (*request.Request, *ssm.DescribeInstanceAssociationsStatusOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceAssociationsStatusRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeInstanceAssociationsStatusOutput)
	return ret0, ret1
}

// DescribeInstanceAssociationsStatusRequest indicates an expected call of DescribeInstanceAssociationsStatusRequest
func (mr *MockSSMAPIMockRecorder) DescribeInstanceAssociationsStatusRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceAssociationsStatusRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceAssociationsStatusRequest), arg0)
}

// DescribeInstanceAssociationsStatusWithContext mocks base method
func (m *MockSSMAPI) DescribeInstanceAssociationsStatusWithContext(arg0 context.Context, arg1 *ssm.DescribeInstanceAssociationsStatusInput, arg2 ...request.Option) (*ssm.DescribeInstanceAssociationsStatusOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceAssociationsStatusWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeInstanceAssociationsStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceAssociationsStatusWithContext indicates an expected call of DescribeInstanceAssociationsStatusWithContext
func (mr *MockSSMAPIMockRecorder) DescribeInstanceAssociationsStatusWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceAssociationsStatusWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceAssociationsStatusWithContext), varargs...)
}

// DescribeInstanceInformation mocks base method
func (m *MockSSMAPI) DescribeInstanceInformation(arg0 *ssm.DescribeInstanceInformationInput) (*ssm.DescribeInstanceInformationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceInformation", arg0)
	ret0, _ := ret[0].(*ssm.DescribeInstanceInformationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceInformation indicates an expected call of DescribeInstanceInformation
func (mr *MockSSMAPIMockRecorder) DescribeInstanceInformation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceInformation", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceInformation), arg0)
}

// DescribeInstanceInformationPages mocks base method
func (m *MockSSMAPI) DescribeInstanceInformationPages(arg0 *ssm.DescribeInstanceInformationInput, arg1 func(*ssm.DescribeInstanceInformationOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceInformationPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceInformationPages indicates an expected call of DescribeInstanceInformationPages
func (mr *MockSSMAPIMockRecorder) DescribeInstanceInformationPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceInformationPages", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceInformationPages), arg0, arg1)
}

// DescribeInstanceInformationPagesWithContext mocks base method
func (m *MockSSMAPI) DescribeInstanceInformationPagesWithContext(arg0 context.Context, arg1 *ssm.DescribeInstanceInformationInput, arg2 func(*ssm.DescribeInstanceInformationOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceInformationPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeInstanceInformationPagesWithContext indicates an expected call of DescribeInstanceInformationPagesWithContext
func (mr *MockSSMAPIMockRecorder) DescribeInstanceInformationPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceInformationPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceInformationPagesWithContext), varargs...)
}

// DescribeInstanceInformationRequest mocks base method
func (m *MockSSMAPI) DescribeInstanceInformationRequest(arg0 *ssm.DescribeInstanceInformationInput) (*request.Request, *ssm.DescribeInstanceInformationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstanceInformationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeInstanceInformationOutput)
	return ret0, ret1
}

// DescribeInstanceInformationRequest indicates an expected call of DescribeInstanceInformationRequest
func (mr *MockSSMAPIMockRecorder) DescribeInstanceInformationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceInformationRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceInformationRequest), arg0)
}

// DescribeInstanceInformationWithContext mocks base method
func (m *MockSSMAPI) DescribeInstanceInformationWithContext(arg0 context.Context, arg1 *ssm.DescribeInstanceInformationInput, arg2 ...request.Option) (*ssm.DescribeInstanceInformationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstanceInformationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeInstanceInformationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstanceInformationWithContext indicates an expected call of DescribeInstanceInformationWithContext
func (mr *MockSSMAPIMockRecorder) DescribeInstanceInformationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstanceInformationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstanceInformationWithContext), varargs...)
}

// DescribeInstancePatchStates mocks base method
func (m *MockSSMAPI) DescribeInstancePatchStates(arg0 *ssm.DescribeInstancePatchStatesInput) (*ssm.DescribeInstancePatchStatesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancePatchStates", arg0)
	ret0, _ := ret[0].(*ssm.DescribeInstancePatchStatesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstancePatchStates indicates an expected call of DescribeInstancePatchStates
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchStates(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchStates", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchStates), arg0)
}

// DescribeInstancePatchStatesForPatchGroup mocks base method
func (m *MockSSMAPI) DescribeInstancePatchStatesForPatchGroup(arg0 *ssm.DescribeInstancePatchStatesForPatchGroupInput) (*ssm.DescribeInstancePatchStatesForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancePatchStatesForPatchGroup", arg0)
	ret0, _ := ret[0].(*ssm.DescribeInstancePatchStatesForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstancePatchStatesForPatchGroup indicates an expected call of DescribeInstancePatchStatesForPatchGroup
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchStatesForPatchGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchStatesForPatchGroup", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchStatesForPatchGroup), arg0)
}

// DescribeInstancePatchStatesForPatchGroupRequest mocks base method
func (m *MockSSMAPI) DescribeInstancePatchStatesForPatchGroupRequest(arg0 *ssm.DescribeInstancePatchStatesForPatchGroupInput) (*request.Request, *ssm.DescribeInstancePatchStatesForPatchGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancePatchStatesForPatchGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeInstancePatchStatesForPatchGroupOutput)
	return ret0, ret1
}

// DescribeInstancePatchStatesForPatchGroupRequest indicates an expected call of DescribeInstancePatchStatesForPatchGroupRequest
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchStatesForPatchGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchStatesForPatchGroupRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchStatesForPatchGroupRequest), arg0)
}

// DescribeInstancePatchStatesForPatchGroupWithContext mocks base method
func (m *MockSSMAPI) DescribeInstancePatchStatesForPatchGroupWithContext(arg0 context.Context, arg1 *ssm.DescribeInstancePatchStatesForPatchGroupInput, arg2 ...request.Option) (*ssm.DescribeInstancePatchStatesForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstancePatchStatesForPatchGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeInstancePatchStatesForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstancePatchStatesForPatchGroupWithContext indicates an expected call of DescribeInstancePatchStatesForPatchGroupWithContext
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchStatesForPatchGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchStatesForPatchGroupWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchStatesForPatchGroupWithContext), varargs...)
}

// DescribeInstancePatchStatesRequest mocks base method
func (m *MockSSMAPI) DescribeInstancePatchStatesRequest(arg0 *ssm.DescribeInstancePatchStatesInput) (*request.Request, *ssm.DescribeInstancePatchStatesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancePatchStatesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeInstancePatchStatesOutput)
	return ret0, ret1
}

// DescribeInstancePatchStatesRequest indicates an expected call of DescribeInstancePatchStatesRequest
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchStatesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchStatesRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchStatesRequest), arg0)
}

// DescribeInstancePatchStatesWithContext mocks base method
func (m *MockSSMAPI) DescribeInstancePatchStatesWithContext(arg0 context.Context, arg1 *ssm.DescribeInstancePatchStatesInput, arg2 ...request.Option) (*ssm.DescribeInstancePatchStatesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstancePatchStatesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeInstancePatchStatesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstancePatchStatesWithContext indicates an expected call of DescribeInstancePatchStatesWithContext
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchStatesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchStatesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchStatesWithContext), varargs...)
}

// DescribeInstancePatches mocks base method
func (m *MockSSMAPI) DescribeInstancePatches(arg0 *ssm.DescribeInstancePatchesInput) (*ssm.DescribeInstancePatchesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancePatches", arg0)
	ret0, _ := ret[0].(*ssm.DescribeInstancePatchesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstancePatches indicates an expected call of DescribeInstancePatches
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatches(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatches", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatches), arg0)
}

// DescribeInstancePatchesRequest mocks base method
func (m *MockSSMAPI) DescribeInstancePatchesRequest(arg0 *ssm.DescribeInstancePatchesInput) (*request.Request, *ssm.DescribeInstancePatchesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInstancePatchesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeInstancePatchesOutput)
	return ret0, ret1
}

// DescribeInstancePatchesRequest indicates an expected call of DescribeInstancePatchesRequest
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchesRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchesRequest), arg0)
}

// DescribeInstancePatchesWithContext mocks base method
func (m *MockSSMAPI) DescribeInstancePatchesWithContext(arg0 context.Context, arg1 *ssm.DescribeInstancePatchesInput, arg2 ...request.Option) (*ssm.DescribeInstancePatchesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInstancePatchesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeInstancePatchesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInstancePatchesWithContext indicates an expected call of DescribeInstancePatchesWithContext
func (mr *MockSSMAPIMockRecorder) DescribeInstancePatchesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInstancePatchesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInstancePatchesWithContext), varargs...)
}

// DescribeInventoryDeletions mocks base method
func (m *MockSSMAPI) DescribeInventoryDeletions(arg0 *ssm.DescribeInventoryDeletionsInput) (*ssm.DescribeInventoryDeletionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInventoryDeletions", arg0)
	ret0, _ := ret[0].(*ssm.DescribeInventoryDeletionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInventoryDeletions indicates an expected call of DescribeInventoryDeletions
func (mr *MockSSMAPIMockRecorder) DescribeInventoryDeletions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInventoryDeletions", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInventoryDeletions), arg0)
}

// DescribeInventoryDeletionsRequest mocks base method
func (m *MockSSMAPI) DescribeInventoryDeletionsRequest(arg0 *ssm.DescribeInventoryDeletionsInput) (*request.Request, *ssm.DescribeInventoryDeletionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeInventoryDeletionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeInventoryDeletionsOutput)
	return ret0, ret1
}

// DescribeInventoryDeletionsRequest indicates an expected call of DescribeInventoryDeletionsRequest
func (mr *MockSSMAPIMockRecorder) DescribeInventoryDeletionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInventoryDeletionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInventoryDeletionsRequest), arg0)
}

// DescribeInventoryDeletionsWithContext mocks base method
func (m *MockSSMAPI) DescribeInventoryDeletionsWithContext(arg0 context.Context, arg1 *ssm.DescribeInventoryDeletionsInput, arg2 ...request.Option) (*ssm.DescribeInventoryDeletionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeInventoryDeletionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeInventoryDeletionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeInventoryDeletionsWithContext indicates an expected call of DescribeInventoryDeletionsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeInventoryDeletionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeInventoryDeletionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeInventoryDeletionsWithContext), varargs...)
}

// DescribeMaintenanceWindowExecutionTaskInvocations mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionTaskInvocations(arg0 *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput) (*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionTaskInvocations", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionTaskInvocations indicates an expected call of DescribeMaintenanceWindowExecutionTaskInvocations
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionTaskInvocations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionTaskInvocations", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionTaskInvocations), arg0)
}

// DescribeMaintenanceWindowExecutionTaskInvocationsRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionTaskInvocationsRequest(arg0 *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput) (*request.Request, *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionTaskInvocationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionTaskInvocationsRequest indicates an expected call of DescribeMaintenanceWindowExecutionTaskInvocationsRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionTaskInvocationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionTaskInvocationsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionTaskInvocationsRequest), arg0)
}

// DescribeMaintenanceWindowExecutionTaskInvocationsWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionTaskInvocationsWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionTaskInvocationsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionTaskInvocationsWithContext indicates an expected call of DescribeMaintenanceWindowExecutionTaskInvocationsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionTaskInvocationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionTaskInvocationsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionTaskInvocationsWithContext), varargs...)
}

// DescribeMaintenanceWindowExecutionTasks mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionTasks(arg0 *ssm.DescribeMaintenanceWindowExecutionTasksInput) (*ssm.DescribeMaintenanceWindowExecutionTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionTasks", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowExecutionTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionTasks indicates an expected call of DescribeMaintenanceWindowExecutionTasks
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionTasks", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionTasks), arg0)
}

// DescribeMaintenanceWindowExecutionTasksRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionTasksRequest(arg0 *ssm.DescribeMaintenanceWindowExecutionTasksInput) (*request.Request, *ssm.DescribeMaintenanceWindowExecutionTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowExecutionTasksOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionTasksRequest indicates an expected call of DescribeMaintenanceWindowExecutionTasksRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionTasksRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionTasksRequest), arg0)
}

// DescribeMaintenanceWindowExecutionTasksWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionTasksWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowExecutionTasksInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowExecutionTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowExecutionTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionTasksWithContext indicates an expected call of DescribeMaintenanceWindowExecutionTasksWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionTasksWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionTasksWithContext), varargs...)
}

// DescribeMaintenanceWindowExecutions mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutions(arg0 *ssm.DescribeMaintenanceWindowExecutionsInput) (*ssm.DescribeMaintenanceWindowExecutionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutions", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutions indicates an expected call of DescribeMaintenanceWindowExecutions
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutions", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutions), arg0)
}

// DescribeMaintenanceWindowExecutionsRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionsRequest(arg0 *ssm.DescribeMaintenanceWindowExecutionsInput) (*request.Request, *ssm.DescribeMaintenanceWindowExecutionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowExecutionsOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionsRequest indicates an expected call of DescribeMaintenanceWindowExecutionsRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionsRequest), arg0)
}

// DescribeMaintenanceWindowExecutionsWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowExecutionsWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowExecutionsInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowExecutionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowExecutionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowExecutionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowExecutionsWithContext indicates an expected call of DescribeMaintenanceWindowExecutionsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowExecutionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowExecutionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowExecutionsWithContext), varargs...)
}

// DescribeMaintenanceWindowSchedule mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowSchedule(arg0 *ssm.DescribeMaintenanceWindowScheduleInput) (*ssm.DescribeMaintenanceWindowScheduleOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowSchedule", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowScheduleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowSchedule indicates an expected call of DescribeMaintenanceWindowSchedule
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowSchedule(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowSchedule", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowSchedule), arg0)
}

// DescribeMaintenanceWindowScheduleRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowScheduleRequest(arg0 *ssm.DescribeMaintenanceWindowScheduleInput) (*request.Request, *ssm.DescribeMaintenanceWindowScheduleOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowScheduleRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowScheduleOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowScheduleRequest indicates an expected call of DescribeMaintenanceWindowScheduleRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowScheduleRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowScheduleRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowScheduleRequest), arg0)
}

// DescribeMaintenanceWindowScheduleWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowScheduleWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowScheduleInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowScheduleOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowScheduleWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowScheduleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowScheduleWithContext indicates an expected call of DescribeMaintenanceWindowScheduleWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowScheduleWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowScheduleWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowScheduleWithContext), varargs...)
}

// DescribeMaintenanceWindowTargets mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowTargets(arg0 *ssm.DescribeMaintenanceWindowTargetsInput) (*ssm.DescribeMaintenanceWindowTargetsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowTargets", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowTargetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowTargets indicates an expected call of DescribeMaintenanceWindowTargets
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowTargets(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowTargets", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowTargets), arg0)
}

// DescribeMaintenanceWindowTargetsRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowTargetsRequest(arg0 *ssm.DescribeMaintenanceWindowTargetsInput) (*request.Request, *ssm.DescribeMaintenanceWindowTargetsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowTargetsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowTargetsOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowTargetsRequest indicates an expected call of DescribeMaintenanceWindowTargetsRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowTargetsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowTargetsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowTargetsRequest), arg0)
}

// DescribeMaintenanceWindowTargetsWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowTargetsWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowTargetsInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowTargetsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowTargetsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowTargetsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowTargetsWithContext indicates an expected call of DescribeMaintenanceWindowTargetsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowTargetsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowTargetsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowTargetsWithContext), varargs...)
}

// DescribeMaintenanceWindowTasks mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowTasks(arg0 *ssm.DescribeMaintenanceWindowTasksInput) (*ssm.DescribeMaintenanceWindowTasksOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowTasks", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowTasks indicates an expected call of DescribeMaintenanceWindowTasks
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowTasks(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowTasks", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowTasks), arg0)
}

// DescribeMaintenanceWindowTasksRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowTasksRequest(arg0 *ssm.DescribeMaintenanceWindowTasksInput) (*request.Request, *ssm.DescribeMaintenanceWindowTasksOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowTasksRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowTasksOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowTasksRequest indicates an expected call of DescribeMaintenanceWindowTasksRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowTasksRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowTasksRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowTasksRequest), arg0)
}

// DescribeMaintenanceWindowTasksWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowTasksWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowTasksInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowTasksOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowTasksWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowTasksOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowTasksWithContext indicates an expected call of DescribeMaintenanceWindowTasksWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowTasksWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowTasksWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowTasksWithContext), varargs...)
}

// DescribeMaintenanceWindows mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindows(arg0 *ssm.DescribeMaintenanceWindowsInput) (*ssm.DescribeMaintenanceWindowsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindows", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindows indicates an expected call of DescribeMaintenanceWindows
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindows(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindows", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindows), arg0)
}

// DescribeMaintenanceWindowsForTarget mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowsForTarget(arg0 *ssm.DescribeMaintenanceWindowsForTargetInput) (*ssm.DescribeMaintenanceWindowsForTargetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowsForTarget", arg0)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowsForTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowsForTarget indicates an expected call of DescribeMaintenanceWindowsForTarget
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowsForTarget(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowsForTarget", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowsForTarget), arg0)
}

// DescribeMaintenanceWindowsForTargetRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowsForTargetRequest(arg0 *ssm.DescribeMaintenanceWindowsForTargetInput) (*request.Request, *ssm.DescribeMaintenanceWindowsForTargetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowsForTargetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowsForTargetOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowsForTargetRequest indicates an expected call of DescribeMaintenanceWindowsForTargetRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowsForTargetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowsForTargetRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowsForTargetRequest), arg0)
}

// DescribeMaintenanceWindowsForTargetWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowsForTargetWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowsForTargetInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowsForTargetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowsForTargetWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowsForTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowsForTargetWithContext indicates an expected call of DescribeMaintenanceWindowsForTargetWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowsForTargetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowsForTargetWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowsForTargetWithContext), varargs...)
}

// DescribeMaintenanceWindowsRequest mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowsRequest(arg0 *ssm.DescribeMaintenanceWindowsInput) (*request.Request, *ssm.DescribeMaintenanceWindowsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeMaintenanceWindowsOutput)
	return ret0, ret1
}

// DescribeMaintenanceWindowsRequest indicates an expected call of DescribeMaintenanceWindowsRequest
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowsRequest), arg0)
}

// DescribeMaintenanceWindowsWithContext mocks base method
func (m *MockSSMAPI) DescribeMaintenanceWindowsWithContext(arg0 context.Context, arg1 *ssm.DescribeMaintenanceWindowsInput, arg2 ...request.Option) (*ssm.DescribeMaintenanceWindowsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeMaintenanceWindowsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeMaintenanceWindowsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeMaintenanceWindowsWithContext indicates an expected call of DescribeMaintenanceWindowsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeMaintenanceWindowsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeMaintenanceWindowsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeMaintenanceWindowsWithContext), varargs...)
}

// DescribeOpsItems mocks base method
func (m *MockSSMAPI) DescribeOpsItems(arg0 *ssm.DescribeOpsItemsInput) (*ssm.DescribeOpsItemsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeOpsItems", arg0)
	ret0, _ := ret[0].(*ssm.DescribeOpsItemsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeOpsItems indicates an expected call of DescribeOpsItems
func (mr *MockSSMAPIMockRecorder) DescribeOpsItems(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeOpsItems", reflect.TypeOf((*MockSSMAPI)(nil).DescribeOpsItems), arg0)
}

// DescribeOpsItemsRequest mocks base method
func (m *MockSSMAPI) DescribeOpsItemsRequest(arg0 *ssm.DescribeOpsItemsInput) (*request.Request, *ssm.DescribeOpsItemsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeOpsItemsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeOpsItemsOutput)
	return ret0, ret1
}

// DescribeOpsItemsRequest indicates an expected call of DescribeOpsItemsRequest
func (mr *MockSSMAPIMockRecorder) DescribeOpsItemsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeOpsItemsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeOpsItemsRequest), arg0)
}

// DescribeOpsItemsWithContext mocks base method
func (m *MockSSMAPI) DescribeOpsItemsWithContext(arg0 context.Context, arg1 *ssm.DescribeOpsItemsInput, arg2 ...request.Option) (*ssm.DescribeOpsItemsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeOpsItemsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeOpsItemsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeOpsItemsWithContext indicates an expected call of DescribeOpsItemsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeOpsItemsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeOpsItemsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeOpsItemsWithContext), varargs...)
}

// DescribeParameters mocks base method
func (m *MockSSMAPI) DescribeParameters(arg0 *ssm.DescribeParametersInput) (*ssm.DescribeParametersOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeParameters", arg0)
	ret0, _ := ret[0].(*ssm.DescribeParametersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeParameters indicates an expected call of DescribeParameters
func (mr *MockSSMAPIMockRecorder) DescribeParameters(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeParameters", reflect.TypeOf((*MockSSMAPI)(nil).DescribeParameters), arg0)
}

// DescribeParametersPages mocks base method
func (m *MockSSMAPI) DescribeParametersPages(arg0 *ssm.DescribeParametersInput, arg1 func(*ssm.DescribeParametersOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeParametersPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeParametersPages indicates an expected call of DescribeParametersPages
func (mr *MockSSMAPIMockRecorder) DescribeParametersPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeParametersPages", reflect.TypeOf((*MockSSMAPI)(nil).DescribeParametersPages), arg0, arg1)
}

// DescribeParametersPagesWithContext mocks base method
func (m *MockSSMAPI) DescribeParametersPagesWithContext(arg0 context.Context, arg1 *ssm.DescribeParametersInput, arg2 func(*ssm.DescribeParametersOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeParametersPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DescribeParametersPagesWithContext indicates an expected call of DescribeParametersPagesWithContext
func (mr *MockSSMAPIMockRecorder) DescribeParametersPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeParametersPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeParametersPagesWithContext), varargs...)
}

// DescribeParametersRequest mocks base method
func (m *MockSSMAPI) DescribeParametersRequest(arg0 *ssm.DescribeParametersInput) (*request.Request, *ssm.DescribeParametersOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeParametersRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeParametersOutput)
	return ret0, ret1
}

// DescribeParametersRequest indicates an expected call of DescribeParametersRequest
func (mr *MockSSMAPIMockRecorder) DescribeParametersRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeParametersRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeParametersRequest), arg0)
}

// DescribeParametersWithContext mocks base method
func (m *MockSSMAPI) DescribeParametersWithContext(arg0 context.Context, arg1 *ssm.DescribeParametersInput, arg2 ...request.Option) (*ssm.DescribeParametersOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeParametersWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeParametersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeParametersWithContext indicates an expected call of DescribeParametersWithContext
func (mr *MockSSMAPIMockRecorder) DescribeParametersWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeParametersWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeParametersWithContext), varargs...)
}

// DescribePatchBaselines mocks base method
func (m *MockSSMAPI) DescribePatchBaselines(arg0 *ssm.DescribePatchBaselinesInput) (*ssm.DescribePatchBaselinesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchBaselines", arg0)
	ret0, _ := ret[0].(*ssm.DescribePatchBaselinesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchBaselines indicates an expected call of DescribePatchBaselines
func (mr *MockSSMAPIMockRecorder) DescribePatchBaselines(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchBaselines", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchBaselines), arg0)
}

// DescribePatchBaselinesRequest mocks base method
func (m *MockSSMAPI) DescribePatchBaselinesRequest(arg0 *ssm.DescribePatchBaselinesInput) (*request.Request, *ssm.DescribePatchBaselinesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchBaselinesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribePatchBaselinesOutput)
	return ret0, ret1
}

// DescribePatchBaselinesRequest indicates an expected call of DescribePatchBaselinesRequest
func (mr *MockSSMAPIMockRecorder) DescribePatchBaselinesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchBaselinesRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchBaselinesRequest), arg0)
}

// DescribePatchBaselinesWithContext mocks base method
func (m *MockSSMAPI) DescribePatchBaselinesWithContext(arg0 context.Context, arg1 *ssm.DescribePatchBaselinesInput, arg2 ...request.Option) (*ssm.DescribePatchBaselinesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePatchBaselinesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribePatchBaselinesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchBaselinesWithContext indicates an expected call of DescribePatchBaselinesWithContext
func (mr *MockSSMAPIMockRecorder) DescribePatchBaselinesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchBaselinesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchBaselinesWithContext), varargs...)
}

// DescribePatchGroupState mocks base method
func (m *MockSSMAPI) DescribePatchGroupState(arg0 *ssm.DescribePatchGroupStateInput) (*ssm.DescribePatchGroupStateOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchGroupState", arg0)
	ret0, _ := ret[0].(*ssm.DescribePatchGroupStateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchGroupState indicates an expected call of DescribePatchGroupState
func (mr *MockSSMAPIMockRecorder) DescribePatchGroupState(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchGroupState", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchGroupState), arg0)
}

// DescribePatchGroupStateRequest mocks base method
func (m *MockSSMAPI) DescribePatchGroupStateRequest(arg0 *ssm.DescribePatchGroupStateInput) (*request.Request, *ssm.DescribePatchGroupStateOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchGroupStateRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribePatchGroupStateOutput)
	return ret0, ret1
}

// DescribePatchGroupStateRequest indicates an expected call of DescribePatchGroupStateRequest
func (mr *MockSSMAPIMockRecorder) DescribePatchGroupStateRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchGroupStateRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchGroupStateRequest), arg0)
}

// DescribePatchGroupStateWithContext mocks base method
func (m *MockSSMAPI) DescribePatchGroupStateWithContext(arg0 context.Context, arg1 *ssm.DescribePatchGroupStateInput, arg2 ...request.Option) (*ssm.DescribePatchGroupStateOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePatchGroupStateWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribePatchGroupStateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchGroupStateWithContext indicates an expected call of DescribePatchGroupStateWithContext
func (mr *MockSSMAPIMockRecorder) DescribePatchGroupStateWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchGroupStateWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchGroupStateWithContext), varargs...)
}

// DescribePatchGroups mocks base method
func (m *MockSSMAPI) DescribePatchGroups(arg0 *ssm.DescribePatchGroupsInput) (*ssm.DescribePatchGroupsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchGroups", arg0)
	ret0, _ := ret[0].(*ssm.DescribePatchGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchGroups indicates an expected call of DescribePatchGroups
func (mr *MockSSMAPIMockRecorder) DescribePatchGroups(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchGroups", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchGroups), arg0)
}

// DescribePatchGroupsRequest mocks base method
func (m *MockSSMAPI) DescribePatchGroupsRequest(arg0 *ssm.DescribePatchGroupsInput) (*request.Request, *ssm.DescribePatchGroupsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchGroupsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribePatchGroupsOutput)
	return ret0, ret1
}

// DescribePatchGroupsRequest indicates an expected call of DescribePatchGroupsRequest
func (mr *MockSSMAPIMockRecorder) DescribePatchGroupsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchGroupsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchGroupsRequest), arg0)
}

// DescribePatchGroupsWithContext mocks base method
func (m *MockSSMAPI) DescribePatchGroupsWithContext(arg0 context.Context, arg1 *ssm.DescribePatchGroupsInput, arg2 ...request.Option) (*ssm.DescribePatchGroupsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePatchGroupsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribePatchGroupsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchGroupsWithContext indicates an expected call of DescribePatchGroupsWithContext
func (mr *MockSSMAPIMockRecorder) DescribePatchGroupsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchGroupsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchGroupsWithContext), varargs...)
}

// DescribePatchProperties mocks base method
func (m *MockSSMAPI) DescribePatchProperties(arg0 *ssm.DescribePatchPropertiesInput) (*ssm.DescribePatchPropertiesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchProperties", arg0)
	ret0, _ := ret[0].(*ssm.DescribePatchPropertiesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchProperties indicates an expected call of DescribePatchProperties
func (mr *MockSSMAPIMockRecorder) DescribePatchProperties(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchProperties", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchProperties), arg0)
}

// DescribePatchPropertiesRequest mocks base method
func (m *MockSSMAPI) DescribePatchPropertiesRequest(arg0 *ssm.DescribePatchPropertiesInput) (*request.Request, *ssm.DescribePatchPropertiesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribePatchPropertiesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribePatchPropertiesOutput)
	return ret0, ret1
}

// DescribePatchPropertiesRequest indicates an expected call of DescribePatchPropertiesRequest
func (mr *MockSSMAPIMockRecorder) DescribePatchPropertiesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchPropertiesRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchPropertiesRequest), arg0)
}

// DescribePatchPropertiesWithContext mocks base method
func (m *MockSSMAPI) DescribePatchPropertiesWithContext(arg0 context.Context, arg1 *ssm.DescribePatchPropertiesInput, arg2 ...request.Option) (*ssm.DescribePatchPropertiesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribePatchPropertiesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribePatchPropertiesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribePatchPropertiesWithContext indicates an expected call of DescribePatchPropertiesWithContext
func (mr *MockSSMAPIMockRecorder) DescribePatchPropertiesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribePatchPropertiesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribePatchPropertiesWithContext), varargs...)
}

// DescribeSessions mocks base method
func (m *MockSSMAPI) DescribeSessions(arg0 *ssm.DescribeSessionsInput) (*ssm.DescribeSessionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSessions", arg0)
	ret0, _ := ret[0].(*ssm.DescribeSessionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSessions indicates an expected call of DescribeSessions
func (mr *MockSSMAPIMockRecorder) DescribeSessions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSessions", reflect.TypeOf((*MockSSMAPI)(nil).DescribeSessions), arg0)
}

// DescribeSessionsRequest mocks base method
func (m *MockSSMAPI) DescribeSessionsRequest(arg0 *ssm.DescribeSessionsInput) (*request.Request, *ssm.DescribeSessionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DescribeSessionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.DescribeSessionsOutput)
	return ret0, ret1
}

// DescribeSessionsRequest indicates an expected call of DescribeSessionsRequest
func (mr *MockSSMAPIMockRecorder) DescribeSessionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSessionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).DescribeSessionsRequest), arg0)
}

// DescribeSessionsWithContext mocks base method
func (m *MockSSMAPI) DescribeSessionsWithContext(arg0 context.Context, arg1 *ssm.DescribeSessionsInput, arg2 ...request.Option) (*ssm.DescribeSessionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DescribeSessionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.DescribeSessionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DescribeSessionsWithContext indicates an expected call of DescribeSessionsWithContext
func (mr *MockSSMAPIMockRecorder) DescribeSessionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DescribeSessionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).DescribeSessionsWithContext), varargs...)
}

// GetAutomationExecution mocks base method
func (m *MockSSMAPI) GetAutomationExecution(arg0 *ssm.GetAutomationExecutionInput) (*ssm.GetAutomationExecutionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAutomationExecution", arg0)
	ret0, _ := ret[0].(*ssm.GetAutomationExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAutomationExecution indicates an expected call of GetAutomationExecution
func (mr *MockSSMAPIMockRecorder) GetAutomationExecution(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAutomationExecution", reflect.TypeOf((*MockSSMAPI)(nil).GetAutomationExecution), arg0)
}

// GetAutomationExecutionRequest mocks base method
func (m *MockSSMAPI) GetAutomationExecutionRequest(arg0 *ssm.GetAutomationExecutionInput) (*request.Request, *ssm.GetAutomationExecutionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAutomationExecutionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetAutomationExecutionOutput)
	return ret0, ret1
}

// GetAutomationExecutionRequest indicates an expected call of GetAutomationExecutionRequest
func (mr *MockSSMAPIMockRecorder) GetAutomationExecutionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAutomationExecutionRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetAutomationExecutionRequest), arg0)
}

// GetAutomationExecutionWithContext mocks base method
func (m *MockSSMAPI) GetAutomationExecutionWithContext(arg0 context.Context, arg1 *ssm.GetAutomationExecutionInput, arg2 ...request.Option) (*ssm.GetAutomationExecutionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetAutomationExecutionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetAutomationExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetAutomationExecutionWithContext indicates an expected call of GetAutomationExecutionWithContext
func (mr *MockSSMAPIMockRecorder) GetAutomationExecutionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAutomationExecutionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetAutomationExecutionWithContext), varargs...)
}

// GetCalendarState mocks base method
func (m *MockSSMAPI) GetCalendarState(arg0 *ssm.GetCalendarStateInput) (*ssm.GetCalendarStateOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCalendarState", arg0)
	ret0, _ := ret[0].(*ssm.GetCalendarStateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCalendarState indicates an expected call of GetCalendarState
func (mr *MockSSMAPIMockRecorder) GetCalendarState(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCalendarState", reflect.TypeOf((*MockSSMAPI)(nil).GetCalendarState), arg0)
}

// GetCalendarStateRequest mocks base method
func (m *MockSSMAPI) GetCalendarStateRequest(arg0 *ssm.GetCalendarStateInput) (*request.Request, *ssm.GetCalendarStateOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCalendarStateRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetCalendarStateOutput)
	return ret0, ret1
}

// GetCalendarStateRequest indicates an expected call of GetCalendarStateRequest
func (mr *MockSSMAPIMockRecorder) GetCalendarStateRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCalendarStateRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetCalendarStateRequest), arg0)
}

// GetCalendarStateWithContext mocks base method
func (m *MockSSMAPI) GetCalendarStateWithContext(arg0 context.Context, arg1 *ssm.GetCalendarStateInput, arg2 ...request.Option) (*ssm.GetCalendarStateOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetCalendarStateWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetCalendarStateOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCalendarStateWithContext indicates an expected call of GetCalendarStateWithContext
func (mr *MockSSMAPIMockRecorder) GetCalendarStateWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCalendarStateWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetCalendarStateWithContext), varargs...)
}

// GetCommandInvocation mocks base method
func (m *MockSSMAPI) GetCommandInvocation(arg0 *ssm.GetCommandInvocationInput) (*ssm.GetCommandInvocationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCommandInvocation", arg0)
	ret0, _ := ret[0].(*ssm.GetCommandInvocationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCommandInvocation indicates an expected call of GetCommandInvocation
func (mr *MockSSMAPIMockRecorder) GetCommandInvocation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCommandInvocation", reflect.TypeOf((*MockSSMAPI)(nil).GetCommandInvocation), arg0)
}

// GetCommandInvocationRequest mocks base method
func (m *MockSSMAPI) GetCommandInvocationRequest(arg0 *ssm.GetCommandInvocationInput) (*request.Request, *ssm.GetCommandInvocationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCommandInvocationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetCommandInvocationOutput)
	return ret0, ret1
}

// GetCommandInvocationRequest indicates an expected call of GetCommandInvocationRequest
func (mr *MockSSMAPIMockRecorder) GetCommandInvocationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCommandInvocationRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetCommandInvocationRequest), arg0)
}

// GetCommandInvocationWithContext mocks base method
func (m *MockSSMAPI) GetCommandInvocationWithContext(arg0 context.Context, arg1 *ssm.GetCommandInvocationInput, arg2 ...request.Option) (*ssm.GetCommandInvocationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetCommandInvocationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetCommandInvocationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetCommandInvocationWithContext indicates an expected call of GetCommandInvocationWithContext
func (mr *MockSSMAPIMockRecorder) GetCommandInvocationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCommandInvocationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetCommandInvocationWithContext), varargs...)
}

// GetConnectionStatus mocks base method
func (m *MockSSMAPI) GetConnectionStatus(arg0 *ssm.GetConnectionStatusInput) (*ssm.GetConnectionStatusOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConnectionStatus", arg0)
	ret0, _ := ret[0].(*ssm.GetConnectionStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetConnectionStatus indicates an expected call of GetConnectionStatus
func (mr *MockSSMAPIMockRecorder) GetConnectionStatus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConnectionStatus", reflect.TypeOf((*MockSSMAPI)(nil).GetConnectionStatus), arg0)
}

// GetConnectionStatusRequest mocks base method
func (m *MockSSMAPI) GetConnectionStatusRequest(arg0 *ssm.GetConnectionStatusInput) (*request.Request, *ssm.GetConnectionStatusOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConnectionStatusRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetConnectionStatusOutput)
	return ret0, ret1
}

// GetConnectionStatusRequest indicates an expected call of GetConnectionStatusRequest
func (mr *MockSSMAPIMockRecorder) GetConnectionStatusRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConnectionStatusRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetConnectionStatusRequest), arg0)
}

// GetConnectionStatusWithContext mocks base method
func (m *MockSSMAPI) GetConnectionStatusWithContext(arg0 context.Context, arg1 *ssm.GetConnectionStatusInput, arg2 ...request.Option) (*ssm.GetConnectionStatusOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetConnectionStatusWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetConnectionStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetConnectionStatusWithContext indicates an expected call of GetConnectionStatusWithContext
func (mr *MockSSMAPIMockRecorder) GetConnectionStatusWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConnectionStatusWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetConnectionStatusWithContext), varargs...)
}

// GetDefaultPatchBaseline mocks base method
func (m *MockSSMAPI) GetDefaultPatchBaseline(arg0 *ssm.GetDefaultPatchBaselineInput) (*ssm.GetDefaultPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDefaultPatchBaseline", arg0)
	ret0, _ := ret[0].(*ssm.GetDefaultPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDefaultPatchBaseline indicates an expected call of GetDefaultPatchBaseline
func (mr *MockSSMAPIMockRecorder) GetDefaultPatchBaseline(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDefaultPatchBaseline", reflect.TypeOf((*MockSSMAPI)(nil).GetDefaultPatchBaseline), arg0)
}

// GetDefaultPatchBaselineRequest mocks base method
func (m *MockSSMAPI) GetDefaultPatchBaselineRequest(arg0 *ssm.GetDefaultPatchBaselineInput) (*request.Request, *ssm.GetDefaultPatchBaselineOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDefaultPatchBaselineRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetDefaultPatchBaselineOutput)
	return ret0, ret1
}

// GetDefaultPatchBaselineRequest indicates an expected call of GetDefaultPatchBaselineRequest
func (mr *MockSSMAPIMockRecorder) GetDefaultPatchBaselineRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDefaultPatchBaselineRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetDefaultPatchBaselineRequest), arg0)
}

// GetDefaultPatchBaselineWithContext mocks base method
func (m *MockSSMAPI) GetDefaultPatchBaselineWithContext(arg0 context.Context, arg1 *ssm.GetDefaultPatchBaselineInput, arg2 ...request.Option) (*ssm.GetDefaultPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetDefaultPatchBaselineWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetDefaultPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDefaultPatchBaselineWithContext indicates an expected call of GetDefaultPatchBaselineWithContext
func (mr *MockSSMAPIMockRecorder) GetDefaultPatchBaselineWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDefaultPatchBaselineWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetDefaultPatchBaselineWithContext), varargs...)
}

// GetDeployablePatchSnapshotForInstance mocks base method
func (m *MockSSMAPI) GetDeployablePatchSnapshotForInstance(arg0 *ssm.GetDeployablePatchSnapshotForInstanceInput) (*ssm.GetDeployablePatchSnapshotForInstanceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDeployablePatchSnapshotForInstance", arg0)
	ret0, _ := ret[0].(*ssm.GetDeployablePatchSnapshotForInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDeployablePatchSnapshotForInstance indicates an expected call of GetDeployablePatchSnapshotForInstance
func (mr *MockSSMAPIMockRecorder) GetDeployablePatchSnapshotForInstance(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDeployablePatchSnapshotForInstance", reflect.TypeOf((*MockSSMAPI)(nil).GetDeployablePatchSnapshotForInstance), arg0)
}

// GetDeployablePatchSnapshotForInstanceRequest mocks base method
func (m *MockSSMAPI) GetDeployablePatchSnapshotForInstanceRequest(arg0 *ssm.GetDeployablePatchSnapshotForInstanceInput) (*request.Request, *ssm.GetDeployablePatchSnapshotForInstanceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDeployablePatchSnapshotForInstanceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetDeployablePatchSnapshotForInstanceOutput)
	return ret0, ret1
}

// GetDeployablePatchSnapshotForInstanceRequest indicates an expected call of GetDeployablePatchSnapshotForInstanceRequest
func (mr *MockSSMAPIMockRecorder) GetDeployablePatchSnapshotForInstanceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDeployablePatchSnapshotForInstanceRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetDeployablePatchSnapshotForInstanceRequest), arg0)
}

// GetDeployablePatchSnapshotForInstanceWithContext mocks base method
func (m *MockSSMAPI) GetDeployablePatchSnapshotForInstanceWithContext(arg0 context.Context, arg1 *ssm.GetDeployablePatchSnapshotForInstanceInput, arg2 ...request.Option) (*ssm.GetDeployablePatchSnapshotForInstanceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetDeployablePatchSnapshotForInstanceWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetDeployablePatchSnapshotForInstanceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDeployablePatchSnapshotForInstanceWithContext indicates an expected call of GetDeployablePatchSnapshotForInstanceWithContext
func (mr *MockSSMAPIMockRecorder) GetDeployablePatchSnapshotForInstanceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDeployablePatchSnapshotForInstanceWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetDeployablePatchSnapshotForInstanceWithContext), varargs...)
}

// GetDocument mocks base method
func (m *MockSSMAPI) GetDocument(arg0 *ssm.GetDocumentInput) (*ssm.GetDocumentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDocument", arg0)
	ret0, _ := ret[0].(*ssm.GetDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDocument indicates an expected call of GetDocument
func (mr *MockSSMAPIMockRecorder) GetDocument(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDocument", reflect.TypeOf((*MockSSMAPI)(nil).GetDocument), arg0)
}

// GetDocumentRequest mocks base method
func (m *MockSSMAPI) GetDocumentRequest(arg0 *ssm.GetDocumentInput) (*request.Request, *ssm.GetDocumentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDocumentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetDocumentOutput)
	return ret0, ret1
}

// GetDocumentRequest indicates an expected call of GetDocumentRequest
func (mr *MockSSMAPIMockRecorder) GetDocumentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDocumentRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetDocumentRequest), arg0)
}

// GetDocumentWithContext mocks base method
func (m *MockSSMAPI) GetDocumentWithContext(arg0 context.Context, arg1 *ssm.GetDocumentInput, arg2 ...request.Option) (*ssm.GetDocumentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetDocumentWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetDocumentWithContext indicates an expected call of GetDocumentWithContext
func (mr *MockSSMAPIMockRecorder) GetDocumentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDocumentWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetDocumentWithContext), varargs...)
}

// GetInventory mocks base method
func (m *MockSSMAPI) GetInventory(arg0 *ssm.GetInventoryInput) (*ssm.GetInventoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInventory", arg0)
	ret0, _ := ret[0].(*ssm.GetInventoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetInventory indicates an expected call of GetInventory
func (mr *MockSSMAPIMockRecorder) GetInventory(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInventory", reflect.TypeOf((*MockSSMAPI)(nil).GetInventory), arg0)
}

// GetInventoryRequest mocks base method
func (m *MockSSMAPI) GetInventoryRequest(arg0 *ssm.GetInventoryInput) (*request.Request, *ssm.GetInventoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInventoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetInventoryOutput)
	return ret0, ret1
}

// GetInventoryRequest indicates an expected call of GetInventoryRequest
func (mr *MockSSMAPIMockRecorder) GetInventoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInventoryRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetInventoryRequest), arg0)
}

// GetInventorySchema mocks base method
func (m *MockSSMAPI) GetInventorySchema(arg0 *ssm.GetInventorySchemaInput) (*ssm.GetInventorySchemaOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInventorySchema", arg0)
	ret0, _ := ret[0].(*ssm.GetInventorySchemaOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetInventorySchema indicates an expected call of GetInventorySchema
func (mr *MockSSMAPIMockRecorder) GetInventorySchema(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInventorySchema", reflect.TypeOf((*MockSSMAPI)(nil).GetInventorySchema), arg0)
}

// GetInventorySchemaRequest mocks base method
func (m *MockSSMAPI) GetInventorySchemaRequest(arg0 *ssm.GetInventorySchemaInput) (*request.Request, *ssm.GetInventorySchemaOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInventorySchemaRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetInventorySchemaOutput)
	return ret0, ret1
}

// GetInventorySchemaRequest indicates an expected call of GetInventorySchemaRequest
func (mr *MockSSMAPIMockRecorder) GetInventorySchemaRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInventorySchemaRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetInventorySchemaRequest), arg0)
}

// GetInventorySchemaWithContext mocks base method
func (m *MockSSMAPI) GetInventorySchemaWithContext(arg0 context.Context, arg1 *ssm.GetInventorySchemaInput, arg2 ...request.Option) (*ssm.GetInventorySchemaOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetInventorySchemaWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetInventorySchemaOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetInventorySchemaWithContext indicates an expected call of GetInventorySchemaWithContext
func (mr *MockSSMAPIMockRecorder) GetInventorySchemaWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInventorySchemaWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetInventorySchemaWithContext), varargs...)
}

// GetInventoryWithContext mocks base method
func (m *MockSSMAPI) GetInventoryWithContext(arg0 context.Context, arg1 *ssm.GetInventoryInput, arg2 ...request.Option) (*ssm.GetInventoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetInventoryWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetInventoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetInventoryWithContext indicates an expected call of GetInventoryWithContext
func (mr *MockSSMAPIMockRecorder) GetInventoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInventoryWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetInventoryWithContext), varargs...)
}

// GetMaintenanceWindow mocks base method
func (m *MockSSMAPI) GetMaintenanceWindow(arg0 *ssm.GetMaintenanceWindowInput) (*ssm.GetMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindow indicates an expected call of GetMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindow), arg0)
}

// GetMaintenanceWindowExecution mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecution(arg0 *ssm.GetMaintenanceWindowExecutionInput) (*ssm.GetMaintenanceWindowExecutionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecution", arg0)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowExecution indicates an expected call of GetMaintenanceWindowExecution
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecution(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecution", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecution), arg0)
}

// GetMaintenanceWindowExecutionRequest mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionRequest(arg0 *ssm.GetMaintenanceWindowExecutionInput) (*request.Request, *ssm.GetMaintenanceWindowExecutionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetMaintenanceWindowExecutionOutput)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionRequest indicates an expected call of GetMaintenanceWindowExecutionRequest
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionRequest), arg0)
}

// GetMaintenanceWindowExecutionTask mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionTask(arg0 *ssm.GetMaintenanceWindowExecutionTaskInput) (*ssm.GetMaintenanceWindowExecutionTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionTask", arg0)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowExecutionTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionTask indicates an expected call of GetMaintenanceWindowExecutionTask
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionTask", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionTask), arg0)
}

// GetMaintenanceWindowExecutionTaskInvocation mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionTaskInvocation(arg0 *ssm.GetMaintenanceWindowExecutionTaskInvocationInput) (*ssm.GetMaintenanceWindowExecutionTaskInvocationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionTaskInvocation", arg0)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowExecutionTaskInvocationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionTaskInvocation indicates an expected call of GetMaintenanceWindowExecutionTaskInvocation
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionTaskInvocation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionTaskInvocation", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionTaskInvocation), arg0)
}

// GetMaintenanceWindowExecutionTaskInvocationRequest mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionTaskInvocationRequest(arg0 *ssm.GetMaintenanceWindowExecutionTaskInvocationInput) (*request.Request, *ssm.GetMaintenanceWindowExecutionTaskInvocationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionTaskInvocationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetMaintenanceWindowExecutionTaskInvocationOutput)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionTaskInvocationRequest indicates an expected call of GetMaintenanceWindowExecutionTaskInvocationRequest
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionTaskInvocationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionTaskInvocationRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionTaskInvocationRequest), arg0)
}

// GetMaintenanceWindowExecutionTaskInvocationWithContext mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionTaskInvocationWithContext(arg0 context.Context, arg1 *ssm.GetMaintenanceWindowExecutionTaskInvocationInput, arg2 ...request.Option) (*ssm.GetMaintenanceWindowExecutionTaskInvocationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionTaskInvocationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowExecutionTaskInvocationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionTaskInvocationWithContext indicates an expected call of GetMaintenanceWindowExecutionTaskInvocationWithContext
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionTaskInvocationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionTaskInvocationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionTaskInvocationWithContext), varargs...)
}

// GetMaintenanceWindowExecutionTaskRequest mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionTaskRequest(arg0 *ssm.GetMaintenanceWindowExecutionTaskInput) (*request.Request, *ssm.GetMaintenanceWindowExecutionTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetMaintenanceWindowExecutionTaskOutput)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionTaskRequest indicates an expected call of GetMaintenanceWindowExecutionTaskRequest
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionTaskRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionTaskRequest), arg0)
}

// GetMaintenanceWindowExecutionTaskWithContext mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionTaskWithContext(arg0 context.Context, arg1 *ssm.GetMaintenanceWindowExecutionTaskInput, arg2 ...request.Option) (*ssm.GetMaintenanceWindowExecutionTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowExecutionTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionTaskWithContext indicates an expected call of GetMaintenanceWindowExecutionTaskWithContext
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionTaskWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionTaskWithContext), varargs...)
}

// GetMaintenanceWindowExecutionWithContext mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowExecutionWithContext(arg0 context.Context, arg1 *ssm.GetMaintenanceWindowExecutionInput, arg2 ...request.Option) (*ssm.GetMaintenanceWindowExecutionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetMaintenanceWindowExecutionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowExecutionWithContext indicates an expected call of GetMaintenanceWindowExecutionWithContext
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowExecutionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowExecutionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowExecutionWithContext), varargs...)
}

// GetMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowRequest(arg0 *ssm.GetMaintenanceWindowInput) (*request.Request, *ssm.GetMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetMaintenanceWindowOutput)
	return ret0, ret1
}

// GetMaintenanceWindowRequest indicates an expected call of GetMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowRequest), arg0)
}

// GetMaintenanceWindowTask mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowTask(arg0 *ssm.GetMaintenanceWindowTaskInput) (*ssm.GetMaintenanceWindowTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowTask", arg0)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowTask indicates an expected call of GetMaintenanceWindowTask
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowTask", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowTask), arg0)
}

// GetMaintenanceWindowTaskRequest mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowTaskRequest(arg0 *ssm.GetMaintenanceWindowTaskInput) (*request.Request, *ssm.GetMaintenanceWindowTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMaintenanceWindowTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetMaintenanceWindowTaskOutput)
	return ret0, ret1
}

// GetMaintenanceWindowTaskRequest indicates an expected call of GetMaintenanceWindowTaskRequest
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowTaskRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowTaskRequest), arg0)
}

// GetMaintenanceWindowTaskWithContext mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowTaskWithContext(arg0 context.Context, arg1 *ssm.GetMaintenanceWindowTaskInput, arg2 ...request.Option) (*ssm.GetMaintenanceWindowTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetMaintenanceWindowTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowTaskWithContext indicates an expected call of GetMaintenanceWindowTaskWithContext
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowTaskWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowTaskWithContext), varargs...)
}

// GetMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) GetMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.GetMaintenanceWindowInput, arg2 ...request.Option) (*ssm.GetMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetMaintenanceWindowWithContext indicates an expected call of GetMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) GetMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetMaintenanceWindowWithContext), varargs...)
}

// GetOpsItem mocks base method
func (m *MockSSMAPI) GetOpsItem(arg0 *ssm.GetOpsItemInput) (*ssm.GetOpsItemOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOpsItem", arg0)
	ret0, _ := ret[0].(*ssm.GetOpsItemOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOpsItem indicates an expected call of GetOpsItem
func (mr *MockSSMAPIMockRecorder) GetOpsItem(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOpsItem", reflect.TypeOf((*MockSSMAPI)(nil).GetOpsItem), arg0)
}

// GetOpsItemRequest mocks base method
func (m *MockSSMAPI) GetOpsItemRequest(arg0 *ssm.GetOpsItemInput) (*request.Request, *ssm.GetOpsItemOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOpsItemRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetOpsItemOutput)
	return ret0, ret1
}

// GetOpsItemRequest indicates an expected call of GetOpsItemRequest
func (mr *MockSSMAPIMockRecorder) GetOpsItemRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOpsItemRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetOpsItemRequest), arg0)
}

// GetOpsItemWithContext mocks base method
func (m *MockSSMAPI) GetOpsItemWithContext(arg0 context.Context, arg1 *ssm.GetOpsItemInput, arg2 ...request.Option) (*ssm.GetOpsItemOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetOpsItemWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetOpsItemOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOpsItemWithContext indicates an expected call of GetOpsItemWithContext
func (mr *MockSSMAPIMockRecorder) GetOpsItemWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOpsItemWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetOpsItemWithContext), varargs...)
}

// GetOpsSummary mocks base method
func (m *MockSSMAPI) GetOpsSummary(arg0 *ssm.GetOpsSummaryInput) (*ssm.GetOpsSummaryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOpsSummary", arg0)
	ret0, _ := ret[0].(*ssm.GetOpsSummaryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOpsSummary indicates an expected call of GetOpsSummary
func (mr *MockSSMAPIMockRecorder) GetOpsSummary(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOpsSummary", reflect.TypeOf((*MockSSMAPI)(nil).GetOpsSummary), arg0)
}

// GetOpsSummaryRequest mocks base method
func (m *MockSSMAPI) GetOpsSummaryRequest(arg0 *ssm.GetOpsSummaryInput) (*request.Request, *ssm.GetOpsSummaryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOpsSummaryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetOpsSummaryOutput)
	return ret0, ret1
}

// GetOpsSummaryRequest indicates an expected call of GetOpsSummaryRequest
func (mr *MockSSMAPIMockRecorder) GetOpsSummaryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOpsSummaryRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetOpsSummaryRequest), arg0)
}

// GetOpsSummaryWithContext mocks base method
func (m *MockSSMAPI) GetOpsSummaryWithContext(arg0 context.Context, arg1 *ssm.GetOpsSummaryInput, arg2 ...request.Option) (*ssm.GetOpsSummaryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetOpsSummaryWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetOpsSummaryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOpsSummaryWithContext indicates an expected call of GetOpsSummaryWithContext
func (mr *MockSSMAPIMockRecorder) GetOpsSummaryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOpsSummaryWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetOpsSummaryWithContext), varargs...)
}

// GetParameter mocks base method
func (m *MockSSMAPI) GetParameter(arg0 *ssm.GetParameterInput) (*ssm.GetParameterOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParameter", arg0)
	ret0, _ := ret[0].(*ssm.GetParameterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParameter indicates an expected call of GetParameter
func (mr *MockSSMAPIMockRecorder) GetParameter(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameter", reflect.TypeOf((*MockSSMAPI)(nil).GetParameter), arg0)
}

// GetParameterHistory mocks base method
func (m *MockSSMAPI) GetParameterHistory(arg0 *ssm.GetParameterHistoryInput) (*ssm.GetParameterHistoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParameterHistory", arg0)
	ret0, _ := ret[0].(*ssm.GetParameterHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParameterHistory indicates an expected call of GetParameterHistory
func (mr *MockSSMAPIMockRecorder) GetParameterHistory(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameterHistory", reflect.TypeOf((*MockSSMAPI)(nil).GetParameterHistory), arg0)
}

// GetParameterHistoryPages mocks base method
func (m *MockSSMAPI) GetParameterHistoryPages(arg0 *ssm.GetParameterHistoryInput, arg1 func(*ssm.GetParameterHistoryOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParameterHistoryPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetParameterHistoryPages indicates an expected call of GetParameterHistoryPages
func (mr *MockSSMAPIMockRecorder) GetParameterHistoryPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameterHistoryPages", reflect.TypeOf((*MockSSMAPI)(nil).GetParameterHistoryPages), arg0, arg1)
}

// GetParameterHistoryPagesWithContext mocks base method
func (m *MockSSMAPI) GetParameterHistoryPagesWithContext(arg0 context.Context, arg1 *ssm.GetParameterHistoryInput, arg2 func(*ssm.GetParameterHistoryOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetParameterHistoryPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetParameterHistoryPagesWithContext indicates an expected call of GetParameterHistoryPagesWithContext
func (mr *MockSSMAPIMockRecorder) GetParameterHistoryPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameterHistoryPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetParameterHistoryPagesWithContext), varargs...)
}

// GetParameterHistoryRequest mocks base method
func (m *MockSSMAPI) GetParameterHistoryRequest(arg0 *ssm.GetParameterHistoryInput) (*request.Request, *ssm.GetParameterHistoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParameterHistoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetParameterHistoryOutput)
	return ret0, ret1
}

// GetParameterHistoryRequest indicates an expected call of GetParameterHistoryRequest
func (mr *MockSSMAPIMockRecorder) GetParameterHistoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameterHistoryRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetParameterHistoryRequest), arg0)
}

// GetParameterHistoryWithContext mocks base method
func (m *MockSSMAPI) GetParameterHistoryWithContext(arg0 context.Context, arg1 *ssm.GetParameterHistoryInput, arg2 ...request.Option) (*ssm.GetParameterHistoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetParameterHistoryWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetParameterHistoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParameterHistoryWithContext indicates an expected call of GetParameterHistoryWithContext
func (mr *MockSSMAPIMockRecorder) GetParameterHistoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameterHistoryWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetParameterHistoryWithContext), varargs...)
}

// GetParameterRequest mocks base method
func (m *MockSSMAPI) GetParameterRequest(arg0 *ssm.GetParameterInput) (*request.Request, *ssm.GetParameterOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParameterRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetParameterOutput)
	return ret0, ret1
}

// GetParameterRequest indicates an expected call of GetParameterRequest
func (mr *MockSSMAPIMockRecorder) GetParameterRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameterRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetParameterRequest), arg0)
}

// GetParameterWithContext mocks base method
func (m *MockSSMAPI) GetParameterWithContext(arg0 context.Context, arg1 *ssm.GetParameterInput, arg2 ...request.Option) (*ssm.GetParameterOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetParameterWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetParameterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParameterWithContext indicates an expected call of GetParameterWithContext
func (mr *MockSSMAPIMockRecorder) GetParameterWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameterWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetParameterWithContext), varargs...)
}

// GetParameters mocks base method
func (m *MockSSMAPI) GetParameters(arg0 *ssm.GetParametersInput) (*ssm.GetParametersOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParameters", arg0)
	ret0, _ := ret[0].(*ssm.GetParametersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParameters indicates an expected call of GetParameters
func (mr *MockSSMAPIMockRecorder) GetParameters(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParameters", reflect.TypeOf((*MockSSMAPI)(nil).GetParameters), arg0)
}

// GetParametersByPath mocks base method
func (m *MockSSMAPI) GetParametersByPath(arg0 *ssm.GetParametersByPathInput) (*ssm.GetParametersByPathOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParametersByPath", arg0)
	ret0, _ := ret[0].(*ssm.GetParametersByPathOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParametersByPath indicates an expected call of GetParametersByPath
func (mr *MockSSMAPIMockRecorder) GetParametersByPath(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParametersByPath", reflect.TypeOf((*MockSSMAPI)(nil).GetParametersByPath), arg0)
}

// GetParametersByPathPages mocks base method
func (m *MockSSMAPI) GetParametersByPathPages(arg0 *ssm.GetParametersByPathInput, arg1 func(*ssm.GetParametersByPathOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParametersByPathPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetParametersByPathPages indicates an expected call of GetParametersByPathPages
func (mr *MockSSMAPIMockRecorder) GetParametersByPathPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParametersByPathPages", reflect.TypeOf((*MockSSMAPI)(nil).GetParametersByPathPages), arg0, arg1)
}

// GetParametersByPathPagesWithContext mocks base method
func (m *MockSSMAPI) GetParametersByPathPagesWithContext(arg0 context.Context, arg1 *ssm.GetParametersByPathInput, arg2 func(*ssm.GetParametersByPathOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetParametersByPathPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetParametersByPathPagesWithContext indicates an expected call of GetParametersByPathPagesWithContext
func (mr *MockSSMAPIMockRecorder) GetParametersByPathPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParametersByPathPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetParametersByPathPagesWithContext), varargs...)
}

// GetParametersByPathRequest mocks base method
func (m *MockSSMAPI) GetParametersByPathRequest(arg0 *ssm.GetParametersByPathInput) (*request.Request, *ssm.GetParametersByPathOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParametersByPathRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetParametersByPathOutput)
	return ret0, ret1
}

// GetParametersByPathRequest indicates an expected call of GetParametersByPathRequest
func (mr *MockSSMAPIMockRecorder) GetParametersByPathRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParametersByPathRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetParametersByPathRequest), arg0)
}

// GetParametersByPathWithContext mocks base method
func (m *MockSSMAPI) GetParametersByPathWithContext(arg0 context.Context, arg1 *ssm.GetParametersByPathInput, arg2 ...request.Option) (*ssm.GetParametersByPathOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetParametersByPathWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetParametersByPathOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParametersByPathWithContext indicates an expected call of GetParametersByPathWithContext
func (mr *MockSSMAPIMockRecorder) GetParametersByPathWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParametersByPathWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetParametersByPathWithContext), varargs...)
}

// GetParametersRequest mocks base method
func (m *MockSSMAPI) GetParametersRequest(arg0 *ssm.GetParametersInput) (*request.Request, *ssm.GetParametersOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetParametersRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetParametersOutput)
	return ret0, ret1
}

// GetParametersRequest indicates an expected call of GetParametersRequest
func (mr *MockSSMAPIMockRecorder) GetParametersRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParametersRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetParametersRequest), arg0)
}

// GetParametersWithContext mocks base method
func (m *MockSSMAPI) GetParametersWithContext(arg0 context.Context, arg1 *ssm.GetParametersInput, arg2 ...request.Option) (*ssm.GetParametersOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetParametersWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetParametersOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetParametersWithContext indicates an expected call of GetParametersWithContext
func (mr *MockSSMAPIMockRecorder) GetParametersWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetParametersWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetParametersWithContext), varargs...)
}

// GetPatchBaseline mocks base method
func (m *MockSSMAPI) GetPatchBaseline(arg0 *ssm.GetPatchBaselineInput) (*ssm.GetPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPatchBaseline", arg0)
	ret0, _ := ret[0].(*ssm.GetPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPatchBaseline indicates an expected call of GetPatchBaseline
func (mr *MockSSMAPIMockRecorder) GetPatchBaseline(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPatchBaseline", reflect.TypeOf((*MockSSMAPI)(nil).GetPatchBaseline), arg0)
}

// GetPatchBaselineForPatchGroup mocks base method
func (m *MockSSMAPI) GetPatchBaselineForPatchGroup(arg0 *ssm.GetPatchBaselineForPatchGroupInput) (*ssm.GetPatchBaselineForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPatchBaselineForPatchGroup", arg0)
	ret0, _ := ret[0].(*ssm.GetPatchBaselineForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPatchBaselineForPatchGroup indicates an expected call of GetPatchBaselineForPatchGroup
func (mr *MockSSMAPIMockRecorder) GetPatchBaselineForPatchGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPatchBaselineForPatchGroup", reflect.TypeOf((*MockSSMAPI)(nil).GetPatchBaselineForPatchGroup), arg0)
}

// GetPatchBaselineForPatchGroupRequest mocks base method
func (m *MockSSMAPI) GetPatchBaselineForPatchGroupRequest(arg0 *ssm.GetPatchBaselineForPatchGroupInput) (*request.Request, *ssm.GetPatchBaselineForPatchGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPatchBaselineForPatchGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetPatchBaselineForPatchGroupOutput)
	return ret0, ret1
}

// GetPatchBaselineForPatchGroupRequest indicates an expected call of GetPatchBaselineForPatchGroupRequest
func (mr *MockSSMAPIMockRecorder) GetPatchBaselineForPatchGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPatchBaselineForPatchGroupRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetPatchBaselineForPatchGroupRequest), arg0)
}

// GetPatchBaselineForPatchGroupWithContext mocks base method
func (m *MockSSMAPI) GetPatchBaselineForPatchGroupWithContext(arg0 context.Context, arg1 *ssm.GetPatchBaselineForPatchGroupInput, arg2 ...request.Option) (*ssm.GetPatchBaselineForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetPatchBaselineForPatchGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetPatchBaselineForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPatchBaselineForPatchGroupWithContext indicates an expected call of GetPatchBaselineForPatchGroupWithContext
func (mr *MockSSMAPIMockRecorder) GetPatchBaselineForPatchGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPatchBaselineForPatchGroupWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetPatchBaselineForPatchGroupWithContext), varargs...)
}

// GetPatchBaselineRequest mocks base method
func (m *MockSSMAPI) GetPatchBaselineRequest(arg0 *ssm.GetPatchBaselineInput) (*request.Request, *ssm.GetPatchBaselineOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPatchBaselineRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetPatchBaselineOutput)
	return ret0, ret1
}

// GetPatchBaselineRequest indicates an expected call of GetPatchBaselineRequest
func (mr *MockSSMAPIMockRecorder) GetPatchBaselineRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPatchBaselineRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetPatchBaselineRequest), arg0)
}

// GetPatchBaselineWithContext mocks base method
func (m *MockSSMAPI) GetPatchBaselineWithContext(arg0 context.Context, arg1 *ssm.GetPatchBaselineInput, arg2 ...request.Option) (*ssm.GetPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetPatchBaselineWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetPatchBaselineWithContext indicates an expected call of GetPatchBaselineWithContext
func (mr *MockSSMAPIMockRecorder) GetPatchBaselineWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPatchBaselineWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetPatchBaselineWithContext), varargs...)
}

// GetServiceSetting mocks base method
func (m *MockSSMAPI) GetServiceSetting(arg0 *ssm.GetServiceSettingInput) (*ssm.GetServiceSettingOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetServiceSetting", arg0)
	ret0, _ := ret[0].(*ssm.GetServiceSettingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetServiceSetting indicates an expected call of GetServiceSetting
func (mr *MockSSMAPIMockRecorder) GetServiceSetting(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetServiceSetting", reflect.TypeOf((*MockSSMAPI)(nil).GetServiceSetting), arg0)
}

// GetServiceSettingRequest mocks base method
func (m *MockSSMAPI) GetServiceSettingRequest(arg0 *ssm.GetServiceSettingInput) (*request.Request, *ssm.GetServiceSettingOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetServiceSettingRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.GetServiceSettingOutput)
	return ret0, ret1
}

// GetServiceSettingRequest indicates an expected call of GetServiceSettingRequest
func (mr *MockSSMAPIMockRecorder) GetServiceSettingRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetServiceSettingRequest", reflect.TypeOf((*MockSSMAPI)(nil).GetServiceSettingRequest), arg0)
}

// GetServiceSettingWithContext mocks base method
func (m *MockSSMAPI) GetServiceSettingWithContext(arg0 context.Context, arg1 *ssm.GetServiceSettingInput, arg2 ...request.Option) (*ssm.GetServiceSettingOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "GetServiceSettingWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.GetServiceSettingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetServiceSettingWithContext indicates an expected call of GetServiceSettingWithContext
func (mr *MockSSMAPIMockRecorder) GetServiceSettingWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetServiceSettingWithContext", reflect.TypeOf((*MockSSMAPI)(nil).GetServiceSettingWithContext), varargs...)
}

// LabelParameterVersion mocks base method
func (m *MockSSMAPI) LabelParameterVersion(arg0 *ssm.LabelParameterVersionInput) (*ssm.LabelParameterVersionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LabelParameterVersion", arg0)
	ret0, _ := ret[0].(*ssm.LabelParameterVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LabelParameterVersion indicates an expected call of LabelParameterVersion
func (mr *MockSSMAPIMockRecorder) LabelParameterVersion(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LabelParameterVersion", reflect.TypeOf((*MockSSMAPI)(nil).LabelParameterVersion), arg0)
}

// LabelParameterVersionRequest mocks base method
func (m *MockSSMAPI) LabelParameterVersionRequest(arg0 *ssm.LabelParameterVersionInput) (*request.Request, *ssm.LabelParameterVersionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LabelParameterVersionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.LabelParameterVersionOutput)
	return ret0, ret1
}

// LabelParameterVersionRequest indicates an expected call of LabelParameterVersionRequest
func (mr *MockSSMAPIMockRecorder) LabelParameterVersionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LabelParameterVersionRequest", reflect.TypeOf((*MockSSMAPI)(nil).LabelParameterVersionRequest), arg0)
}

// LabelParameterVersionWithContext mocks base method
func (m *MockSSMAPI) LabelParameterVersionWithContext(arg0 context.Context, arg1 *ssm.LabelParameterVersionInput, arg2 ...request.Option) (*ssm.LabelParameterVersionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "LabelParameterVersionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.LabelParameterVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LabelParameterVersionWithContext indicates an expected call of LabelParameterVersionWithContext
func (mr *MockSSMAPIMockRecorder) LabelParameterVersionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LabelParameterVersionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).LabelParameterVersionWithContext), varargs...)
}

// ListAssociationVersions mocks base method
func (m *MockSSMAPI) ListAssociationVersions(arg0 *ssm.ListAssociationVersionsInput) (*ssm.ListAssociationVersionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAssociationVersions", arg0)
	ret0, _ := ret[0].(*ssm.ListAssociationVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListAssociationVersions indicates an expected call of ListAssociationVersions
func (mr *MockSSMAPIMockRecorder) ListAssociationVersions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociationVersions", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociationVersions), arg0)
}

// ListAssociationVersionsRequest mocks base method
func (m *MockSSMAPI) ListAssociationVersionsRequest(arg0 *ssm.ListAssociationVersionsInput) (*request.Request, *ssm.ListAssociationVersionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAssociationVersionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListAssociationVersionsOutput)
	return ret0, ret1
}

// ListAssociationVersionsRequest indicates an expected call of ListAssociationVersionsRequest
func (mr *MockSSMAPIMockRecorder) ListAssociationVersionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociationVersionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociationVersionsRequest), arg0)
}

// ListAssociationVersionsWithContext mocks base method
func (m *MockSSMAPI) ListAssociationVersionsWithContext(arg0 context.Context, arg1 *ssm.ListAssociationVersionsInput, arg2 ...request.Option) (*ssm.ListAssociationVersionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListAssociationVersionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListAssociationVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListAssociationVersionsWithContext indicates an expected call of ListAssociationVersionsWithContext
func (mr *MockSSMAPIMockRecorder) ListAssociationVersionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociationVersionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociationVersionsWithContext), varargs...)
}

// ListAssociations mocks base method
func (m *MockSSMAPI) ListAssociations(arg0 *ssm.ListAssociationsInput) (*ssm.ListAssociationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAssociations", arg0)
	ret0, _ := ret[0].(*ssm.ListAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListAssociations indicates an expected call of ListAssociations
func (mr *MockSSMAPIMockRecorder) ListAssociations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociations", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociations), arg0)
}

// ListAssociationsPages mocks base method
func (m *MockSSMAPI) ListAssociationsPages(arg0 *ssm.ListAssociationsInput, arg1 func(*ssm.ListAssociationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAssociationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListAssociationsPages indicates an expected call of ListAssociationsPages
func (mr *MockSSMAPIMockRecorder) ListAssociationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociationsPages", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociationsPages), arg0, arg1)
}

// ListAssociationsPagesWithContext mocks base method
func (m *MockSSMAPI) ListAssociationsPagesWithContext(arg0 context.Context, arg1 *ssm.ListAssociationsInput, arg2 func(*ssm.ListAssociationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListAssociationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListAssociationsPagesWithContext indicates an expected call of ListAssociationsPagesWithContext
func (mr *MockSSMAPIMockRecorder) ListAssociationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociationsPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociationsPagesWithContext), varargs...)
}

// ListAssociationsRequest mocks base method
func (m *MockSSMAPI) ListAssociationsRequest(arg0 *ssm.ListAssociationsInput) (*request.Request, *ssm.ListAssociationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAssociationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListAssociationsOutput)
	return ret0, ret1
}

// ListAssociationsRequest indicates an expected call of ListAssociationsRequest
func (mr *MockSSMAPIMockRecorder) ListAssociationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociationsRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociationsRequest), arg0)
}

// ListAssociationsWithContext mocks base method
func (m *MockSSMAPI) ListAssociationsWithContext(arg0 context.Context, arg1 *ssm.ListAssociationsInput, arg2 ...request.Option) (*ssm.ListAssociationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListAssociationsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListAssociationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListAssociationsWithContext indicates an expected call of ListAssociationsWithContext
func (mr *MockSSMAPIMockRecorder) ListAssociationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAssociationsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListAssociationsWithContext), varargs...)
}

// ListCommandInvocations mocks base method
func (m *MockSSMAPI) ListCommandInvocations(arg0 *ssm.ListCommandInvocationsInput) (*ssm.ListCommandInvocationsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCommandInvocations", arg0)
	ret0, _ := ret[0].(*ssm.ListCommandInvocationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListCommandInvocations indicates an expected call of ListCommandInvocations
func (mr *MockSSMAPIMockRecorder) ListCommandInvocations(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandInvocations", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandInvocations), arg0)
}

// ListCommandInvocationsPages mocks base method
func (m *MockSSMAPI) ListCommandInvocationsPages(arg0 *ssm.ListCommandInvocationsInput, arg1 func(*ssm.ListCommandInvocationsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCommandInvocationsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListCommandInvocationsPages indicates an expected call of ListCommandInvocationsPages
func (mr *MockSSMAPIMockRecorder) ListCommandInvocationsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandInvocationsPages", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandInvocationsPages), arg0, arg1)
}

// ListCommandInvocationsPagesWithContext mocks base method
func (m *MockSSMAPI) ListCommandInvocationsPagesWithContext(arg0 context.Context, arg1 *ssm.ListCommandInvocationsInput, arg2 func(*ssm.ListCommandInvocationsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListCommandInvocationsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListCommandInvocationsPagesWithContext indicates an expected call of ListCommandInvocationsPagesWithContext
func (mr *MockSSMAPIMockRecorder) ListCommandInvocationsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandInvocationsPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandInvocationsPagesWithContext), varargs...)
}

// ListCommandInvocationsRequest mocks base method
func (m *MockSSMAPI) ListCommandInvocationsRequest(arg0 *ssm.ListCommandInvocationsInput) (*request.Request, *ssm.ListCommandInvocationsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCommandInvocationsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListCommandInvocationsOutput)
	return ret0, ret1
}

// ListCommandInvocationsRequest indicates an expected call of ListCommandInvocationsRequest
func (mr *MockSSMAPIMockRecorder) ListCommandInvocationsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandInvocationsRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandInvocationsRequest), arg0)
}

// ListCommandInvocationsWithContext mocks base method
func (m *MockSSMAPI) ListCommandInvocationsWithContext(arg0 context.Context, arg1 *ssm.ListCommandInvocationsInput, arg2 ...request.Option) (*ssm.ListCommandInvocationsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListCommandInvocationsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListCommandInvocationsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListCommandInvocationsWithContext indicates an expected call of ListCommandInvocationsWithContext
func (mr *MockSSMAPIMockRecorder) ListCommandInvocationsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandInvocationsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandInvocationsWithContext), varargs...)
}

// ListCommands mocks base method
func (m *MockSSMAPI) ListCommands(arg0 *ssm.ListCommandsInput) (*ssm.ListCommandsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCommands", arg0)
	ret0, _ := ret[0].(*ssm.ListCommandsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListCommands indicates an expected call of ListCommands
func (mr *MockSSMAPIMockRecorder) ListCommands(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommands", reflect.TypeOf((*MockSSMAPI)(nil).ListCommands), arg0)
}

// ListCommandsPages mocks base method
func (m *MockSSMAPI) ListCommandsPages(arg0 *ssm.ListCommandsInput, arg1 func(*ssm.ListCommandsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCommandsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListCommandsPages indicates an expected call of ListCommandsPages
func (mr *MockSSMAPIMockRecorder) ListCommandsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandsPages", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandsPages), arg0, arg1)
}

// ListCommandsPagesWithContext mocks base method
func (m *MockSSMAPI) ListCommandsPagesWithContext(arg0 context.Context, arg1 *ssm.ListCommandsInput, arg2 func(*ssm.ListCommandsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListCommandsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListCommandsPagesWithContext indicates an expected call of ListCommandsPagesWithContext
func (mr *MockSSMAPIMockRecorder) ListCommandsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandsPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandsPagesWithContext), varargs...)
}

// ListCommandsRequest mocks base method
func (m *MockSSMAPI) ListCommandsRequest(arg0 *ssm.ListCommandsInput) (*request.Request, *ssm.ListCommandsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCommandsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListCommandsOutput)
	return ret0, ret1
}

// ListCommandsRequest indicates an expected call of ListCommandsRequest
func (mr *MockSSMAPIMockRecorder) ListCommandsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandsRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandsRequest), arg0)
}

// ListCommandsWithContext mocks base method
func (m *MockSSMAPI) ListCommandsWithContext(arg0 context.Context, arg1 *ssm.ListCommandsInput, arg2 ...request.Option) (*ssm.ListCommandsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListCommandsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListCommandsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListCommandsWithContext indicates an expected call of ListCommandsWithContext
func (mr *MockSSMAPIMockRecorder) ListCommandsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommandsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListCommandsWithContext), varargs...)
}

// ListComplianceItems mocks base method
func (m *MockSSMAPI) ListComplianceItems(arg0 *ssm.ListComplianceItemsInput) (*ssm.ListComplianceItemsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListComplianceItems", arg0)
	ret0, _ := ret[0].(*ssm.ListComplianceItemsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListComplianceItems indicates an expected call of ListComplianceItems
func (mr *MockSSMAPIMockRecorder) ListComplianceItems(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListComplianceItems", reflect.TypeOf((*MockSSMAPI)(nil).ListComplianceItems), arg0)
}

// ListComplianceItemsRequest mocks base method
func (m *MockSSMAPI) ListComplianceItemsRequest(arg0 *ssm.ListComplianceItemsInput) (*request.Request, *ssm.ListComplianceItemsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListComplianceItemsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListComplianceItemsOutput)
	return ret0, ret1
}

// ListComplianceItemsRequest indicates an expected call of ListComplianceItemsRequest
func (mr *MockSSMAPIMockRecorder) ListComplianceItemsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListComplianceItemsRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListComplianceItemsRequest), arg0)
}

// ListComplianceItemsWithContext mocks base method
func (m *MockSSMAPI) ListComplianceItemsWithContext(arg0 context.Context, arg1 *ssm.ListComplianceItemsInput, arg2 ...request.Option) (*ssm.ListComplianceItemsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListComplianceItemsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListComplianceItemsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListComplianceItemsWithContext indicates an expected call of ListComplianceItemsWithContext
func (mr *MockSSMAPIMockRecorder) ListComplianceItemsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListComplianceItemsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListComplianceItemsWithContext), varargs...)
}

// ListComplianceSummaries mocks base method
func (m *MockSSMAPI) ListComplianceSummaries(arg0 *ssm.ListComplianceSummariesInput) (*ssm.ListComplianceSummariesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListComplianceSummaries", arg0)
	ret0, _ := ret[0].(*ssm.ListComplianceSummariesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListComplianceSummaries indicates an expected call of ListComplianceSummaries
func (mr *MockSSMAPIMockRecorder) ListComplianceSummaries(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListComplianceSummaries", reflect.TypeOf((*MockSSMAPI)(nil).ListComplianceSummaries), arg0)
}

// ListComplianceSummariesRequest mocks base method
func (m *MockSSMAPI) ListComplianceSummariesRequest(arg0 *ssm.ListComplianceSummariesInput) (*request.Request, *ssm.ListComplianceSummariesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListComplianceSummariesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListComplianceSummariesOutput)
	return ret0, ret1
}

// ListComplianceSummariesRequest indicates an expected call of ListComplianceSummariesRequest
func (mr *MockSSMAPIMockRecorder) ListComplianceSummariesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListComplianceSummariesRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListComplianceSummariesRequest), arg0)
}

// ListComplianceSummariesWithContext mocks base method
func (m *MockSSMAPI) ListComplianceSummariesWithContext(arg0 context.Context, arg1 *ssm.ListComplianceSummariesInput, arg2 ...request.Option) (*ssm.ListComplianceSummariesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListComplianceSummariesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListComplianceSummariesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListComplianceSummariesWithContext indicates an expected call of ListComplianceSummariesWithContext
func (mr *MockSSMAPIMockRecorder) ListComplianceSummariesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListComplianceSummariesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListComplianceSummariesWithContext), varargs...)
}

// ListDocumentVersions mocks base method
func (m *MockSSMAPI) ListDocumentVersions(arg0 *ssm.ListDocumentVersionsInput) (*ssm.ListDocumentVersionsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListDocumentVersions", arg0)
	ret0, _ := ret[0].(*ssm.ListDocumentVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListDocumentVersions indicates an expected call of ListDocumentVersions
func (mr *MockSSMAPIMockRecorder) ListDocumentVersions(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocumentVersions", reflect.TypeOf((*MockSSMAPI)(nil).ListDocumentVersions), arg0)
}

// ListDocumentVersionsRequest mocks base method
func (m *MockSSMAPI) ListDocumentVersionsRequest(arg0 *ssm.ListDocumentVersionsInput) (*request.Request, *ssm.ListDocumentVersionsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListDocumentVersionsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListDocumentVersionsOutput)
	return ret0, ret1
}

// ListDocumentVersionsRequest indicates an expected call of ListDocumentVersionsRequest
func (mr *MockSSMAPIMockRecorder) ListDocumentVersionsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocumentVersionsRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListDocumentVersionsRequest), arg0)
}

// ListDocumentVersionsWithContext mocks base method
func (m *MockSSMAPI) ListDocumentVersionsWithContext(arg0 context.Context, arg1 *ssm.ListDocumentVersionsInput, arg2 ...request.Option) (*ssm.ListDocumentVersionsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListDocumentVersionsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListDocumentVersionsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListDocumentVersionsWithContext indicates an expected call of ListDocumentVersionsWithContext
func (mr *MockSSMAPIMockRecorder) ListDocumentVersionsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocumentVersionsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListDocumentVersionsWithContext), varargs...)
}

// ListDocuments mocks base method
func (m *MockSSMAPI) ListDocuments(arg0 *ssm.ListDocumentsInput) (*ssm.ListDocumentsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListDocuments", arg0)
	ret0, _ := ret[0].(*ssm.ListDocumentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListDocuments indicates an expected call of ListDocuments
func (mr *MockSSMAPIMockRecorder) ListDocuments(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocuments", reflect.TypeOf((*MockSSMAPI)(nil).ListDocuments), arg0)
}

// ListDocumentsPages mocks base method
func (m *MockSSMAPI) ListDocumentsPages(arg0 *ssm.ListDocumentsInput, arg1 func(*ssm.ListDocumentsOutput, bool) bool) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListDocumentsPages", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListDocumentsPages indicates an expected call of ListDocumentsPages
func (mr *MockSSMAPIMockRecorder) ListDocumentsPages(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocumentsPages", reflect.TypeOf((*MockSSMAPI)(nil).ListDocumentsPages), arg0, arg1)
}

// ListDocumentsPagesWithContext mocks base method
func (m *MockSSMAPI) ListDocumentsPagesWithContext(arg0 context.Context, arg1 *ssm.ListDocumentsInput, arg2 func(*ssm.ListDocumentsOutput, bool) bool, arg3 ...request.Option) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1, arg2}
	for _, a := range arg3 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListDocumentsPagesWithContext", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ListDocumentsPagesWithContext indicates an expected call of ListDocumentsPagesWithContext
func (mr *MockSSMAPIMockRecorder) ListDocumentsPagesWithContext(arg0, arg1, arg2 interface{}, arg3 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1, arg2}, arg3...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocumentsPagesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListDocumentsPagesWithContext), varargs...)
}

// ListDocumentsRequest mocks base method
func (m *MockSSMAPI) ListDocumentsRequest(arg0 *ssm.ListDocumentsInput) (*request.Request, *ssm.ListDocumentsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListDocumentsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListDocumentsOutput)
	return ret0, ret1
}

// ListDocumentsRequest indicates an expected call of ListDocumentsRequest
func (mr *MockSSMAPIMockRecorder) ListDocumentsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocumentsRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListDocumentsRequest), arg0)
}

// ListDocumentsWithContext mocks base method
func (m *MockSSMAPI) ListDocumentsWithContext(arg0 context.Context, arg1 *ssm.ListDocumentsInput, arg2 ...request.Option) (*ssm.ListDocumentsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListDocumentsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListDocumentsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListDocumentsWithContext indicates an expected call of ListDocumentsWithContext
func (mr *MockSSMAPIMockRecorder) ListDocumentsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListDocumentsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListDocumentsWithContext), varargs...)
}

// ListInventoryEntries mocks base method
func (m *MockSSMAPI) ListInventoryEntries(arg0 *ssm.ListInventoryEntriesInput) (*ssm.ListInventoryEntriesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListInventoryEntries", arg0)
	ret0, _ := ret[0].(*ssm.ListInventoryEntriesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListInventoryEntries indicates an expected call of ListInventoryEntries
func (mr *MockSSMAPIMockRecorder) ListInventoryEntries(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListInventoryEntries", reflect.TypeOf((*MockSSMAPI)(nil).ListInventoryEntries), arg0)
}

// ListInventoryEntriesRequest mocks base method
func (m *MockSSMAPI) ListInventoryEntriesRequest(arg0 *ssm.ListInventoryEntriesInput) (*request.Request, *ssm.ListInventoryEntriesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListInventoryEntriesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListInventoryEntriesOutput)
	return ret0, ret1
}

// ListInventoryEntriesRequest indicates an expected call of ListInventoryEntriesRequest
func (mr *MockSSMAPIMockRecorder) ListInventoryEntriesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListInventoryEntriesRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListInventoryEntriesRequest), arg0)
}

// ListInventoryEntriesWithContext mocks base method
func (m *MockSSMAPI) ListInventoryEntriesWithContext(arg0 context.Context, arg1 *ssm.ListInventoryEntriesInput, arg2 ...request.Option) (*ssm.ListInventoryEntriesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListInventoryEntriesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListInventoryEntriesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListInventoryEntriesWithContext indicates an expected call of ListInventoryEntriesWithContext
func (mr *MockSSMAPIMockRecorder) ListInventoryEntriesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListInventoryEntriesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListInventoryEntriesWithContext), varargs...)
}

// ListResourceComplianceSummaries mocks base method
func (m *MockSSMAPI) ListResourceComplianceSummaries(arg0 *ssm.ListResourceComplianceSummariesInput) (*ssm.ListResourceComplianceSummariesOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListResourceComplianceSummaries", arg0)
	ret0, _ := ret[0].(*ssm.ListResourceComplianceSummariesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListResourceComplianceSummaries indicates an expected call of ListResourceComplianceSummaries
func (mr *MockSSMAPIMockRecorder) ListResourceComplianceSummaries(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListResourceComplianceSummaries", reflect.TypeOf((*MockSSMAPI)(nil).ListResourceComplianceSummaries), arg0)
}

// ListResourceComplianceSummariesRequest mocks base method
func (m *MockSSMAPI) ListResourceComplianceSummariesRequest(arg0 *ssm.ListResourceComplianceSummariesInput) (*request.Request, *ssm.ListResourceComplianceSummariesOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListResourceComplianceSummariesRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListResourceComplianceSummariesOutput)
	return ret0, ret1
}

// ListResourceComplianceSummariesRequest indicates an expected call of ListResourceComplianceSummariesRequest
func (mr *MockSSMAPIMockRecorder) ListResourceComplianceSummariesRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListResourceComplianceSummariesRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListResourceComplianceSummariesRequest), arg0)
}

// ListResourceComplianceSummariesWithContext mocks base method
func (m *MockSSMAPI) ListResourceComplianceSummariesWithContext(arg0 context.Context, arg1 *ssm.ListResourceComplianceSummariesInput, arg2 ...request.Option) (*ssm.ListResourceComplianceSummariesOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListResourceComplianceSummariesWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListResourceComplianceSummariesOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListResourceComplianceSummariesWithContext indicates an expected call of ListResourceComplianceSummariesWithContext
func (mr *MockSSMAPIMockRecorder) ListResourceComplianceSummariesWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListResourceComplianceSummariesWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListResourceComplianceSummariesWithContext), varargs...)
}

// ListResourceDataSync mocks base method
func (m *MockSSMAPI) ListResourceDataSync(arg0 *ssm.ListResourceDataSyncInput) (*ssm.ListResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListResourceDataSync", arg0)
	ret0, _ := ret[0].(*ssm.ListResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListResourceDataSync indicates an expected call of ListResourceDataSync
func (mr *MockSSMAPIMockRecorder) ListResourceDataSync(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListResourceDataSync", reflect.TypeOf((*MockSSMAPI)(nil).ListResourceDataSync), arg0)
}

// ListResourceDataSyncRequest mocks base method
func (m *MockSSMAPI) ListResourceDataSyncRequest(arg0 *ssm.ListResourceDataSyncInput) (*request.Request, *ssm.ListResourceDataSyncOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListResourceDataSyncRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListResourceDataSyncOutput)
	return ret0, ret1
}

// ListResourceDataSyncRequest indicates an expected call of ListResourceDataSyncRequest
func (mr *MockSSMAPIMockRecorder) ListResourceDataSyncRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListResourceDataSyncRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListResourceDataSyncRequest), arg0)
}

// ListResourceDataSyncWithContext mocks base method
func (m *MockSSMAPI) ListResourceDataSyncWithContext(arg0 context.Context, arg1 *ssm.ListResourceDataSyncInput, arg2 ...request.Option) (*ssm.ListResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListResourceDataSyncWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListResourceDataSyncWithContext indicates an expected call of ListResourceDataSyncWithContext
func (mr *MockSSMAPIMockRecorder) ListResourceDataSyncWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListResourceDataSyncWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListResourceDataSyncWithContext), varargs...)
}

// ListTagsForResource mocks base method
func (m *MockSSMAPI) ListTagsForResource(arg0 *ssm.ListTagsForResourceInput) (*ssm.ListTagsForResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTagsForResource", arg0)
	ret0, _ := ret[0].(*ssm.ListTagsForResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTagsForResource indicates an expected call of ListTagsForResource
func (mr *MockSSMAPIMockRecorder) ListTagsForResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTagsForResource", reflect.TypeOf((*MockSSMAPI)(nil).ListTagsForResource), arg0)
}

// ListTagsForResourceRequest mocks base method
func (m *MockSSMAPI) ListTagsForResourceRequest(arg0 *ssm.ListTagsForResourceInput) (*request.Request, *ssm.ListTagsForResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListTagsForResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ListTagsForResourceOutput)
	return ret0, ret1
}

// ListTagsForResourceRequest indicates an expected call of ListTagsForResourceRequest
func (mr *MockSSMAPIMockRecorder) ListTagsForResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTagsForResourceRequest", reflect.TypeOf((*MockSSMAPI)(nil).ListTagsForResourceRequest), arg0)
}

// ListTagsForResourceWithContext mocks base method
func (m *MockSSMAPI) ListTagsForResourceWithContext(arg0 context.Context, arg1 *ssm.ListTagsForResourceInput, arg2 ...request.Option) (*ssm.ListTagsForResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ListTagsForResourceWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ListTagsForResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListTagsForResourceWithContext indicates an expected call of ListTagsForResourceWithContext
func (mr *MockSSMAPIMockRecorder) ListTagsForResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListTagsForResourceWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ListTagsForResourceWithContext), varargs...)
}

// ModifyDocumentPermission mocks base method
func (m *MockSSMAPI) ModifyDocumentPermission(arg0 *ssm.ModifyDocumentPermissionInput) (*ssm.ModifyDocumentPermissionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyDocumentPermission", arg0)
	ret0, _ := ret[0].(*ssm.ModifyDocumentPermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyDocumentPermission indicates an expected call of ModifyDocumentPermission
func (mr *MockSSMAPIMockRecorder) ModifyDocumentPermission(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyDocumentPermission", reflect.TypeOf((*MockSSMAPI)(nil).ModifyDocumentPermission), arg0)
}

// ModifyDocumentPermissionRequest mocks base method
func (m *MockSSMAPI) ModifyDocumentPermissionRequest(arg0 *ssm.ModifyDocumentPermissionInput) (*request.Request, *ssm.ModifyDocumentPermissionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ModifyDocumentPermissionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ModifyDocumentPermissionOutput)
	return ret0, ret1
}

// ModifyDocumentPermissionRequest indicates an expected call of ModifyDocumentPermissionRequest
func (mr *MockSSMAPIMockRecorder) ModifyDocumentPermissionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyDocumentPermissionRequest", reflect.TypeOf((*MockSSMAPI)(nil).ModifyDocumentPermissionRequest), arg0)
}

// ModifyDocumentPermissionWithContext mocks base method
func (m *MockSSMAPI) ModifyDocumentPermissionWithContext(arg0 context.Context, arg1 *ssm.ModifyDocumentPermissionInput, arg2 ...request.Option) (*ssm.ModifyDocumentPermissionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ModifyDocumentPermissionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ModifyDocumentPermissionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ModifyDocumentPermissionWithContext indicates an expected call of ModifyDocumentPermissionWithContext
func (mr *MockSSMAPIMockRecorder) ModifyDocumentPermissionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ModifyDocumentPermissionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ModifyDocumentPermissionWithContext), varargs...)
}

// PutComplianceItems mocks base method
func (m *MockSSMAPI) PutComplianceItems(arg0 *ssm.PutComplianceItemsInput) (*ssm.PutComplianceItemsOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutComplianceItems", arg0)
	ret0, _ := ret[0].(*ssm.PutComplianceItemsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutComplianceItems indicates an expected call of PutComplianceItems
func (mr *MockSSMAPIMockRecorder) PutComplianceItems(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutComplianceItems", reflect.TypeOf((*MockSSMAPI)(nil).PutComplianceItems), arg0)
}

// PutComplianceItemsRequest mocks base method
func (m *MockSSMAPI) PutComplianceItemsRequest(arg0 *ssm.PutComplianceItemsInput) (*request.Request, *ssm.PutComplianceItemsOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutComplianceItemsRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.PutComplianceItemsOutput)
	return ret0, ret1
}

// PutComplianceItemsRequest indicates an expected call of PutComplianceItemsRequest
func (mr *MockSSMAPIMockRecorder) PutComplianceItemsRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutComplianceItemsRequest", reflect.TypeOf((*MockSSMAPI)(nil).PutComplianceItemsRequest), arg0)
}

// PutComplianceItemsWithContext mocks base method
func (m *MockSSMAPI) PutComplianceItemsWithContext(arg0 context.Context, arg1 *ssm.PutComplianceItemsInput, arg2 ...request.Option) (*ssm.PutComplianceItemsOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PutComplianceItemsWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.PutComplianceItemsOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutComplianceItemsWithContext indicates an expected call of PutComplianceItemsWithContext
func (mr *MockSSMAPIMockRecorder) PutComplianceItemsWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutComplianceItemsWithContext", reflect.TypeOf((*MockSSMAPI)(nil).PutComplianceItemsWithContext), varargs...)
}

// PutInventory mocks base method
func (m *MockSSMAPI) PutInventory(arg0 *ssm.PutInventoryInput) (*ssm.PutInventoryOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutInventory", arg0)
	ret0, _ := ret[0].(*ssm.PutInventoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutInventory indicates an expected call of PutInventory
func (mr *MockSSMAPIMockRecorder) PutInventory(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutInventory", reflect.TypeOf((*MockSSMAPI)(nil).PutInventory), arg0)
}

// PutInventoryRequest mocks base method
func (m *MockSSMAPI) PutInventoryRequest(arg0 *ssm.PutInventoryInput) (*request.Request, *ssm.PutInventoryOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutInventoryRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.PutInventoryOutput)
	return ret0, ret1
}

// PutInventoryRequest indicates an expected call of PutInventoryRequest
func (mr *MockSSMAPIMockRecorder) PutInventoryRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutInventoryRequest", reflect.TypeOf((*MockSSMAPI)(nil).PutInventoryRequest), arg0)
}

// PutInventoryWithContext mocks base method
func (m *MockSSMAPI) PutInventoryWithContext(arg0 context.Context, arg1 *ssm.PutInventoryInput, arg2 ...request.Option) (*ssm.PutInventoryOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PutInventoryWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.PutInventoryOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutInventoryWithContext indicates an expected call of PutInventoryWithContext
func (mr *MockSSMAPIMockRecorder) PutInventoryWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutInventoryWithContext", reflect.TypeOf((*MockSSMAPI)(nil).PutInventoryWithContext), varargs...)
}

// PutParameter mocks base method
func (m *MockSSMAPI) PutParameter(arg0 *ssm.PutParameterInput) (*ssm.PutParameterOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutParameter", arg0)
	ret0, _ := ret[0].(*ssm.PutParameterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutParameter indicates an expected call of PutParameter
func (mr *MockSSMAPIMockRecorder) PutParameter(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutParameter", reflect.TypeOf((*MockSSMAPI)(nil).PutParameter), arg0)
}

// PutParameterRequest mocks base method
func (m *MockSSMAPI) PutParameterRequest(arg0 *ssm.PutParameterInput) (*request.Request, *ssm.PutParameterOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PutParameterRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.PutParameterOutput)
	return ret0, ret1
}

// PutParameterRequest indicates an expected call of PutParameterRequest
func (mr *MockSSMAPIMockRecorder) PutParameterRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutParameterRequest", reflect.TypeOf((*MockSSMAPI)(nil).PutParameterRequest), arg0)
}

// PutParameterWithContext mocks base method
func (m *MockSSMAPI) PutParameterWithContext(arg0 context.Context, arg1 *ssm.PutParameterInput, arg2 ...request.Option) (*ssm.PutParameterOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "PutParameterWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.PutParameterOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PutParameterWithContext indicates an expected call of PutParameterWithContext
func (mr *MockSSMAPIMockRecorder) PutParameterWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PutParameterWithContext", reflect.TypeOf((*MockSSMAPI)(nil).PutParameterWithContext), varargs...)
}

// RegisterDefaultPatchBaseline mocks base method
func (m *MockSSMAPI) RegisterDefaultPatchBaseline(arg0 *ssm.RegisterDefaultPatchBaselineInput) (*ssm.RegisterDefaultPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterDefaultPatchBaseline", arg0)
	ret0, _ := ret[0].(*ssm.RegisterDefaultPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterDefaultPatchBaseline indicates an expected call of RegisterDefaultPatchBaseline
func (mr *MockSSMAPIMockRecorder) RegisterDefaultPatchBaseline(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterDefaultPatchBaseline", reflect.TypeOf((*MockSSMAPI)(nil).RegisterDefaultPatchBaseline), arg0)
}

// RegisterDefaultPatchBaselineRequest mocks base method
func (m *MockSSMAPI) RegisterDefaultPatchBaselineRequest(arg0 *ssm.RegisterDefaultPatchBaselineInput) (*request.Request, *ssm.RegisterDefaultPatchBaselineOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterDefaultPatchBaselineRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.RegisterDefaultPatchBaselineOutput)
	return ret0, ret1
}

// RegisterDefaultPatchBaselineRequest indicates an expected call of RegisterDefaultPatchBaselineRequest
func (mr *MockSSMAPIMockRecorder) RegisterDefaultPatchBaselineRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterDefaultPatchBaselineRequest", reflect.TypeOf((*MockSSMAPI)(nil).RegisterDefaultPatchBaselineRequest), arg0)
}

// RegisterDefaultPatchBaselineWithContext mocks base method
func (m *MockSSMAPI) RegisterDefaultPatchBaselineWithContext(arg0 context.Context, arg1 *ssm.RegisterDefaultPatchBaselineInput, arg2 ...request.Option) (*ssm.RegisterDefaultPatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RegisterDefaultPatchBaselineWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.RegisterDefaultPatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterDefaultPatchBaselineWithContext indicates an expected call of RegisterDefaultPatchBaselineWithContext
func (mr *MockSSMAPIMockRecorder) RegisterDefaultPatchBaselineWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterDefaultPatchBaselineWithContext", reflect.TypeOf((*MockSSMAPI)(nil).RegisterDefaultPatchBaselineWithContext), varargs...)
}

// RegisterPatchBaselineForPatchGroup mocks base method
func (m *MockSSMAPI) RegisterPatchBaselineForPatchGroup(arg0 *ssm.RegisterPatchBaselineForPatchGroupInput) (*ssm.RegisterPatchBaselineForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterPatchBaselineForPatchGroup", arg0)
	ret0, _ := ret[0].(*ssm.RegisterPatchBaselineForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterPatchBaselineForPatchGroup indicates an expected call of RegisterPatchBaselineForPatchGroup
func (mr *MockSSMAPIMockRecorder) RegisterPatchBaselineForPatchGroup(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterPatchBaselineForPatchGroup", reflect.TypeOf((*MockSSMAPI)(nil).RegisterPatchBaselineForPatchGroup), arg0)
}

// RegisterPatchBaselineForPatchGroupRequest mocks base method
func (m *MockSSMAPI) RegisterPatchBaselineForPatchGroupRequest(arg0 *ssm.RegisterPatchBaselineForPatchGroupInput) (*request.Request, *ssm.RegisterPatchBaselineForPatchGroupOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterPatchBaselineForPatchGroupRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.RegisterPatchBaselineForPatchGroupOutput)
	return ret0, ret1
}

// RegisterPatchBaselineForPatchGroupRequest indicates an expected call of RegisterPatchBaselineForPatchGroupRequest
func (mr *MockSSMAPIMockRecorder) RegisterPatchBaselineForPatchGroupRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterPatchBaselineForPatchGroupRequest", reflect.TypeOf((*MockSSMAPI)(nil).RegisterPatchBaselineForPatchGroupRequest), arg0)
}

// RegisterPatchBaselineForPatchGroupWithContext mocks base method
func (m *MockSSMAPI) RegisterPatchBaselineForPatchGroupWithContext(arg0 context.Context, arg1 *ssm.RegisterPatchBaselineForPatchGroupInput, arg2 ...request.Option) (*ssm.RegisterPatchBaselineForPatchGroupOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RegisterPatchBaselineForPatchGroupWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.RegisterPatchBaselineForPatchGroupOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterPatchBaselineForPatchGroupWithContext indicates an expected call of RegisterPatchBaselineForPatchGroupWithContext
func (mr *MockSSMAPIMockRecorder) RegisterPatchBaselineForPatchGroupWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterPatchBaselineForPatchGroupWithContext", reflect.TypeOf((*MockSSMAPI)(nil).RegisterPatchBaselineForPatchGroupWithContext), varargs...)
}

// RegisterTargetWithMaintenanceWindow mocks base method
func (m *MockSSMAPI) RegisterTargetWithMaintenanceWindow(arg0 *ssm.RegisterTargetWithMaintenanceWindowInput) (*ssm.RegisterTargetWithMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterTargetWithMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.RegisterTargetWithMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterTargetWithMaintenanceWindow indicates an expected call of RegisterTargetWithMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) RegisterTargetWithMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTargetWithMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).RegisterTargetWithMaintenanceWindow), arg0)
}

// RegisterTargetWithMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) RegisterTargetWithMaintenanceWindowRequest(arg0 *ssm.RegisterTargetWithMaintenanceWindowInput) (*request.Request, *ssm.RegisterTargetWithMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterTargetWithMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.RegisterTargetWithMaintenanceWindowOutput)
	return ret0, ret1
}

// RegisterTargetWithMaintenanceWindowRequest indicates an expected call of RegisterTargetWithMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) RegisterTargetWithMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTargetWithMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).RegisterTargetWithMaintenanceWindowRequest), arg0)
}

// RegisterTargetWithMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) RegisterTargetWithMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.RegisterTargetWithMaintenanceWindowInput, arg2 ...request.Option) (*ssm.RegisterTargetWithMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RegisterTargetWithMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.RegisterTargetWithMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterTargetWithMaintenanceWindowWithContext indicates an expected call of RegisterTargetWithMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) RegisterTargetWithMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTargetWithMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).RegisterTargetWithMaintenanceWindowWithContext), varargs...)
}

// RegisterTaskWithMaintenanceWindow mocks base method
func (m *MockSSMAPI) RegisterTaskWithMaintenanceWindow(arg0 *ssm.RegisterTaskWithMaintenanceWindowInput) (*ssm.RegisterTaskWithMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterTaskWithMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.RegisterTaskWithMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterTaskWithMaintenanceWindow indicates an expected call of RegisterTaskWithMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) RegisterTaskWithMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTaskWithMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).RegisterTaskWithMaintenanceWindow), arg0)
}

// RegisterTaskWithMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) RegisterTaskWithMaintenanceWindowRequest(arg0 *ssm.RegisterTaskWithMaintenanceWindowInput) (*request.Request, *ssm.RegisterTaskWithMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegisterTaskWithMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.RegisterTaskWithMaintenanceWindowOutput)
	return ret0, ret1
}

// RegisterTaskWithMaintenanceWindowRequest indicates an expected call of RegisterTaskWithMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) RegisterTaskWithMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTaskWithMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).RegisterTaskWithMaintenanceWindowRequest), arg0)
}

// RegisterTaskWithMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) RegisterTaskWithMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.RegisterTaskWithMaintenanceWindowInput, arg2 ...request.Option) (*ssm.RegisterTaskWithMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RegisterTaskWithMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.RegisterTaskWithMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RegisterTaskWithMaintenanceWindowWithContext indicates an expected call of RegisterTaskWithMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) RegisterTaskWithMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegisterTaskWithMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).RegisterTaskWithMaintenanceWindowWithContext), varargs...)
}

// RemoveTagsFromResource mocks base method
func (m *MockSSMAPI) RemoveTagsFromResource(arg0 *ssm.RemoveTagsFromResourceInput) (*ssm.RemoveTagsFromResourceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveTagsFromResource", arg0)
	ret0, _ := ret[0].(*ssm.RemoveTagsFromResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveTagsFromResource indicates an expected call of RemoveTagsFromResource
func (mr *MockSSMAPIMockRecorder) RemoveTagsFromResource(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveTagsFromResource", reflect.TypeOf((*MockSSMAPI)(nil).RemoveTagsFromResource), arg0)
}

// RemoveTagsFromResourceRequest mocks base method
func (m *MockSSMAPI) RemoveTagsFromResourceRequest(arg0 *ssm.RemoveTagsFromResourceInput) (*request.Request, *ssm.RemoveTagsFromResourceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveTagsFromResourceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.RemoveTagsFromResourceOutput)
	return ret0, ret1
}

// RemoveTagsFromResourceRequest indicates an expected call of RemoveTagsFromResourceRequest
func (mr *MockSSMAPIMockRecorder) RemoveTagsFromResourceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveTagsFromResourceRequest", reflect.TypeOf((*MockSSMAPI)(nil).RemoveTagsFromResourceRequest), arg0)
}

// RemoveTagsFromResourceWithContext mocks base method
func (m *MockSSMAPI) RemoveTagsFromResourceWithContext(arg0 context.Context, arg1 *ssm.RemoveTagsFromResourceInput, arg2 ...request.Option) (*ssm.RemoveTagsFromResourceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "RemoveTagsFromResourceWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.RemoveTagsFromResourceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveTagsFromResourceWithContext indicates an expected call of RemoveTagsFromResourceWithContext
func (mr *MockSSMAPIMockRecorder) RemoveTagsFromResourceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveTagsFromResourceWithContext", reflect.TypeOf((*MockSSMAPI)(nil).RemoveTagsFromResourceWithContext), varargs...)
}

// ResetServiceSetting mocks base method
func (m *MockSSMAPI) ResetServiceSetting(arg0 *ssm.ResetServiceSettingInput) (*ssm.ResetServiceSettingOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResetServiceSetting", arg0)
	ret0, _ := ret[0].(*ssm.ResetServiceSettingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResetServiceSetting indicates an expected call of ResetServiceSetting
func (mr *MockSSMAPIMockRecorder) ResetServiceSetting(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetServiceSetting", reflect.TypeOf((*MockSSMAPI)(nil).ResetServiceSetting), arg0)
}

// ResetServiceSettingRequest mocks base method
func (m *MockSSMAPI) ResetServiceSettingRequest(arg0 *ssm.ResetServiceSettingInput) (*request.Request, *ssm.ResetServiceSettingOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResetServiceSettingRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ResetServiceSettingOutput)
	return ret0, ret1
}

// ResetServiceSettingRequest indicates an expected call of ResetServiceSettingRequest
func (mr *MockSSMAPIMockRecorder) ResetServiceSettingRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetServiceSettingRequest", reflect.TypeOf((*MockSSMAPI)(nil).ResetServiceSettingRequest), arg0)
}

// ResetServiceSettingWithContext mocks base method
func (m *MockSSMAPI) ResetServiceSettingWithContext(arg0 context.Context, arg1 *ssm.ResetServiceSettingInput, arg2 ...request.Option) (*ssm.ResetServiceSettingOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ResetServiceSettingWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ResetServiceSettingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResetServiceSettingWithContext indicates an expected call of ResetServiceSettingWithContext
func (mr *MockSSMAPIMockRecorder) ResetServiceSettingWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetServiceSettingWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ResetServiceSettingWithContext), varargs...)
}

// ResumeSession mocks base method
func (m *MockSSMAPI) ResumeSession(arg0 *ssm.ResumeSessionInput) (*ssm.ResumeSessionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResumeSession", arg0)
	ret0, _ := ret[0].(*ssm.ResumeSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResumeSession indicates an expected call of ResumeSession
func (mr *MockSSMAPIMockRecorder) ResumeSession(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResumeSession", reflect.TypeOf((*MockSSMAPI)(nil).ResumeSession), arg0)
}

// ResumeSessionRequest mocks base method
func (m *MockSSMAPI) ResumeSessionRequest(arg0 *ssm.ResumeSessionInput) (*request.Request, *ssm.ResumeSessionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResumeSessionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.ResumeSessionOutput)
	return ret0, ret1
}

// ResumeSessionRequest indicates an expected call of ResumeSessionRequest
func (mr *MockSSMAPIMockRecorder) ResumeSessionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResumeSessionRequest", reflect.TypeOf((*MockSSMAPI)(nil).ResumeSessionRequest), arg0)
}

// ResumeSessionWithContext mocks base method
func (m *MockSSMAPI) ResumeSessionWithContext(arg0 context.Context, arg1 *ssm.ResumeSessionInput, arg2 ...request.Option) (*ssm.ResumeSessionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ResumeSessionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.ResumeSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ResumeSessionWithContext indicates an expected call of ResumeSessionWithContext
func (mr *MockSSMAPIMockRecorder) ResumeSessionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResumeSessionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).ResumeSessionWithContext), varargs...)
}

// SendAutomationSignal mocks base method
func (m *MockSSMAPI) SendAutomationSignal(arg0 *ssm.SendAutomationSignalInput) (*ssm.SendAutomationSignalOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SendAutomationSignal", arg0)
	ret0, _ := ret[0].(*ssm.SendAutomationSignalOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendAutomationSignal indicates an expected call of SendAutomationSignal
func (mr *MockSSMAPIMockRecorder) SendAutomationSignal(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendAutomationSignal", reflect.TypeOf((*MockSSMAPI)(nil).SendAutomationSignal), arg0)
}

// SendAutomationSignalRequest mocks base method
func (m *MockSSMAPI) SendAutomationSignalRequest(arg0 *ssm.SendAutomationSignalInput) (*request.Request, *ssm.SendAutomationSignalOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SendAutomationSignalRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.SendAutomationSignalOutput)
	return ret0, ret1
}

// SendAutomationSignalRequest indicates an expected call of SendAutomationSignalRequest
func (mr *MockSSMAPIMockRecorder) SendAutomationSignalRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendAutomationSignalRequest", reflect.TypeOf((*MockSSMAPI)(nil).SendAutomationSignalRequest), arg0)
}

// SendAutomationSignalWithContext mocks base method
func (m *MockSSMAPI) SendAutomationSignalWithContext(arg0 context.Context, arg1 *ssm.SendAutomationSignalInput, arg2 ...request.Option) (*ssm.SendAutomationSignalOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SendAutomationSignalWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.SendAutomationSignalOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendAutomationSignalWithContext indicates an expected call of SendAutomationSignalWithContext
func (mr *MockSSMAPIMockRecorder) SendAutomationSignalWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendAutomationSignalWithContext", reflect.TypeOf((*MockSSMAPI)(nil).SendAutomationSignalWithContext), varargs...)
}

// SendCommand mocks base method
func (m *MockSSMAPI) SendCommand(arg0 *ssm.SendCommandInput) (*ssm.SendCommandOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SendCommand", arg0)
	ret0, _ := ret[0].(*ssm.SendCommandOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendCommand indicates an expected call of SendCommand
func (mr *MockSSMAPIMockRecorder) SendCommand(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendCommand", reflect.TypeOf((*MockSSMAPI)(nil).SendCommand), arg0)
}

// SendCommandRequest mocks base method
func (m *MockSSMAPI) SendCommandRequest(arg0 *ssm.SendCommandInput) (*request.Request, *ssm.SendCommandOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SendCommandRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.SendCommandOutput)
	return ret0, ret1
}

// SendCommandRequest indicates an expected call of SendCommandRequest
func (mr *MockSSMAPIMockRecorder) SendCommandRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendCommandRequest", reflect.TypeOf((*MockSSMAPI)(nil).SendCommandRequest), arg0)
}

// SendCommandWithContext mocks base method
func (m *MockSSMAPI) SendCommandWithContext(arg0 context.Context, arg1 *ssm.SendCommandInput, arg2 ...request.Option) (*ssm.SendCommandOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SendCommandWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.SendCommandOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendCommandWithContext indicates an expected call of SendCommandWithContext
func (mr *MockSSMAPIMockRecorder) SendCommandWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendCommandWithContext", reflect.TypeOf((*MockSSMAPI)(nil).SendCommandWithContext), varargs...)
}

// StartAssociationsOnce mocks base method
func (m *MockSSMAPI) StartAssociationsOnce(arg0 *ssm.StartAssociationsOnceInput) (*ssm.StartAssociationsOnceOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartAssociationsOnce", arg0)
	ret0, _ := ret[0].(*ssm.StartAssociationsOnceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartAssociationsOnce indicates an expected call of StartAssociationsOnce
func (mr *MockSSMAPIMockRecorder) StartAssociationsOnce(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartAssociationsOnce", reflect.TypeOf((*MockSSMAPI)(nil).StartAssociationsOnce), arg0)
}

// StartAssociationsOnceRequest mocks base method
func (m *MockSSMAPI) StartAssociationsOnceRequest(arg0 *ssm.StartAssociationsOnceInput) (*request.Request, *ssm.StartAssociationsOnceOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartAssociationsOnceRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.StartAssociationsOnceOutput)
	return ret0, ret1
}

// StartAssociationsOnceRequest indicates an expected call of StartAssociationsOnceRequest
func (mr *MockSSMAPIMockRecorder) StartAssociationsOnceRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartAssociationsOnceRequest", reflect.TypeOf((*MockSSMAPI)(nil).StartAssociationsOnceRequest), arg0)
}

// StartAssociationsOnceWithContext mocks base method
func (m *MockSSMAPI) StartAssociationsOnceWithContext(arg0 context.Context, arg1 *ssm.StartAssociationsOnceInput, arg2 ...request.Option) (*ssm.StartAssociationsOnceOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartAssociationsOnceWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.StartAssociationsOnceOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartAssociationsOnceWithContext indicates an expected call of StartAssociationsOnceWithContext
func (mr *MockSSMAPIMockRecorder) StartAssociationsOnceWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartAssociationsOnceWithContext", reflect.TypeOf((*MockSSMAPI)(nil).StartAssociationsOnceWithContext), varargs...)
}

// StartAutomationExecution mocks base method
func (m *MockSSMAPI) StartAutomationExecution(arg0 *ssm.StartAutomationExecutionInput) (*ssm.StartAutomationExecutionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartAutomationExecution", arg0)
	ret0, _ := ret[0].(*ssm.StartAutomationExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartAutomationExecution indicates an expected call of StartAutomationExecution
func (mr *MockSSMAPIMockRecorder) StartAutomationExecution(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartAutomationExecution", reflect.TypeOf((*MockSSMAPI)(nil).StartAutomationExecution), arg0)
}

// StartAutomationExecutionRequest mocks base method
func (m *MockSSMAPI) StartAutomationExecutionRequest(arg0 *ssm.StartAutomationExecutionInput) (*request.Request, *ssm.StartAutomationExecutionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartAutomationExecutionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.StartAutomationExecutionOutput)
	return ret0, ret1
}

// StartAutomationExecutionRequest indicates an expected call of StartAutomationExecutionRequest
func (mr *MockSSMAPIMockRecorder) StartAutomationExecutionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartAutomationExecutionRequest", reflect.TypeOf((*MockSSMAPI)(nil).StartAutomationExecutionRequest), arg0)
}

// StartAutomationExecutionWithContext mocks base method
func (m *MockSSMAPI) StartAutomationExecutionWithContext(arg0 context.Context, arg1 *ssm.StartAutomationExecutionInput, arg2 ...request.Option) (*ssm.StartAutomationExecutionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartAutomationExecutionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.StartAutomationExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartAutomationExecutionWithContext indicates an expected call of StartAutomationExecutionWithContext
func (mr *MockSSMAPIMockRecorder) StartAutomationExecutionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartAutomationExecutionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).StartAutomationExecutionWithContext), varargs...)
}

// StartSession mocks base method
func (m *MockSSMAPI) StartSession(arg0 *ssm.StartSessionInput) (*ssm.StartSessionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartSession", arg0)
	ret0, _ := ret[0].(*ssm.StartSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartSession indicates an expected call of StartSession
func (mr *MockSSMAPIMockRecorder) StartSession(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartSession", reflect.TypeOf((*MockSSMAPI)(nil).StartSession), arg0)
}

// StartSessionRequest mocks base method
func (m *MockSSMAPI) StartSessionRequest(arg0 *ssm.StartSessionInput) (*request.Request, *ssm.StartSessionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StartSessionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.StartSessionOutput)
	return ret0, ret1
}

// StartSessionRequest indicates an expected call of StartSessionRequest
func (mr *MockSSMAPIMockRecorder) StartSessionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartSessionRequest", reflect.TypeOf((*MockSSMAPI)(nil).StartSessionRequest), arg0)
}

// StartSessionWithContext mocks base method
func (m *MockSSMAPI) StartSessionWithContext(arg0 context.Context, arg1 *ssm.StartSessionInput, arg2 ...request.Option) (*ssm.StartSessionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StartSessionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.StartSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StartSessionWithContext indicates an expected call of StartSessionWithContext
func (mr *MockSSMAPIMockRecorder) StartSessionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StartSessionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).StartSessionWithContext), varargs...)
}

// StopAutomationExecution mocks base method
func (m *MockSSMAPI) StopAutomationExecution(arg0 *ssm.StopAutomationExecutionInput) (*ssm.StopAutomationExecutionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StopAutomationExecution", arg0)
	ret0, _ := ret[0].(*ssm.StopAutomationExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StopAutomationExecution indicates an expected call of StopAutomationExecution
func (mr *MockSSMAPIMockRecorder) StopAutomationExecution(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StopAutomationExecution", reflect.TypeOf((*MockSSMAPI)(nil).StopAutomationExecution), arg0)
}

// StopAutomationExecutionRequest mocks base method
func (m *MockSSMAPI) StopAutomationExecutionRequest(arg0 *ssm.StopAutomationExecutionInput) (*request.Request, *ssm.StopAutomationExecutionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StopAutomationExecutionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.StopAutomationExecutionOutput)
	return ret0, ret1
}

// StopAutomationExecutionRequest indicates an expected call of StopAutomationExecutionRequest
func (mr *MockSSMAPIMockRecorder) StopAutomationExecutionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StopAutomationExecutionRequest", reflect.TypeOf((*MockSSMAPI)(nil).StopAutomationExecutionRequest), arg0)
}

// StopAutomationExecutionWithContext mocks base method
func (m *MockSSMAPI) StopAutomationExecutionWithContext(arg0 context.Context, arg1 *ssm.StopAutomationExecutionInput, arg2 ...request.Option) (*ssm.StopAutomationExecutionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "StopAutomationExecutionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.StopAutomationExecutionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// StopAutomationExecutionWithContext indicates an expected call of StopAutomationExecutionWithContext
func (mr *MockSSMAPIMockRecorder) StopAutomationExecutionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StopAutomationExecutionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).StopAutomationExecutionWithContext), varargs...)
}

// TerminateSession mocks base method
func (m *MockSSMAPI) TerminateSession(arg0 *ssm.TerminateSessionInput) (*ssm.TerminateSessionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TerminateSession", arg0)
	ret0, _ := ret[0].(*ssm.TerminateSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TerminateSession indicates an expected call of TerminateSession
func (mr *MockSSMAPIMockRecorder) TerminateSession(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TerminateSession", reflect.TypeOf((*MockSSMAPI)(nil).TerminateSession), arg0)
}

// TerminateSessionRequest mocks base method
func (m *MockSSMAPI) TerminateSessionRequest(arg0 *ssm.TerminateSessionInput) (*request.Request, *ssm.TerminateSessionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TerminateSessionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.TerminateSessionOutput)
	return ret0, ret1
}

// TerminateSessionRequest indicates an expected call of TerminateSessionRequest
func (mr *MockSSMAPIMockRecorder) TerminateSessionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TerminateSessionRequest", reflect.TypeOf((*MockSSMAPI)(nil).TerminateSessionRequest), arg0)
}

// TerminateSessionWithContext mocks base method
func (m *MockSSMAPI) TerminateSessionWithContext(arg0 context.Context, arg1 *ssm.TerminateSessionInput, arg2 ...request.Option) (*ssm.TerminateSessionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "TerminateSessionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.TerminateSessionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TerminateSessionWithContext indicates an expected call of TerminateSessionWithContext
func (mr *MockSSMAPIMockRecorder) TerminateSessionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TerminateSessionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).TerminateSessionWithContext), varargs...)
}

// UpdateAssociation mocks base method
func (m *MockSSMAPI) UpdateAssociation(arg0 *ssm.UpdateAssociationInput) (*ssm.UpdateAssociationOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssociation", arg0)
	ret0, _ := ret[0].(*ssm.UpdateAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateAssociation indicates an expected call of UpdateAssociation
func (mr *MockSSMAPIMockRecorder) UpdateAssociation(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssociation", reflect.TypeOf((*MockSSMAPI)(nil).UpdateAssociation), arg0)
}

// UpdateAssociationRequest mocks base method
func (m *MockSSMAPI) UpdateAssociationRequest(arg0 *ssm.UpdateAssociationInput) (*request.Request, *ssm.UpdateAssociationOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssociationRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateAssociationOutput)
	return ret0, ret1
}

// UpdateAssociationRequest indicates an expected call of UpdateAssociationRequest
func (mr *MockSSMAPIMockRecorder) UpdateAssociationRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssociationRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateAssociationRequest), arg0)
}

// UpdateAssociationStatus mocks base method
func (m *MockSSMAPI) UpdateAssociationStatus(arg0 *ssm.UpdateAssociationStatusInput) (*ssm.UpdateAssociationStatusOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssociationStatus", arg0)
	ret0, _ := ret[0].(*ssm.UpdateAssociationStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateAssociationStatus indicates an expected call of UpdateAssociationStatus
func (mr *MockSSMAPIMockRecorder) UpdateAssociationStatus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssociationStatus", reflect.TypeOf((*MockSSMAPI)(nil).UpdateAssociationStatus), arg0)
}

// UpdateAssociationStatusRequest mocks base method
func (m *MockSSMAPI) UpdateAssociationStatusRequest(arg0 *ssm.UpdateAssociationStatusInput) (*request.Request, *ssm.UpdateAssociationStatusOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateAssociationStatusRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateAssociationStatusOutput)
	return ret0, ret1
}

// UpdateAssociationStatusRequest indicates an expected call of UpdateAssociationStatusRequest
func (mr *MockSSMAPIMockRecorder) UpdateAssociationStatusRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssociationStatusRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateAssociationStatusRequest), arg0)
}

// UpdateAssociationStatusWithContext mocks base method
func (m *MockSSMAPI) UpdateAssociationStatusWithContext(arg0 context.Context, arg1 *ssm.UpdateAssociationStatusInput, arg2 ...request.Option) (*ssm.UpdateAssociationStatusOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateAssociationStatusWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateAssociationStatusOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateAssociationStatusWithContext indicates an expected call of UpdateAssociationStatusWithContext
func (mr *MockSSMAPIMockRecorder) UpdateAssociationStatusWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssociationStatusWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateAssociationStatusWithContext), varargs...)
}

// UpdateAssociationWithContext mocks base method
func (m *MockSSMAPI) UpdateAssociationWithContext(arg0 context.Context, arg1 *ssm.UpdateAssociationInput, arg2 ...request.Option) (*ssm.UpdateAssociationOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateAssociationWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateAssociationOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateAssociationWithContext indicates an expected call of UpdateAssociationWithContext
func (mr *MockSSMAPIMockRecorder) UpdateAssociationWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateAssociationWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateAssociationWithContext), varargs...)
}

// UpdateDocument mocks base method
func (m *MockSSMAPI) UpdateDocument(arg0 *ssm.UpdateDocumentInput) (*ssm.UpdateDocumentOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateDocument", arg0)
	ret0, _ := ret[0].(*ssm.UpdateDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateDocument indicates an expected call of UpdateDocument
func (mr *MockSSMAPIMockRecorder) UpdateDocument(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDocument", reflect.TypeOf((*MockSSMAPI)(nil).UpdateDocument), arg0)
}

// UpdateDocumentDefaultVersion mocks base method
func (m *MockSSMAPI) UpdateDocumentDefaultVersion(arg0 *ssm.UpdateDocumentDefaultVersionInput) (*ssm.UpdateDocumentDefaultVersionOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateDocumentDefaultVersion", arg0)
	ret0, _ := ret[0].(*ssm.UpdateDocumentDefaultVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateDocumentDefaultVersion indicates an expected call of UpdateDocumentDefaultVersion
func (mr *MockSSMAPIMockRecorder) UpdateDocumentDefaultVersion(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDocumentDefaultVersion", reflect.TypeOf((*MockSSMAPI)(nil).UpdateDocumentDefaultVersion), arg0)
}

// UpdateDocumentDefaultVersionRequest mocks base method
func (m *MockSSMAPI) UpdateDocumentDefaultVersionRequest(arg0 *ssm.UpdateDocumentDefaultVersionInput) (*request.Request, *ssm.UpdateDocumentDefaultVersionOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateDocumentDefaultVersionRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateDocumentDefaultVersionOutput)
	return ret0, ret1
}

// UpdateDocumentDefaultVersionRequest indicates an expected call of UpdateDocumentDefaultVersionRequest
func (mr *MockSSMAPIMockRecorder) UpdateDocumentDefaultVersionRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDocumentDefaultVersionRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateDocumentDefaultVersionRequest), arg0)
}

// UpdateDocumentDefaultVersionWithContext mocks base method
func (m *MockSSMAPI) UpdateDocumentDefaultVersionWithContext(arg0 context.Context, arg1 *ssm.UpdateDocumentDefaultVersionInput, arg2 ...request.Option) (*ssm.UpdateDocumentDefaultVersionOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateDocumentDefaultVersionWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateDocumentDefaultVersionOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateDocumentDefaultVersionWithContext indicates an expected call of UpdateDocumentDefaultVersionWithContext
func (mr *MockSSMAPIMockRecorder) UpdateDocumentDefaultVersionWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDocumentDefaultVersionWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateDocumentDefaultVersionWithContext), varargs...)
}

// UpdateDocumentRequest mocks base method
func (m *MockSSMAPI) UpdateDocumentRequest(arg0 *ssm.UpdateDocumentInput) (*request.Request, *ssm.UpdateDocumentOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateDocumentRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateDocumentOutput)
	return ret0, ret1
}

// UpdateDocumentRequest indicates an expected call of UpdateDocumentRequest
func (mr *MockSSMAPIMockRecorder) UpdateDocumentRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDocumentRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateDocumentRequest), arg0)
}

// UpdateDocumentWithContext mocks base method
func (m *MockSSMAPI) UpdateDocumentWithContext(arg0 context.Context, arg1 *ssm.UpdateDocumentInput, arg2 ...request.Option) (*ssm.UpdateDocumentOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateDocumentWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateDocumentOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateDocumentWithContext indicates an expected call of UpdateDocumentWithContext
func (mr *MockSSMAPIMockRecorder) UpdateDocumentWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateDocumentWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateDocumentWithContext), varargs...)
}

// UpdateMaintenanceWindow mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindow(arg0 *ssm.UpdateMaintenanceWindowInput) (*ssm.UpdateMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindow", arg0)
	ret0, _ := ret[0].(*ssm.UpdateMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateMaintenanceWindow indicates an expected call of UpdateMaintenanceWindow
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindow(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindow", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindow), arg0)
}

// UpdateMaintenanceWindowRequest mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowRequest(arg0 *ssm.UpdateMaintenanceWindowInput) (*request.Request, *ssm.UpdateMaintenanceWindowOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateMaintenanceWindowOutput)
	return ret0, ret1
}

// UpdateMaintenanceWindowRequest indicates an expected call of UpdateMaintenanceWindowRequest
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowRequest), arg0)
}

// UpdateMaintenanceWindowTarget mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowTarget(arg0 *ssm.UpdateMaintenanceWindowTargetInput) (*ssm.UpdateMaintenanceWindowTargetOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowTarget", arg0)
	ret0, _ := ret[0].(*ssm.UpdateMaintenanceWindowTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateMaintenanceWindowTarget indicates an expected call of UpdateMaintenanceWindowTarget
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowTarget(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowTarget", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowTarget), arg0)
}

// UpdateMaintenanceWindowTargetRequest mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowTargetRequest(arg0 *ssm.UpdateMaintenanceWindowTargetInput) (*request.Request, *ssm.UpdateMaintenanceWindowTargetOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowTargetRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateMaintenanceWindowTargetOutput)
	return ret0, ret1
}

// UpdateMaintenanceWindowTargetRequest indicates an expected call of UpdateMaintenanceWindowTargetRequest
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowTargetRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowTargetRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowTargetRequest), arg0)
}

// UpdateMaintenanceWindowTargetWithContext mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowTargetWithContext(arg0 context.Context, arg1 *ssm.UpdateMaintenanceWindowTargetInput, arg2 ...request.Option) (*ssm.UpdateMaintenanceWindowTargetOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowTargetWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateMaintenanceWindowTargetOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateMaintenanceWindowTargetWithContext indicates an expected call of UpdateMaintenanceWindowTargetWithContext
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowTargetWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowTargetWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowTargetWithContext), varargs...)
}

// UpdateMaintenanceWindowTask mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowTask(arg0 *ssm.UpdateMaintenanceWindowTaskInput) (*ssm.UpdateMaintenanceWindowTaskOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowTask", arg0)
	ret0, _ := ret[0].(*ssm.UpdateMaintenanceWindowTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateMaintenanceWindowTask indicates an expected call of UpdateMaintenanceWindowTask
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowTask(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowTask", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowTask), arg0)
}

// UpdateMaintenanceWindowTaskRequest mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowTaskRequest(arg0 *ssm.UpdateMaintenanceWindowTaskInput) (*request.Request, *ssm.UpdateMaintenanceWindowTaskOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowTaskRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateMaintenanceWindowTaskOutput)
	return ret0, ret1
}

// UpdateMaintenanceWindowTaskRequest indicates an expected call of UpdateMaintenanceWindowTaskRequest
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowTaskRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowTaskRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowTaskRequest), arg0)
}

// UpdateMaintenanceWindowTaskWithContext mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowTaskWithContext(arg0 context.Context, arg1 *ssm.UpdateMaintenanceWindowTaskInput, arg2 ...request.Option) (*ssm.UpdateMaintenanceWindowTaskOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowTaskWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateMaintenanceWindowTaskOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateMaintenanceWindowTaskWithContext indicates an expected call of UpdateMaintenanceWindowTaskWithContext
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowTaskWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowTaskWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowTaskWithContext), varargs...)
}

// UpdateMaintenanceWindowWithContext mocks base method
func (m *MockSSMAPI) UpdateMaintenanceWindowWithContext(arg0 context.Context, arg1 *ssm.UpdateMaintenanceWindowInput, arg2 ...request.Option) (*ssm.UpdateMaintenanceWindowOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateMaintenanceWindowWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateMaintenanceWindowOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateMaintenanceWindowWithContext indicates an expected call of UpdateMaintenanceWindowWithContext
func (mr *MockSSMAPIMockRecorder) UpdateMaintenanceWindowWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateMaintenanceWindowWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateMaintenanceWindowWithContext), varargs...)
}

// UpdateManagedInstanceRole mocks base method
func (m *MockSSMAPI) UpdateManagedInstanceRole(arg0 *ssm.UpdateManagedInstanceRoleInput) (*ssm.UpdateManagedInstanceRoleOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateManagedInstanceRole", arg0)
	ret0, _ := ret[0].(*ssm.UpdateManagedInstanceRoleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateManagedInstanceRole indicates an expected call of UpdateManagedInstanceRole
func (mr *MockSSMAPIMockRecorder) UpdateManagedInstanceRole(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateManagedInstanceRole", reflect.TypeOf((*MockSSMAPI)(nil).UpdateManagedInstanceRole), arg0)
}

// UpdateManagedInstanceRoleRequest mocks base method
func (m *MockSSMAPI) UpdateManagedInstanceRoleRequest(arg0 *ssm.UpdateManagedInstanceRoleInput) (*request.Request, *ssm.UpdateManagedInstanceRoleOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateManagedInstanceRoleRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateManagedInstanceRoleOutput)
	return ret0, ret1
}

// UpdateManagedInstanceRoleRequest indicates an expected call of UpdateManagedInstanceRoleRequest
func (mr *MockSSMAPIMockRecorder) UpdateManagedInstanceRoleRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateManagedInstanceRoleRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateManagedInstanceRoleRequest), arg0)
}

// UpdateManagedInstanceRoleWithContext mocks base method
func (m *MockSSMAPI) UpdateManagedInstanceRoleWithContext(arg0 context.Context, arg1 *ssm.UpdateManagedInstanceRoleInput, arg2 ...request.Option) (*ssm.UpdateManagedInstanceRoleOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateManagedInstanceRoleWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateManagedInstanceRoleOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateManagedInstanceRoleWithContext indicates an expected call of UpdateManagedInstanceRoleWithContext
func (mr *MockSSMAPIMockRecorder) UpdateManagedInstanceRoleWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateManagedInstanceRoleWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateManagedInstanceRoleWithContext), varargs...)
}

// UpdateOpsItem mocks base method
func (m *MockSSMAPI) UpdateOpsItem(arg0 *ssm.UpdateOpsItemInput) (*ssm.UpdateOpsItemOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateOpsItem", arg0)
	ret0, _ := ret[0].(*ssm.UpdateOpsItemOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateOpsItem indicates an expected call of UpdateOpsItem
func (mr *MockSSMAPIMockRecorder) UpdateOpsItem(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateOpsItem", reflect.TypeOf((*MockSSMAPI)(nil).UpdateOpsItem), arg0)
}

// UpdateOpsItemRequest mocks base method
func (m *MockSSMAPI) UpdateOpsItemRequest(arg0 *ssm.UpdateOpsItemInput) (*request.Request, *ssm.UpdateOpsItemOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateOpsItemRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateOpsItemOutput)
	return ret0, ret1
}

// UpdateOpsItemRequest indicates an expected call of UpdateOpsItemRequest
func (mr *MockSSMAPIMockRecorder) UpdateOpsItemRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateOpsItemRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateOpsItemRequest), arg0)
}

// UpdateOpsItemWithContext mocks base method
func (m *MockSSMAPI) UpdateOpsItemWithContext(arg0 context.Context, arg1 *ssm.UpdateOpsItemInput, arg2 ...request.Option) (*ssm.UpdateOpsItemOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateOpsItemWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateOpsItemOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateOpsItemWithContext indicates an expected call of UpdateOpsItemWithContext
func (mr *MockSSMAPIMockRecorder) UpdateOpsItemWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateOpsItemWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateOpsItemWithContext), varargs...)
}

// UpdatePatchBaseline mocks base method
func (m *MockSSMAPI) UpdatePatchBaseline(arg0 *ssm.UpdatePatchBaselineInput) (*ssm.UpdatePatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdatePatchBaseline", arg0)
	ret0, _ := ret[0].(*ssm.UpdatePatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdatePatchBaseline indicates an expected call of UpdatePatchBaseline
func (mr *MockSSMAPIMockRecorder) UpdatePatchBaseline(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdatePatchBaseline", reflect.TypeOf((*MockSSMAPI)(nil).UpdatePatchBaseline), arg0)
}

// UpdatePatchBaselineRequest mocks base method
func (m *MockSSMAPI) UpdatePatchBaselineRequest(arg0 *ssm.UpdatePatchBaselineInput) (*request.Request, *ssm.UpdatePatchBaselineOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdatePatchBaselineRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdatePatchBaselineOutput)
	return ret0, ret1
}

// UpdatePatchBaselineRequest indicates an expected call of UpdatePatchBaselineRequest
func (mr *MockSSMAPIMockRecorder) UpdatePatchBaselineRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdatePatchBaselineRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdatePatchBaselineRequest), arg0)
}

// UpdatePatchBaselineWithContext mocks base method
func (m *MockSSMAPI) UpdatePatchBaselineWithContext(arg0 context.Context, arg1 *ssm.UpdatePatchBaselineInput, arg2 ...request.Option) (*ssm.UpdatePatchBaselineOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdatePatchBaselineWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdatePatchBaselineOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdatePatchBaselineWithContext indicates an expected call of UpdatePatchBaselineWithContext
func (mr *MockSSMAPIMockRecorder) UpdatePatchBaselineWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdatePatchBaselineWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdatePatchBaselineWithContext), varargs...)
}

// UpdateResourceDataSync mocks base method
func (m *MockSSMAPI) UpdateResourceDataSync(arg0 *ssm.UpdateResourceDataSyncInput) (*ssm.UpdateResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateResourceDataSync", arg0)
	ret0, _ := ret[0].(*ssm.UpdateResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateResourceDataSync indicates an expected call of UpdateResourceDataSync
func (mr *MockSSMAPIMockRecorder) UpdateResourceDataSync(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateResourceDataSync", reflect.TypeOf((*MockSSMAPI)(nil).UpdateResourceDataSync), arg0)
}

// UpdateResourceDataSyncRequest mocks base method
func (m *MockSSMAPI) UpdateResourceDataSyncRequest(arg0 *ssm.UpdateResourceDataSyncInput) (*request.Request, *ssm.UpdateResourceDataSyncOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateResourceDataSyncRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateResourceDataSyncOutput)
	return ret0, ret1
}

// UpdateResourceDataSyncRequest indicates an expected call of UpdateResourceDataSyncRequest
func (mr *MockSSMAPIMockRecorder) UpdateResourceDataSyncRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateResourceDataSyncRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateResourceDataSyncRequest), arg0)
}

// UpdateResourceDataSyncWithContext mocks base method
func (m *MockSSMAPI) UpdateResourceDataSyncWithContext(arg0 context.Context, arg1 *ssm.UpdateResourceDataSyncInput, arg2 ...request.Option) (*ssm.UpdateResourceDataSyncOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateResourceDataSyncWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateResourceDataSyncOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateResourceDataSyncWithContext indicates an expected call of UpdateResourceDataSyncWithContext
func (mr *MockSSMAPIMockRecorder) UpdateResourceDataSyncWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateResourceDataSyncWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateResourceDataSyncWithContext), varargs...)
}

// UpdateServiceSetting mocks base method
func (m *MockSSMAPI) UpdateServiceSetting(arg0 *ssm.UpdateServiceSettingInput) (*ssm.UpdateServiceSettingOutput, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateServiceSetting", arg0)
	ret0, _ := ret[0].(*ssm.UpdateServiceSettingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateServiceSetting indicates an expected call of UpdateServiceSetting
func (mr *MockSSMAPIMockRecorder) UpdateServiceSetting(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateServiceSetting", reflect.TypeOf((*MockSSMAPI)(nil).UpdateServiceSetting), arg0)
}

// UpdateServiceSettingRequest mocks base method
func (m *MockSSMAPI) UpdateServiceSettingRequest(arg0 *ssm.UpdateServiceSettingInput) (*request.Request, *ssm.UpdateServiceSettingOutput) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateServiceSettingRequest", arg0)
	ret0, _ := ret[0].(*request.Request)
	ret1, _ := ret[1].(*ssm.UpdateServiceSettingOutput)
	return ret0, ret1
}

// UpdateServiceSettingRequest indicates an expected call of UpdateServiceSettingRequest
func (mr *MockSSMAPIMockRecorder) UpdateServiceSettingRequest(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateServiceSettingRequest", reflect.TypeOf((*MockSSMAPI)(nil).UpdateServiceSettingRequest), arg0)
}

// UpdateServiceSettingWithContext mocks base method
func (m *MockSSMAPI) UpdateServiceSettingWithContext(arg0 context.Context, arg1 *ssm.UpdateServiceSettingInput, arg2 ...request.Option) (*ssm.UpdateServiceSettingOutput, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{arg0, arg1}
	for _, a := range arg2 {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "UpdateServiceSettingWithContext", varargs...)
	ret0, _ := ret[0].(*ssm.UpdateServiceSettingOutput)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateServiceSettingWithContext indicates an expected call of UpdateServiceSettingWithContext
func (mr *MockSSMAPIMockRecorder) UpdateServiceSettingWithContext(arg0, arg1 interface{}, arg2 ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{arg0, arg1}, arg2...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateServiceSettingWithContext", reflect.TypeOf((*MockSSMAPI)(nil).UpdateServiceSettingWithContext), varargs...)
}
